package com.geoway.landteam.landcloud.service.formatConversion;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.*;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yecongwang on 2020/7/13.
 */
public class Txt2ShpService {
    private String rootPath=null;
    public Txt2ShpService(String downloadPath){
        this.rootPath = downloadPath;
    }

    /**
     * 开始转换
     * @param mulFile
     * @return
     */
    public String startExchange(MultipartFile mulFile){
        Map<String,Object> allShapeData = null;
        String path = this.rootPath+"txt2shp";
        File txtFile = MulFileUtil.getFileFromMultipartFile(mulFile,".txt",path);
        allShapeData = readTxtFile(txtFile);
        if(allShapeData == null){
            return null;
        }
        String filename = mulFile.getOriginalFilename();
        allShapeData.put("fileName",filename);
        allShapeData.put("folderName",txtFile.getName());
        return createShp(allShapeData);
    }

    /**
     * 处理所有从txt当中获取的信息，生成shp文件
     * @param allShapeData
     * @return
     */
    public  String createShp(Map<String,Object> allShapeData){
        ArrayList<Map<String,String>> attrsMapList = (ArrayList<Map<String, String>>) allShapeData.get("feature");
        Integer SRID = (Integer) allShapeData.get("crsId");
//        Geometry geometry = (Geometry) allShapeData.get("geometry");
        List<Geometry> geometryList  = (List<Geometry>) allShapeData.get("geometryList");
        Map<String,String> headData = (Map<String, String>) allShapeData.get("headData");
        //建立坐标系
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        try {
            tb.setCRS(CRS.decode("EPSG:"+SRID));
        } catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
        } catch (FactoryException e) {
            e.printStackTrace();
        }
        tb.setName("shapefile");
        tb.add("the_geom", MultiPolygon.class);
        tb.setDefaultGeometry("the_geom");
        for(Map.Entry<String,String> attr:attrsMapList.get(0).entrySet()) {
            tb.add(attr.getKey(), String.class);
        }
        for(Map.Entry<String,String> head:headData.entrySet()) {
            tb.add(head.getKey(), String.class);
        }
        //创建shp文件
        String path = this.rootPath+"txt2shp\\shp";
        String folderName = (String) allShapeData.get("folderName");
        String fileName = (String) allShapeData.get("fileName");
        folderName = folderName.substring(0,folderName.indexOf("."));
        fileName = fileName.substring(0,fileName.indexOf("."));
        File dir = new File(path);
        if(!dir.exists()){
            dir.mkdirs();
        }
        File shapeFileFolder = null;
        ShapefileDataStore ds = null;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = null;
        String shapefileFolderPath = dir.getAbsolutePath() + File.separator + fileName;
        try {

            shapeFileFolder = new File(shapefileFolderPath);
            if (!shapeFileFolder.exists()) {
                shapeFileFolder.mkdirs();
            }
            String shapeFilePath = shapefileFolderPath + File.separator + fileName + ".shp";
            File file = new File(shapeFilePath);
            file.createNewFile();

            //创建文件成功后，将shp属性内容写入文件
            Map<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());

            ds = (ShapefileDataStore) new ShapefileDataStoreFactory().createNewDataStore(params);
            SimpleFeatureType sft = tb.buildFeatureType();

            ds.createSchema(sft);
            ds.setCharset(Charset.forName("GBK"));
            String typeName = ds.getTypeNames()[0];
            writer = ds.getFeatureWriter(typeName, Transaction.AUTO_COMMIT);
            SimpleFeature feature;
            for(int i=0;i<attrsMapList.size();i++){
                feature = writer.next();
                feature.setAttribute("the_geom", geometryList.get(i));
                for(Map.Entry<String,String> attr:attrsMapList.get(i).entrySet()){
                    if("ZMJ".equals(attr.getKey())){
                        feature.setAttribute(attr.getKey(),Double.parseDouble(String.format("%.4f",geometryList.get(i).getArea()/10000)));
                    }else {
                        feature.setAttribute(attr.getKey(),attr.getValue());
                    }
                }
                for(Map.Entry<String,String> head:headData.entrySet()) {
                    feature.setAttribute(head.getKey(),head.getValue());
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            return shapefileFolderPath;
        } catch (Exception e) {
            //创建文件夹后代码若出现异常删掉文件夹
            if (shapeFileFolder.exists()) {
                shapeFileFolder.delete();
            }
            return null;
        } finally {
            try {
                writer.close();
                ds.dispose();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 读取txt，获取shp文件的属性描述、地块坐标、geometry
     * @param file
     * @return
     */
    public static Map<String,Object> readTxtFile(File file) {
        Geometry geometry = null;
        List<Geometry> geometryList = new ArrayList<>();
        JSONArray points = new JSONArray();
        Map<String,String> crsAttrs = new HashMap<>();
        List<Map<String,String>> feature = new ArrayList<>();
        Map<String,Object> allShapeData = new HashMap<>();
        Map<String,String> headData = new HashMap<>();
        /* 读取数据 */
        try {
            String encoding = MulFileUtil.getFileCharSet(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file), encoding));
            String lineTxt = null;
            int i = -1;
            int j = 0;
            boolean flag = false;//是否开始记录点数据
            while ((lineTxt = br.readLine()) != null) {//数据以逗号分隔
                if(!flag&& lineTxt.contains("=")){
                    switch (lineTxt.split("=")[0]){
                        case "坐标系":crsAttrs.put("坐标系",lineTxt.split("=")[1]);break;
                        case "几度分带":crsAttrs.put("几度分带",lineTxt.split("=")[1]);break;
                        case "带号":crsAttrs.put("带号",lineTxt.split("=")[1]);break;
                        case "格式版本号":headData.put("GSBB",lineTxt.split("=")[1]);break;
                        case "数据产生单位":headData.put("SJCSDW",lineTxt.split("=")[1]);break;
                        case "数据产生日期":headData.put("SJCSRQ",lineTxt.split("=")[1]);break;
                        default:break;
                    }

                }
                if (flag && !lineTxt.contains("@")) {
                    Point point = createPoint(Double.parseDouble(lineTxt.split(",")[2]), Double.parseDouble(lineTxt.split(",")[3]));
                    Double[] arr = new Double[]{point.getY(), point.getX()};
                    Map<String,Object> tem = new HashMap<String,Object>();
                    tem.put("point",arr);
                    tem.put("region",lineTxt.split(",")[1]);
              /*      points.getJSONArray(i).getJSONArray(j).put(tem);*/
                    points.getJSONArray(i).getJSONArray(j).add(tem);
                }
                if (lineTxt.contains("@")) {
                    i++;
                    Map<String,String> shapeAttrs = new HashMap<>();
                    String[] attrs = lineTxt.split(",");
                    shapeAttrs.put("JZDSL",attrs[0]);
                    shapeAttrs.put("ZMJ",attrs[1]);
                    shapeAttrs.put("DKMC",attrs[2]);
                    shapeAttrs.put("XMMC",attrs[3]);
                    shapeAttrs.put("LX",attrs[4]);
                    shapeAttrs.put("SJTFH",attrs[5]);
                    shapeAttrs.put("DLMC",attrs[6]);
                    //feature.add(shapeAttrs);
                    if(i>0){
                        Map<String,String> previous = feature.get(i-1);
                        String pjl = previous.remove("JZDSL");
                        String sjl = shapeAttrs.remove("JZDSL");
                        if(previous.equals(shapeAttrs)){
                            try {
                                int pAddS = Integer.parseInt(pjl) + Integer.parseInt(sjl);
                                previous.put("JZDSL",pAddS+"");
                                feature.set(i-1,previous);
                               /* points.getJSONArray(i-1).put(new JSONArray());*/
                                points.getJSONArray(i-1).add(new JSONArray());
                                i--;
                                j++;
                            }catch (Exception e){
                              e.printStackTrace();
                            }

                        }else {
                            previous.put("JZDSL",pjl);
                            shapeAttrs.put("JZDSL",sjl);
                            feature.add(shapeAttrs);
                            JSONArray ja = new JSONArray();
                            ja.add(new JSONArray());
                            points.add(ja);
                            j=0;
                        }
                    }else {
                        feature.add(shapeAttrs);
                        JSONArray ja = new JSONArray();
                        ja.add(new JSONArray());
                        points.add(ja);
                        j=0;
                    }
                    flag = true;
                }
            }
            br.close();
            List<String> wktList = getWktList(points);
            Integer crsId = StrUtil.getCrsId(crsAttrs);
            if(crsId == null){
                return null;
            }
            for(String wkt:wktList){
                geometry = StrUtil.wktToGeometry(wkt,crsId);
                geometryList.add(geometry);
            }
            allShapeData.put("crsId",crsId);
            allShapeData.put("geometryList",geometryList);
            allShapeData.put("feature",feature);
            allShapeData.put("headData",headData);
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            FileUtil.deleteFileAndDir(file.getParentFile());
        }
        return  allShapeData;
    }


    public static Point createPoint(double longitude, double latitude) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate coord = new Coordinate(longitude, latitude);
        Point point = gf.createPoint(coord);
        return point;
    }


    /**
     * 获取wkt的list
     * @param points 存放坐标点的json数组
     * @return
     */
    private static List<String> getWktList(JSONArray points) {
        List<String> wktList = new ArrayList<>();
        for(int i=0;i<points.size();i++){
            JSONArray pointArr = points.getJSONArray(i);
            String wkt = "MULTIPOLYGON (";
            for(int j=0;j<pointArr.size();j++){
                JSONArray pointItem = pointArr.getJSONArray(j);
                wkt += "((";
                for(int m=0;m<pointItem.size();m++){
                    JSONObject map1 = (JSONObject) pointItem.get(m);
                    JSONObject map2 = new JSONObject();
                    if (m>0) {
                        map2 = (JSONObject) pointItem.get(m-1);
                    }
                    if(map2.get("region")!=null &&!map1.getString("region").equals(map2.getString("region"))){
                        wkt = wkt.substring(0, wkt.lastIndexOf(","));
                        wkt += "),(";
                    }
                    JSONArray point =  map1.getJSONArray("point");
                    wkt += point
                            .getDouble(0)+ " " + point.getDouble(1) + ",";
                }
                wkt = wkt.substring(0, wkt.lastIndexOf(","));
                wkt += ")),";
            }
            wkt = wkt.substring(0, wkt.lastIndexOf(","));
            wkt += ")";
            wktList.add(wkt);
        }
        return wktList;
    }

}
