package com.geoway.landteam.landcloud.service.formatConversion;

import com.geoway.landteam.customtask.service.util.ZipUtils;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.*;

/**
 * FileName: UploadShpService.java
 * Author:   dengmingdong
 * Date:     2020.07.18 18:21
 * Description: shapefile上传
 */
public class UploadShpService {

    String uploadDir;

    public UploadShpService(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    /**
     * 将MultipartFile转成File
     *
     * @return
     */
    //取出shape文件
    public List<Integer> parsingShapeFile(HttpServletRequest request) throws IOException {

        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<Integer>belts=new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                List<MultipartFile> shapeFile =  multiRequest.getFiles(iter.next());
                for (int i = 0;i < shapeFile.size();i++){
                    if (shapeFile.get(i) != null) {
                        String fileName = shapeFile.get(i).getOriginalFilename();
                        if (fileName.endsWith(".zip")) {
//                             Todo  shapefile解析
                            belts.add(this.shapeFile(shapeFile.get(i)));
                        }else{
                            List<Integer> error = new ArrayList<>();
                            return error;
                        }
                    }
                }
            }
        }
        return belts;
    }

    /**
     * 解析zip文件读取其中的.shp文件
     *
     * @return
     */
    public Integer shapeFile(MultipartFile shapeFile) throws IOException {
        File zipFile = getFileFromMultipartFile(shapeFile, ".zip");
        Long zipLong = zipFile.length();
        String zipString = zipLong.toString();
        Integer zipInteger = Integer.valueOf(zipString);
//        根据zip大小判断是否为空
        if(zipInteger>2000) {
            File[] files = ZipUtil1s.unZip(zipFile, this.uploadDir);
            if (files == null) {
            }
            // 解压文件夹名称
            String zipDirFileName = this.uploadDir +File.separator + FilenameUtils.getBaseName(zipFile.getName());
            File zipDirFile = new File(zipDirFileName);
            // 获取shp文件
            List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");
            if(shpFileList.isEmpty()){
                System.out.println("没有shp文件");
                return 0;
            }else{
                for (int i=0;i<shpFileList.size();i++){
                    String fileShp = shpFileList.get(i).toString();
                    fileShp=fileShp.replaceAll("\\\\","\\\\\\\\");
                    shpFileList.set(i,fileShp);
                }
                Integer theBelt=shpInfo(shpFileList);
                FileUtil.deleteFileAndDir(zipDirFile);
                return theBelt;
            }
        }else{
            return 0;
        }
    }

    /**
     * 建立临时文件
     *
     * @param file
     * @return
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy(is, os);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                os.close();
                is.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return f;
    }


    /**
     * 读取shp信息，建立字段集合和对应的属性值集合，返回转换完的EpsgCode
     *
     * @param shpFilePath 需要传给转换方法的.shp路径
     * @return
     */
    public Integer shpInfo(List<String> shpFilePath) throws IOException {

        Integer tarEpsg = 0;
        for (int i = 0; i < shpFilePath.size(); i++) {
            //遍历shp集合
            ShapefileDataStore dataStore = buildDataStore(shpFilePath.get(i));
            //加载文件
            File file = new File(shpFilePath.get(i));
            if (file == null) {
            }
            //通过store获取featurecollection
            FileDataStore store = FileDataStoreFinder.getDataStore(file);
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureCollection simpleFeatureCollection = featureSource.getFeatures();
            SimpleFeatureIterator itertor = simpleFeatureCollection.features();

            //遍历featurecollection
            List<Integer> equalEpsg = new ArrayList<>();
            while (itertor.hasNext()) {
                Map<String, Object> data = new HashMap<String, Object>();
                SimpleFeature feature = itertor.next();
                Collection<Property> p = feature.getProperties();
                Iterator<Property> it = p.iterator();
                while (it.hasNext()) {
                    //遍历属性字段
                    Property pro = it.next();
                    String name = pro.getName().toString();
                    name = name.equals("the_geom") ? "wkt" : name;
                    data.put(name, pro.getValue());
                    if (name == "wkt") {
                        //当字段为wkt时，对其属性值geometry进行处理。
                        equalEpsg.add(StrUtil.getTarget(dataStore));
//                        System.out.println("查询文件信息中");

                    } else {
                    }
                }
            }
            itertor.close();
            dataStore.dispose();
            return equalEpsg.get(0);
        }
        return tarEpsg;
    }

    /**
     * 构建ShapeDataStore对象。
     *
     * @param shpFilePath shape文件路径。
     * @return
     */
    public static ShapefileDataStore buildDataStore(String shpFilePath) {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        try {
            ShapefileDataStore dataStore = (ShapefileDataStore) factory
                    .createDataStore(new File(shpFilePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(Charset.forName("UTF-8"));
            }
            return dataStore;
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}