package com.geoway.landteam.landcloud.service.formatConversion.utils;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.formatConversion.Gson2ShpService;
import com.geoway.landteam.landcloud.service.formatConversion.Shp2GsonService;
import com.geoway.landteam.landcloud.service.formatConversion.Shp2TxtService;
import com.geoway.landteam.landcloud.service.formatConversion.Txt2ShpService;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.multipart.MultipartFile;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;


/**
 * 根据任务数创建新的线程
 * Created by yecongwang on 2020/7/13.
 */

public class AsyncHandler {
    private ExecutorService executorService = null;
    public AsyncHandler(int threadNum){
        this.executorService = Executors.newFixedThreadPool(threadNum);
    }
    //根据转换文件的格式进行相应的处理
    public Future<Integer> call(MultipartFile mulFile, JSONObject rule, RedisTemplate redisTemplate, String username, String downloadPath){
        return executorService.submit(()->{
            String filename = mulFile.getOriginalFilename().substring(mulFile.getOriginalFilename().indexOf(".")+1);
            String targetFileName = mulFile.getOriginalFilename().substring(0,mulFile.getOriginalFilename().indexOf(".")+1)+rule.getString("targetFile");
            long index = redisTemplate.opsForList().rightPush(username,mulFile.getOriginalFilename()+"-"+targetFileName+"-executing") - 1;
            String suffix = null;
            switch (filename){
                case "txt":{
                    if("shp".equals(rule.getString("targetFile"))){
                        Txt2ShpService txt2ShpUtil = new Txt2ShpService(downloadPath);
                        suffix = txt2ShpUtil.startExchange(mulFile);
                    }
                }break;
                case "zip":{
                    if("txt".equals(rule.getString("targetFile"))){
                        Shp2TxtService shp2TxtUtil = new Shp2TxtService(downloadPath);
                        suffix = shp2TxtUtil.startExchange(mulFile,rule.getString("fileNum"));
                    }else {
                        Shp2GsonService shp2GsonUtil = new Shp2GsonService(downloadPath);
                        suffix = shp2GsonUtil.startExchange(mulFile);
                    }
                }break;
                case "geojson":{
                    if("shp".equals(rule.getString("targetFile"))){
                        Gson2ShpService gson2ShpUtil = new Gson2ShpService(downloadPath);
                        suffix = gson2ShpUtil.startExchange(mulFile);
                    }
                }break;
            }
            String tem = null;
            tem = rule.get("fileNum")==null?null:rule.getString("fileNum");
            if(suffix != null){
                redisTemplate.opsForList().set(username,index,mulFile.getOriginalFilename()+"-"+targetFileName+"-"+suffix+"-"+tem);
            }else {
                redisTemplate.opsForList().set(username,index,mulFile.getOriginalFilename()+"-"+targetFileName+"-fail"+"-"+tem);
            }
            return 1;
        });
    }
    public void shutDown(){
        executorService.shutdown();
    }

}
