package com.geoway.landteam.landcloud.service.formatConversion.utils;

import org.apache.commons.io.IOUtils;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.*;

/**
 * Created by yecongwang on 2020/7/16.
 */
public class MulFileUtil {
    //获取文件的字节编码
    public static String getFileCharSet(File sourceFile){
        String charset = "GBK";
        byte[] first3Bytes = new byte[3];
        try {
            boolean checked = false;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            bis.mark(0);
            int read = bis.read(first3Bytes, 0, 3);
            if (read == -1) {
                //文件编码为 ANSI
            } else if (first3Bytes[0] == (byte) 0xFF
                    && first3Bytes[1] == (byte) 0xFE) {
                charset = "UTF-16LE"; //文件编码为 Unicode
                checked = true;
            } else if (first3Bytes[0] == (byte) 0xFE
                    && first3Bytes[1] == (byte) 0xFF) {
                charset = "UTF-16BE"; //文件编码为 Unicode big endian
                checked = true;
            } else if (first3Bytes[0] == (byte) 0xEF
                    && first3Bytes[1] == (byte) 0xBB
                    && first3Bytes[2] == (byte) 0xBF) {
                charset = "UTF-8"; //文件编码为 UTF-8
                checked = true;
            }
            bis.reset();
            if (!checked) {
                int loc = 0;
                while ((read = bis.read()) != -1) {
                    loc++;
                    if (read >= 0xF0)
                        break;
                    if (0x80 <= read && read <= 0xBF) // 单独出现BF以下的，也算是GBK
                        break;
                    if (0xC0 <= read && read <= 0xDF) {
                        read = bis.read();
                        if (0x80 <= read && read <= 0xBF) // 双字节 (0xC0 - 0xDF)
                            // (0x80
                            // - 0xBF),也可能在GB编码内
                            continue;
                        else
                            break;
                    } else if (0xE0 <= read && read <= 0xEF) {// 也有可能出错，但是几率较小
                        read = bis.read();
                        if (0x80 <= read && read <= 0xBF) {
                            read = bis.read();
                            if (0x80 <= read && read <= 0xBF) {
                                charset = "UTF-8";
                                break;
                            } else
                                break;
                        } else
                            break;
                    }
                }
            }
            bis.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return charset;
    }
    //读取dbf
    public static List<Map> readDBF(String dbfPath) {
        List<Map> results=new ArrayList<Map>();
        String charset = getFileCharSet(new File(dbfPath));
        try {
            FileChannel in = new FileInputStream(dbfPath).getChannel();
            Charset cs = Charset.forName(charset);
//			if("UTF-8".equalsIgnoreCase(cs.name())){
//				cs = Charset.forName("GBK");
//			}
            DbaseFileReader dbfReader =  new DbaseFileReader(in, false,  cs);
            DbaseFileHeader header = dbfReader.getHeader();
            int fields = header.getNumFields();


            while ( dbfReader.hasNext() ){
                DbaseFileReader.Row row =  dbfReader.readRow();
//				System.out.println(row.toString());
                Map item=new HashMap();
                for (int i=0; i<fields; i++) {
                    item.put(header.getFieldName(i), row.read(i));
                }
                results.add(item);
            }
            dbfReader.close();
            in.close();
            return results;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
    //读取geojson
    public static String readJson(String filepath) {
        FileReader re = null;
        BufferedReader buff = null;
        String line = "";
        try {
            File file = new File(filepath);
            re = new FileReader(file);
            buff = new BufferedReader(re);
            String tempString = null;
            while ((tempString = buff.readLine()) != null) {
                line += tempString.replaceAll(" ","");
            }
            return line;
        } catch (Exception e) {
            System.out.println("失败了");
        } finally {
            try {
                re.close();
                buff.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return line;
    }

    //临时保存上传的文件
    public static File getFileFromMultipartFile(MultipartFile file, String suffix, String uploadDir) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy(is, os);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                os.close();
                is.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return f;
    }
}
