package com.geoway.landteam.landcloud.service.formatConversion.utils;


import org.geotools.data.shapefile.ShapefileDataStore;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by yecongwang on 2020/7/17.
 */
public class StrUtil {
    /**
     * 获取求crsId所需的信息
     * @param crsDataSource
     * @return
     */
    public static Map<String,String> splitCrsData(String crsDataSource){
        String crsData = crsDataSource.toLowerCase();
        Map<String,String> headData = new HashMap<>();
        boolean is3Degree = true;
        String daiHao = "0";//默认带号
        if(crsData.contains("cgcs2000")){
            headData.put("坐标系","2000国家大地坐标系");
        }

        String degreeRex = "3.*degree";
        Pattern degreePt = Pattern.compile(degreeRex);
        Matcher degreeMc = degreePt.matcher(crsData);
        if(degreeMc.find()){
            headData.put("几度分带","3");
        }else {
            headData.put("几度分带","6");
            is3Degree = false;
        }
        if(crsData.contains("zone")){
            daiHao = crsData.split("zone")[1].replaceAll("[^1-9]","");
        }else {
            int longitude = Integer.parseInt(crsData.split("cm")[1].replaceAll("[^1-9]",""));
            if(is3Degree){
                daiHao = Math.floor(longitude/3)+"";
            }else {
                daiHao = Math.floor((longitude+3)/6)+"";
            }
        }
        headData.put("带号",daiHao);
        return headData;

    }

    /**
     * 求取crsId
     * @param crsAttrs
     * @return
     */
    public static Integer getCrsId(Map<String,String> crsAttrs) {
        Integer crsId = null;
        if(!crsAttrs.containsKey("几度分带")&&!crsAttrs.containsKey("带号") && "2000国家大地坐标系".equals(crsAttrs.get("坐标系"))){
            crsId = 4490;
            return crsId;
        }
        Integer zoning = Integer.parseInt(crsAttrs.get("几度分带"));
        Integer zoningNum = Integer.parseInt(crsAttrs.get("带号"));
        String crs = (String) crsAttrs.get("坐标系");
        if(zoning == 3 && "2000国家大地坐标系".equals(crs)){
            crsId = 4513 + zoningNum - 25;
        }else {
            crsId = 4514 + zoningNum - 25;
        }
        return crsId;
    }

    public static String getTargetFileSuffix(String suffix){
        switch (suffix){
            case "txt":return "txt";
            case "shp":return "zip";
            case "geojson":return "geojson";
            default:return "";
        }
    }
    public static Geometry wktToGeometry(String wktString, Integer crsId) {
        StringBuffer sbBuffer = new StringBuffer();
        WKTReader fromText = new WKTReader();
        String wkt = sbBuffer.append(wktString).toString();
        Geometry geom = null;
        try {
            geom = fromText.read(wkt);
            geom.setSRID(crsId);
        } catch (Exception e) {
            throw new RuntimeException("Not a WKT string:" + wktString);
        }
        return geom;
    }

    public static boolean haveAttribute(String rex,Map<String,String> field){
        for(String attr:rex.split(",")){
            if(!"".equals(attr) && attr!=null){
                boolean exist = false;
                for(String key : field.keySet()){
                    if(key.contains(attr)){
                        exist = true;
                        break;
                    }
                }
                if(!exist){
                    return false;
                }
            }
        }
        return true;
    }

    /**
     * 通过获取geometry最大最小值经度值判断属于哪个带，判断是否存在跨带情况。返回前端上传界面需要的EPSG
     *
     * @param shpFilePath .shp路径
     * @param geometry  需要转换的geometry
     * @param belt 需要转换的分度带值
     * @return
     */

    public static int getTarget(ShapefileDataStore dataStore){

        int epsg=0;
        try {
            String wkt = dataStore.getSchema().getCoordinateReferenceSystem().toWKT();

            //根据读出的数据是否存在PROJCS字段判断转换类型
            if(wkt.indexOf("PROJCS")!=-1){
                // 当前是投影，需要去投影转地理坐标系
                String str1=wkt.substring(0, wkt.indexOf("GEOGCS[\""));
                String str2=wkt.substring(str1.length()+8, wkt.length());
                String str3=str2.substring(0,str2.indexOf("\""));
                if(str3.equals("China Geodetic Coordinate System 2000")||str3.equals("GCS_CGCS_2000")||str3.equals("GCS_China_Geodetic_Coordinate_System_2000")) {
                    //4490和4326都表示当前需要去投影转地理坐标系
                    epsg = 4490;
                }else if(str3.equals("WGS 84")||str3.equals("GCS_WGS_1984")){
                    epsg = 4326;
                }
            }else {
                // 地理坐标系加投影
                String str1=wkt.substring(0, wkt.indexOf("GEOGCS[\""));
                String str2=wkt.substring(str1.length()+8, wkt.length());
                String str3=str2.substring(0,str2.indexOf("\""));
                if(str3.equals("China Geodetic Coordinate System 2000")||str3.equals("GCS_China_Geodetic_Coordinate_System_2000")||str3.equals("GCS_CGCS_2000")){
                    //当前需要为cgcs2000添加投影，4535表示当前需要给cgcs2000加投影，3857表示需要给wgs84加投影
                    epsg=4535;
                }else if(str3.equals("WGS 84")||str3.equals("GCS_WGS_1984")){
                    epsg=3857;
                }
            }

        } catch (UnsupportedOperationException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return epsg;
    }


    /**
     * 返回需要写入文件的EPSG值
     *
     * @param geometry 需要转换的geometry
     * @param targetEpsg 用户选择的需要转换的坐标信息字符串
     * @return
     */
    public static Integer getEpsg(Geometry geometry,String targetEpsg) {

        String str1=targetEpsg.substring(0,targetEpsg.length()-1);
        String str2=targetEpsg.substring(targetEpsg.length()-1,targetEpsg.length());
        if(targetEpsg.equals("CGCS-2000")){
            targetEpsg="4490";
        }else if(targetEpsg.equals("WGS-84")){
            targetEpsg="4326";
        }else if(targetEpsg.equals("WEB-墨卡托")){
            targetEpsg="3857";
        }else if(str1.equals("高斯-克吕格")){
            String belt=str2;
            Integer theBelt = Integer.parseInt(belt);
            String str = geometry.getEnvelope().toString();
            String pattern="[^0-9.]";
            Pattern p=Pattern.compile(pattern);
            Matcher m=p.matcher(str);
            Double left;
            Double right;
            Integer theEpsg=4514;
            Integer sixEpsg=4492;

            if(m.find()){
                String strm=m.replaceAll(" ");
                String[] chunks = strm.split("\\s+");
                List<Double> lon=new ArrayList<>();
                for(int i=0;i<chunks.length;i++){
                    if(i%2!=0) {
                        lon.add(Double.parseDouble(chunks[i]));
                    }
                }
//                获取geometry经度最大最小值
                left=lon.get(0);
                right=lon.get(2);
                if(theBelt==3){
                    if(right<76.5){
                        theEpsg=4513;
                        targetEpsg=theEpsg.toString();
                    }
                    for(Double i=76.5;i<133.5;i=i+3){
                        if(i>left&&i<right){
                            System.out.println("跨带了！！");
                        }else if(i<left&&right<i+3){
                            targetEpsg=theEpsg.toString();
                        }else{
                            theEpsg++;
                        }
                    }
                }else if(theBelt==6){
                    if(right<78){
                        sixEpsg=4491;
                        targetEpsg=sixEpsg.toString();
                    }
                    for(int i=78;i<132;i=i+6){
                        if(i>left&&i<right){
                            System.out.println("跨带了！！");
                        }else if(i<left&&right<i+6){
                            targetEpsg=sixEpsg.toString();
                        }else{
                            sixEpsg++;
                        }
                    }
                }
            }else{
                System.out.println("nomatch=====");
            }
        }
        Integer finalEpsg=Integer.parseInt(targetEpsg);
        return finalEpsg;
    }
    public static Integer epsgForArea(Geometry geometry) {
        int targetEpsg = 0;
        String str = geometry.getEnvelope().toString();
        String pattern = "[^0-9.]";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        Double left;
        Double right;
        Integer theEpsg = 4514;
        if (m.find()) {
            String strm = m.replaceAll(" ");
            String[] chunks = strm.split("\\s+");
            List<Double> lon = new ArrayList<>();
            for (int i = 0; i < chunks.length; i++) {
                if (i % 2 != 0) {
                    lon.add(Double.parseDouble(chunks[i]));
                }
            }
//                获取geometry经度最大最小值
            left = lon.get(0);
            right = lon.get(2);
            if (right < 76.5) {
                theEpsg = 4513;
                targetEpsg = theEpsg;
            }
            for (Double i = 76.5; i < 133.5; i = i + 3) {
                if (i > left && i < right) {
                    System.out.println("跨带了！！");
                } else if (i < left && right < i + 3) {
                    targetEpsg = theEpsg;
                } else {
                    theEpsg++;
                }
            }
        } else {
            System.out.println("nomatch=====");
        }
        return targetEpsg;
    }
}
