package com.geoway.landteam.landcloud.service.jms.config;

//import com.geoway.base.service.SysConfigService;
//import com.geoway.land.core.activemq.constant.ActiveMQQueueConstant;
//import com.geoway.land.core.activemq.receive.ConsumerMessageListener;
//import com.geoway.land.core.syncuis.service.SyncUisService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQQueueConstant;
import com.geoway.landteam.landcloud.service.jms.receive.ConsumerMessageListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.pool.PooledConnectionFactory;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import javax.jms.MessageListener;
import java.util.LinkedList;
import java.util.List;

@EnableJms
@Configuration
public class ActiveMQConfig {

    @Value("${activemq.ip}")
    String ip;

    @Value("${activemq.port}")
    String port;

    @Value("${activemq.queueName}")
    String queueName;

    @Value("${activemq.passEnable}")
    String passEnable;

    @Value("${activemq.username}")
    String username;

    @Value("${activemq.password}")
    String password;

    @Value("${activemq.topicName}")
    String topicName;

    @Value("${activemq.maxConnections}")
    Integer maxConnections;

    @Value("${activemq.idleTimeout}")
    Integer idleTimeout;
    @Value("${Queue.accept.Tran:}")
    String queueAcceptTran;

    @Value("${Queue.accept.enable:false}")
    boolean queueAcceptEnable;
   /* @Resource
    SyncUisService syncUisService;*/

    @Autowired
    SysConfigService sysConfigService;

    //配置ConnectionFactory用于生成connection
    @Bean
    public ActiveMQConnectionFactory connectionFactory() {
        //tcp://localhost:61616
        StringBuffer url = new StringBuffer("tcp://");
        url.append(ip).append(":").append(port);
        ActiveMQConnectionFactory activeMQConnectionFactory;

        if("true".equals(passEnable)){
            //启用密码设置
            activeMQConnectionFactory = new ActiveMQConnectionFactory(url.toString());
        }else{
            activeMQConnectionFactory = new ActiveMQConnectionFactory(username,password,url.toString());
        }

        return activeMQConnectionFactory;
    }

    //配置activemq的连接池
    @Bean
    public PooledConnectionFactory pooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory(connectionFactory);
        pooledConnectionFactory.setMaxConnections(maxConnections);
        pooledConnectionFactory.setIdleTimeout(idleTimeout);
        return pooledConnectionFactory;
    }

    /**
     * 配置队列目的的
     * 1.队列  点对点 queue
     * 2.主题  一对多  topic
     */
    @Bean
    public ActiveMQQueue queueDestination() {
        List<String> nameList = new LinkedList<>();
        nameList.add("LandWork-Queue");
        if(queueAcceptEnable){
            nameList.add(ActiveMQQueueConstant.IMAGE_CAPTURE);
            nameList.add(ActiveMQQueueConstant.TASK);
            //nameList.add(ActiveMQQueueConstant.TRANSFER_ADAPTER);
            //nameList.add(ActiveMQQueueConstant.TXT_DOWN);
            //nameList.add(ActiveMQQueueConstant.XZJSYDMJ);
            if(StringUtils.isNotBlank(queueAcceptTran)){
                nameList.add(queueAcceptTran);
            }
        }
        String queueName = StringUtils.join(nameList, ",");
        ActiveMQQueue activeMQQueue = new ActiveMQQueue(queueName);
        return activeMQQueue;
    }


    //配置生产者，jmsTemplate
    @Bean
    public JmsTemplate jmsTemplate(PooledConnectionFactory pooledConnectionFactory, ActiveMQQueue activeMQQueue) {
        JmsTemplate jmsTemplate = new JmsTemplate();
        jmsTemplate.setConnectionFactory(pooledConnectionFactory);
        jmsTemplate.setDefaultDestination(activeMQQueue);
        return jmsTemplate;
    }

    @Bean
    public ActiveMQTopic topicDestination() {
        ActiveMQTopic activeMQTopic = new ActiveMQTopic(topicName);
        return activeMQTopic;
    }

    @Bean
    public MessageListener queueListener() {
        MessageListener listener = new ConsumerMessageListener();
        return listener;
    }

    @Bean
    public DefaultMessageListenerContainer jmsQueueListenerContainer(PooledConnectionFactory pooledConnectionFactory,
                                                                     ActiveMQQueue queueDestination,
                                                                     MessageListener listener) {
        DefaultMessageListenerContainer jmsContainer = new DefaultMessageListenerContainer();
        jmsContainer.setConnectionFactory(pooledConnectionFactory);
        jmsContainer.setDestination(queueDestination);
        jmsContainer.setMessageListener(listener);
        return jmsContainer;
    }

    @Bean
    public DefaultMessageListenerContainer jmsTopicListenerContainer(PooledConnectionFactory pooledConnectionFactory,
                                                                     ActiveMQTopic topicDestination,
                                                                     MessageListener listener) {
        DefaultMessageListenerContainer jmsContainer = new DefaultMessageListenerContainer();
        jmsContainer.setConnectionFactory(pooledConnectionFactory);
        jmsContainer.setDestination(topicDestination);
        jmsContainer.setMessageListener(listener);
        return jmsContainer;
    }
}
