package com.geoway.landteam.landcloud.service.jms.jmx;


import com.alibaba.fastjson.JSONObject;
//import com.geoway.land.core.support.CloudMsgUtil;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
//
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;


@Component
/*@PropertySource("classpath:activemq.properties")*/
public class JmxApiService {

    private static final GiLoger logger = GwLoger.getLoger(JmxApiService.class);

    /**
     * 未消费消息数量
     */
    public static String QueueSize = "QueueSize";

    /**
     * 已接受消息数量
     */
    public static String EnqueueCount = "EnqueueCount";

    /**
     * 已消费消息数量
     */
    public static String DequeueCount = "DequeueCount";

    /**
     * 消费者数量
     */
    public static String ConsumerCount = "ConsumerCount";

    /**
     * 生产者数量
     */
    public static String ProducerCount = "ProducerCount";

    @Value("${activemq.ip}")
    String ip;

    @Value("${activemq.jmx.port}")
    Integer port;

    @Value("${activemq.queueName}")
    String queueName;

    @Value("${activemq.topicName}")
    String topicName;

    @Value("${activemq.jmx.username}")
    String username;

    @Value("${activemq.jmx.password}")
    String password;

    @Value("${activemq.jmx.connectTimeout}")
    Integer timeout;

    /**
     * 获取默认队列中成员的等待数量
     * @return
     */
    public Long getDefQueuePendingNum(){
        return getQueuePendingNum(queueName);
    }

    /**
     * 通过队列名称获取队列已接收消息数量
     * @param queueName 队列名称
     * @return
     */
    public Long getQueueEnqueueCount(String queueName){
        Long length = 0L;

        String result = sendJmxHttp(queueName, EnqueueCount);
        JSONObject obj = JSONObject.parseObject(result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq队列已接收消息数量接口访问成功，数量：" + length);
        }
        return length;
    }

    /**
     * 通过队列名称获取队列已消费消息数量
     * @param queueName 队列名称
     * @return
     */
    public Long getQueueDequeueCount(String queueName){
        Long length = 0L;

        String result = sendJmxHttp(queueName, DequeueCount);
        JSONObject obj = JSONObject.parseObject(result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq队列已消费消息数量接口访问成功，数量：" + length);
        }
        return length;
    }

    /**
     * 通过队列名称获取队列消费者数量
     * @param queueName 队列名称
     * @return
     */
    public Long getQueueConsumerCount(String queueName){
        Long length = 0L;

        String result = sendJmxHttp(queueName, ConsumerCount);
        JSONObject obj = JSONObject.parseObject(result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq队列消费者数量接口访问成功，数量：" + length);
        }
        return length;
    }

    /**
     * 通过队列名称获取队列生产者数量
     * @param queueName 队列名称
     * @return
     */
    public Long getQueueProducerCount(String queueName){
        Long length = 0L;

        String result = sendJmxHttp(queueName, ProducerCount);
        JSONObject obj = JSONObject.parseObject(result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq队列生产者数量接口访问成功，数量：" + length);
        }
        return length;
    }

    /**
     * 通过队列名称获取队列中未消费消息数量
     * @param queueName 队列名称
     * @return
     */
    public Long getQueuePendingNum(String queueName){
        Long length = 0L;

        String result = sendJmxHttp(queueName, QueueSize);
        JSONObject obj = JSONObject.parseObject(result);
        String status = obj.getString("status");
        if ("200".equals(status)) {
            length = obj.getLongValue("value");
            logger.info("activemq队列未消费消息数量接口访问成功，数量：" + length);
        }
        return length;
    }

    private String sendJmxHttp(String queueName, String method) {
        CloseableHttpClient httpClient = null;
        String result = null;
        try {
            //String url = "http://49.4.122.19:8161/api/jolokia/read/org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=landworkQueue/QueueSize";
            String url = String.format("/api/jolokia/read/org.apache.activemq:type=Broker," +
                    "brokerName=localhost,destinationType=Queue,destinationName=%s/%s", queueName, method);
            HttpHost targetHost = new HttpHost(ip, port, "http");
            //此处添加账号和密码
            CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(
                    new AuthScope(targetHost.getHostName(), targetHost.getPort()),
                    new UsernamePasswordCredentials(username, password));


            //设置请求超时时间
            RequestConfig requestConfig = RequestConfig.custom()
                    .setSocketTimeout(timeout)
                    .setConnectTimeout(timeout)
                    .setConnectionRequestTimeout(timeout)
                    .build();

            // httpClient实例.
            httpClient = HttpClients.custom() //此处可以添加权限
                    .setDefaultCredentialsProvider(credentialsProvider)
                    .setDefaultRequestConfig(requestConfig)
                    .build();

            HttpGet httpget = new HttpGet(targetHost.toURI() + url);
            httpget.addHeader("Content-Type", "application/json;charset=UTF-8");

            // 执行请求
            CloseableHttpResponse response  = httpClient.execute(httpget);

            // 打印执行结果
            result = EntityUtils.toString(response.getEntity(), "utf-8");

            System.out.println(result);

        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            CloudMsgUtil.closeHttpClient(httpClient);
        }
        return result;
    }

}
