package com.geoway.landteam.landcloud.service.jms.jmx;


import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
//
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import java.util.HashMap;
import java.util.Map;

/**
 * 消息队列工具类
 * activemq/conf/activemq.xml文件中 broker节点下，修改managementContext节点内容为
 * <managementContext>
 *   <managementContext createConnector="true" connectorPort="11099"/>
 *</managementContext>
 */
@Component
/*@PropertySource("classpath:activemq.properties")*/
public class JmxService {

    private static final GiLoger logger = GwLoger.getLoger(JmxService.class);

    @Value("${activemq.ip}")
    String ip;

    @Value("${activemq.jmx.port}")
    String port;

    @Value("${activemq.queueName}")
    String queueName;

    @Value("${activemq.topicName}")
    String topicName;

    /**
     * 获取默认队列中成员的等待数量
     * @return
     */
    public Long getDefQueuePendingNum(){
        return 0L;
        //return getQueuePendingNum(queueName);
    }

    /**
     * 通过队列名称获取队列中成员的等待数量
     * @param queueName 队列名称
     * @return
     */
    public Long getQueuePendingNum(String queueName){
        Long length = 0L;
        try {
            Map<String, Long> map = getQueuesInfo();
            if (map.size() > 0) {
                length = map.get(queueName);
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            e.printStackTrace();
        }

        return length;
    }

    private Map<String, Long> getQueuesInfo() throws Exception {
        Map<String, Long> map = new HashMap<>();

        //service:jmx:rmi:///jndi/rmi://localhost:11099/jmxrmi
        StringBuffer url = new StringBuffer("service:jmx:rmi:///jndi/rmi://");
        url.append(ip).append(":").append(port).append("/jmxrmi");

        JMXServiceURL address = new JMXServiceURL(url.toString());
        JMXConnector connector = JMXConnectorFactory.connect(address);
        MBeanServerConnection mbsc = connector.getMBeanServerConnection();
        connector.connect();
        ObjectName objectName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost");
        if (objectName != null) {
            BrokerViewMBean broker = MBeanServerInvocationHandler.newProxyInstance(mbsc, objectName, BrokerViewMBean.class, true);
            //BrokerViewMBean broker = JMX.newMBeanProxy(mbsc, objectName, BrokerViewMBean.class);
            //System.out.println(Arrays.toString(broker.getQueues()));
            for (ObjectName queueName : broker.getQueues()) {
                QueueViewMBean queueMBean = MBeanServerInvocationHandler.newProxyInstance(mbsc, queueName, QueueViewMBean.class, true);
                map.put(queueMBean.getName(), queueMBean.getQueueSize());
                //System.out.println("Queue Name --- " + queueMBean.getName());// 消息队列名称
                //System.out.println("Queue Size --- " + queueMBean.getQueueSize());// 队列中剩余的消息数
                //System.out.println("Number of Consumers --- " + queueMBean.getConsumerCount());// 消费者数
                //System.out.println("Number of Dequeue ---" + queueMBean.getDequeueCount());// 出队数

            }
        }
        connector.close();
        return map;
    }
}
