package com.geoway.landteam.landcloud.service.jms.receive;

import com.alibaba.fastjson.JSONObject;
//import com.geoway.land.core.activemq.constant.ActiveMQConstant;
//import com.geoway.land.core.activemq.constant.ActiveMQQueueConstant;
//import com.geoway.land.core.activemq.service.IConsumerStrategyJsonService;
//import com.geoway.land.core.activemq.service.IConsumerStrategyService;
//import com.geoway.land.core.activemq.service.factory.StrategyServiceFactory;
//import com.geoway.land.core.networkTransmission.service.TaskTransmitService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQQueueConstant;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyJsonService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.jms.service.factory.StrategyServiceFactory;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.activemq.command.ActiveMQDestination;
//

import javax.jms.*;

public class ConsumerMessageListener implements MessageListener {

    private static final GiLoger logger = GwLoger.getLoger(ConsumerMessageListener.class);

    @Override
    public void onMessage(Message message) {
        try {

            ActiveMQDestination queues = (ActiveMQDestination) message.getJMSDestination();

            switch (queues.getPhysicalName()) {
                case ActiveMQQueueConstant.QueueLoadData:
                    // 数据加载

                    break;
                case ActiveMQQueueConstant.QueueCreateDB:
                    // 生成DB包

                    break;
                case ActiveMQQueueConstant.QueueAssign:
                    // 数据下发
                    System.out.println("数据下发");
                    break;
                case ActiveMQQueueConstant.QueueSubmit:
                    // 数据提交
                    break;
                case ActiveMQQueueConstant.QueueDownLoad:
                    // 数据下载
                    break;
            }


            logger.info("-----消费者接受到消息了-----");
            if (message instanceof TextMessage) { //接收文本消息
                TextMessage tmessage = (TextMessage) message;
                String msg = tmessage.getText();
                JSONObject obj = JSONObject.parseObject(msg);
                if (obj.containsKey(ActiveMQConstant.SERVICE_NAME)) {
                    String id = obj.getString(ActiveMQConstant.SERVICE_NAME);
                    IConsumerStrategyJsonService service = StrategyServiceFactory.getJsonService(id);
                    service.execute(obj);
                } else {
                    throw new JMSException(this.getClass().getName() + ": json参数中缺少serviceName属性");
                }

            } else if (message instanceof MapMessage) { //接收键值对消息

                MapMessage messageMap = (MapMessage) message;
                String id = messageMap.getString(ActiveMQConstant.SERVICE_NAME);
                if (id != null) {
                    IConsumerStrategyService service = StrategyServiceFactory.getService(id);
                    service.execute(messageMap);
                } else {
                    throw new JMSException(this.getClass().getName() + ": map参数中缺少serviceName键值对");
                }
            } else if (message instanceof BytesMessage) { //字节接收消息
                BytesMessage bytesMessage = (BytesMessage) message;
                // todo 张俊关闭，因为类暂时未引入
//                TaskTransmitService service = new TaskTransmitService();
//                service.execute(bytesMessage);

            }
        } catch (JMSException e) {
            e.printStackTrace();
        }
    }
}
