package com.geoway.landteam.landcloud.service.jms.send;

import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
//
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.jms.*;
import java.io.Serializable;
import java.util.Map;

@Component
public class ProducerService {

    private static final GiLoger logger = GwLoger.getLoger(ProducerService.class);

    @Autowired
    private JmsTemplate jmsTemplate;

    @Resource(name = "queueDestination")
    private Destination queueDestination;

    public void sendTextMessage2Queue(final String json) {

        logger.info("------生产者发送的消息[消息类型Text]-----");
        logger.info("生产者发送的一条消息：text");

        jmsTemplate.send(queueDestination, new MessageCreator() {

            @Override
            public Message createMessage(Session session) throws JMSException {
                TextMessage message = session.createTextMessage();
                message.setText(json);
                logger.info("------生产者发送的消息SUCCESS[消息类型Text]-----");
                return message;
            }

        });
    }

    public void sendMapMessage2Queue(final Map<String, Object> map) {

        logger.info("------生产者发送的消息[消息类型Map]-----");
        logger.info("生产者发送的一条消息：Map");

        jmsTemplate.send(queueDestination, new MessageCreator() {

            @Override
            public Message createMessage(Session session) throws JMSException {
                MapMessage message = session.createMapMessage();
                transformMapMessage(message, map);
                //message.setJMSReplyTo();
                logger.info("------生产者发送的消息SUCCESS[消息类型Map]-----");
                return message;
            }

        });

    }

    public void sendMapMessage2Queue(final Map<String, Object> map, String queueName) {
       /* Destination destination = jmsTemplate.getDefaultDestination();
        ActiveMQDestination activeMQDestination = (ActiveMQDestination) destination;
        ActiveMQDestination[] compositeDestinations = activeMQDestination.getCompositeDestinations();
        for (int i = 0; i < compositeDestinations.length; i++) {
            String name = compositeDestinations[i].getPhysicalName();
            if (queueName.equals(name)) {*/
                jmsTemplate.send(queueName, new MessageCreator() {

                    @Override
                    public Message createMessage(Session session) throws JMSException {
                        MapMessage message = session.createMapMessage();
                        transformMapMessage(message, map);
                        //message.setJMSReplyTo();
                        logger.info("------生产者发送的消息SUCCESS[消息类型Map]-----");
                        return message;
                    }
                });
         /*   }
        }*/
    }

    public void sendObjectMessage2Queue(final Serializable obj) {

        logger.info("------生产者发送的消息[消息类型Object]-----");
        logger.info("生产者发送的一条消息：Object");

        jmsTemplate.send(queueDestination, new MessageCreator() {

            @Override
            public Message createMessage(Session session) throws JMSException {
                ObjectMessage message = session.createObjectMessage();
                message.setObject(obj);
                logger.info("------生产者发送的消息SUCCESS[消息类型Object]-----");
                return message;
            }

        });
    }

    private void transformMapMessage(MapMessage message, Map<String, Object> map) throws JMSException {
        for (String key : map.keySet()) {
            Object obj = map.get(key);

            if (obj instanceof Boolean) {
                message.setBoolean(key, (Boolean) obj);
            } else if (obj instanceof Byte) {
                message.setByte(key, (Byte) obj);
            } else if (obj instanceof Short) {
                message.setShort(key, (Short) obj);
            } else if (obj instanceof Character) {
                message.setChar(key, (Character) obj);
            } else if (obj instanceof Integer) {
                message.setInt(key, (Integer) obj);
            } else if (obj instanceof Long) {
                message.setLong(key, (Long) obj);
            } else if (obj instanceof Float) {
                message.setFloat(key, (Float) obj);
            } else if (obj instanceof Double) {
                message.setDouble(key, (Double) obj);
            } else if (obj instanceof String) {
                message.setString(key, (String) obj);
            } else {
                message.setObject(key, obj);
            }
        }
    }

}
