package com.geoway.landteam.landcloud.service.jms.service;

import com.alibaba.fastjson.JSONArray;

import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;


import com.geoway.landteam.customtask.service.task.thread.TaskDBThread;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

@Service
public class TaskAddBizService implements IConsumerStrategyService {

    @Autowired
    TaskNoticeServiceImpl taskNoticeService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    TaskRecordService taskRecordService;

    ExecutorService threadPool= Executors.newFixedThreadPool(10);

    @Override
    public String getCode() {
        return "TaskAddBizService";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        //mapMessage.put("userId", userId);
        //mapMessage.put("userName", user.getName());
        //mapMessage.put("taskBizId", tskTaskBiz.getId());
        //mapMessage.put("uploadDir", uploadDir);
        //mapMessage.put("userIds", groups.toJSONString());

        try {
            Long userId = mapMessage.getLong("userId");
            String userName = mapMessage.getString("userName");
            String bizId = mapMessage.getString("taskBizId");
            String uploadDir = mapMessage.getString("uploadDir");

            String userIdsStr = mapMessage.getString("userIds");
            JSONArray array = JSONArray.parseArray(userIdsStr);
            List<String> userIds = new ArrayList<>();
            for (int i=0; i<array.size(); i++) {
                String obj = array.getString(i);//.getJSONObject(i);
                userIds.add(obj);
            }

            TaskRecord one = taskRecordService.findOne(mapMessage.getString("recordId"));
            TaskDBThread th = new TaskDBThread(taskNoticeService, ossOperatorService, userId, userName,
                    bizId, userIds, tskTaskBizService, uploadDir);
            //threadPoolTaskExecutor.execute(th);
            Future<?> future = threadPool.submit(th);
            String failReason = null;
            try {
                // 等待计算结果，最长等待timeout秒，timeout秒后中止任务
                Object o = future.get(60, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                failReason = "主线程在等待返回结果时被中断！";
                one.setState(4);
                one.setRemark(failReason);
                taskRecordService.save(one);
            } catch (ExecutionException e) {
                failReason = "主线程等待返回结果，但任务本身抛出异常！";
                one.setState(4);
                one.setRemark(failReason);
                taskRecordService.save(one);
            } catch (TimeoutException e) {
                failReason = "主线程等待计算结果超时，因此中断任务线程！";
                one.setState(4);
                one.setRemark(failReason);
                taskRecordService.save(one);
            }

        } catch (JMSException e) {
            e.printStackTrace();
        }

    }
}
