package com.geoway.landteam.landcloud.service.jms.service.factory;

//import com.geoway.land.core.activemq.service.IConsumerStrategyJsonService;
//import com.geoway.land.core.activemq.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyJsonService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class StrategyServiceFactory implements ApplicationContextAware {

    private static final Map<String, IConsumerStrategyService> serviceMap = new HashMap<>();

    private static final Map<String, IConsumerStrategyJsonService> jsonServiceMap = new HashMap<>();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, IConsumerStrategyService> map = applicationContext.getBeansOfType(IConsumerStrategyService.class);
        for (String key : map.keySet()) {
            IConsumerStrategyService service = map.get(key);
            serviceMap.put(service.getCode(), service);
        }

        /*Map<String, IConsumerStrategyJsonService> jMap = applicationContext.getBeansOfType(IConsumerStrategyJsonService.class);
        for (String key : jMap.keySet()) {
            IConsumerStrategyJsonService service = jMap.get(key);
            jsonServiceMap.put(service.getCode(), service);
        }*/
    }

    public static IConsumerStrategyService getService(String serviceName) {
        return serviceMap.get(serviceName);
    }

    public static IConsumerStrategyJsonService getJsonService(String serviceName) {
        return jsonServiceMap.get(serviceName);
    }
}
