package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.Tbgst;
import com.geoway.landteam.customtask.repository.pub.TbgstRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.DbResolverProvider;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.jms.MapMessage;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author Waves
 * @Date 2023/8/7
 * @Description
 **/
@Service
public class ImageCaptureConsumer implements IConsumerStrategyService {

    GiLoger logger = GwLoger.getLoger(ImageCaptureConsumer.class);

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;

    @Autowired
    protected SysConfigService sysConfigService;
    @Autowired
    protected DbResolverProvider dbResolverProvider;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TbgstRepository tbgstRepository;

    @Autowired
    DataBizService dataBizService;

    @Autowired
    TskTaskBizService taskBizService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Override
    public String getCode() {
        return "IMAGE-CAPTURE";
    }

    private static final List<String> TAGS = Arrays.asList("QSX","HSX","GL");

    @Override
    public void execute(MapMessage mapMessage) {
        String messageId="";
        try {
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\","");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File recvFile = null;
            if(StringUtils.isNotBlank(storageType)){
                if("0".equals(storageType.trim())){ //共享文件路径
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new","/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                }else if("1".equals(storageType.trim())){ //Ftp方式
                    String storageUrl =  mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/"+purl.substring(0,purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/")+1,purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?")+1,purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];

                    recvFile = buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip,Integer.valueOf(port),userName,possWord);
                    if(ftpClient != null){
                        try {
                            FileUtils.copyInputStreamToFile(FtpUtil.getFTPFileInputStream(ftpClient,filepath,fileName), recvFile);
                        }  catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            //关闭ftp连接
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                }else if("2".equals(storageType.trim())){ //文件存储
                    String objectStorag = mapMessage.getString("objectStorage");
                    if(StringUtils.isNotBlank(objectStorag)){
                        URL url = new URL(objectStorag);
                        HttpURLConnection conn = null;
                        if (url != null) {
                            conn = (HttpURLConnection) url.openConnection();
                            conn.setConnectTimeout(3 * 1000);
                            conn.setRequestProperty("Charset", "UTF-8");
                            recvFile = buildTempUploadFile();
                            FileUtils.copyInputStreamToFile(conn.getInputStream(), recvFile);
                        }
                        conn.disconnect();
                    }
                }
            }
            resove(recvFile);
            // 删除文件夹
            FileUtils.deleteQuietly(recvFile);
        } catch (Exception e) {
            logger.error(e);
        }
        finally {
            if(StringUtils.isNotBlank(messageId))
            {
                try {
                    JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRequestById(messageId, transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex)
                {
                    logger.error("网间传输回调异常"+ ExceptionUtil.getErrorString(ex));
                }
            }
        }
    }

    protected  void resove(File recvFile) throws Exception {

        String zipName = recvFile.getAbsolutePath();
        String unzipFileDir = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
        //解压文件路径
        FileUtil.creatDirectoryIfNotExist(unzipFileDir);
        //解压文件
        Zip4jUtils.unzip(zipName, unzipFileDir, "",true);
        File file = new File(unzipFileDir);
        File[] contents = file.listFiles();
        File metaFile = Arrays.stream(contents).filter( f -> f.getName().endsWith("json")).findFirst().orElseThrow(() -> new RuntimeException("缺少元数据"));
        String mateInfo = FilenameUtils.getBaseName(metaFile.getAbsolutePath());
        String[] mateInfos = mateInfo.split("\\.");
        String objType = mateInfos[0];
        String objectid = mateInfos[1];
        JSONObject meta =  readMeta(metaFile);
        for(File content:contents){
            if(content.isDirectory()){
                 resolveDir(content,objType,objectid,meta);
            }
        }
        // 删除文件夹
        FileUtils.deleteQuietly(new File(unzipFileDir));

    }

    public static JSONObject readMeta(File file) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            String encoding = "UTF-8";
            if(file.isFile() && file.exists()){ //判断文件是否存在
                InputStreamReader read = new InputStreamReader(
                        new FileInputStream(file),encoding);//考虑到编码格式
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while((lineTxt = bufferedReader.readLine()) != null){
                    sb.append(lineTxt);
                }
                read.close();
            }else{
                throw new Exception("找不到指定的Json文件");
            }
            String meta =  sb.toString();
            return JSONObject.parseObject(meta);
        } catch (Exception e) {
            throw e;
        }
    }
    protected void resolveDir(File dir, String objectType, String objectId, JSONObject metainfo){
        String tag = FilenameUtils.getName(dir.getAbsolutePath());
        if(!TAGS.contains(tag)){
            return;
        }
        Set<String>tbids = new HashSet<>();
        File[] contents = dir.listFiles();
        for(File content:contents){
            if(content.isFile()){
                upload(content,tag,objectType,objectId,metainfo,tbids);
            }
        }
        if(!tbids.isEmpty())
        {
           TbtskObjectinfo objectinfo = taskBizService.findTableByTaskId(objectId);
           if(objectinfo!=null)
           {
               if(!TableUtil.hasField(objectinfo.getfTablename(),"f_updatetime",jdbcTemplate))
               {
                   TableUtil.addField(objectinfo.getfTablename(),"f_updatetime",jdbcTemplate);
               }
               Map<String,Object>up = new HashMap<>();
               up.put("f_updatetime",String.valueOf(System.currentTimeMillis()));
               String  where = "f_id in ('"+StringUtils.join(tbids,"','")+"')";
               dataBizService.updateData(objectinfo.getfTablename(),up,where);
               tbids.clear();
           }
        }
    }

    protected void upload(File content,String tag,String objectType,String objectId, JSONObject metainfo,Set<String>tbids){
        try {
            String fileName = FilenameUtils.getName(content.getAbsolutePath());
            String id = FilenameUtils.getBaseName(content.getAbsolutePath());
            tbids.add(id);
            String osskey = "/imageCapture/" + objectType + "/" + objectId + "/" + tag + "/" + fileName;
            Integer tagIdx = TAGS.indexOf(tag) + 1;
            String phase = metainfo.getString(tag.toLowerCase());
            String url = ossOperatorService.sendObject2Oss(osskey,content);
            Tbgst tbgst = new Tbgst();
            tbgst.setId(UUID.randomUUID().toString());
            tbgst.setBizId(objectId);
            tbgst.setTbId(id);
            tbgst.setCreateTime(new Date());
            tbgst.setBizType(Integer.valueOf(objectType));
            tbgst.setType(String.valueOf(tagIdx));
            tbgst.setUrl(url);
            tbgst.setPhase(phase);
            tbgstRepository.save(tbgst);
        }catch (Exception e){
            logger.error(e);
        }
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("capture-%s-%s.zip", sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if(uploadDir == null){
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }
}
