package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterDataTransmitAcceptService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TranFileUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.jms.MapMessage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.networkTransmission.service
 * @date 2022/4/20 16:30
 */
@Slf4j
@Service
/*@Transactional(rollbackFor = {Exception.class})*/
public class InnerDataTransmitAcceptService implements IConsumerStrategyService {
    private final GiLoger logger = GwLoger.getLoger(InnerDataTransmitAcceptService.class);
    @Value("${project.uploadDir}")
    String uploadDir;


    @Value("${transmit.url:}")
    String transmitUrl;

    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    InnerPatrolTaskTransmitAcceptService innerPatrolTaskTransmitAcceptService;
    @Autowired
    InnerUserTransmitAcceptService innerUserTransmitAcceptService;
    @Autowired
    InnerUserTrackTransmitAcceptService innerUserTrackTransmitAcceptService;
    @Autowired
    InnerTaskTransmitAcceptService innerTaskTransmitAcceptService;
    @Resource
    TemporarySignedUrlService temporarySignedUrlService;

    @Override
    public String getCode() {
        return "INNER-RECEIVE-MESSAGE";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        String messageId="";
        try {
          /*  String appkey = mapMessage.getString("appkey");
            String module = mapMessage.getString("module");*/
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\","");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File zipFile = null;
            if(StringUtils.isNotBlank(storageType)){
                if("0".equals(storageType.trim())){ //共享文件路径
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new","/mnt/smb/baseout-new/");
                    zipFile = new File(recvpath);
                }else if("1".equals(storageType.trim())){ //Ftp方式
                    String storageUrl =  mapMessage.getString("storageUrl");
                    if(StringUtils.isNotBlank(storageUrl)){
                        String ipport = storageUrl.split("//")[1];
                        String ip = ipport.split(":")[0];
                        String port = ipport.split(":")[1];
                        String purl = storageUrl.split("//")[2];
                        String filepath = "/"+purl.substring(0,purl.lastIndexOf("/"));
                        String fileName = purl.substring(purl.lastIndexOf("/")+1,purl.lastIndexOf("?"));
                        String ebString = purl.substring(purl.lastIndexOf("?")+1,purl.length());
                        String userNamePoss = AESECB.decrypt(messageId, ebString);
                        String userName = userNamePoss.split(":")[0];
                        String possWord = userNamePoss.split(":")[1];

                        zipFile = buildTempUploadFile("101");
                        FTPClient ftpClient = FtpUtil.getFtpClient(ip,Integer.valueOf(port),userName,possWord);
                        if(ftpClient != null){
                            try {
                                FileUtils.copyInputStreamToFile(FtpUtil.getFTPFileInputStream(ftpClient,filepath,fileName), zipFile);
                            }  catch (Exception e) {
                                e.printStackTrace();
                            } finally {
                                //关闭ftp连接
                                FtpUtil.disConnection(ftpClient);
                            }
                        }
                    }
                }else if("2".equals(storageType.trim())){ //文件存储
                    String objectStorag = mapMessage.getString("objectStorage");
                    //objectStorag = temporarySignedUrlService.getTemporarySignedUrl("", objectStorag, null);
                    if(StringUtils.isNotBlank(objectStorag)){
                        URL url = new URL(objectStorag);
                        HttpURLConnection conn = null;
                        if (url != null) {
                            conn = (HttpURLConnection) url.openConnection();
                            conn.setConnectTimeout(3 * 1000);
                            conn.setRequestProperty("Charset", "UTF-8");
                            zipFile = buildTempUploadFile("101");
                            FileUtils.copyInputStreamToFile(conn.getInputStream(), zipFile);
                        }
                        conn.disconnect();
                    }
                }
            }
            String zipName = zipFile.getAbsolutePath();
            // String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            String unzipFileDir = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            //解压文件路径
           FileUtil.creatDirectoryIfNotExist(unzipFileDir);
            //解压文件
            Zip4jUtils.unzip(zipName, unzipFileDir, "");
            //解析数据入库
            resolveFiles(unzipFileDir);
            // 删除文件夹
            FileUtils.deleteQuietly(new File(unzipFileDir));
            FileUtils.deleteQuietly(zipFile);
            //调用网间传输回调接口
          /*  String transmitUrl = this.transmitUrl+"/monitor/trans/feedBack.action";
            JSONObject result = HttpUtil.sendRequestById(messageId ,transmitUrl);*/
        } catch (Exception e) {
            logger.error("接收外网推送数据包异常"+ ExceptionUtil.getErrorString(e));
        }
        finally {
            if(StringUtils.isNotBlank(messageId))
            {
                try {
                    JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRequestById(messageId, transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex)
                {
                    logger.error("网间传输回调异常"+ ExceptionUtil.getErrorString(ex));
                }
            }
        }
    }

    public void resolveFiles(String unzipFileDir) throws Exception {
            File file = new File(unzipFileDir);
            File dbFile = null;
            File jsonFile = null;
            File[] content = file.listFiles();
            Map<String,String> fileMap = new HashMap<>();
            for (int j = 0, ln = content.length; j < ln; ++j) {
                if (content[j].getName().endsWith(".json")) {
                    jsonFile = content[j];
                }else if (content[j].getName().endsWith(".db")) {
                    dbFile = content[j];
                }else{
                    File mediafile =  content[j];
                    String fiename = mediafile.getName();
                    String sendObjName = "patrolTaskTran/media/" + fiename;
                    // 上传到obs
                    String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, mediafile);
                    fileMap.put(fiename,resultUrl);
                }
            }
            String jsonContext = TranFileUtil.readFile(jsonFile.getAbsolutePath());
            JSONObject jsonObject = JSONObject.parseObject(jsonContext);
            String group = jsonObject.getString("group");
            if(StringUtils.isNotBlank(group)) {
                switch (group) {
                    case "patrol": { //巡查任务
                        innerPatrolTaskTransmitAcceptService.execute(jsonObject,fileMap,dbFile);
                    }
                    break;
                    case "user":{ //用户信息
                        innerUserTransmitAcceptService.execute(jsonObject,fileMap,dbFile);
                    }
                    break;
                    case "userTrack":{ //用户轨迹数据
                        innerUserTrackTransmitAcceptService.execute(jsonObject,fileMap,dbFile);
                    }
                    break;
                    case "task":{ //调查任务数据
                        innerTaskTransmitAcceptService.execute(jsonObject,fileMap,dbFile);
                    }
                    break;
                    default: {
                        throw new GwValidateException("数据类型错误");
                    }
                }
            }
    }



    private File buildTempUploadFile(String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("tran-%s-%s-%s.zip", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if(uploadDir == null){
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }

}
