package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.service.util.TbbhUtil;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.mapper.pub.DmDictValueMapper;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.DmDictValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.File;
import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.networkTransmission.service
 * @date 2022/3/1 16:19
 */
@Slf4j
@Service
@Transactional(rollbackFor = {Exception.class})
public class InnerPatrolTaskTransmitAcceptService {

    @Value("${project.uploadDir}")
    String uploadDir;
    @Autowired
    TbbhUtil tbbhUtil;
    @Autowired
    RegionService regionService;
    @Resource
    private DmDictValueMapper dictValueDao;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Resource
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    private LandUserService landuserService;

    public void execute(JSONObject jsonObject, Map<String,String> fileMap, File dbFile) {
        try {
            String mode = jsonObject.getString("mode");
            String taskName = jsonObject.getString("taskName");
            Long userId = jsonObject.getLong("userId");
            handDbFile(dbFile,fileMap,taskName,userId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 处理DB文件
     * @param dbFile
     */
    public void handDbFile( File dbFile,Map<String,String>  fileMap,String taskId,Long userId) throws Exception {
        try {
            // 获取DB文件数据库连接
            SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(sysConfig.getValue()).orElse(null);
            TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
            List<TbtskFields> tbtskFieldsByTableid = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            List<String> collect = tbtskFieldsByTableid.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            List<DmDictValue> dmDictValues = dictValueDao.queryTop(10012510L);
            //处理任务图斑表
            String sql = "select * from media";
            ResultSet rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                String f_id = rs.getString("f_id");
                Map mapdata = dataBizService.selectByID("tb_app_media", "f_id", "'"+f_id+"'");
                int rowSize = metaData.getColumnCount();
                Map<String, Object> map = new HashMap<>();
                for (int i = 1; i <= rowSize; i++) {
                    String labelName = metaData.getColumnName(i);
                    Object obj = rs.getObject(labelName);
                    map.put(labelName, obj);
                }
                String f_serverpath = map.get("f_serverpath").toString();
                String fiename = f_serverpath.substring(f_serverpath.lastIndexOf("/") + 1, f_serverpath.length());
                map.put("f_serverpath",fileMap.get(fiename));
                map.put("f_bizid",tskTaskBiz.getId());
                map.put("f_username",landuserService.queryUserById(userId).getName());
                if(mapdata == null){
                    dataBizService.insertData("tb_app_media",map,null);
                }else{
                    dataBizService.updateData("tb_app_media", map, " f_id = '" + f_id + "'");
                }
            }
            //处理图斑数据表
            String dataSql = "select * from  basic";
            ResultSet  dataRs = statement.executeQuery(dataSql);
            List<Map<String, Object>> datalist = new ArrayList<>();
            while (dataRs.next()) {
                handXsData(dataRs,datalist,userId,collect,dmDictValues);
            }
            //批量增加巡查任务线索数据
            dataBizService.insertDatasBatchByTimeStamp(tableInfo.getfTablename(), datalist, "f_shape");
            // 关闭连接并删除缓存文件
            connPool.closeAll(connection, statement, rs);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    //保存线索数据
   public void handXsData(ResultSet  resultSet, List<Map<String, Object>> datalist,Long userId,List<String> collect,List<DmDictValue> dmDictValues)
           throws Exception {
       Map<String, Object> map = new HashMap<>();
       Double lon = resultSet.getDouble("f_lon");
       Double lat = resultSet.getDouble("f_lat");
       map.put("f_id", resultSet.getString("f_id"));
       map.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
       map.put("f_review_stage", 93);
       map.put("f_lon", lon);
       map.put("f_lat",lat);
       map.put("f_createtime", System.currentTimeMillis() + "");
       map.put("f_committime", System.currentTimeMillis() + "");
       map.put("f_userid", userId.toString());
       map.put("f_upload_userid", userId.toString());
       map.put("f_submit_userid", userId.toString());
       map.put("f_ismy", "0");
       completeBasicRegionInfo(map, lon, lat);
       map.put("f_tbmc", resultSet.getString("f_name"));
       map.put("f_tbmj", resultSet.getDouble("f_mj"));
       Object objShape = resultSet.getObject("f_shape");
       if (objShape != null && StringUtils.isNotBlank(objShape.toString())) {
           map.put("f_shape", objShape.toString());
           map.put("f_shape1", objShape.toString());
       }
       fillRequiredFieldNames(map,collect,resultSet,userId,dmDictValues);
       datalist.add(map);
   }


    private void completeBasicRegionInfo(Map<String, Object> map,Double lon,Double lat ) throws Exception {
        if (lon == null || lat == null) {
            return;
        }
        String wkt = "POINT(" + lon + " " + lat + ")";
        RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);
        if (region == null) {
            // 由于行政区缝隙或地级市找不到行政区代码，先查询市级行政区代码
            region = regionService.queryRegionByGeom(wkt, 4490, 2);
        }
        if (region == null) {
            map.put("f_xzqdmsys", null);
            map.put("f_xzqdm", null);
            return;
        }
        String county = "";
        String city = "";
        String province = "";

        if (region.getLevel() == 3) {
            county = region.getCode();
           /* city = region.getPcode();
            province = regionService.findRegionByCode(city).getPcode();*/
        } else if (region.getLevel() == 2) {
            /*city = region.getCode();
            province = region.getPcode();*/
        }
        RegionVillage village = regionService.queryVillageCotain(wkt, 0);
        map.put("f_xzqdmsys", village != null ? village.getCode() : county);
        map.put("f_xzqdm", county);
    }


    //添加线索任务字段
    private void fillRequiredFieldNames(Map<String, Object> map, List<String> collect, ResultSet  resultSet, Long userId, List<DmDictValue> dmDictValues) throws SQLException {
        if (collect.contains("f_xsmc")) {
            map.put("f_xsmc", resultSet.getString("f_heading"));
        }
        if (collect.contains("f_jhID")) {
            map.put("f_jhid", resultSet.getString("f_jhid"));
        }
        if (collect.contains("f_xsrwID")) {
            map.put("f_xsrwid", resultSet.getString("f_xsrwid"));
        }
        if (collect.contains("f_xsbh") && map.get("f_xzqdmsys") != null
                && StringUtils.isNotBlank(map.get("f_xzqdmsys").toString())) {
            String xsbh = tbbhUtil.generateTbbh(map.get("f_xzqdmsys").toString(), "TB", tbbhUtil.getUserLevelCode(userId));
            map.put("f_xsbh", xsbh);
            map.put("f_tbbh", xsbh);
        }
        if (collect.contains("f_xzqmc") && map.get("f_xzqdm") != null && StringUtils.isNotBlank(map.get("f_xzqdm").toString())) {
            map.put("f_xzqmc", regionService.getName(map.get("f_xzqdm").toString()));
        }
        if (collect.contains("f_xsms") && StringUtils.isNotBlank(resultSet.getString("f_desc"))) {
            map.put("f_xsms", resultSet.getString("f_desc"));
        }
        if (collect.contains("f_wfdd")) {
            map.put("f_wfdd", resultSet.getString("f_name"));
        }
        if (collect.contains("f_xcsj")) {
            map.put("f_xcsj", new Timestamp(System.currentTimeMillis()));
        }
        if (collect.contains("f_yswflx")  && StringUtils.isNotBlank(resultSet.getString("f_type"))) {
            String type = resultSet.getString("f_type");
            for (DmDictValue dmDictValue : dmDictValues) {
                if (dmDictValue.getName().equalsIgnoreCase(resultSet.getString("f_type"))) {
                    type = dmDictValue.getCode();
                }
            }
            map.put("f_yswflx", type);
        }
        if (collect.contains("f_xslx")) {
            List<DmDictValue> dmDictValues1 = dictValueDao.queryTop(10012511L);
            String type = resultSet.getString("f_xslx");
            for (DmDictValue dmDictValue : dmDictValues1) {
                if (dmDictValue.getName().equalsIgnoreCase(resultSet.getString("f_xslx"))) {
                    type = dmDictValue.getCode();
                }
            }
            map.put("f_xslx", type);
        }
        if (collect.contains("f_xcry")) {
            map.put("f_xcry", landuserService.queryUserById(userId).getName());
        }
    }
}
