package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.networkTransmission.service
 * @date 2022/3/5 15:08
 */
@Service
public class InnerProgramTransmitService {

    private GiLoger logger = GwLoger.getLoger(InnerProgramTransmitService.class);
    @Resource
    ProducerService producerService;

    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.task.appkey:}")
    String transmitAppkey;
    @Value("${transmit.task.module:}")
    String transmitModule;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    public void syncPatrolPlanAndTask(JSONObject object) throws Exception {
        String type = object.getString("type");
        Long userId = object.getLongValue("operUserId");
        if(StringUtils.isNotBlank(type)){
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UUID.randomUUID().toString()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 02.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();
            //JSONObject jsonObject = new JSONObject();
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(JSONObject.toJSONString(object,SerializerFeature.WriteMapNullValue));
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            String url  =  afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            JSONObject result = HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix + ".zip"), transmitUrl+"/monitor/trans/transData.action");
          /*  publishTranMsg(fileNameNoSuffix + ".zip");*/
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
            FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
    }
    }


    /**
     * 压缩文件
     * @param userId
     * @param tempFolderPath
     * @param safeFileName
     * @param fileNameNoSuffix
     * @return
     */
    public  String afterExport(Long userId,String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url ="";
        logger.info( " 开始压缩成zip文件 ");
        Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", false, "");
        //url =  uploadFileToCloudDisk(userId, safeFileName);
        return url;
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */


    public  String  uploadFileToCloudDisk(Long userId, String safeFileName) {
        // 注意：这里不能用File.separator 替代"/"，OBS上路径分隔符用"/",而File.separator默认为:"\"
        String sendObjName = "userTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 上传到obs
        String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }


    /**
     * 发送消息
     * @param url
     */
    public void publishTranMsg(String url) {
        try {
            String queueName = "Base-Outer-Tran";
            logger.info("发送同步消息队列名称：" + queueName + " 内容：" + url);
            //producerService.sendMessage(queueName, bytes);
            Map<String, Object> map = new HashMap<>();
            map.put(ActiveMQConstant.SERVICE_NAME, "OUTER-RECEIVE-MESSAGE");
            map.put("appkey",  PropertyUtil.getProperty("transmit.appkey"));
            map.put("module",  PropertyUtil.getProperty("transmit.module"));
            map.put("name", "测试");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "OUTER-RECEIVE-MESSAGE");
            producerService.sendMapMessage2Queue(map, queueName);
        } catch (Exception e) {
            logger.error("发送同步消息异常：", e);
        }
    }
}
