package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.task.TbtskRevokeRecordDao;
import com.geoway.landteam.customtask.dao.task.TbtskSubmitReportRecordDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskRejectRecordRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorValueService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.cgjcyj.MCgjcyjTaskService;
import com.geoway.landteam.landcloud.service.customtask.resultshare.impl.MAnalysisTaskServiceImpl;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueImportTaskRelDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueImportTaskRelFieldsDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSourceDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueTaskRelDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRel;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRelFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueTaskRel;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.sql.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission
 * @date 2022/2/24 16:44
 */
@Slf4j
@Service
public class InnerTaskTransmitAcceptService {

    private final GiLoger logger = GwLoger.getLoger(InnerTaskTransmitAcceptService.class);

    @Value("${project.uploadDir}")
    String uploadDir;
    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    EnumeratorValueService enumeratorValueService;
    @Autowired
    EnumeratorDomainService enumeratorDomainService;
    @Autowired
    TbtskTaskClassService tbtskTaskClassService;
    @Resource
    AppMediaRepository appMediaRepository;

    @Autowired
    JcClueImportTaskRelDao jcClueImportTaskRelDao;

    @Autowired
    JcClueImportTaskRelFieldsDao jcClueImportTaskRelFieldsDao;

    @Autowired
    JcClueTaskRelDao jcClueTaskRelDao;

    @Autowired
    JcClueSourceDao jcClueSourceDao;
    @Autowired
    MCgjcyjTaskService cgjcyjTaskService;
    @Resource
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Resource
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Resource
    TbtskRevokeRecordDao tbtskRevokeRecordDao;
    @Resource
    TbtskSubmitReportRecordDao tbtskSubmitReportRecordDao;
    @Resource
    DataBizMapper dataBizMapper;


    public void execute(com.alibaba.fastjson.JSONObject jsonObject, Map<String,String> fileMap, File dbFile) {
        try {
             String taskId = jsonObject.getString("taskId");
             String mode = jsonObject.getString("mode");
             Long userId = jsonObject.getLong("userId");
              handDbFile(dbFile,fileMap,taskId,jsonObject);
            // 删除文件夹
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 处理DB文件
     * @param dbFile
     */
    public void handDbFile( File dbFile,Map<String,String>  fileMap,String taskId,com.alibaba.fastjson.JSONObject jsonObject){
        try {
            logger.info("外网举证数同步内网,任务id:"+taskId);

            SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
            CgjcyjConfig cgjcyjConfig= cgjcyjTaskService.getConfig();
            // 获取DB文件数据库连接
            SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            //TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
            JcClueImportTaskRel clueImportTaskRel=null;
            List<JcClueImportTaskRelFields>updatesFields=null;
            Map<String,String>updateFieldMap = null;
            List<Map<String,Object>>updateDatas =null;
            JcClueSource clue = null;
            if(cgjcyjConfig!=null) {
                //如果是常规监测，则同步数据 进行监测预警

                int count =  jcClueTaskRelDao.getCuleTaskCountBySourceAndTask(taskId,cgjcyjConfig.getRelId());
                if(count>0)
                {
                    logger.info("常规监测预警同步线索,线索id:"+cgjcyjConfig.getRelId()+" 任务id:"+taskId);
                    clue = jcClueSourceDao.gwSearchByPK(cgjcyjConfig.getRelId());
                    if(clue==null)
                    {
                        logger.error("常规监测预警同步线索,同步任务数据到线索进行常规监测预警失败,未找到线索,线索id:"+cgjcyjConfig.getRelId()+" 任务id:"+taskId);
                    }
                    else {
                        updateFieldMap = new HashMap<>();
                        updateDatas = new ArrayList<>();
                        updateFieldMap.put(cgjcyjConfig.getFieldEjdlTask(), cgjcyjConfig.getFieldEjdl());
                        updateFieldMap.put(cgjcyjConfig.getFieldYjdlTask(), cgjcyjConfig.getFieldYjdl());
                    }
                }
                /* 映射方案不全
                List<JcClueImportTaskRel>clueImportTaskRels =  jcClueImportTaskRelDao.findClueMapperSchemes(cgjcyjConfig.getRelId(), taskId, "1");
                if(clueImportTaskRels!=null&&!clueImportTaskRels.isEmpty())
                {
                    logger.info("常规监测预警同步线索,线索id:"+cgjcyjConfig.getRelId()+" 任务id:"+taskId);
                    clueImportTaskRel = clueImportTaskRels.get(0);
                    List<JcClueImportTaskRelFields>relFields =  jcClueImportTaskRelFieldsDao.selectByRelId(clueImportTaskRel.getfId());
                    updatesFields =  relFields.stream().filter(t->t.getfOriFieldname().equals(cgjcyjConfig.getFieldYjdl())||t.getfOriFieldname().equals(cgjcyjConfig.getFieldEjdl())).collect(Collectors.toList());
                    if(updatesFields!=null&&!updatesFields.isEmpty())
                    {
                        clue = jcClueSourceDao.gwSearchByPK(cgjcyjConfig.getRelId());
                        if(clue==null)
                        {
                            logger.error("常规监测预警同步线索,同步任务数据到线索进行常规监测预警失败,未找到线索,线索id:"+cgjcyjConfig.getRelId()+" 任务id:"+taskId);
                        }
                        else {
                            updateFieldMap = new HashMap<>();
                            updateDatas = new ArrayList<>();
                            for (JcClueImportTaskRelFields f : updatesFields) {
                                updateFieldMap.put(f.getfTarFieldname(), f.getfOriFieldname());
                            }
                        }

                    }
                    else
                    {
                        logger.error("常规监测预警同步线索,同步任务数据到线索进行常规监测预警失败,未找到映射字段，线索id:"+cgjcyjConfig.getRelId()+" 任务id:"+taskId);
                    }

                }
                */

            }
            if(updateFieldMap!=null)
            {
                for (Map.Entry<String ,String >kv:updateFieldMap.entrySet()) {
                    logger.info("常规监测预警同步线索 field-target:"+kv.getKey()+" field-source:"+kv.getValue());
                }
            }
           TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
            //处理任务附件数据
            String sql = "select * from media";
            ResultSet  rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                    int rowSize = metaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = metaData.getColumnName(i);
                        Object obj = rs.getObject(labelName);
                        //logger.error("media labelName:"+labelName+" value:"+(obj==null?"":obj.toString()));
                        if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                         continue;
                        }else{
                            map.put(labelName, obj);
                        }
                    }
                   String f_serverpath = map.get("f_serverpath").toString();
                String fiename = f_serverpath.substring(f_serverpath.lastIndexOf("/") + 1, f_serverpath.length());
               map.put("f_serverpath",fileMap.get(fiename));
                map.put("f_bizid",taskId);
                //除去_开头的字段
                Iterator<String> iterator = map.keySet().iterator();
                while (iterator.hasNext()){
                    String next = iterator.next();
                    if(next.startsWith("_")){
                        iterator.remove();
                    }
                    if(next.equals("f_isApply")){
                        iterator.remove();
                    }
                    if(next.equals("f_yuntai")){
                        iterator.remove();
                    }
                    if(next.equals("f_altitude")){
                        iterator.remove();
                    }
                    if(next.equals("f_localpath")){
                        iterator.remove();
                    }
                }
                AppMedia one = appMediaRepository.findById(map.get("f_id").toString()).orElse(null);
                if(one == null){
                    //logger.error("media obj:"+ JSONObject.toJSONString(map));
                    //dataBizService.insertData("tb_app_media",map,null);
                    dataBizMapper.insertWithoutJudge("tb_app_media",map,null);
                }
            }

            //处理图斑数据表
            String dataSql = "select * from  "+table.getfTablename();
            if(table.getfTablename().contains(".")){
                String[] split = table.getfTablename().split("\\.");
                dataSql = "select * from  "+split[1];
            }
            ResultSet  dataRs = statement.executeQuery(dataSql);
            ResultSetMetaData datametaData = dataRs.getMetaData();
            List<Map<String, Object>> datalist = new ArrayList<>();
         /*   //违法类型字段转化
            EnumeratorValue ev = enumeratorValueService.findOneByKey("DIC_WFLX");
            List<EnumeratorDomain> enumList = enumeratorDomainService.findByDicno(ev.getDicno());*/
            while (dataRs.next()) {
                String f_id = dataRs.getString("f_id");
                Map mapdata = dataBizService.selectFieldByID(table.getfTablename(), Arrays.asList("f_id",
                        "f_xzqdmsys","f_tbbh"),"f_id", "'"+f_id+"'");
                String xzqdm = MapUtils.getString(mapdata, "f_xzqdmsys");
                int rowSize = datametaData.getColumnCount();
                Map<String, Object> map = new HashMap<>();
                Map<String, Object> updateMap=null;
                if(updateFieldMap!=null){
                    updateMap = new HashMap<>();
                    List<String>tbids = new ArrayList<>();
                    tbids.add(f_id);
                    List<JcClueTaskRel>clueTaskRels = jcClueTaskRelDao.getClueTaskRelsByTbids(cgjcyjConfig.getRelId(),taskId,tbids);
                    if(clueTaskRels==null||clueTaskRels.isEmpty())
                    {
                        logger.error("常规监测预警同步线索,任务图斑:"+f_id+"未找到对应得线索图斑,线索id:"+cgjcyjConfig.getRelId()+" 任务id:"+taskId);
                    }else {
                        updateMap.put(cgjcyjConfig.getFieldUniqueId(), clueTaskRels.get(0).getfClueid());
                    }
                }
                for (int i = 1; i <= rowSize; i++) {
                    String labelName = datametaData.getColumnName(i);
                    Object obj = dataRs.getObject(labelName);
                    if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                        continue;
                    }else{
                        map.put(labelName, obj);
                        if(updateFieldMap!=null&&updateFieldMap.containsKey(labelName))
                        {
                            updateMap.put(updateFieldMap.get(labelName),obj);
                        }
                    }
                }
                if(updateMap!=null&&!updateMap.isEmpty()&&updateMap.size()>1)
                {
                    updateDatas.add(updateMap);
                }
                if(sysConfig !=null && sysConfig.getValue().equals(taskId)){
                    map.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
                    map.put("f_review_stage", ReviewStageEnum.COUNTY_VERIFY.getCode());
                }
                if(map.containsKey("f_shape") && map.get("f_shape")!= null && !map.get("f_shape").toString().contains(";")){
                    map.put("f_shape", "SRID=4490;"+map.get("f_shape").toString());
                }
                if (mapdata == null) {
                    dataBizService.insertData(table.getfTablename(),map, "f_shape");
                }else{
                    if(!map.containsKey("f_tbbh")){
                        String f_tbbh = MapUtils.getString(mapdata, "f_tbbh");
                        if(StringUtils.isBlank(f_tbbh)){
                            map.put("f_tbbh", getTbbh(xzqdm));
                        }
                    }
                    dataBizService.updateData(table.getfTablename(), map, " f_id = '" + f_id + "'");
                }
            }
            if(updateFieldMap!=null&&!updateFieldMap.isEmpty()) {
                if (updateDatas == null || updateDatas.isEmpty()) {
                    logger.info("常规监测预警同步线索,无同步数据，线索id:" + cgjcyjConfig.getRelId() + " 任务id:" + taskId);
                } else {
                    cgjcyjTaskService.UpdateClue(updateDatas, clue, taskId);
                }
            }
            //判断任务是否存在子图斑
            if(org.apache.commons.lang3.StringUtils.isNotBlank(table.getSplitTableName() )){
                String childtableName = table.getSplitTableName();
                if(childtableName.contains(".")){
                    String[] split = childtableName.split("\\.");
                    childtableName = split[1];
                }
                if(existTable(statement,childtableName)) {
                    sql = "select * from " + childtableName;
                    ResultSet resultSet = statement.executeQuery(sql);
                    ResultSetMetaData datametaData1 = resultSet.getMetaData();
                    while (resultSet.next()) {
                        String f_id = resultSet.getString("f_id");
                        Map mapdata = dataBizService.selectFieldByID(table.getSplitTableName(), Arrays.asList("f_id","f_xzqdmsys","f_tbbh"),"f_id", "'"+f_id+"'");
                        String xzqdm = MapUtils.getString(mapdata, "f_xzqdmsys");
                        int rowSize = datametaData1.getColumnCount();
                        Map<String, Object> map = new HashMap<>();
                        for (int i = 1; i <= rowSize; i++) {
                            String labelName = datametaData1.getColumnName(i);
                            Object obj = resultSet.getObject(labelName);
                            if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                continue;
                            }else{
                                map.put(labelName, obj);
                            }
                        }
                        if(map.containsKey("f_shape") && map.get("f_shape")!= null && !map.get("f_shape").toString().contains(";")){
                            map.put("f_shape", "SRID=4490;"+map.get("f_shape").toString());
                        }
                        if (mapdata == null) {
                            dataBizService.insertData(table.getSplitTableName(),map, "f_shape");
                        }else{
                            if(!map.containsKey("f_tbbh")){
                                String f_tbbh = MapUtils.getString(mapdata, "f_tbbh");
                                if(StringUtils.isBlank(f_tbbh)){
                                    map.put("f_tbbh", getTbbh(xzqdm));
                                }
                            }
                            dataBizService.updateData(table.getSplitTableName(), map, " f_id = '" + f_id + "'");
                        }
                    }
                }
            }
            //处理审核相关数据jsonObject
            if(jsonObject.containsKey("TbtskApproveRecords") && jsonObject.get("TbtskApproveRecords") != null){
                List<TbtskApproveRecord> tbtskApproveRecords = JSONArray.parseArray(jsonObject.get("TbtskApproveRecords").toString(), TbtskApproveRecord.class);
                   if(tbtskApproveRecords.size() > 0){
                       tbtskApproveRecordRepository.gwAccessSelective(tbtskApproveRecords);
                   }
            }
            if(jsonObject.containsKey("TbtskRejectRecords") && jsonObject.get("TbtskRejectRecords") != null){
                List<TbtskRejectRecord> tbtskRejectRecords = JSONArray.parseArray(jsonObject.get("TbtskRejectRecords").toString(), TbtskRejectRecord.class);
                  if(tbtskRejectRecords.size() > 0){
                      tbtskRejectRecordRepository.gwAccessSelective(tbtskRejectRecords);
                  }
            }
            if(jsonObject.containsKey("TbtskRevokeRecords") && jsonObject.get("TbtskRevokeRecords") != null){
                List<TbtskRevokeRecord> tbtskRevokeRecords = JSONArray.parseArray(jsonObject.get("TbtskRevokeRecords").toString(), TbtskRevokeRecord.class);
                if(tbtskRevokeRecords.size() > 0){
                    tbtskRevokeRecordDao.gwAccessSelective(tbtskRevokeRecords);
                }
            }
            if(jsonObject.containsKey("TbtskSubmitReportRecords") && jsonObject.get("TbtskSubmitReportRecords") != null){
                List<TbtskSubmitReportRecord> tbtskSubmitReportRecords = JSONArray.parseArray(jsonObject.get("TbtskSubmitReportRecords").toString(), TbtskSubmitReportRecord.class);
                if(tbtskSubmitReportRecords.size() > 0){
                    tbtskSubmitReportRecordDao.gwAccessSelective(tbtskSubmitReportRecords);
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /**
     * 下发图斑
     * @param userId
     * @param tskTaskBiz
     * @param userIds
     * @param tbIds
     */
    public void assignTask(Long userId, TskTaskBiz tskTaskBiz, List<String> userIds, List<String> tbIds){
        String recordId = UUID.randomUUID().toString();
       // List<String> list = com.alibaba.fastjson.JSONObject.parseArray(com.alibaba.fastjson.JSONObject.toJSONString(tbIds),  String.class);
        List<String> list = tbIds;
        //获取任务
        com.alibaba.fastjson.JSONObject additionJson = new com.alibaba.fastjson.JSONObject();
        additionJson.put("count", tbIds.size());
        // 不管是下发模式还是领取模式的任务，都标记为update，app端对判断如果本地不存在，就将update的数据转为新增
        additionJson.put("addOrUpdate", "UPDATE");
        additionJson.put("taskMode", tskTaskBiz.getMode());
        additionJson.put("curMode", "assign");

        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(null);
        parameter.setTaskId(tskTaskBiz.getId());
        parameter.setOrgs(com.alibaba.fastjson.JSONArray.parseArray(JSON.toJSONString(userIds)));
        parameter.setUserId(userId);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        parameter.setAddition(additionJson);

        //  String paramJSONStr = JSONObject.toJSONString(parameter);
        //将参数添加到任务记录中进行后台处理
        com.alibaba.fastjson.JSONObject params = new com.alibaba.fastjson.JSONObject();
        params.put("filterType", "checkFilter");
        params.put("userId", userId);
        params.put("TaskDataDbParameter", parameter);
        params.put("taskId", tskTaskBiz.getId());
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(com.alibaba.fastjson.JSONObject.toJSONString(params));
        //数据下发3
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);

        List<TaskRecordTemp> tempList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid(list.get(i));
            tempList.add(temp);
        }
        taskRecordService.saveTaskRecordTemp(tempList);
    }
    //插入违法图斑表
    private void InsertIntoWfInfo(TbtskObjectinfo table,String xzqdm,String f_id,String taskId,ResultSetMetaData datametaData, ResultSet resultSet) throws SQLException, ParseException {
        List<String> fields = Arrays.asList("f_hcjl","f_shyj","f_shsm","f_userid","f_xzqdm","f_sfyxzz","f_hcczjy","f_czsj");
        //违法制止表名
        final String WFTaskName = "jc_wf_info";
        //查询是否有改图标的信息
        String sql = "select count(1) from "+WFTaskName+" where f_taskid='"+taskId+"' and f_task_tbid = '"+f_id+"'";
        Long aLong = jdbcTemplate.queryForObject(sql, Long.class);
        //查询sourceid和clueid
        String sourceIdAndClueId = "select f_sourceid,f_clueid from jc_clue_task_rel where f_taskid='"+taskId+"' and " +
                "f_tbid = '"+f_id+"' and f_type ='1'";
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(sourceIdAndClueId);
        //查询线索编号
        String xsbhSql = "select f_tbbh from "+ table.getfTablename()+" where f_id = '"+f_id+"'";
        String xsbh = jdbcTemplate.queryForObject(xsbhSql, String.class);
        String sourceId = "";
        String clueId = "";
        Map<String,Object> insert = new HashMap<>();
        if(maps!=null && maps.size()>0){
            Map<String,Object> map = maps.get(0);
            sourceId = map.get("f_sourceid")!=null ? map.get("f_sourceid").toString():null;
            clueId = map.get("f_clueid")!=null ? map.get("f_clueid").toString():null;

            if (sourceId != null && clueId!=null) {
                //查询线索对应的表名称
                String selectTableName = "select f_tablename from jc_clue_source where f_id = '" + sourceId + "'";
                String tablename= jdbcTemplate.queryForObject(selectTableName, String.class);
                String sqlinfo = " select f_yswflx from "+tablename +" where f_id='"+clueId+"'";
                List<Map<String, Object>> list = jdbcTemplate.queryForList(sqlinfo);
                if(!list.isEmpty()){
                    Map<String,Object> map1 = list.get(0);
                    insert.put("f_wflx",map1.get("f_yswflx")!=null?map1.get("f_yswflx").toString():null);
                }
            }
        }
        boolean isInsert = true;
        if(aLong>0){
            isInsert = false;
        }
        int count = datametaData.getColumnCount();
        Map<String,Object> map = new HashMap<>();
        for (int i = 1; i <= count; i++) {
             String key = datametaData.getColumnName(i);
             Object obj = resultSet.getObject(key);
             map.put(key,obj);
        }

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (String field : fields) {
            if(map.containsKey(field)){
                if(field.equals("f_userid")){
                    if(!"".equals(map.get("f_userid").toString())){
                        insert.put("f_userid",Long.valueOf(map.get("f_userid").toString()));
                    }
                    break;
                }
                if(map.get(field)!=null && StringUtils.isNotBlank(map.get(field).toString())) {
                    if(field.equals("f_hcjl")){
                        insert.put("f_hcjg",map.get("f_hcjl")!=null?map.get("f_hcjl").toString():null);
                    }else{
                        insert.put(field, map.get(field));
                    }
                }
            }
        }
        insert.put("f_taskid",taskId);
        insert.put("f_task_tbid",f_id);
        insert.put("f_sourceid",sourceId);
        insert.put("f_clueid",clueId);
        insert.put("f_createtime",new Date().toString());
        insert.put("f_xsbh",xsbh);
        insert.put("f_xzqdm",xzqdm);
        if (isInsert) {
            insert.put("f_id",UUID.randomUUID().toString());
            List<Map<String,Object>> list = new ArrayList<>();
            list.add(insert);
            try {
                dataBizService.insertDatasBatch(WFTaskName,list,"f_shape");
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            insert.put("f_id",f_id);
            dataBizService.updateData(WFTaskName, insert, " f_taskid = '" + taskId + "' and f_task_tbid='"+f_id+"'");
        }
    }


    /**
     * 插入图斑判定数据
     * @param map
     */
    public void insertTaskJudge( Map<String, Object> map){
        if(map.containsKey("f_pdlx")){
             if(map.get("f_pdlx") != null){
                 Map<String, Object> judgeMap = new HashMap<>();
                 String dataId = map.get("f_id").toString();
                 String pdlx = map.containsKey("f_pdlx")?map.get("f_pdlx").toString():null;
                 Map mapdata = dataBizService.selectByID("jc_task_clue_judge", "f_dataid", "'"+dataId+"'");
                 judgeMap.put("f_dataid",dataId);
                 judgeMap.put("f_gsbm",map.containsKey("f_gsbm")?map.get("f_gsbm"):null);
                 judgeMap.put("f_pdlx",pdlx);
                 judgeMap.put("f_sjyt",map.containsKey("f_sjyt")?map.get("f_sjyt"):null);
                 judgeMap.put("f_jyqx",map.containsKey("f_jtqx")?map.get("f_jtqx"):null);
                 judgeMap.put("f_pdjysm",map.containsKey("f_pdyjsm")?map.get("f_pdyjsm"):null);
                 judgeMap.put("f_wflx",map.containsKey("f_wflx")?map.get("f_wflx"):null);
                 judgeMap.put("f_sfxzlzgdjf",map.containsKey("f_sfxzlzgd")?map.get("f_sfxzlzgd"):null);
                 judgeMap.put("f_sfwhzj",map.containsKey("f_sfwhzj")?map.get("f_sfwhzj"):null);
                 judgeMap.put("f_sfgdmj",map.containsKey("f_qzgdmj")?map.get("f_qzgdmj"):null);
                 judgeMap.put("f_wfnydmj",map.containsKey("f_wfnydmj")?map.get("f_wfnydmj"):null);//
                 judgeMap.put("f_qzjbntmj",map.containsKey("f_qzjbntmj")?map.get("f_qzjbntmj"):null);
                 judgeMap.put("f_wfktzdlmj",map.containsKey("f_wfkdzdlm")?map.get("f_wfkdzdlm"):null);
                 judgeMap.put("f_wfwlydmj",map.containsKey("f_wfwlydmj")?map.get("f_wfwlydmj"):null);
                 judgeMap.put("f_wfjsydmj",map.containsKey("f_wfjsydmj")?map.get("f_wfjsydmj"):null);
                 if(mapdata == null){
                     judgeMap.put("f_id",UUID.randomUUID().toString());
                     dataBizService.insertData("jc_task_clue_judge",judgeMap, "f_shape");
                 }else{
                     dataBizService.updateData("jc_task_clue_judge", judgeMap, " f_dataid = '" + dataId + "'");
                 }
                 //合法用地批文
                 if(pdlx.equals("1")){
                    String  landinfoTableName= "jc_task_clue_landinfo";
                     String sql = " delete from "+landinfoTableName+" where f_dataid = '" + dataId + "'";
                     //清除数据
                     dataBizService.excuteSql(sql);
                     //新增数据
                     Map<String, Object> landinfoMap = new HashMap<>();
                     landinfoMap.put("f_id",UUID.randomUUID().toString());
                     landinfoMap.put("f_dataid",dataId);
                     landinfoMap.put("f_pwlx",map.containsKey("f_pwlx")?map.get("f_pwlx"):null);
                     landinfoMap.put("f_pzsj",map.containsKey("f_pzrq")?map.get("f_pzrq"):null);
                     landinfoMap.put("f_pzwh",map.containsKey("f_pzwh")?map.get("f_pzwh"):null);
                     landinfoMap.put("f_pzmj",map.containsKey("f_pzmj")?map.get("f_pzmj"):null);
                     landinfoMap.put("f_pzgdmj",map.containsKey("f_pzgdmj")?map.get("f_pzgdmj"):null);
                     landinfoMap.put("f_pzjg",map.containsKey("f_pzjg")?map.get("f_pzjg"):null);
                     landinfoMap.put("f_pznydmj",map.containsKey("f_pznydmj")?map.get("f_pznydmj"):null);
                     landinfoMap.put("f_pzyjjbntmj",map.containsKey("f_pzyjjbnt")?map.get("f_pzyjjbnt"):null);
                     dataBizService.insertData(landinfoTableName,landinfoMap, "f_shape");
                 }
             }
        }
    }


    /**
     * 获取图斑编号
     * @param regionCode
     * @return
     * @throws Exception
     */
    public String getTbbh(String regionCode) {
        String sql = "select nextval('seq_jc_case_case_wh_id')";
        Integer count  = jdbcTemplate.queryForObject(sql,Integer.class);
        String num  = String.format("%04d",count);
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String dateString = sf.format(new Date());
        String clueNum = regionCode.substring(0,6)+dateString+"XC"+num;
        return clueNum;
    }


    private Boolean existTable(Statement statement,String tableName){
        try{
            // 执行查询
            String sql = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'";
            ResultSet rs = statement.executeQuery(sql);

            // 检查结果集是否为空
            if (rs.next()) {
                return true;
            } else {
                return false;
            }
        }
        catch (Exception ex){
            System.out.println(ex.getMessage());
            return false;
        }
    }
}
