package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.dao.task.TbtskRejectDefDao;
import com.geoway.landteam.customtask.dao.task.TbtskRejectRecordDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.review.TbtskFlowService;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskBizFlowService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskAssignJobService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TaskUtils;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.data.GwValidateException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.networkTransmission
 * @date 2022/2/24 9:47
 */
@Service
public class InnerTaskTransmitService {

    private GiLoger logger = GwLoger.getLoger(InnerTaskTransmitService.class);
    @Autowired
    RedisTemplate redisTemplate;
    @Resource
    ProducerService producerService;

    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.task.appkey:}")
    String transmitAppkey;
    @Value("${transmit.task.module:}")
    String transmitModule;
    @Autowired
    TaskRecordService taskRecordService;
    @Resource
    TbtskFlowDefRepository tbtskFlowDefRepository;
    @Resource
    TbtskTaskBizFlowService tbtskTaskBizFlowService;

    @Autowired
    TskTaskBizRepository tskTaskBizRepository;

    @Autowired
    TbtskFlowService tbtskFlowService;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    UserBiz2Repository userBiz2Repository;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    MTaskAssignJobService taskAssignJobService;
    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskRejectDefDao rejectDefDao;

    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;

    /**
     * 勾选下发
     * @param parameter
     * @throws Exception
     */
    public void assignData(TaskDataDbParameter parameter) throws Exception {
        String recordId = parameter.getRecordId();
        TaskRecord one = taskRecordService.findOne(recordId);
        // 1.更新图斑状态
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(parameter.getTaskId());
        if (table == null) {
            return;
        }
        // 将recordid关联的数据至为已下发状态
        String sql = "update " + table.getfTablename() + " a\n" +
                "set f_status=2\n" +
                "where f_status=1 and exists (select null from tbsys_task_record_temp b where b.f_dataid=a.f_id and  b.f_recordid = '" + recordId + "')";
        dataBizService.excuteSql(sql);
        // 2.作业区挂接
        JSONArray users = new JSONArray();
        if (parameter.getOrgs() != null) {
            users.addAll(parameter.getOrgs());
        }
        if(parameter.getGroups()!=null) {
            users.addAll(parameter.getGroups());
        }
        taskAssignJobService.assignTaskArea(users, parameter.getTaskId(), recordId, table);

        // 3.生成文件
        Pair<String,String> pair = createTaskZip(parameter);

        // 成功后删除tbsys_task_record_temp表中的临时数据
        dataBizService.excuteSql("delete from tbsys_task_record_temp where f_recordid='"+recordId+"'");
        one.setEndtime(new Date());
        one.setState(3);
        one.setData(pair.getLeft());
        one.setResult(pair.getRight());
        taskRecordService.save(one);
    }

    /**
     * 条件下发
     * @param paramsObject
     * @param record
     * @throws Exception
     */
    public void assignDataByCondition(JSONObject paramsObject, TaskRecord record) throws Exception {
        TaskQueryParameter queryParameter = JSONObject.parseObject(paramsObject.getString("taskQueryParameter"),
                TaskQueryParameter.class);
        List<Map>  data = tbtskFlowService.getConfigTaskDataListNew(queryParameter);
        // 1.更新图斑状态
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(queryParameter.getTaskId());
        if (table == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        data.forEach(a -> sb.append("'" + a.get("f_id") + "',"));
        // 将recordid关联的数据至为已下发状态
        String sql = "update " + table.getfTablename() + " a set f_status=2 , f_reject_status = 1" +
                "where f_status=1 and f_id in ("+sb.toString().substring(0, sb.length()-1)+")" ;
        dataBizService.excuteSql(sql);
        // 2.作业区挂接
        JSONArray users = new JSONArray();
        if (paramsObject.getString("orgs") != null) {
            users.addAll(paramsObject.getJSONArray("orgs"));
        }
        if(paramsObject.getString("groups")!=null) {
            users.addAll(paramsObject.getJSONArray("groups"));
        }
        taskAssignJobService.assignTaskAreaByCond(users, queryParameter.getTaskId(), data, table);
        // 3.生成文件
        Pair<String,String> pair = createTaskDbByCond(paramsObject, data );

        record.setEndtime(new Date());
        record.setState(3);
        record.setData(pair.getLeft());
        record.setResult(pair.getRight());
        taskRecordService.save(record);
    }
    /**
     * 条件下发
     * @param paramsObject
     * @param record
     * @throws Exception
     */
    public void pushTaskData(JSONObject paramsObject, TaskRecord record) throws Exception {
        String recordId = record.getData();
        Long userId = paramsObject.getLongValue("userId");
        String taskId = paramsObject.getString("taskId");
        // 生成文件
        Pair<String,String> pair = createPushTaskZip(userId,taskId,recordId);
        // 成功后删除tbsys_task_record_temp表中的临时数据
        dataBizService.excuteSql("delete from tbsys_task_record_temp where f_recordid='"+recordId+"'");
        record.setEndtime(new Date());
        record.setState(3);
        record.setData(pair.getLeft());
        record.setResult(pair.getRight());
        taskRecordService.save(record);
    }

    /**
     * 下发推送任务数据
     * @throws Exception
     */
    public Pair<String,String> createPushTaskZip(Long userId,String taskId,String recordId) throws Exception {
        String url ="";
        JSONObject result = new JSONObject();
        //List<String> ids = taskRecordService.getDataIdListByRecordId(recordId);

        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        // 任务区域
        List<BizArea> tskTaskBizArea = tskTaskBizService.getTskTaskBizAreaByBizId(taskId);

        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);

        // 查找
        String sql = "SELECT a.*\n" +
                "FROM\n" +
                "\t"+table.getfTablename()+" A \n" +
                "WHERE\n" +
                "\tEXISTS (\n" +
                "SELECT NULL \n" +
                "FROM\n" +
                "\ttbsys_task_record_temp b \n" +
                "WHERE\n" +
                "\tb.f_dataid = A.f_id \n" +
                "\tAND b.f_recordid = '"+recordId+"')";
        List<Map> list = dataBizService.queryDataBySql(sql);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 01.先根据 taskid生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生产表信息和字段信息
            TaskUtils.createInfo(tskTaskBizService,table, task, statement);
            Long classId =  task.getClassId();
            sql=String.format("select * from tbtsk_task_class where f_id in (\n" +
                    "WITH RECURSIVE parents AS (\n" +
                    "    SELECT f_id, f_parentid\n" +
                    "    FROM tbtsk_task_class\n" +
                    "    WHERE f_id = '%s' -- 替换为你要查询的子级ID\n" +
                    "    UNION ALL\n" +
                    "    SELECT n.f_id, n.f_parentid\n" +
                    "    FROM tbtsk_task_class n\n" +
                    "    INNER JOIN parents p ON n.f_id = p.f_parentid\n" +
                    ")\n" +
                    "SELECT f_id\n" +
                    "FROM parents\n" +
                    ")",classId);
            List<Map> taskClassMaps  = dataBizService.queryDataBySql(sql);
            List<TbtskTaskClass>taskClassLst = new ArrayList<>();
            for(Map m:taskClassMaps)
            {
                TbtskTaskClass t = new TbtskTaskClass();
                t.setId(Long.parseLong(m.get("f_id").toString()));
                t.setName(m.get("f_name").toString());
                t.setParentId(Long.parseLong(m.get("f_parentid").toString()));
                t.setUserId(Long.parseLong(m.get("f_userid").toString()));
                t.setLevel(Long.parseLong(m.get("f_level").toString()));
                taskClassLst.add(t);
            }
            TaskUtils.creaTaskClass(statement,taskClassLst);
           // 任务审核数据
            TbtskTaskBizFlow tbtskTaskBizFlow = tbtskTaskBizFlowService.selectByTaskId(taskId);
            if(tbtskTaskBizFlow != null){
                TbtskFlowDef tbtskFlowDef = tbtskFlowDefRepository.findById(tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow,tbtskFlowDef,statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId)
                    .map(rejectDefDao::selectByTaskId)
                    .ifPresent( e -> TaskUtils.createTaskReject(e, finalStatement));
            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table,task, statement);
            // 导入图斑数据
            if(list!=null&&!list.isEmpty()) {
                Set<String> set = taskAssignJobService.insertData(list, statement, table, task.getMode().toString());
            }
            // 关闭连接
            tool.closeAll(conn, statement, null);
            // 02.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            //1 新增任务 2 更新任务结构
            jsonObject.put("group","task");
            jsonObject.put("type","pushTaskData");
            jsonObject.put("mode","1");
            jsonObject.put("userId",userId);
            jsonObject.put("taskId",taskId);
            List<BizArea> arealist = bizAreaRepository.findByBizId(taskId);
            if(!arealist.isEmpty()){
                jsonObject.put("taskArea",arealist.get(0).getArea());
            }
            List<UserBiz2> userBiz2s = userBiz2Repository.findByBizIdAndRole(taskId, 0);
            if(!userBiz2s.isEmpty()){
                jsonObject.put("taskCreateUserId",userBiz2s.get(0).getUserId());
            }
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(StringUtils.deleteWhitespace(task.getName()).replaceAll
                    (":","").replaceAll("/","")).append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            url  =  afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            result =   HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix +".zip"), transmitUrl+"/monitor/trans/transData.action");
           // publishTranMsg(fileNameNoSuffix + ".zip");
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
             FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
        return Pair.of(url, JSONObject.toJSONString(result,SerializerFeature.WriteMapNullValue));
    }


    public Pair<String,String> createTaskZip(TaskDataDbParameter parameter) throws Exception {
        String url ="";
        JSONObject result = new JSONObject();
        if (parameter == null) {
            throw new GwValidateException("parameter参数不能为null");
        }
        List<String> ids = taskRecordService.getDataIdListByRecordId(parameter.getRecordId());

        JSONArray orgs = parameter.getOrgs();
        JSONArray groups = parameter.getGroups();
        Long userId = parameter.getUserId();
        String taskId = parameter.getTaskId();
        String mode = parameter.getMode();

        //生成下发记录
        tskTaskBizService.createRecord(ids, groups, orgs, userId, taskId);

        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);

        // 查找
        String sql = "SELECT a.*\n" +
                "FROM\n" +
                "\t"+table.getfTablename()+" A \n" +
                "WHERE\n" +
                "\tEXISTS (\n" +
                "SELECT NULL \n" +
                "FROM\n" +
                "\ttbsys_task_record_temp b \n" +
                "WHERE\n" +
                "\tb.f_dataid = A.f_id \n" +
                "\tAND b.f_recordid = '"+parameter.getRecordId()+"')";
        List<Map> list = dataBizService.queryDataBySql(sql);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 01.先根据 taskid生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生产表信息和字段信息
            TaskUtils.createInfo(tskTaskBizService,table, task, statement);
            // 任务审核数据
            TbtskTaskBizFlow tbtskTaskBizFlow = tbtskTaskBizFlowService.selectByTaskId(taskId);
            if(tbtskTaskBizFlow != null){
                TbtskFlowDef tbtskFlowDef = tbtskFlowDefRepository.findById(tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow,tbtskFlowDef,statement);
            }

            Statement finalStatement = statement;
            Optional.ofNullable(taskId)
                    .map(rejectDefDao::selectByTaskId)
                    .ifPresent( e -> TaskUtils.createTaskReject(e, finalStatement));
            TaskDBUtils.createTable(tskTaskBizService, table, task,statement);
            // 导入图斑数据
            Set<String> set = taskAssignJobService.insertData(list, statement, table, mode);
            // 关闭连接
            tool.closeAll(conn, statement, null);
            // 02.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            //1 新增任务 2 更新任务结构
            jsonObject.put("group","task");
            jsonObject.put("type","assignBiz");
            jsonObject.put("mode","1");
            jsonObject.put("userId",userId);
            jsonObject.put("taskId",taskId);
            jsonObject.put("assignUserIds",userIdList( orgs, groups));
            jsonObject.put("tbIds",ids);
            List<BizArea> arealist = bizAreaRepository.findByBizId(taskId);
            if(!arealist.isEmpty()){
                jsonObject.put("taskArea",arealist.get(0).getArea());
            }
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(task.getName()).append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            url  =  afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            result =   HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix +".zip"), transmitUrl+"/monitor/trans/transData.action");
           // publishTranMsg(fileNameNoSuffix + ".zip");
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
             FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
        return Pair.of(url, JSONObject.toJSONString(result,SerializerFeature.WriteMapNullValue));
    }

    /**
     * 条件下发
     * @param paramsObject
     * @param data
     * @return
     * @throws Exception
     */
    private Pair<String,String> createTaskDbByCond(JSONObject paramsObject, List<Map>  data ) throws Exception {
        String url ="";
        JSONObject result = new JSONObject();
        if (paramsObject == null) {
            throw new GwValidateException("parameter参数不能为null");
        }
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(paramsObject.getString("taskId")).orElse(null);
        List<String> ids = new ArrayList<>();
        data.forEach(a -> ids.add(a.get("f_id").toString()));
        JSONArray orgs = paramsObject.getJSONArray("orgs");
        JSONArray groups = paramsObject.getJSONArray("groups");
        Long userId = paramsObject.getLongValue("userId");
        String taskId = paramsObject.getString("taskId");
        String mode = String.valueOf(tskTaskBiz.getMode());
        //生成下发记录
        tskTaskBizService.createRecord(ids, groups, orgs, userId, taskId);
        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 01.先根据 taskid生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生产表信息和字段信息
            TaskUtils.createInfo(tskTaskBizService,table, task, statement);
            // 任务审核数据
            TbtskTaskBizFlow tbtskTaskBizFlow = tbtskTaskBizFlowService.selectByTaskId(taskId);
            if(tbtskTaskBizFlow != null){
                TbtskFlowDef tbtskFlowDef = tbtskFlowDefRepository.findById(tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow,tbtskFlowDef,statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId)
                    .map(rejectDefDao::selectByTaskId)
                    .ifPresent( e -> TaskUtils.createTaskReject(e, finalStatement));
            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table, task,statement);
            // 导入图斑数据
            Set<String> set = taskAssignJobService.insertData(data, statement, table, mode);
            // 关闭连接
            tool.closeAll(conn, statement, null);
            // 02.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            //1 新增任务 2 更新任务结构
            jsonObject.put("mode","1");
            jsonObject.put("group","task");
            jsonObject.put("type","assignBiz");
            jsonObject.put("userId",userId);
            jsonObject.put("taskId",taskId);
            jsonObject.put("userIds",userIdList( orgs, groups));
            jsonObject.put("tbIds",ids);
            List<BizArea> list = bizAreaRepository.findByBizId(taskId);
            if(!list.isEmpty()){
                jsonObject.put("taskArea",list.get(0).getArea());
            }
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(task.getName()).append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            url  =  afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            result = HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix + ".zip"), transmitUrl+"/monitor/trans/transData.action");
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
            FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
        return Pair.of(url, JSONObject.toJSONString(result,SerializerFeature.WriteMapNullValue));
    }


    /**
     * 压缩文件
     * @param userId
     * @param tempFolderPath
     * @param safeFileName
     * @param fileNameNoSuffix
     * @return
     */
    public  String afterExport(Long userId,String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url ="";
        logger.info( " 开始压缩成zip文件 ");
        Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", false, "");
        url =  uploadFileToCloudDisk(userId, safeFileName);
        /*String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 计算大小
        Double zipFileSize = new File(zipFile).length() / 1024d;*/
        url = temporarySignedUrlService.getTemporarySignedUrl("",url,null);
        return url;
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */


    public  String  uploadFileToCloudDisk(Long userId, String safeFileName) {
        // 注意：这里不能用File.separator 替代"/"，OBS上路径分隔符用"/",而File.separator默认为:"\"
        String sendObjName = "taskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 上传到obs
        String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }

    /**
     * 下发的用户
     * @param orgs
     * @param groups
     * @return
     */
    public List<String> userIdList(JSONArray orgs, JSONArray groups) {
        List<String> userIds = new ArrayList<>();
        JSONArray array = new JSONArray();
        // 单位用户
        for (int i = 0; i < orgs.size(); i++) {
            JSONObject jsonObject = orgs.getJSONObject(i);
            array.addAll(jsonObject.getJSONArray("userids"));
        }
        // 工作组用户
        for (int i = 0; i < groups.size(); i++) {
            JSONObject jsonObject = groups.getJSONObject(i);
            array.addAll(jsonObject.getJSONArray("userids"));
        }
        for (int j = 0; j < array.size(); j++) {
            String userid = array.getString(j);
            if (!userIds.contains(userid)) {
                userIds.add(userid);
            }
        }
        return userIds;
    }

    /**
     * 同步内网
     * @param userId
     * @param taskId
     * @throws Exception
     */
    public void syncTask(Long userId,String taskId) throws Exception {
        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        try {
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 01.先根据 taskid生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生产表信息和字段信息
            TaskUtils.createInfo(tskTaskBizService,table, task, statement);
            //增加任务审核流程
            TbtskTaskBizFlow tbtskTaskBizFlow = tbtskTaskBizFlowService.selectByTaskId(taskId);
            if(tbtskTaskBizFlow != null){
                TbtskFlowDef tbtskFlowDef = tbtskFlowDefRepository.findById(tbtskTaskBizFlow.getFlowId()).orElse(null);
                TaskUtils.createTaskFlow(tbtskTaskBizFlow,tbtskFlowDef,statement);
            }
            Statement finalStatement = statement;
            Optional.ofNullable(taskId)
                    .map(rejectDefDao::selectByTaskId)
                    .ifPresent( e -> TaskUtils.createTaskReject(e, finalStatement));
            // 关闭连接
            tool.closeAll(conn, statement, null);
            // 02.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            //1 新增任务 2 更新任务结构
            jsonObject.put("mode","1");
            jsonObject.put("group","task");
            jsonObject.put("type","addBiz");
            jsonObject.put("userId",userId);
            jsonObject.put("taskId",taskId);
            List<BizArea> list = bizAreaRepository.findByBizId(taskId);
            if(!list.isEmpty()){
                jsonObject.put("taskArea",list.get(0).getArea());
            }
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(task.getName()).append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            HttpUtil.sendRrquestByFile(transmitAppkey, transmitModule, new File(fileNameNoSuffix + ".zip"), transmitUrl+"/monitor/trans/transData.action");
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
            FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
    }

    /**
     * 发送消息
     * @param url
     */
    public void publishTranMsg(String url) {
        try {
            String queueName = "SC-out-taskTran";
            logger.info("发送同步消息队列名称：" + queueName + " 内容：" + url);
            //producerService.sendMessage(queueName, bytes);
            Map<String, Object> map = new HashMap<>();
            map.put(ActiveMQConstant.SERVICE_NAME, "TASKTRAN-RECEIVE-MESSAGE");
            map.put("appkey",  PropertyUtil.getProperty("transmit.appkey"));
            map.put("module",  PropertyUtil.getProperty("transmit.module"));
            map.put("name", "测试");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "TASKTRAN-RECEIVE-MESSAGE");
            producerService.sendMapMessage2Queue(map, queueName);
        } catch (Exception e) {
            logger.error("发送同步消息异常：", e);
        }
    }

}
