package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.GeometryUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.AtlasTaskInfo;
import com.geoway.landteam.landcloud.model.cffx.enm.CffxStateEnum;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDownloadTxtDailyTaskServiceImpl;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.graphbuilder.geom.Geom;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.Data;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.jms.MapMessage;
import javax.sql.DataSource;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class InnerTxtShpResolverAdapterConsumer implements IConsumerStrategyService {

    GiLoger logger = GwLoger.getLoger(InnerTxtShpResolverAdapterConsumer.class);

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.txtdown.appkey:}")
    String transmitAppkey;
    @Value("${transmit.txtdown.module:}")
    String transmitModule;

    @Autowired
    protected SysConfigService sysConfigService;

    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    DataBizMapper dataBizMapper;

    @Autowired
    TaskRecordService taskRecordService;

    String key="txt-down-config";

    @Override
    public String getCode() {
        return "INNER-TXT-DOWN";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        String messageId="";
        try {
            SysConfig sysconfig = sysConfigService.findOne(key);
            if(sysconfig==null)
            {
                logger.error("内网网间传输接收txt-down任务处理失败,未配置叠加数及叠加分析服务");
                return;
            }
            TxtDownConfig config = JSONObject.parseObject(sysconfig.getValue(),TxtDownConfig.class);
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File recvFile = null;
            if (StringUtils.isNotBlank(storageType)) {
                if ("0".equals(storageType.trim())) { //共享文件路径
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) { //Ftp方式
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];

                    recvFile = buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile(FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), recvFile);
                        } catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            //关闭ftp连接
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim())) { //文件存储
                    String objectStorag = mapMessage.getString("objectStorage");
                    if(StringUtils.isNotBlank(objectStorag)){
                        String signed = temporarySignedUrlService.getTemporarySignedUrl("",objectStorag,null);
                        URL url = new URL(signed);
                        HttpURLConnection conn = null;
                        if (url != null) {
                            conn = (HttpURLConnection) url.openConnection();
                            conn.setConnectTimeout(3 * 1000);
                            conn.setRequestProperty("Charset", "UTF-8");
                            recvFile = buildTempUploadFile();
                            FileUtils.copyInputStreamToFile(conn.getInputStream(), recvFile);
                        }
                        conn.disconnect();
                    }
                }
            }
            resove(recvFile,config);
            // 删除文件夹
            FileUtils.deleteQuietly(recvFile);
        } catch (Exception e) {
            logger.error(e);
        }
        finally {
            if(StringUtils.isNotBlank(messageId))
            {
                try {
                    JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRequestById(messageId, transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex)
                {
                    logger.error("网间传输回调异常"+ ExceptionUtil.getErrorString(ex));
                }
            }
        }
    }

    public void runTask(TaskRecord record)
    {
        SysConfig sysconfig = sysConfigService.findOne(key);
        if(sysconfig==null)
        {
            logger.error("内网网间传输接收txt-down任务处理失败,未配置叠加数据及叠加分析服务");
            return;
        }
        TempParam param = JSONObject.parseObject(record.getParam(),TempParam.class);
        if(param.getAtlasState()!=null&&param.getAtlasState().equals(1)) {
            TxtDownConfig config = JSONObject.parseObject(sysconfig.getValue(), TxtDownConfig.class);

            String atlasId = param.getAtlasId();
            String atlasUrl = config.atlasUrl;
            String url = atlasUrl.substring(0, atlasUrl.indexOf("/analysis"));
            url = url + "/task/get?id=" + atlasId;
            HttpRequest get = cn.hutool.http.HttpUtil.createGet(url);
            cn.hutool.http.HttpResponse execute = get.execute();
            String bodyStr = execute.body();
            if (execute.getStatus() == 200) {
                JSONObject body = JSONObject.parseObject(bodyStr);
                if (body.get("code").equals(200)) {
                    AtlasTaskInfo taskDto = JSONObject.parseObject(body.get("data").toString(), AtlasTaskInfo.class);
                    if (taskDto.getFinished()) {

                        if (taskDto.getSucceed()) {
                            param.setAtlasState(2);
                            record.setParam(JSONObject.toJSONString(param));
                            record.setState(JobConstants.JOB_STATE_RUNNING);
                        } else {
                            param.setAtlasState(3);
                            record.setParam(JSONObject.toJSONString(param));
                            record.setState(JobConstants.JOB_STATE_FAILED);
                            TableUtil.dropTable(param.tempTable,jdbcTemplate);
                        }

                    }
                    taskRecordService.save(record);
                    try {
                        if (param.getAtlasState().equals(2)) {

                            String tempTable = param.getTempTable();
                            List<String> fields = new ArrayList<>();
                            fields.add("st_astext(f_shape) as f_shape");
                            fields.add("aid");
                            fields.add(config.getHzField());
                            List<Map> maps = dataBizMapper.queryAllData(tempTable, fields, null);
                            if (maps != null && !maps.isEmpty()) {
                                writeTxtTbfw(record.getId(), maps,config);
                            }

                            String resultTable = param.getResultTable();
                            fields.clear();
                            fields.add("st_astext(shape) as f_shape");
                            fields.add("aid_1");
                            fields.add(config.getHzField() + "_1 as " + config.getHzField());
                            fields.add(config.getFjsydDlmcField() + "_2 as " + config.getFjsydDlmcField());
                            maps = dataBizMapper.queryAllData(resultTable, fields, null);
                            if (maps != null && !maps.isEmpty()) {
                                writeTxtFjsyd(record.getId(), maps,config);
                                writeTxtDlmc(record.getId(), maps,config);
                            }
                            generateConfig(  uploadDir+File.separator+record.getId(),record.getId());
                            String foler = uploadDir+File.separator+record.getId();
                            String file = uploadDir+File.separator+record.getId()+".zip";
                            Zip4jUtils.zip(foler, file, false, "");
                            JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(file), transmitUrl+"/monitor/trans/transData.action");
                            if(httpResult==null||!"200".equals(httpResult.getString("code")))
                            {
                                logger.error("发送文件失败"+httpResult==null?"":httpResult.toJSONString());
                                record.setLog("发送文件失败");
                                record.setState(JobConstants.JOB_STATE_FAILED);
                                taskRecordService.save(record);
                                TableUtil.dropTable(param.tempTable,jdbcTemplate);
                                TableUtil.dropTable(param.resultTable,jdbcTemplate);
                                return;
                            }
                            record.setState(JobConstants.JOB_STATE_SUCCESS);
                            taskRecordService.save(record);

                        }
                    }
                    catch (Exception ex)
                    {
                        logger.error("写txt异常"+ExceptionUtil.getErrorString(ex));
                        record.setLog("写txt失败");
                        record.setState(JobConstants.JOB_STATE_FAILED);
                        taskRecordService.save(record);
                        TableUtil.dropTable(param.tempTable,jdbcTemplate);
                        TableUtil.dropTable(param.resultTable,jdbcTemplate);
                    }
                }
            }
        }
    }
    void generateConfig(String folderPath,String id) {

        if (com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(folderPath)) {
            FileUtil.creatDirectoryIfNotExist(folderPath);

            String fileName = new StringBuilder()
                    .append(folderPath)
                    .append(File.separator)
                    .append("config.json")
                    .toString();
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                Writer writer = null;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id",id);
                try {

                    writer = new FileWriter(file, true); // true表示追加
                    writer.write(jsonObject.toJSONString());
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    try {
                        writer.close();
                    } catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    public void resove(File recvFile,TxtDownConfig config) throws Exception {
        TaskRecord  record = new TaskRecord();

        String zipName = recvFile.getAbsolutePath();
        String unzipFileDir = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
        //解压文件路径
        FileUtil.creatDirectoryIfNotExist(unzipFileDir);
        //解压文件
        Zip4jUtils.unzip(zipName, unzipFileDir, "", true);
        File file = new File(unzipFileDir);
        File[] contents = file.listFiles();
        File metaFile = Arrays.stream(contents).filter(f -> f.getName().endsWith("config.json")).findFirst().orElseThrow(() -> new RuntimeException("缺少元数据"));
        JSONObject meta = readMeta(metaFile);
        String id = meta.getString("id");
        record.setId(id);
        record.setTasktype(JobConstants.JOB_TYPE_TXT_DOWN_INNER_ATLAS);
        record.setState(JobConstants.JOB_STATE_FAILED);
        record.setStarttime(new Date());

        File shpFile = Arrays.stream(contents).filter(f -> f.getName().endsWith(".shp")).findFirst().orElseThrow(() -> new RuntimeException("缺少shp数据"));
        String tablename = "temp_txt_" + UUID.randomUUID().toString().replace("-", "");
        String dbleft = getDB();
        String dbright = dbleft;
        if(StringUtils.isNotBlank(config.fjsydDb))
        {
            dbright = config.fjsydDb;
        }
        String resultname = "intersect_" + UUID.randomUUID().toString().replace("-", "");
        try {
            importData(shpFile, tablename);
            String template = getTemplate("intersect.json");
            Map<String,String>mapParam = new HashMap<>();
            mapParam.put("{left}",dbleft+"/"+tablename);
            mapParam.put("{leftPkField}","aid");
            mapParam.put("{leftShapeField}","f_shape");
            mapParam.put("{leftWhere}","1=1");
            mapParam.put("{right}",dbright+"/"+config.fjsydTable);
            mapParam.put("{rightPkField}",config.fjsydPkField);
            mapParam.put("{rightShapeField}",config.fjsydShapeField);
            mapParam.put("{rightWhere}","1=1");
            mapParam.put("{result}",resultname);
            mapParam.put("{resultdb}",dbleft+"/"+resultname);
            for(Map.Entry<String,String>kv:mapParam.entrySet())
            {
                template = template.replace(kv.getKey(), kv.getValue());
            }


            logger.info("atlas service url:" + config.atlasUrl + " param:" + template);
            String result = HttpUtil.createPost(config.atlasUrl).body(template).execute().body();
            logger.info("atlas service url:" + config.atlasUrl + " http result: " + result);
            if(StringUtils.isNotBlank(result)) {
                JSONObject resultJson = JSONObject.parseObject(result);
                if (resultJson.containsKey("code") && resultJson.getString("code").equals("200")) {
                    String taskId = resultJson.getJSONObject("data").getString("taskId");
                    TempParam param = new TempParam();
                    param.setAtlasId(taskId);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(1);

                    record.setParam(JSONObject.toJSONString(param));
                    record.setState(JobConstants.JOB_STATE_CREATE);
                }
                else
                {
                    TempParam param = new TempParam();
                    param.setAtlasId(null);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(3);

                    record.setParam(JSONObject.toJSONString(param));
                    record.setState(JobConstants.JOB_STATE_FAILED);
                    record.setLog("创建atlas任务失败");
                    TableUtil.dropTable(tablename, jdbcTemplate);
                }
            }
            taskRecordService.save(record);

        } catch (Exception ex) {
            TableUtil.dropTable(tablename, jdbcTemplate);
            logger.error("导入shp失败" + ExceptionUtil.getStackTrace(ex));
        } finally {
            // 删除文件夹
            FileUtils.deleteQuietly(new File(unzipFileDir));
        }

    }
    private String getDB() {
        DataSource dataSource = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource) dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split(url, "?");
        url = urls[0];// StringUtils.replace(urls[0], "jdbc:", "");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }
    private static JSONObject readMeta(File file) throws Exception {
        try {
            StringBuilder sb = new StringBuilder();
            String encoding = "UTF-8";
            if (file.isFile() && file.exists()) { //判断文件是否存在
                InputStreamReader read = new InputStreamReader(
                        new FileInputStream(file), encoding);//考虑到编码格式
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    sb.append(lineTxt);
                }
                read.close();
            } else {
                throw new Exception("找不到指定的mate文件");
            }
            String meta = sb.toString();
            return JSONObject.parseObject(meta);
        } catch (Exception e) {
            throw e;
        }
    }

    private void importData(File file, String tableName) throws Exception {

        String shp = file.getAbsolutePath();
        URL url = null;
        try {
            url = file.toURI().toURL();
        } catch (Exception ex) {
            throw new RuntimeException("shp文件路径异常:" + shp);
        }

        int totalcount = 0;
        int importcount = 0;

        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        shpDataStore.setCharset(Charset.forName("GBK"));
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        org.geotools.data.Query query = new org.geotools.data.Query();
        try {
            totalcount += featureSource.getCount(query);
        } catch (Exception ex) {
            logger.error("shp文件计算图斑数量异常:" + shp + ExceptionUtil.getErrorString(ex));
            throw new RuntimeException("shp文件计算图斑数量异常:" + shp);
        }
        if (totalcount == 0) {
            logger.error("shp文件计算图斑数量为0:" + shp);
            throw new RuntimeException("shp文件计算图斑数量为0:" + shp);
        }
        Map<String, String> mapFields = null;
        try {
            mapFields = getShpToTableColumns(shpDataStore);
        } catch (Exception ex) {
            logger.error("shp字段获取异常:" + shp + ExceptionUtil.getErrorString(ex));
            throw new RuntimeException("shp字段获取异常:" + shp);
        }
        createShpTable(mapFields, jdbcTemplate, tableName);
        List<String> fields = mapFields.keySet().stream().collect(Collectors.toList());
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = null;
        try {
            collection = featureSource.getFeatures();
        } catch (Exception ex) {
            logger.error("shp获取要素集合异常:" + shp + ExceptionUtil.getErrorString(ex));
            throw new RuntimeException("shp获取要素集合异常:" + shp);
        }
        FeatureIterator<SimpleFeature> itertor = collection.features();
        SimpleFeature sf = null;
        List<Map<String, Object>> tbList = new ArrayList<>();

        while (itertor.hasNext()) {
            sf = itertor.next();
            Map<String, Object> tb = getFromSimpleFeature(sf, fields);
            tbList.add(tb);
            if (tbList.size() == 100) {
                importcount += 100;
                dataBizMapper.insertBatch(tableName, tbList, "f_shape");
                tbList.clear();
            }

        }
        if (!tbList.isEmpty()) {
            importcount += tbList.size();
            dataBizMapper.insertBatch(tableName, tbList, "f_shape");
            tbList.clear();
        }


    }

    private Map<String, String> getShpToTableColumns(ShapefileDataStore shpDataStore) throws IOException {
        String[] typeNames = shpDataStore.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType featureType = shpDataStore.getSchema(typeName);
        String shapeField = featureType.getGeometryDescriptor().getLocalName();
        List<AttributeDescriptor> ads = featureType.getAttributeDescriptors();
        List<String> fieldNames = ads.stream().map(descriptor -> descriptor.getLocalName()).collect(Collectors.toList());
        Map<String, String> mapFields = new HashMap<>();
        for (String f : fieldNames) {
            if (f.equals(shapeField)) {
                mapFields.put("f_shape", "public.geometry NOT NULL");
            } else {
                mapFields.put(f, "varchar(100) NULL");
            }
        }
        return mapFields;
    }

    private void createShpTable(Map<String, String> mapFields, JdbcTemplate jdbcTemplate, String tableName) {

        if (!TableUtil.tableExist(tableName, jdbcTemplate)) {
            String sql = "create table " + tableName + " (";
            for (Map.Entry<String, String> kv : mapFields.entrySet()) {
                sql += kv.getKey() + " " + kv.getValue() + ",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql += " )";
            jdbcTemplate.execute(sql);
            jdbcTemplate.execute("select updategeometrysrid('" + tableName + "','f_shape',4490)");
            TableUtil.createSequence(tableName, "aid", tableName + "_aid", jdbcTemplate);
        }

    }


    private Map<String, Object> getFromSimpleFeature(SimpleFeature sf, List<String> fields) {
        Map<String, Object> map = new HashMap<>();
        Geometry geo = (Geometry) sf.getDefaultGeometry();
        geo.setSRID(4490);
        for (String f : fields) {
            if (f.equals("f_shape")) {
                continue;
            }
            map.put(f, sf.getAttribute(f));

        }
        map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt(geo));

        return map;

    }

    private String getTemplate(String fileName) {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/" + fileName);
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result += s;
            }
            return result;
        } catch (Exception ex) {
            logger.error("读取分析模型失败" + ExceptionUtil.getErrorString(ex));
            return null;
        }

    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("downtxt-%s-%s.zip", sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if (uploadDir == null) {
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }

    private void writeTxtTbfw(String recordId, List<Map>maps, TxtDownConfig config) throws Exception {
        String path = uploadDir+File.separator+recordId;
        File folder = new File(path);
        if(!folder.exists())
        {
            folder.mkdir();
        }
        Map<String,List<Map>>kvMap = maps.stream().collect(Collectors.groupingBy(t->t.get(config.hzField).toString()));
        for(Map.Entry<String,List<Map>>kv:kvMap.entrySet())
        {


            String hz = kv.getKey();
            List<Map>values = kv.getValue();
            String wkt = values.get(0).get("f_shape").toString();
            WKTReader reader = new WKTReader();
            Geometry geo = reader.read(wkt);
            Integer projNo= GeometryUtil.getProjNum(geo);
            CoordinateReferenceSystem ref = GeometryUtil.getCoordinateReferenceSystem(projNo);
            Map<Integer,CoordinateReferenceSystem>mapRef = new HashMap<>();
            mapRef.put(projNo,ref);

            List<String>contents = new ArrayList<>();
            contents.add("[属性描述]\n");
            contents.add("坐标系=2000国家大地坐标系\n");
            contents.add("几度分带=3\n");
            contents.add("投影类型=高斯克吕格\n");
            contents.add("计量单位=米\n");
            contents.add("带号="+projNo+"\n");
            contents.add("精度=0.0001\n");
            contents.add("转换参数=0,0,0,0,0,0,0\n");
            contents.add("[地块坐标]\n");
            int index=0;
            java.text.DecimalFormat df = new java.text.DecimalFormat("#.000");
            for(Map map:values)
            {
                 wkt = map.get("f_shape").toString();
                 geo = reader.read(wkt);
                 projNo= GeometryUtil.getProjNum(geo);
                 if(mapRef.containsKey(projNo))
                 {
                     ref = mapRef.get(projNo);
                 }
                 else {
                     CoordinateReferenceSystem prjRef = GeometryUtil.getCoordinateReferenceSystem(projNo);
                     mapRef.put(projNo,prjRef);
                     ref = prjRef;
                 }
                Geometry projGeo =  GeometryUtil.transCgcs2000ToPrj(geo,ref);

                int geoCount =projGeo.getNumGeometries();
                for(int i=0;i<geoCount;i++)
                {
                    index++;
                    Geometry childGeo =  projGeo.getGeometryN(i);
                    Double areaD = childGeo.getArea();
                    String area = df.format(areaD);
                    String dkInfo =childGeo.getCoordinates().length+","+area+","+index+","+"地块"+index+",面"+",,农村宅基地,,@";
                    contents.add(dkInfo+"\n");
                    Coordinate[] coordinates = childGeo.getCoordinates();
                    for(int j=0;j<coordinates.length;j++)
                    {
                        BigDecimal bigx = new BigDecimal(coordinates[j].x);
                        String x = df.format(bigx.doubleValue());
                        BigDecimal bigy = new BigDecimal(coordinates[j].y);
                        String y=  df.format(bigy.doubleValue());
                        contents.add("J"+(j+1)+",1,"+y+","+x+"\n");
                    }
                    BigDecimal bigx = new BigDecimal(coordinates[0].x);
                    String x = df.format(bigx.doubleValue());
                    BigDecimal bigy = new BigDecimal(coordinates[0].y);
                    String y=  df.format(bigy.doubleValue());
                    contents.add("J1"+",1,"+y+","+x+"\n");

                }


            }

            String fileName = new StringBuilder()
                    .append(path)
                    .append(File.separator)
                    .append(hz+"选址范围.txt")
                    .toString();
            Writer writer = null;
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new FileWriter(file, true); // true表示追加
                for (String c : contents) {
                    writer.write(c);
                }
            }
            catch (Exception ex)
            {
                logger.error("写选址范围.txt异常"+ExceptionUtil.getErrorString(ex));
            }
            finally {
                if(writer!=null)
                {
                    writer.close();
                }
            }

        }

    }
    private void writeTxtFjsyd(String recordId, List<Map>maps, TxtDownConfig config) throws Exception {
        String path = uploadDir+File.separator+recordId;
        File folder = new File(path);
        if(!folder.exists())
        {
            folder.mkdir();
        }
        Map<String,List<Map>>kvMap = maps.stream().collect(Collectors.groupingBy(t->t.get(config.hzField).toString()));

        for(Map.Entry<String,List<Map>>kv:kvMap.entrySet())
        {
            String hz = kv.getKey();
            List<Map>values = kv.getValue();

            WKTReader reader = new WKTReader();
            List<TempGeo>geos = new ArrayList<>();
            int index=0;
            for(Map map:values)
            {
                String wkt = values.get(0).get("f_shape").toString();
                Geometry geo = reader.read(wkt);
                TempGeo tempGeo = new TempGeo();
                tempGeo.setGeo(geo);
                tempGeo.setIndex(index);
                geos.add(tempGeo);
                index++;
            }
            int size = geos.size();
            for(int i=0;i<size;i++)
            {
                TempGeo self = geos.get(i);
                for(int j=i+1;j<size;j++)
                {
                    TempGeo other = geos.get(j);
                    if(self.getIndex()==other.index)
                    {
                        continue;
                    }
                    if(self.getIndex()<i)
                    {
                        continue;
                    }
                    if(self.getGeo().touches(other.getGeo()))
                    {
                       Geometry union =   self.getGeo().union(other.getGeo());
                       self.setGeo(union);
                       other.setGeo(union);
                       other.setIndex(self.getIndex());
                    }
                }
            }
            Map<Integer,List<TempGeo>>mapGeos = geos.stream().collect(Collectors.groupingBy(t->t.getIndex()));

            Integer projNo= GeometryUtil.getProjNum(geos.get(0).getGeo());
            CoordinateReferenceSystem ref = GeometryUtil.getCoordinateReferenceSystem(projNo);
            Map<Integer,CoordinateReferenceSystem>mapRef = new HashMap<>();
            mapRef.put(projNo,ref);

            List<String>contents = new ArrayList<>();
            contents.add("[属性描述]\n");
            contents.add("坐标系=2000国家大地坐标系\n");
            contents.add("几度分带=3\n");
            contents.add("投影类型=高斯克吕格\n");
            contents.add("计量单位=米\n");
            contents.add("带号="+projNo+"\n");
            contents.add("精度=0.0001\n");
            contents.add("转换参数=0,0,0,0,0,0,0\n");
            contents.add("[地块坐标]\n");
            index=0;
            java.text.DecimalFormat df = new java.text.DecimalFormat("#.000");
            for(Map.Entry<Integer,List<TempGeo>> kvTemp:mapGeos.entrySet())
            {
                Geometry geo = kvTemp.getValue().get(0).getGeo();
                projNo= GeometryUtil.getProjNum(geo);
                if(mapRef.containsKey(projNo))
                {
                    ref = mapRef.get(projNo);
                }
                else {
                    CoordinateReferenceSystem prjRef = GeometryUtil.getCoordinateReferenceSystem(projNo);
                    mapRef.put(projNo,prjRef);
                    ref = prjRef;
                }
                Geometry projGeo =  GeometryUtil.transCgcs2000ToPrj(geo,ref);

                int geoCount =projGeo.getNumGeometries();
                for(int i=0;i<geoCount;i++)
                {
                    index++;
                    Geometry childGeo =  projGeo.getGeometryN(i);
                    Double areaD = childGeo.getArea();
                    String area = df.format(areaD);
                    String dkInfo =childGeo.getCoordinates().length+","+area+","+index+","+"地块"+index+",面"+",,非建设用地,,@";
                    contents.add(dkInfo+"\n");
                    Coordinate[] coordinates = childGeo.getCoordinates();
                    for(int j=0;j<coordinates.length;j++)
                    {
                        BigDecimal bigx = new BigDecimal(coordinates[j].x);
                        String x = df.format(bigx.doubleValue());
                        BigDecimal bigy = new BigDecimal(coordinates[j].y);
                        String y=  df.format(bigy.doubleValue());
                        contents.add("J"+(j+1)+",1,"+y+","+x+"\n");
                    }
                    BigDecimal bigx = new BigDecimal(coordinates[0].x);
                    String x = df.format(bigx.doubleValue());
                    BigDecimal bigy = new BigDecimal(coordinates[0].y);
                    String y=  df.format(bigy.doubleValue());
                    contents.add("J1"+",1,"+y+","+x+"\n");
                }


            }

            String fileName = new StringBuilder()
                    .append(path)
                    .append(File.separator)
                    .append(hz+"非建设用地范围.txt")
                    .toString();
            Writer writer = null;
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new FileWriter(file, true); // true表示追加
                for (String c : contents) {
                    writer.write(c);
                }
            }
            catch (Exception ex)
            {
                logger.error("写非建设用地范围.txt异常"+ExceptionUtil.getErrorString(ex));
            }
            finally {
                if(writer!=null)
                {
                    writer.close();
                }
            }



        }




    }
    private void writeTxtDlmc(String recordId, List<Map>maps, TxtDownConfig config) throws Exception {
        String path = uploadDir+File.separator+recordId;
        File folder = new File(path);
        if(!folder.exists())
        {
            folder.mkdir();
        }
        Map<String,List<Map>>kvMap = maps.stream().collect(Collectors.groupingBy(t->t.get(config.hzField).toString()));
        for(Map.Entry<String,List<Map>>kv:kvMap.entrySet())
        {


            String hz = kv.getKey();
            List<Map>values = kv.getValue();
            String wkt = values.get(0).get("f_shape").toString();
            WKTReader reader = new WKTReader();
            Geometry geo = reader.read(wkt);
            Integer projNo= GeometryUtil.getProjNum(geo);
            CoordinateReferenceSystem ref = GeometryUtil.getCoordinateReferenceSystem(projNo);
            Map<Integer,CoordinateReferenceSystem>mapRef = new HashMap<>();
            mapRef.put(projNo,ref);

            List<String>contents = new ArrayList<>();
            contents.add("[属性描述]\n");
            contents.add("坐标系=2000国家大地坐标系\n");
            contents.add("几度分带=3\n");
            contents.add("投影类型=高斯克吕格\n");
            contents.add("计量单位=米\n");
            contents.add("带号="+projNo+"\n");
            contents.add("精度=0.0001\n");
            contents.add("转换参数=0,0,0,0,0,0,0\n");
            contents.add("[地块坐标]\n");
            int index=0;
            java.text.DecimalFormat df = new java.text.DecimalFormat("#.000");
            for(Map map:values)
            {
                Object dlmcObj =map.get(config.getFjsydDlmcField());
                String dlmc = dlmcObj==null?"":dlmcObj.toString();
                wkt = map.get("f_shape").toString();
                geo = reader.read(wkt);
                projNo= GeometryUtil.getProjNum(geo);
                if(mapRef.containsKey(projNo))
                {
                    ref = mapRef.get(projNo);
                }
                else {
                    CoordinateReferenceSystem prjRef = GeometryUtil.getCoordinateReferenceSystem(projNo);
                    mapRef.put(projNo,prjRef);
                    ref = prjRef;
                }
                Geometry projGeo =  GeometryUtil.transCgcs2000ToPrj(geo,ref);

                int geoCount =projGeo.getNumGeometries();
                for(int i=0;i<geoCount;i++)
                {
                    index++;
                    Geometry childGeo =  projGeo.getGeometryN(i);
                    Double areaD = childGeo.getArea();
                    String area = df.format(areaD);
                    String dkInfo =childGeo.getCoordinates().length+","+area+","+index+","+"地块"+index+",面"+",,"+dlmc+",,@";
                    contents.add(dkInfo+"\n");
                    Coordinate[] coordinates = childGeo.getCoordinates();
                    for(int j=0;j<coordinates.length;j++)
                    {
                        BigDecimal bigx = new BigDecimal(coordinates[j].x);
                        String x = df.format(bigx.doubleValue());
                        BigDecimal bigy = new BigDecimal(coordinates[j].y);
                        String y=  df.format(bigy.doubleValue());
                        contents.add("J"+(j+1)+",1,"+y+","+x+"\n");
                    }
                    BigDecimal bigx = new BigDecimal(coordinates[0].x);
                    String x = df.format(bigx.doubleValue());
                    BigDecimal bigy = new BigDecimal(coordinates[0].y);
                    String y=  df.format(bigy.doubleValue());
                    contents.add("J1"+",1,"+y+","+x+"\n");

                }


            }

            String fileName = new StringBuilder()
                    .append(path)
                    .append(File.separator)
                    .append(hz+"非建设用地范围内各地类情况.txt")
                    .toString();
            Writer writer = null;
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                writer = new FileWriter(file, true); // true表示追加
                for (String c : contents) {
                    writer.write(c);
                }
            }
            catch (Exception ex)
            {
                logger.error("写非建设用地范围内各地类情况.txt异常"+ExceptionUtil.getErrorString(ex));
            }
            finally {
                if(writer!=null)
                {
                    writer.close();
                }
            }

        }

    }


    public class TxtDownConfig
    {
        private String atlasUrl;
        private String fjsydDb;
        private String fjsydTable;
        private String fjsydShapeField;
        private String fjsydPkField;
        private String hzField;

        private String fjsydDlmcField;

        public String getAtlasUrl() {
            return atlasUrl;
        }

        public void setAtlasUrl(String atlasUrl) {
            this.atlasUrl = atlasUrl;
        }

        public String getFjsydDb() {
            return fjsydDb;
        }

        public void setFjsydDb(String fjsydDb) {
            this.fjsydDb = fjsydDb;
        }

        public String getFjsydTable() {
            return fjsydTable;
        }

        public void setFjsydTable(String fjsydTable) {
            this.fjsydTable = fjsydTable;
        }

        public String getFjsydShapeField() {
            return fjsydShapeField;
        }

        public void setFjsydShapeField(String fjsydShapeField) {
            this.fjsydShapeField = fjsydShapeField;
        }

        public String getHzField() {
            return hzField;
        }

        public void setHzField(String hzField) {
            this.hzField = hzField;
        }

        public String getFjsydDlmcField() {
            return fjsydDlmcField;
        }

        public void setFjsydDlmcField(String fjsydDlmcField) {
            this.fjsydDlmcField = fjsydDlmcField;
        }

        public String getFjsydPkField() {
            return fjsydPkField;
        }

        public void setFjsydPkField(String fjsydPkField) {
            this.fjsydPkField = fjsydPkField;
        }
    }



    private class TempParam
    {
        private String atlasId;
        private String tempTable;
        private String resultTable;
        private Integer atlasState;

        public String getAtlasId() {
            return atlasId;
        }

        public void setAtlasId(String atlasId) {
            this.atlasId = atlasId;
        }

        public String getTempTable() {
            return tempTable;
        }

        public void setTempTable(String tempTable) {
            this.tempTable = tempTable;
        }

        public String getResultTable() {
            return resultTable;
        }

        public void setResultTable(String resultTable) {
            this.resultTable = resultTable;
        }

        public Integer getAtlasState() {
            return atlasState;
        }

        public void setAtlasState(Integer atlasState) {
            this.atlasState = atlasState;
        }
    }

    private class TempGeo
    {
        private int index;
        private Geometry geo;

        public int getIndex() {
            return index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Geometry getGeo() {
            return geo;
        }

        public void setGeo(Geometry geo) {
            this.geo = geo;
        }
    }
}
