package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.geoway.landteam.customtask.repository.task.TbsysUserTrackRecordRepository;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.task.entity.TbsysUserTrackRecord;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission
 * @date 2022/3/10 16:44
 */
@Slf4j
@Service
public class InnerUserTrackTransmitAcceptService {

    @Value("${project.uploadDir}")
    String uploadDir;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TbsysUserTrackRecordRepository tbsysUserTrackRecordRepository;

    public void execute(com.alibaba.fastjson.JSONObject jsonObject, Map<String,String> fileMap, File dbFile) {
        try {
             String type = jsonObject.getString("type");
             Long userId = jsonObject.getLong("userId");
              handDbFile(dbFile,userId);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 处理DB文件
     * @param dbFile
     */
    public void handDbFile( File dbFile,Long userId){
        try {
        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(" select * from track");
            List<TbsysUserTrackRecord> tbsysUserTrackRecordList = new ArrayList<>();
            while (rs.next()) {
                TbsysUserTrackRecord bean = new TbsysUserTrackRecord();
                bean.setId(rs.getString("f_id"));
                bean.setLat(rs.getDouble("f_lat"));
                bean.setLon(rs.getDouble("f_lon"));
                bean.setPlanId(rs.getString("f_jhid"));
                bean.setXsrwId(rs.getString("f_xsrwid"));
                if (rs.findColumn("f_batch") > 0) {
                    bean.setBatch(rs.getString("f_batch"));
                }
                bean.setUserId(userId);
                bean.setCreateTime(new Timestamp(Long.valueOf(rs.getString("f_createtime"))));
                tbsysUserTrackRecordList.add(bean);
                if (tbsysUserTrackRecordList.size() >= 500) {
                    tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
                    tbsysUserTrackRecordList.clear();
                }
            }
            if (tbsysUserTrackRecordList.size() > 0) {
                tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
            }
            // 关闭连接并删除缓存文件
            connPool.closeAll(connection, statement, rs);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }
}
