package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.customtask.repository.task.TbsysInspectionRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.task.entity.TbsysInspectionRecord;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserApplication;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.model.user.entity.UserRoleInfo;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.OrganizationService;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.oauth.SyncUserInfo;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterUserTransmitDataService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.google.common.collect.Lists;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.networkTransmission.service
 * @date 2022/3/1 16:19
 */
@Slf4j
@Service
@Transactional(rollbackFor = {Exception.class})
public class InnerUserTransmitAcceptService {
    private GiLoger logger = GwLoger.getLoger(InnerUserTransmitAcceptService.class);
    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${oauth.appkey}")
    protected String appkey;

    @Value("${oauth.appkeys}")
    protected String appkeys;
    @Autowired
    LandRegUserRepository landRegUserRepository;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    LandUserService userService;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Autowired
    UserRoleInfoRepository userRoleInfoDao;
    @Autowired
    UserApplicationRepository userApplicationDao;
    @Resource
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    UserCloudAreaRepository userCloudAreaDao;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Autowired
    UisApplicationRepository UisApplicationDao;
    @Autowired
    OrganizationRepository organizationRepository;
    @Autowired
    OrganizationService organizationService;
    @Autowired
    TbsysInspectionRecordRepository tbsysInspectionRecordRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    OauthUserService oauthUserService;

    public void execute(JSONObject jsonObject, Map<String,String> fileMap, File dbFile) {
        try {
            handData(jsonObject);
        } catch (Exception e) {
            logger.error("内网用户接收异常:"+ ExceptionUtil.getStackTrace(e));
        }
    }

    public void handData(JSONObject jsonObject) throws Exception {
        String type  = jsonObject.getString("type");
        if(StringUtils.isNotBlank(type)){
            switch (type) {
                case "insert":
                {
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.syncAddBusUser(landUser);
                }
                break;
                case "update": {
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.syncUpdateBusUser(landUser);
                }
                break;
                case "updatePassWord" :{
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.changePasswordByUsername(landUser.getUserName(),landUser.getPassWord());
                }
                case "updatePhoneNumber" :{
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.renewPhoneNum(landUser.getMidUserId(),landUser.getPhone());
                }
                break;
                /*
                case "delete" :{
                    Long userId = jsonObject.getLongValue("userId");
                    String deleteReason = jsonObject.getString("userRegionCode");
                    LandUser user = landUserDao.findById(userId).orElse(null);
                    if (user != null) {
                        userService.deleteUserByLiaison(101L, Long.valueOf(userId), deleteReason);
                        //删除云查询角色
                        roleCloudQueryRelRepository.deleteByUid(userId.toString());
                        //删除用户right_area信息
                        tskRightAreaRepository.deleteByUserId(userId.toString());

                    }
                }
                break;
                */
                case "forbidden" :{
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.setUserEnable(landUser.getMidUserId(),landUser.getEnable());
                }
                break;
                case "register" :{
                    LandRegUser landRegUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("landRegUser"), LandRegUser.class);
                    landRegUserRepository.save(landRegUser);
                }
                break;
                case "zeroReport" :{
                    if(jsonObject.get("TbsysInspectionRecord")!=null){
                        TbsysInspectionRecord record  = JSONObject.toJavaObject(jsonObject.getJSONObject("TbsysInspectionRecord"), TbsysInspectionRecord.class);
                        tbsysInspectionRecordRepository.save(record);
                    }
                }
                break;
                case "patrolCase" :{
                    if(jsonObject.get("PatrolGzqk")!=null){
                        JSONObject patrolGzqk = jsonObject.getJSONObject("PatrolGzqk");
                        StringBuffer sql = new StringBuffer();
                        sql.append("insert into tb_patrol_gzqk (f_id, f_planid, f_xsrwid,  f_xcsj, f_xcry, f_xcqylx, f_qxywlx, f_xclx, f_xcjbqk,  f_createtime, f_userid) values (");
                        sql.append("'"+patrolGzqk.getString("fId")+"',");
                        sql.append("'"+patrolGzqk.getString("fPlanid")+"',");
                        sql.append("'"+patrolGzqk.getString("fXsrwid")+"',");
                        String fXcsj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(patrolGzqk.get("fXcsj"));
                        sql.append("'"+fXcsj+"',");
                        sql.append("'"+patrolGzqk.getString("fXcry")+"',");
                        sql.append("'"+patrolGzqk.getString("fXcqylx")+"',");
                        sql.append("'"+patrolGzqk.getString("fQxywlx")+"',");
                        sql.append("'"+patrolGzqk.getString("fXclx")+"',");
                        sql.append("'"+patrolGzqk.getString("fXcjbqk")+"',");
                        String fCreatetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(patrolGzqk.get("fXcsj"));
                        sql.append("'"+fCreatetime+"',");
                        sql.append(patrolGzqk.getInteger("fUserid")+")");
                        jdbcTemplate.execute(sql.toString());
                    }
                }
                break;
                default: {
                    throw new GwValidateException("任务数据类型错误");
                }
            }
        }
    }
}
