package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.GeometryUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.AtlasTaskInfo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.xzjsydmj.MXzjsydmjService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.jms.MapMessage;
import javax.sql.DataSource;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class InnerXzjsydmjResolverAdapterConsumer implements IConsumerStrategyService {

    GiLoger logger = GwLoger.getLoger(InnerXzjsydmjResolverAdapterConsumer.class);

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.xzjsydmj.appkey:}")
    String transmitAppkey;
    @Value("${transmit.xzjsydmj.module:}")
    String transmitModule;

    @Autowired
    protected SysConfigService sysConfigService;

    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;



    @Autowired
    MXzjsydmjService mXzjsydmjService;

    String key="xzjsydmj-config";

    @Override
    public String getCode() {
        return "INNER-XZJSYDMJ";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        String messageId="";
        File recvFile = null;
        try {
            SysConfig sysconfig = sysConfigService.findOne(key);
            if(sysconfig==null)
            {
                logger.error("内网网间传输接收XZJSYDMJ任务处理失败,未配置擦除数据及擦除分析服务");
                return;
            }

            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\", "");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");

            if (StringUtils.isNotBlank(storageType)) {
                if ("0".equals(storageType.trim())) { //共享文件路径
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new", "/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                } else if ("1".equals(storageType.trim())) { //Ftp方式
                    String storageUrl = mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/" + purl.substring(0, purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/") + 1, purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?") + 1, purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];

                    recvFile = buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip, Integer.valueOf(port), userName, possWord);
                    if (ftpClient != null) {
                        try {
                            FileUtils.copyInputStreamToFile(FtpUtil.getFTPFileInputStream(ftpClient, filepath, fileName), recvFile);
                        } catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            //关闭ftp连接
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                } else if ("2".equals(storageType.trim())) { //文件存储
                    String objectStorag = mapMessage.getString("objectStorage");
                    if(StringUtils.isNotBlank(objectStorag)){
                        URL url = new URL(objectStorag);
                        HttpURLConnection conn = null;
                        if (url != null) {
                            conn = (HttpURLConnection) url.openConnection();
                            conn.setConnectTimeout(3 * 1000);
                            conn.setRequestProperty("Charset", "UTF-8");
                            recvFile = buildTempUploadFile();
                            FileUtils.copyInputStreamToFile(conn.getInputStream(), recvFile);
                        }
                        conn.disconnect();
                    }
                }
            }
            mXzjsydmjService.resoveInner(recvFile);
        } catch (Exception e) {
            logger.error(e);
        }
        finally {
            FileUtils.deleteQuietly(recvFile);
            if(StringUtils.isNotBlank(messageId))
            {
                try {
                    JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRequestById(messageId, transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex)
                {
                    logger.error("网间传输回调异常"+ ExceptionUtil.getErrorString(ex));
                }
            }
        }
    }
    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("xzjsydmj-%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if (uploadDir == null) {
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }




}
