package com.geoway.landteam.landcloud.service.networkTransmission.inner;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.DbResolverProvider;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.DirectoryResolverProvider;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.jms.MapMessage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/7/26
 * @Description
 **/
@Service
public class WpzfMessageConsumerImpl implements IConsumerStrategyService {

    GiLoger logger = GwLoger.getLoger(WpzfMessageConsumerImpl.class);
    private static final String UNZIP_PASSWORD = "cc9b219c799c417ca95418ef5f0e05e5";

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;

    @Autowired
    protected SysConfigService sysConfigService;
    @Autowired
    protected DbResolverProvider dbResolverProvider;
    @Autowired
    protected DirectoryResolverProvider directoryResolverProvider;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;

    @Override
    public String getCode() {
        return "WPZF";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        String messageId="";
        try {
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\","");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File recvFile = null;
            if(StringUtils.isNotBlank(storageType)){
                if("0".equals(storageType.trim())){ //共享文件路径
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new","/mnt/smb/baseout-new/");
                    recvFile = new File(recvpath);
                }else if("1".equals(storageType.trim())){ //Ftp方式
                    String storageUrl =  mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/"+purl.substring(0,purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/")+1,purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?")+1,purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];

                    recvFile = buildTempUploadFile();
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip,Integer.valueOf(port),userName,possWord);
                    if(ftpClient != null){
                        try {
                            FileUtils.copyInputStreamToFile(FtpUtil.getFTPFileInputStream(ftpClient,filepath,fileName), recvFile);
                        }  catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            //关闭ftp连接
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                }else if("2".equals(storageType.trim())){ //文件存储
                    String objectStorag = mapMessage.getString("objectStorage");
                    if(StringUtils.isNotBlank(objectStorag)){
                        String signed = temporarySignedUrlService.getTemporarySignedUrl("",objectStorag,null);
                        URL url = new URL(signed);
                        HttpURLConnection conn = null;
                        if (url != null) {
                            conn = (HttpURLConnection) url.openConnection();
                            conn.setConnectTimeout(3 * 1000);
                            conn.setRequestProperty("Charset", "UTF-8");
                            recvFile = buildTempUploadFile();
                            FileUtils.copyInputStreamToFile(conn.getInputStream(), recvFile);
                        }
                        conn.disconnect();
                    }
                }
            }
            String zipName = recvFile.getAbsolutePath();
            // String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            String unzipFileDir = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            //解压文件路径
            FileUtil.creatDirectoryIfNotExist(unzipFileDir);
            //解压文件
            Zip4jUtils.unzip(zipName, unzipFileDir, UNZIP_PASSWORD,true);

            File unzipPath = new File(unzipFileDir);
            File[] contents = unzipPath.listFiles();
            File dbFile = Arrays.stream(contents)
                    .filter(f -> f.getName().endsWith(".db"))
                    .findFirst()
                    .orElseThrow(() -> new RuntimeException("无效的db文件"));
            SqlliteConnTool connTool = null;
            try {
                connTool = new SqlliteConnTool(dbFile.getAbsolutePath());
                String sql = "select code from paraminfo";
                ResultSetInfo result = connTool.doQuery(sql);
                ResultSet rs = result.getResultSet();
                rs.next();
                String busiz = rs.getString("code");
                DbResolver resolver =  dbResolverProvider.getHandler(busiz);
                resolver.resolve(connTool);
                List<File> otherFiles = Arrays.stream(contents)
                        .filter(f -> !f.getName().endsWith(".db"))
                        .collect(Collectors.toList());


                AttachFileParam param = AttachFileParam.create(connTool,busiz);
                resolveOtherFiles(otherFiles,param);
            } finally {
                connTool.Dispose();
            }
            // 删除文件夹
            FileUtils.deleteQuietly(new File(unzipFileDir));
            // 删除文件夹
            FileUtils.deleteQuietly(recvFile);
        } catch (Exception e) {
            logger.error(ExceptionUtil.getErrorString(e));
        }
        finally {
            if(StringUtils.isNotBlank(messageId))
            {
                try {
                    JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRequestById(messageId, transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex)
                {
                    logger.error("网间传输回调异常"+ ExceptionUtil.getErrorString(ex));
                }
            }
        }
    }

    protected void resolveOtherFiles(List<File> files, AttachFileParam param) throws Exception {
        String resloverPrefix = "wpzf_";
        for(File file:files){
            directoryResolverProvider.handle(file,param,resloverPrefix + file.getName());
        }
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("wpzf-%s-%s.zip", sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if(uploadDir == null){
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }
}
