package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskTemplateService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.dto.AppConfigDTO;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.AESECB;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.FtpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TranFileUtil;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.jms.MapMessage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission.service
 * @date 2022/4/20 16:53
 */
@Slf4j
@Service
@Transactional(rollbackFor = {Exception.class})
public class OuterDataTransmitAcceptService implements IConsumerStrategyService {
    private final GiLoger logger = GwLoger.getLoger(OuterDataTransmitAcceptService.class);
    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;

    @Resource
    private DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    OuterUserTranAcceptService outerUserTranAcceptService;
    @Resource
    OuterTaskTransmitAcceptService outerTaskTransmitAcceptService;
    @Resource
    OuterProgramTransmitAcceptService outerProgramTransmitAcceptService;
    @Resource
    TbtskFieldsService tbtskFieldsService;
    @Resource
    TbtskTemplateService templateService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Autowired
    MDataBizService dataBizService;
    @Resource
    TbtskTaskClassRepository tbtskTaskClassRepository;

    @Override
    public String getCode() {
        return "OUTER-RECEIVE-MESSAGE";
    }

    @Override
    public void execute(MapMessage mapMessage) {
        String messageId="";
        try {
           /* String appkey = mapMessage.getString("appkey");
            String module = mapMessage.getString("module");*/
            String storageType = mapMessage.getString("storageType");
            messageId = mapMessage.getString("id");
            String name = mapMessage.getString("name");
            String path = mapMessage.getString("recvpath").replace("\\","");
            boolean useObjectStorage = mapMessage.getBoolean("useObjectStorage");
            File zipFile = null;
            if(StringUtils.isNotBlank(storageType)){
                if("0".equals(storageType.trim())){ //共享文件路径
                    String recvpath = path.substring(path.indexOf("baseout-new")).replace("baseout-new","/mnt/smb/baseout-new/");
                    zipFile = new File(recvpath);
                }else if("1".equals(storageType.trim())){ //Ftp方式
                    String storageUrl =  mapMessage.getString("storageUrl");
                    String ipport = storageUrl.split("//")[1];
                    String ip = ipport.split(":")[0];
                    String port = ipport.split(":")[1];
                    String purl = storageUrl.split("//")[2];
                    String filepath = "/"+purl.substring(0,purl.lastIndexOf("/"));
                    String fileName = purl.substring(purl.lastIndexOf("/")+1,purl.lastIndexOf("?"));
                    String ebString = purl.substring(purl.lastIndexOf("?")+1,purl.length());
                    String userNamePoss = AESECB.decrypt(messageId, ebString);
                    String userName = userNamePoss.split(":")[0];
                    String possWord = userNamePoss.split(":")[1];

                    zipFile = buildTempUploadFile("101");
                    FTPClient ftpClient = FtpUtil.getFtpClient(ip,Integer.valueOf(port),userName,possWord);
                    if(ftpClient != null){
                        try {
                            FileUtils.copyInputStreamToFile(FtpUtil.getFTPFileInputStream(ftpClient,filepath,fileName), zipFile);
                        }  catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            //关闭ftp连接
                            FtpUtil.disConnection(ftpClient);
                        }
                    }
                }else if("2".equals(storageType.trim())){ //文件存储
                    String objectStorag = mapMessage.getString("objectStorage");
                    if(StringUtils.isNotBlank(objectStorag)){
                        URL url = new URL(objectStorag);
                        HttpURLConnection conn = null;
                        if (url != null) {
                            conn = (HttpURLConnection) url.openConnection();
                            conn.setConnectTimeout(3 * 1000);
                            conn.setRequestProperty("Charset", "UTF-8");
                            zipFile = buildTempUploadFile("101");
                            FileUtils.copyInputStreamToFile(conn.getInputStream(), zipFile);
                        }
                        conn.disconnect();
                    }
                }
            }
            String zipName = zipFile.getAbsolutePath();
            // String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            String unzipFileDir = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            //解压文件路径
            FileUtil.creatDirectoryIfNotExist(unzipFileDir);
            //解压文件
            Zip4jUtils.unzip(zipName, unzipFileDir, "");
            resolveFiles(unzipFileDir);
            // 删除文件夹
            FileUtils.deleteQuietly(new File(unzipFileDir));
            FileUtils.deleteQuietly(zipFile);
         /*   //调用网间传输回调接口
            String transmitUrl = this.transmitUrl+"/monitor/trans/feedBack.action";
            JSONObject result = HttpUtil.sendRequestById(messageId ,transmitUrl);*/
        } catch (Exception e) {
            logger.error("接收内网推送数据包异常"+ ExceptionUtil.getErrorString(e));
        }
        finally {
            if(StringUtils.isNotBlank(messageId))
            {
                try {
                    JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRequestById(messageId, transmitUrl + "/monitor/trans/feedBack.action");
                }
                catch (Exception ex)
                {
                    logger.error("网间传输回调异常"+ ExceptionUtil.getErrorString(ex));
                }
            }
        }
    }



    public void resolveFiles(String unzipDir) throws Exception {
        File file = new File(unzipDir);
        File dbFile = null;
        File jsonFile = null;
        File[] content = file.listFiles();
        Map<String,String> fileMap = new HashMap<>();
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".json")) {
                jsonFile = content[j];
            }else if (content[j].getName().endsWith(".db")) {
                dbFile = content[j];
            }else{
                File mediafile =  content[j];
                String fiename = mediafile.getName();
                String sendObjName = "patrolTaskTran/media/" + fiename;
                // 上传到obs
                String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, mediafile);
                fileMap.put(fiename,resultUrl);
            }
        }
        String jsonContext = TranFileUtil.readFile(jsonFile.getAbsolutePath());
        JSONObject jsonObject = JSONObject.parseObject(jsonContext);
        String group = jsonObject.getString("group");
        if(StringUtils.isNotBlank(group)) {
            switch (group) {
                case "patrol": { //巡查任务
                    outerProgramTransmitAcceptService.execute(jsonObject);
                }
                break;
                case "user":{ //用户信息
                    outerUserTranAcceptService.execute(jsonObject);
                }
                break;
                case "task":{ //调查任务数据
                    String type = jsonObject.getString("type");
                    switch (type) {
                        case "addBiz": //新增任务
                        case "assignBiz": { //下发任务
                            outerTaskTransmitAcceptService.execute(jsonObject,fileMap,dbFile,type);
                        }
                        break;
                        case "pushTaskData": { //推送任务数据
                            outerTaskTransmitAcceptService.execute(jsonObject,fileMap,dbFile,type);
                        }
                        break;
                        case "updateGroup": { //更新分组
                            AppConfigDTO appconfig  = JSONObject.toJavaObject(jsonObject.getJSONObject("appconfig"), AppConfigDTO.class);
                            String sys = jsonObject.getString("sys");
                            tbtskFieldsService.saveAppConfigByTaskId(appconfig, sys);
                            TskTaskBiz task = tskTaskBizService.findByTableId(appconfig.getBizId());
                            task.setStructDbUrl(null);
                            tskTaskBizService.save(task);
                        }
                        break;
                        case "updateField": { //更新字段
                            TbtskFields field  = JSONObject.toJavaObject(jsonObject.getJSONObject("tbtskFields"), TbtskFields.class);
                            templateService.saveField(field);
                            TskTaskBiz task = tskTaskBizService.findByTableId(field.getfTableid());
                            task.setStructDbUrl(null);
                            tskTaskBizService.save(task);
                        }
                        break;
                        case "deleteTBData": { //删除图斑数据
                            String taskId = jsonObject.getString("taskId");
                            String dataIds = jsonObject.getString("dataIds");
                            TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
                            if(taskBiz != null){
                                tskTaskBizService.deleteBatchByDataId(dataIds, taskId);
                                TbtskObjectinfo tableInfo = tskTaskBizService.getTableByTableId(taskBiz.getTableId());
                                if(StringUtils.isNotBlank(tableInfo.getfTablename())){
                                    Integer count = dataBizService.getCount(tableInfo.getfTablename(), "");
                                    taskBiz.setTotal(count);
                                    tskTaskBizService.update(taskBiz);
                                }
                            }
                        }
                        default: {
                            throw new GwValidateException("数据类型错误");
                        }
                    }
                }
                break;
                case "taskClass":{ //业务大类
                    String type = jsonObject.getString("type");
                    switch (type) {
                        case "insert":
                        case "update": { //更新分组
                            TbtskTaskClass tbtskTaskClass  = JSONObject.toJavaObject(jsonObject.getJSONObject("TbtskTaskClass"), TbtskTaskClass.class);

                            TbtskTaskClass save = tbtskTaskClassRepository.save(tbtskTaskClass);
                            tbtskTaskClassRepository.updateIdById(tbtskTaskClass.getId(),save.getId());
                        }
                        break;
                        case "delete": { //更新字段
                            String id = jsonObject.getString("id");
                            TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(Long.parseLong(id));
                            if (tbtskTaskClass == null) {
                                throw new RuntimeException("该业务类型不存在，请检查参数");
                            }
                            tbtskTaskClassRepository.deleteById(Long.parseLong(id));
                        }
                        break;
                        default: {
                            throw new GwValidateException("数据类型错误");
                        }
                    }
                }
                break;
                default: {
                    throw new GwValidateException("数据类型错误");
                }
            }
        }
    }

    private File buildTempUploadFile(String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("tran-%s-%s-%s.zip", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if(uploadDir == null){
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }
}
