package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.*;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.*;
import com.gw.base.data.GwValidateException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission.service
 * @date 2022/3/5 15:18
 */
@Slf4j
@Service
public class OuterProgramTransmitAcceptService {

    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.task.appkey:}")
    String transmitAppkey;
    @Value("${transmit.task.module:}")
    String transmitModule;
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    
    @Autowired
    PatrolPlanAreaMapper patrolPlanAreaMapper;

    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    PatrolPlanContentMapper patrolPlanContentMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Autowired
    PatrolPlanScopeServiceMapper patrolPlanScopeServiceMapper;
    @Autowired
    PatrolProgramMapper patrolProgramMapper;

    public void execute(com.alibaba.fastjson.JSONObject jsonObject) {
        try {
            handPatrolData(jsonObject);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 处理巡查任务相关数据
     * @param jsonObject
     * @throws Exception
     */
    public void handPatrolData(JSONObject jsonObject) throws Exception {
        String type = jsonObject.getString("type");
        switch (type) {
            case "insert": {
                if(jsonObject.getJSONObject("patrolPlan") != null){
                    PatrolPlan patrolPlan  = JSONObject.toJavaObject(jsonObject.getJSONObject("patrolPlan"), PatrolPlan.class);
                    patrolPlanMapper.gwDeleteByPK(patrolPlan.getfId());
                    patrolPlanMapper.insert(patrolPlan);
                }
                if(jsonObject.getJSONObject("PatrolProgram") != null){
                    PatrolProgram patrolProgram  = JSONObject.toJavaObject(jsonObject.getJSONObject("PatrolProgram"), PatrolProgram.class);
                    patrolProgramMapper.gwDeleteByPK(patrolProgram.getfId());
                    patrolProgramMapper.insert(patrolProgram);
                }
                if(jsonObject.getJSONArray("patrolPlanArea") != null){
                    JSONArray objects = jsonObject.getJSONArray("patrolPlanArea");
                    if(!objects.isEmpty()){
                        List<PatrolPlanArea> patrolPlanAreas = objects.toJavaList(PatrolPlanArea.class);
                        patrolPlanAreaMapper.deleteByPlanId(patrolPlanAreas.get(0).getfPlanid());
                        for(PatrolPlanArea p : patrolPlanAreas){
                            patrolPlanAreaMapper.gwDeleteByPK(p.getfId());
                            patrolPlanAreaMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("patrolPlanTask") != null){
                    JSONArray objects = jsonObject.getJSONArray("patrolPlanTask");
                    if(!objects.isEmpty()){
                        List<PatrolPlanTask> patrolPlanTasks = objects.toJavaList(PatrolPlanTask.class);
                        patrolPlanTaskMapper.deleteByPlanId(patrolPlanTasks.get(0).getfPlanid());
                        for(PatrolPlanTask p : patrolPlanTasks){
                            patrolPlanTaskMapper.gwDeleteByPK(p.getfId());
                            patrolPlanTaskMapper.insertSelective(p);
                        }
                    }

                }
                if(jsonObject.getJSONArray("PatrolPlanScope") != null){
                    JSONArray objects = jsonObject.getJSONArray("PatrolPlanScope");
                    if(!objects.isEmpty()){
                        List<PatrolPlanScope> patrolPlanScopes = objects.toJavaList(PatrolPlanScope.class);
                        List<String> ids = patrolPlanScopes.stream().map(PatrolPlanScope::getfId).collect(Collectors.toList());
                        patrolPlanScopeMapper.deleteByIds(ids);
                        for(PatrolPlanScope p : patrolPlanScopes){
                            patrolPlanScopeMapper.gwDeleteByPK(p.getfId());
                            patrolPlanScopeMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("PatrolPlanContent") != null){
                    JSONArray objects = jsonObject.getJSONArray("PatrolPlanContent");
                    if(!objects.isEmpty()){
                        List<PatrolPlanContent> patrolPlanContents = objects.toJavaList(PatrolPlanContent.class);
                        patrolPlanContentMapper.deleteByPlanId(patrolPlanContents.get(0).getfPlanid());
                        patrolPlanContentMapper.insertList(patrolPlanContents);
                        for(PatrolPlanContent p : patrolPlanContents){
                            patrolPlanContentMapper.gwDeleteByPK(p.getfId());
                            patrolPlanContentMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("PatrolPlanScopeService") != null){
                    JSONArray objects = jsonObject.getJSONArray("PatrolPlanScopeService");
                    if(!objects.isEmpty()){
                        List<PatrolPlanScopeService> patrolPlanScopeServices = objects.toJavaList(PatrolPlanScopeService.class);
                        patrolPlanScopeServiceMapper.deleteByPlanId(patrolPlanScopeServices.get(0).getfPlanid());
                        for(PatrolPlanScopeService p : patrolPlanScopeServices){
                            patrolPlanScopeServiceMapper.gwDeleteByPK(p.getfId());
                            patrolPlanScopeServiceMapper.insertSelective(p);
                        }
                    }
                }
            }
            break;
            case "update" :{
                String planId = "";
                if(jsonObject.get("patrolPlan") != null){
                    PatrolPlan patrolPlan  = JSONObject.toJavaObject(jsonObject.getJSONObject("patrolPlan"), PatrolPlan.class);
                    planId = patrolPlan.getfId();
                    patrolPlanMapper.deleteByPrimaryKey(patrolPlan.getfId());
                    patrolPlanMapper.insert(patrolPlan);
                }
                if(jsonObject.getJSONObject("PatrolProgram") != null){
                    PatrolProgram patrolProgram  = JSONObject.toJavaObject(jsonObject.getJSONObject("PatrolProgram"), PatrolProgram.class);
                    patrolProgramMapper.gwDeleteByPK(patrolProgram.getfId());
                    patrolProgramMapper.insert(patrolProgram);
                }
                if(jsonObject.getJSONArray("patrolPlanArea") != null){
                    JSONArray objects = jsonObject.getJSONArray("patrolPlanArea");
                    if(!objects.isEmpty()){
                        List<PatrolPlanArea> patrolPlanAreas = objects.toJavaList(PatrolPlanArea.class);
                        //删除范围数据，重新新增
                        patrolPlanAreaMapper.deleteByPlanId(planId);
                        //新增范围数据
                        for(PatrolPlanArea p : patrolPlanAreas){
                            patrolPlanAreaMapper.gwDeleteByPK(p.getfId());
                            patrolPlanAreaMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("patrolPlanTask") != null){
                    JSONArray objects = jsonObject.getJSONArray("patrolPlanTask");
                    if(!objects.isEmpty()){
                        List<PatrolPlanTask> patrolPlanTasks = objects.toJavaList(PatrolPlanTask.class);
                        if(StringUtils.isNotBlank(planId)){
                            //删除任务
                            patrolPlanTaskMapper.deleteByPlanId(planId);
                        }
                        //新增任务
                        for(PatrolPlanTask p : patrolPlanTasks){
                            patrolPlanTaskMapper.gwDeleteByPK(p.getfId());
                            patrolPlanTaskMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("PatrolPlanContent") != null){
                    JSONArray objects = jsonObject.getJSONArray("PatrolPlanContent");
                    if(!objects.isEmpty()){
                        List<PatrolPlanContent> patrolPlanContents = objects.toJavaList(PatrolPlanContent.class);
                        if(StringUtils.isNotBlank(planId)){
                            //删除内容
                            patrolPlanContentMapper.deleteByPlanId(planId);
                        }
                        for(PatrolPlanContent p : patrolPlanContents){
                            patrolPlanContentMapper.gwDeleteByPK(p.getfId());
                            patrolPlanContentMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("PatrolPlanScope") != null){
                    JSONArray objects = jsonObject.getJSONArray("PatrolPlanScope");
                    if(!objects.isEmpty()){
                        List<PatrolPlanScope> patrolPlanScopes = objects.toJavaList(PatrolPlanScope.class);
                        if(StringUtils.isNotBlank(planId)){
                            //删除范围
                            List<String> scopeByFPlanid = patrolPlanScopeServiceMapper.queryByPlanId(planId);
                            if(!scopeByFPlanid.isEmpty()){
                                patrolPlanScopeMapper.deleteByIds(scopeByFPlanid);
                            }
                        }
                        for(PatrolPlanScope p : patrolPlanScopes){
                            patrolPlanScopeMapper.gwDeleteByPK(p.getfId());
                            patrolPlanScopeMapper.insertSelective(p);
                        }
                    }
                }
                if(jsonObject.getJSONArray("PatrolPlanScopeService") != null){
                    JSONArray objects = jsonObject.getJSONArray("PatrolPlanScopeService");
                    if(!objects.isEmpty()){
                        List<PatrolPlanScopeService> patrolPlanScopeServices = objects.toJavaList(PatrolPlanScopeService.class);
                        if(StringUtils.isNotBlank(planId)){
                            patrolPlanScopeServiceMapper.deleteByPlanId(planId);
                        }
                        for(PatrolPlanScopeService p : patrolPlanScopeServices){
                            patrolPlanScopeServiceMapper.gwDeleteByPK(p.getfId());
                            patrolPlanScopeServiceMapper.insertSelective(p);
                        }
                    }
                }
            }
            break;
            case "delete" :{
                if(jsonObject.get("planId") != null){
                    String planId = jsonObject.getString("planId");
                    //删除计划
                    patrolPlanMapper.deleteByPrimaryKey(planId);
                    //删除范围
                    patrolPlanAreaMapper.deleteByPlanId(planId);
                    //删除任务
                    patrolPlanTaskMapper.deleteByPlanId(planId);
                    //删除内容
                    patrolPlanContentMapper.deleteByPlanId(planId);
                    //删除范围
                    List<String> scopeByFPlanid = patrolPlanScopeServiceMapper.queryByPlanId(planId);
                    if(!scopeByFPlanid.isEmpty()){
                        patrolPlanScopeMapper.deleteByIds(scopeByFPlanid);
                    }
                    //删除服务
                    patrolPlanScopeServiceMapper.deleteByPlanId(planId);
                }
            }
            break;
            case "revoke" :{
                if(jsonObject.getJSONObject("patrolPlan") != null){
                    PatrolPlan patrolPlan  = JSONObject.toJavaObject(jsonObject.getJSONObject("patrolPlan"), PatrolPlan.class);
                    patrolPlanMapper.deleteByPrimaryKey(patrolPlan.getfId());
                    patrolPlanMapper.insert(patrolPlan);
                    patrolPlanTaskMapper.deleteByPlanId(patrolPlan.getfId());
                }
            }
            break;
            default: {
                throw new GwValidateException("任务数据类型错误");
            }
        }

    }

}
