package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.dao.task.TbtskRevokeRecordDao;
import com.geoway.landteam.customtask.dao.task.TbtskSubmitReportRecordDao;
import com.geoway.landteam.customtask.dao.task.TbtskSyncRecordDao;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskRejectRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRecordRepository;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TaskUtils;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.geolatte.geom.M;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.networkTransmission.outer
 * @date 2023/11/7 9:46
 */
@Slf4j
@Service
public class OuterTaskDataSyncService {

    private GiLoger logger = GwLoger.getLoger(OuterTaskTransmitDataService.class);
    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.task.appkey:}")
    String transmitAppkey;
    @Value("${transmit.task.module:}")
    String transmitModule;

    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskAssignJobService taskAssignJobService;
    @Resource
    DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    TemporarySignedUrlService temporarySignedUrlService;
    @Resource
    AppMediaRepository appMediaRepository;
    @Resource
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Resource
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Resource
    TbtskRevokeRecordDao tbtskRevokeRecordDao;
    @Resource
    TbtskSubmitReportRecordDao tbtskSubmitReportRecordDao;
    @Autowired
    TbtskSyncRecordDao tbtskSyncRecordDao;
    @Autowired
    MDataBizService dataBizService;


    public void doWork(String taskId, List<TbtskSyncRecord> list) throws Exception {
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo table = tskTaskBizService.getTableByTableId(task.getTableId());
        //获取数据
        List<String> dataIds = list.stream().filter(r->r.getDataId()!=null).map(r->r.getDataId()).collect(Collectors.toList());
        String sql = "select * from " + table.getfTablename() + " where  f_id  in('" + StringUtils.join(dataIds.toArray(), "','") + "')";
        List<Map> tempList = dataBizService.queryDataBySql(sql);
        try {
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 01.先根据 taskid生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table,task, statement);
            // 导入图斑数据
            Set<String> set = taskAssignJobService.insertData(tempList,statement, table, "2");
            //生成附件数据
            List<String> allDataIds = new ArrayList<>();
            allDataIds.addAll(dataIds);
            if(StringUtils.isNotBlank(table.getSplitTableName()) && dataBizService.isExistTableName(table.getSplitTableName())){
                String childsql = "select f_id from "+ table.getSplitTableName()+ " where f_splitedid  in('" + StringUtils.join(dataIds.toArray(), "','") + "')";
                List<Map> childList = dataBizService.queryDataBySql(childsql);
                if(childList.size() > 0 ){
                    for(Map mapdata :childList ){
                        String f_id = MapUtils.getString(mapdata, "f_id");
                        allDataIds.add(f_id);
                    }
                }
            }
            List<AppMedia> listMedia = appMediaRepository.queryByGalleryids(allDataIds);
            List<AppMedia> mediaList = new ArrayList<>();
            for(int i = 0; i<listMedia.size();i++){
                    String accessUrl = "";
                    if (listMedia.get(i).getServerpath() != null && !listMedia.get(i).getServerpath().contains("AccessKeyId")) {
                        accessUrl = temporarySignedUrlService.getTemporarySignedUrl("", listMedia.get(i).getServerpath(), null);
                    }
                    String fiename = listMedia.get(i).getServerpath().substring(listMedia.get(i).getServerpath().lastIndexOf("/") + 1, listMedia.get(i).getServerpath().length());
                    String path = tempFolderPath + File.separator + fiename;
                    File lsFile = new File(path);
                    if (!lsFile.exists()) {
                        FileUtils.copyURLToFile(new URL(accessUrl), lsFile);
                    }
                    mediaList.add(listMedia.get(i));
            }
            //生成任务附件结构和数据
            TaskUtils.createMdeiaStruct(mediaList,statement);
            JSONObject jsonObject = new JSONObject();
            //获取审核相关数据
            //审核表
            List<TbtskApproveRecord> tbtskApproveRecords = tbtskApproveRecordRepository.findApproveRecordOrderByIds (taskId, dataIds);
            jsonObject.put("TbtskApproveRecords", JSONObject.toJSONString(tbtskApproveRecords, SerializerFeature .WriteMapNullValue));
            //打回表
            List<TbtskRejectRecord> tbtskRejectRecords = tbtskRejectRecordRepository.findByTaskIdAndTbIds(taskId, dataIds);
            jsonObject.put("TbtskRejectRecords", JSONObject.toJSONString(tbtskRejectRecords, SerializerFeature .WriteMapNullValue));
            //撤销表
            List<TbtskRevokeRecord> tbtskRevokeRecords =  tbtskRevokeRecordDao.selectByTaskIdAndTbIds(taskId, dataIds);
            jsonObject.put("TbtskRevokeRecords", JSONObject.toJSONString(tbtskRevokeRecords, SerializerFeature .WriteMapNullValue));
            //提报表
            List<TbtskSubmitReportRecord> tbtskSubmitReportRecords =  tbtskSubmitReportRecordDao.queryByDataids(taskId, dataIds);
            jsonObject.put("TbtskSubmitReportRecords", JSONObject.toJSONString(tbtskSubmitReportRecords, SerializerFeature.WriteMapNullValue));
            // 关闭连接
            tool.closeAll(conn, statement, null);
            // 03.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();

            //1 新增任务 2 更新任务结构 3 更新数据
            jsonObject.put("mode","3");
            jsonObject.put("group","task");
            jsonObject.put("userId",101);
            jsonObject.put("taskId",taskId);
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(task.getName()).append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            String url = afterExport(101L , tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix +".zip"), transmitUrl+"/monitor/trans/transData.action");
            /*  publishTranMsg(fileNameNoSuffix + ".zip");*/
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
            FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            logger.error(e);
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
    }


    /**
     * 压缩文件
     * @param userId
     * @param tempFolderPath
     * @param safeFileName
     * @param fileNameNoSuffix
     * @return
     */
    public  String afterExport(Long userId,String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url ="";
        logger.info( " 开始压缩成zip文件 ");
        Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", false, "");
        //url =  uploadFileToCloudDisk(userId, safeFileName);
        /*String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 计算大小
        Double zipFileSize = new File(zipFile).length() / 1024d;*/
        return url;
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */


    public  String  uploadFileToCloudDisk(Long userId, String safeFileName) {
        // 注意：这里不能用File.separator 替代"/"，OBS上路径分隔符用"/",而File.separator默认为:"\"
        String sendObjName = "taskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 上传到obs
        String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }


}
