package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.task.TbtskTaskFieldsAddDao;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.sql.*;
import java.util.*;
import java.util.Date;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission
 * @date 2022/2/24 16:44
 */
@Slf4j
@Service
public class OuterTaskTransmitAcceptService {

    @Value("${project.uploadDir}")
    String uploadDir;

    private final GiLoger logger = GwLoger.getLoger(OuterTaskTransmitAcceptService.class);
    @Resource
    DataBizService dataBizService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskRecordService taskRecordService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    TbtskTaskFieldsAddDao tbtskTaskFieldsAddDao;


    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;

    public void execute(com.alibaba.fastjson.JSONObject jsonObject, Map<String,String> fileMap, File dbFile,String type) {
        try {
            String taskId = jsonObject.getString("taskId");
            String mode = jsonObject.getString("mode");
            Long userId = jsonObject.getLong("userId");
            if(jsonObject.get("taskArea") != null){
                String taskArea = jsonObject.getString("taskArea");
                if(StringUtils.isNotBlank(taskArea)){
                    tskTaskBizService.saveBizArea(taskId,taskArea);
                }
            }
            TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
            if("1".equals(mode)){
                if(task == null){
                    handDbFile(dbFile,true,type);
                }else{
                    handDbFile(dbFile,false,type);
                }
                task = tskTaskBizService.findByTaskId(taskId);
                if (StringUtils.isBlank(task.getStructDbUrl())) {
                    String dbUrl = createStructDB(taskId, userId.toString());
                    task.setStructDbUrl(dbUrl);
                    tskTaskBizService.update(task);
                }
            }
            if(task == null){
                task = tskTaskBizService.findByTaskId(taskId);
            }
            //下发数据
            if(task !=null && type.equals("assignBiz")){
                //下发数据
                JSONArray userIds =jsonObject.getJSONArray("assignUserIds");
                JSONArray tbIds = jsonObject.getJSONArray("tbIds");
                assignTask(userId,task,parseStringList(userIds),parseStringList(tbIds));
            }else if(task !=null && type.equals("pushTaskData")){ //推送任务数据，不进行下发 配置任务管理员和创建者
                 if(jsonObject.containsKey("taskCreateUserId")){
                     Long taskCreateUserId = jsonObject.getLongValue("taskCreateUserId");
                     // 任务授权给创建者
                     createTaskRole(task.getId(),0,taskCreateUserId);
                     //任务创建者同为管理员
                     createTaskRole(task.getId(),1,taskCreateUserId);
                     //任务创建者同为管理员
                     createTaskRole(task.getId(),1,userId);
                 }else{
                     //任务创建者同为管理员
                     createTaskRole(task.getId(),1,userId);
                 }
            }
        } catch (Exception e) {
            logger.error("接收内网推送数据包异常"+ ExceptionUtil.getErrorString(e));
        }
    }
    /**
     * com.alibaba.fastjson.JSONArray.toJavaList方法Line:547 在转换为String时有bug,
     * 源码中缺少从Stringd到String类型的converter,jsonarray中有String类型元素时会报错
     */
    private List<String> parseStringList(JSONArray jsonArray){
        List<String> strJsonarray = (List<String>) jsonArray.stream().
                filter(e -> e != null)
                .map(Object::toString)
                .collect(Collectors.toList());
        return strJsonarray;
    }
    /**
     * 处理DB文件
     * @param dbFile
     */
    public void handDbFile( File dbFile,Boolean isCreate,String type){
        Connection connection = null;
        Statement statement = null;
        SqlliteConnTool connPool = null;
        try {
            // 获取DB文件数据库连接
             connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
             connection = connPool.getConnection();
             statement = connection.createStatement();
            String taskId = "";
            String tableName = "";
            Map<Long,Long>mapClassId = new HashMap<>();
            if(existTable(statement,"tbtsk_task_class"))
            {
                String objectSql = "select * from tbtsk_task_class";
                ResultSet  objectRs = statement.executeQuery(objectSql);
                ResultSetMetaData objectmetaData = objectRs.getMetaData();
                List<TbtskTaskClass>taskClasses = new ArrayList<>();
                while (objectRs.next()) {
                    TbtskTaskClass t = new TbtskTaskClass();
                    t.setId(Long.parseLong(objectRs.getString("f_id")));
                    t.setName(objectRs.getString("f_name").toString());
                    t.setParentId(Long.parseLong(objectRs.getString("f_parentid")));
                    t.setUserId(Long.parseLong(objectRs.getString("f_userid")));
                    t.setLevel(Long.parseLong(objectRs.getString("f_level")));
                    taskClasses.add(t);
                }
                TbtskTaskClass root =  taskClasses.stream().filter(t->t.getLevel().equals(1)).findFirst().get();
                setChild(taskClasses,root);
                List<TbtskTaskClass>alls = tbtskTaskClassRepository.gwSearchAll();
                TbtskTaskClass finalRoot = root;
                TbtskTaskClass nameExist = alls.stream().filter(t->t.getName().equals(finalRoot.getName())).findFirst().orElse(null);
                if(nameExist==null)
                {
                    Long oldId = root.getId();
                    root.setId(null);
                    List<TbtskTaskClass>childs = root.getChildren();
                    root =  tbtskTaskClassRepository.save(root);
                    root.setChildren(childs);
                    saveChild(alls,root,mapClassId);
                    mapClassId.put(oldId,root.getId());
                }
                else
                {
                    Long oldId = root.getId();
                    root.setId(nameExist.getId());
                    saveChild(alls,root,mapClassId);
                    mapClassId.put(oldId,root.getId());
                }
            }
            // 支持同时上传多张表
            //处理任务表
            String sql = "select * from task_biz";
            ResultSet  rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                taskId = rs.getString("f_id");
                if(isCreate){
                    int rowSize = metaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = metaData.getColumnName(i);
                        Object obj = rs.getObject(labelName);
                        if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                            map.put(labelName, null);
                        }else{
                            //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                            if(obj instanceof String){
                                obj = ((String) obj).replaceAll("'","''");
                            }
                            map.put(labelName, obj);
                        }
                    }
                    map.put("f_source","内网任务");
                    map.put("f_struct_dburl",null);
                    Long classId = map.get("f_classid")==null?null:Long.parseLong(map.get("f_classid").toString());
                    if(mapClassId.containsKey(classId))
                    {
                        classId = mapClassId.get(classId);
                        map.put("f_classid",classId);
                    }
                    dataBizService.insertData("tbtsk_task_biz",map,null);
                }
            }

            //处理任务对象表
            if(existTable(statement,"task_objectinfo")) {
                    String objectSql = "select * from task_objectinfo";
                    ResultSet  objectRs = statement.executeQuery(objectSql);
                    ResultSetMetaData objectmetaData = objectRs.getMetaData();
                    while (objectRs.next()) {
                        tableName = objectRs.getString("f_tablename");
                        if(isCreate){
                            int rowSize = objectmetaData.getColumnCount();
                            Map<String, Object> map = new HashMap<>();
                            for (int i = 1; i <= rowSize; i++) {
                                String labelName = objectmetaData.getColumnName(i);
                                Object obj = objectRs.getObject(labelName);
                                if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                    map.put(labelName, null);
                                }else{
                                    //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                                    if(obj instanceof String){
                                        obj = ((String) obj).replaceAll("'","''");
                                    }
                                    map.put(labelName, obj);
                                }
                            }
                            dataBizService.insertData("tbtsk_objectinfo",map,null);
                        }
                    }
            }
            //处理任务字段表
            List<Map<String, Object>> addFields = new ArrayList<>();
            List<Map<String, Object>> fieldsFields = new ArrayList<>();
            TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
            List<TbtskFields> existFields = tskTaskBizService.getFieldsByTableId(taskBiz.getTableId());
            if (existTable(statement, "task_fields")) {
                String fieldSql = "select * from task_fields";
                ResultSet fieldRs = statement.executeQuery(fieldSql);
                ResultSetMetaData fieldmetaData = fieldRs.getMetaData();

                while (fieldRs.next()) {
                    int rowSize = fieldmetaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = fieldmetaData.getColumnName(i);
                        Object obj = fieldRs.getObject(labelName);
                        if (obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())) {
                            map.put(labelName, null);
                        } else {
                            //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                            if (obj instanceof String) {
                                obj = ((String) obj).replaceAll("'", "''");
                            }
                            map.put(labelName, obj);
                        }
                    }
                    String fieldname = map.get("f_fieldname").toString();
                    if(isCreate)
                    {
                        fieldsFields.add(map);
                    }
                    else {
                        if (existFields == null && !existFields.stream().filter(t -> t.getfFieldname().equals(fieldname)).findFirst().isPresent()) {
                            addFields.add(map);
                        }
                    }
                }

                if(isCreate)
                {
                    dataBizService.insertDatasBatch("tbtsk_fields", fieldsFields, null);
                }
                else {
                    if(!addFields.isEmpty()) {
                        List<Map<String, Object>>insertFields = new ArrayList<>();
                        for(Map<String,Object>m:addFields) {
                             String f_id = m.get("f_id").toString();
                            if(dataBizService.getCount("tbtsk_fields_add","f_id ='"+f_id+"'")==0)
                            {
                                insertFields.add(m);

                            }
                        }
                        if(!insertFields.isEmpty()) {
                            dataBizService.insertDatasBatch("tbtsk_fields_add", insertFields, null);
                        }

                    }
                }

            }

            if(isCreate){

                //处理任务分组表
                if(existTable(statement,"task_group")) {
                    String groupSql = "select * from task_group";
                    ResultSet  groupRs = statement.executeQuery(groupSql);
                    ResultSetMetaData groupmetaData = groupRs.getMetaData();
                    List<Map<String, Object>> grouplist = new ArrayList<>();
                    while (groupRs.next()) {
                        int rowSize = groupmetaData.getColumnCount();
                        Map<String, Object> map = new HashMap<>();
                        for (int i = 1; i <= rowSize; i++) {
                            String labelName = groupmetaData.getColumnName(i);
                            Object obj = groupRs.getObject(labelName);
                            if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                map.put(labelName, null);
                            }else{
                                //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                                if(obj instanceof String){
                                    obj = ((String) obj).replaceAll("'","''");
                                }
                                map.put(labelName, obj);
                            }
                          /*  if(labelName.equals("f_regexp") || labelName.equals("f_connection")){
                                if(obj != null && StringUtils.isNotBlank(obj.toString()) && !"null".equals(obj.toString())){
                                    map.put(labelName, obj.toString().replaceAll("'","''"));
                                }
                            }*/
                        }
                        grouplist.add(map);
                    }
                    dataBizService.insertDatasBatch("tbtsk_group",grouplist,null);
                }
                //处理任务范围数据
                if(existTable(statement,"task_area")) {
                    String areaSql = "select * from task_area";
                    ResultSet  areaRs = statement.executeQuery(areaSql);
                    ResultSetMetaData areametaData = areaRs.getMetaData();
                    List<Map<String, Object>> arealist = new ArrayList<>();
                    while (areaRs.next()) {
                        int rowSize = areametaData.getColumnCount();
                        Map<String, Object> map = new HashMap<>();
                        for (int i = 1; i <= rowSize; i++) {
                            String labelName = areametaData.getColumnName(i);
                            Object obj = areaRs.getObject(labelName);
                            if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                map.put(labelName, null);
                            }else{
                                //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                                if(obj instanceof String){
                                    obj = ((String) obj).replaceAll("'","''");
                                }
                                map.put(labelName, obj);
                            }
                        }
                        arealist.add(map);
                    }
                    dataBizService.insertDatasBatch("tbtsk_biz_area",arealist,null);
                }
                //新建图斑数据表
                TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
                TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
                tskTaskBizService.createTable(tskTaskBiz, table);
                //创建子表
                if(StringUtils.isNotBlank(tskTaskBiz.getConfigArgs())) {
                    JSONObject configArgsObject = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
                    if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)|| (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {
                       if(StringUtils.isNotBlank(table.getSplitTableName())){
                           String spotsql = "create table "+table.getSplitTableName()+" as select * from "+table.getfTablename()+" where 1 =2";
                           dataBizService.excuteSql(spotsql);
                       }
                    }
                }
            }
            if(isCreate){
                try{
                    //处理任务审核流程表
                    if(existTable(statement,"tbtsk_task_biz_flow")) {
                        String bizFlowSql = "select * from tbtsk_task_biz_flow";
                        ResultSet  bizFlowRs = statement.executeQuery(bizFlowSql);
                        ResultSetMetaData bizFlowmetaData = bizFlowRs.getMetaData();
                        List<Map<String, Object>> bizFlowlist = new ArrayList<>();
                        while (bizFlowRs.next()) {
                            int rowSize = bizFlowmetaData.getColumnCount();
                            Map<String, Object> map = new HashMap<>();
                            for (int i = 1; i <= rowSize; i++) {
                                String labelName = bizFlowmetaData.getColumnName(i);
                                Object obj = bizFlowRs.getObject(labelName);
                                if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                    map.put(labelName, null);
                                }else{
                                    //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                                    if(obj instanceof String){
                                        obj = ((String) obj).replaceAll("'","''");
                                    }
                                    map.put(labelName, obj);
                                }
                            }
                            bizFlowlist.add(map);
                        }
                        if(bizFlowlist.size() > 0){
                            dataBizService.insertDatasBatch("tbtsk_task_biz_flow",bizFlowlist,null);
                        }
                        //处理任务审核流程表
                        String flowDefSql = "select * from tbtsk_flow_def";
                        ResultSet  flowDefRs = statement.executeQuery(flowDefSql);
                        ResultSetMetaData flowDefmetaData = flowDefRs.getMetaData();
                        List<Map<String, Object>> flowDeflist = new ArrayList<>();
                        while (flowDefRs.next()) {
                            int rowSize = flowDefmetaData.getColumnCount();
                            Map<String, Object> map = new HashMap<>();
                            for (int i = 1; i <= rowSize; i++) {
                                String labelName = flowDefmetaData.getColumnName(i);
                                Object obj = flowDefRs.getObject(labelName);
                                if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                    map.put(labelName, null);
                                }else{
                                    //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                                    if(obj instanceof String){
                                        obj = ((String) obj).replaceAll("'","''");
                                    }
                                    map.put(labelName, obj);
                                }
                            }
                            flowDeflist.add(map);
                        }
                        if(flowDeflist.size() > 0){
                            dataBizService.insertDatasBatch("tbtsk_flow_def",flowDeflist,null);
                        }
                    }
                    //处理打回配置
                    if(existTable(statement,"tbtsk_reject_def")) {
                        String rejectDefSql = "select * from tbtsk_reject_def";
                        ResultSet rejectDefRs = statement.executeQuery(rejectDefSql);
                        ResultSetMetaData rejectDefMetaData = rejectDefRs.getMetaData();
                        List<Map<String,Object>> rejectDefList = new ArrayList<>();
                        while (rejectDefRs.next()){
                            int rowSize = rejectDefMetaData.getColumnCount();
                            Map<String, Object> map = new HashMap<>();
                            for (int i = 1; i <= rowSize; i++) {
                                String labelName = rejectDefMetaData.getColumnName(i);
                                Object obj = rejectDefRs.getObject(labelName);
                                if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){
                                    map.put(labelName, null);
                                }else{
                                    //处理字段中的单引号，应该在mapper中改，但改了会有其他问题，懒得深入研究
                                    if(obj instanceof String){
                                        obj = ((String) obj).replaceAll("'","''");
                                    }
                                    map.put(labelName, obj);
                                }
                            }
                            rejectDefList.add(map);
                        }
                        if(!rejectDefList.isEmpty()){
                            dataBizService.insertDatasBatch("tbtsk_reject_def",rejectDefList,null);
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
            //处理图斑数据表
            if("assignBiz".equals(type) || "pushTaskData".equals(type)){
                String tableName1 = "";
                if(tableName.contains(".")){
                    String[] split = tableName.split("\\.");
                    tableName1 = split[1];
                }else{
                    tableName1 = tableName;
                }
                String dataSql = "select * from "+tableName1;
                ResultSet  dataRs = statement.executeQuery(dataSql);
                ResultSetMetaData datametaData = dataRs.getMetaData();
                String updateTime =String.valueOf(System.currentTimeMillis());
                while (dataRs.next()) {
                    String f_id = dataRs.getString("f_id");
                    Map mapdata = dataBizService.selectByID(tableName, "f_id", "'"+f_id+"'");
                    int rowSize = datametaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    Map<String, Object> map2 = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = datametaData.getColumnName(i);
                        Object obj = dataRs.getObject(labelName);
                        if(addFields.contains(labelName))
                        {
                            if (obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())) {
                                map2.put(labelName, null);
                            } else {
                                map2.put(labelName, obj);
                            }
                        }
                        else {
                            if (obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())) {
                                map.put(labelName, null);
                            } else {
                                if (labelName.equals("f_shape") && obj != null) {
                                    map.put("f_shape", "SRID=4490;" + obj.toString());
                                } else {
                                    map.put(labelName, obj);
                                }
                            }
                        }
                    }
                    map.put("f_updatetime",updateTime);
                    if(!map.isEmpty()) {
                        if (mapdata == null) {
                            dataBizService.insertData(tableName, map, "f_shape");
                        } else {
                            dataBizService.updateData(tableName, map, " f_id = '" + f_id + "'");
                        }
                    }
                    if(!map2.isEmpty())
                    {
                        TbtskTaskFieldsAdd search = new TbtskTaskFieldsAdd();
                        search.setTaskId(taskId);
                        search.setTbid(f_id);
                        List<TbtskTaskFieldsAdd>exists = tbtskTaskFieldsAddDao.gwSearch(search);
                        if(exists==null||exists.isEmpty())
                        {
                            search.setfId(UUID.randomUUID().toString());
                            search.setContent(JSONObject.toJSONString(map2));
                            tbtskTaskFieldsAddDao.gwAccess(search);
                        }
                        else
                        {
                            TbtskTaskFieldsAdd exist =  exists.get(0);
                            exist.setContent(JSONObject.toJSONString(map2));
                            tbtskTaskFieldsAddDao.gwUpdateByPK(exist);
                        }
                    }
                }

             try{
                //处理分割子表数据
                TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
                TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
                if(StringUtils.isNotBlank(table.getSplitTableName())){
                    String splitTableName = "";
                    if(table.getSplitTableName().contains(".")){
                        String[] split = table.getSplitTableName().split("\\.");
                        splitTableName = split[1];
                    }else{
                        splitTableName = table.getSplitTableName();
                    }
                    if(existTable(statement,splitTableName)) {
                        //判断外网是否存在子表
                        if(!dataBizService.isExistTableName(table.getSplitTableName())){
                            //创建子表
                            if(StringUtils.isNotBlank(tskTaskBiz.getConfigArgs())) {
                                JSONObject configArgsObject = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
                                if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)|| (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {
                                    if(StringUtils.isNotBlank(table.getSplitTableName())){
                                        String spotsql = "create table "+table.getSplitTableName()+" as select * from "+table.getfTablename()+" where 1 =2";
                                        dataBizService.excuteSql(spotsql);
                                    }
                                }
                            }
                        }
                        String dataSql1 = "select * from "+splitTableName;
                        ResultSet  dataRs1 = statement.executeQuery(dataSql1);
                        ResultSetMetaData datametaData1 = dataRs1.getMetaData();
                        while (dataRs1.next()) {
                            String f_id = dataRs1.getString("f_id");
                            Map mapdata = dataBizService.selectByID(table.getSplitTableName(), "f_id", "'"+f_id+"'");
                            int rowSize = datametaData1.getColumnCount();
                            Map<String, Object> map = new HashMap<>();
                            Map<String, Object> map2 = new HashMap<>();
                            for (int i = 1; i <= rowSize; i++) {
                                String labelName = datametaData1.getColumnName(i);
                                Object obj = dataRs1.getObject(labelName);
                                if(addFields.contains(labelName))
                                {
                                    if (obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())) {
                                        map2.put(labelName, null);
                                    } else {
                                        map2.put(labelName, obj);
                                    }
                                }
                                else {
                                    if (obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())) {
                                        map.put(labelName, null);
                                    } else {
                                        if (labelName.equals("f_shape") && obj != null) {
                                            map.put("f_shape", "SRID=4490;" + obj.toString());
                                        } else {
                                            map.put(labelName, obj);
                                        }
                                    }
                                }
                            }
                            if(!map.isEmpty()) {
                                if (mapdata == null) {
                                    dataBizService.insertData(table.getSplitTableName(), map, "f_shape");
                                } else {
                                    dataBizService.updateData(table.getSplitTableName(), map, " f_id = '" + f_id + "'");
                                }
                            }
                            if(!map2.isEmpty())
                            {
                                TbtskTaskFieldsAdd search = new TbtskTaskFieldsAdd();
                                search.setTaskId(taskId);
                                search.setTbid(f_id);
                                List<TbtskTaskFieldsAdd>exists = tbtskTaskFieldsAddDao.gwSearch(search);
                                if(exists==null||exists.isEmpty())
                                {
                                    search.setfId(UUID.randomUUID().toString());
                                    search.setContent(JSONObject.toJSONString(map2));
                                    tbtskTaskFieldsAddDao.gwAccess(search);
                                }
                                else
                                {
                                    TbtskTaskFieldsAdd exist =  exists.get(0);
                                    exist.setContent(JSONObject.toJSONString(map2));
                                    tbtskTaskFieldsAddDao.gwUpdateByPK(exist);
                                }
                            }
                        }
                    }
                 }
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        } catch (SQLException e) {
            try {
                connPool.closeAll(connection, statement, null);
            }
            catch (Exception EX)
            {
                logger.error("关闭db连接失败"+ ExceptionUtil.getErrorString(EX));
            }
            logger.error("接收内网推送数据包异常"+ ExceptionUtil.getErrorString(e));

        }
    }
    private void setChild(List<TbtskTaskClass>lst,TbtskTaskClass parent)
    {
        List<TbtskTaskClass>childs = lst.stream().filter(t->t.getParentId().equals(parent.getId())).collect(Collectors.toList());
        while (childs!=null)
        {
            parent.setChildren(childs);
            for(TbtskTaskClass c:childs)
            {
                setChild(lst,c);
            }
        }
    }
    private void saveChild(List<TbtskTaskClass>alls,TbtskTaskClass parent,Map<Long,Long>mapClassId)
    {
        List<TbtskTaskClass>childs = parent.getChildren();
        if(childs!=null)
        {
            for (TbtskTaskClass c :childs)
            {
                c.setParentId(parent.getId());
                TbtskTaskClass finalC = c;
                TbtskTaskClass nameExist = alls.stream().filter(t->t.getName().equals(finalC.getName())).findFirst().orElse(null);
                Long oldId = c.getId();
                if(nameExist==null)
                {
                    c.setId(null);
                    c =  tbtskTaskClassRepository.save(c);
                    mapClassId.put(oldId,c.getId());
                }
                else
                {
                    c.setId(nameExist.getId());
                    mapClassId.put(oldId,c.getId());
                }
            }
        }
    }
    /**
     * 下发图斑
     * @param userId
     * @param tskTaskBiz
     * @param userIds
     * @param tbIds
     */
    public void assignTask(Long userId,TskTaskBiz tskTaskBiz, List<String> userIds,List<String> tbIds){
        String recordId = UUID.randomUUID().toString();
        // List<String> list = com.alibaba.fastjson.JSONObject.parseArray(com.alibaba.fastjson.JSONObject.toJSONString(tbIds),  String.class);
        List<String> list = tbIds;
        //获取任务
        com.alibaba.fastjson.JSONObject additionJson = new com.alibaba.fastjson.JSONObject();
        additionJson.put("count", tbIds.size());
        // 不管是下发模式还是领取模式的任务，都标记为update，app端对判断如果本地不存在，就将update的数据转为新增
        additionJson.put("addOrUpdate", "UPDATE");
        additionJson.put("taskMode", tskTaskBiz.getMode());
        additionJson.put("curMode", "assign");

        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(null);
        parameter.setTaskId(tskTaskBiz.getId());
        JSONArray array = new JSONArray();
        JSONArray orgArray = new JSONArray();
        JSONObject userids = new JSONObject();
        for(String s : userIds){
            array.add(Integer.parseInt(s));
        }
        userids.put("userids",array);
        orgArray.add(userids);
        parameter.setOrgs(orgArray);
        parameter.setGroups(new JSONArray());
        parameter.setUserId(userId);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        parameter.setAddition(additionJson);

        //  String paramJSONStr = JSONObject.toJSONString(parameter);
        //将参数添加到任务记录中进行后台处理
        com.alibaba.fastjson.JSONObject params = new com.alibaba.fastjson.JSONObject();
        params.put("filterType", "checkFilter");
        params.put("userId", userId);
        params.put("TaskDataDbParameter", parameter);
        params.put("taskId", tskTaskBiz.getId());
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(com.alibaba.fastjson.JSONObject.toJSONString(params));
        //数据下发3
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);

        List<TaskRecordTemp> tempList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid(list.get(i));
            tempList.add(temp);
        }
        taskRecordService.saveTaskRecordTemp(tempList);
    }
    private String createStructDB(String bizId, String userId) {
        TskTaskBiz task = tskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(bizId);
        Connection conn = null;
        Statement statement = null;
        String dbUrl = "";
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        try {
            // 01.先根据 taskids 生成数据db
            String fileName = UUID.randomUUID() + ".db";
            String filePath = uploadDir + File.separator + fileName;
            SqlliteConnTool tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();

            // 生产表信息和字段信息
            TaskDBUtils.createInfo(tskTaskBizService, table, task, statement, "sendApp");

            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table,task, statement);

            // 关闭连接
            tool.closeAll(conn, statement, null);

            // 上传db包到oss上
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", userId, date);
            dbUrl = ossOperatorService.sendObject2Oss(key, new File(filePath));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dbUrl;
    }


    private void createTaskRole(String taskId,Integer role,Long userId){
        List<UserBiz2>  userBiz2s = userBiz2Repository.findByUserIdAndBizIdAndRole(userId,taskId,role);
        if(userBiz2s.size() <= 0){
            UserBiz2 ub = new UserBiz2();
            ub.setUserId(userId);
            ub.setBizId(taskId);
            ub.setRole(role);
            userBiz2Repository.save(ub);
            if(role == 1){
                //查询用户政区
                List<String> regions = landUser2AreaRepository.queryAreas(userId);
                if (!regions.isEmpty()) {
                    //给任务管理员设置管理区
                    tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions.get(0), null);
                }
            }
        }
    }

    private Boolean existTable(Statement statement,String tableName){
        try{
            // 执行查询
            String sql = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'";
            ResultSet rs = statement.executeQuery(sql);
            // 检查结果集是否为空
            if (rs.next()) {
                return true;
            } else {
                return false;
            }
        }
        catch (Exception ex){
            System.out.println(ex.getMessage());
            return false;
        }
    }

}
