package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TaskUtils;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.data.GwValidateException;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission.service
 * @date 2022/2/25 11:21
 */
@Service
public class OuterTaskTransmitDataService {

    private GiLoger logger = GwLoger.getLoger(OuterTaskTransmitDataService.class);
    @Value("${project.uploadDir}")
    String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.task.appkey:}")
    String transmitAppkey;
    @Value("${transmit.task.module:}")
    String transmitModule;
    @Resource
    ProducerService producerService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskAssignJobService taskAssignJobService;
    @Resource
    DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    TemporarySignedUrlService temporarySignedUrlService;
    @Resource
    AppMediaRepository appMediaRepository;


    public void doWork(List<Map<String, Object>> datas, String bizId, List<AppMedia> listMedia, Long userId) throws Exception {
        Connection conn = null;
        Statement statement = null;
        SqlliteConnTool tool = null;
        TskTaskBiz task = tskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(bizId);
        try {
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            // 01.先根据 taskid生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = tempFolderPath + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table,task, statement);
            // 导入图斑数据
            List<Map> list = new ArrayList<>();
            datas.forEach(a ->{
                list.add(a);
            });
            Set<String> set = taskAssignJobService.insertData(list,statement, table, "2");
            //生成附件数据
            List<AppMedia> mediaList = new ArrayList<>();
                for(int i = 0; i<listMedia.size();i++){
                    AppMedia one = appMediaRepository.findById(listMedia.get(i).getId()).orElse(null);
                    if(one == null){
                        String accessUrl = "";
                        if (listMedia.get(i).getServerpath() != null && !listMedia.get(i).getServerpath().contains("AccessKeyId")) {
                            accessUrl = temporarySignedUrlService.getTemporarySignedUrl("", listMedia.get(i).getServerpath(), null);
                        }
                        String fiename = listMedia.get(i).getServerpath().substring(listMedia.get(i).getServerpath().lastIndexOf("/") + 1, listMedia.get(i).getServerpath().length());
                        String path = tempFolderPath + File.separator + fiename;
                        File lsFile = new File(path);
                        if (!lsFile.exists()) {
                            FileUtils.copyURLToFile(new URL(accessUrl), lsFile);
                        }
                        mediaList.add(listMedia.get(i));
                    }
            }
            //生成任务附件结构和数据
            TaskUtils.createMdeiaStruct(mediaList,statement);
            // 关闭连接
            tool.closeAll(conn, statement, null);

            // 03.生成json文件
            String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
            // 保证创建一个新文件
            File file = new File(jsonPath);
            if (file.exists()) { // 如果已存在,删除旧文件
                file.delete();
            }
            file.createNewFile();
            JSONObject jsonObject = new JSONObject();
            //1 新增任务 2 更新任务结构 3 更新数据
            jsonObject.put("mode","3");
            jsonObject.put("group","task");
            jsonObject.put("userId",userId);
            jsonObject.put("taskId",bizId);
            // 将格式化后的字符串写入文件
            Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
            write.write(jsonObject.toJSONString());
            write.flush();
            write.close();
            //压缩文件
            String safeFileName = new StringBuilder().append(task.getName()).append(UuidUtil.get16UUID()).toString();
            String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
            String url = afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
            //发送数据
            HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix +".zip"), transmitUrl+"/monitor/trans/transData.action");
          /*  publishTranMsg(fileNameNoSuffix + ".zip");*/
            // 删除文件夹
            FileUtils.deleteQuietly(new File(tempFolderPath));
            // 删除zip文件
            FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
        } catch (Exception e) {
            logger.error("外网推送任务数据包到内网失败"+ ExceptionUtil.getErrorString(e));
            tool.closeAll(conn, statement, null);
            throw new GwValidateException(e.getMessage());
        }
    }


    /**
     * 压缩文件
     * @param userId
     * @param tempFolderPath
     * @param safeFileName
     * @param fileNameNoSuffix
     * @return
     */
    public  String afterExport(Long userId,String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url ="";
        logger.info( " 开始压缩成zip文件 ");
        Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", false, "");
        url =  uploadFileToCloudDisk(userId, safeFileName);
        /*String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 计算大小
        Double zipFileSize = new File(zipFile).length() / 1024d;*/
        return url;
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */


    public  String  uploadFileToCloudDisk(Long userId, String safeFileName) {
        // 注意：这里不能用File.separator 替代"/"，OBS上路径分隔符用"/",而File.separator默认为:"\"
        String sendObjName = "taskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 上传到obs
        String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }


    /**
     * 发送消息
     * @param url
     */
    public void publishTranMsg(String url) {
        try {
            String queueName = "Shandong-Outer-Tran";
            logger.info("发送同步消息队列名称：" + queueName + " 内容：" + url);
            //producerService.sendMessage(queueName, bytes);
            Map<String, Object> map = new HashMap<>();
            map.put(ActiveMQConstant.SERVICE_NAME, "OUTER-RECEIVE-MESSAGE");
            map.put("appkey",  PropertyUtil.getProperty("tran.appkey"));
            map.put("module",  PropertyUtil.getProperty("tran.module"));
            map.put("name", "测试");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "OUTER-RECEIVE-MESSAGE");
            producerService.sendMapMessage2Queue(map, queueName);
        } catch (Exception e) {
            logger.error("发送同步消息异常：", e);
        }
    }
}
