package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.TranFileUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.jms.BytesMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.*;
import java.util.*;
import java.util.Date;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission
 * @date 2022/2/24 16:44
 */
@Slf4j
@Service
public class OuterTaskTransmitService {

    @Value("${project.uploadDir}")
    String uploadDir;

    @Resource
    DataBizService dataBizService;
    @Resource
    TskTaskBizService tskTaskBizService;
    @Resource
    TaskRecordService taskRecordService;

    public void execute(BytesMessage bytesMessage) {
        try {
            String  fileName = bytesMessage.getStringProperty("FileName");
            FileOutputStream out = new FileOutputStream(uploadDir+"/"+fileName);
            byte[] bytes=new byte[1024];
            int len=0;
            while ((len=bytesMessage.readBytes(bytes))!=-1){
                out.write(bytes,0,len);
            }
            File zipFile = new File(uploadDir+"/"+fileName);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            //解压文件
            Zip4jUtils.unzip(zipName, unzipFileDir, "");

            File file = new File(unzipFileDir);
            File dbFile = null;
            File jsonFile = null;
            File[] content = file.listFiles();
            for (int j = 0, ln = content.length; j < ln; ++j) {
                if (content[j].getName().endsWith(".json")) {
                    jsonFile = content[j];
                }
                if (content[j].getName().endsWith(".db")) {
                    dbFile = content[j];
                }
            }
            String jsonContext = TranFileUtil.readFile(jsonFile.getAbsolutePath());
           JSONObject jsonObject = JSONObject.parseObject(jsonContext);
             String taskId = jsonObject.getString("taskId");
             String mode = jsonObject.getString("mode");
             Long userId = jsonObject.getLong("userId");
             List<String> userIds =jsonObject.getJSONArray("assignUserIds").toJavaList(String.class);
             List<String> tbIds = jsonObject.getJSONArray("tbIds").toJavaList(String.class);;
            TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
            if("1".equals(mode)){
                if(task == null){
                    handDbFile(dbFile,true);
                }else{
                    handDbFile(dbFile,false);
                }
            }
            //下发数据
            assignTask(userId,task,userIds,tbIds);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 处理DB文件
     * @param dbFile
     */
    public void handDbFile( File dbFile,Boolean isCreate){
        try {
        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(dbFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        String taskId = "";
        String tableName = "";
            // 支持同时上传多张表
            //处理任务表
            String sql = "select * from task_biz";
            ResultSet  rs = statement.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            while (rs.next()) {
                taskId = rs.getString("f_id");
                if(isCreate){
                    int rowSize = metaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = metaData.getColumnName(i);
                        Object obj = rs.getObject(labelName);
                        map.put(labelName, obj);
                    }
                    map.put("f_source","内网任务");
                    dataBizService.insertData("tbtsk_task_biz",map,null);
                }
            }
            //处理任务对象表
            String objectSql = "select * from task_biz";
            ResultSet  objectRs = statement.executeQuery(objectSql);
            ResultSetMetaData objectmetaData = objectRs.getMetaData();
            while (objectRs.next()) {
                tableName = objectRs.getString("f_tablename");
                if(isCreate){
                    int rowSize = objectmetaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = objectmetaData.getColumnName(i);
                        Object obj = objectRs.getObject(labelName);
                        map.put(labelName, obj);
                    }
                    dataBizService.insertData("tbtsk_objectinfo",map,null);
                }
            }

            if(isCreate){
                //处理任务字段表
                String fieldSql = "select * from task_biz";
                ResultSet  fieldRs = statement.executeQuery(fieldSql);
                ResultSetMetaData fieldmetaData = fieldRs.getMetaData();
                List<Map<String, Object>> fieldlist = new ArrayList<>();
                while (fieldRs.next()) {
                    int rowSize = fieldmetaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = fieldmetaData.getColumnName(i);
                        Object obj = fieldRs.getObject(labelName);
                        map.put(labelName, obj);
                    }
                    fieldlist.add(map);
                }
                dataBizService.insertDatasBatch("tbtsk_fields",fieldlist,null);

                //处理任务分组表
                String groupSql = "select * from task_biz";
                ResultSet  groupRs = statement.executeQuery(groupSql);
                ResultSetMetaData groupmetaData = groupRs.getMetaData();
                List<Map<String, Object>> grouplist = new ArrayList<>();
                while (groupRs.next()) {
                    int rowSize = groupmetaData.getColumnCount();
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 1; i <= rowSize; i++) {
                        String labelName = groupmetaData.getColumnName(i);
                        Object obj = groupRs.getObject(labelName);
                        map.put(labelName, obj);
                    }
                    grouplist.add(map);
                }
                dataBizService.insertDatasBatch("tbtsk_group",grouplist,null);

                   //新建图斑数据表
                TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
                TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
                tskTaskBizService.createTable(tskTaskBiz, table);
            }

            //处理图斑数据表
            String dataSql = "select * from "+tableName;
            ResultSet  dataRs = statement.executeQuery(dataSql);
            ResultSetMetaData datametaData = dataRs.getMetaData();
            List<Map<String, Object>> datalist = new ArrayList<>();
            while (dataRs.next()) {
                String f_id = dataRs.getString("f_id");
                Map mapdata = dataBizService.selectByID(tableName, "f_id", "'"+f_id+"'");
                int rowSize = datametaData.getColumnCount();
                Map<String, Object> map = new HashMap<>();
                for (int i = 1; i <= rowSize; i++) {
                    String labelName = datametaData.getColumnName(i);
                    Object obj = dataRs.getObject(labelName);
                    map.put(labelName, obj);
                }
                if (mapdata == null) {
                    dataBizService.insertDatasBatch(tableName,datalist, "f_shape");
                }else{
                    dataBizService.updateData(tableName, map, " f_id = '" + f_id + "'");
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /**
     * 下发图斑
     * @param userId
     * @param tskTaskBiz
     * @param userIds
     * @param tbIds
     */
    public void assignTask(Long userId,TskTaskBiz tskTaskBiz, List<String> userIds,List<String> tbIds){
        String recordId = UUID.randomUUID().toString();
       // List<String> list = com.alibaba.fastjson.JSONObject.parseArray(com.alibaba.fastjson.JSONObject.toJSONString(tbIds),  String.class);
        List<String> list = tbIds;
        //获取任务
        com.alibaba.fastjson.JSONObject additionJson = new com.alibaba.fastjson.JSONObject();
        additionJson.put("count", tbIds.size());
        // 不管是下发模式还是领取模式的任务，都标记为update，app端对判断如果本地不存在，就将update的数据转为新增
        additionJson.put("addOrUpdate", "UPDATE");
        additionJson.put("taskMode", tskTaskBiz.getMode());
        additionJson.put("curMode", "assign");

        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(null);
        parameter.setTaskId(tskTaskBiz.getId());
        JSONArray array = new JSONArray();
        for(String s : userIds){
            array.add(Integer.parseInt(s));
        }
        parameter.setOrgs(array);
        parameter.setUserId(userId);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        parameter.setAddition(additionJson);

        //  String paramJSONStr = JSONObject.toJSONString(parameter);
        //将参数添加到任务记录中进行后台处理
        com.alibaba.fastjson.JSONObject params = new com.alibaba.fastjson.JSONObject();
        params.put("filterType", "checkFilter");
        params.put("userId", userId);
        params.put("TaskDataDbParameter", parameter);
        params.put("taskId", tskTaskBiz.getId());
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(com.alibaba.fastjson.JSONObject.toJSONString(params));
        //数据下发3
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);

        List<TaskRecordTemp> tempList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid(list.get(i));
            tempList.add(temp);
        }
        taskRecordService.saveTaskRecordTemp(tempList);
    }

}
