package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.common.util.PropertyUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.*;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission.service
 * @date 2022/3/10 14:50
 */
@Slf4j
@Service
public class OuterUserTrackTranService {

    private GiLoger logger = GwLoger.getLoger(OuterUserTrackTranService.class);
    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.task.appkey:}")
    String transmitAppkey;
    @Value("${transmit.task.module:}")
    String transmitModule;
    @Resource
    DefaultOssOperatorService defaultOssOperatorService;
    @Resource
    ProducerService producerService;

    public void syscUserTrack(Long userId,MultipartFile fileOfDB) throws IOException {
        // 临时数据存放文件夹
        if(uploadDir == null){
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
        FileUtil.creatDirectoryIfNotExist(tempFolderPath);
        // 文件保存至临时文件目录(时间-UUID.db)
        String fileName = UUID.randomUUID().toString() + ".db";
        File tempUploadFile = new File(tempFolderPath + File.separator+fileName);
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);
        // 03.生成json文件
        String jsonPath = tempFolderPath + File.separator  + UUID.randomUUID().toString()+".json";
        // 保证创建一个新文件
        File file = new File(jsonPath);
        if (file.exists()) { // 如果已存在,删除旧文件
            file.delete();
        }
        file.createNewFile();
        JSONObject jsonObject = new JSONObject();
        //1 新增任务 2 更新任务结构 3 更新数据
        jsonObject.put("type","userTrack");
        jsonObject.put("group","userTrack");
        jsonObject.put("userId",userId);
        jsonObject.put("taskName","动态巡查");
        // 将格式化后的字符串写入文件
        Writer write = new OutputStreamWriter(new FileOutputStream(file), "UTF-8");
        write.write(jsonObject.toJSONString());
        write.flush();
        write.close();
        //压缩文件
        String safeFileName = new StringBuilder().append("动态巡查").append(UuidUtil.get16UUID()).toString();
        String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
        String url = afterExport( userId, tempFolderPath,  safeFileName,  fileNameNoSuffix);
        //发送数据
        HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(fileNameNoSuffix +".zip"), transmitUrl+"/monitor/trans/transData.action");
        //发送消息
       // publishTranMsg(fileNameNoSuffix + ".zip");
        // 删除文件夹
        FileUtils.deleteQuietly(new File(tempFolderPath));
        // 删除zip文件
         FileUtils.deleteQuietly(new File(fileNameNoSuffix + ".zip"));
    }


    /**
     * 发送消息
     * @param url
     */
    public void publishTranMsg(String url) {
        try {
            String queueName = "SC-Inner-UserTrackTran";
            logger.info("发送同步消息队列名称：" + queueName + " 内容：" + url);
            //producerService.sendMessage(queueName, bytes);
            Map<String, Object> map = new HashMap<>();
            map.put(ActiveMQConstant.SERVICE_NAME, "USERTRACKTRAN-RECEIVE-MESSAGE");
            map.put("appkey",  PropertyUtil.getProperty("transmit.appkey"));
            map.put("module",  PropertyUtil.getProperty("transmit.module"));
            map.put("name", "测试");
            map.put("recvpath", url);
            map.put("size", 1);
            map.put("serviceName", "USERTRACKTRAN-RECEIVE-MESSAGE");
            producerService.sendMapMessage2Queue(map, queueName);
        } catch (Exception e) {
            logger.error("发送同步消息异常：", e);
        }
    }

    /**
     * 压缩文件
     * @param userId
     * @param tempFolderPath
     * @param safeFileName
     * @param fileNameNoSuffix
     * @return
     */
    public  String afterExport(Long userId,String tempFolderPath, String safeFileName, String fileNameNoSuffix) {
        String url ="";
        logger.info( " 开始压缩成zip文件 ");
        Zip4jUtils.zip(tempFolderPath, fileNameNoSuffix + ".zip", false, "");
       // url =  uploadFileToCloudDisk(userId, safeFileName);
        return url;
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */
    public  String  uploadFileToCloudDisk(Long userId, String safeFileName) {
        // 注意：这里不能用File.separator 替代"/"，OBS上路径分隔符用"/",而File.separator默认为:"\"
        String sendObjName = "patrolTaskTran/" + userId + "/" + safeFileName + ".zip";
        String zipFile = new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append(safeFileName)
                .append(".zip")
                .toString();
        // 上传到obs
        String resultUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, zipFile);
        return resultUrl;
    }

}
