package com.geoway.landteam.landcloud.service.networkTransmission.outer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.task.entity.TbsysInspectionRecord;
import com.geoway.landteam.customtask.task.entity.TbtskUserTaskClass;
import com.geoway.landteam.customtask.task.entity.User2Biz;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserApplication;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.model.user.entity.UserRoleInfo;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.oauth.SyncUserInfo;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.google.common.collect.Lists;
import com.gw.base.data.GwValidateException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.networkTransmission.service
 * @date 2022/4/6 16:01
 */
@Slf4j
@Service
@Transactional(rollbackFor = {Exception.class})
public class OuterUserTranAcceptService {

    @Value("${project.uploadDir}")
    String uploadDir;
    @Resource
    LandRegUserRepository landRegUserRepository;
    @Resource
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;
    @Resource
    LandUserRepository landUserDao;
    @Resource
    LandUserService userService;
    @Resource
    TskRightAreaRepository tskRightAreaRepository;
    @Resource
    UserRoleInfoRepository userRoleInfoDao;
    @Resource
    UserApplicationRepository userApplicationDao;
    @Resource
    User2BizRepository userBiz2Dao;
    @Resource
    LandUser2AreaRepository landUser2AreaDao;
    @Resource
    Organization2UserRepository organization2UserDao;
    @Resource
    UserCloudAreaRepository userCloudAreaDao;
    @Resource
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Resource
    UisApplicationRepository UisApplicationDao;
    @Resource
    OrganizationRepository organizationRepository;
    @Resource
     JdbcTemplate jdbcTemplate;

    @Autowired
    OauthUserService oauthUserService;
    /**
     * 处理数据
     * @param jsonObject
     */
    public void execute_old(JSONObject jsonObject) throws Exception {
        String type  = jsonObject.getString("type");
        if(StringUtils.isNotBlank(type)){
            switch (type) {
                case "insert": {
                    LandUser landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), LandUser.class);
                    LandUser landUser1 = landUserDao.save(landUser);
                    landUserDao.updateUserId(landUser1.getId(),landUser.getId());
                    String userRegionCode = jsonObject.getString("userRegionCode");
                    String userRoles = jsonObject.getString("userRoles");
                    String userCloudAreas = jsonObject.getString("userCloudArea");
                    String userCloudQueryConfig = jsonObject.getString("userCloudQueryConfig");
                    //创建单位
                    Object organizationBean = JSONObject.toJavaObject(jsonObject.getJSONObject("organization"), Organization.class);
                    String orgId = "";
                    if(organizationBean != null){
                        Organization organization = (Organization) organizationBean;
                        if(organization != null){  //校验单位是否存在，不存在进行新增
                            Organization organizations = organizationRepository.queryByNameAndRegion( organization.getName(), organization.getRegionCode());
                            if(organizations == null){  //没有单位，新增单位
                                Organization organization1 = organizationRepository.save(organization);
                                //Organization org = organizationService.create(organization.getName(), organization.getRegionCode(),null,  null,organization.getType());
                                orgId = organization1.getId();
                            }else{
                                orgId = organizations.getId();
                            }
                        }
                    }
                    // 保存用户单位（组织机构）信息
                    Organization2User organization2User = new Organization2User();
                    organization2User.setId(UUID.randomUUID().toString());
                    organization2User.setOrganizationId(orgId);
                    organization2User.setUserId(landUser.getId());
                    organization2UserDao.save(organization2User);
                    // 保存用户角色信息
                    String[] roles = userRoles.split(",");
                    if (userRoles.indexOf(";") > -1) {
                        roles =userRoles.split(";");
                    }
                    for (String role : roles) {
                        String uid=UUID.randomUUID().toString();
                        UserRoleInfo userRole=new UserRoleInfo();
                        userRole.setId(uid);
                        userRole.setRoleinfoid(role);
                        userRole.setUserid(landUser.getId());
                        userRoleInfoDao.save(userRole);
                    }
                    // 保存用户行政区信息
                    String regionCode = userRegionCode;
                    if (StringUtils.isNotBlank(regionCode)) {
                        LandUser2Area landUser2Area = new LandUser2Area();
                        landUser2Area.setUserId(landUser.getId());
                        landUser2Area.setCreateTime(landUser.getCreateTime());
                        landUser2Area.setState(1);
                        landUser2Area.setRegionCode(regionCode);
                        landUser2AreaDao.save(landUser2Area);
                    }
                    // 保存用户云查询信息
                    if (StringUtils.isNotEmpty(userCloudAreas)) {
                        String[] cloudAreas = userCloudAreas.split(",");
                        ArrayList<String> cloudList = Lists.newArrayList(cloudAreas);
                        List<UserCloudArea> userCloudAreaList = new ArrayList<>();
                        for (String cloud : cloudList) {
                            UserCloudArea userCloudArea = new UserCloudArea();
                            userCloudArea.setCode(cloud);
                            userCloudArea.setUserId(landUser.getId());
                            userCloudArea.setCreateTime(new Date());
                            userCloudArea.setState(1);
                            userCloudAreaList.add(userCloudArea);
                        }
                        userCloudAreaDao.saveAll(userCloudAreaList);
                    }
                    // 更新云查询配置
                    String config = userCloudQueryConfig;
                    if (StringUtils.isNotBlank(config)) {
                        String[] strs = config.split(",");
                        List<RoleCloudQueryRel> list = new ArrayList<>();
                        for (int i = 0; i < strs.length; i++) {
                            RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                            ucc.setUid(landUser.getId().toString());
                            ucc.setCid(strs[i].trim());
                            list.add(ucc);
                        }
                        roleCloudQueryRelRepository.saveAll(list);
                    }
                    //业务权限
                    if(jsonObject.get("userTaskClass") != null){
                        String userTaskClass = jsonObject.getString("userTaskClass");
                        updateUserClass(userTaskClass,landUser.getId());
                    }
                   // 修改用户业务权限
                    if(jsonObject.get("userBiz") != null){
                        String userBiz = jsonObject.getString("userBiz");
                        updateUserBiz(landUser.getId(),userBiz);
                    }

                    String appkey =(String) ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
                    String  appkeys = (String) ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEYS.getKey());
                    //单独写关联表
                    List<String> keys = new ArrayList<String>();
                    keys.add(appkey);
                    //挂接配置的其他权限
                    String[] tempKeys = appkeys.split(",");
                    for (String tempKey : tempKeys) {
                        if(keys.indexOf(tempKey)<0){
                            keys.add(tempKey);
                        }
                    }
                    List<String> appIds = UisApplicationDao.getIdByAppKey(keys);
                    for (String key : appIds) {
                        UserApplication userApp = new UserApplication();
                        String uid = UUID.randomUUID().toString();
                        userApp.setId(uid);
                        userApp.setApplicationId(key);
                        userApp.setUserId(landUser.getId());
                        userApplicationDao.save(userApp);
                    }
                }
                break;
                case "update" :{
                    LandUser landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), LandUser.class);
                    LandUser landUser1 = landUserDao.save(landUser);
                    landUserDao.updateUserId(landUser1.getId(),landUser.getId());
                    //创建单位
                    Object organizationBean = JSONObject.toJavaObject(jsonObject.getJSONObject("organization"), Organization.class);
                    String orgId = "";
                    if(organizationBean != null){
                        Organization organization = (Organization) organizationBean;
                        if(organization != null){  //校验单位是否存在，不存在进行新增
                            Organization organizations = organizationRepository.queryByNameAndRegion( organization.getName(), organization.getRegionCode());
                            if(organizations == null){  //没有单位，新增单位
                                Organization organization1 = organizationRepository.save(organization);
                                /* Organization org = organizationService.create(organization.getName(), organization.getRegionCode(),null,  null,organization.getType());*/
                                orgId = organization1.getId();
                            }else{
                                orgId = organizations.getId();
                            }
                        }
                    }
                    organization2UserDao.deleteByUserId(landUser.getId());
                    // 保存用户单位（组织机构）信息
                    Organization2User organization2User = new Organization2User();
                    organization2User.setId(UUID.randomUUID().toString());
                    organization2User.setOrganizationId(orgId);
                    organization2User.setUserId(landUser.getId());
                    organization2UserDao.save(organization2User);

                    String userRegionCode = jsonObject.getString("userRegionCode");
                    //更新用户政区
                    Integer count =   landUser2AreaDao.queryUserAreasIsExists(landUser.getId(),userRegionCode);
                    if(count <= 0 ){
                        LandUser2Area landUser2Area = new LandUser2Area();
                        landUser2Area.setUserId(landUser.getId());
                        landUser2Area.setCreateTime(landUser.getCreateTime());
                        landUser2Area.setState(1);
                        landUser2Area.setRegionCode(userRegionCode);
                        landUser2AreaDao.save(landUser2Area);
                    }
                    String userRoles = jsonObject.getString("userRoles");
                    userRoleInfoDao.deleteByUserId(landUser.getId());
                    // 保存用户角色信息
                    String[] roles = userRoles.split(",");
                    if (userRoles.indexOf(";") > -1) {
                        roles =userRoles.split(";");
                    }
                    for (String role : roles) {
                        String uid=UUID.randomUUID().toString();
                        UserRoleInfo userRole=new UserRoleInfo();
                        userRole.setId(uid);
                        userRole.setRoleinfoid(role);
                        userRole.setUserid(landUser.getId());
                        userRoleInfoDao.save(userRole);
                    }
                    String userCloudAreas = jsonObject.getString("userCloudArea");
                    userCloudAreaDao.delteByUserId(landUser.getId());
                    // 保存用户云查询信息
                    if (StringUtils.isNotEmpty(userCloudAreas)) {
                        String[] cloudAreas = userCloudAreas.split(",");
                        ArrayList<String> cloudList = Lists.newArrayList(cloudAreas);
                        List<UserCloudArea> userCloudAreaList = new ArrayList<>();
                        for (String cloud : cloudList) {
                            UserCloudArea userCloudArea = new UserCloudArea();
                            userCloudArea.setCode(cloud);
                            userCloudArea.setUserId(landUser.getId());
                            userCloudArea.setCreateTime(new Date());
                            userCloudArea.setState(1);
                            userCloudAreaList.add(userCloudArea);
                        }
                        userCloudAreaDao.saveAll(userCloudAreaList);
                    }
                    String userCloudQueryConfig = jsonObject.getString("userCloudQueryConfig");
                    roleCloudQueryRelRepository.deleteByUid(landUser.getId().toString());
                    // 更新云查询配置
                    String config = userCloudQueryConfig;
                    if (StringUtils.isNotBlank(config)) {
                        String[] strs = config.split(",");
                        List<RoleCloudQueryRel> list = new ArrayList<>();
                        for (int i = 0; i < strs.length; i++) {
                            RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                            ucc.setUid(landUser.getId().toString());
                            ucc.setCid(strs[i].trim());
                            list.add(ucc);
                        }
                        roleCloudQueryRelRepository.saveAll(list);
                    }
                    //业务权限
                    if(jsonObject.get("userTaskClass") != null){
                        String userTaskClass = jsonObject.getString("userTaskClass");
                        updateUserClass(userTaskClass,landUser.getId());
                    }
                    // 修改用户业务权限
                    if(jsonObject.get("userBiz") != null){
                        String userBiz = jsonObject.getString("userBiz");
                        updateUserBiz(landUser.getId(),userBiz);
                    }
                }
                break;
                case "updatePassWord" :{
                    LandUser landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), LandUser.class);
                    landUserDao.save(landUser);
                }
                break;
                case "delete" :{
                    Long userId = jsonObject.getLongValue("userId");
                    String deleteReason = jsonObject.getString("userRegionCode");
                    LandUser user = landUserDao.findById(userId).orElse(null);
                    if (user != null) {
                        userService.deleteUserByLiaison(101L, Long.valueOf(userId), deleteReason);
                        //删除云查询角色
                        roleCloudQueryRelRepository.deleteByUid(userId.toString());
                        //删除用户right_area信息
                        tskRightAreaRepository.deleteByUserId(userId.toString());

                    }
                }
                break;
                case "forbidden" :{
                    Long userId = jsonObject.getLongValue("userId");
                    String state = jsonObject.getString("state");
                    landUserDao.forbiddenoruserUser(userId,Integer.parseInt(state));
                }
                break;
                case "register" :{
                    LandRegUser landRegUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("landRegUser"), LandRegUser.class);
                    landRegUserRepository.save(landRegUser);
                }
                break;
                default: {
                    throw new GwValidateException("任务数据类型错误");
                }
            }
        }
    }

    public void execute(JSONObject jsonObject) throws Exception {
       handData(jsonObject);
    }
    /**
     * 用户权限
     */
    public void updateUserBiz(Long userid,String biz){
        //删除该用户对应分组下面的任务权限
        userBiz2Dao.deleteByUserIdLeftTskTaskBiz(userid);
        if (StringUtils.isNotBlank(biz) && !"".equalsIgnoreCase(biz)) {
            // 查找被去掉的权限和新增的权限
            List<String> arrays = Arrays.asList(biz.split(","));
            List<User2Biz> list = new ArrayList<>();
            for (int i = 0; i < arrays.size(); i++) {
                List<User2Biz> byBizidAndUserid = userBiz2Dao.getByBizidAndUserid(arrays.get(i), userid);
                if(byBizidAndUserid.isEmpty()){
                    User2Biz userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(3);// 默认给业务员
                    userBiz.setBizid(arrays.get(i));
                    list.add(userBiz);
                }
            }
            userBiz2Dao.saveAll(list);
        }
    }

    //业务范围权限
    public void updateUserClass(String userTaskClass,Long userId){
        //业务权限
            tbtskUserTaskClassRepository.deleteByUserId(userId);
            if(userTaskClass != null &&  !"".equalsIgnoreCase(userTaskClass)){
                String [] classIds = userTaskClass.split(",");
                List<TbtskUserTaskClass> list = new ArrayList<>();
                for (int i = 0; i < classIds.length; i++) {
                    List<TbtskUserTaskClass> tbtskUserTaskClasses = tbtskUserTaskClassRepository.queryByUserIdAndClassId(userId, Long.valueOf(classIds[i]));
                   if(tbtskUserTaskClasses.isEmpty()){
                       TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
                       tbtskUserTaskClass.setUserId(userId);
                       tbtskUserTaskClass.setCreateDate(new Date());
                       tbtskUserTaskClass.setClassId(Long.valueOf(classIds[i]));
                       list.add(tbtskUserTaskClass);
                   }
                }
                //添加用户业务范围
                tbtskUserTaskClassRepository.saveAll(list);
            }
    }

    public void handData(JSONObject jsonObject) throws Exception {
        String type  = jsonObject.getString("type");
        if(StringUtils.isNotBlank(type)){
            switch (type) {
                case "insert":
                {
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.syncAddBusUser(landUser);
                }
                break;
                case "update": {
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.syncUpdateBusUser(landUser);
                }
                break;
                case "updatePassWord" :{
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.changePasswordByUsername(landUser.getUserName(),landUser.getPassWord());
                }
                case "updatePhoneNumber" :{
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.renewPhoneNum(landUser.getMidUserId(),landUser.getPhone());
                }
                break;
                /*
                case "delete" :{
                    Long userId = jsonObject.getLongValue("userId");
                    String deleteReason = jsonObject.getString("userRegionCode");
                    LandUser user = landUserDao.findById(userId).orElse(null);
                    if (user != null) {
                        userService.deleteUserByLiaison(101L, Long.valueOf(userId), deleteReason);
                        //删除云查询角色
                        roleCloudQueryRelRepository.deleteByUid(userId.toString());
                        //删除用户right_area信息
                        tskRightAreaRepository.deleteByUserId(userId.toString());

                    }
                }
                break;
                */
                case "forbidden" :{
                    SyncUserInfo landUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("user"), SyncUserInfo.class);
                    oauthUserService.setUserEnable(landUser.getMidUserId(),landUser.getEnable());
                }
                break;
                case "register" :{
                    LandRegUser landRegUser  = JSONObject.toJavaObject(jsonObject.getJSONObject("landRegUser"), LandRegUser.class);
                    landRegUserRepository.save(landRegUser);
                }
                break;
                default: {
                    throw new GwValidateException("任务数据类型错误");
                }
            }
        }
    }
}
