package com.geoway.landteam.landcloud.service.networkTransmission.utils;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterTaskTransmitDataService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import okhttp3.*;

import java.io.File;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.networkTransmission.utils
 * @date 2022/2/25 10:18
 */
public class HttpUtil {
    private static GiLoger logger = GwLoger.getLoger(HttpUtil.class);
    /**
     * 发生摆渡机数据
     * @param appkey
     * @param module
     * @param file
     * @param url
     * @return
     */
    public static JSONObject sendRrquestByFile(String appkey, String module, File file, String url) {
            JSONObject result = new JSONObject();
            result.put("code", 1);
            result.put("status", "FAILURE");
            OkHttpClient client = new OkHttpClient();
            try {
                MultipartBody.Builder requestBody = new MultipartBody.Builder("aa").setType(MultipartBody.FORM);
                    try {
                        MediaType type = MediaType.parse("application/octet-stream");
                        RequestBody fileBody = RequestBody.create(type, file);
                        requestBody.addPart(Headers.of("Content-Disposition", "form-data; name=\"file\" ; " +
                                "filename=\"" + file.getName() + "\""), fileBody);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                requestBody.addFormDataPart("appkey",appkey);
                requestBody.addFormDataPart("module", module);
                Request request = new Request.Builder()
                        .url(url)
                        .post(requestBody.build())
                        .build();
                Response response = client.newCall(request).execute();
                String result1 = response.body().string();
                result = JSONObject.parseObject(result1.substring(result1.indexOf("{"), result1.lastIndexOf("}") + 1));
            } catch (Exception e) {
                logger.error("网间传输服务调用异常"+ ExceptionUtil.getErrorString(e));
            } finally {
                 client.dispatcher().executorService().shutdown();
            }
        return result;
    }

    //发送摆渡机回调接口
    public static JSONObject sendRequestById(String id, String url) {
            JSONObject result = new JSONObject();
            result.put("code", 1);
            result.put("status", "FAILURE");
            OkHttpClient client = new OkHttpClient();
            try {
                MultipartBody.Builder requestBody = new MultipartBody.Builder("aa").setType(MultipartBody.FORM);
                requestBody.addFormDataPart("id",id);
                Request request = new Request.Builder()
                        .url(url)
                        .post(requestBody.build())
                        .build();
                Response response = client.newCall(request).execute();
                String result1 = response.body().string();
                result = JSONObject.parseObject(result1.substring(result1.indexOf("{"), result1.lastIndexOf("}") + 1));
            } catch (Exception e) {
                logger.error("网间传输服务回调"+ ExceptionUtil.getErrorString(e));
            } finally {
                 client.dispatcher().executorService().shutdown();
            }
        return result;
    }



}
