package com.geoway.landteam.landcloud.service.networkTransmission.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class Md5Utils {
    /**
     * 获取随机字符串，可用于加密 添加字符，增加保密度
     */
    private static final String ALLCHAR = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    private static Random random = new Random();
    /**
     * 获取任意位的随机字符串(0-9 a-z A-Z)
     *
     * @param size
     *            位数
     * @return
     */
    public static String getRandomNum(int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; i++) {
            sb.append(ALLCHAR.charAt(random.nextInt(ALLCHAR.length())));
        }
        return sb.toString();
    }

    /**
     * md5加密(ITS)
     *
     * @param str
     * @param charSet
     * @return
     */
    public synchronized static String getMD5Str(String str, String charSet) { // md5加密
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            if (charSet == null) {
                messageDigest.update(str.getBytes(StandardCharsets.UTF_8));
            } else {
                messageDigest.update(str.getBytes(charSet));
            }
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            return null;
        }

        byte[] byteArray = messageDigest.digest();
        StringBuilder md5StrBuff = new StringBuilder();
        for (int i = 0; i < byteArray.length; i++) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
            } else {
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
        }
        return md5StrBuff.toString();
    }

    /**
     * md5加密16位(ITS)
     *
     * @param str
     * @param charSet
     * @return
     */
    public synchronized static String getMD5Str16(String str, String charSet) { // md5加密
        String md5str = getMD5Str(str,charSet);
        if(md5str == null){
            return null;
        }
        return md5str.substring(8,24);
    }
}
