package com.geoway.landteam.landcloud.service.oauth;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.constant.OrgTypeAliasEnum;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.oauth.OrganizationCertificateResoDto;
import com.geoway.landteam.landcloud.servface.oauth.OauthOrganizationService;
import com.geoway.landteam.platform.mgruser.res3user.api.user.MgrUserRes3UserService;
import com.geoway.landteam.platform.mgruser.res3user.api.user.reso.SysUserReso;
import com.geoway.landteam.platform.mgruser.sdk.MgrUserRes3UserSdkService;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.organization.OrganizationRes3UserSdk;
import com.geoway.landteam.platform.mgruser.MgrUserRes3Sdk;
import com.geoway.landteam.platform.organization.res3.api.OrganizationCertificateRes3Service;
import com.geoway.landteam.platform.organization.res3.api.OrganizationSelectRes3Service;
import com.geoway.landteam.platform.organization.res3.api.em.OrganizationTypeCodeEnum;
import com.geoway.landteam.platform.organization.res3.api.reso.*;
import com.geoway.landteam.platform.organization.res3user.api.OrganizationCertificateRes3UserService;
import com.geoway.landteam.platform.organization.res3user.api.OrganizationSelectRes3UserService;
import com.geoway.landteam.platform.organization.res3user.api.em.OrganizationCertificateEnum;
import com.geoway.landteam.platform.organization.res3user.api.ro.MsgRo;
import com.geoway.landteam.platform.organization.res3user.api.ro.OrganizationCertificateRo;
import com.geoway.landteam.platform.organization.res3user.api.ro.OrganizationRo;
import com.geoway.landteam.platform.ucs.UcsRes3Sdk;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserSelectRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;
import com.gw.base.util.GutilStr;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class OatuhOrganizationServiceImpl implements OauthOrganizationService {
    private OrganizationSelectRes3UserService organizationSelectRes3UserService = OrganizationRes3UserSdk.getOrganizationSelectRes3UserService();

    private OrganizationSelectRes3Service organizationSelectRes3Service = OrganizationRes3Sdk.getOrganizationSelectRes3Service();

    private MgrUserRes3UserService mgrUserRes3UserSdkService = MgrUserRes3Sdk.getMgrUserRes3UserService();

    private OrganizationCertificateRes3UserService organizationCertificateRes3UserService = OrganizationRes3UserSdk.getOrganizationCertificateRes3UserService()       ;

    private OrganizationCertificateRes3Service organizationCertificateRes3Service = OrganizationRes3Sdk.getOrganizationCertificateRes3Service();

    private EpaUserSelectRes3Service epaUserSelectRes3Service = UcsRes3Sdk.getEpaUserSelectRes3Service();

    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    RegionVersionRepository regionVersionRepository;

    @Autowired
    RegionRepository regionRepository;
    @Override
    public List<OrganizationRo> getUserOrganization(String pid, Integer type, String orgRegion, String orgName, AuthUserInfo authUserInfo) {
        List<OrganizationTypeReso> organizationTypeResos = organizationSelectRes3Service.orgTypeList(false);
        if (organizationTypeResos != null) {
            List<String> types = organizationTypeResos.stream().map(OrganizationTypeReso::getOrgTypeName).collect(Collectors.toList());
            if (types.contains(pid)) {
                String finalPid = pid;
                type = organizationTypeResos.stream().filter(t -> t.getOrgTypeName().equals(finalPid)).findFirst().get().getOrgTypeCode();
                pid = null;
            }
        }
        List<OrganizationRo> result = new ArrayList<>();

        SysUserReso userReso =null;
        try {
            userReso = mgrUserRes3UserSdkService.findByMidUserId(authUserInfo.getMidUserId());
        }
        catch (Exception ex)
        {

        }
        if(userReso!=null) {

            OrganizationReso organizationReso = organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId());
            orgRegion = organizationReso.getRegionCode();
            orgName = null;
            if(orgRegion.endsWith("0000"))
            {
                orgRegion=null;
            }
            List<OrganizationReso>organizationResos=   organizationSelectRes3Service.searchOrganizationChildrenById(pid, type, orgRegion, orgName);
            if(organizationResos!=null)
            {
                for (OrganizationReso reso:organizationResos) {
                    OrganizationRo ro = new OrganizationRo();
                    BeanUtils.copyProperties(reso, ro);
                    result.add(ro);
                }

            }
        }
        else {

            //result = organizationSelectRes3UserService.searchOrganizationByPid(pid, type, orgRegion, orgName);
            result = organizationSelectRes3UserService.searchOrganizationByPid(pid, type, orgRegion, orgName);
        }
        return result;
    }

    @Override
    public OrganizationReso getOrganization(String id) {
        return organizationSelectRes3Service.searchOrganizationById(id);
    }
    @Override
    public List<OrganizationTypeReso> getOrganizationTypeList() {
       List<OrganizationTypeReso>organizationTypeResos= organizationSelectRes3Service.orgTypeList(false);

       return organizationTypeResos;
    }

    @Override
    public List<OrganizationReso> getOrganizations(String id, Integer type, String orgRegion, String orgName) {
        return  organizationSelectRes3Service.searchOrganizationChildrenById(id, type, orgRegion, orgName);
    }
    @Override
    public String getOrgFullNameById(String id) {
        return  organizationSelectRes3Service.getOrgFullNameById(id);
    }
    @Override
    public OrganizationPager OrganizationByCodeAndKeyWord(String orgType, String regionName, String sjsf, String keyWord, int page, int rows) throws Exception {
        String regionCode;

        if (GutilStr.isBlank(sjsf)) {
            if ("全国".equals(regionName)) {
                regionCode = "1";
            } else {
                RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
                regionCode = regionRepository.getCodeByNameAndVersion(regionName, defaultVersion != null ? defaultVersion.getVersion() : "2018");
            }
        } else {
            regionCode = sjsf;
        }

        OrganizationSearchReso searchReso = new OrganizationSearchReso();
        searchReso.setRegionCode(regionCode);
        if(StringUtils.isNotBlank(orgType))
        {
            searchReso.setOrgTypeCode(Integer.parseInt(orgType));
        }

        if(StringUtils.isNotBlank(keyWord)) {
            searchReso.setOrgName(keyWord);
        }
        OrganizationPager pages = organizationSelectRes3Service.searchOrganizationPage(searchReso,page,rows);
        return pages;
    }

    @Override
    public OrganizationPager getLikelyParentOrg(String sjsf, String orgType, String keyWord, int page, int rows) throws Exception {



        OrganizationSearchReso searchReso = new OrganizationSearchReso();
        if (GutilStr.isNotBlank(keyWord)) {
            searchReso.setOrgName(keyWord);
        }
        if (GutilStr.isNotBlank(orgType)) {
            searchReso.setOrgTypeCode(Integer.parseInt(orgType));
        }

        if ("1".equals(sjsf)) {
            searchReso.setRegionCode("1");
        } else {
            RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
            Region region = regionRepository.findByCodeAndVersion(sjsf, defaultVersion != null ? defaultVersion.getVersion() : "2018");
            if (region == null) {
                throw new RuntimeException("行政区代码有误");
            }
            String pCode = region.getPcode();
            if ("-1".equalsIgnoreCase(pCode)) {
                pCode = "1";
            }
            String [] regions = new String[2];
            regions[0] = sjsf;
            regions[1] = pCode;
            searchReso.setAndRegionCodeIn(regions);
        }

        OrganizationPager pages = organizationSelectRes3Service.searchOrganizationPage(searchReso,page,rows);
        return pages;
    }

    @Override
    public OrganizationCertificateResoDto submitCertificateFile(AuthUserInfo authUserInfo,String orgId, String typeCertificate,MultipartFile file) throws Exception {
        boolean hasPemission=false;
        if(authUserInfo.getAdminMgr())
        {
            hasPemission=true;
        }
        if(authUserInfo.getMgr()&&authUserInfo.getOrgId().equals(orgId))
        {
            hasPemission=true;
        }
        OrganizationReso organizationReso = organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId());
        if(organizationReso!=null&&organizationReso.getOrgTypeCode().equals(2)&&authUserInfo.getMgr()){
            hasPemission=true;
        }
        if(!hasPemission)
        {
            throw new Exception("当前用户无权限上传单位资质文件");
        }
        String filename = file.getOriginalFilename();
        String fileSuffix = filename.substring(filename.lastIndexOf(".")+1);
        if(!fileSuffix.toLowerCase().equals("pdf"))
        {
            throw new Exception("当前文件不是pdf格式");
        }
        List<String>types = new ArrayList<>();
        types.add("营业执照");
        types.add("承诺书");
        types.add("测绘资质");
        if(!types.contains(typeCertificate))
        {
            throw new Exception("文件类型错误");
        }
        File tempFile = null;
        File folder=null;
        try {
            filename = filename.substring(0, filename.lastIndexOf("."));
            String temp = uploadDir + File.separator + UUID.randomUUID().toString();
            folder = new File(temp);
            folder.mkdir();
            temp = temp + File.separator + file.getOriginalFilename();
            tempFile = new File(temp);
            file.transferTo(tempFile);
            OrganizationCertificateRo ro = organizationCertificateRes3UserService.submitFile(orgId, typeCertificate, filename, tempFile, fileSuffix);
            OrganizationCertificateResoDto result = new OrganizationCertificateResoDto();
            result.setSubmitUserName(authUserInfo.getUsername());
            BeanUtils.copyProperties(ro, result);
            return result;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally {
            if(tempFile!=null&&tempFile.exists()) {
                FileUtils.deleteQuietly(tempFile);
            }
            if(folder!=null&&folder.exists()) {
                FileUtils.deleteQuietly(folder);
            }
        }
    }

    @Override
    public List<OrganizationCertificateResoDto> searchCertificateList(AuthUserInfo authUserInfo,OrganizationCertificateSearchReso searchReso) throws Exception {
        boolean hasPemission=false;
        if(authUserInfo.getAdminMgr())
        {
            hasPemission=true;
        }
        if(authUserInfo.getMgr()&&authUserInfo.getOrgId().equals(searchReso.getOrgId()))
        {
            hasPemission=true;
        }
        OrganizationReso organizationReso = organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId());
        if(organizationReso!=null&&organizationReso.getOrgTypeCode().equals(2)&&authUserInfo.getMgr()){
            hasPemission=true;
        }
        if(!hasPemission)
        {
            throw new Exception("当前用户无权限查看单位资质文件");
        }
        List<OrganizationCertificateReso> results = organizationCertificateRes3Service.searchList(searchReso);
        if(results==null||results.isEmpty())
            return null;

        List<OrganizationCertificateResoDto>resoDtos = new ArrayList<>();
        Map<String,String> map = new HashMap<>();
        for(OrganizationCertificateReso reso:results)
        {
            OrganizationCertificateResoDto dto = new OrganizationCertificateResoDto();
            BeanUtils.copyProperties(reso,dto);
            String username=null;
            if(!map.containsKey(reso.getMidUserCreate()))
            {
                EpaUserReso epaUserReso = epaUserSelectRes3Service.getUserByUserId(reso.getMidUserCreate());
                map.put(reso.getMidUserCreate(),epaUserReso!=null?epaUserReso.getUserName():"");
            }

            username = map.get(reso.getMidUserCreate());
            dto.setSubmitUserName(username);

            OrganizationCertificateEnum organizationCertificateEnum = OrganizationCertificateEnum.valueOf(dto.getTypeCertificate());
            dto.setIndex(organizationCertificateEnum.ordinal());
            resoDtos.add(dto);
        }
        Collections.sort(resoDtos, (reso1, reso2) -> {
            return reso1.getIndex().compareTo(reso2.getIndex());
        });
        return resoDtos;
    }

    @Override
    public String getCertificateFileAccessUrl(String fileObjectId) {
        return organizationCertificateRes3Service.getFileAccessUrl(fileObjectId);
    }
    @Override
    public MsgRo deleteCertificate(String certificateId)
    {
        return organizationCertificateRes3UserService.delFile(certificateId);

    }
    @Override
    public Boolean hasCertificatePermission(AuthUserInfo authUserInfo) {
        boolean hasPemission=false;
        if(authUserInfo.getAdminMgr())
        {
            hasPemission=true;
        }
        if(authUserInfo.getMgr())
        {
            hasPemission=true;
        }
        OrganizationReso organizationReso = organizationSelectRes3Service.searchOrganizationById(authUserInfo.getOrgId());
        if(organizationReso!=null&&organizationReso.getOrgTypeCode().equals(2)&&authUserInfo.getMgr()){
            hasPemission=true;
        }
        return hasPemission;
    }

    @Override
    public List<String> getAllChildIds(String orgId) {
        List<OrganizationReso>orgs =  organizationSelectRes3Service.searchOrganizationChildrenByIdAanLevel(orgId,null,null);
        if(orgs==null||orgs.isEmpty())
            return null;
        return orgs.stream().map(OrganizationReso::getOrgId).collect(Collectors.toList());
    }
}
