package com.geoway.landteam.landcloud.service.oauth;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQuery;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.gac.oauth2.mini.GacOauth2Tool;
import com.geoway.landteam.gac.oauth2.mini.as.Oauth2Provider;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClient;
import com.geoway.landteam.gac.oauth2.mini.client.OAuth2AuthorizedClientService;
import com.geoway.landteam.gac.oauth2.mini.client.Oauth2ClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.client.support.ClientCredentialsClientRegistration;
import com.geoway.landteam.gac.oauth2.mini.core.AuthorizationGrantType;
import com.geoway.landteam.gac.oauth2.mini.core.OAuth2AccessToken;
import com.geoway.landteam.gac.oauth2.mini.core.OAuth2RefreshToken;
import com.geoway.landteam.gac.oauth2.mini.util.URLUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.dto.MyRegion;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserSimpleInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.dto.RegUserInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.*;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserCloudAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.*;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.SecurityService;
import com.geoway.landteam.landcloud.core.service.user.FriendsServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.VertifyServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.model.oauth.*;
import com.geoway.landteam.landcloud.model.pub.entity.TbsysUserSubjectRel;
import com.geoway.landteam.landcloud.repository.pub.TbsysUserSubjectRelRepository;
import com.geoway.landteam.landcloud.servface.oauth.OauthOrganizationService;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterUserTransmitDataService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.RSA;
import com.geoway.landteam.platform.business.BusinessRes3Sdk;
import com.geoway.landteam.platform.business.res3.api.bususer.BusUserRes3Service;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.*;
import com.geoway.landteam.platform.business.res3.api.orguser.OrgUserSelectRes3Service;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailPager;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserDetailReso;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserSearchReso;
import com.geoway.landteam.platform.mgruser.MgrUserRes3Sdk;
import com.geoway.landteam.platform.mgruser.res3user.api.user.MgrUserRes3UserService;
import com.geoway.landteam.platform.mgruser.res3user.api.user.reso.SysUserReso;
import com.geoway.landteam.platform.organization.OrganizationRes3Sdk;
import com.geoway.landteam.platform.organization.res3.api.OrganizationSelectRes3Service;
import com.geoway.landteam.platform.organization.res3.api.reso.OrganizationReso;
import com.geoway.landteam.platform.permission.PermissionRes3UserSdk;
import com.geoway.landteam.platform.permission.res3user.api.pmc.Res3UserPermissionService;
import com.geoway.landteam.platform.permission.res3user.api.pmc.ro.RoleRelRo;
import com.geoway.landteam.platform.permission.res3user.api.pmc.ro.RoleResourceDetailRo;
import com.geoway.landteam.platform.ucs.UcsRes3Sdk;
import com.geoway.landteam.platform.ucs.UcsRes3UserSdk;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaRegisterUserRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserRealNameRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserSelectRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.EpaUserUpdateRes3Service;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaRealNameAddReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaRealNameReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserAddReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;
import com.geoway.landteam.platform.ucs.res3user.api.user.EpaUserSelectRes3UserService;
import com.geoway.landteam.platform.ucs.res3user.api.user.reso.EpaUserInfoReso;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.*;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.*;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

@Transactional
@Service
public class OauthUserServiceImpl implements OauthUserService {
    private GiLoger logger = GwLoger.getLoger(OauthUserServiceImpl.class);
    @Autowired
    UserCloudAreaRepository userCloudAreaRepository;

    @Autowired
    RoleCloudQueryRepository roleCloudQueryRepository;

    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;

    @Autowired
    TbsysUserSubjectRelRepository tbsysUserSubjectRelRepository;

    @Autowired
    LandUserService landUserService;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    YXUserRepository yxUserRepository;

    @Autowired
    FriendsServiceImpl friendsService;

    @Autowired
    VertifyServiceImpl vertifyService;

    @Autowired
    SecurityService securityService;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    User2BizRepository user2BizRepository;

    @Autowired
    TskRightAreaRepository tskRightAreaRepository;

    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;

    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    UserRoleInfoRepository userRoleInfoDao;

    @Autowired
    UserCloudAreaRepository userCloudAreaDao;

    @Autowired
    LandRegUserRepository landRegUserRepository;

    @Autowired
    LandRegUserService regUserService;

    @Autowired
    LandRegUserRepository landRegUserDao;

    @Autowired
    RegionService regionService;

    @Autowired
    RegionVersionRepository regionVersionRepository;

    @Autowired
    RegionRepository regionDao;
    @Autowired
    RegionTownRepository regionTownDao;

    @Autowired
    RegionVillageRepository regionVillageRepository;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    OauthOrganizationService oauthOrganizationService;

    private OrgUserSelectRes3Service orgUserSelectRes3Service = BusinessRes3Sdk.getOrgUserSelectRes3Service();
    private BusUserRes3Service busUserRes3SdkService = BusinessRes3Sdk.getBusUserRes3Service();


    private EpaRegisterUserRes3Service epaRegisterUserRes3Service = UcsRes3Sdk.getEpaRegisterUserRes3Service();
    private EpaUserSelectRes3Service epaUserSelectRes3Service = UcsRes3Sdk.getEpaUserSelectRes3Service();

    private EpaUserRealNameRes3Service epaUserRealNameRes3Service = UcsRes3Sdk.getEpaUserRealNameRes3Service();

    private EpaUserUpdateRes3Service epaUserUpdateRes3Service = UcsRes3Sdk.getEpaUserUpdateRes3Service();

    private EpaUserSelectRes3UserService epaUserSelectRes3UserService = UcsRes3UserSdk.getEpaUserSelectRes3UserService();

    private OrganizationSelectRes3Service organizationSelectRes3Service = OrganizationRes3Sdk.getOrganizationSelectRes3Service();

    private MgrUserRes3UserService mgrUserRes3UserSdkService = MgrUserRes3Sdk.getMgrUserRes3UserService();

    private Res3UserPermissionService res3UserPermissionService = PermissionRes3UserSdk.getPermissionRes3UserService();

    @Override
    public List<RoleResourceDetailRo> getUserResource()
    {
        //List<RoleRelRo> roles = res3UserPermissionService.getRoleListByUser();
        List<RoleResourceDetailRo>resource =  res3UserPermissionService.getServiceResourceListByUser();
        return resource;
    }

    @Override
    public String getRealName(String busUserId)
    {
        EpaRealNameReso realNameReso =   epaUserRealNameRes3Service.searchRealNameByUserId(busUserId);
        return  realNameReso!=null?realNameReso.getRealName():null;
    }

    @Override
    public EpaUserReso getMidtUser(String midUserId) {
        return epaUserSelectRes3Service.getUserByUserId(midUserId);

    }

    @Override
    public EpaUserReso getMidtUser(Long userId) {
        List<TbsysUserSubjectRel> subjectRels =  tbsysUserSubjectRelRepository.findByUserId(userId);
        if(subjectRels==null||subjectRels.isEmpty())
            return null;
        return getMidtUser(subjectRels.get(0).getMidUserId());

    }

    @Override
    public EpaUserReso getMidtUserByPhone(String phoneNumber) {
        return epaUserSelectRes3Service.getUserByUserphone(phoneNumber);

    }
    @Override
    public BusUserInfoReso getBusUser(String busUserId) {
        return busUserRes3SdkService.userInfo(busUserId);

    }
    @Override
    public BusUserInfoReso getBusUserByPhone(String phoneNumber) {
        return busUserRes3SdkService.getUserInfo(null,null,null,phoneNumber);

    }
    @Override
    public EpaUserReso getMidtUserByUserName(String userName)
    {
        return  epaUserSelectRes3Service.getUserByUsername(userName);
    }

    @Override
    public  String getUserpasswordByMidUserId(String midUserId)
    {
        return  epaUserSelectRes3Service.getUserpasswordByUserId(midUserId);
    }
    @Override
    public boolean match(String userName,String password)
    {
        EpaUserReso epaUserReso= epaUserSelectRes3Service.getUserByUsername(userName);
        if(epaUserReso==null)
            return false;
        String pwd = epaUserSelectRes3Service.getUserpasswordByUserId(epaUserReso.getUserId());
        if(pwd.startsWith("{")&&pwd.contains("}"))
        {
            pwd = pwd.split("}")[1];
        }
        if (!password.equals(pwd)) {
            //将密码转为MD5
            String passwordMD5 = Md5Util.calFileMd5ByByte(password.getBytes());
            if (!passwordMD5.equals(pwd) && !passwordMD5.endsWith(pwd)) {
                BCrypt.Verifyer verifyer = BCrypt.verifyer();
                //返回类型要求是BCrypt的result类型，点进去看源码可以看到result有verified属性判断是否匹配
                BCrypt.Result result = verifyer.verify( password.toCharArray(),pwd.toCharArray());
                //第二种是校验BCrypt加密方式
                if (!result.verified) {
                   return false;
                }
            }
        }
        return true;
    }

    /*
    @Override
    public Long addUser(AuthUserInfo userInfo) {
        TbsysUserSubjectRel subjectRel = new TbsysUserSubjectRel();
        subjectRel.setSubjectUserId(userInfo.getEpaUserId());
        subjectRel.setMidUserId(userInfo.getMidUserId());
        subjectRel.setCreatetime(new Date());
        subjectRel.setUserName(userInfo.getUsername());
        subjectRel.setRealName(userInfo.getUserRname());
        subjectRel = tbsysUserSubjectRelRepository.save(subjectRel);
        Long userId = subjectRel.getUserId();
        addUser(userId,userInfo.getRegionCode());
        return userId;
    }
    */

    @Override
    public BusUserDetailPagerDto listOrganizationAndBusUserPage(BusUserSearchReso searchReso, Integer pageNum, Integer pageSize) {
        BusUserDetailPager pages = orgUserSelectRes3Service.listOrganizationAndBusUserPage(searchReso,pageNum,pageSize);
        List<BusUserDetailResoDto>userDtos = new ArrayList<>();
        BusUserDetailPagerDto pageDto = new BusUserDetailPagerDto();
        pageDto.setPageNum(pages.getPageNum());
        pageDto.setPageParam(pages.getPageParam());
        pageDto.setPageSize(pages.getPageSize());
        pageDto.setTotal(pages.getTotal());
        pageDto.setStartRow(pages.getStartRow());
        if(pages.getList()!=null)
        {
            for (BusUserDetailReso user: pages.getList()) {
                BusUserDetailResoDto dto = new BusUserDetailResoDto();
                dto.setBusUserId(user.getBusUserId());
                dto.setEmail(user.getEmail());
                dto.setMidUserId(user.getMidUserId());
                dto.setOrgId(user.getOrgId());
                dto.setOrgName(user.getOrgName());
                dto.setOrgRole(user.getOrgRole());
                dto.setEnable(user.getEnable());
                dto.setOrgRegion(user.getOrgRegion());
                dto.setOrgType(user.getOrgType());
               /* dto.setPhone(user.getPhone());*/
                dto.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
                dto.setRealName(user.getRealName());
                dto.setUserName(user.getUserName());
                dto.setRegionCode(user.getRegionCode());
                dto.setTimeCreate(user.getTimeCreate());
                dto.setTimeExpire(user.getTimeExpire());
                List<TbsysUserSubjectRel> subjectUser= tbsysUserSubjectRelRepository.findByMidUserId(user.getMidUserId());
                if (subjectUser != null && subjectUser.size() > 0) {
                    TbsysUserSubjectRel subjectRel = subjectUser.get(0);
                    dto.setUserId(subjectRel.getUserId());
                }
                /*
                else
                {
                    subjectUser= tbsysUserSubjectRelRepository.findByPhoneNumber(user.getPhone());
                    if(subjectUser==null||subjectUser.isEmpty()) {
                        TbsysUserSubjectRel subjectRel = new TbsysUserSubjectRel();
                        subjectRel.setSubjectUserId(user.getBusUserId());
                        subjectRel.setMidUserId(user.getMidUserId());
                        subjectRel.setCreatetime(new Date());
                        subjectRel.setUserName(user.getUserName());
                        subjectRel.setRealName(user.getRealName());
                        subjectRel.setPhoneNumber(user.getPhone());
                        subjectRel = tbsysUserSubjectRelRepository.save(subjectRel);
                        Long userId = subjectRel.getUserId();
                        addUser(userId, user.getRegionCode());
                        dto.setUserId(userId);
                    }
                    else
                    {
                        TbsysUserSubjectRel subjectRel = subjectUser.get(0);
                        dto.setUserId(subjectRel.getUserId());
                        if(StringUtils.isBlank(subjectRel.getMidUserId())||StringUtils.isBlank(subjectRel.getSubjectUserId())) {
                            subjectRel.setSubjectUserId(user.getBusUserId());
                            subjectRel.setMidUserId(user.getMidUserId());
                            subjectRel = tbsysUserSubjectRelRepository.save(subjectRel);
                        }

                    }
                }
                */
                /*
                if(StringUtils.isBlank(dto.getOrgRole()))
                {
                    List<String>roleIds =  userRoleInfoDao.getRoleIdsByUserId(dto.getUserId());
                    for (String role:roleIds) {
                        String orgRole="";
                        switch (role)
                        {
                            case "10022":
                                orgRole="管理员";
                                break;
                            case "10020":
                                orgRole="联络员";
                                break;
                            case "10024":
                                orgRole="审核员";
                                break;
                            case "10025":
                                orgRole="复核员";
                                break;
                            case "10007":
                                orgRole="普通用户";
                                break;
                            default:
                                break;
                        }
                        if(StringUtils.isNotBlank(orgRole))
                        {
                            dto.setOrgRole(orgRole);
                            break;
                        }
                    }
                }
                */
                userDtos.add(dto);
            }
        }
        pageDto.setList(userDtos);
        return pageDto;
    }
    @Override
    public RegUserDetialDto getRegUserDetial(String id)
    {
        LandRegUser regUser = landRegUserDao.findById(id).orElse(null);

        RegUserDetialDto regUserDetialDto = new RegUserDetialDto();
        regUserDetialDto.setOrgRole(getOrgRoleByRoleId(regUser.getRoleIds()));
        regUserDetialDto.setOrgName(regUser.getPostId());
        regUserDetialDto.setOrgId(regUser.getDepNo());
        regUserDetialDto.setPhone(regUser.getPhone());
        regUserDetialDto.setUserName(regUser.getName());
        regUserDetialDto.setRealName(regUser.getRname());
        regUserDetialDto.setRegionCode(regUser.getRegionCode());
        regUserDetialDto.setEmail(regUser.getEmail());
        OrganizationReso org = organizationSelectRes3Service.searchOrganizationById(regUser.getDepNo());
        if(org!=null)
        {
            regUserDetialDto.setOrgRegion(org.getRegionCode());
            regUserDetialDto.setOrgType(org.getOrgType());

        }

        List<UserCloudArea> cloudAreas = new ArrayList<>();
        UserCloudArea cloudArea = new UserCloudArea();
        cloudArea.setCode(regUser.getRegionCode());
        cloudArea.setCodeName( regionService.getName(regUser.getRegionCode()));
        cloudAreas.add(cloudArea);
        regUserDetialDto.setCloudAreas(cloudAreas);

        Map<String,Object>map = regionCodeLevel(regUser.getRegionCode());
        String cloudRole = map.get("cloudRole").toString();
        List<String>ids = new ArrayList<>();
        ids.add(cloudRole);
        List<RoleCloudQuery> cloudRoles = roleCloudQueryRepository.findByIds(ids);
        regUserDetialDto.setCloudRoles(cloudRoles);
        return regUserDetialDto;
    }



    @Override
    public  void setUserEnable(Long userId, Integer enable) throws Exception {
        List<TbsysUserSubjectRel>  subjectRel = tbsysUserSubjectRelRepository.findByUserId(userId);

        if(subjectRel==null||subjectRel.isEmpty())
        {
            throw new Exception("未找到用户:"+userId+"对应的统一用户");
        }
        String midUserId=subjectRel.get(0).getMidUserId();
        busUserRes3SdkService.updateEnable(midUserId,enable);
    }
    @Override
    public  void setUserEnable(String midUserId, Integer enable) {

        busUserRes3SdkService.updateEnable(midUserId,enable);
    }
    @Override
    public SyncUserInfo setUserInfo(Long userId, String orgId, String regionCode, String orgRole, String cloudRoleId, String cloudArea) throws Exception {
        SyncUserInfo syncUserInfo = new SyncUserInfo();
        setUserInfo(userId,orgId,regionCode,orgRole,syncUserInfo);

        userCloudAreaRepository.delteByUserId(userId);
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(userId);
        userCloudArea.setCode(cloudArea);
        userCloudArea.setState(1);
        userCloudArea.setCreateTime(new Date());
        userCloudAreaRepository.save(userCloudArea);

        roleCloudQueryRelRepository.deleteByUserId(userId.toString());
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(userId.toString());
        roleCloudQueryRel.setCid(cloudRoleId);
        roleCloudQueryRelRepository.save(roleCloudQueryRel);

        syncUserInfo.setCloudArea(cloudArea);
        syncUserInfo.setCloudRoleId(cloudRoleId);
        LandUser landUser = landUserRepository.queryUserById(userId);
        syncUserInfo.setUserName(landUser.getName());
        return syncUserInfo;
    }

    @Override
    public void setUserInfo2(Long userId,String phone,String email,String regionCode) throws Exception {
        List<TbsysUserSubjectRel>  subjectRel = tbsysUserSubjectRelRepository.findByUserId(userId);

        if(subjectRel==null||subjectRel.isEmpty())
        {
            throw new Exception("未找到用户:"+userId+"对应的业务用户");
        }
        String busUserId=subjectRel.get(0).getSubjectUserId();

        if(StringUtils.isNotBlank(phone)||StringUtils.isNotBlank(email)) {
            epaUserSelectRes3UserService.updateUserInfo(phone, email, null, null, null,null);
        }
        if(StringUtils.isNotBlank(regionCode)) {
            BusUserUpdateReso userUpdateReso = new BusUserUpdateReso();
            userUpdateReso.setBusUserId(busUserId);
            userUpdateReso.setRegionCode(regionCode);
            busUserRes3SdkService.updateBusUser(userUpdateReso);
        }
    }
    @Override
    public UserSimpleInfo getUserInfo(Long ownerId, Long userId) throws Exception {
        UserSimpleInfo userSimpleInfo = new UserSimpleInfo();

        /*
        LandUser landUser = landUserService.queryUserById(userIdL);
        if (landUser == null) {
            return null;
        }
        */
        List<TbsysUserSubjectRel> subjects = tbsysUserSubjectRelRepository.findByUserId(userId);
        if(subjects==null||subjects.isEmpty())
            return null;
        EpaUserReso userReso = epaUserSelectRes3Service.getUserByUserId(subjects.get(0).getSubjectUserId());
        if(userReso==null)
        {
            return null;
        }
        EpaRealNameReso realNameReso =   epaUserRealNameRes3Service.searchRealNameByUserId(subjects.get(0).getSubjectUserId());
        userSimpleInfo.setUserId(userId);

        userSimpleInfo.setUserRefName(realNameReso==null?"":realNameReso.getRealName());
        //userSimpleInfo.setGender(landUser.getSex());
        //userSimpleInfo.setCompany(landUser.getDepId());
        userSimpleInfo.setPost(userReso.getEmail());
        userSimpleInfo.setPhoneNumber(userReso.getPhoneNumber());
        //userSimpleInfo.setDesc();
        //userSimpleInfo.setBusiness(landUser.getBusiness());
        //userSimpleInfo.setImgUrl(landUser.getImgUrl());

        YXUser yxUser = yxUserRepository.findById(userId).orElse(null);
        if (yxUser != null) {
            userSimpleInfo.setAccid(yxUser.getAccid());
        }
        userSimpleInfo.setMyFriend(isMyFriend(ownerId, userId));
        return userSimpleInfo;
    }

    @Override
    public boolean isPhoneRegistered(String phone)
    {
        EpaUserReso userReso =  epaUserSelectRes3Service.getUserByUserphone(phone);
        return userReso!=null;
    }

    @Override
    public void renewPhoneNum(Long userId, String newPhoneNum, String verifyCode) {

        LandUser landUser = landUserService.queryUserById(userId);
        if (landUser == null) {
            throw new RuntimeException("用户不存在");
        }

        if (StringUtils.isBlank(verifyCode)) {
            throw new RuntimeException("验证码为空");
        }
        if (StringUtils.isBlank(newPhoneNum)) {
            throw new RuntimeException("手机号为空");
        }
        if (isPhoneRegistered(newPhoneNum)) {
            throw new RuntimeException("手机号已被使用");
        }
        List<Vertify> curVerty = vertifyService.findByFilter(newPhoneNum, verifyCode);
        if (curVerty.size() == 0) {
            throw new RuntimeException("验证码错误");
        }
        epaUserSelectRes3UserService.updateUserInfo(newPhoneNum,null,null,null,null,null);

    }

    @Override
    public void renewPhoneNum(String midUserId, String newPhoneNum) {

        //暂无接口
    }
    @Override
    public void changePasswordByUsername(String username, String password, String oldPassword, String pswtip) throws Exception {
        EpaUserReso userReso =  epaUserSelectRes3Service.getUserByUsername(username);
        if(userReso==null)
        {
            throw  new Exception("修改密码失败,当前用户名未注册!");
        }
        List<TbsysUserSubjectRel> subjects = tbsysUserSubjectRelRepository.findBySubjectUserId(userReso.getUserId());
        if(subjects==null||subjects.isEmpty())
            throw  new Exception("修改密码失败,映射用户不存在!");

        LandUser landUser = landUserService.queryUserById(subjects.get(0).getUserId());
        if (landUser == null) {
            throw  new Exception("修改密码失败,映射用户不存在!");
        }

        String op=  epaUserSelectRes3Service.getUserpasswordByUserId(userReso.getUserId());
        if(op.startsWith("{")&&op.contains("}"))
        {
            op = op.split("}")[1];
        }
        if (!oldPassword.equals(op)) {
            //将密码转为MD5
            String passwordMD5 = Md5Util.calFileMd5ByByte(oldPassword.getBytes());
            if (!passwordMD5.equals(op) && !passwordMD5.endsWith(op)) {
                BCrypt.Verifyer verifyer = BCrypt.verifyer();
                //返回类型要求是BCrypt的result类型，点进去看源码可以看到result有verified属性判断是否匹配
                BCrypt.Result result = verifyer.verify(oldPassword.toCharArray(), op);
                //第二种是校验BCrypt加密方式
                if (!result.verified) {
                   throw new  Exception("用户原始密码不正确");
                }
            }
        }

        landUser.setPswtip(pswtip);
        landUserService.saveUser(landUser);
        /*
        password = Md5Util.calFileMd5ByByte(password.getBytes());
        String  newPassword="{MD5}"+password;
        */
        epaUserUpdateRes3Service.updatePassword(userReso.getUserId(), password);

        securityService.updateToken(subjects.get(0).getUserId());

    }

    @Override
    public void changePasswordByUsername(String username, String newPassword) throws Exception {
        EpaUserReso userReso =  epaUserSelectRes3Service.getUserByUsername(username);
        if(userReso==null)
        {
            throw  new Exception("修改密码失败,当前用户名未注册!");
        }
        List<TbsysUserSubjectRel> subjects = tbsysUserSubjectRelRepository.findBySubjectUserId(userReso.getUserId());
        if(subjects==null||subjects.isEmpty())
            throw  new Exception("修改密码失败,映射用户不存在!");

        LandUser landUser = landUserService.queryUserById(subjects.get(0).getUserId());
        if (landUser == null) {
            throw  new Exception("修改密码失败,映射用户不存在!");
        }

        epaUserUpdateRes3Service.updatePassword(userReso.getUserId(), newPassword);

        securityService.updateToken(subjects.get(0).getUserId());

    }

    @Override
    public void changePasswordByPhone( String phone, String code, String password, String pswtip) throws Exception {

        EpaUserReso userReso =  epaUserSelectRes3Service.getUserByUserphone(phone);
        if(userReso==null)
        {
            throw  new Exception("修改密码失败,当前手机号未注册!");
        }
        List<TbsysUserSubjectRel> subjects = tbsysUserSubjectRelRepository.findBySubjectUserId(userReso.getUserId());
        if(subjects==null||subjects.isEmpty())
            throw  new Exception("修改密码失败,映射用户不存在!");

        LandUser landUser = landUserService.queryUserById(subjects.get(0).getUserId());
        if (landUser == null) {
            throw  new Exception("修改密码失败,映射用户不存在!");
        }

        List<Vertify> curVerty = vertifyService.findByFilter( phone, code);
        if (curVerty.size() == 0) {
            throw  new Exception("修改密码失败,验证码不正确!");
        }
        landUser.setPswtip(pswtip);
        landUserService.saveUser(landUser);
        //password = Md5Util.calFileMd5ByByte(password.getBytes());
        //String  newPassword="{MD5}"+password;
        epaUserUpdateRes3Service.updatePassword(userReso.getUserId(), password);

        securityService.updateToken(subjects.get(0).getUserId());

    }


    @Override
    public void resetPasswordByAdmin(Long userId,String newPassword) throws Exception {

        List<TbsysUserSubjectRel>  subjectRel = tbsysUserSubjectRelRepository.findByUserId(userId);

        if(subjectRel==null||subjectRel.isEmpty())
        {
            throw new Exception("未找到用户:"+userId+"对应的业务用户");
        }
        String midUserId=subjectRel.get(0).getMidUserId();
        newPassword="{MD5}"+newPassword;
        epaUserUpdateRes3Service.updateEncryptionPassword(midUserId, newPassword);
    }

    @Override
    public void registerByWeb(WebRegUserInfo user) throws Exception {

        if (StringUtils.isBlank(user.getOrgRole())) {
            throw new RuntimeException("角色信息不能为空");
        }

        if (StringUtils.isBlank(user.getRegionCode())) {
            throw new RuntimeException("所在区域不能为空");
        }
        if (StringUtils.isBlank(user.getOrgId())) {
            throw new RuntimeException("所在单位信息不能为空");
        }
        if (StringUtils.isBlank(user.getOrgName())) {
            throw new RuntimeException("所在单位信息不能为空");
        }
        if (StringUtils.isBlank(user.getRealName())) {
            throw new RuntimeException("真实姓名不能为空");
        }

        EpaUserInfoReso epaUserInfoReso = epaUserSelectRes3UserService.getUserInfo();
        LandRegUser newUser = new LandRegUser();
        newUser.setPhone(epaUserInfoReso.getPhoneNumber());
        newUser.setName(epaUserInfoReso.getUserName());
        newUser.setRname(user.getRealName());
        newUser.setSjsf(user.getRegionCode());
        newUser.setRegionCode(user.getRegionCode());
        newUser.setDepName(user.getOrgName());
        newUser.setPostId(user.getOrgName());
        newUser.setDepNo(user.getOrgId());
        newUser.setRoleIds(getRoleIdByOrgRole(user.getOrgRole(),user.getRegionCode()));
        newUser.setState(0);
        newUser.setCreateTime(new Date());
        newUser.setUserId(1L);//默认
        newUser.setPassword("");
        newUser.setAppId(user.getAppId());
        landRegUserRepository.save(newUser);
    }


    @Override
    public void registerByApp(RegUserInfo user) throws Exception {

        // 确认有无手机号重复的
        if (isPhoneRegistered(user.getPhone())) {
            throw new RuntimeException("该手机号已被注册");
        }
        List<LandRegUser> landRegUser = landRegUserDao.queryRegUserByPhone(user.getPhone());
        if(landRegUser!=null&&!landRegUser.isEmpty())
        {
            LandRegUser regUser = landRegUser.get(0);
            if(regUser.getState().equals(0))
            {
                throw new RuntimeException("该手机号已被注册,请联系管理员审核");
            }
            if(regUser.getState().equals(1))
            {
                throw new RuntimeException("该手机号已被注册且通过审核");
            }
        }
        EpaUserReso userReso =  epaUserSelectRes3Service.getUserByUsername(user.getName());
        // 确认用户表中有无重名
        if (userReso!=null) {
            throw new RuntimeException("该用户名已被注册");
        }

        if (StringUtils.isBlank(user.getRoleIds())) {
            throw new RuntimeException("角色信息不能为空");
        }

        if (StringUtils.isBlank(user.getSjsf())) {
            throw new RuntimeException("所在区域不能为空");
        }

        String password="{MD5}"+ Md5Util.calFileMd5ByByte(RSA.decryptByUrlDecoder(user.getPassword(),RSA.getPrivateKey()).getBytes());
        /*
        EpaUserAddReso userAddReso = new EpaUserAddReso();
        userAddReso.setUserName(user.getName());
        userAddReso.setRealName(user.getRname());
        userAddReso.setPhoneNumber(user.getPhone());
        userAddReso.setEncryptionPassword(password);
        epaRegisterUserRes3Service.registerEpaUser(userAddReso);
        */
        /*
        String[]roleIds =user.getRoleIds().split(",");
        String orgRole="";
        for (String role:roleIds) {
            switch (role) {
                case "10022":
                    orgRole = "管理员";
                    break;
                case "10020":
                    orgRole = "联络员";
                    break;
                case "10024":
                    orgRole = "审核员";
                    break;
                case "10025":
                    orgRole = "复核员";
                    break;
                case "10012":
                case "10003":
                case "10018":
                case "10019":
                case "10017":
                    orgRole = "普通用户";
                    break;
                default:
                    orgRole = "普通用户";
                    break;
            }
        }
        UserAddReso addReso = new UserAddReso();
        addReso.setEmail(user.getEmail());
        addReso.setPhoneNumber(user.getPhone());
        addReso.setUserName(user.getName());
        addReso.setOrgId(user.getDepNo());
        addReso.setRegionCode(user.getSjsf());
        addReso.setRealName(user.getRname());
        addReso.setOrgRole(orgRole);
        if (user.getRoleIds().equals("10007")) {
            // 公众用户
            SysConfig publicConfig = sysConfigService.findOne("publicConfig");
            String bizId = "";
            String unitId = "";
            if(publicConfig != null){
                JSONObject jsonObject = JSONObject.parseObject(publicConfig.getValue());
                bizId = jsonObject.getString("zngl");
                unitId = jsonObject.getString("unit");
            }
            addReso.setOrgId(unitId);

        } else {
            // 如果是管理用户，单位不能为空
            // 非公众用户
            // 单位id为空,表明是新建的单位,需传父单位id
            if (StringUtils.isBlank(user.getDepNo())) {

                throw new RuntimeException("用户单位不能为空");
            }
            addReso.setOrgId(user.getDepNo());
        }

        String password="{MD5}"+ Md5Util.calFileMd5ByByte(RSA.decryptByUrlDecoder(user.getPassword(),RSA.getPrivateKey()).getBytes());
        addReso.setEncryptionPassword(password);
        UserReso regUser = busUserRes3SdkService.registerUser(addReso);
        */
        LandRegUser newUser = new LandRegUser();
        BeanUtil.copyProperties(user, newUser);
        newUser.setDepName(user.getDepName());
        if(StringUtils.isNotBlank(user.getSjsf()))
        {
            newUser.setRegionCode(user.getSjsf());
        }
        /*
        if (user.getRoleIds().equals("10007")) {
            // 公众用户
            SysConfig publicConfig = sysConfigService.findOne("publicConfig");
            String bizId = "";
            String unitId = "";
            if(publicConfig != null){
                JSONObject jsonObject = JSONObject.parseObject(publicConfig.getValue());
                bizId = jsonObject.getString("zngl");
                unitId = jsonObject.getString("unit");
            }

            newUser.setDepNo(unitId);

            if(StringUtils.isNotBlank(newUser.getBizRegion())){
                JSONObject js = new JSONObject();
                js.put(bizId,newUser.getBizRegion());

                String code = newUser.getBizRegion().substring(0,6);
                newUser.setSjsf(code);
                newUser.setRegionCode(code);

                JSONObject js1 = new JSONObject();
                js1.put("zngl",bizId);
                newUser.setBusiness(js1.toJSONString());
                newUser.setBizRegion(js.toJSONString());
            }

        } else {
            // 非公众用户，单位不能为空
            if(StringUtils.isBlank(user.getDepNo()))
            {
                throw new RuntimeException("单位信息不能为空");
            }
        }
        */
        if(StringUtils.isBlank(user.getDepNo()))
        {
            throw new RuntimeException("单位信息不能为空");
        }
        newUser.setState(0);
        newUser.setCreateTime(new Date());
        newUser.setUserId(2L);//默认
        newUser.setPassword(password);
        newUser.setName(user.getName());
        newUser.setRname(user.getRname());
        newUser.setPhone(user.getPhone());

        newUser.setSjsf(user.getSjsf());

        newUser.setDepNo(user.getDepNo());
        newUser.setRoleIds(user.getRoleIds());


        landRegUserRepository.save(newUser);
    }


    @Override
    public void deleteUser(Long userId, String reason,AuthUserInfo loginUser) {
        throw new GwValidateException("当前功能暂不可用");
        /*
        if(loginUser.getUserId().equals(userId)&&loginUser.getAdminMgr())
        {
            throw new GwValidateException("管理员或运维人员不可被注销");
        }
        if(!loginUser.getAdminMgr()&&!loginUser.getMgr())
        {
            throw new GwValidateException("当前用户无权限");
        }
        LandUser user =  landUserService.queryUserById(userId);
        if(user==null)
        {
            throw new GwValidateException("用户不存在");
        }
        try {
            SysUserReso mgrUser = mgrUserRes3UserSdkService.findByMidUserId(user.getMidUserId());
            if (mgrUser != null) {
                throw new GwValidateException("管理员或运维人员不可被注销");
            }
        }
        catch (Exception ex)
        {

        }
        roleCloudQueryRelRepository.deleteByUid(userId.toString());
        userCloudAreaRepository.delteByUserId(userId);
        user2BizRepository.deleteByUserId(userId);
        tskRightAreaRepository.deleteByUserId(userId.toString());
        tbtskUserTaskClassRepository.deleteByUserId(userId);
        */
    }

    @Override
    public void changeUserRealName(String userRName,String midUserId)
    {
        EpaRealNameAddReso realNameAddReso = new EpaRealNameAddReso();
        realNameAddReso.setRealName(userRName);
        realNameAddReso.setUserId(midUserId);
        epaUserRealNameRes3Service.updateUserRealName(realNameAddReso);
    }

    @Override
    public String getRoleIdByOrgRole(String orgRole,String regionCode)
    {
        String roleId="";
        if(StringUtils.isBlank(orgRole))
        {
            roleId="10017";
            return roleId;
        }
        switch (orgRole) {
            case "管理员":
                roleId = "10022";
                break;
            case "联络员":
                roleId = "10020";
                break;
            case "审核员":
                roleId = "10024";
                break;
            case "复核员":
                roleId = "10025";
                break;
            case "普通用户":
                int level = getRegionCodeLevel(regionCode);
                switch (level)
                {
                    case 1:
                        roleId="10012";
                        break;
                    case 2:
                        roleId="10003";
                        break;
                    case 3:
                        roleId="10018";
                        break;
                    case 4:
                        roleId="10019";
                        break;
                    case 5:
                        roleId="10017";
                        break;
                }
                break;
            default:
                roleId="10017";
                break;

        }
        return roleId;
    }

    @Override
    public String getOrgRoleByRoleId(String roleIds)
    {
        if(StringUtils.isBlank(roleIds))
        {
            return null;
        }
        String[]roleIdArr =roleIds.split(",");
        String orgRole=roleIds;
        for (String role:roleIdArr) {
            switch (role) {
                case "10022":
                    orgRole = "管理员";
                    break;
                case "10020":
                    orgRole = "联络员";
                    break;
                case "10024":
                    orgRole = "审核员";
                    break;
                case "10025":
                    orgRole = "复核员";
                    break;
                case "10012":
                case "10003":
                case "10018":
                case "10019":
                case "10017":
                    orgRole = "普通用户";
                    break;
                default:
                    orgRole = "普通用户";
                    break;
            }
        }
        return orgRole;
    }

    @Override
    public int getRegionCodeLevel(String regionCode){
        int level=0;
        if(regionCode.length() <= 6 ){
            if(regionCode.endsWith("0000")){
                level =1;
            }else if(regionCode.endsWith("00") ){
                level =2;
            }else{
                level =3;
            }
        }else if(regionCode.length() == 9 ){
            level =4;
        }else if(regionCode.length() == 12 ){
            level =5;
        }
        return level;
    }

    @Override
    public SyncUserInfo addBusUser(ApproveUserInfo approveUserInfo) throws Exception {
        Optional<LandRegUser> landRegUser = landRegUserDao.findById(approveUserInfo.getId());
        if (!landRegUser.isPresent()) {
            throw new Exception("待审核记录:" + approveUserInfo.getId() + "不存在");
        }
        LandRegUser regUser = landRegUser.get();
        LandUser landUser = new LandUser();
        landUser.setName(approveUserInfo.getUserName());
        landUser.setState(0);
        landUser.setIsdel(0);
        landUser = landUserService.saveUser(landUser);


        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(landUser.getId());
        userCloudArea.setCode(approveUserInfo.getCloudArea());
        userCloudArea.setState(1);
        userCloudArea.setCreateTime(new Date());
        userCloudAreaRepository.save(userCloudArea);


        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(landUser.getId().toString());
        roleCloudQueryRel.setCid(approveUserInfo.getCloudRoleId());
        roleCloudQueryRelRepository.save(roleCloudQueryRel);

        EpaUserReso epaUserReso = null;
        if(regUser.getUserId().equals(1l))
        {
            //web端注册 时统一用户不为空
            epaUserReso = epaUserSelectRes3Service.getUserByUsername(regUser.getName());
            if(epaUserReso==null)
            {
                throw new Exception("统一认证用户:" + regUser.getName() + "不存在");
            }
        }
        else {
            //app端注册 时统一用户为空 如果不为空 肯定是在web端又注册了一次 此时还是已app端注册的信息为准
            epaUserReso =  epaUserSelectRes3Service.getUserByUserphone(regUser.getPhone());
        }
        if (epaUserReso == null) {
            EpaUserAddReso userAddReso = new EpaUserAddReso();
            userAddReso.setUserName(regUser.getName());
            userAddReso.setRealName(regUser.getRname());
            userAddReso.setPhoneNumber(regUser.getPhone());
            userAddReso.setEncryptionPassword(regUser.getPassword());
            epaUserReso =  epaRegisterUserRes3Service.registerEpaUser(userAddReso);

        }

        BusUserInfoReso busUser = null;
        try {
            busUser = busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception ex)
        {

        }
        if(busUser==null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(approveUserInfo.getOrgId());
            addReso.setRegionCode(approveUserInfo.getRegionCode());
            addReso.setOrgRole(approveUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = busUserRes3SdkService.registerBusUser(addReso);
            changeUserRealName(approveUserInfo.getRealName(), busUser.getMidUserId());
            if (StringUtils.isNotBlank(regUser.getAppId())) {
                String sql = " select * from bus_apps_config where f_apps_id  ='" + landRegUser.get().getAppId() + "'";
                List<Map<String, Object>> map = jdbcTemplate.queryForList(sql);
                if (map != null && !map.isEmpty()) {
                    String clientId = map.get(0).get("f_app_key").toString();
                    busUserRes3SdkService.addBusUserAc(busUser.getBusUserId(), clientId, null);
                }

            }
        }
        else
        {

            boolean update=false;
            if(StringUtils.isBlank(busUser.getOrgId())||!busUser.getOrgId().equals(approveUserInfo.getOrgId())) {
                update=true;
            }
            if(StringUtils.isBlank(busUser.getRegionCode())||!busUser.getRegionCode().equals(approveUserInfo.getRegionCode())) {
                update=true;
            }
            if(StringUtils.isBlank(busUser.getOrgRole())||!busUser.getOrgRole().equals(approveUserInfo.getOrgRole())) {
                update=true;
            }
            if(update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(approveUserInfo.getOrgId());
                updateReso.setRegionCode(approveUserInfo.getRegionCode());
                updateReso.setOrgRole(approveUserInfo.getOrgRole());
                updateReso.setBusUserId(busUser.getBusUserId());
                busUser = busUserRes3SdkService.updateBusUser(updateReso);
            }
            if(StringUtils.isBlank(busUser.getRealName())||!busUser.getRealName().equals(approveUserInfo.getRealName())) {
                changeUserRealName(approveUserInfo.getRealName(), busUser.getMidUserId());
            }
        }

        landUser.setMidUserId(busUser.getMidUserId());
        landUser.setSubjectUserId(busUser.getBusUserId());
        landUserService.updateUserInfo(landUser);

        SyncUserInfo syncUserInfo = new SyncUserInfo();
        syncUserInfo.setMidUserId(busUser.getMidUserId());
        syncUserInfo.setEpaUserId(busUser.getBusUserId());
        syncUserInfo.setUserId(landUser.getId());
        syncUserInfo.setUserName(busUser.getUserName());
        syncUserInfo.setEnable(1);
        syncUserInfo.setCloudArea(approveUserInfo.getCloudArea());
        syncUserInfo.setCloudRoleId(approveUserInfo.getCloudRoleId());
        syncUserInfo.setPhone(busUser.getPhone());
        syncUserInfo.setOrgId(busUser.getOrgId());
        syncUserInfo.setOrgRole(busUser.getOrgRole());
        syncUserInfo.setRegionCode(busUser.getRegionCode());
        syncUserInfo.setRealName(busUser.getRealName());
        syncUserInfo.setPassWord(epaUserSelectRes3Service.getUserpasswordByUserId(busUser.getMidUserId()));
        return syncUserInfo;
    }

    @Override
    public void syncAddBusUser(SyncUserInfo syncUserInfo) throws Exception {
        EpaUserReso epaUserReso = epaUserSelectRes3Service.getUserByUsername(syncUserInfo.getUserName());
        if (epaUserReso == null) {

            if(StringUtils.isNotBlank(syncUserInfo.getPassWord())) {
                EpaUserAddReso userAddReso = new EpaUserAddReso();
                userAddReso.setUserName(syncUserInfo.getUserName());
                userAddReso.setRealName(syncUserInfo.getRealName());
                userAddReso.setPhoneNumber(syncUserInfo.getPhone());
                userAddReso.setEncryptionPassword(syncUserInfo.getPassWord());
                epaUserReso = epaRegisterUserRes3Service.registerEpaUser(userAddReso);
            }

        }
        LandUser landUser = null;
        List<TbsysUserSubjectRel>sub =tbsysUserSubjectRelRepository.findByMidUserId(epaUserReso.getUserId());
        if(sub==null||sub.isEmpty()) {
            landUser = new LandUser();
            landUser.setName(syncUserInfo.getUserName());
            //landUser.setRname(approveUserInfo.getRealName());
            landUser.setState(0);
            landUser.setIsdel(0);
            //landUser.setMidUserId(epaUserReso.getUserId());
            //landUser.setSubjectUserId(epaUserReso.getUserId());
            landUser = landUserService.saveUser(landUser);
        }
        else
        {
            landUser = new LandUser();
            landUser.setMidUserId(sub.get(0).getMidUserId());
            landUser.setSubjectUserId(sub.get(0).getSubjectUserId());
            landUser.setId(sub.get(0).getUserId());
            landUser.setName(sub.get(0).getUserName());
        }
        userCloudAreaRepository.delteByUserId(landUser.getId());
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(landUser.getId());
        userCloudArea.setCode(syncUserInfo.getCloudArea());
        userCloudArea.setState(1);
        userCloudArea.setCreateTime(new Date());
        userCloudAreaRepository.save(userCloudArea);

        roleCloudQueryRelRepository.deleteByUserId(landUser.getId().toString());
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(landUser.getId().toString());
        roleCloudQueryRel.setCid(syncUserInfo.getCloudRoleId());
        roleCloudQueryRelRepository.save(roleCloudQueryRel);
        /*
        UserRoleInfo userRole = new UserRoleInfo();
        userRole.setId(UUID.randomUUID().toString());
        userRole.setRoleinfoid(getRoleIdByOrgRole(approveUserInfo.getOrgRole(),approveUserInfo.getRegionCode()));
        userRole.setUserid(landUser.getId());
        userRoleInfoDao.save(userRole);
        */
        BusUserInfoReso busUser = null;
        BusUserInfoReso existUser = null;
        try {
            existUser = busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception ex)
        {

        }
        if(existUser==null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(syncUserInfo.getOrgId());
            addReso.setRegionCode(syncUserInfo.getRegionCode());
            addReso.setOrgRole(syncUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = busUserRes3SdkService.registerBusUser(addReso);

            changeUserRealName(syncUserInfo.getRealName(),busUser.getMidUserId());
        }
        else
        {
            boolean update=false;
            if(StringUtils.isBlank(existUser.getOrgId())||!existUser.getOrgId().equals(syncUserInfo.getOrgId())) {
                update=true;
            }
            if(StringUtils.isBlank(existUser.getRegionCode())||!existUser.getRegionCode().equals(syncUserInfo.getRegionCode())) {
                update=true;
            }
            if(StringUtils.isBlank(existUser.getOrgRole())||!existUser.getOrgRole().equals(syncUserInfo.getOrgRole())) {
                update=true;
            }
            if(update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(syncUserInfo.getOrgId());
                updateReso.setRegionCode(syncUserInfo.getRegionCode());
                updateReso.setOrgRole(syncUserInfo.getOrgRole());
                updateReso.setBusUserId(existUser.getBusUserId());
                busUserRes3SdkService.updateBusUser(updateReso);
            }
            if(StringUtils.isBlank(existUser.getRealName())||!existUser.getRealName().equals(syncUserInfo.getRealName())) {
                changeUserRealName(syncUserInfo.getRealName(), busUser.getMidUserId());
            }
        }
        landUser.setMidUserId(busUser.getMidUserId());
        landUser.setSubjectUserId(busUser.getBusUserId());
        landUserService.updateUserInfo(landUser);
    }

    @Override
    public void syncUpdateBusUser(SyncUserInfo syncUserInfo) throws Exception {
        EpaUserReso epaUserReso = epaUserSelectRes3Service.getUserByUserId(syncUserInfo.getUserName());
        if(epaUserReso==null)
        {
            throw new Exception("统一认证用户:"+syncUserInfo.getUserName()+"不存在");
        }
        LandUser landUser = null;
        List<TbsysUserSubjectRel>sub =tbsysUserSubjectRelRepository.findByMidUserId(epaUserReso.getUserId());
        if(sub==null||sub.isEmpty()) {
            landUser = new LandUser();
            landUser.setName(syncUserInfo.getUserName());
            //landUser.setRname(approveUserInfo.getRealName());
            landUser.setState(0);
            landUser.setIsdel(0);
            //landUser.setMidUserId(epaUserReso.getUserId());
            //landUser.setSubjectUserId(epaUserReso.getUserId());
            landUser = landUserService.saveUser(landUser);
        }
        else
        {
            landUser = new LandUser();
            landUser.setMidUserId(sub.get(0).getMidUserId());
            landUser.setSubjectUserId(sub.get(0).getSubjectUserId());
            landUser.setId(sub.get(0).getUserId());
            landUser.setName(sub.get(0).getUserName());
        }
        userCloudAreaRepository.delteByUserId(landUser.getId());
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(landUser.getId());
        userCloudArea.setCode(syncUserInfo.getCloudArea());
        userCloudArea.setState(1);
        userCloudArea.setCreateTime(new Date());
        userCloudAreaRepository.save(userCloudArea);

        roleCloudQueryRelRepository.deleteByUserId(landUser.getId().toString());
        RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
        roleCloudQueryRel.setUid(landUser.getId().toString());
        roleCloudQueryRel.setCid(syncUserInfo.getCloudRoleId());
        roleCloudQueryRelRepository.save(roleCloudQueryRel);
        /*
        UserRoleInfo userRole = new UserRoleInfo();
        userRole.setId(UUID.randomUUID().toString());
        userRole.setRoleinfoid(getRoleIdByOrgRole(approveUserInfo.getOrgRole(),approveUserInfo.getRegionCode()));
        userRole.setUserid(landUser.getId());
        userRoleInfoDao.save(userRole);
        */
        BusUserInfoReso busUser = null;
        BusUserInfoReso existUser = null;
        try {
            existUser = busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception ex)
        {

        }
        if(existUser==null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(syncUserInfo.getOrgId());
            addReso.setRegionCode(syncUserInfo.getRegionCode());
            addReso.setOrgRole(syncUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = busUserRes3SdkService.registerBusUser(addReso);
        }
        else
        {
            boolean update=false;
            if(StringUtils.isBlank(existUser.getOrgId())||!existUser.getOrgId().equals(syncUserInfo.getOrgId())) {
                update=true;
            }
            if(StringUtils.isBlank(existUser.getRegionCode())||!existUser.getRegionCode().equals(syncUserInfo.getRegionCode())) {
                update=true;
            }
            if(StringUtils.isBlank(existUser.getOrgRole())||!existUser.getOrgRole().equals(syncUserInfo.getOrgRole())) {
                update=true;
            }
            if(update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(syncUserInfo.getOrgId());
                updateReso.setRegionCode(syncUserInfo.getRegionCode());
                updateReso.setOrgRole(syncUserInfo.getOrgRole());
                updateReso.setBusUserId(existUser.getBusUserId());
                busUserRes3SdkService.updateBusUser(updateReso);
            }
            if(StringUtils.isBlank(existUser.getRealName())||!existUser.getRealName().equals(syncUserInfo.getRealName())) {
                changeUserRealName(syncUserInfo.getRealName(), busUser.getMidUserId());
            }
        }

    }

    @Override
    public String getUserRegion(Long userId) throws Exception {
       LandUser user =   landUserService.queryUserById(userId);
       if(user==null)
       {
           throw new Exception("用户:"+userId+"不存在");
       }
        BusUserInfoReso busUserInfoReso = getBusUser(user.getSubjectUserId());
       if(busUserInfoReso==null)
       {
           throw new Exception("业务用户:"+userId+"不存在");
       }
       return busUserInfoReso.getRegionCode();
    }

    @Override
    public JSONObject queryOfCommonRegister(AuthUserInfo userInfo, String regionCode,String namePhone,String role,String orgId, int page, int size) throws Exception {
        JSONObject result = new JSONObject();
        List<String>wheres = new ArrayList<>();
        wheres.add("f_state = 0");
        if(StringUtils.isNotBlank(orgId))
        {
            wheres.add("f_depno ='"+orgId+"'");

        }
        else {
            if (userInfo.getAdminMgr() == null || !userInfo.getAdminMgr()) {
                List<String> orgIds = oauthOrganizationService.getAllChildIds(userInfo.getOrgId());
                if (orgIds != null && !orgIds.isEmpty()) {
                    wheres.add("f_depno in('" + StringUtils.join(orgIds, "','") + "')");
                }
            }
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(namePhone)) {

            wheres.add("(f_username like '%"+namePhone+"%' or f_phonework like '%"+namePhone+"%')");
        }
        if(role!=null && !role.equals("")){
            if(role.equals("1")){
                wheres.add("f_roleids like '%10022%'");
            }
            if(role.equals("2")){
                wheres.add("f_roleids like '%10020%'");
            }
            if(role.equals("3")){
                wheres.add("f_roleids not like '%10022%' and f_roleids not like '%10020%'");
            }
        }

        if(regionCode!=null && !regionCode.equals("")){
            if(regionCode.length()==6) {
                if (regionCode.endsWith("0000")) {
                    regionCode = regionCode.substring(0, 2);
                } else if (regionCode.endsWith("00")) {
                    regionCode = regionCode.substring(0, 4);
                }else{
                    regionCode=regionCode;
                }

            }
            wheres.add("f_sjsf like '"+regionCode+"%'");
        }

        String where = org.apache.commons.lang3.StringUtils.join(wheres," and ");
        Map<String,Object>mapCount = jdbcTemplate.queryForMap("select count(*) as f_count from tb_reguser where "+where);
        int totalCount =Integer.parseInt(mapCount.get("f_count").toString());
        if(totalCount>0)
        {
            int offset = (page-1)*size;
            List<Map<String,Object>>maps =  jdbcTemplate.queryForList("select * from tb_reguser where "+where+" order by f_create_date offset "+offset+" limit "+size);
            List<LandRegUser>regUsers = new ArrayList<>();
            SimpleDateFormat dr = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            for(Map m:maps)
            {
                LandRegUser user = new LandRegUser();
                user.setId(m.get("f_id")!=null?m.get("f_id").toString():"");
                user.setName(m.get("f_username")!=null?m.get("f_username").toString():"");
                user.setRname(m.get("f_rname")!=null?m.get("f_rname").toString():"");
                user.setUserId(m.get("f_userid")!=null?Long.parseLong(m.get("f_userid").toString()):null);
                user.setPassword(m.get("f_password")!=null?m.get("f_password").toString():"");
                user.setPhone(m.get("f_phonework")!=null?m.get("f_phonework").toString():"");
                user.setDepNo(m.get("f_depno")!=null?m.get("f_depno").toString():"");
                user.setAppId(m.get("f_appid")!=null?m.get("f_appid").toString():"");
                user.setDepName(m.get("f_depname")!=null?m.get("f_depname").toString():"");
                user.setRegionCode(m.get("f_regergion")!=null?m.get("f_regergion").toString():"");
                user.setRoleIds(m.get("f_roleids")!=null?m.get("f_roleids").toString():"");
                user.setPostId(m.get("f_userposid")!=null?m.get("f_userposid").toString():"");
                user.setPost(m.get("f_post")!=null?m.get("f_post").toString():"");
                user.setSjsf(m.get("f_sjsf")!=null?m.get("f_sjsf").toString():"");
                user.setCreateTime(m.get("f_create_date")!=null?dr.parse(m.get("f_create_date").toString()):null);

                regUsers.add(user);
            }
            RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
            for (LandRegUser reg : regUsers) {
                LandRegUser regUser = new LandRegUser();
                BeanUtils.copyProperties(reg, regUser);
                completeRegUserInfo1(regUser,defaultVersion);
                if(regUser.getRegion()!=null&&regUser.getRegion().getTown()!=null){
                    regUser.getRegion().getTown().setShape(null);
                }
                String phoneVal = regUser.getPhone();
                if(org.apache.commons.lang3.StringUtils.isNotBlank(phoneVal) && phoneVal.length()>=11){
                    regUser.setPhone(phoneVal.substring(0,3)+"****"+phoneVal.substring(7,11));
                }

                if (org.apache.commons.lang3.StringUtils.isNotBlank(reg.getBizRegion())) {
                    JSONObject brJson = JSONObject.parseObject(reg.getBizRegion());
                    JSONObject reJson = new JSONObject();
                    for (String key : brJson.keySet()) {
                        TskTaskBiz biz = tskTaskBizService.getTskTaskBizById(key);
                        if (biz == null) {
                            continue;
                        }
                        String[] arr = brJson.getString(key).split(",");
                        List<String> arrName = new ArrayList<>();
                        if (biz.getGranularity() != null && biz.getGranularity() == 5) {
                            for (String code : arr) {
                                RegionVillage regionVillage = regionService.queryRegionVillageByCode(code);
                                arrName.add(regionVillage.getName());
                            }
                        } else if (biz.getGranularity() != null && biz.getGranularity() == 4) {
                            for (String code : arr) {
                                RegionTown regionTown = regionService.queryRegionTownByCode(code);
                                arrName.add(regionTown.getName());
                            }
                        } else if (biz.getGranularity() != null && biz.getGranularity() == 4) {
                            for (String code : arr) {
                                Region region = regionService.queryRegionByCode(code);
                                arrName.add(region.getName());
                            }
                        }
                        reJson.put(biz.getName(), org.apache.commons.lang3.StringUtils.join(arrName, ","));
                    }
                    regUser.setBizRegionName(reJson.toJSONString());
                }


            }
            result.put("list",regUsers);
        }
        result.put("total", totalCount);


        //Page<LandRegUser> list = this.landRegUserDao.findAll(new QuerySpecification(filterParam), PageRequest.of(page, size, QueryParamUtil.parseSortParams(sortParam)));

        return result;

    }


    @Override
    public SyncUserInfo addUser(AddUserInfo addUserInfo) throws Exception {
        if(addUserInfo==null)
        {
            throw new GwValidateException("新增用户失败,参数不正确");
        }
        if(StringUtils.isBlank(addUserInfo.getUserName()))
        {
            throw new GwValidateException("新增用户失败,未设置用户名");
        }
        else
        {
           EpaUserReso userReso =  getMidtUserByUserName(addUserInfo.getUserName());
           if(userReso!=null)
           {
               throw new GwValidateException("新增用户失败,用户名已存在");
           }
        }
        if(StringUtils.isBlank(addUserInfo.getUserRealName()))
        {
            throw new GwValidateException("新增用户失败,未设置真实姓名");
        }
        if(StringUtils.isBlank(addUserInfo.getPhoneNumber()))
        {
            throw new GwValidateException("新增用户失败,未设置手机号");
        }
        else
        {
            if(isPhoneRegistered(addUserInfo.getPhoneNumber()))
            {
                throw new GwValidateException("新增用户失败,当前手机号已注册");
            }
        }
        if(StringUtils.isBlank(addUserInfo.getPassWord()))
        {
            throw new GwValidateException("新增用户失败,未设置密码");
        }
        /*
        if(StringUtils.isBlank(addUserInfo.getPassWord2()))
        {
            throw new GwValidateException("新增用户失败,请再次输入密码");
        }
        if(!addUserInfo.getPassWord().equals(addUserInfo.getPassWord2()))
        {
            throw new GwValidateException("新增用户失败,两次输入密码不一致");
        }
        */
        String reg = "^(?![0-9]+$)(?![a-zA-Z]+$)[a-zA-Z0-9]{6,16}$";
        if(!addUserInfo.getPassWord().matches(reg))
        {
            throw new GwValidateException("新增用户失败,密码要求数字和字母组合,长度6-16位");
        }

        if(StringUtils.isBlank(addUserInfo.getOrgId()))
        {
            throw new GwValidateException("新增用户失败,未设置所属单位");
        }
        OrganizationReso organizationReso =  organizationSelectRes3Service.searchOrganizationById(addUserInfo.getOrgId());
        if(organizationReso==null)
        {
            throw new GwValidateException("新增用户失败,用户所属单位不存在");
        }
        if(StringUtils.isBlank(addUserInfo.getOrgRole()))
        {
            throw new GwValidateException("新增用户失败,未设置组织角色");
        }
        if(StringUtils.isBlank(addUserInfo.getRegionCode()))
        {
            throw new GwValidateException("新增用户失败,未设置用户政区");
        }
        if(StringUtils.isBlank(addUserInfo.getCloudRoleId()))
        {
            throw new GwValidateException("新增用户失败,未设置云查询角色");
        }
        if(StringUtils.isBlank(addUserInfo.getCloudArea()))
        {
            throw new GwValidateException("新增用户失败,未设置云查询区域");
        }

        String password="{MD5}"+ Md5Util.calFileMd5ByByte(addUserInfo.getPassWord().getBytes());

        EpaUserAddReso userAddReso = new EpaUserAddReso();
        userAddReso.setUserName(addUserInfo.getUserName());
        userAddReso.setRealName(addUserInfo.getUserRealName());
        userAddReso.setPhoneNumber(addUserInfo.getPhoneNumber());
        userAddReso.setEncryptionPassword(password);
        userAddReso.setEmail(addUserInfo.getEmail());
        EpaUserReso epaUserReso =  epaRegisterUserRes3Service.registerEpaUser(userAddReso);



        BusUserInfoReso busUser = null;
        try {
            busUser = busUserRes3SdkService.getUserInfo(null, epaUserReso.getUserId(), null, null);
        }
        catch (Exception ex)
        {

        }
        if(busUser==null) {
            BusUserAddReso addReso = new BusUserAddReso();
            addReso.setOrgId(addUserInfo.getOrgId());
            addReso.setRegionCode(addUserInfo.getRegionCode());
            addReso.setOrgRole(addUserInfo.getOrgRole());
            addReso.setMidUserId(epaUserReso.getUserId());
            busUser = busUserRes3SdkService.registerBusUser(addReso);
            changeUserRealName(addUserInfo.getUserRealName(), busUser.getMidUserId());
        }
        else
        {

            boolean update=false;
            if(StringUtils.isBlank(busUser.getOrgId())||!busUser.getOrgId().equals(addUserInfo.getOrgId())) {
                update=true;
            }
            if(StringUtils.isBlank(busUser.getRegionCode())||!busUser.getRegionCode().equals(addUserInfo.getRegionCode())) {
                update=true;
            }
            if(StringUtils.isBlank(busUser.getOrgRole())||!busUser.getOrgRole().equals(addUserInfo.getOrgRole())) {
                update=true;
            }
            if(update) {
                BusUserUpdateReso updateReso = new BusUserUpdateReso();
                updateReso.setOrgId(addUserInfo.getOrgId());
                updateReso.setRegionCode(addUserInfo.getRegionCode());
                updateReso.setOrgRole(addUserInfo.getOrgRole());
                updateReso.setBusUserId(busUser.getBusUserId());
                busUser = busUserRes3SdkService.updateBusUser(updateReso);
            }
            if(StringUtils.isBlank(busUser.getRealName())||!busUser.getRealName().equals(addUserInfo.getUserRealName())) {
                changeUserRealName(addUserInfo.getUserRealName(), busUser.getMidUserId());
            }
        }

        LandUser landUser = new LandUser();
        landUser.setName(epaUserReso.getUserName());
        landUser.setRname(addUserInfo.getUserRealName());
        landUser.setState(0);
        landUser.setIsdel(0);
        landUser.setMidUserId(busUser.getMidUserId());
        landUser.setSubjectUserId(busUser.getBusUserId());
        landUser = landUserService.saveUser(landUser);

        try {
            userCloudAreaRepository.delteByUserId(landUser.getId());
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setUserId(landUser.getId());
            userCloudArea.setCode(addUserInfo.getCloudArea());
            userCloudArea.setState(1);
            userCloudArea.setCreateTime(new Date());
            userCloudAreaRepository.save(userCloudArea);

            roleCloudQueryRelRepository.deleteByUserId(landUser.getId().toString());
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setUid(landUser.getId().toString());
            roleCloudQueryRel.setCid(addUserInfo.getCloudRoleId());
            roleCloudQueryRelRepository.save(roleCloudQueryRel);

            if (addUserInfo.getUserTaskPermissionDto() != null) {
                addUserInfo.getUserTaskPermissionDto().setUserId(landUser.getId());
                tskTaskBizService.setUserTaskPermission(addUserInfo.getUserTaskPermissionDto());
            }
        }
        catch (Exception ex)
        {
            logger.error("新增用户设置业务信息失败");
        }
        SyncUserInfo syncUserInfo = new SyncUserInfo();
        syncUserInfo.setMidUserId(busUser.getMidUserId());
        syncUserInfo.setEpaUserId(busUser.getBusUserId());
        syncUserInfo.setUserId(landUser.getId());
        syncUserInfo.setUserName(busUser.getUserName());
        syncUserInfo.setEnable(1);
        syncUserInfo.setCloudArea(addUserInfo.getCloudArea());
        syncUserInfo.setCloudRoleId(addUserInfo.getCloudRoleId());
        syncUserInfo.setPhone(busUser.getPhone());
        syncUserInfo.setOrgId(busUser.getOrgId());
        syncUserInfo.setOrgRole(busUser.getOrgRole());
        syncUserInfo.setRegionCode(busUser.getRegionCode());
        syncUserInfo.setRealName(busUser.getRealName());
        syncUserInfo.setPassWord(password);
        return syncUserInfo;

    }

    @Override
    public boolean canViewAppZttj(String orgId) {
        try {
            SysConfig config = sysConfigService.findOne("appZttjViewOrg");
            if(config==null||StringUtils.isBlank(config.getValue()))
                return true;
            JSONArray jsonArray = JSONArray.parseArray(config.getValue());
            if(jsonArray==null||jsonArray.isEmpty())
                return true;
            List<String>childViews = new ArrayList<>();
            for(int i=0;i<jsonArray.size();i++)
            {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String org = jsonObject.getString("orgId");
                if(org.equals(orgId))
                {
                    return true;
                }
                Boolean childView = jsonObject.getBoolean("childView");
                if(childView)
                {
                    childViews.add(org);
                }
            }
             if(!childViews.isEmpty())
             {
                 for(String org:childViews) {
                     List<String> childs =  oauthOrganizationService.getAllChildIds(org);
                     if(childs!=null&&childs.contains(orgId))
                     {
                         return true;
                     }
                 }
             }

        }
        catch (Exception ex)
        {
            return true;
        }
        return false;
    }

    @Override
    public LandUser addUser(String usreName,String regionCode,String midUserId,String busUserId){
        LandUser landUser = new LandUser();
        landUser.setMidUserId(midUserId);
        landUser.setSubjectUserId(busUserId);
        landUser.setName(usreName);
        landUser.setIsdel(0);
        landUser.setState(1);
        landUser = landUserService.saveUser(landUser);
        if (GutilStr.isNotBlank(regionCode)) {
            Map<String,Object> map = regionCodeLevel(regionCode);
            String cloudRole = map.get("cloudRole").toString();

            //新增云查询区域
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setCode(regionCode);
            userCloudArea.setUserId(landUser.getId());
            userCloudArea.setCreateTime(new Date());
            userCloudArea.setState(1);
            userCloudAreaDao.save(userCloudArea);
            //新增云查询角色
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setCid(cloudRole);
            roleCloudQueryRel.setUid(landUser.getId().toString());
            roleCloudQueryRelRepository.save(roleCloudQueryRel);
        }
        return landUser;
    }
    @Override
    public  Boolean sendSms(String phone) {
        try {
            String registrationId = "gas-" + AuthorizationGrantType.CLIENT_CREDENTIALS.getValue() + "-" + "gasClient";
            ClientCredentialsClientRegistration cccr = (ClientCredentialsClientRegistration) Oauth2ClientRegistration.findById(registrationId);
            if (cccr == null) {
                logger.error("sendsms:发送登录验证码 获取client失败，初始化一个");
                GacOauth2Tool.getGasClient();
                cccr = new ClientCredentialsClientRegistration(registrationId, "gasClient");
            }
            logger.error("sendsms:clientName:" + cccr.getClientName());
            logger.error("sendsms:clientId:" + cccr.getClient().getClientId());
            logger.error("sendsms:clientName:" + cccr.getClient().getClientName());
            logger.error("sendsms:clientSecret:" + cccr.getClient().getClientSecret());
            logger.error("sendsms:priovider:" + cccr.getClient().getProvider());
            Oauth2Provider provider = Oauth2Provider.get(cccr.getClient().getProvider());
            logger.error("sendsms:getTokenEndpointURI:" + provider.getTokenEndpointURI().toString());
            logger.error("sendsms:getAuthorizationEndpointURI:" + provider.getAuthorizationEndpointURI().toString());
            URI url = provider.getIssuerEndpointURIWithPath("/res3client/captcha");
            logger.error("sendsms:getIssuerEndpointURIWithPath:" + url.toString());


            String type = "sms";
            String phoneNumber = phone;
            String userId = null;
            String userName = null;

            HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
            httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
            Map<String, List<String>> params = new HashMap();
            if (org.springframework.util.StringUtils.hasText(type)) {
                params.put("type", Collections.singletonList(type));
                if (org.springframework.util.StringUtils.hasText(userId)) {
                    params.put("userId", Collections.singletonList(userId));
                }

                if (org.springframework.util.StringUtils.hasText(userName)) {
                    params.put("userName", Collections.singletonList(userName));
                }

                if (org.springframework.util.StringUtils.hasText(phoneNumber)) {
                    params.put("phoneNumber", Collections.singletonList(phoneNumber));
                }

                String paramStr = URLUtils.serializeParameters(params);
                httpRequest.setQuery(paramStr);
                logger.error("sendsms:param:"+paramStr);
                String principalName = cccr.getClientName();
                OAuth2AuthorizedClientService oAuth2AuthorizedClientService = Oauth2Provider.get(cccr.getClient().getProvider()).getAuthorizedClientService();
                OAuth2AuthorizedClient client = oAuth2AuthorizedClientService.loadAuthorizedClient(registrationId, principalName);
                if (client == null) {
                    try {
                        logger.error("sendsms:client redis null");
                        OAuth2AccessToken accessToken = authentication(cccr,provider);
                        logger.error("sendsms:client token "+accessToken.getTokenValue());
                        client = new OAuth2AuthorizedClient(OAuth2AuthorizedClient.OAuth2AuthorizedPrincipalId.of(registrationId, principalName), accessToken, (OAuth2RefreshToken)null);
                        oAuth2AuthorizedClientService.saveAuthorizedClient(client);
                    } catch (Exception var6) {
                        logger.error("sendsms:client redis null,init error"+ExceptionUtil.getErrorString(var6));
                    }
                }

                httpRequest.setAuthorization("Bearer " + client.getAccessToken().getTokenValue());
                logger.error("sendsms:token:" +"Bearer " + client.getAccessToken().getTokenValue());
                HTTPResponse response = httpRequest.send();
                String res;
                if (response.getStatusCode() == 200) {
                    logger.error("sendsms:200:"+response.getContent());
                    res = response.getContent();
                    return Boolean.valueOf(res.trim());
                } else {
                    res = response.getContent();
                    logger.error("sendsms:error:"+response.getContent());
                    return false;
                }
            } else {
                logger.error("sendsms:type is need");
                return false;
            }
        }
        catch (Exception ex)
        {
            logger.error("sendsms:ex:"+ ExceptionUtil.getErrorString(ex));
            return false;
        }

    }
    private OAuth2AccessToken authentication(ClientCredentialsClientRegistration cccr,Oauth2Provider provider) throws Exception {
        ClientSecretBasic clientSecretBasicAuthentication = new ClientSecretBasic(new ClientID(cccr.getClient().getClientId()), new Secret(cccr.getClient().getClientSecret()));
        TokenRequest request = new TokenRequest(provider.getTokenEndpointURI(), clientSecretBasicAuthentication, new ClientCredentialsGrant(), Scope.parse(cccr.getScope()));
        HTTPResponse httpResponse = request.toHTTPRequest().send();
        TokenResponse response = TokenResponse.parse(httpResponse);
        if (!response.indicatesSuccess()) {
            TokenErrorResponse errorResponse = response.toErrorResponse();
            if (errorResponse != null && errorResponse.getErrorObject() != null) {
                throw new RuntimeException("1ClientCredentialsGrant模式返回错误结果:" + errorResponse.toJSONObject().toJSONString());
            } else {
                throw new RuntimeException("2ClientCredentialsGrant模式返回错误结果:" + errorResponse.toJSONObject().toJSONString());
            }
        } else {
            AccessTokenResponse successResponse = response.toSuccessResponse();
            Tokens tokens = successResponse.getTokens();
            AccessToken accessToken = tokens.getAccessToken();
            OAuth2AccessToken oAuth2AccessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, accessToken.getValue(), Instant.now(), Instant.now().plusSeconds(accessToken.getLifetime()));
            return oAuth2AccessToken;
        }
    }
    private void setUserInfo(Long userId, String orgId, String regionCode, String orgRole, SyncUserInfo syncUserInfo) throws Exception {
        List<TbsysUserSubjectRel>  subjectRel = tbsysUserSubjectRelRepository.findByUserId(userId);

        if(subjectRel==null||subjectRel.isEmpty())
        {
            throw new Exception("未找到用户:"+userId+"对应的业务用户");
        }
        String busUserId=subjectRel.get(0).getSubjectUserId();
        BusUserUpdateReso userUpdateReso = new BusUserUpdateReso();
        userUpdateReso.setBusUserId(busUserId);
        userUpdateReso.setOrgId(orgId);
        userUpdateReso.setOrgRole(orgRole);
        userUpdateReso.setRegionCode(regionCode);
        busUserRes3SdkService.updateBusUser(userUpdateReso);
        syncUserInfo.setUserId(userId);
        syncUserInfo.setMidUserId(subjectRel.get(0).getMidUserId());
        syncUserInfo.setEpaUserId(subjectRel.get(0).getSubjectUserId());
        syncUserInfo.setOrgRole(orgRole);
        syncUserInfo.setOrgId(orgId);
        syncUserInfo.setRegionCode(regionCode);
    }

    private boolean isMyFriend(Long ownerId, Long userId) throws Exception {
        List<LandUser> friends = friendsService.getMyFriends(ownerId);
        if (friends.isEmpty()) {
            return false;
        }
        for (LandUser myFriend : friends) {
            if (myFriend.getId().equals(userId)) {
                return true;
            }
        }
        return false;
    }

    private void addUser(Long userId,String regionCode){
        if (GutilStr.isNotBlank(regionCode)) {
            Map<String,Object> map = regionCodeLevel(regionCode);
            //int level = Integer.valueOf(map.get("level").toString());
            String cloudRole = map.get("cloudRole").toString();
            //String userrole = map.get("userrole").toString();
            /*
            //新增用户区域
            LandUser2Area landUser2Area = new LandUser2Area();
            landUser2Area.setUserId(userId);
            landUser2Area.setCreateTime(new Date());
            landUser2Area.setState(1);
            landUser2Area.setRegionCode(regionCode);
            landUser2AreaDao.save(landUser2Area);
            //新增用户角色

            UserRoleInfo userRole = new UserRoleInfo();
            userRole.setId(UUID.randomUUID().toString());
            userRole.setRoleinfoid(userrole);
            userRole.setUserid(userId);
            userRoleInfoDao.save(userRole);
            */
            //新增云查询区域
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setCode(regionCode);
            userCloudArea.setUserId(userId);
            userCloudArea.setCreateTime(new Date());
            userCloudArea.setState(1);
            userCloudAreaDao.save(userCloudArea);
            //新增云查询角色
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setCid(cloudRole);
            roleCloudQueryRel.setUid(userId.toString());
            roleCloudQueryRelRepository.save(roleCloudQueryRel);
        }
    }

    private void addUser(Long userId,String regionCode,String roleIds){
        if (GutilStr.isNotBlank(regionCode)) {
            Map<String,Object> map = regionCodeLevel(regionCode);
            //int level = Integer.valueOf(map.get("level").toString());
            String cloudRole = map.get("cloudRole").toString();
            String userrole =roleIds;

            /*
            //新增用户区域
            LandUser2Area landUser2Area = new LandUser2Area();
            landUser2Area.setUserId(userId);
            landUser2Area.setCreateTime(new Date());
            landUser2Area.setState(1);
            landUser2Area.setRegionCode(regionCode);
            landUser2AreaDao.save(landUser2Area);
            //新增用户角色

            if(StringUtils.isNotBlank(userrole)) {
                String [] roles = userrole.split(",");
                for(int i=0;i<roles.length;i++) {
                    UserRoleInfo userRole = new UserRoleInfo();
                    userRole.setId(UUID.randomUUID().toString());
                    userRole.setRoleinfoid(roles[i]);
                    userRole.setUserid(userId);
                    this.userRoleInfoDao.save(userRole);
                }
            }
            */
            //新增云查询区域
            UserCloudArea userCloudArea = new UserCloudArea();
            userCloudArea.setCode(regionCode);
            userCloudArea.setUserId(userId);
            userCloudArea.setCreateTime(new Date());
            userCloudArea.setState(1);
            userCloudAreaDao.save(userCloudArea);
            //新增云查询角色
            RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
            roleCloudQueryRel.setCid(cloudRole);
            roleCloudQueryRel.setUid(userId.toString());
            roleCloudQueryRelRepository.save(roleCloudQueryRel);
        }
    }
    public Map<String,Object> regionCodeLevel(String regionCode){
        Map<String,Object> result = new HashMap<>();
        result.put("level",1);
        result.put("cloudRole",1001);
        result.put("userrole",10003);
        if(regionCode.length() <= 6 ){
            if(regionCode.endsWith("0000")){
                result.put("level",1);
                result.put("cloudRole","1001");
                result.put("userrole","10003");
            }else if(regionCode.endsWith("00") ){
                result.put("level",2);
                result.put("cloudRole","1005");
                result.put("userrole","10018");
            }else{
                result.put("level",3);
                result.put("cloudRole","1006");
                result.put("userrole","10019");
            }
        }else if(regionCode.length() == 9 ){
            result.put("level",4);
            result.put("cloudRole","1006");
            result.put("userrole","10019");
        }else if(regionCode.length() == 12 ){
            result.put("level",5);
            result.put("cloudRole","1006");
            result.put("userrole","10019");
        }
        return result;
    }

    private void completeRegUserInfo1(LandRegUser regUser,RegionVersion defaultVersion) throws Exception {
        String roleIds = regUser.getRoleIds();
        // 区域完整信息
        MyRegion myRegion = new MyRegion();
        int level = 3;
        String lsSf = "";
        if (GutilStr.isNotBlank(regUser.getSjsf())) {
            lsSf = regUser.getSjsf();
            if (lsSf.equals("000000")) {
                lsSf = "1";
            }

            myRegion = getMyRegionByCode(lsSf,defaultVersion);
            if (lsSf != null && lsSf.length() == 6) {
                Region region = regionDao.findByCodeAndVersion(lsSf, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                level = region.getLevel();
            } else if (lsSf != null && lsSf.length() == 9) {
                RegionTown regionTown = regionTownDao.getByCodeAndVersion(lsSf, defaultVersion != null ? defaultVersion.getVersion() : "2018");
                level = regionTown.getLevel();
            } else if (lsSf != null && lsSf.length() == 12) {
                //RegionVillage regionVillage = regionVillageRepository.getByCodeAndVersion(lsSf,defaultVersion!=null?defaultVersion.getVersion():"2018");
                level = 5;
            }

        }
        regUser.setRegion(myRegion);
        regUser.setRegionCode(lsSf);
        regUser.setLevel(level);

    }

    public MyRegion getMyRegionByCode(String xzqdm,RegionVersion defaultVersion) throws Exception {

        if ("1".equals(xzqdm)) {
            MyRegion myRegion = new MyRegion("全国");
            myRegion.setCountry("1");
            return myRegion;
        }
        MyRegion myRegion = new MyRegion();

        //查询行政区代码信息
        Region region = null;
        RegionTown regionTown = null;
        RegionVillage regionVillage = null;
        if (xzqdm.length() == 6) {
            region = regionDao.findByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        } else if (xzqdm.length() == 9) {
            regionTown = regionTownDao.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        } else if (xzqdm.length() == 12) {
            regionVillage = regionVillageRepository.getByCodeAndVersion(xzqdm, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        }
        if (region == null && regionTown == null && regionVillage == null) {
            return new MyRegion();
        }
        int level = 0;
        if (region != null) {
            level = region.getLevel();
        } else if (regionTown != null) {
            level = regionTown.getLevel();
        } else if (regionVillage != null) {
            level = 5;
        }
        switch (level) {
            case 1:
                // 省级
                myRegion.setProvince(region);
                myRegion.setFullName(region.getName());
                break;
            case 2:
                // 市级
                myRegion.setCity(region);
                Region pRegion = regionDao.findByCodeAndVersion(region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(pRegion);
                myRegion.setFullName(pRegion.getName() + region.getName());
                break;
            case 3:
                // 区级
                myRegion.setCounty(region);
                Region p1Region = regionDao.findByCodeAndVersion(region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCity(p1Region);
                Region p2Region = regionDao.findByCodeAndVersion(p1Region.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(p2Region);
                myRegion.setFullName(p2Region.getName() + p1Region.getName() + region.getName());
                break;
            case 4:
                //乡级
                myRegion.setTown(regionTown);
                Region parentRegion1 = regionDao.findByCodeAndVersion(regionTown.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCounty(parentRegion1);
                Region parentRegion2 = regionDao.findByCodeAndVersion(parentRegion1.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCity(parentRegion2);
                Region parentRegion3 = regionDao.findByCodeAndVersion(parentRegion2.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(parentRegion3);
                myRegion.setFullName(parentRegion3.getName() + parentRegion2.getName() + parentRegion1.getName() + regionTown.getName());
                break;
            case 5:
                //村级
                myRegion.setVillage(regionVillage);
                RegionTown regionTown1 = regionTownDao.getByCodeAndVersion(regionVillage.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setTown(regionTown1);
                Region parentRegion5 = regionDao.findByCodeAndVersion(regionTown1.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCounty(parentRegion5);
                Region parentRegion6 = regionDao.findByCodeAndVersion(parentRegion5.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setCity(parentRegion6);
                Region parentRegion7 = regionDao.findByCodeAndVersion(parentRegion6.getPcode(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
                myRegion.setProvince(parentRegion7);
                myRegion.setFullName(parentRegion7.getName() + parentRegion6.getName() + parentRegion5.getName() + regionTown1.getName() + regionVillage.getName());
            default:
                break;
        }

        return myRegion;
    }

}
