package com.geoway.landteam.landcloud.service.other.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import io.jsonwebtoken.lang.Assert;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * Created by licong on 2022/5/12.
 */
@Service
public class ImportOtherDataServiceImpl implements ImportOtherDataService {
    private final GiLoger logger = GwLoger.getLoger(this.getClass());
    //private final String host = "http://scgxpt.tianmu.cloud:811";
    //private final String getMediaUrl = "/api/cggl/GetAchievementInPolygon";

    private final String host = "https://jzgx.cqlandcloud.org.cn:806";
    private final String getMediaUrl = "/api/cggl/GetAchievementInPolygon";
    private final String ak = "jwgxpt";
    private final String sk = "grsCKkZsGcPD";
    private final Long days = Long.valueOf(360);
    private static final String MEDIA_SOURCE_PREFIX = "JA_IMPORT_";
    private static final String IMPORT_JAMEDIA_CACHE = "IMPORT_JAMEDIA_CACHE";

    private static final String JA_TOKEN = "JA_IMPORT_TOKEN";
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    private AppMediaRepository appMediaRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public String getMediaSourcePrefix() {
        return MEDIA_SOURCE_PREFIX;
    }

    @Override
    public void saveJAMediaData(String taskId) throws Exception {
//        String data = "{\"WKT\":\"POLYGON((102.466605173794 29.6265917642155,102.466626982802 29.6265948200895,102.466741079785 29.6266323706402,102.46671368557 29.626734864837,102.466740797936 29.6267490908499,102.466840726371 29.6265987302911,102.466924534648 29.6265353336404,102.466906734471 29.6264905538334,102.466874112766 29.6265108864113,102.466800087286 29.6264538603996,102.466750686774 29.6264372761522,102.466543616089 29.6264428174664,102.466534557422 29.626584666866,102.466605173794 29.6265917642155))\",\"BufferDistance\":40,\"StartDate\":\"2021-01-01\",\"EndDate\":\"2022-06-01\",\"QueryCountLimit\":100}";
//        JSONObject json = JSONObject.parseObject(data);
//        HttpPost post = new HttpPost(this.host + this.getMediaUrl);
//        StringEntity entity = new StringEntity(data,"UTF-8");//解决中文乱码问题
//        entity.setContentEncoding("UTF-8");
//        entity.setContentType("application/json;charset=utf-8");
//        post.setEntity(entity);
//
//        post.setHeader("Authorization", "bearer 6TRtO11i85bE96RJeUYnRE304CtDun4M_YTaBIvqQLSFIzWHeOXkxv4uAzgNglpEPCNAHDEQb1P6hozZSG_NjIUDqDG6f0pTbZPSQuSUGKmgAVZLh3GfmlJx074KLHe0vQwgJJfdkXXDFp1-X5FRIGHfJ8UkouQMhmuWBPc3sYX7YJnkaitJZ-jYUkf7aKAO-JIxZiU0TS0GZXDKF3L1Qi5aV0h7e2L-LuHILSzPStFcXOb2KbaqKTsx5j8a4XZfeTWcCP3WaJmesaoM66yMVHPoc091t3X2l_UcbGttevhbZ7tpiFM8QCrep_W7RzbU");//设置通用请求头
//        post.addHeader("Content-Type", "application/json");
//
//        HttpClient httpClient = buildHttpClient(false);
//        HttpResponse response1 = httpClient.execute(post);
//        String result = EntityUtils.toString(response1.getEntity());
//        System.err.println(result);

        Boolean tag = redisTemplate.opsForHash().hasKey(JobConstants.JOB_REDIS_IMPORTDATA, taskId);
        if (tag){
            throw new Exception("数据处理中，请勿重复请求");
        }
        redisTemplate.opsForHash().put(JobConstants.JOB_REDIS_IMPORTDATA, taskId, new Date());
        Thread thread = new Thread(()->{
            try {
                TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
                String tablename = table.getfTablename();
                List<Map<String, Object>> dataList = this.getData(tablename);
                dataList.forEach(data -> {
                    String f_id = (String) data.get("f_id");
                    String wkt = (String) data.get("wkt");
                    Boolean flag = this.hasMedia(f_id);
                    if (!flag) {
                        try {
                            JSONObject medias = this.getMediaByJA(wkt);
                            String code = medias.getString("Code");
                            if (!"200".equals(code)) {
                                throw new Exception(code + medias.getString("Error") + medias.getString("Message"));
                            }
                            JSONArray array = medias.getJSONArray("Data");
                            if (array.size() > 0) {
                                this.logger.error("图斑id" + f_id);
                                for (int i = 0; i < array.size(); i++) {
                                    this.saveMedia(f_id, array.getJSONObject(i));
                                }
                            }
                        } catch (Exception e) {
                            this.logger.error(e);
                        }
                    }
                });
            } catch (Exception e) {
                this.logger.error(e);
            } finally {
                redisTemplate.opsForHash().delete(JobConstants.JOB_REDIS_IMPORTDATA, taskId);
            }
        });
        this.threadPoolTaskExecutor.execute(thread);
    }

    @Override
    public JSONArray getTbMediaData(String taskId, String tbid, String tableId) throws Exception {
        JSONArray result = null;
        TbtskObjectinfo table = null;
        if(StringUtils.isNotBlank(tableId)){
            table = tskTaskBizService.getTableByTableId(tableId);
        }else{
             table = tskTaskBizService.findTableByTaskId(taskId);
        }
        String tablename = table.getfTablename();
        List<Map<String, Object>> dataList = this.getData(tablename,tbid);
        Assert.notEmpty(dataList,"未查到图斑信息");
        Map<String, Object> data = dataList.get(0);
        String wkt = (String) data.get("wkt");
        List<AppMedia> attachedMedias = appMediaRepository.queryByGalleryidAndBizid(tbid,taskId);
        try {
            JSONObject medias = this.getMediaByJA(wkt);
            String code = medias.getString("Code");
            if (!"200".equals(code)) {
                throw new Exception(code + medias.getString("Error") + medias.getString("Message"));
            }
            Map<String,Object> cache = new HashMap<>();
            JSONArray temp = medias.getJSONArray("Data");
            Assert.notNull(temp,"未查到结果");
            temp.forEach(item->{
                JSONObject json = (JSONObject)item;
                //创建缓存索引值
                String bsm = json.getString("BSM");
                //逐条将请求结果暂时放在redis中，挂接时不用重新请求
                redisTemplate.opsForHash().putIfAbsent(IMPORT_JAMEDIA_CACHE, bsm, json);
                //增加是否已挂接字段
                json.put("isAttached",isAttached(attachedMedias,bsm));
            });
            redisTemplate.expire(IMPORT_JAMEDIA_CACHE,1L, TimeUnit.HOURS);
            result = temp;
        } catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
        }
        return result;
    }

    @Override
    public JSONObject attachMedia(String taskId, String tbid, String medias) {
        String[] mediaArray = medias.split(",");
        JSONObject result = new JSONObject();
        for(String mediaId : mediaArray){
            Boolean tag = redisTemplate.opsForHash().hasKey(IMPORT_JAMEDIA_CACHE, mediaId);
            if(!tag){//缓存过期
                result.put(mediaId,"挂载失败刷新后重试");
                continue;
            }
            try {
                JSONObject cache= (JSONObject)redisTemplate.opsForHash().get(IMPORT_JAMEDIA_CACHE, mediaId);
                boolean suc =saveMedia(taskId,tbid,cache);
                result.put(mediaId,"挂载成功");
                result.put("suc",suc);
            }catch (Exception e){
                result.put(mediaId,"挂载失败");
            }
        }
        return  result;
    }

    @Override
    public List<String>getTempUrl(List<String>url) throws IOException {
        JSONObject json = new JSONObject();
        json.put("urls",url);
        json.put("resize",0);
        JSONArray arr = new JSONArray();
        arr.add(json);
        String sevice = "https://jg.landcloud.org.cn:8553/temporarysignature/api/FileUrl/Convert";
        HttpPost post = new HttpPost(sevice);
        StringEntity entity = new StringEntity(arr.toString(), "UTF-8");//解决中文乱码问题
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json;charset=utf-8");
        post.setEntity(entity);
        //post.setHeader("Authorization", "bearer " + token);//设置通用请求头
        post.addHeader("Content-Type", "application/json");
        HttpClient httpClient = buildHttpClient(false);
        HttpResponse response1 = httpClient.execute(post);
        String result = EntityUtils.toString(response1.getEntity());
        if(StringUtils.isBlank(result))
            return null;
        JSONObject resultObj = JSONObject.parseObject(result);
        if(resultObj.containsKey("code")&&"200".equals(resultObj.getString("code")))
        {
            JSONArray data = resultObj.getJSONArray("data");
            if(data==null)
            {
                return null;
            }
            List<String>newUrls = new ArrayList<>();
            for(int i=0;i<data.size();i++)
            {
                String aa =  data.getString(i);
                newUrls.add(aa);

            }
            return newUrls;
        }
        return null;
    }

    private List<Map<String, Object>> getData(String tablename) {
        String sql = "select f_id,st_astext(f_shape) as wkt from " + tablename;
        return this.jdbcTemplate.queryForList(sql);

    }
    private List<Map<String, Object>> getData(String tablename,String tbid) {
        String sql = "select f_id,st_astext(f_shape) as wkt from " + tablename + " where f_id = '" + tbid + "'";
        return this.jdbcTemplate.queryForList(sql);

    }
    private Boolean hasMedia(String f_id){
        String sql = "select f_id from tb_app_media where f_galleryid = '" + f_id + "'";
        List list = this.jdbcTemplate.queryForList(sql);
        if (list.isEmpty())
            return false;
        else
            return true;
    }
    private void saveMedia(String f_id, JSONObject obj) throws ParseException {
        //如果要启用 挂接照片成功之后 请更新图斑的updatetime 字段
        //return saveMedia(null,f_id,obj);
    }
    private boolean saveMedia(String taskid,String fid, JSONObject obj) throws ParseException {
        String url = obj.getString("BigImgUrl");
        if(StringUtils.isBlank(url)){//没照片的跳过
            return false;
        }
        //单图斑挂接且已挂接的不重复处理,乐观锁
        //TODO 改成悲观锁
        if(StringUtils.isNotBlank(taskid) && isAttached(taskid,fid,url)){
            return false;
        }
        if(url.contains("?"))
        {
            url = StringUtils.split(url,"?")[0];
        }
        AppMedia media = new AppMedia();
        media.setId(UUID.randomUUID().toString());
        media.setBizId(taskid);
        media.setGalleryid(fid);
        media.setType(1);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String pssjStr = obj.getString("PSSJ").trim().replace('/','-').substring(0,18);
        media.setTime(String.valueOf(format.parse(obj.getString("PSSJ")).getTime()));
        media.setLon(obj.getDouble("Longitude"));
        media.setLat(obj.getDouble("Latitude"));
        media.setAzimuth(obj.getString("PSJD"));
        media.setServerpath(url);
        media.setUsername(obj.getString("PSRY"));
        //标记用以便今后统计
        media.setFromSource(MEDIA_SOURCE_PREFIX + obj.getString("BSM"));
        this.appMediaRepository.save(media);
        this.logger.error("照片" + obj.getString("BigImgUrl"));
        return true;

    }
    private JSONObject getMediaByJA(String wkt) throws IOException {
        Boolean hasToken = redisTemplate.hasKey(JA_TOKEN);
        String token = "";
        if(hasToken){
            token = (String) redisTemplate.opsForValue().get(JA_TOKEN);
        }else {
            try{
                token = getAuthorization();
                if(StringUtils.isNotBlank(token)){
                    redisTemplate.opsForValue().set(JA_TOKEN,token);
                    redisTemplate.expire(JA_TOKEN,1L,TimeUnit.HOURS);
                }
            }catch (Exception e){
                throw new RuntimeException("token获取失败");
            }
        }

        Long time = System.currentTimeMillis();
        Long starttime = time - this.days * 1000 * 60 * 60 * 24;

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String StartDate = format.format(starttime);
        String EndDate = format.format(time);

        JSONObject obj = new JSONObject();
        obj.put("BufferDistance", 20);
        obj.put("QueryCountLimit", 100);
        obj.put("StartDate", StartDate);
        obj.put("EndDate", EndDate);
        obj.put("WKT",wkt);
//        obj.put("WKT","POLYGON((107.35639168341127 29.747474867209956,107.36744238455448 29.746860075498642,107.36613346655655 29.741969552623598,107.35671354849303 29.74211860065438,107.35639168341127 29.747474867209956))");

        HttpPost post = new HttpPost(this.host + this.getMediaUrl);
        StringEntity entity = new StringEntity(obj.toString(), "UTF-8");//解决中文乱码问题
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json;charset=utf-8");
        post.setEntity(entity);
        post.setHeader("Authorization", "bearer " + token);//设置通用请求头
        post.addHeader("Content-Type", "application/json");
        HttpClient httpClient = buildHttpClient(false);
        HttpResponse response1 = httpClient.execute(post);
        String result = EntityUtils.toString(response1.getEntity());
        JSONObject resultObj = JSONObject.parseObject(result);
        return resultObj;
    }
    private JSONObject getMediaByJA_bk(String wkt) throws IOException {
        Long time = System.currentTimeMillis();
        Long starttime = time - this.days * 1000 * 60 * 60 * 24;

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String StartDate = format.format(starttime);
        String EndDate = format.format(time);

        JSONObject obj = new JSONObject();
        obj.put("BufferDistance", 20);
        obj.put("QueryCountLimit", 100);
        obj.put("StartDate", StartDate);
        obj.put("EndDate", EndDate);
        obj.put("WKT",wkt);
//        obj.put("WKT","POLYGON((107.35639168341127 29.747474867209956,107.36744238455448 29.746860075498642,107.36613346655655 29.741969552623598,107.35671354849303 29.74211860065438,107.35639168341127 29.747474867209956))");

        HttpPost post = new HttpPost(this.host + this.getMediaUrl);
        StringEntity entity = new StringEntity(obj.toString(), "UTF-8");//解决中文乱码问题
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json;charset=utf-8");
        post.setEntity(entity);

        post.setHeader("Authorization", "bearer 6TRtO11i85bE96RJeUYnRE304CtDun4M_YTaBIvqQLSFIzWHeOXkxv4uAzgNglpEPCNAHDEQb1P6hozZSG_NjIUDqDG6f0pTbZPSQuSUGKmgAVZLh3GfmlJx074KLHe0vQwgJJfdkXXDFp1-X5FRIGHfJ8UkouQMhmuWBPc3sYX7YJnkaitJZ-jYUkf7aKAO-JIxZiU0TS0GZXDKF3L1Qi5aV0h7e2L-LuHILSzPStFcXOb2KbaqKTsx5j8a4XZfeTWcCP3WaJmesaoM66yMVHPoc091t3X2l_UcbGttevhbZ7tpiFM8QCrep_W7RzbU");//设置通用请求头
        post.addHeader("Content-Type", "application/json");
        HttpClient httpClient = buildHttpClient(false);
        HttpResponse response1 = httpClient.execute(post);
        String result = EntityUtils.toString(response1.getEntity());
        JSONObject resultObj = JSONObject.parseObject(result);
        return resultObj;
    }
    private String getAuthorization() throws Exception {
        OkHttpClient client = new OkHttpClient();

        MediaType mediaType = MediaType.parse("application/x-www-form-urlencoded");
        FormBody body = new FormBody.Builder()
                .add("grant_type","password")
                .add("username",ak)
                .add("password",sk)
                .build();
        Request request = new Request.Builder()
                .url(this.host + "/token")
                .post(body)
                .addHeader("Content-Type", "application/x-www-form-urlencoded")
                .addHeader("cache-control", "no-cache")
                .build();

        String result = "";
        try (Response response = client.newCall(request).execute()){
            if (response.code() == 200) {
                String resp = response.body().string();
                JSONObject jsonObject = JSONObject.parseObject(resp);
                result = jsonObject.getString("access_token");
            }
        }catch (Exception e){
            throw new Exception("今奥登录失败");
        }
        return result;
    }

    private CloseableHttpClient buildHttpClient(boolean isMultiThread) {
        CloseableHttpClient client;
        if (isMultiThread)
            client = HttpClientBuilder.create().setConnectionManager(new PoolingHttpClientConnectionManager()).build();
        else
            client = HttpClientBuilder.create().build();
        // 设置代理服务器地址和端口
        // client.getHostConfiguration().setProxy("proxy_host_addr",proxy_port);
        return client;
    }

    /**
     * 检测已挂接，乐观锁，存在重复风险
     * @param taskid
     * @param tbid
     * @param bsm
     * @return
     */
    private Boolean isAttached(String taskid, String tbid,String bsm){
        List<AppMedia> list = appMediaRepository.queryByTaskIdGidAndFromSource(tbid,taskid,MEDIA_SOURCE_PREFIX + bsm);
        return list != null && !list.isEmpty();
    }

    private Boolean isAttached(List<AppMedia> medias , String bsm){
        if (medias == null) return false;
        String source = MEDIA_SOURCE_PREFIX + bsm;
        List<AppMedia> result = medias.stream().filter( item -> source.equals(item.getFromSource())).collect(Collectors.toList());
        return !result.isEmpty();
    }
}
