package com.geoway.landteam.landcloud.service.patrolclue.caselibrary.impl;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.servface.patrolclue.caselibrary.MCaseService;
import com.geoway.landteam.patrolclue.mapper.caselibrary.*;
import com.geoway.landteam.patrolclue.model.caselibrary.dto.*;
import com.geoway.landteam.patrolclue.model.caselibrary.entity.*;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.caselibrary.service.impl
 * @date 2022/3/15 15:29
 */
@Service
@Transactional
public class MCaseServiceImpl implements MCaseService {

    @Autowired
    DataBizService dataBizService;
    @Autowired
    JcCaseInfoMapper jcCaseInfoMapper;
    @Autowired
    JcCaseLianMapper jcCaseLianMapper;
    @Autowired
    JcCaseApproveMapper jcCaseApproveMapper;
    @Autowired
    JcCaseInvestigationMapper jcCaseInvestigationMapper;
    @Autowired
    JcCaseLandinfoMapper jcCaseLandinfoMapper;
    @Autowired
    JcCaseClosedMapper jcCaseClosedMapper;
    @Autowired
    JcCaseTrialMapper jcCaseTrialMapper;
    @Autowired
    JcCasePunishmentMapper jcCasePunishmentMapper;
    @Autowired
    JcCaseXzcfaMapper jcCaseXzcfaMapper;
    @Autowired
    JcCaseWfInfoMapper jcCaseWfInfoMapper;
    @Autowired
    JcCaseNonlianMapper jcCaseNonlianMapper;

    @Autowired
    private LandUserService landuserService;
    @Resource
    private JdbcTemplate jdbcTemplate;

    @Override
    public int deleteByPrimaryKey(String id) {
        return jcCaseInfoMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(JcCaseInfo record) {
        return jcCaseInfoMapper.insert(record);
    }

    @Override
    public int insertSelective(JcCaseInfo record) {
        return jcCaseInfoMapper.insertSelective(record);
    }

    @Override
    public JcCaseInfo selectByPrimaryKey(String fId) {
        return jcCaseInfoMapper.selectByPrimaryKey(fId);
    }

    @Override
    public int updateByPrimaryKeySelective(JcCaseInfo record) {
        return jcCaseInfoMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(JcCaseInfo record) {
        return jcCaseInfoMapper.updateByPrimaryKey(record);
    }

    @Override
    public Map getCaseList(Long userId,String type,String status,String xsbh, String regionCode, String wflx, String caseStage, String dczt, int
            pageIndex, int pageSize) {
        Map<String,Object> result = new HashMap<>();
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length()<= 6 && regionCode.endsWith("00")){
                regionCode = regionCode.replace("00","");
            }
        }
        pageIndex = (pageIndex -1) * pageSize;
         if(StringUtils.isNotBlank(caseStage) && "2".equals(caseStage)){
             if(StringUtils.isNotBlank(dczt)){
                 status = "2";
             }
             List<JcCaseInfo> list =  jcCaseInfoMapper.getCaseListByDc(type,status ,xsbh,  regionCode,  wflx,  caseStage,dczt,pageIndex, pageSize);
             result.put("list",list);
             int caseListCount = jcCaseInfoMapper.getCaseListCountByDc(type,status ,xsbh, regionCode, wflx, caseStage,dczt);
             result.put("count",caseListCount);
             return result;
         }
        List<JcCaseInfo> list =  jcCaseInfoMapper.getCaseList(type,status ,xsbh,  regionCode,  wflx,  caseStage,
                pageIndex, pageSize);
        result.put("list",list);
        int caseListCount = jcCaseInfoMapper.getCaseListCount(type,status ,xsbh, regionCode, wflx, caseStage);
        result.put("count",caseListCount);
        return result;
    }

    @Override
    public JcCaseLian lianSubmission(Long userId, Integer operate, String caseId, String lianTime, String lianjg,
                                     String dflrlawh, String syslawh) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM
        JcCaseLian jcCaseLian = jcCaseInfoMapper.selectByCaseId(caseId);
        Boolean isExist = true;
        if(jcCaseLian == null){
             jcCaseLian = new JcCaseLian();
            jcCaseLian.setfId(UUID.randomUUID().toString());
            isExist = false;
         }
            jcCaseLian.setfCaseid(caseId);
            jcCaseLian.setfCreatetime(new Date());
            jcCaseLian.setfUserid(userId.intValue());
            jcCaseLian.setfDflrlawh(dflrlawh);
            jcCaseLian.setfLiantime( simpleDateFormat.parse(lianTime));
            jcCaseLian.setfSyslawh(syslawh);
            jcCaseLian.setfLajg(lianjg);
        if(!isExist){
            jcCaseLianMapper.insertSelective(jcCaseLian);
        }else{
            jcCaseLianMapper.updateByPrimaryKeySelective(jcCaseLian);
        }
           //立案提交则将进到审核阶段
           if(operate == 1){
               JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(caseId);
               jcCaseInfo.setfStatus(2);
               jcCaseInfo.setfReviewstage(1);
               jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
           }
           return jcCaseLian;
    }

    @Override
    public void lianSubmissionNew(Long userId, JcCaseLianDto jcCaseLianDto) throws Exception {
        JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(jcCaseLianDto.getfCaseid());
        if(jcCaseInfo == null){
            throw  new GwValidateException("案件不存在,请检查案件id");
        }
        JcCaseLian jcCaseLian = jcCaseInfoMapper.selectByCaseId(jcCaseLianDto.getfCaseid());
        if(jcCaseLian == null){
            JcCaseLian bean   = new JcCaseLian();
            BeanUtil.copyProperties(jcCaseLianDto,bean,false);
            bean.setfId(UUID.randomUUID().toString());
            bean.setfCreatetime(new Date());
            bean.setfUserid(userId.intValue());
            if(StringUtils.isNotBlank(jcCaseInfo.getfXzqdmsys())){
                bean.setfSyslawh(getCasewhSeq(jcCaseInfo.getfXzqdmsys().substring(0,6)));
            }
            jcCaseLianMapper.insertSelective(bean);
        }else{
            BeanUtil.copyProperties(jcCaseLianDto,jcCaseLian,false);
            jcCaseLian.setfCreatetime(new Date());
            jcCaseLian.setfUserid(userId.intValue());
            jcCaseLianMapper.updateByPrimaryKeySelective(jcCaseLian);
        }
        //立案提交则将进到审核阶段
        if(jcCaseLianDto.getOperate().equals("1")){
            jcCaseInfo.setfStatus(2);
            jcCaseInfo.setfReviewstage(1);
            jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
        }
    }

    @Override
    public JcCaseLian findLianSubmissionData(Long userId, String caseId) {
        return jcCaseLianMapper.selectByCaseId(caseId);
    }

    @Override
    public JcCaseApprove caseApprove(Long userId, String caseId, Integer status, String remark, Integer caseStage, Integer reviewStage) {
           JcCaseApprove approve = new JcCaseApprove();
                approve.setfId(UUID.randomUUID().toString());
                approve.setfStatus(status.shortValue());
                approve.setfRemark(remark);
                approve.setfReviewstage(reviewStage);
                approve.setfCasestage(caseStage);
                approve.setfUserid(userId.intValue());
                approve.setfCreatetime(new Date());
                approve.setfApprovetime(new Date());
                approve.setfCaseid(caseId);
                approve.setfApprovename(landuserService.queryUserById(userId).getName());
                //保存审核记录
               jcCaseApproveMapper.insertSelective(approve);
        //处理审核流程
        JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(caseId);
        switch (caseStage){
            //立案审核
            case 1:
                  if(reviewStage == 1 && status == 1 ){ //审核通过
                      jcCaseInfo.setfReviewstage(2);
                  }else if(reviewStage == 1 && status == 2){ //审核不通过
                      jcCaseInfo.setfReviewstage(0);
                      jcCaseInfo.setfStatus(1);
                  }else if(reviewStage == 2 && status == 1){ //复核通过
                      jcCaseInfo.setfReviewstage(0);
                      jcCaseInfo.setfStatus(1);
                      jcCaseInfo.setfCasestage(2);
                  }else if(reviewStage == 2 && status == 2){ //复核不通过
                      jcCaseInfo.setfReviewstage(0);
                      jcCaseInfo.setfStatus(1);
                  }
                break;
                  //调查取证
            case 2:
                if(reviewStage == 1 && status == 1 ){ //审核通过
                    jcCaseInfo.setfReviewstage(2);
                }else if(reviewStage == 1 && status == 2){ //审核不通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                }else if(reviewStage == 2 &&  status == 1){ //复核通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                    jcCaseInfo.setfCasestage(3);
                    //“调查终止”审核完成直接流转“结案”阶段；
                    JcCaseInvestigation jcCaseInvestigation = jcCaseInvestigationMapper.selectByCaseId(caseId);
                    if(jcCaseInvestigation.getfDczt() == 2){
                        jcCaseInfo.setfCasestage(4);
                    }
                }else if(reviewStage == 2 && status == 2){ //复核不通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                }
                break;
                //案件审理
            case 3:
                if(reviewStage == 1 && status == 1 ){ //审核通过
                    jcCaseInfo.setfReviewstage(2);
                }else if(reviewStage == 1 && status == 2){ //审核不通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                }else if(reviewStage == 2 &&  status == 1){ //复核通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                    jcCaseInfo.setfCasestage(4);
                }else if(reviewStage == 2 && status == 2){ //复核不通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                }
                break;
                //结案
            case 4:
                if(reviewStage == 1 && status == 1 ){ //审核通过
                    jcCaseInfo.setfReviewstage(2);
                }else if(reviewStage == 1 && status == 2){ //审核不通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                }else if(reviewStage == 2 &&  status == 1){ //复核通过
                    jcCaseInfo.setfReviewstage(3);
                    jcCaseInfo.setfStatus(3);
                    //根据线索来源id和线索id更新线索阶段
                    Map mapdata = dataBizService.selectFieldByID("jc_clue_source", Arrays.asList("f_id","f_tablename"),"f_id", "'"+jcCaseInfo.getfSourceid()+"'");
                    if(mapdata != null){
                        String tablename = MapUtils.getString(mapdata, "f_tablename");
                        dataBizService.excuteSql("update "+tablename +" set f_stage ='4' where f_id ='"+jcCaseInfo.getfClueid() +"'");
                    }
                }else if(reviewStage == 2 && status == 2){ //复核不通过
                    jcCaseInfo.setfReviewstage(0);
                    jcCaseInfo.setfStatus(1);
                }
                break;
            default:
                break;
        }
        jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
        return approve;
    }

    @Override
    public List<JcCaseApprove> findCaseApproveRecords(Long userId, String caseId, Integer caseStage) {
        return  jcCaseApproveMapper.findCaseApproveRecords( caseId,  caseStage);
    }

    @Override
    public List<JcCaseApprove> findCaseApproveLatestRecords(Long userId, String caseId, Integer caseStage) {
        List<JcCaseApprove> approves = new ArrayList<>();
            //审核
            approves.addAll(jcCaseApproveMapper.findCaseApproveLatestRecords( caseId,  caseStage,1));
            //复核
            approves.addAll(jcCaseApproveMapper.findCaseApproveLatestRecords( caseId,  caseStage,2));
        return  approves;
    }

    @Override
    public void investigationSubmit(Long userId, JcCaseInvestigationDto jcCaseInvestigationDto) throws Exception {
        JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(jcCaseInvestigationDto.getfCaseid());
        if(jcCaseInfo == null ){
            throw new RuntimeException("案件不存在");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM
        JcCaseInvestigation jcCaseInvestigation = jcCaseInvestigationMapper.selectByCaseId(jcCaseInvestigationDto.getfCaseid());
        //保存调查数据
        String dcid = UUID.randomUUID().toString();
        if(jcCaseInvestigation == null){
            JcCaseInvestigation   bean =  new JcCaseInvestigation();
            BeanUtil.copyProperties(jcCaseInvestigationDto,bean,false);
            bean.setfId(dcid);
            jcCaseInvestigationMapper.insertSelective(bean);
            //非“调查终止/调查中止”填报完成直接流转“案件审理”
            if(bean.getfDczt() != 1 &&  bean.getfDczt() != 2 ){
                jcCaseInfo.setfReviewstage(0);
                jcCaseInfo.setfStatus(1);
                jcCaseInfo.setfCasestage(3);
            }else{
                jcCaseInfo.setfStatus(2);
                jcCaseInfo.setfReviewstage(1);
            }
        }else{
            BeanUtil.copyProperties(jcCaseInvestigationDto,jcCaseInvestigation,false);
            jcCaseInvestigationMapper.updateByPrimaryKeySelective(jcCaseInvestigation);
            //删除暂存的用地数据
            jcCaseLandinfoMapper.deleteByCaseId(jcCaseInvestigationDto.getfCaseid());
            //非“调查终止/调查中止”填报完成直接流转“案件审理”
            if(jcCaseInvestigation.getfDczt() != 1 &&  jcCaseInvestigation.getfDczt() != 2 ){
                jcCaseInfo.setfReviewstage(0);
                jcCaseInfo.setfStatus(1);
                jcCaseInfo.setfCasestage(3);
            }else{
                jcCaseInfo.setfStatus(2);
                jcCaseInfo.setfReviewstage(1);
            }
        }

      //保存用地情况数据
        if(jcCaseInvestigationDto.getLandinfo() != null && !jcCaseInvestigationDto.getLandinfo().isEmpty()){
            List<JcCaseLandinfo> jcCaseLandinfos = jcCaseInvestigationDto.getLandinfo().toJavaList(JcCaseLandinfo .class);
            for(JcCaseLandinfo bean : jcCaseLandinfos){
                bean.setfId(UUID.randomUUID().toString());
                bean.setfCaseid(jcCaseInvestigationDto.getfCaseid());
                jcCaseLandinfoMapper.insertSelective(bean);
            }
        }
        //调查提交则将进到审核阶段
        if(jcCaseInvestigationDto.getOperate().equals("1")){
            jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
        }
    }

    @Override
    public JcCaseInvestigation getInvestigationInfo(Long userId, String caseId) throws Exception {
        JcCaseInvestigation jcCaseInvestigation = jcCaseInvestigationMapper.selectByCaseId(caseId);
        if(jcCaseInvestigation != null){
            List<JcCaseLandinfo> jcCaseLandinfos = jcCaseLandinfoMapper.selectByCaseId(caseId);
            jcCaseInvestigation.setLandInfo(jcCaseLandinfos);
        }
        return  jcCaseInvestigation;
    }

    @Override
    public void caseTrialSubmit(Long userId, JcCaseTrialDto jcCaseTrialDto) throws Exception {
        JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(jcCaseTrialDto.getfCaseid());
        if(jcCaseInfo == null){
            throw  new GwValidateException("案件不存在,请检查案件id");
        }
        JcCaseTrial jcCaseTrial = jcCaseTrialMapper.selectByCaseId(jcCaseTrialDto.getfCaseid());
        //保存调查数据
        String dcid = UUID.randomUUID().toString();
        if(jcCaseTrial == null){
            JcCaseTrial   bean =  new JcCaseTrial();
            BeanUtil.copyProperties(jcCaseTrialDto,bean,false);
            bean.setfId(dcid);
            bean.setfUserid(userId.intValue());
            bean.setfCreatetime(new Date());
            jcCaseTrialMapper.insertSelective(bean);
        }else{
            BeanUtil.copyProperties(jcCaseTrialDto,jcCaseTrial,false);
            jcCaseTrial.setfUserid(userId.intValue());
            jcCaseTrial.setfCreatetime(new Date());
            jcCaseTrialMapper.updateByPrimaryKeySelective(jcCaseTrial);
            //删除暂存的处分数据
            jcCasePunishmentMapper.deleteByCaseId(jcCaseTrialDto.getfCaseid());
            //删除暂存的处分数据
            jcCaseXzcfaMapper.deleteByCaseId(jcCaseTrialDto.getfCaseid());
        }

        //保存处分数据
        if(jcCaseTrialDto.getCaseXzcfen() != null && !jcCaseTrialDto.getCaseXzcfen().isEmpty()){
            List<JcCasePunishment> jcCasePunishments = jcCaseTrialDto.getCaseXzcfen().toJavaList(JcCasePunishment.class);
            for(JcCasePunishment bean : jcCasePunishments){
                bean.setfId(UUID.randomUUID().toString());
                bean.setfCaseid(jcCaseTrialDto.getfCaseid());
                bean.setfUserid(userId.intValue());
                bean.setfCreatetime(new Date());
                jcCasePunishmentMapper.insertSelective(bean);
            }
        }
        //保存处罚数据
        if(jcCaseTrialDto.getCaseXzcfa() != null && !jcCaseTrialDto.getCaseXzcfa().isEmpty()){
            List<JcCaseXzcfa> jcCaseXzcfas = jcCaseTrialDto.getCaseXzcfa().toJavaList(JcCaseXzcfa.class);
            for(JcCaseXzcfa bean : jcCaseXzcfas){
                bean.setfId(UUID.randomUUID().toString());
                bean.setfCaseid(jcCaseTrialDto.getfCaseid());
                bean.setfUserid(userId.intValue());
                bean.setfCreatetime(new Date());
                jcCaseXzcfaMapper.insertSelective(bean);
            }
        }
        //调查提交则将进到审核阶段
        if(jcCaseTrialDto.getOperate().equals("1")){
            jcCaseInfo.setfStatus(2);
            jcCaseInfo.setfReviewstage(1);
            jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
        }
    }

    @Override
    public JcCaseTrial getTrialInfo(Long userId, String caseId) {
        JcCaseTrial jcCaseTrial = jcCaseTrialMapper.selectByCaseId(caseId);
        if(jcCaseTrial != null){
            List<JcCaseXzcfa> jcCaseXzcfas = jcCaseXzcfaMapper.selectByCaseId(caseId);
            jcCaseTrial.setCaseXzcfa(jcCaseXzcfas);
            List<JcCasePunishment> jcCasePunishments = jcCasePunishmentMapper.selectByCaseId(caseId);
            jcCaseTrial.setCaseXzcfen(jcCasePunishments);
        }
        return jcCaseTrial;
    }


    @Override
    public void closeSubmit(Long userId, JcCaseClosedDto jcCaseClosedDto) throws Exception {
        JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(jcCaseClosedDto.getfCaseid());
        if(jcCaseInfo == null){
            throw  new GwValidateException("案件不存在,请检查案件id");
        }
        JcCaseClosed jcCaseClosed = jcCaseClosedMapper.selectByCaseId(jcCaseClosedDto.getfCaseid());
        if(jcCaseClosed == null ){
            JcCaseClosed bean = new JcCaseClosed();
            BeanUtil.copyProperties(jcCaseClosedDto,bean,false);
            bean.setfId( UUID.randomUUID().toString());
            bean.setfUserid(userId.intValue());
            bean.setfCreatetime(new Date());
            jcCaseClosedMapper.insertSelective(bean);
        }else{
            BeanUtil.copyProperties(jcCaseClosedDto,jcCaseClosed,false);
            jcCaseClosed.setfUserid(userId.intValue());
            jcCaseClosed.setfCreatetime(new Date());
            jcCaseClosedMapper.updateByPrimaryKeySelective(jcCaseClosed);
        }
        //调查提交则将进到审核阶段
        if(jcCaseClosedDto.getOperate().equals("1")){
            jcCaseInfo.setfStatus(2);
            jcCaseInfo.setfReviewstage(1);
            jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
        }
    }

    @Override
    public JcCaseClosed getCloseSubmitInfo(Long userId, String caseId) {
        return jcCaseClosedMapper.selectByCaseId(caseId);
    }

    @Override
    public  Map<String,Object> getCaseStageCount(Long userId,String regionCode, Integer caseStage) {
        Map<String,Object> resultMap = new HashMap<>();
        switch (caseStage){
            //立案审核
            case 1:
            //案件审理
            case 3:
            //结案
            case 4:
                        resultMap.put("type",caseStage);//类型
                        resultMap.put("dclCount",0);    //待处理数据
                        resultMap.put("dshCount",0);    //待审核数据
                        resultMap.put("overCount",0);    //审核完结数据
                      String sql = "select f_status status ,count(1) count from jc_case_info where f_type ='1' and " +
                              "f_casestage ='"+caseStage+"' and f_xzqdmsys like '"+regionCode+"%' group by f_status ";
                      List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                      if(maps.size() > 0){
                          for(Map<String, Object> map : maps){
                              if("1".equals(map.get("status").toString())){
                                  resultMap.put("dclCount",map.get("count").toString());
                              }else if("2".equals(map.get("status").toString())){
                                  resultMap.put("dshCount",map.get("count").toString());
                              }else if("3".equals(map.get("status").toString())){
                                  resultMap.put("overCount",map.get("count").toString());
                              }
                          }
                      }
                resultMap.put("allCount",Integer.valueOf(resultMap.get("dclCount").toString()) + Integer.valueOf
                        (resultMap.get("dshCount").toString()) + Integer.valueOf(resultMap.get("overCount").toString())  );
                break;
            //调查取证
            case 2:
                resultMap.put("type",caseStage);//类型
                resultMap.put("dclCount",0);    //待处理数据
                resultMap.put("dczzCount",0);    //调查中止
                resultMap.put("dcendCount",0);    //调查终止
                resultMap.put("ssrdCount",0);    //事实认定
                String sql2 = "select info.f_status status,invest.f_dczt dczt,count(1) count from jc_case_info info " +
                        "LEFT JOIN jc_case_investigation invest on(info.f_id = invest.f_caseid) where f_type ='1' and f_casestage ='2' and info.f_xzqdmsys like '"+regionCode+"%' group by info.f_status,invest.f_dczt";
                List<Map<String, Object>> maps2 = jdbcTemplate.queryForList(sql2);
                if(maps2.size() > 0){
                    for(Map<String, Object> map : maps2){
                        if("1".equals(map.get("status").toString())){
                            resultMap.put("dclCount",Integer.valueOf(resultMap.get("dclCount").toString()) + Integer.valueOf(map.get("count").toString()));
                        }else if("2".equals(map.get("status").toString())){
                            if(map.get("dczt") != null){
                                if("1".equals(map.get("dczt").toString())){
                                    resultMap.put("dczzCount",Integer.valueOf(resultMap.get("dczzCount").toString()) + Integer.valueOf(map.get("count").toString()));
                                }else if("2".equals(map.get("dczt").toString())){
                                    resultMap.put("dcendCount",Integer.valueOf(resultMap.get("dcendCount").toString()) + Integer.valueOf(map.get("count").toString()));
                                }else if("3".equals(map.get("dczt").toString())){
                                    resultMap.put("ssrdCount",Integer.valueOf(resultMap.get("ssrdCount").toString()) + Integer.valueOf(map.get("count").toString()));
                                }
                            }
                        }
                    }
                }
                resultMap.put("allCount",Integer.valueOf(resultMap.get("dclCount").toString())
                        + Integer.valueOf(resultMap.get("dczzCount").toString())
                        + Integer.valueOf(resultMap.get("dcendCount").toString())
                        + Integer.valueOf(resultMap.get("ssrdCount").toString())
                       );
                break;
            default:
                break;
        }
    return resultMap;

    }

   public void syncCaseInfo(Long userId,String fid,String fFcczjy){
       JcWfInfo jcWfInfo = jcCaseWfInfoMapper.selectByPrimaryKey(fid);
       if(jcWfInfo != null){
           JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByWfId(fid);
           Boolean isExist = true;
           if(jcCaseInfo == null){
               isExist = false;
               jcCaseInfo = new JcCaseInfo();
               jcCaseInfo.setfId(UUID.randomUUID().toString());
               jcCaseInfo.setfCreatetime(new Date());
           }
           jcCaseInfo.setfInspectid(jcWfInfo.getfId());
           jcCaseInfo.setfClueid(jcWfInfo.getfClueid());
           jcCaseInfo.setfSourceid(jcWfInfo.getfSourceid());
           jcCaseInfo.setfXsly(jcWfInfo.getfXsly());
           jcCaseInfo.setfType(Integer.valueOf(fFcczjy));
           jcCaseInfo.setfUserid(userId.intValue());
           jcCaseInfo.setfXsbh(jcWfInfo.getfXsbh());
           jcCaseInfo.setfWflx(jcWfInfo.getfWflx());
           jcCaseInfo.setfWfdd(jcWfInfo.getfWtfsd());
           jcCaseInfo.setfWfzrzt(jcWfInfo.getfBjbrxm());
           jcCaseInfo.setfXzqdmsys(jcWfInfo.getfXzqdm());
           if(fFcczjy.equals("1")){
               jcCaseInfo.setfType(1);
               jcCaseInfo.setfCasestage(1);
               jcCaseInfo.setfReviewstage(0);
               jcCaseInfo.setfStatus(1);
           }else{
               jcCaseInfo.setfType(2);
               jcCaseInfo.setfStatus(1);
           }
           if(isExist){
               jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
           }else{
               jcCaseInfoMapper.insertSelective(jcCaseInfo);
           }
           //根据线索来源id和线索id更新线索阶段
           Map mapdata = dataBizService.selectFieldByID("jc_clue_source", Arrays.asList("f_id","f_tablename"),"f_id", "'"+jcWfInfo.getfSourceid()+"'");
            if(mapdata != null){
                String tablename = MapUtils.getString(mapdata, "f_tablename");
                if(StringUtils.isNotBlank(jcWfInfo.getfHcjg()) && jcWfInfo.getfHcjg().equals("0")){ //不违法
                    dataBizService.excuteSql("update "+tablename +" set f_stage ='4' where f_id ='"+jcWfInfo.getfClueid() +"'");
                }else if(StringUtils.isNotBlank(jcWfInfo.getfHcjg()) && jcWfInfo.getfHcjg().equals("1")){ //违法
                    dataBizService.excuteSql("update "+tablename +" set f_stage ='3' where f_id ='"+jcWfInfo.getfClueid() +"'");
                }
            }
       }
   }

    @Override
    public void nonLianSubmit(Long userId, JcCaseNonlianDto jcCaseNonlianDto) throws Exception {
        JcCaseInfo jcCaseInfo = jcCaseInfoMapper.selectByPrimaryKey(jcCaseNonlianDto.getfCaseid());
        if(jcCaseInfo == null ){
            throw new RuntimeException("案件不存在");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM
        JcCaseNonlian jcCaseNonlian = jcCaseNonlianMapper.selectByCaseId(jcCaseNonlianDto.getfCaseid());
        //保存调查数据
        String dcid = UUID.randomUUID().toString();
        if(jcCaseNonlian == null){
            JcCaseNonlian   bean =  new JcCaseNonlian();
            BeanUtil.copyProperties(jcCaseNonlianDto,bean,false);
            bean.setfId(dcid);
            jcCaseNonlianMapper.insertSelective(bean);
        }else{
            BeanUtil.copyProperties(jcCaseNonlianDto,jcCaseNonlian,false);
            jcCaseNonlianMapper.updateByPrimaryKeySelective(jcCaseNonlian);
            //删除暂存的用地数据
            jcCaseLandinfoMapper.deleteByCaseId(jcCaseNonlianDto.getfCaseid());
        }

        //保存用地情况数据
        if(jcCaseNonlianDto.getLandinfo() != null && !jcCaseNonlianDto.getLandinfo().isEmpty()){
            List<JcCaseLandinfo> jcCaseLandinfos = jcCaseNonlianDto.getLandinfo().toJavaList(JcCaseLandinfo .class);
            for(JcCaseLandinfo bean : jcCaseLandinfos){
                bean.setfId(UUID.randomUUID().toString());
                bean.setfCaseid(jcCaseNonlianDto.getfCaseid());
                jcCaseLandinfoMapper.insertSelective(bean);
            }
        }
        //调查提交则将进到审核阶段
        if(jcCaseNonlianDto.getOperate().equals("1")){
            jcCaseInfoMapper.updateByPrimaryKeySelective(jcCaseInfo);
        }
    }

    @Override
    public JcCaseNonlian getNonLianSubmitInfo(Long userId, String caseId) throws Exception {
        JcCaseNonlian jcCaseNonlian = jcCaseNonlianMapper.selectByCaseId(caseId);
        if(jcCaseNonlian == null){
            List<JcCaseLandinfo> jcCaseLandinfos = jcCaseLandinfoMapper.selectByCaseId(caseId);
            jcCaseNonlian.setLandInfo(jcCaseLandinfos);
        }
        return  jcCaseNonlian;
    }

    /**
     * 系统生成立案文号
     * @param regionCode
     * @return
     * @throws Exception
     */
    public String getCasewhSeq(String regionCode) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");//注意月份是MM
        String gen = "";
        Integer num = jcCaseInfoMapper.getCasewhSeq();
        gen = String.format("%s%s%s", regionCode, simpleDateFormat.format(new Date()), generByNum(num));
        return gen;
    }

    private String generByNum(Integer count) throws Exception {
        int idx = count.toString().length();
        if (idx > 4) {
            throw new RuntimeException("生成编码的数量超过了4位数");
        }
        String gener = "";
        switch (idx) {
            case 1:
                gener = "000" + count;
                break;
            case 2:
                gener = "00" + count;
                break;
            case 3:
                gener = "0" + count;
                break;
            case 4:
                gener = count.toString();
                break;
            default:
                break;
        }
        return gener;
    }


}
