package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MCluePlotService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskClueJudgeMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskClueLandinfoMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskCluePlotinfoMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.TaskClueJudgeDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskClueJudge;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskClueLandinfo;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcTaskCluePlotinfo;
/*import com.gw.base.data.GwValidateException;*/
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.cluelibrary.service.impl
 * @date 2022/3/29 10:39
 */
@Service
public class MCluePlotServiceImpl implements MCluePlotService {

    @Autowired
    JcTaskClueJudgeMapper jcTaskClueJudgeMapper;
    @Autowired
    JcTaskClueLandinfoMapper jcTaskClueLandinfoMapper;
    @Autowired
    JcTaskCluePlotinfoMapper jcTaskCluePlotinfoMapper;
    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DataBizService dataBizService;
    @Resource
    private JdbcTemplate jdbcTemplate;


    @Override
    public void saveTaskclueJudgeInfo(Long userId, TaskClueJudgeDto taskClueJudgeDto) {
        //新增和更新判定信息
        if(taskClueJudgeDto != null){
            JcTaskClueJudge jcTaskClueJudge = jcTaskClueJudgeMapper.selectByDataId(taskClueJudgeDto.getfDataid());
            if(jcTaskClueJudge == null){
                JcTaskClueJudge bean = new JcTaskClueJudge();
                BeanUtil.copyProperties(taskClueJudgeDto,bean);
                bean.setfId(UUID.randomUUID().toString());
                bean.setfUserid(userId.intValue());
                bean.setfCreatetime(new Date());
                jcTaskClueJudgeMapper.insertSelective(bean);
            }else{
                BeanUtil.copyProperties(taskClueJudgeDto,jcTaskClueJudge,false);
                jcTaskClueJudge.setfUserid(userId.intValue());
                jcTaskClueJudgeMapper.updateByPrimaryKeySelective(jcTaskClueJudge);
            }
            //删除合法用地批文
            jcTaskClueLandinfoMapper.deleteByDataId(taskClueJudgeDto.getfDataid());
            //合法用地批文
            if(taskClueJudgeDto.getLandinfo() != null && !taskClueJudgeDto.getLandinfo().isEmpty()){
                List<JcTaskClueLandinfo> jcCaseLandinfos = taskClueJudgeDto.getLandinfo().toJavaList(JcTaskClueLandinfo .class);
                for(JcTaskClueLandinfo bean : jcCaseLandinfos){
                    bean.setfId(UUID.randomUUID().toString());
                    bean.setfDataid(taskClueJudgeDto.getfDataid());
                    jcTaskClueLandinfoMapper.insertSelective(bean);
                }
            }
        }

    }

    @Override
    public void saveCluePlotInfo(Long userId, JcTaskCluePlotinfo jcTaskCluePlotinfo) {
        if(jcTaskCluePlotinfo != null){
            String id = UUID.randomUUID().toString();
            JcTaskCluePlotinfo jcTaskCluePlotinfo1 = jcTaskCluePlotinfoMapper.selectByDataId(jcTaskCluePlotinfo.getfDataid());
            if(jcTaskCluePlotinfo1 != null){
                id = jcTaskCluePlotinfo1.getfId();
                BeanUtil.copyProperties(jcTaskCluePlotinfo,jcTaskCluePlotinfo1,false);
                jcTaskCluePlotinfo1.setfId(id);
                jcTaskCluePlotinfo1.setfUserid(userId.intValue());
                jcTaskCluePlotinfo1.setfCreatetime(new Date());
                jcTaskCluePlotinfoMapper.updateByPrimaryKeySelective(jcTaskCluePlotinfo1);
            }else{
                JcTaskCluePlotinfo bean = new JcTaskCluePlotinfo();
                BeanUtil.copyProperties(jcTaskCluePlotinfo,bean,false);
                bean.setfId(id);
                bean.setfUserid(userId.intValue());
                bean.setfCreatetime(new Date());
                jcTaskCluePlotinfoMapper.insertSelective(bean);
            }
        }
    }

    @Override
    public JcTaskClueJudge getTaskclueJudgeInfo(Long userId, String dataId) {
        JcTaskClueJudge jcTaskClueJudge = jcTaskClueJudgeMapper.selectByDataId(dataId);
        if(jcTaskClueJudge != null){
            List<JcTaskClueLandinfo> jcTaskClueLandinfos = jcTaskClueLandinfoMapper.selectByDataId(dataId);
            jcTaskClueJudge.setLandinfo(jcTaskClueLandinfos);

            List<AppMedia> appMedias =  appMediaDao.queryByGid(dataId);
            List<AppMediaDTO> result = new ArrayList<>();
            List<Object> resultObject = new ArrayList<>();
            for (int i = 0; i < appMedias.size(); i++) {
                if(appMedias.get(i).getTypetype() == 5){
                    AppMediaDTO newMedia = new AppMediaDTO();
                    BeanUtils.copyProperties(appMedias.get(i), newMedia);
                    if (newMedia.getServerpath() != null && !newMedia.getServerpath().contains("AccessKeyId")) {
                        //获取文件名
                        String fiename = appMedias.get(i).getServerpath().substring(appMedias.get(i).getServerpath().lastIndexOf("/") + 1, appMedias.get(i).getServerpath().length());
                        newMedia.setFileName(fiename);
                        //获取文件授权有效期
                        String url = temporarySignedUrlService.getTemporarySignedUrl("", newMedia.getServerpath(), null);
                        if (StringUtils.isNotBlank(url)) {
                            newMedia.setServerpath(url);
                        }
                    }
                  //  result.add(newMedia);
                    resultObject.add(newMedia);
                }
            }
            jcTaskClueJudge.setMediaList(resultObject);
        }
        return jcTaskClueJudge;
    }

    @Override
    public JcTaskCluePlotinfo getCluePlotInfo(Long userId, String dataId) {
        return  jcTaskCluePlotinfoMapper.selectByDataId(dataId);
    }

    @Override
    public Map<String, Object> findCluePlotList(Long userId, String regionCode, String existLian, String wflx, String tbbh, String xsStage, int pageIndex, int pageSize) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findByName("卫片执法");
        if(jcClueSource == null){
            throw new RuntimeException("线索来源不存在");
        }
        Map<String, Object> result = new HashMap<>();
     String sql = " select ca.f_id caseid,ca.f_inspectid inspectid,wf.f_zzqk zzqk,ca.f_type " +
             "casetype,tb.f_wflx wflx,tb.f_xzqdm xzqdm,r.f_clueid clueid,r.f_sourceid sourceid,r.f_taskid taskid,r.f_tbid tbid ,tb.f_tbbh tbbh,tb.f_stage stage\n" +
             "from jc_clue_task_rel as r \n" +
             "LEFT JOIN jc_wf_info wf ON(wf.f_clueid = r.f_clueid) \n" +
             "LEFT JOIN jc_case_info ca ON(ca.f_clueid = r.f_clueid) \n" +
             ","+jcClueSource.getfTablename()+" tb where r.f_clueid = tb.f_id and r.f_type='2'";
        String countSql = "select count(1) from jc_clue_task_rel as r \n" +
                "LEFT JOIN jc_wf_info wf ON(wf.f_clueid = r.f_clueid) \n" +
                "LEFT JOIN jc_case_info ca ON(ca.f_clueid = r.f_clueid) \n" +
                ","+jcClueSource.getfTablename()+" tb where r.f_clueid = tb.f_id and r.f_type='2'";

        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length() <= 6 && regionCode.endsWith("00")){
                regionCode = regionCode.replace("00","");
            }
            sql += " and tb.f_xzqdm like '"+regionCode+"%'";
            countSql += " and tb.f_xzqdm like '"+regionCode+"%'";
        }
        if(StringUtils.isNotBlank(existLian)){
            sql += " and ca.f_type = '"+existLian+"'";
            countSql += " and ca.f_type = '"+existLian+"'";
        }
        if(StringUtils.isNotBlank(wflx)){
            sql += " and tb.f_wflx like '"+wflx+"%'";
            countSql += " and tb.f_wflx like '"+wflx+"%'";
        }
        if(StringUtils.isNotBlank(tbbh)){
            sql += " and tb.f_tbbh like '%"+wflx+"%'";
            countSql += " and tb.f_tbbh like '%"+wflx+"%'";
        }
        int start = (pageIndex - 1) * pageSize;
        sql += " order by tb.f_createtime desc limit " + pageSize + " offset " + start;
        List<Map> maps = dataBizService.queryDataBySql(sql);
        Integer count = jdbcTemplate.queryForObject(countSql, Integer.class);
        result.put("datas", maps);
        result.put("totalNum", count);
        return result;
    }
}
