package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.landcloud.common.util.PinYinUtil;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldsMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueSourceMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/**
 * @author cuiwenjing
 * @date 2021/12/7 14:57
 */
@Service
public class MJcClueFieldsServiceImpl implements MJcClueFieldsService {

    @Autowired
    JcClueFieldsMapper jcClueFieldsMapper;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Autowired
    TaskRecordService taskRecordService;

    @Autowired
    JcClueSourceMapper jcClueSourceMapper;

    @Autowired
    MJcClueSourceService jcClueSourceService;

    @Override
    public int deleteByPrimaryKey(String fId) {
        return jcClueFieldsMapper.deleteByPrimaryKey(fId);
    }

    @Override
    public int insert(JcClueFields record) {
        return jcClueFieldsMapper.insert(record);
    }

    @Override
    public int insertSelective(JcClueFields record) {
        return jcClueFieldsMapper.insertSelective(record);
    }

    @Override
    public JcClueFields selectByPrimaryKey(String fId) {
        return jcClueFieldsMapper.selectByPrimaryKey(fId);
    }

    @Override
    public int updateByPrimaryKeySelective(JcClueFields record) {
        return jcClueFieldsMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(JcClueFields record) {
        return jcClueFieldsMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<JcClueFields> findByTableName(String sourceId) {
        return jcClueFieldsMapper.findByTableName(sourceId);
    }
    @Override
    public List<JcClueFields> findByTableId(String sourceId) {
        return jcClueFieldsMapper.findByTableId(sourceId);
    }

    @Override
    public List<JcClueFields> getClueMustFieldsByTableid(String sourceId,Integer fIsMust) {
        return jcClueFieldsMapper.getClueMustFieldsByTableid(sourceId,fIsMust);
    }

    @Override
    public List<JcClueFields> getClueUniqueFieldsByTableid(String sourceId,Integer fUnique) {
        return jcClueFieldsMapper.getClueUniqueFieldsByTableid(sourceId,fUnique);
    }

    @Override
    public JcClueFields saveClueField(JcClueFields bean) {
        if(bean.getfTableid() != null ){
            JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(bean.getfTableid());
            //判断表是否已经创建
            if(jcClueSource!=null && jcClueSource.getfTablename()!=null){
                //已创建表
                if (!StringUtils.isEmpty(bean.getfId())) {
                    JcClueFields oldField = jcClueFieldsMapper.selectByPrimaryKey(bean.getfId());
                    if (!oldField.getfAlias().equals(bean.getfAlias())) {
                        bean = changeFileName(bean);
                        //变更表字段名称
                        jdbcTemplate.execute("ALTER TABLE "+jcClueSource.getfTablename() + " RENAME "+oldField.getfFieldname()+" to " +
                                bean.getfFieldname());
                    }
                    jcClueFieldsMapper.updateByPrimaryKeySelective(bean);
                    //字段更新
                    List<JcClueFields> fields = new ArrayList<>();
                    fields.add(bean);
                    StringBuilder sbSql = new StringBuilder();
                    sbSql.append(" ALTER TABLE ");
                    sbSql.append(jcClueSource.getfTablename());
                    sbSql.append( "  alter  COLUMN ");
                    String sql = MJcClueSourceImpl.generateFieldSql(jcClueSource, fields);
                           sql = bean.getfFieldname() +" TYPE "+ sql.replace(bean.getfFieldname(),"")+"  USING ( "
                            +bean.getfFieldname()+"::"+sql.replace(bean.getfFieldname(),"")+")";
                    sbSql.append(sql);
                    //更改数据库字段
                    jdbcTemplate.execute(sbSql.toString());
                } else {
                    //新增字段
                    bean.setfId(UUID.randomUUID().toString());
                    bean = changeFileName(bean);
                    jcClueFieldsMapper.insertSelective(bean);

                    List<JcClueFields> fields = new ArrayList<>();
                    fields.add(bean);
                    StringBuilder sbSql = new StringBuilder();
                    sbSql.append(" ALTER TABLE ");
                    sbSql.append(jcClueSource.getfTablename());
                    sbSql.append( " ADD COLUMN ");
                    String sql = MJcClueSourceImpl.generateFieldSql(jcClueSource, fields);
                    sbSql.append(sql);
                    //更改数据库字段
                    jdbcTemplate.execute(sbSql.toString());
                }
                //同步字段信息给智能分析
                syncClueInfo(jcClueSource, bean.getfId(),101L,"rootNode","update");

                //添加默认导入关系数据
                jcClueSourceService.defaultClueImportRel(jcClueSource.getfId());

            }{
                //未创建表
                if (!StringUtils.isEmpty(bean.getfId())) {
                    JcClueFields oldField = jcClueFieldsMapper.selectByPrimaryKey(bean.getfId());
                    if (!oldField.getfAlias().equals(bean.getfAlias())) {
                        bean = changeFileName(bean);
                    }
                    jcClueFieldsMapper.updateByPrimaryKeySelective(bean);
                } else {
                    bean.setfId(UUID.randomUUID().toString());
                    bean = changeFileName(bean);
                    jcClueFieldsMapper.insertSelective(bean);
                }
            }
        }
        return bean;
    }


    /**
     * 同步线索信息给智能分析
     * @param jcClueSource
     * @param userId
     */
    public void syncClueInfo(JcClueSource jcClueSource,String fieldId, Long userId,String source,String type){
        //改为定时任务处理
        JSONObject params = new JSONObject();
        params.put("sourceId", jcClueSource.getfId());
        params.put("fieldId", fieldId);
        params.put("userId", userId);
        params.put("type", type);
        params.put("source", source);
        TaskRecord record = new TaskRecord();
        record.setId( UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_SYNC);
        record.setBizId(jcClueSource.getfId());
        record.setRead(0);
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        record.setTaskName(jcClueSource.getfName());
        taskRecordService.save(record);
    }


    private JcClueFields changeFileName(JcClueFields field) {
        // 规则：默认字段名为“f_”加上字段别名的前8位中文首字母，长度最大为10个长度，
        // 如果同一张表，存在相同的字段名
        //      如“f_mj”这种长度不超过7个的，则直接在字段后补充“_n1”，1为存在相同的字段的个数，最终字段名为“f_mj_n1”
        //      如果“f_qmlmjzd”这种长度超过7个的，则截取前7位补充“_n1”，1为存在相同的字段的个数（一般来说不会超过两位数的相同字段名），最终字段名为“f_qmlmj_n1”
        String alias = field.getfAlias();
        String pinYin = PinYinUtil.getFirstSpell(alias);
        if(pinYin.length()>8){
            pinYin = pinYin.substring(0,8);
        }
        pinYin = "f_" + pinYin;
        //同名第一种情况
        Long count = jcClueFieldsMapper.countStartWithPinyin(field.getfTableid(), pinYin+"%");
        //如果有第一种情况 才执行 同名第二种情况fTableid = "7af15c9b-686f-4c33-b712-c2921d3f25e1"
        if (count > 0) {
            if (pinYin.length() > 7) {
                count += jcClueFieldsMapper.countStartWithPinyin(field.getfTableid(), pinYin.substring(0, pinYin.length() - 3) + "_n%");
            }
        }
        if (count > 0) {
            if(pinYin.length()+3<=10) {
                pinYin = pinYin + "_n" + count;
            }
            else{
                pinYin = pinYin.substring(0,pinYin.length()-3) + "_n" + count;
            }
        }
        field.setfFieldname(pinYin);
        return field;
    }


    public void saveFields(JcClueSource jcClueSource, String name, String type, String length, String flength,
                           String notNull, String isBase, String isOutwork, String rname, String order,
                           String isListShow, String isWebCheck, String isWebEdit, String isStatis, Integer fieldType, Boolean isSysField) {
        JcClueFields tbField = new JcClueFields();
        tbField.setfId(UUID.randomUUID().toString());
        tbField.setfAlias(rname);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(type);

        if (StringUtils.isNotBlank(order)) {
            tbField.setfOrder(Integer.parseInt(order));
        }

        if (StringUtils.isNotBlank(length)) {
            tbField.setfLength(Integer.parseInt(length));
        }
        if (StringUtils.isNotBlank(flength)) {
            tbField.setfPrecision(Integer.parseInt(flength));
        }

        if ("true".equals(notNull)) {
            tbField.setfNullable(0);
        } else {
            tbField.setfNullable(1);
        }
        if ("true".equals(isBase)) {
            tbField.setfIsBase(1);
        } else {
            tbField.setfIsBase(0);
        }
        if ("true".equals(isOutwork)) {
            tbField.setfIsOutwork(1);
        } else {
            tbField.setfIsOutwork(0);
        }
        if ("true".equals(isListShow)) {
            tbField.setfIsListShow(1);
        } else {
            tbField.setfIsListShow(0);
        }
        if ("true".equals(isWebCheck)) {
            tbField.setfIsWebCheck(1);
        } else {
            tbField.setfIsWebCheck(0);
        }
        if ("true".equals(isWebEdit)) {
            tbField.setfIsWebEdit(1);
        } else {
            tbField.setfIsWebEdit(0);
        }
        if ("true".equals(isStatis)) {
            tbField.setfIsStatis(1);
        } else {
            tbField.setfIsStatis(0);
        }

        tbField.setfFieldInnerOuterSys(fieldType);
        // 因为app更新
        if ("int4".equals(type) && isSysField) {
            tbField.setfDefaultvalue("0");
        }
        tbField.setfTablename(jcClueSource.getfTablename());
        tbField.setfTableid(jcClueSource.getfId());
        jcClueFieldsMapper.insertSelective(tbField);
    }

    @Override
    public void updateTableNameBytableId(String tableName, String tableId) {
        jcClueFieldsMapper.updateTableNameBytableId(tableName,tableId);
    }

}
