package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.geoway.landteam.customtask.task.dto.FieldDisPlay;
import com.geoway.landteam.customtask.task.dto.FieldGroup;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueGroupService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldGroupViewMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueGroupMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.CuleGroupDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFieldGroupView;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


/**
 * @author panzhiguang
 * @Package com.geoway.land.cluelibrary.domain
 * @date 2021/12/14 11:15
 */
@Service
public class MJcClueGroupServiceImpl implements MJcClueGroupService {

    final String LISTCODE = "100"; //图斑列表展示配置
    final String FILTERCODE = "101"; //业务字段筛选配置
    final String DETAILCODE = "202"; //图斑详情展示配置
    final String SEARCHCODE = "102"; //关键字搜索配置
    final String MAINCODE = "103"; // 详情主显示字段
    final String FILTERSYSCODE = "104"; //系统字段筛选配置
    final String ORDERCODE = "105";//业务字段排序配置

    final String AUDITQXCODE = "301";//区县审核字段配置
    final String AUDITCITYCODE = "302";//市级审核字段配置
    final String AUDITSJCODE = "303";//省级审核字段配置

    @Autowired
    JcClueGroupMapper jcClueGroupMapper;

    @Autowired
    JcClueFieldGroupViewMapper jcClueFieldGroupViewMapper;

    @Override
    public int deleteByPrimaryKey(String fId) {
        return jcClueGroupMapper.deleteByPrimaryKey(fId);
    }

    @Override
    public int insert(JcClueGroup record) {
        return jcClueGroupMapper.insert(record);
    }

    @Override
    public int insertSelective(JcClueGroup record) {
        return jcClueGroupMapper.insertSelective(record);
    }

    @Override
    public JcClueGroup selectByPrimaryKey(String fId) {
        return jcClueGroupMapper.selectByPrimaryKey(fId);
    }

    @Override
    public int updateByPrimaryKeySelective(JcClueGroup record) {
        return jcClueGroupMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(JcClueGroup record) {
        return jcClueGroupMapper.updateByPrimaryKey(record);
    }

    @Override
    public CuleGroupDto getFieldGroup(String sourceId) {
        CuleGroupDto bean = new CuleGroupDto();
        bean.setSourceId(sourceId);
        //100
        List<String> fieldInList = jcClueGroupMapper.clueGroupBySourceId("web",sourceId, LISTCODE);
         bean.setFieldInList(fieldInList);
        List<String> fieldInFilter = jcClueGroupMapper.clueGroupBySourceId("web",sourceId, FILTERCODE);
         bean.setFieldInFilter(fieldInFilter);
        List<String> fieldInSearch = jcClueGroupMapper.clueGroupBySourceId("web",sourceId,SEARCHCODE);
         bean.setFieldInSearch(fieldInSearch);
        List<String> fieldInDetailMain = jcClueGroupMapper.clueGroupBySourceId("web",sourceId, MAINCODE);
         bean.setFieldInDetailMain(fieldInDetailMain);
       //详情配置tab
        List<JcClueGroup> detailGroup = jcClueGroupMapper.clueGroupByTableId("web",sourceId, DETAILCODE);
        List<FieldGroup> fieldGroups = new ArrayList<>();
        HashMap<String, List<FieldDisPlay>> map = new HashMap();
        HashMap<String, String> btnMap = new HashMap();
        detailGroup.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!map.containsKey(title)) {
                ArrayList<FieldDisPlay> fields = new ArrayList<>();
                map.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroups.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getfNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getfConnection());
            field.setVisible(group.getfVisible());
            field.setItemGroupName(group.getfItemGroupName());
            map.get(title).add(field);
        });
        List<Object> resultObject = new ArrayList<>();
        for (FieldGroup fieldGroup : fieldGroups) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields(map.get(key));
            if (btnMap.containsKey(key))
                fieldGroup.setButton(btnMap.get(key));
            resultObject.add(fieldGroup);
        }
        bean.setFieldGroup(resultObject);
        return bean;
    }

    @Override
    public List<JcClueFieldGroupView> getFieldGroupByGroupCode(String sourceId, String groupCode) {
        List<JcClueFieldGroupView> fieldInDetailMain = jcClueFieldGroupViewMapper.clueGroupByTableId("web",sourceId, groupCode);
        return fieldInDetailMain;
    }


    @Override
    public Map<String, Object> getFieldGroupView(String tablename,String sourceId) {
        Map<String, Object> result = new HashMap<>();
        List<JcClueFieldGroupView> fieldInList = jcClueFieldGroupViewMapper.clueGroupByTableId("web",sourceId, LISTCODE);
        List<JcClueFieldGroupView> fieldInFilter = jcClueFieldGroupViewMapper.clueGroupByTableId("web",sourceId, FILTERCODE);
        List<JcClueFieldGroupView> fieldInSearch = jcClueFieldGroupViewMapper.clueGroupByTableId("web",sourceId,SEARCHCODE);
        List<JcClueFieldGroupView> fieldInDetailMain = jcClueFieldGroupViewMapper.clueGroupByTableId("web",sourceId, MAINCODE);
        result.put("list", fieldInList);
        result.put("filter", fieldInFilter);
        result.put("search", fieldInSearch);
        result.put("sourceId", sourceId);
        result.put("detailMain", fieldInDetailMain);
        return result;
    }




}
