package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskDataLogRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskDataLogService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.constants.UpResultEnum;
import com.geoway.landteam.customtask.task.constants.UpResultErrorEnum;
import com.geoway.landteam.customtask.task.dto.TskUploadErrorLogDTO;
import com.geoway.landteam.customtask.task.dto.TskUploadLogDTO;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.ExcelData;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.bean.MapUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.*;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.base.*;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.pub.dto.ClueFieldsValueParamVo;
import com.geoway.landteam.landcloud.model.pub.dto.JcClueFilterVo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.cgjcyj.MCgjcyjTaskService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskImportTaskDataService;
import com.geoway.landteam.patrolclue.dao.cluelibrary.*;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldGroupViewMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueJudgeMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueNumMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcTaskClueJudgeMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.*;
import com.geoway.landteam.patrolclue.model.until.ShapeUtil;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRelService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import jxl.Workbook;
import jxl.write.WritableWorkbook;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

/**
 * @author cuiwenjing
 * @date 2021/12/5 15:21
 */
@Service
public class MJcClueServiceImpl implements MJcClueService {

    private final GiLoger logger = GwLoger.getLoger(MJcClueServiceImpl.class);
    private final static String SHAPE_APPEND = "0";
    private final static String SHAPE_UPDATE = "1";

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    RegionRepository regionDao;

    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionvillageDao;

    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskTaskClassService tbtskTaskClassService;
    @Autowired
    RegionService regionService;
    @Autowired
    TaskRecordService taskRecordService;

    @Autowired
    DataBizService dataBizService;
    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    RegionVersionRepository regionVersionRepository;

    @Autowired
    JcClueImportRecordService jcClueImportRecordService;

    @Autowired
    MJcClueFieldsService jcClueFieldsService;

    @Autowired
    JcClueImportRelService jcClueImportRelService;

    @Autowired
    JcClueFieldGroupViewMapper jcClueFieldGroupViewMapper;
    @Autowired
    JcClueJudgeMapper jcClueJudgeMapper;

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    JcClueNumMapper jcClueNumMapper;
    @Autowired
    JcTaskClueJudgeMapper jcTaskClueJudgeMapper;
    @Autowired
    JcClueFilterDao jcClueFilterDao;

    @Autowired
    MTaskImportTaskDataService taskImportTaskDataService;

    @Autowired
    JcClueAssignmentPmDao jcClueAssignmentPmDao;
    @Autowired
    JcClueAssignmentCondDao jcClueAssignmentCondDao;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JcClueSplitProgrammeDao jcClueSplitProgrammeDao;
    @Autowired
    JcClueSplitMapDao jcClueSplitMapDao;
    @Autowired
    JcClueSplitMapLayerDao jcClueSplitMapLayerDao;
    @Autowired
    TbtskDataLogService tbtskDataLogService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TbtskDataLogRepository tbtskDataLogRepository;

    //@Autowired
    //MCgjcyjTaskService cgjcyjTaskService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void importData(MultipartFile multipartFile, JcClueSource jcClueSource, Long userid, String sjpc,
                           String jcClueImportRels, Boolean isChange, String jcsj) throws Exception {
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        if(multipartFile==null){
            throw new RuntimeException("文件错误");
        }

        File zipFile = null;
        File dir = new File(uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        zipFile = File.createTempFile("tmp", ".gty", dir);
        FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), zipFile);
        String zipName = zipFile.getAbsolutePath();
        String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
        Zip4jUtils.unzip(zipName, unzipFileDir, "");

        File file = new File(unzipFileDir);
        URL url = null;
        File[] content = file.listFiles();
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".shp")) {
                url = content[j].toURI().toURL();
                break;
            }
        }
        if(url==null){
            throw new RuntimeException("shape文件错误");
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);

        String chasetStr = shpDataStore.getCharset().toString();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore
                .getFeatureSource(shpDataStore.getTypeNames()[0]);
        //获取图层原始坐标系，转换目标坐标系
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84, true);
        SimpleFeature sf = null;
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = featureSource.getFeatures();

        FeatureIterator<SimpleFeature> itertor = collection.features();
        //处理映射数据
        if(isChange){
            if(!StringUtils.isEmpty(jcClueImportRels)){
                JSONArray objects = JSONArray.parseArray(jcClueImportRels);
                List<JcClueImportRel> jcClueImportRelList = objects.toJavaList(JcClueImportRel.class);
                for(JcClueImportRel bean: jcClueImportRelList){
                    jcClueImportRelService.updateByPrimaryKey(bean);
                }
            }
        }
        List<JcClueImportRelView> jcClueImportRelViews = jcClueImportRelService.selectBySourceId(jcClueSource.getfId());
        if(jcClueImportRelViews.isEmpty()){
            throw new RuntimeException("缺少导入配置");
        }

        List<Map<String, Object>> addDataCacheList = new ArrayList<>();

        int count = 0;
        Double area = 0D;
        String id = UUID.randomUUID().toString();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (itertor.hasNext()) {
            count++;
            System.out.println("本次图斑总数量："+collection.size()+"，当前正在处理第"+count+"条数据...");

            HashMap<String, Object> map = new HashMap<>();

            sf = itertor.next();
            Geometry geo = (Geometry) sf.getDefaultGeometry();
            if(geo == null){
                continue;
            }
            map.clear();
            Geometry pt = geo.getCentroid();

            int proNum = getColNum(((Point) pt).getX());
            // 获取村级政区代码
            HashMap<String, Object> map1 = null;
            try {
                map1 = getXzqdmSys(pt,geo,proNum);//getXzqdmSys(pt, defaultVersion.getVersion());
                if (map1 != null && map1.size() > 0) {
                    map.put("f_xzqdm", map1.get("xzqdmsys"));
                    map.put("f_xzqmc", map1.get("xzqmc"));
                    map.put("f_location", map1.get("location"));
                    map.put("f_area", map1.get("area"));
                    area += Double.valueOf(map1.get("area").toString());
                }
            }
            catch (SQLException e){
                logger.error("getXzqdmSys错误："+e.getMessage());
            }

            map.put("f_shape",geo);
            map.put("f_sjpc",sjpc);
            map.put("f_status",0);
            map.put("f_userid",userid.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime",System.currentTimeMillis()/1000);
           // map.put("f_createtime",df.format(new Date()));
            map.put("f_import_recordid", id);
            for (int i = 0; i < jcClueImportRelViews.size(); i++) {
                JcClueImportRelView t = jcClueImportRelViews.get(i);

                if(!"f_shape".equalsIgnoreCase(t.getfFieldname()) && !"f_sjpc".equalsIgnoreCase(t.getfFieldname()) && !"f_sourceid".equalsIgnoreCase(t.getfFieldname())){
                    String strValue = getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr);
                    switch (conType(t.getfFieldtype())){
                        case "varchar":
                            map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));
                            break;
                        case "text":
                            map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));
                            break;
                        case "decimal":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Double value2 = Double.valueOf(strValue);
                                map.put(t.getfFieldname(), value2);
                               /* map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));*/
                            }
                            break;
                        case "timestamp":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Date date = df.parse(strValue);
                                Timestamp value5 = new Timestamp(date.getTime());
                                map.put(t.getfFieldname(), value5);
                               /* map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));*/
                            }
                            break;
                        case "int4":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Integer value3 = Integer.valueOf(strValue);
                                map.put(t.getfFieldname(), value3);
                               /* map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));*/
                            }
                            break;
                        case "geometry":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Geometry geo1 = WKTUtil.wktToGeom(strValue);
                                if (geo == null) {
                                    break;
                                } else {
                                    map.put(t.getfFieldname(), WKTUtil.geomToWkt(geo1));
                                }
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
            if(map.containsKey("f_id")){
                if(StringUtils.isBlank(map.get("f_id").toString())){
                    map.put("f_id", UUID.randomUUID().toString());
                }
            }
            else{
                map.put("f_id", UUID.randomUUID().toString());
            }
            addDataCacheList.add(map);

            // 每达到提交数量是，提交插入数据,并清空缓存集合
            if (addDataCacheList.size() == 200) {
                dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
                addDataCacheList.clear();
            }
        }
        if (!addDataCacheList.isEmpty()) {
            // 提交插入最后一批数据
            dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        shpDataStore.dispose();

        // 插入批次
        JcClueImportRecord record = new JcClueImportRecord();
        record.setfId(id);
        record.setfCreatetime(new Date());
        record.setfName(sjpc);
        record.setfSourceid(jcClueSource.getfId());
        record.setfCount(count);
        record.setfJcmj(new BigDecimal(Double.valueOf(area)));
        record.setfJcsj(jcsj);
        jcClueImportRecordService.insert(record);
    }


    /**
     * 异步处理数据导入
     * @param multipartFile
     * @param jcClueSource
     * @param userId
     * @param sjpc
     * @param jcClueImportRels
     * @param isChange
     * @param jcsj
     * @throws Exception
     */
    @Override
    public void asynImportData1(MultipartFile multipartFile, JcClueSource jcClueSource, Long userId, String sjpc,
                           String jcClueImportRels, Boolean isChange,String jcsj) throws Exception {
        if(multipartFile==null){
            throw new RuntimeException("文件错误");
        }
        File zipFile = null;
        File dir = new File(uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        zipFile = File.createTempFile("tmp", ".gty", dir);
        FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), zipFile);
        String zipName = zipFile.getAbsolutePath();
        String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
        Zip4jUtils.unzip(zipName, unzipFileDir, "");
        //将文件保存到obs上
        String fileName = UUID.randomUUID().toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = sdf.format(new Date());
        String obsFilePath = "importClueData/" + dateString + "/"+zipFile.getName();
        String resultUrl = defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);
        String id = UUID.randomUUID().toString();
        //改为定时任务处理
        JSONObject params = new JSONObject();
            params.put("unzipFileDir", resultUrl);
            params.put("userId", userId);
            params.put("sjpc", sjpc);
            params.put("jcClueImportRels", jcClueImportRels);
            params.put("isChange", isChange);
            params.put("jcsj", jcsj);
            params.put("sourceId", jcClueSource.getfId());
            params.put("importId", id);
        TaskRecord record = new TaskRecord();
        record.setId(id);
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_CULEDATA_IMPORT);
        record.setData(resultUrl);
        record.setBizId(jcClueSource.getfId());
        record.setRead(0);
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        record.setTaskName(sjpc);
        taskRecordService.save(record);
        // 插入批次
        JcClueImportRecord bean = new JcClueImportRecord();
        bean.setfId(id);
        bean.setfCreatetime(new Date());
        bean.setfName(sjpc);
        bean.setfSourceid(jcClueSource.getfId());
        bean.setfCount(0);
        bean.setfJcmj(new BigDecimal(0));
        bean.setfJcsj(jcsj);
        jcClueImportRecordService.insert(bean);
    }

    @Override
    public void deleteClueDatas(String sourceId, String recordId, String clueIds) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        if(StringUtils.isNotBlank(clueIds)){
            List<String> ids = Arrays.asList(clueIds.split(","));
            String id = "";
            if(ids.size() > 0){
                for(String s : ids){
                    id += "'" + s + "',";
                }
            }
            //删除线索数据
            String sql = "delete from "+jcClueSource.getfTablename() +" where f_id in ("+id.substring(0,id.length()-1)+")";
            jdbcTemplate.execute(sql);
            //将线索批次数据数量-1
            JcClueImportRecord jcClueImportRecord = jcClueImportRecordService.selectByPrimaryKey(recordId);
                jcClueImportRecord.setfCount(jcClueImportRecord.getfCount() - ids.size());
                jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
        }else{
            if(StringUtils.isNotBlank(recordId)){
                //删除线索数据
                String sql = "delete from "+jcClueSource.getfTablename() +" where f_import_recordid = '"+recordId+"'";
                jdbcTemplate.execute(sql);
                //删除批次数据
                jcClueImportRecordService.deleteByPrimaryKey(recordId);
            }
        }
    }

    /**
     * 导入线索数据
     * @param record
     * @throws Exception
     */
    @Override
    public void handleImportData(TaskRecord record) throws Exception {
        if(StringUtils.isNoneEmpty(record.getParam())) {
            JSONObject jsonObject = JSONObject.parseObject(record.getParam());
            String sjpc = jsonObject.getString("sjpc");
            String jcClueImportRels = jsonObject.getString("jcClueImportRels");
            Boolean isChange = jsonObject.getBoolean("isChange");
            String jcsj = jsonObject.getString("jcsj");
            Long userId = jsonObject.getLong("userId");
            String sourceId = jsonObject.getString("sourceId");
            String importId = jsonObject.getString("importId");

            HttpURLConnection httpURLConnection = null;
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", jsonObject.getString("unzipFileDir"), null);
            // 统一资源
            URL url = new URL(uploadurl);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000 * 60*10);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();
            File zipFile = null;
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "");
            List<Map<String, Object>> dataLog = new ArrayList<>();
            JSONObject resultObject = new JSONObject();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            resultObject.put("uploadTime", simpleDateFormat.format(record.getStarttime()));
            resultObject.put("completeTime", simpleDateFormat.format(new Date()));
            resultObject.put("userId", userId);
            //处理数据
            try{
                Map<String, Object> map =  importData(unzipFileDir, sourceId,importId,  userId,  sjpc,jcClueImportRels,  isChange, jcsj,dataLog);
                resultObject.put("totalNum", map.get("count").toString());
                resultObject.put("successNum", map.get("count").toString());
                resultObject.put("failNum", 0);
                resultObject.put("logAddr", null);
                //更新任务记录
                record.setResult(JSONObject.toJSONString(resultObject,SerializerFeature.WriteMapNullValue));
                record.setEndtime(new Date());
                taskRecordService.save(record);

                //cgjcyjTaskService.createCgjcyjTask(sourceId,importId,"常规监测预警",record.getUserid().toString());
            }catch (Exception e){
                resultObject.put("totalNum", 0);
                resultObject.put("successNum", 0);
                resultObject.put("failNum", 0);
                if(dataLog.size() > 0 ){
                    String logAddr =   createLog( userId, dataLog,record);
                    resultObject.put("logAddr", logAddr);
                }
                //更新任务记录
                record.setResult(JSONObject.toJSONString(resultObject,SerializerFeature.WriteMapNullValue));
                record.setEndtime(new Date());
                taskRecordService.save(record);
                throw new GwValidateException(e.getMessage());
            }
        }
    }

    public  Map<String, Object> importData(String unzipFileDir,String sourceId,String importId, Long userid, String sjpc,
                           String jcClueImportRels, Boolean isChange,String jcsj,List<Map<String, Object>> dataLog) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        Map<String, Object> errorMap = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>();
        File file = new File(unzipFileDir);
        URL url = null;
        File[] content = file.listFiles();
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".shp")) {
                url = content[j].toURI().toURL();
                break;
            }
        }
        if(url==null){
            errorMap.put("objectId",0);
            errorMap.put("type","error");
            errorMap.put("result","shape文件错误");
            dataLog.add(errorMap);
            throw new GwValidateException("shape文件错误");
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);

        String chasetStr = shpDataStore.getCharset().toString();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore
                .getFeatureSource(shpDataStore.getTypeNames()[0]);
        //获取图层原始坐标系，转换目标坐标系
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84, true);
        SimpleFeature sf = null;
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = featureSource.getFeatures();

        FeatureIterator<SimpleFeature> itertor = collection.features();
        //处理映射数据
        if(isChange){
            if(!StringUtils.isEmpty(jcClueImportRels)){
                JSONArray objects = JSONArray.parseArray(jcClueImportRels);
                List<JcClueImportRel> jcClueImportRelList = objects.toJavaList(JcClueImportRel.class);
                for(JcClueImportRel bean: jcClueImportRelList){
                    jcClueImportRelService.updateByPrimaryKey(bean);
                }
            }
        }
        //获取根节点sourceId
        String rootSourceId = jcClueSource.getfId();
       /* if(!jcClueSource.getfParentid().equals("-1")){
            JcClueSource  bean = jcClueSourceService.rootJcClueSource(rootSourceId);
            rootSourceId = bean.getfId();
        }*/
        List<JcClueImportRelView> jcClueImportRelViews = jcClueImportRelService.selectBySourceId(rootSourceId);
        if(jcClueImportRelViews.isEmpty()){
            errorMap.put("objectId",0);
            errorMap.put("type","error");
            errorMap.put("result","缺少导入配置");
            dataLog.add(errorMap);
            throw new RuntimeException("缺少导入配置");
        }
        List<Map<String, Object>> addDataCacheList = new ArrayList<>();

        int count = 0;
        Double area = 0D;
      //  String id = UUID.randomUUID().toString();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (itertor.hasNext()) {
            count++;
            //System.out.println("本次图斑总数量："+collection.size()+"，当前正在处理第"+count+"条数据...");
            HashMap<String, Object> map = new HashMap<>();

            sf = itertor.next();
            Geometry geo = (Geometry) sf.getDefaultGeometry();
            if(geo == null){
                continue;
            }
            //geo = wktToGeom(WKTUtil.geomToWkt(geo));
            map.clear();
            Geometry pt = geo.getCentroid();
            int proNum = getColNum(((Point) pt).getX());
            // 获取村级政区代码
            HashMap<String, Object> map1 = null;
            List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
            List<String> fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            try {
                map1 = getXzqdmSys(pt,geo,proNum);//getXzqdmSys(pt, defaultVersion.getVersion());
                if (map1 != null && map1.size() > 0) {
                    map.put("f_xzqdm", map1.get("xzqdmsys"));
                    map.put("f_xzqmc", map1.get("xzqmc"));
                    map.put("f_location", map1.get("location"));
                    map.put("f_area", map1.get("area"));
                    area += Double.valueOf(map1.get("area").toString());
                    //处理新增的市、县、镇、村
                    if(fields.contains("f_xzqdmcity") && StringUtils.isNotBlank((String) map1.get("xzqdmsys"))){
                        map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0,4)+"00");
                        map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0,6));
                        map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0,9));
                        map.put("f_xzqdmvillage", map1.get("xzqdmsys"));
                    }
                }
            }
            catch (SQLException e){
                logger.error("getXzqdmSys错误："+e.getMessage());
            }
            map.put("f_shape", "SRID=4490;"+WKTUtil.geomToWkt(geo));
            map.put("f_sjpc",sjpc);
            map.put("f_status",'0');
            map.put("f_state",'0');
            map.put("f_stage",'1');
            map.put("f_analysis",'0');
            if(fields.contains("f_registerstatus")){
                map.put("f_registerstatus",'0');
                map.put("f_mergestatus",'0');
            }
            map.put("f_userid",userid.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime",System.currentTimeMillis()/1000);
            map.put("f_import_recordid", importId);
            for (int i = 0; i < jcClueImportRelViews.size(); i++) {
                JcClueImportRelView t = jcClueImportRelViews.get(i);

                if(!"f_shape".equalsIgnoreCase(t.getfFieldname()) && !"f_sjpc".equalsIgnoreCase(t.getfFieldname()) && !"f_sourceid".equalsIgnoreCase(t.getfFieldname())){
                    String strValue = getStrValue(sf.getAttribute(t.getfFieldnameimport()), chasetStr);
                    switch (conType(t.getfFieldtype())){
                        case "varchar":
                            map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));
                            break;
                        case "text":
                            map.put(t.getfFieldname(),getStrValue(sf.getAttribute(t.getfFieldnameimport()),chasetStr));
                            break;
                        case "decimal":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Double value2 = Double.valueOf(strValue);
                                map.put(t.getfFieldname(), value2);
                            }
                            break;
                        case "timestamp":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                try {
                                    Date date = df.parse(strValue);
                                    Timestamp value5 = new Timestamp(date.getTime());
                                    map.put(t.getfFieldname(), value5);
                                }
                                catch (Exception e){
                                    DateTimeFormatter df1 = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                                    LocalDateTime localDateTime = LocalDateTime.parse(strValue, df1);
                                    Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                                    Timestamp value5 = new Timestamp(date.getTime());
                                    map.put(t.getfFieldname(), value5);
                                }
                            }
                            break;
                        case "int4":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Integer value3 = Integer.valueOf(strValue);
                                map.put(t.getfFieldname(), value3);
                            }
                            break;
                        case "geometry":
                            if(StringUtils.isBlank(strValue)){
                                break;
                            }else {
                                Geometry geo1 = WKTUtil.wktToGeom(strValue);
                                if (geo == null) {
                                    break;
                                } else {
                                    map.put(t.getfFieldname(), WKTUtil.geomToWkt(geo1));
                                }
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
            if(map.containsKey("f_id")){
                if(StringUtils.isBlank(map.get("f_id").toString())){
                    map.put("f_id", UUID.randomUUID().toString());
                }
            }
            else{
                map.put("f_id", UUID.randomUUID().toString());
            }
            addDataCacheList.add(map);

            // 每达到提交数量是，提交插入数据,并清空缓存集合
            if (addDataCacheList.size() == 200) {
                dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
                addDataCacheList.clear();
            }
        }
        if (!addDataCacheList.isEmpty()) {
            // 提交插入最后一批数据
            dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            addDataCacheList.clear();
        }
        shpDataStore.dispose();

        JcClueImportRecord record = jcClueImportRecordService.selectByPrimaryKey(importId);
        record.setfCount(count);
        record.setfJcmj(new BigDecimal(Double.valueOf(area)));
        jcClueImportRecordService.updateByPrimaryKeySelective(record);
         resultMap.put("count",count);
         return resultMap;
    }

        public static Geometry wktToGeom(String wkt) throws ParseException {
            Geometry geometry = null;
            WKTReader reader = new WKTReader();
            geometry = reader.read(wkt);
            geometry.setSRID(4490);
            return geometry;
        }

    /**
     * 处理上传用户轨迹数据
     * @param record
     */
    @Override
    public void handleCuleDataAsyncImport(TaskRecord record) throws Exception {
        logger.info("线索导入任务:"+record.getId()+"开始");
        HttpURLConnection conn = null;
        Map<String, TskUploadLogDTO> dataUploadLog = new HashMap();
        JcClueSource jcClueSource  = new JcClueSource();
        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        TskUploadErrorLogDTO erros = new TskUploadErrorLogDTO();
        Long userId =null;

        try{
            //解析参数，执行数据加载
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
             userId = paramsObject.getLongValue("userId");
            String sourceId = paramsObject.getString("sourceId");
            String tbtskDataLogId = paramsObject.getString("tbtskDataLogId");
            jcClueSource = jcClueSourceService.findOne(sourceId);

            // 日志记录
            tbtskDataLog = tbtskDataLogRepository.findById(tbtskDataLogId).get();

            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            if(paramsObject.containsKey("batch") && paramsObject.get("batch").equals(true)) {
                clueDataBatchImport(tbtskDataLog, record, paramsObject, uploadurl);
                return;
            }

            URL url = new URL(uploadurl);
            logger.info("线索导入任务:"+record.getId()+"数据url:"+uploadurl);
            if (url != null) {
                conn = (HttpURLConnection) url.openConnection();
                conn.setConnectTimeout(3 * 1000);
                conn.setRequestProperty("Charset", "UTF-8");
                File zipFile = null;
                File dir = new File(uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = File.createTempFile("tmp", ".gty", dir);
                FileUtils.copyInputStreamToFile(conn.getInputStream(), zipFile);
                String zipName = zipFile.getAbsolutePath();
                String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
                Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");
                String batchId = paramsObject.getString("batchId");
                //加载数据
                Map<String, List<String>> tempIds = importTaskData(1, tbtskDataLog.getId(), record,unzipFileDir, jcClueSource, userId, paramsObject
                        .getString("updateType"), dataUploadLog, batchId);
                Map<String, List<String>> ids = new HashMap<>();
                ids.computeIfAbsent("ADD", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("ADD", new ArrayList<>()));
                ids.computeIfAbsent("UPDATE", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList<>()));
                //生成日志
//                TbtskDataLog log = taskImportTaskDataService.createLog(userId, dataUploadLog, jcClueSource.getfName(), jcClueSource.getfId());
                createOrUpdateLog(tbtskDataLog, userId, dataUploadLog, jcClueSource);
                zipFile.delete();
                record.setLog(tbtskDataLog.getLogUrl());
                taskRecordService.save(record);
            }
        }catch (Exception e){
            logger.error("线索导入任务:"+record.getId()+"异常"+e.getMessage()+" "+ExceptionUtils.getStackTrace(e));
            if(conn != null){
                conn.disconnect();
            }
            //生成日志
//            TbtskDataLog log =taskImportTaskDataService.createLog( userId, dataUploadLog, jcClueSource.getfName(),jcClueSource.getfId());
            createOrUpdateLog(tbtskDataLog, userId, dataUploadLog, jcClueSource);
            record.setLog(tbtskDataLog.getLogUrl());
            taskRecordService.save(record);
            throw new GwValidateException(ExceptionUtils.getStackTrace(e));
        }finally {
            redisTemplate.opsForHash().delete(JobConstants.JOB_REDIS_WEB, tbtskDataLog.getId());
            if(conn != null){
                conn.disconnect();
            }
        }
    }


    private void clueDataBatchImport(TbtskDataLog tbtskDataLog, TaskRecord record, JSONObject paramsObject, String uploadurl) {
        DateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        HttpURLConnection httpURLConnection = null;
        String sourceId = paramsObject.getString("sourceId");
        Long userId = paramsObject.getLongValue("userId");
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);

        List<Map<String, TskUploadLogDTO>> allDataUploadLogList = new ArrayList<>();
        List<TskUploadErrorLogDTO> errosList = new ArrayList<>();
        List<String> fileNameList = new ArrayList<>();
        try {
            // 统一资源
            URL url = new URL(uploadurl);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000 * 60 * 10);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 文件大小
            int fileLength = httpURLConnection.getContentLength();
            // 控制台打印文件大小
            /*  logger.info(String.format("%s", "您要下载的文件大小为:", fileLength / (1024 *1024) + "MB"));*/
            // 建立链接从请求中获取数据
            URLConnection con = url.openConnection();
            File zipFile = null;
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".zip", dir);
            FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019", "UTF-8");

            File file = new File(unzipFileDir);
            File[] content = file.listFiles();
            int gtyFileNum = Arrays.stream(content).filter(u -> u.getName().endsWith(".gty")).collect(Collectors.toList()).size();

            for (int j = 0, ln = content.length; j < ln; ++j) {
                if (content[j].getName().endsWith(".gty")) {
                    dealSingleClueGty(gtyFileNum, tbtskDataLog.getId(), record, content[j], allDataUploadLogList);
                    fileNameList.add(content[j].getName());
                }
            }
            createBatchClueLog(tbtskDataLog, userId, allDataUploadLogList, jcClueSource, fileNameList);
            record.setEndtime(new Date());
            record.setState(3); //成功
            taskRecordService.save(record);
        } catch (Exception e) {
            e.printStackTrace();
            //生成日志
            createBatchClueLog(tbtskDataLog, userId, allDataUploadLogList, jcClueSource, fileNameList);
            record.setEndtime(new Date());
            record.setState(4); //成功
            record.setRemark(e.getMessage());
            taskRecordService.save(record);
        } finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            logger.info("JobRunTask-rateJobDataImportInner 平台任务数据加载执行结束" + record.getId() + "-" + record.getState() + "-" + df
                    .format(new Date()));
        }
    }


    private void createBatchClueLog(TbtskDataLog tbtskDataLog, Long userId, List<Map<String, TskUploadLogDTO>> dataUploadLogList,
                                            JcClueSource jcClueSource, List<String> fileNameList) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = jcClueSource.getfName() + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
        String fileName1 = jcClueSource.getfName() + "-数据导入日志-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
        String localFullFileName = tempDir + "/" + fileName;
        WritableWorkbook wwb = null;
        try {
            File file = new File(localFullFileName);
            if(wwb == null || wwb.getSheets() == null || wwb.getSheets().length <= 0) {
                wwb = Workbook.createWorkbook(file);
            }
            int i = 0;
            for (Map<String, TskUploadLogDTO> dataUploadLog : dataUploadLogList) {
                String gtyName = fileNameList.get(i);
                Integer successCount = 0; Integer failCount = 0;Integer skipCount = 0;
                if (!dataUploadLog.isEmpty()) {
                    String name = landUserRepository.queryUserById(userId).getName();
                    List<Map<String, Object>> data = new ArrayList<>();
                    if(dataUploadLog.size() ==1 && dataUploadLog.containsKey("error")){
                        Map map = JSONObject.parseObject(JSONObject.toJSONString(dataUploadLog.get("error")), Map.class);
                        map.put("uploadUser", name);
                        map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        map.put("error",map.get("errorInfo"));
                        map.put("updateType",map.get("uploadType"));
                        failCount +=  Integer.valueOf(map.get("failNum").toString());
                        data.add(map);
                    }else{
                        // 日志记录
                        for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                            Map map = entry.getValue().toMap();
                            map.put("uploadUser", name);
                            map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            successCount +=  Integer.valueOf(map.get("success").toString());
                            failCount +=  Integer.valueOf(map.get("fail").toString());
                            skipCount +=  Integer.valueOf(map.get("skip").toString());
                            data.add(map);
                        }
                    }

                    String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
                    String colName = TskUploadLogDTO.getExcelColName() + ",上传人,上传时间";

                    List<ExcelData> excelDataLst = new ArrayList<>();
                    ExcelData dataHz = new ExcelData();
                    dataHz.setData(data);
                    dataHz.setCol(col);
                    dataHz.setHeader(colName);
                    dataHz.setSheetIndex(i++);
                    dataHz.setSheetName(gtyName);
                    excelDataLst.add(dataHz);
                    try {
                        ExcelUtil.createAndWriteExcelMultipleSheets(wwb, excelDataLst);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            wwb.write();
            wwb.close();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {

        }
        String sendObjName = "taskManagerUploadLog/" + fileName1;
        String downloadPath = ossOperatorService.sendObject2Oss(sendObjName, localFullFileName);
        tbtskDataLog.setLogUrl(downloadPath);
        tbtskDataLogService.saveDataLog(tbtskDataLog);
    }



    public void createOrUpdateLog(TbtskDataLog tbtskDataLog, Long userId, Map<String, TskUploadLogDTO> dataUploadLog, JcClueSource jcClueSource) {
        Integer successCount = 0; Integer failCount = 0;Integer skipCount = 0;
        if (!dataUploadLog.isEmpty()) {
            String name = landUserRepository.queryUserById(userId).getName();
            List<Map<String, Object>> data = new ArrayList<>();
            if(dataUploadLog.size() ==1 && dataUploadLog.containsKey("error")){
                Map map = JSONObject.parseObject(JSONObject.toJSONString(dataUploadLog.get("error")), Map.class);
                map.put("uploadUser", name);
                map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                map.put("error",map.get("errorInfo"));
                map.put("updateType",map.get("uploadType"));
                failCount +=  Integer.valueOf(map.get("failNum").toString());
                data.add(map);
            }else{
                // 日志记录
                for (Map.Entry<String, TskUploadLogDTO> entry : dataUploadLog.entrySet()) {
                    Map map = entry.getValue().toMap();
                    map.put("uploadUser", name);
                    map.put("uploadDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    successCount +=  Integer.valueOf(map.get("success").toString());
                    failCount +=  Integer.valueOf(map.get("fail").toString());
                    skipCount +=  Integer.valueOf(map.get("skip").toString());
                    data.add(map);
                }
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String fileName = jcClueSource.getfName() + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
            String fileName1 = jcClueSource.getfName() + "-数据导入日志-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";

            String col = TskUploadLogDTO.getExcelCol() + ",uploadUser,uploadDate";
            String colName = TskUploadLogDTO.getExcelColName() + ",上传人,上传时间";
            String filePath = null;
            try {
                filePath = ExcelUtil.CreateExcel(data, tempDir, fileName, col, colName, "日志导出");
            } catch (Exception e) {
                e.printStackTrace();
            }
            String sendObjName = "taskManagerUploadLog/" + fileName1;
            String downloadPath = ossOperatorService.sendObject2Oss(sendObjName, filePath);
            tbtskDataLog.setLogUrl(downloadPath);
            tbtskDataLog.setSuccessCount(successCount.toString());
            tbtskDataLog.setFailCount(failCount.toString());
            tbtskDataLog.setSkipCount(skipCount.toString());
            tbtskDataLogService.saveDataLog(tbtskDataLog);
        }
    }

    private void dealSingleClueGty(int gtyFileNum, String tskDataLogId, TaskRecord record, File item, List<Map<String, TskUploadLogDTO>> allDataUploadLogList) {
        Map<String, TskUploadLogDTO> dataUploadLog = new HashMap();
        Long userId =null;
        try{
            //解析参数，执行数据加载
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            userId = paramsObject.getLongValue("userId");
            String sourceId = paramsObject.getString("sourceId");
            JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File zipFile = File.createTempFile("tmp", ".gty", dir);
            FileInputStream fileInputStream = new FileInputStream(item);
            FileUtils.copyInputStreamToFile(fileInputStream, zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");
            String batchId = paramsObject.getString("batchId");
            //加载数据
            Map<String, List<String>> tempIds = importTaskData(gtyFileNum, tskDataLogId, record,unzipFileDir, jcClueSource, userId, paramsObject
                    .getString("updateType"), dataUploadLog, batchId);
            Map<String, List<String>> ids = new HashMap<>();
            ids.computeIfAbsent("ADD", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("ADD", new ArrayList<>()));
            ids.computeIfAbsent("UPDATE", k -> new ArrayList<>()).addAll(tempIds.getOrDefault("UPDATE", new ArrayList<>()));
            allDataUploadLogList.add(dataUploadLog);
            //生成日志
//                TbtskDataLog log = taskImportTaskDataService.createLog(userId, dataUploadLog, jcClueSource.getfName(), jcClueSource.getfId());
//            createOrUpdateLog(tbtskDataLog, userId, dataUploadLog, jcClueSource);
            zipFile.delete();

        }catch (Exception e){
            logger.error("线索导入任务:"+record.getId()+"异常"+e.getMessage()+" "+ExceptionUtils.getStackTrace(e));
            //生成日志
//            TbtskDataLog log =taskImportTaskDataService.createLog( userId, dataUploadLog, jcClueSource.getfName(),jcClueSource.getfId());
            allDataUploadLogList.add(dataUploadLog);
        }finally {

        }
    }


    public Map<String, List<String>> importTaskData(int gtyFileNum, String tskDataLogId, TaskRecord taskRecord,  String unzipFileDir, JcClueSource jcClueSource, Long userId,String updateType,
                                                    Map<String, TskUploadLogDTO> dataUploadLog, String batchId) throws Exception {
        JSONObject jsonParam =JSONObject.parseObject(taskRecord.getParam());
        URL url = null;
        File file = null;
        file = new File(unzipFileDir);
        File[] content = file.listFiles();
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".shp")) {
                url = content[j].toURI().toURL();
                break;
            }
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        String chasetStr = shpDataStore.getCharset().toString();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore
                .getFeatureSource(shpDataStore.getTypeNames()[0]);
        //获取图层原始坐标系，转换目标坐标系
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84, true);
        SimpleFeature sf = null;
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = featureSource.getFeatures();
        // 必有字段判断
        List<AttributeDescriptor> attributeDescriptors = collection.getSchema().getAttributeDescriptors();
        // 必有字段集合
        List<JcClueFields> mustFields = jcClueFieldsService.getClueMustFieldsByTableid(jcClueSource.getfId(),1);
        if (!mustFields.isEmpty()) {
            List<String> fieldNames = attributeDescriptors.stream().map(a -> a.getLocalName()).collect(Collectors.toList());
            for (JcClueFields mustField : mustFields) {
                if (!fieldNames.contains(mustField.getfFieldname())) {
                    TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
                    tskUploadLogDTO.setUploadType("0".equals(updateType) ? "追加" : "覆盖");
                    tskUploadLogDTO.setErrorInfo("必有字段" + mustField.getfAlias() + "不存在,请检查数据。");
                    dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
                    throw new RuntimeException("必有字段" + mustField.getfAlias() + "不存在,请检查数据。");
                }
            }
        }

        if (collection.size() > 20000) {
            TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
            tskUploadLogDTO.setErrorInfo("加载线索数量一次不能超过20000");
            tskUploadLogDTO.setUploadType("0".equals(updateType) ? "追加" : "覆盖");
            dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
            throw new RuntimeException("加载线索数量一次不能超过20000");
        }

        FeatureIterator<SimpleFeature> itertor = collection.features();

        Map<String, List<String>> map = new HashMap<>();
        List<Map<String, Object>> addDataCacheList = new ArrayList<>();
        List<Map<String, Object>> updateDataCacheList = new ArrayList<>();
        List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
        // 唯一值字段集合
        List<JcClueFields> uniqueFields = jcClueFieldsService.getClueUniqueFieldsByTableid(jcClueSource.getfId(),1);
        if (uniqueFields.isEmpty()) {
            TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
            tskUploadLogDTO.setErrorInfo("唯一值字段不存在,请检查任务配置。");
            tskUploadLogDTO.setUploadType("0".equals(updateType) ? "追加" : "覆盖");
            dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
            throw new RuntimeException("唯一值字段不存在,请检查任务配置。");
        }
        //获取任务范围
        /*  List<BizArea> bizAreas = bizAreaRepository.queryByBizId(tskTaskBiz.getId());
        Set<String> areaCodes = bizAreas.stream().map(bizArea -> bizArea.getArea()).collect(Collectors.toSet());*/
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        int s = 0;
        int importTbSize = collection.size();
        while (itertor.hasNext()) {
            s++;
            String importProgress  = new BigDecimal(s * 100.0 / importTbSize / gtyFileNum).setScale(2, BigDecimal.ROUND_HALF_UP).toString() + "%";
            redisTemplate.opsForHash().put(JobConstants.JOB_REDIS_WEB, tskDataLogId, importProgress);

            sf = itertor.next();

            Map<String, Object> result = saveData(jcClueSource, sf, chasetStr, userId.toString(),updateType,
                    addDataCacheList, updateDataCacheList, allFields, uniqueFields, null,batchId,defaultVersion);
            UpResultEnum r = (UpResultEnum) result.get("type");
            String xzqdm = ((String) result.get("xzqdm")== null || "".equals((String) result.get("xzqdm")) )?"政区代码":(String) result.get("xzqdm");
            TskUploadLogDTO tskUploadLogDTO = dataUploadLog.computeIfAbsent(xzqdm, k -> new TskUploadLogDTO(xzqdm, updateType));
            tskUploadLogDTO.addTotal(1L);
            switch (r) {
                case ADD:
                    tskUploadLogDTO.addSuccessNum(1L);
                    map.computeIfAbsent("ADD", k -> new ArrayList<>()).add((String) result.get("f_id"));
                    break;
                case UPDATE:
                    tskUploadLogDTO.addSuccessNum(1L);
                    map.computeIfAbsent("UPDATE", k -> new ArrayList<>()).add((String) result.get("f_id"));
                    break;
                case SKIP:
                    tskUploadLogDTO.addSkipNum(1L);
                    break;
                case ERROR:
                    Map<UpResultErrorEnum, Long> errorEnumLongMap = tskUploadLogDTO.getErrorEnumLongMap();
                    UpResultErrorEnum e = (UpResultErrorEnum) result.getOrDefault("error", UpResultErrorEnum.OTHER);
                    // 统计错误的类型
                    errorEnumLongMap.merge(e, 1L, (oldValue, newValue) -> oldValue + newValue);
                    tskUploadLogDTO.addFailNum(1L).appendErrorInfo((String) result.getOrDefault("errorInfo", ""));
                    break;
                default:
                    break;
            }

            // 每达到提交数量是，提交插入数据,并清空缓存集合
            if (addDataCacheList.size() == 200) {
                dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
                //根据导入的批量变更数量和面积
               /* if(StringUtils.isNotBlank(batchId)){
                    JcClueImportRecord record = jcClueImportRecordService.selectByPrimaryKey(batchId);
                    record.setfCount(record.getfCount()+addDataCacheList.size());
                    Double area = 0.0D;
                    for(Map<String, Object> map2 : addDataCacheList ){
                        if(map2.containsKey("f_area") && map2.get("f_area")!=null){
                            area += Double.parseDouble(map2.get("f_area").toString());
                        }
                    }
                    if(record.getfJcmj()!=null){
                        area +=record.getfJcmj().doubleValue();
                    }
                    record.setfJcmj(new BigDecimal(Double.valueOf(area)));
                    jcClueImportRecordService.updateByPrimaryKeySelective(record);
                }*/


                addDataCacheList.clear();
                logger.info("数量----------------"+s);
            }
            //更新当前任务处理图斑数量--方便计算进度
            if(s%200==0) {
                jsonParam.put("curCount", s);
                taskRecord.setParam(jsonParam.toJSONString());
                taskRecordService.save(taskRecord);
            }
        }

        jsonParam.put("curCount", s);
        taskRecord.setParam(jsonParam.toJSONString());
        taskRecordService.save(taskRecord);

        logger.info("数据加载最后一步-------------"+s);
        if (!addDataCacheList.isEmpty()) {
            // 提交插入最后一批数据
            dataBizService.insertDatasBatch(jcClueSource.getfTablename(), addDataCacheList, "f_shape");
            //根据导入的批量变更数量和面积
            /*if(StringUtils.isNotBlank(batchId)){
                JcClueImportRecord record = jcClueImportRecordService.selectByPrimaryKey(batchId);
                record.setfCount(record.getfCount()+addDataCacheList.size());
                Double area = 0.0D;
               for(Map<String, Object> map2 : addDataCacheList ){
                   if(map2.containsKey("f_area") && map2.get("f_area")!=null){
                       area += Double.parseDouble(map2.get("f_area").toString());
                   }
               }
               if(record.getfJcmj()!=null){
                   area +=record.getfJcmj().doubleValue();
               }
                record.setfJcmj(new BigDecimal(Double.valueOf(area)));
                jcClueImportRecordService.updateByPrimaryKeySelective(record);
            }*/
            addDataCacheList.clear();
        }
        //更新数据批次总量及面积
        if(StringUtils.isNotBlank(batchId)){
            JcClueImportRecord record = jcClueImportRecordService.selectByPrimaryKey(batchId);
            String sql ="select count(1) count,sum(f_area) area  from "+jcClueSource.getfTablename()+" where f_import_recordid  ='"+batchId+"';";
            List<Map<String, Object>> list = jdbcTemplate.queryForList(sql);
            if (!list.isEmpty() && list.size() > 0) {
                String count =  list.get(0).get("count").toString();
                String area =  list.get(0).get("area").toString();
                record.setfJcmj( new BigDecimal(Double.valueOf(area)));
                record.setfCount(Integer.parseInt(count));
                jcClueImportRecordService.updateByPrimaryKeySelective(record);
            }
        }
        return map;
    }

    private Map<String, Object> saveData( JcClueSource jcClueSource, SimpleFeature sf, String chasetStr, String
            userId, String updateType, List<Map<String, Object>> addDataList, List<Map<String, Object>>
            updateDataList, List<JcClueFields> allFields, List<JcClueFields> uniqueFields, Set<String> areaCodes,
                                          String batchId,RegionVersion defaultVersion) throws Exception {

        //RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        HashMap<String, Object> map = new HashMap<>();
        HashMap<String, Object> updateMap = new HashMap<>();
        List<String> fieldDefault = new ArrayList<>();

        String fieldName = "";
        String fieldType = "";
        String alias = "";
        Integer outWork = -1;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> result = new HashMap<>();
        //插入数据
        for (JcClueFields field : allFields) {

            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            fieldType = TskTaskBizDBUtil.getDBType(fieldType);
            alias = field.getfAlias();
            outWork = field.getfIsWebCheck();

            if ("f_lat".equals(fieldName) || "f_lon".equals(fieldName)) {
                continue;
            }
            if ("f_shape".equals(fieldName)) {
                continue;
            }
            if (field.getfDefaultvalue() != null && !"".equalsIgnoreCase(field.getfDefaultvalue())) {
                fieldDefault.add(fieldName);
            }
            map.put(fieldName, field.getfDefaultvalue());
            //校验shape数据类型
            Boolean dataType = false;
            if("f_shape".equalsIgnoreCase(fieldName)){
                if(fieldType.equalsIgnoreCase("geometry")){
                    Geometry geo = (Geometry) sf.getDefaultGeometry();
                        if(geo.getGeometryType().equals("Polygon") || geo.getGeometryType().equals("MultiPolygon")){
                            dataType = true;
                        }
                    }else{
                    dataType = false;
                  }
                if(!dataType){
                    String xzqdm = (String) map.get("f_xzqdm");
                    result.put("xzqdm", xzqdm);
                    result.put("type", UpResultEnum.ERROR);
                    result.put("error", UpResultErrorEnum.DATA_TYPE_ERROR);
                    result.put("errorInfo", "数据类型不匹配");
                    return result;
                }
            }
            boolean isOut = (field.getfFieldInnerOuterSys() & FieldGroupTypeConstant.OUTER_FIELD) == FieldGroupTypeConstant.OUTER_FIELD;
            addDatatoMap(map, sf, fieldType, fieldName, alias, chasetStr, isOut ? 1 : field.getfNullable()
                    , field.getfOrder(), field.getfDefaultvalue());
            if (SHAPE_UPDATE.equals(updateType)) {
                // & 判断是否是内业字段  例如数字是5( 1 + 4) 与 1求&得出 1 即是内业
                if ((field.getfFieldInnerOuterSys().intValue() & FieldGroupTypeConstant.INNER_FIELD) == FieldGroupTypeConstant.INNER_FIELD) {
                    updateMap.put(fieldName, field.getfDefaultvalue());
                    addDatatoMap(updateMap, sf, fieldType, fieldName, alias, chasetStr, isOut ? 1 : field
                            .getfNullable(), field.getfOrder(), field.getfDefaultvalue());
                }
            }
        }
        List<String> fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        map.put("f_id", UUID.randomUUID().toString());
        map.put("f_sjpc",batchId);
        map.put("f_status",'0');
        map.put("f_state",'0');
        map.put("f_stage",'1');
        map.put("f_analysis",'0');
        if(fields.contains("f_registerstatus")){
            map.put("f_registerstatus",'0');
            map.put("f_mergestatus",'0');
        }
        map.put("f_userid",userId);
        map.put("f_sourceid", jcClueSource.getfId());
        map.put("f_createtime",System.currentTimeMillis()/1000);
        map.put("f_import_recordid", batchId);

        // 默认赋上村级政区代码
        List<JcClueFields> sysFields = allFields.stream().filter(t -> "f_xzqdm".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList());
        if (sysFields != null && sysFields.size() > 0) {
            // 包含这个字段的表，赋上系统政区代码值
            Geometry geo = (Geometry) sf.getDefaultGeometry();
            Geometry pt = geo.getCentroid();
            int proNum = getColNum(((Point) pt).getX());
            // 获取村级政区代码
            HashMap<String, Object> map1 = getXzqdmSys(pt,geo,proNum);
            map.put("f_xzqdm", map1.get("xzqdmsys"));
            map.put("f_xzqmc", map1.get("xzqmc"));
            map.put("f_location", map1.get("location"));
            map.put("f_shape", "SRID=4490;"+WKTUtil.geomToWkt(geo));
            map.put("f_area", map1.get("area"));

            updateMap.put("f_xzqdm", map1.get("xzqdmsys"));
            updateMap.put("f_xzqmc", map1.get("xzqmc"));
            updateMap.put("f_location", map1.get("location"));
            updateMap.put("f_area", map1.get("area"));
            updateMap.put("f_shape", "SRID=4490;"+WKTUtil.geomToWkt(geo));

            //处理新增的市、县、镇、村
            if(fields.contains("f_xzqdmcity") &&  StringUtils.isNotBlank((String) map1.get("xzqdmsys"))){
                map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0,4)+"00");
                map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0,6));
                map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0,9));
                map.put("f_xzqdmvillage", map1.get("xzqdmsys"));
                updateMap.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0,4)+"00");
                updateMap.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0,6));
                updateMap.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0,9));
                updateMap.put("f_xzqdmvillage", map1.get("xzqdmsys"));
            }
        }

        if (map.containsKey("f_xzqdm") && StringUtils.isNotBlank((String) map.get("f_xzqdm"))) {
            String xzqdm = (String) map.get("f_xzqdm");
            if(xzqdm.endsWith("000") || xzqdm.endsWith("000000")){
                xzqdm = xzqdm.replaceAll("000","");
            }
            result.put("xzqdm", xzqdm);
            //校验f_xzqdm 是否存在政区表中
            boolean xzqdmisExist = true;
            if (xzqdm.length() <= 6) {
                Region region = regionDao.findByCodeAndVersion(xzqdm,  defaultVersion!=null?defaultVersion.getVersion():"2018");
                if (region == null) {
                    xzqdmisExist = false;
                }
            } else if (xzqdm.length() == 9) {
                String name = regionTownRepository.getNameByCodeAndVersion(xzqdm,  defaultVersion!=null?defaultVersion.getVersion():"2018");
                if (name == null) {
                    xzqdmisExist = false;
                }
            } else if (xzqdm.length() == 12) {
                String name = regionvillageDao.getNameByCodeAndVersion(xzqdm, defaultVersion!=null?defaultVersion.getVersion():"2018");
                if (name == null) {
                    xzqdmisExist = false;
                }
            }
            if (!xzqdmisExist) {
                result.put("xzqdm", xzqdm);
                result.put("type", UpResultEnum.ERROR);
                result.put("error", UpResultErrorEnum.XZQDM_ERROR);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (JcClueFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }


           /* // 行政区范围不在任务定义的范围则不加入
            if (!XzqdmUtil.xzqdmInAreaCodes(areaCodes, xzqdm)) {
                result.put("xzqdm", xzqdm);
                result.put("type", UpResultEnum.ERROR);
                result.put("error", UpResultErrorEnum.NOT_IN_AREA);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (JcClueFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }*/
            List<Map> maps = new ArrayList<>();
            //唯一值校验
            if (uniqueFields != null && !uniqueFields.isEmpty()) {

                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("select f_id from " + jcClueSource.getfTablename() + " where 1=1 and f_import_recordid = '"+batchId+"' ");
                List<Object> values = new ArrayList<>(uniqueFields.size());
                for (JcClueFields tbtskFields : uniqueFields) {
                    stringBuilder.append(" and ");
                    stringBuilder.append(tbtskFields.getfFieldname());
                    stringBuilder.append(" = ?");
                    values.add(map.get(tbtskFields.getfFieldname()));
                }

                maps = jdbcTemplate.query(stringBuilder.toString(), values.toArray(new Object[0]), new RowMapper<Map>() {
                    @Override
                    public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                        Map ha = new HashMap();
                        rs.getString("f_id");
                        ha.put("f_id", rs.getString("f_id"));
                        return ha;
                    }
                });
            }

            // 跳过--有重复记录且追加新增模式跳过
            if (!maps.isEmpty() && SHAPE_APPEND.equals(updateType)) {
                result.put("type", UpResultEnum.SKIP);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (JcClueFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            String name = regionService.getNameAndVersion(xzqdm,defaultVersion.getVersion());
            if (StringUtils.isNotBlank(name)) {
                map.put("f_xzqmc", name);
                if (updateMap.containsKey("f_xzqmc")) {
                    updateMap.put("f_xzqmc", name);
                }
                if (updateMap.containsKey("f_createtime")) {
                    updateMap.put("f_createtime", System.currentTimeMillis() + "");
                }
                if (updateMap.containsKey("f_userid")) {
                    updateMap.put("f_userid", userId);
                }
            }
            // 没有定义唯一值
            if (maps.isEmpty()) {
                result.put("f_id", map.get("f_id"));
                result.put("type", UpResultEnum.ADD);
                //解析默认值
                resolveFieldDefault(map, fieldDefault);
                addDataList.add(map);
                // 覆盖更新
            } else if (maps.size() > 0 && SHAPE_UPDATE.equals(updateType)) {
                String fid = (String) maps.get(0).get("f_id");

                result.put("f_id", fid);
                result.put("type", UpResultEnum.UPDATE);
                //解析默认值
                resolveFieldDefault(updateMap, fieldDefault);
                updateMap.remove("f_id");
                try {
                    //根据导入的批量变更数量和面积
                   /* if(StringUtils.isNotBlank(batchId)){
                        JcClueImportRecord record = jcClueImportRecordService.selectByPrimaryKey(batchId);
                        record.setfCount(record.getfCount()+1);
                        Double area = 0.0D;
                        if(updateMap.containsKey("f_area") && updateMap.get("f_area")!=null){
                            area =  Double.parseDouble(updateMap.get("f_area").toString());
                            if(record.getfJcmj()!=null){
                                area += record.getfJcmj().doubleValue();
                            }
                        }
                        record.setfJcmj( new BigDecimal(Double.valueOf(area)));
                        jcClueImportRecordService.updateByPrimaryKeySelective(record);
                    }*/
                    dataBizService.updateData(jcClueSource.getfTablename(), updateMap, " f_id = '" + fid + "'");
                } catch (Exception e) {
                    result.put("type", UpResultEnum.ERROR);
                    result.put("error", UpResultErrorEnum.OTHER);
                    result.put("errorInfo", e.getMessage());
                    logger.error(e.getMessage(), e);
                }
                //updateDataList.add(map);
            }
            return result;
        } else {
            result.put("type", UpResultEnum.ERROR);
            result.put("error", UpResultErrorEnum.MISS_XZQDM_FIELD);
            return result;
        }
    }

    void addDatatoMap(Map map, SimpleFeature sf, String fieldType, String fieldName, String rname,
                      String chasetStr, Integer nullable, Integer order, String defaultValue) throws Exception {

        DecimalFormat format = new DecimalFormat("######0.0000000");
        switch (fieldType) {
            case "varchar":
                String value1 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (value1 == null || "null".equalsIgnoreCase(value1) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "不能为空");
                    } else {
                        map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value1);
                }
                break;
            case "decimal":
                if (!"f_lat".equals(fieldName) && !"f_lon".equals(fieldName)) {
                    String tmp1 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                    if (tmp1 == null || isMessyCode(tmp1) || "".equals(tmp1)) {
                        if (order != null && nullable == 0) {
                            throw new GwValidateException(rname + "不能为空");
                        } else {
                              map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Double.valueOf(defaultValue));
                           /* map.put(fieldName, defaultValue);*/
                        }
                    } else {
                        Double value2 = Double.valueOf(tmp1);
                        map.put(fieldName, value2);
                    }
                }
                break;
            case "int4":
                String tmp2 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp2 == null || isMessyCode(tmp2) || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "不能为空");
                    } else {
                         map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Integer.valueOf(defaultValue));
                       /* map.put(fieldName, defaultValue);*/
                    }
                } else {
                    Integer value3 = Integer.valueOf(tmp2);
                    map.put(fieldName, value3);
                }
                break;
            case "timestamp":
                String tmp3 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp3 == null || isMessyCode(tmp3) || "".equals(tmp3)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "不能为空");
                    } else {
                        map.put(fieldName, null);
                    }
                } else {
                    try {
                        DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = df.parse(tmp3);
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(fieldName, value5);
                    } catch (java.text.ParseException e) {
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                        LocalDateTime localDateTime = LocalDateTime.parse(tmp3, df);
                        Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(fieldName, value5);
                    }
                }
                break;
            case "text":
                String value2 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (value2 == null || "null".equalsIgnoreCase(value2) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        throw new GwValidateException(rname + "不能为空");
                    } else {
                        map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value2);
                }
                break;
            case "geometry":
                Geometry geo = (Geometry) sf.getDefaultGeometry();
                if ("f_shape".equalsIgnoreCase(fieldName)) {
                    if (geo == null) {
                        break;
                    } else {
                      /*  map.put(fieldName, WKTUtil.geomToWkt(geo));*/
                        map.put("f_shape", "SRID=4490;"+WKTUtil.geomToWkt(geo));
                            if(geo.getGeometryType().equals("Point")){
                                Geometry geo1 = (Point) sf.getDefaultGeometry();
                                if (geo1 != null) {
                                    map.put("f_lat", format.format( ((Point) geo1).getY()));
                                    map.put("f_lon", format.format( ((Point) geo1).getX()));
                                }else {
                                    map.put("f_lat", "0.0");
                                    map.put("f_lon", "0.0");
                                }
                            }else{
                                Point point = geo.getCentroid();
                                if (point != null) {
                                    map.put("f_lat", format.format(point.getY()));
                                    map.put("f_lon", format.format(point.getX()));
                                } else {
                                    map.put("f_lat", "0.0");
                                    map.put("f_lon", "0.0");
                                }
                            }
                    }
                }

                break;
            default:
                break;
        }
    }

    /**
     * 解析字段默认值
     *
     * @param map
     * @param fieldDefaults
     */
    public void resolveFieldDefault(HashMap<String, Object> map, List<String> fieldDefaults) {
        if (fieldDefaults.size() > 0) {
            for (String fieldDefault : fieldDefaults) {
                try {
                    if (map.containsKey(fieldDefault)) {
                        if (map.get(fieldDefault) != null) {
                            if (!map.get(fieldDefault).toString().contains("fields")) {
                                if ("{\"value\":null}".equalsIgnoreCase(map.get(fieldDefault).toString())) {
                                    map.put(fieldDefault, null);
                                }
                                continue;
                            } else {
                                JSONObject jsonObject = JSONObject.parseObject(map.get(fieldDefault).toString());
                                //场景一：fields为空时
                                if ("".equalsIgnoreCase(jsonObject.getString("fields")) || jsonObject.getString("fields") == null) {
                                    map.put(fieldDefault, jsonObject.getString("value"));
                                } else if (!"".equalsIgnoreCase(jsonObject.getString("fields"))) {
                                    String[] fieldArray = jsonObject.getString("fields").split(",");
                                    //根据表达式转换数据计算默认值
                                    map.put(fieldDefault, jexlConverData(map, fieldArray, jsonObject.getString("value")));
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    map.put(fieldDefault, null);
                }
            }
        }
    }

    /**
     * 根据表达式转换数据
     *
     * @param map
     * @param fieldArray 涉及字段
     * @param jexlExp    表达式
     * @return
     */
    public Object jexlConverData(HashMap<String, Object> map, String[] fieldArray, String jexlExp) {
        JexlBuilder jexlB = new JexlBuilder();
        org.apache.commons.jexl3.JexlEngine jexl = jexlB.create();
        //用ExpressionFactory类的静态方法createExpression创建一个Expression对象
        JexlExpression e = jexl.createExpression(jexlExp);
        //初始化一个JexlContext对象，它代表一个执行JEXL表达式的上下文环境
        JexlContext jc = new MapContext();
        for (String field : fieldArray) {
            //向执行JEXL表达式的上下文环境的变量字典中存入变量对应值
            jc.set(field, map.get(field));
        }
        //对这个Expression对象求值，传入执行JEXL表达式的上下文环境对象
        Object obj = e.evaluate(jc);
        return obj;
    }

    @Override
    public void importClueByTaskData(Long userId,String taskId,String tbId) throws Exception {
        Integer type = 1; // 1 巡查任务线索 2 卫片执法
        TskTaskBiz taskBiz = tskTaskBizService.findOne(taskId);
        if(taskBiz == null){
            throw new RuntimeException("任务不存在");
        }
        String tableNameByBizId = tskTaskBizService.getTableNameByBizId(taskId);
        if (StringUtils.isBlank(tableNameByBizId)) {
            throw new RuntimeException("任务表不存在");
        }
        JcClueSource jcClueSource = null;
        Map<String, Object> errorMap = new HashMap<>();
        List<JcClueImportTaskRel> rels = jcClueSourceService.findTaskMapperSchemes(101L, taskId,"2");
         if(!rels.isEmpty()){
             jcClueSource =  jcClueSourceService.findOne(rels.get(0).getfSourceid());
         }else{
             errorMap.put("objectId", 0);
             errorMap.put("type", "error");
             errorMap.put("result", "缺少导入配置");
             throw new RuntimeException("缺少导入配置");
         }
        List<JcClueImportRecord> clueImportRecords = jcClueImportRecordService.selectBySourceId(jcClueSource.getfId());
        JcClueImportRecord jcClueImportRecord = null;
        if(!clueImportRecords.isEmpty()){
            jcClueImportRecord = clueImportRecords.get(0);
        }

        HashMap<String, Object> map = new HashMap<>();
       // SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<TbtskFields> fieldsList  = tskTaskBizService.findTbtskFieldsByTaskId(taskId);
        List<String> fields = new ArrayList<>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        Map datamap = dataBizService.selectFieldByID(tableNameByBizId, fields,"f_id", "'"+tbId+"'");
        if (datamap != null) {
            String clueId = UUID.randomUUID().toString();
            //插入关联数据
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\"," +
                    " \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
            stringBuffer.append(" VALUES ( uuid_generate_v1(),'"+jcClueSource.getfId()+"'," +
                            "'"+jcClueImportRecord==null?"":jcClueImportRecord.getfId()+"','"+clueId+"','"+taskId+"'," +
                    "'"+tbId+"',now(),null,'2')");
            jdbcTemplate.execute(stringBuffer.toString());
            if(!rels.get(0).getTaskRelFields().isEmpty()){
                for(JcClueImportTaskRelFields fields1 : rels.get(0).getTaskRelFields()){
                    map.put(fields1.getfTarFieldname(),datamap.get(fields1.getfOriFieldname()));
                }
            }
            Double area = 0.0D;
            if(datamap.get("f_tbmj") != null && StringUtils.isNotBlank(datamap.get("f_tbmj").toString())){
                area = Double.parseDouble(datamap.get("f_tbmj").toString());
            }
            List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
            List<String> cluefields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            map.put("f_id",clueId);
            map.put("f_xzqdm", datamap.get("f_xzqdmsys"));
            map.put("f_xzqmc", datamap.get("f_xzqmc"));
            map.put("f_location", datamap.get("f_xzqmc"));
            map.put("f_area", datamap.get("f_tbmj"));
            if(datamap.get("f_shape") != null && StringUtils.isNotBlank(datamap.get("f_shape").toString())){
                map.put("f_shape","SRID=4490;"+datamap.get("f_shape").toString());
            }
            map.put("f_sjpc", jcClueImportRecord==null?"":jcClueImportRecord.getfName());
            map.put("f_status",'0');
            map.put("f_state",'0');
            map.put("f_stage",'1');
            map.put("f_analysis",'0');
            if(cluefields.contains("f_registerstatus")){
                map.put("f_registerstatus",'0');
                map.put("f_mergestatus",'0');
            }
            map.put("f_userid", userId.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000);
            map.put("f_import_recordid", jcClueImportRecord==null?"":jcClueImportRecord.getfId());
       /* //增加线索判断信息
            if(type == 1 ){
                addJudgeInfo(tbId,map);
            }else{
                addWPZFJudgeInfo(tbId,map);
            }*/
        dataBizService.insertData(jcClueSource.getfTablename(), map, "f_shape");
         /*   if(type == 1 ){
                //处理附件数据
                List<AppMedia> appMedias =  appMediaDao.queryByGid(tbId);
                if(!appMedias.isEmpty()){
                    for(AppMedia appMedia : appMedias){
                        if(appMedia.getTypetype() == 2 ){
                            appMedia.setId(UUID.randomUUID().toString());
                            appMedia.setGalleryid(clueId);
                            appMediaDao.saveAll(appMedias);
                        }
                    }
                }
            }*/
         if(jcClueImportRecord != null){
             jcClueImportRecord.setfCount(jcClueImportRecord.getfCount() + 1);
             jcClueImportRecord.setfJcmj(new BigDecimal(jcClueImportRecord.getfJcmj().doubleValue() + Double.valueOf(area)));
             jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
         }
     }
    }

    @Override
    public void syncClueByTaskData(Long userId, String taskId, String tbId, String sourceId, String importRel) throws Exception {
        TskTaskBiz taskBiz = tskTaskBizService.findOne(taskId);
        if (taskBiz == null) {
            throw new RuntimeException("任务不存在");
        }
        String tableNameByBizId = tskTaskBizService.getTableNameByBizId(taskId);
        if (StringUtils.isBlank(tableNameByBizId)) {
            throw new RuntimeException("任务表不存在");
        }
        if (StringUtils.isBlank(importRel)) {
            throw new RuntimeException("缺失字段配置映射数据");
        }
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
        List<String> cluefields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        List<JcClueImportRecord> clueImportRecords = jcClueImportRecordService.selectBySourceId(jcClueSource.getfId());
        JcClueImportRecord jcClueImportRecord = null;
        if (!clueImportRecords.isEmpty()) {
            jcClueImportRecord = clueImportRecords.get(0);
        }
        HashMap<String, Object> map = new HashMap<>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<TbtskFields> fieldsList = tskTaskBizService.findTbtskFieldsByTaskId(taskId);
        List<String> fields = new ArrayList<>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        Map datamap = dataBizService.selectFieldByID(tableNameByBizId, fields, "f_id", "'" + tbId + "'");
        if (datamap != null) {
            String clueId = UUID.randomUUID().toString();
            //插入关联数据
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\"," +
                    " \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
            stringBuffer.append(" VALUES ( uuid_generate_v1(),'" + jcClueSource.getfId() + "'," +
                    "'" + jcClueImportRecord!=null?jcClueImportRecord.getfId():null + "','" + clueId + "','" + taskId +
                    "'," +
                    "'" + datamap.get("f_id").toString() + "',now(),null,'2')");
            jdbcTemplate.execute(stringBuffer.toString());
            Double area = 0.0D;
            if (datamap.get("f_tbmj") != null && StringUtils.isNotBlank(datamap.get("f_tbmj").toString())) {
                area = Double.parseDouble(datamap.get("f_tbmj").toString());
            }
            map.put("f_id", clueId);
            map.put("f_xzqdm", datamap.get("f_xzqdmsys"));
            map.put("f_xzqmc", datamap.get("f_xzqmc"));
            map.put("f_location", datamap.get("f_xzqmc"));
            map.put("f_area", datamap.get("f_tbmj"));
            if (datamap.get("f_shape") != null && StringUtils.isNotBlank(datamap.get("f_shape").toString())) {
                map.put("f_shape", "SRID=4490;" + datamap.get("f_shape").toString());
            }
            map.put("f_sjpc", jcClueImportRecord!=null?jcClueImportRecord.getfName():null);
            map.put("f_status",'0');
            map.put("f_state",'0');
            map.put("f_stage",'1');
            map.put("f_analysis",'0');
            if(cluefields.contains("f_registerstatus")){
                map.put("f_registerstatus",'0');
                map.put("f_mergestatus",'0');
            }
            map.put("f_userid", userId.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime", System.currentTimeMillis() / 1000);
            map.put("f_import_recordid", jcClueImportRecord!=null?jcClueImportRecord.getfId():null);
            JSONArray jsonArray = JSONObject.parseArray(importRel);
            for(int i=0;i<jsonArray.size();i++){
                JSONObject object = jsonArray.getJSONObject(i);
                String oriField = object.getString("oriField");
                String tarField = object.getString("tarField");
                map.put(oriField,datamap.get(tarField));
            }
            dataBizService.insertData(jcClueSource.getfTablename(), map, "f_shape");
            if(jcClueImportRecord!=null){
                jcClueImportRecord.setfCount(jcClueImportRecord.getfCount() + 1);
                jcClueImportRecord.setfJcmj(new BigDecimal(jcClueImportRecord.getfJcmj().doubleValue() + Double.valueOf(area)));
                jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);
            }
        }
    }

    //
    public void addJudgeInfo(String dataId,HashMap<String, Object> map){
        JcClueJudge jcClueJudge = jcClueJudgeMapper.selectByDataId(dataId);
        if(jcClueJudge != null){
            map.put("f_pdlx",jcClueJudge.getfPdlx());
            map.put("f_jyclfs",jcClueJudge.getfJyclfs());
            map.put("f_bljy",jcClueJudge.getfBljy());
            map.put("f_pdbz",jcClueJudge.getfPdbz());
            map.put("f_pdr",jcClueJudge.getfPdr());
            if(jcClueJudge.getfPdsj() != null){
                String f_pdsj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(jcClueJudge.getfPdsj());
                map.put("f_pdsj",f_pdsj);
            }
            map.put("f_djdw",jcClueJudge.getfDjdw());
            map.put("f_djr",jcClueJudge.getfDjr());
            map.put("f_djrq",jcClueJudge.getfDjrq());
        }
    }

    public void addWPZFJudgeInfo(String dataId,HashMap<String, Object> map){
        JcTaskClueJudge jcTaskClueJudge = jcTaskClueJudgeMapper.selectByDataId(dataId);
        if(jcTaskClueJudge != null){
            map.put("f_pdlx",jcTaskClueJudge.getfPdlx());
            map.put("f_gsbm",jcTaskClueJudge.getfGsbm());
            map.put("f_sjyt",jcTaskClueJudge.getfSjyt());
            map.put("f_jtqx",jcTaskClueJudge.getfJyqx());
            map.put("f_pdyjsm",jcTaskClueJudge.getfPdjysm());
            map.put("f_wflx",jcTaskClueJudge.getfWflx());
            map.put("f_sfxzlzgd",jcTaskClueJudge.getfSfxzlzgdjf());
            map.put("f_sfwhzj",jcTaskClueJudge.getfSfwhzj());
            map.put("f_qzgdmj",jcTaskClueJudge.getfSfgdmj());
            map.put("f_wfnydmj",jcTaskClueJudge.getfWfnydmj());
            map.put("f_qzjbntmj",jcTaskClueJudge.getfQzjbntmj());
            map.put("f_wfkdzdlm",jcTaskClueJudge.getfWfktzdlmj());
            map.put("f_wfwlydmj",jcTaskClueJudge.getfWfwlydmj());
            map.put("f_wfjsydmj",jcTaskClueJudge.getfWfjsydmj());
        }
    }

    /**
     * 导出日志
     * @param userId
     * @param dataLog
     * @param record
     * @return
     */
    public String createLog(Long userId, List<Map<String, Object>> dataLog,TaskRecord record){
    String tempDir = System.getProperty("java.io.tmpdir");
    String fileName = record.getTaskName() + "-数据导入日志-" + System.currentTimeMillis() + ".xls";
    String col =  "objectId,type,result";
    String colName = "objectId,结果类型,结果";
    String filePath = null;
    try {
        filePath = ExcelUtil.CreateExcel(dataLog, tempDir, fileName, col, colName, "日志导出");
    } catch (Exception e) {
        e.printStackTrace();
    }
    String sendObjName = "clueDataUploadLog/" + fileName;
    String downloadPath = defaultOssOperatorService.sendObject2Oss(sendObjName, filePath);
    return downloadPath;
}

@Override
public int getColNumOut(Double xLine) {
        return getColNum( xLine);
}

    @Override
    public String saveClueInfo(String sourceId, String clueInfo, MultipartFile shape,String slzb,Long userId) throws Exception {
        String id = "";
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        if(jcClueSource!=null){
            //获取动态生成的表明
            Map<String, Object> map = new HashMap<>();

            JSONObject jsonObject = JSONObject.parseObject(clueInfo);
            List<String> fields = new ArrayList<>();
            List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
            fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            if(jsonObject.keySet().size()>0) {
                Set<String> keys = jsonObject.keySet();
                for (String s : keys) {
                    String fieldType = getFieldType(s, allFields);
                    Object obj = jsonObject.get(s);
                    if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){

                    }else{
                        if("4".equalsIgnoreCase(fieldType) || "5".equalsIgnoreCase(fieldType)){
                            String datetime = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(obj);
                            map.put(s,"'" + datetime + "'");
                        }else{
                            map.put(s, obj);
                        }
                    }
                }
            }
            //处理shape数据
            Geometry geometry = null;
            if(shape != null){
                geometry = ShapeUtil.shapeFile2Geometry(shape,this.uploadDir);
                String wkt = geometry.toText();
                map.put("f_shape","SRID=4490;"+wkt);
            }else if(StringUtils.isNotBlank(slzb)){
                geometry = WKTUtil.wktToGeom(slzb);
                String wkt = geometry.toText();
                map.put("f_shape","SRID=4490;"+wkt);
            }
            Geometry pt = geometry.getCentroid();
            int proNum = getColNum(((Point) pt).getX());
            Map<String, Object> map1 = getXzqdmSys(pt, geometry, proNum);
            map.put("f_xzqdm", map1.get("xzqdmsys"));
            map.put("f_xzqmc", map1.get("xzqmc"));
            if(fields.contains("f_xzqdmcity") && StringUtils.isNotBlank((String) map1.get("xzqdmsys"))){
                map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0,4)+"00");
                map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0,6));
                map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0,9));
                map.put("f_xzqdmvillage", map1.get("xzqdmsys"));
            }

            map.put("f_location", map1.get("location"));
            map.put("f_area", map1.get("area"));
            map.put("f_id",UUID.randomUUID().toString());
            map.put("f_status",'0');
            map.put("f_state",'0');
            map.put("f_stage",'1');
            map.put("f_analysis",'0');
            if(fields.contains("f_registerstatus")){
                map.put("f_registerstatus",'0');
                map.put("f_mergestatus",'0');
            }
            map.put("f_userid",userId.toString());
            map.put("f_sourceid", jcClueSource.getfId());
            map.put("f_createtime",System.currentTimeMillis()/1000);
            //获取线索编号
           /* String xsbh = getClueNum(map.get("f_xzqdm").toString(), "XS");
            map.put("f_xsbh", xsbh);*/
            dataBizService.insertData(jcClueSource.getfTablename(),map, "f_shape");
            id = map.get("f_id").toString();
        }
        return id;
    }

    @Override
    public void updateXsInfo(String sourceId, String clueInfo,String clueId ) {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        if(jcClueSource!=null){
            //获取动态生成的表明
            Map<String, Object> updateMap = new HashMap<>();

            JSONObject jsonObject = JSONObject.parseObject(clueInfo);
            if(jsonObject.keySet().size()>0) {
                List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
                Set<String> keys = jsonObject.keySet();
                for (String s : keys) {
                    String fieldType = getFieldType(s, allFields);
                    Object obj = jsonObject.get(s);
                    if(obj == null || StringUtils.isBlank(obj.toString()) || "null".equals(obj.toString())){

                    }else{
                        if("4".equalsIgnoreCase(fieldType) || "5".equalsIgnoreCase(fieldType)){
                            String datetime = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(obj);
                            updateMap.put(s,"'" + datetime + "'");
                        }else{
                            updateMap.put(s, obj);
                        }
                    }
                }
            }
            if (MapUtil.isNotEmpty(updateMap)) {
                int row = dataBizService.updateDataById(jcClueSource.getfTablename(), clueId, updateMap);
            }
        }
    }

    @Override
    public void batchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findOne(clueFieldsValueParamVo.getSourceId());
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        List<JcClueFields> allFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
        StringBuilder sb = new StringBuilder();
        if(validParam(allFields,clueFieldsValueParamVo)){
            for(ClueFieldsValueParamVo.FieldValueParam fieldValueParam : clueFieldsValueParamVo.getFieldValueParams()){
                Optional<JcClueFields>op = allFields.stream().filter(t->t.getfFieldname().equalsIgnoreCase(fieldValueParam.getFieldName())).findAny();
                JcClueFields jcClueField = op.get();
                String fFieldtype= jcClueField.getfFieldtype();
                String where = "1 = 1 ";
                if (StringUtils.isNotBlank(clueFieldsValueParamVo.getImportRecordId())
                        && !clueFieldsValueParamVo.getImportRecordId().equals(clueFieldsValueParamVo.getSourceId())) {
                    where += " and f_import_recordid = '" + clueFieldsValueParamVo.getImportRecordId()+"' ";
                }
                if (StringUtils.isNotBlank(fieldValueParam.getFilter())) {
                    where += " and " + fieldValueParam.getFilter();
                }
                Integer type = fieldValueParam.getSetType();
                switch (type) { //赋值类型 0 覆盖 1 前追加 2 后追加 3 null值
                    case 0:
                        sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " ='" + fieldValueParam.getValue() + "' where " + where +";");
                        break;
                    case 1:
                        if(("1".equals(fFieldtype) || "2".equals(fFieldtype)) && !StringUtils.isNotBlank(jcClueField .getfCodetableid()) ){
                            sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam .getFieldName() + " =  " +
                                            " case  when  " + fieldValueParam .getFieldName()+" is null then '" + fieldValueParam.getValue() + "' " +
                                            "       else '" + fieldValueParam.getValue() + "' || " + fieldValueParam.getFieldName() + " end  where " + where+";");
                        }else{
                            throw new Exception("字段：" + fieldValueParam.getFieldName() + "待赋值类型错误,只能字符串类型数据进行追加");
                        }
                        break;
                    case 2:
                        if(("1".equals(fFieldtype) || "2".equals(fFieldtype)) && !StringUtils.isNotBlank(jcClueField .getfCodetableid()) ){
                            sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam .getFieldName() + " =  " +
                                    " case  when  " + fieldValueParam .getFieldName()+" is null then '" + fieldValueParam.getValue() + "' " +
                                    "       else " + fieldValueParam.getFieldName() + "||'" + fieldValueParam.getValue() + "' end  where " + where+";");

                           /* sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " = " + fieldValueParam.getFieldName() + "||'" + fieldValueParam.getValue() + "' where " + where+";");*/
                        }else{
                            throw new Exception("字段：" + fieldValueParam.getFieldName() +
                                    "待赋值类型错误,只能字符串类型数据进行追加");
                        }
                        break;
                    case 3:
                        sb.append("update " + jcClueSource.getfTablename() + " set " + fieldValueParam.getFieldName() + " = null  where "+ where+";");
                        break;
                    default:
                        throw new Exception("字段：" + fieldValueParam.getFieldName() + "待赋值类型错误");
                }
            }
            dataBizService.excuteSql(sb.toString());
        }
    }

    @Override
    public void addBatchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findOne(clueFieldsValueParamVo.getSourceId());
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        List<JcClueAssignmentPm> jcClueAssignmentPms = jcClueAssignmentPmDao.selectBySourceIdAndName(clueFieldsValueParamVo.getSourceId(), clueFieldsValueParamVo
                .getProgrammeName());
        if(jcClueAssignmentPms.size() > 0 ){
            throw new RuntimeException("方案名称已存在，请检查数据");
        }
        //新增方案
        JcClueAssignmentPm jcClueAssignmentPm = new JcClueAssignmentPm();
            jcClueAssignmentPm.setId(UUID.randomUUID().toString());
            jcClueAssignmentPm.setProgrammeName(clueFieldsValueParamVo.getProgrammeName());
            jcClueAssignmentPm.setCreateTime(new Timestamp(System.currentTimeMillis()));
           jcClueAssignmentPm.setSourceId(clueFieldsValueParamVo.getSourceId());
        jcClueAssignmentPmDao.gwAccessSelective(jcClueAssignmentPm);
        //新增方案对应条件数据
        for(ClueFieldsValueParamVo.FieldValueParam fieldValueParam :clueFieldsValueParamVo.getFieldValueParams()){
            JcClueAssignmentCond jcClueAssignmentCond = new JcClueAssignmentCond();
            BeanUtils.copyProperties(fieldValueParam, jcClueAssignmentCond);
            jcClueAssignmentCond.setSourceId(clueFieldsValueParamVo.getSourceId());
            jcClueAssignmentCond.setProgrammeId(jcClueAssignmentPm.getId());
            jcClueAssignmentCond.setId(UUID.randomUUID().toString());
            jcClueAssignmentCond.setFieldValue(fieldValueParam.getValue());
            jcClueAssignmentCondDao.gwAccessSelective(jcClueAssignmentCond);
        }
    }

    @Override
    public void updateBatchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findOne(clueFieldsValueParamVo.getSourceId());
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        JcClueAssignmentPm jcClueAssignmentPm = jcClueAssignmentPmDao.gwSearchByPK(clueFieldsValueParamVo.getId());
        if(jcClueAssignmentPm == null){
            throw new RuntimeException("方案不存在不存在");
        }
        if(!jcClueAssignmentPm.getProgrammeName().equals(clueFieldsValueParamVo.getProgrammeName())){
            List<JcClueAssignmentPm> jcClueAssignmentPms = jcClueAssignmentPmDao.selectBySourceIdAndName(clueFieldsValueParamVo.getSourceId(), clueFieldsValueParamVo.getProgrammeName());
            if(jcClueAssignmentPms.size() > 0 ){
                throw new RuntimeException("方案名称已存在，请检查数据");
            }
            //修改方案名称
            jcClueAssignmentPm.setProgrammeName(clueFieldsValueParamVo.getProgrammeName());
        }
        jcClueAssignmentPmDao.gwUpdateByPK(jcClueAssignmentPm);
        //删除方法对应条件数据
        jcClueAssignmentCondDao.delByProgrammeId(jcClueAssignmentPm.getId());
        //新增方案对应条件数据
        for(ClueFieldsValueParamVo.FieldValueParam fieldValueParam :clueFieldsValueParamVo.getFieldValueParams()){
            JcClueAssignmentCond jcClueAssignmentCond = new JcClueAssignmentCond();
            BeanUtils.copyProperties(fieldValueParam, jcClueAssignmentCond);
            jcClueAssignmentCond.setSourceId(clueFieldsValueParamVo.getSourceId());
            jcClueAssignmentCond.setProgrammeId(jcClueAssignmentPm.getId());
            jcClueAssignmentCond.setId(UUID.randomUUID().toString());
            jcClueAssignmentCond.setFieldValue(fieldValueParam.getValue());
            jcClueAssignmentCondDao.gwAccessSelective(jcClueAssignmentCond);
        }
    }

    @Override
    public List<JcClueAssignmentPm> findBatchUpdateXsInfoByCondition(String sourceId) throws Exception {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        List<JcClueAssignmentPm> jcClueAssignmentPms = jcClueAssignmentPmDao.selectBySourceId(sourceId);
            for(JcClueAssignmentPm jcClueAssignmentPm : jcClueAssignmentPms){
                jcClueAssignmentPm.setJcClueAssignmentConds(jcClueAssignmentCondDao.selectByProgrammeId(jcClueAssignmentPm.getId()));
            }
        return jcClueAssignmentPms;
    }

    @Override
    public JcClueAssignmentPm findBatchUpdateXsInfoByProgrammeId(String programmeId) throws Exception {
       JcClueAssignmentPm jcClueAssignmentPm = jcClueAssignmentPmDao.gwSearchByPK(programmeId);
                jcClueAssignmentPm.setJcClueAssignmentConds(jcClueAssignmentCondDao.selectByProgrammeId(jcClueAssignmentPm.getId()));
        return jcClueAssignmentPm;
    }

    @Override
    public void delBatchUpdateXsInfoByCondition(String programmeId) throws Exception {
        JcClueAssignmentPm jcClueAssignmentPm = jcClueAssignmentPmDao.gwSearchByPK(programmeId);
        if(jcClueAssignmentPm == null){
            throw new RuntimeException("方案不存在不存在");
        }
        //删除方法对应条件数据
        jcClueAssignmentCondDao.delByProgrammeId(jcClueAssignmentPm.getId());
        //删除方案
        jcClueAssignmentPmDao.gwDeleteByPK(programmeId);
    }

    @Override
    public JcClueFilter addClueFilter(Long userId,JcClueFilterVo jcClueFilterVo) {
        List<JcClueFilter> jcClueFilters = jcClueFilterDao.selectBySourceIdAndFilterName(jcClueFilterVo.getSourceId(), jcClueFilterVo.getFilterName());
       if(jcClueFilters.size() > 0 ){
           throw new GwValidateException("线索过滤条件名称已存在，请检查数据");
       }
        JcClueFilter jcClueFilter = new JcClueFilter();
        BeanUtils.copyProperties(jcClueFilterVo, jcClueFilter);
        jcClueFilter.setId(UUID.randomUUID().toString());
        jcClueFilter.setCreateTime(new Timestamp(System.currentTimeMillis()));
        jcClueFilter.setUserId(Math.toIntExact(userId));
        jcClueFilterDao.gwAccessSelective(jcClueFilter);
        return jcClueFilter;
    }

    @Override
    public JcClueFilter updateClueFilter(Long userId,JcClueFilterVo jcClueFilterVo) {
        JcClueFilter jcClueFilter = jcClueFilterDao.gwSearchByPK(jcClueFilterVo.getId());
        if(jcClueFilter == null){
            throw new GwValidateException("线索过滤数据不存在，请检查数据id");
        }
        if(!jcClueFilter.getFilterName().equals(jcClueFilterVo.getFilterName())){
            List<JcClueFilter> jcClueFilters = jcClueFilterDao.selectBySourceIdAndFilterName(jcClueFilterVo.getSourceId(), jcClueFilterVo.getFilterName());
            if(jcClueFilters.size() > 0 ){
                throw new GwValidateException("线索过滤条件名称已存在，请检查数据");
            }
            jcClueFilter.setFilterName(jcClueFilterVo.getFilterName());
        }
        jcClueFilter.setFilterValue(jcClueFilterVo.getFilterValue());
        jcClueFilter.setEnumCode(jcClueFilterVo.getEnumCode());
        jcClueFilterDao.gwUpdateByPKSelective(jcClueFilter);
        return jcClueFilter;
    }

    @Override
    public void delClueFilterById(String id) {
        JcClueFilter jcClueFilter = jcClueFilterDao.gwSearchByPK(id);
        if(jcClueFilter == null){
            throw new GwValidateException("线索过滤数据不存在，请检查数据id");
        }
        jcClueFilterDao.gwDeleteByPK(id);
    }

    @Override
    public List<JcClueFilter> findClueFilters(String sourceId) {
        return   jcClueFilterDao.selectBySourceId(sourceId);
    }

    public boolean validParam(List<JcClueFields> allFields,ClueFieldsValueParamVo param) throws Exception {
     for(ClueFieldsValueParamVo.FieldValueParam fieldValueParam : param.getFieldValueParams()){
         Optional<JcClueFields>op = allFields.stream().filter(t->t.getfFieldname().equalsIgnoreCase(fieldValueParam.getFieldName())).findAny();
         if(!op.isPresent()){
             throw new Exception("字段：" + fieldValueParam.getFieldName()+"不存在");
         }
         JcClueFields jcClueFields = op.get();
         String fieldType = jcClueFields.getfFieldtype();
         if(fieldValueParam.getSetType() != 3 && StringUtils.isBlank(fieldValueParam.getValue())){
             throw new Exception("字段：" + fieldValueParam.getFieldName()+"待赋值内容为空");
         }
     }
      return true;
  }


    //获取字段类型
    public String getFieldType(String fieldName, List<JcClueFields> tbtskFields) {
        String fieldType = "";
        for (JcClueFields field : tbtskFields) {
            if (fieldName.equalsIgnoreCase(field.getfFieldname())) {
                fieldType = field.getfFieldtype();
            }
        }
        return fieldType;
    }



    private int getColNum(Double xLine) {
        int proNum = 2362;
        if (xLine >= 75.5 && xLine < 78.5) {
            proNum = 2353;
        } else if (xLine >= 78.5 && xLine < 81.5) {
            proNum = 2354;
        } else if (xLine >= 81.5 && xLine < 84.5) {
            proNum = 2355;
        } else if (xLine >= 84.5 && xLine < 87.5) {
            proNum = 2356;
        } else if (xLine >= 87.5 && xLine < 90.5) {
            proNum = 2357;
        } else if (xLine >= 90.5 && xLine < 93.5) {
            proNum = 2358;
        } else if (xLine >= 93.5 && xLine < 96.5) {
            proNum = 2359;
        } else if (xLine >= 96.5 && xLine < 99.5) {
            proNum = 2360;
        } else if (xLine >= 99.5 && xLine < 112.5) {
            proNum = 2361;
        } else if (xLine >= 112.5 && xLine < 115.5) {
            proNum = 2362;
        } else if (xLine > 115.5 && xLine < 118.5) {
            proNum = 2363;
        } else if (xLine > 118.5 && xLine < 121.5) {
            proNum = 2364;
        } else if (xLine > 121.5 && xLine < 124.5) {
            proNum = 2365;
        } else if (xLine > 124.5 && xLine < 127.5) {
            proNum = 2366;
        } else if (xLine > 127.5 && xLine < 130.5) {
            proNum = 2367;
        } else if (xLine > 130.5 && xLine < 133.5) {
            proNum = 2368;
        } else if (xLine > 133.5 && xLine < 136.5) {
            proNum = 2369;
        }
        return proNum;
    }

    public String conType(String fieldType){
        Map<String,String> FIELD_TYPE_DIC = new HashMap<>();
        FIELD_TYPE_DIC.put("1","text");
        FIELD_TYPE_DIC.put("2","varchar");
        FIELD_TYPE_DIC.put("3","decimal");
        FIELD_TYPE_DIC.put("4","timestamp");
        FIELD_TYPE_DIC.put("5", "timestamp");
        FIELD_TYPE_DIC.put("6", "varchar");
        FIELD_TYPE_DIC.put("7", "decimal");
        FIELD_TYPE_DIC.put("8","int4");
        FIELD_TYPE_DIC.put("9","geometry");
        FIELD_TYPE_DIC.put("10","text");
       return  FIELD_TYPE_DIC.getOrDefault(fieldType,"varchar");
    }


    @Override
    public List<JcClueFields> getJcFieldsByTablename(String tablename) {
        List<JcClueFields> jcClueFieldsList = jcClueFieldsService.findByTableName(tablename);
        return jcClueFieldsList;
    }



    private CoordinateReferenceSystem createCRSByPrjFile(String filePath) {
        String prjFilePath = filePath.replace(".shp", ".prj");
        String wkt = txt2String(new File(prjFilePath));
        String wkt2 = wkt.replaceAll("[',']+", ",").replaceAll(",]", "]");

        CoordinateReferenceSystem sCRS = null;
        try {
            sCRS = CRS.parseWKT(wkt2);
        } catch (FactoryException e) {
            e.printStackTrace();
        }
        return sCRS;
    }

    private String txt2String(File file) {
        StringBuilder result = new StringBuilder();
        try {
            //构造一个BufferedReader类来读取文件
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                //使用readLine方法，一次读一行
                result.append(s);
            }
            br.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private String getStrValue(Object obj, String chasetStr) {
        String val = "";
        try {
            if (obj != null && !"".equals(obj)) {
                String objStr = obj.toString();
                obj = new String(objStr.getBytes(chasetStr), StandardCharsets.UTF_8);
                if (obj != null && isMessyCode(obj.toString())) {
                    obj = new String(objStr.getBytes(chasetStr), "GBK");
                }
                val = String.valueOf(obj);
            }
        } catch (Exception ex) {
        }
        return val;
    }

    private boolean isMessyCode(String str) {
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            // 当从Unicode编码向某个字符集转换时，如果在该字符集中没有对应的编码，则得到0x3f（即问号字符?）
            // 从其他字符集向Unicode编码转换时，如果这个二进制数在该字符集中没有标识任何的字符，则得到的结果是0xfffd
            if ((int) c == 0xfffd) {
                // 存在乱码
                return true;
            }
        }
        return false;
    }


    /**
     * 获取政区数据
     * @param geo
     * @param version
     * @return
     */
    private HashMap<String, Object> getXzqdmSys(Geometry geo, String version) throws Exception {
        HashMap<String, Object> map = new HashMap<>();
        map.put("xzqdmsys","");
        map.put("xzqmc","");
        map.put("location","");
        String location = "";
        String xzqdmsys = "";
        try {
            RegionVillage regionVillage = new RegionVillage();
            RegionTown regionTown = new RegionTown();
            RegionDetail region = new RegionDetail();
            String wkt = WKTUtil.geomToWkt(geo);
            if (version != null) {
                regionVillage = regionService.queryRegionVillageByCoor(geo, version);
                regionTown = regionService.queryRegionTownCotain(geo, version);
                region = regionService.queryRegionByGeomByVersion(wkt, 4490, 3, version);

            } else {
                regionVillage = regionService.queryRegionVillageByCoor(geo);
                regionTown = regionService.queryRegionTownCotain(geo);
                region = regionService.queryRegionByGeom(wkt, 4490, 3);
            }

            if (regionVillage != null) {
                xzqdmsys = regionVillage.getCode();
                map.put("xzqdmsys",xzqdmsys);
                map.put("xzqmc",regionVillage.getName());
            } else {
                if (regionTown != null) {
                    xzqdmsys = regionTown.getCode() + "000";
                    map.put("xzqdmsys",xzqdmsys);
                    map.put("xzqmc",regionTown.getName());
                } else {
                    xzqdmsys = region.getCode() + "000000";
                    map.put("xzqdmsys",xzqdmsys);
                    map.put("xzqmc",regionTown.getName());
                }
            }

            if(region!=null){
                location += region.getName();
            }
            if(regionTown!=null){
                location += regionTown.getName();
            }
            if(regionVillage!=null){
                location += regionVillage.getName();
            }

            map.put("location",location);

        } catch (ParseException e) {
            e.printStackTrace();
        }
        return map;
    }

    private HashMap<String,Object> getXzqdmSys(Geometry pt,Geometry geo,int proNum) throws SQLException {
        HashMap<String, Object> map = new HashMap<>();
        try {
            String wkt = WKTUtil.geomToWkt(pt);
            String sql = "select * from ((select f_xzqdm as xzqdm,f_xzqmc as xzqmc,3 as level from tb_region where st_contains(shape, st_geomfromtext('" + wkt + "',4490)) and f_level =3  limit 1)\n" +
                    "union\n" +
                    "(select xzqdm,xzqmc,4 as level from tb_region_town where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)\n" +
                    "union\n" +
                    "(select xzqdm,xzqmc,5 as level from tb_region_village where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)) as q order by q.level";

            List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);

            Map<String, Object> region = null;
            Map<String, Object> regionTown = null;
            Map<String, Object> regionVillage = null;

            for(int i=0;i<maps.size();i++){
                Object xzqdm = maps.get(i).get("xzqdm");
                if(xzqdm==null)continue;

                if(xzqdm.toString().length()==12){
                    regionVillage = maps.get(i);
                }
                else if(xzqdm.toString().length()==9){
                    regionTown = maps.get(i);
                }
                else if(xzqdm.toString().length()==6){
                    region = maps.get(i);
                }
            }

            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage!=null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown!=null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region!=null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }

            String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt(geo) + "',4490)," + proNum + "))/666.6666667 as area";
            Map<String, Object> areaMap = jdbcTemplate.queryForMap(areasql);
            String area = areaMap.get("area").toString();
            BigDecimal bigDecimal = new BigDecimal(Double.valueOf(area));

            map.put("area",bigDecimal);
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e){
            throw new SQLException(e.getMessage());
        }

        return map;
    }


    @Override
    public Pair<Long, List<Map>> queryCulelist(CuleQueryParam parameter) {
        Pair<String, String> queryParamPair = parseQueryParameter(parameter);
        String tableName = queryParamPair.getLeft();
        String where = queryParamPair.getRight();
        if(StringUtils.isNotBlank(parameter.getConditionFilter())){
            where += " and "+parameter.getConditionFilter();
        }
        String order = " order by " + parameter.getSortParam();

        List<JcClueFields> jcFields = jcClueFieldsService.findByTableId(parameter.getSourceId());
        List<String> fieldList = jcFields.stream().filter(r->!r.getfFieldname().equals("f_shape_g")).map(t->t .getfFieldname()).collect(Collectors.toList());
        if(StringUtils.isNotBlank(tableName) && !tableName.contains("null")){
            Integer count = dataBizService.getCount(tableName, where);
            List<Map> list = dataBizService.queryPageData(tableName, fieldList, parameter.getRows(), parameter.getPage(), where + order);
            return Pair.of(Long.valueOf(count), list);
        }
        return Pair.of(0L, new ArrayList<>());
    }

    @Override
    public Pair<Long, List<Map>> queryCulelistNotPage(CuleQueryParam parameter) {
        Pair<String, String> queryParamPair = parseQueryParameter(parameter);
        String tableName = queryParamPair.getLeft();
        String where = queryParamPair.getRight();
        if(StringUtils.isNotBlank(parameter.getConditionFilter())){
            where += " and "+parameter.getConditionFilter();
        }
        String order = " order by " + parameter.getSortParam();

        List<JcClueFields> jcFields = jcClueFieldsService.findByTableId(parameter.getSourceId());
        List<String> fieldList = jcFields.stream().filter(r->!r.getfFieldname().equals("f_shape_g")).map(t->t .getfFieldname()).collect(Collectors.toList());
        if(StringUtils.isNotBlank(tableName) && !tableName.contains("null")){
            Integer count = dataBizService.getCount(tableName, where);
            List<Map> list = dataBizMapper.queryNotPageData(tableName, fieldList, where + order);
            return Pair.of(Long.valueOf(count), list);
        }
        return Pair.of(0L, new ArrayList<>());
    }

    @Override
    public void importClueToTaskByCondition(CuleQueryParam parameter) {
        Pair<String, String> queryParamPair = parseQueryParameter(parameter);
        String where = queryParamPair.getRight();
        if(StringUtils.isNotBlank(parameter.getConditionFilter())){
            where += " and "+parameter.getConditionFilter();
        }
        String tablename = parameter.getTableName();
        /*String where = " clue.f_sourceid='"+sourceId+"'";
        if(StringUtils.isNotBlank(recordId)){
            where += " and clue.f_import_recordid = '"+recordId+"'";
        }*/
            where +=  " and  not exists (select null from jc_clue_task_rel " +
                    "r where r.f_clueid= tb.f_id and r.f_type='1'  and r.f_taskid = '"+parameter.getTaskId()+"')";
        //插入关联数据
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\"," +
                " \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
        stringBuffer.append(" select uuid_generate_v1(),'"+parameter.getSourceId()+"','"+parameter.getRecordId()+"',tb.f_id," +
                "'"+parameter.getTaskId()+"', uuid_generate_v1(),now(),null,'1' from " +tablename+" tb  where "+ where);

        dataBizMapper.excuteSql(stringBuffer.toString());
        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
        params.put("sourceId", parameter.getSourceId());
        params.put("recordId", parameter.getRecordId());
        params.put("importRel", parameter.getImportRel());
        params.put("taskId", parameter.getTaskId());
        params.put("userId", parameter.getUserId());
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        //线索数据导入到核查任务
        record.setTaskName("线索数据导入到核查任务");
        record.setTasktype(JobConstants.JOB_TYPE_CULETASK_IMPORT);
        record.setStarttime(new Date());
        record.setBizId(parameter.getSourceId());
        record.setRead(0);
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(parameter.getUserId());
        taskRecordService.save(record);

    }

    @Override
    public String getClueNum(String xzqdm, String type) {
        //查询新增线索
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String dateString = sf.format(new Date());
        Lock lock = new ReentrantLock();
        if(xzqdm.length()>=6){
            xzqdm = xzqdm.substring(0,6);
        }else{
            throw new RuntimeException("政区代码有误");
        }
        int count =0;
        try {
            boolean b = lock.tryLock();
            if(b) {
                JcClueNum clueNum = jcClueNumMapper.getClueNum(xzqdm, type, dateString);

                if (clueNum == null) {
                    clueNum = new JcClueNum();
                    clueNum.setfXzqdm(xzqdm);
                    clueNum.setfDate(dateString);
                    clueNum.setfType(type);
                    clueNum.setfNum(0);
                    jcClueNumMapper.insert(clueNum);
                } else {
                    count = clueNum.getfNum() + 1;
                    clueNum.setfNum(count);
                    jcClueNumMapper.update(clueNum);
                }
            }
        } finally {
            lock.unlock();;
        }
        return getXSBH(xzqdm,type,dateString,count);
    }

    @Override
    public HashMap<String,Object> getXzqdmSysOut(Geometry pt,Geometry geo,int proNum) throws SQLException {
        return getXzqdmSys(pt, geo, proNum);
    }

    //生成线索编号
    public String getXSBH(String xzqdm,String type,String dateString,int count){
        String c = String.format("%04d",count);
        return xzqdm+dateString+type+c;
    }

    @Override
    public void clueJudgeSubmit(Long userId, JcClueJudge jcClueJudge) throws java.text.ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("YYYY-MM-DD");
        String fid = "";
        if(jcClueJudge != null && jcClueJudge.getfDataid() != null){
            JcClueJudge jcClueJudge1 = jcClueJudgeMapper.selectByDataId(jcClueJudge.getfDataid());
           if(jcClueJudge1 != null){
               fid = jcClueJudge1.getfId();
               BeanUtil.copyProperties(jcClueJudge,jcClueJudge1,false);
               jcClueJudge1.setfId(fid);
               jcClueJudge1.setfUserid(userId.intValue());
               jcClueJudge1.setfCreatetime(new Date());
               if(StringUtils.isNotBlank(jcClueJudge.getPdsj())){
                   jcClueJudge1.setfPdsj(simpleDateFormat.parse(jcClueJudge.getPdsj()));
               }
               if(StringUtils.isNotBlank(jcClueJudge.getDjrq())){
                   jcClueJudge1.setfDjrq(simpleDateFormat.parse(jcClueJudge.getDjrq()));
               }
               jcClueJudgeMapper.updateByPrimaryKeySelective(jcClueJudge1);
           }else{
               JcClueJudge bean = new JcClueJudge();
               BeanUtil.copyProperties(jcClueJudge,bean,false);
               bean.setfId(UUID.randomUUID().toString());
               bean.setfUserid(userId.intValue());
               bean.setfCreatetime(new Date());
               if(StringUtils.isNotBlank(jcClueJudge.getPdsj())){
                   bean.setfPdsj(simpleDateFormat.parse(jcClueJudge.getPdsj()));
               }
               if(StringUtils.isNotBlank(jcClueJudge.getDjrq())){
                   bean.setfDjrq(simpleDateFormat.parse(jcClueJudge.getDjrq()));
               }
               jcClueJudgeMapper.insertSelective(bean);
           }
        }

    }

    @Override
    public JcClueJudge findClueJudgeInfo(Long userId,String dataId){
        JcClueJudge jcClueJudge =  jcClueJudgeMapper.selectByDataId(dataId);
        List<AppMedia> appMedias =  appMediaDao.queryByGid(dataId);
        List<AppMediaDTO> result = new ArrayList<>();
        List<Object> resultObject = new ArrayList<>();
        for (int i = 0; i < appMedias.size(); i++) {
            if(appMedias.get(i).getTypetype() == 2){
                AppMediaDTO newMedia = new AppMediaDTO();
                BeanUtils.copyProperties(appMedias.get(i), newMedia);
                if (newMedia.getServerpath() != null && !newMedia.getServerpath().contains("AccessKeyId")) {
                    //获取文件名
                    String fiename = appMedias.get(i).getServerpath().substring(appMedias.get(i).getServerpath().lastIndexOf("/") + 1, appMedias.get(i).getServerpath().length());
                    newMedia.setFileName(fiename);
                    //获取文件授权有效期
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", newMedia.getServerpath(), null);
                    if (StringUtils.isNotBlank(url)) {
                        newMedia.setServerpath(url);
                    }
                }
                //result.add(newMedia);
                resultObject.add(newMedia);
            }
        }
        jcClueJudge.setMediaList(resultObject);
        return jcClueJudge;
    }

    public Pair<String, String> parseQueryParameter(CuleQueryParam param){
        String tempFilter = "";
        String rejectJoinFilter = "";
        StringBuilder sbFilter = new StringBuilder(" 1=1 ");
        String tableAlias = "tb";
        if (StringUtils.isNotBlank(param.getRegionCode())) {
            List<JcClueFields> allFields = jcClueFieldsService.findByTableId(param.getSourceId());
            List<String> fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            sbFilter.append(" and  ");
            if (param.getRegionCode().length() <= 6) {
                if (param.getRegionCode().endsWith("0000")) {
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_xzqdm like '" + param.getRegionCode().substring(0, 2) + "%' ");
                } else if (param.getRegionCode().endsWith("00")) {
                    sbFilter.append(tableAlias);
                    if(fields.contains("f_xzqdmcity")){
                        sbFilter.append(".f_xzqdmcity = '" + param.getRegionCode() + "' ");
                    }else{
                        sbFilter.append(".f_xzqdm like '" + param.getRegionCode().substring(0, 4) + "%' ");
                    }
                } else {
                    sbFilter.append(tableAlias);
                    if(fields.contains("f_xzqdmcounty")){
                        sbFilter.append(".f_xzqdmcounty = '" + param.getRegionCode() + "' ");
                    }else{
                        sbFilter.append(".f_xzqdm like '" + param.getRegionCode() + "%' ");
                    }
                }
            } else if(param.getRegionCode().length() == 9){
                sbFilter.append(tableAlias);
                if(fields.contains("f_xzqdmtown")){
                    sbFilter.append(".f_xzqdmtown = '" + param.getRegionCode() + "' ");
                }else{
                    sbFilter.append(".f_xzqdm like '" + param.getRegionCode() + "%' ");
                }
            }else if(param.getRegionCode().length() == 12){
                sbFilter.append(tableAlias);
                if(fields.contains("f_xzqdmvillage")){
                    sbFilter.append(".f_xzqdmvillage = '" + param.getRegionCode() + "' ");
                }else{
                    sbFilter.append(".f_xzqdm like '" + param.getRegionCode() + "%' ");
                }
            }
        }
        // 线索来源id
       /* if (StringUtils.isNotBlank(param.getSourceId())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
                sbFilter.append(".f_sourceid = '"+param.getSourceId()+"' ");
        }*/
        // 线索批次
        if (StringUtils.isNotBlank(param.getRecordId()) && !param.getSourceId().equals(param.getRecordId())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
                sbFilter.append(".f_import_recordid =  '"+param.getRecordId()+"' ");
        }
        // 套合状态 0 未套合 1 已套合
        if (param.getRegisterStatus() != null) {
            if(param.getRegisterStatus() == 0  ){
                sbFilter.append(" and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status =  '"+param.getRegisterStatus()+"'  or ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status  is null ) ");
            }else{
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_registerstatus =  '"+param.getRegisterStatus()+"' ");
            }

        }
        // //融合状态 0 未融合 1 已融合
        if (param.getMergeStatus() != null) {
            if(param.getMergeStatus() == 0  ){
                sbFilter.append(" and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_mergestatus =  '"+param.getMergeStatus()+"'  or ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_mergestatus  is null ) ");
            }else{
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_mergestatus =  '"+param.getMergeStatus()+"' ");
            }
        }
        // 处理状态 0 未处理 1 已处理
        if (param.getHandlyStatus() != null) {
            if(param.getHandlyStatus() == 0  ){
                sbFilter.append(" and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status =  '"+param.getHandlyStatus()+"'  or ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status  is null ) ");
            }else{
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_status =  '"+param.getHandlyStatus()+"' ");
            }
        }
        //常规监测定制页面 分析研判数据页面
        if(StringUtils.isNotBlank(param.getFxymCode()) ){

            List<JcClueFilter> jcClueFilters = jcClueFilterDao.selectBySourceIdAndEnumCode(param.getSourceId(), param.getFxymCode());
            if(jcClueFilters.size() > 0){
                //定制查询删选数据条件
                sbFilter.append(" and (");
                for(JcClueFilter jcClueFilter : jcClueFilters){
                    sbFilter.append("(").append(jcClueFilter.getFilterValue()).append(") or ");
                }
                sbFilter.delete(sbFilter.length()-4,sbFilter.length());
                sbFilter.append(" ) ");
            }else{
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_id is null  ");
            }
        }

        if (StringUtils.isNotBlank(param.getKeyWord())) {
            tempFilter = parseSearchParam(param.getKeyWord(), param.getTableName(), tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }

        if (StringUtils.isNotBlank(param.getCustomFilter())) {
            tempFilter = parseFilterParam(param.getCustomFilter(), param.getSourceId(), tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }
        String tableName = " " + param.getTableName() + " as " + tableAlias + " ";
        return Pair.of(tableName  + rejectJoinFilter, sbFilter.toString());
    }



    public String parseSearchParam(String keyWord, String tablename, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty(keyWord)) {
            List<String> searchList = jcClueFieldGroupViewMapper.clueGroupByTableName("web",tablename,"102")
                    .stream()
                    .map(r -> "(" + tableAlias + "." + r.getfFieldname() + " LIKE '%" + keyWord + "%')")
                    .collect(Collectors.toList());
            String searchStr = String.join(" OR ", searchList);
            where += " AND (" + searchStr + ") ";
        }
        return where;
    }


    public String parseFilterParam(String filterParam, String tablename, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty(filterParam)) {
            JSONArray filterArray = JSONArray.parseArray(filterParam);
            //101代表筛选配置
            List<JcClueFieldGroupView> filterField = jcClueFieldGroupViewMapper.clueGroupByTableId("web",tablename,"101");
            for (int i = 0; i < filterArray.size(); i++) {
                JSONObject jsonObject = filterArray.getJSONObject(i);
                String field = jsonObject.getString("field");
                String ref = jsonObject.getString("ref");
                String val = jsonObject.getString("val");
                String filterStr = "";
                if (!"".equals(val)) {
                    Optional<JcClueFieldGroupView> optional = filterField.stream().filter(r -> r.getfId().equals(field)).findFirst();
                    if (optional.isPresent()) {
                        JcClueFieldGroupView one = optional.get();
                        switch (one.getfFieldtype()) {
//                            文本型的
                            case "1":
                            case "2": {
                                switch (ref) {
                                    case "LK": {
                                        /*  filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";*/
                                        String[] tem = val.split(",");
                                        if (tem.length > 1) {
                                            filterStr += "( ";
                                            for (String s : tem) {
                                                filterStr += tableAlias + "." + one.getfFieldname() + " LIKE '%" +
                                                        s + "%'  or ";
                                            }
                                            filterStr = filterStr.substring(0, filterStr.length() - 3) + ") ";
                                        } else {
                                            filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";
                                        }
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "IN": {

                                        List<String> inValues = new ArrayList<>();
                                        for (String s : val.split(",")) {
                                            inValues.add("'" + s + "'");
                                        }
                                        filterStr = tableAlias + "." + one.getfFieldname() + " IN (" + StringUtils.join(inValues, ",") + ") ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case "3":
                            case "4":
                            case "5": {
                                switch (ref) {
                                    case "GT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " > " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "LT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " < " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "LE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " <= " + jsonObject .getString("val") + " ";
                                        break;
                                    }
                                    case "GE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " >= " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "NE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " != " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            default:
                                break;
                        }
                    }
                    if (!StringUtils.isEmpty(filterStr)) {
                        where += " AND " + filterStr;
                    }
                }
            }
        }
        return where;
    }



    @Override
    public byte[] exportExcel(List<Map<String, Object>> maps, String templateFile, String type) {
        if (maps == null) {
            return null;
        }
        XSSFWorkbook wb = null;
        FileInputStream fileInputStream = null;
        byte[] barray = null;
        ByteArrayOutputStream bos = null;
        try {
            File srcFile = new File(templateFile);
            fileInputStream = new FileInputStream(srcFile);
            wb = new XSSFWorkbook(fileInputStream);
            if (type.equals("tbjxlxfx")){
                tbjxlxfxSheet(wb, maps);
            }else if(type.equals("gdwtbdjfx")){
                gdwtbdjfxSheet(wb, maps);
            }else if(type.equals("xftbmx")){
                xftbmxSheet(wb, maps);
            }else if(type.equals("zhjcjgxsb")){
                zhjcjgxsbSheet(wb, maps);
            }else if(type.equals("shfpqd")){
                shfpqdSheet(wb, maps);
            }

            bos = new ByteArrayOutputStream();
            wb.write(bos);
            barray = bos.toByteArray();
            logger.info("excel完成！！！！！");

        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            if (wb != null) {
                try {
                    wb.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return barray;
    }

    @Override
    public List<Map<String, Object>> statisticsTbjclxfx(String sourceId, String recordId) {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        String where = " where f_sourceid='"+sourceId+"'";
        if(StringUtils.isNotBlank(recordId)){
            where += " and f_import_recordid = '"+recordId+"'";
        }
        String sql = " select '全市' as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n" +
                "  SUM ( case when f_jcgl = '建构筑物' then 1   else 0 end ) as jgzwCount,\n" +
                "\tSUM( case when f_jcgl = '建构筑物' then f_area else 0 end ) as jgzwArea,\n" +
                "\tSUM( case when f_jcgl = '推堆土' then 1 else 0 end ) as tdtCount,\n" +
                "\tSUM( case when f_jcgl = '推堆土' then f_area else 0 end ) as tdtArea,\n" +
                "\tSUM ( case when f_jcgl = '线状地物' then 1 else 0 end ) as xzdwCount,\n" +
                "\tSUM( case when f_jcgl = '线状地物' then f_area else 0 end ) as xzdwArea,\n" +
                "\tSUM ( case when f_jcgl = '园林地' then 1 else 0 end ) as yldCount,\n" +
                "\tSUM( case when f_jcgl = '园林地' then f_area else 0 end ) as yldArea,\n" +
                "\tSUM ( case when f_jcgl = '坑塘' then 1 else 0 end ) as ktCount,\n" +
                "\tSUM( case when f_jcgl = '坑塘' then f_area else 0 end ) as ktArea,\n" +
                "\tSUM ( case when f_jcgl = '建筑拆除及原址变化' then 1 else 0 end ) as jzccCount,\n" +
                "\tSUM ( case when f_jcgl = '建筑拆除及原址变化' then f_area else 0 end ) as jzccArea,\n" +
                "\tSUM ( case when f_jcgl = '新增耕地' then 1 else 0 end ) as xzgdCount,\n" +
                "\tSUM ( case when f_jcgl = '新增耕地' then f_area else 0 end ) as xzgdArea\n" +
                "\tfrom "+jcClueSource.getfTablename() +where +"\n" +
                "union all\t\n" +
                "select\n" +
                "\tcase when f_rwfp is null then '政区数据为空' else f_rwfp end  as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n" +
                "\tSUM ( case when f_jcgl = '建构筑物' then 1 else 0 end ) as jgzwCount,\n" +
                "\tSUM( case when f_jcgl = '建构筑物' then f_area else 0 end ) as jgzwArea,\n" +
                "\tSUM( case when f_jcgl = '推堆土' then 1 else 0 end ) as tdtCount,\n" +
                "\tSUM( case when f_jcgl = '推堆土' then f_area else 0 end ) as tdtArea,\n" +
                "\tSUM ( case when f_jcgl = '线状地物' then 1 else 0 end ) as xzdwCount,\n" +
                "\tSUM( case when f_jcgl = '线状地物' then f_area else 0 end ) as xzdwArea,\n" +
                "\tSUM ( case when f_jcgl = '园林地' then 1 else 0 end ) as yldCount,\n" +
                "\tSUM( case when f_jcgl = '园林地' then f_area else 0 end ) as yldArea,\n" +
                "\tSUM ( case when f_jcgl = '坑塘' then 1 else 0 end ) as ktCount,\n" +
                "\tSUM( case when f_jcgl = '坑塘' then f_area else 0 end ) as ktArea,\n" +
                "\tSUM ( case when f_jcgl = '建筑拆除及原址变化' then 1 else 0 end ) as jzccCount,\n" +
                "\tSUM ( case when f_jcgl = '建筑拆除及原址变化' then f_area\telse 0 end ) as jzccArea,\n" +
                "\tSUM ( case when f_jcgl = '新增耕地' then 1 else 0 end ) as xzgdCount,\n" +
                "\tSUM ( case when f_jcgl = '新增耕地' then f_area else 0 end ) as xzgdArea\n" +
                "from\n" +
                "\t"+jcClueSource.getfTablename() +where +"\n" +
                " group by f_rwfp;";
        List<Map<String, Object>> dataList = jdbcTemplate.queryForList(sql);
        return dataList;
    }

    @Override
    public List<Map<String, Object>> statisticsGdwtbdjfx(String sourceId, String recordId) {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        String where = " where f_sourceid='"+sourceId+"' and f_jcrw ='常规监测' ";
        if(StringUtils.isNotBlank(recordId)){
            where += " and f_import_recordid = '"+recordId+"'";
        }
        String sql = " select\n" +
                "\tcase when f_rwfp is null then '政区数据为空' else f_rwfp end  as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n" +
                "\tSUM ( case when f_cbsxyy in( '手续覆盖类','临时用地','设施农用地') then 1 else 0 end ) as ysxlCount,\n" +
                "\tSUM( case when f_cbsxyy in( '手续覆盖类','临时用地','设施农用地')  then f_area else 0 end ) as ysxlArea,\n" +
                "\tSUM( case when f_cbsxyy = '已纳入变更构建筑物' then 1 else 0 end ) as ynrbgjzwCount,\n" +
                "\tSUM( case when f_cbsxyy = '已纳入变更构建筑物' then f_area else 0 end ) as ynrbgjzwArea,\n" +
                "\tSUM ( case when f_cbsxyy = '纳入卫片执法' then 1 else 0 end ) as nrwpzfCount,\n" +
                "\tSUM( case when f_cbsxyy = '纳入卫片执法' then f_area else 0 end ) as nrwpzfArea,\n" +
                "\tSUM ( case when f_cbsxyy is null and f_nxftb='人工判定' then 1 else 0 end ) as xzdwCount,\n" +
                "\tSUM( case when f_cbsxyy is null and f_nxftb='人工判定' then f_area else 0 end ) as xzdwArea,\n" +
                "\tSUM ( case when f_cbsxyy = '建筑拆除' then 1 else 0 end ) as jzccCount,\n" +
                "\tSUM( case when f_cbsxyy = '建筑拆除' then f_area else 0 end ) as jzccArea,\n" +
                "\tSUM ( case when f_cbsxyy = '面积不足' then 1 else 0 end ) as mjbzCount,\n" +
                "\tSUM ( case when f_cbsxyy = '面积不足' then f_area else 0 end ) as mjbzArea\n" +
                "from\n" +
                "\t"+jcClueSource.getfTablename() +where +"\n" +
                "group by f_rwfp\n" +
                "union all \n" +
                "select\n" +
                "\t'总计' as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea,\n" +
                "\tSUM ( case when f_cbsxyy in( '手续覆盖类','临时用地','设施农用地') then 1 else 0 end ) as ysxlCount,\n" +
                "\tSUM( case when f_cbsxyy in( '手续覆盖类','临时用地','设施农用地')  then f_area else 0 end ) as ysxlArea,\n" +
                "\tSUM( case when f_cbsxyy = '已纳入变更构建筑物' then 1 else 0 end ) as ynrbgjzwCount,\n" +
                "\tSUM( case when f_cbsxyy = '已纳入变更构建筑物' then f_area else 0 end ) as ynrbgjzwArea,\n" +
                "\tSUM ( case when f_cbsxyy = '纳入卫片执法' then 1 else 0 end ) as nrwpzfCount,\n" +
                "\tSUM( case when f_cbsxyy = '纳入卫片执法' then f_area else 0 end ) as nrwpzfArea,\n" +
                "\tSUM ( case when f_cbsxyy is null and f_nxftb='人工判定' then 1 else 0 end ) as xzdwCount,\n" +
                "\tSUM( case when f_cbsxyy is null and f_nxftb='人工判定' then f_area else 0 end ) as xzdwArea,\n" +
                "\tSUM ( case when f_cbsxyy = '建筑拆除' then 1 else 0 end ) as jzccCount,\n" +
                "\tSUM( case when f_cbsxyy = '建筑拆除' then f_area else 0 end ) as jzccArea,\n" +
                "\tSUM ( case when f_cbsxyy = '面积不足' then 1 else 0 end ) as mjbzCount,\n" +
                "\tSUM ( case when f_cbsxyy = '面积不足' then f_area else 0 end ) as mjbzArea\n" +
                "from\n" +
                "\t"+jcClueSource.getfTablename() +where +";";
        List<Map<String, Object>> dataList = jdbcTemplate.queryForList(sql);
        return dataList;
    }

    @Override
    public List<Map<String, Object>> statisticsXftbmx(String sourceId, String recordId) {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        String where = " where f_sourceid='"+sourceId+"'";
        if(StringUtils.isNotBlank(recordId)){
            where += " and f_import_recordid = '"+recordId+"'";
        }
        String sql = " select f_rwfp as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea from \n" +
                "\t"+jcClueSource.getfTablename()+ where+" and f_jcrw='常规监测' and f_nxftb='下发'\n" +
                "group by f_rwfp  \n" +
                "union all \n" +
                "select '总计' as f_xzqmc,count(1) as totalCount,sum(f_area)  as totalArea from \n" +
                "\t"+jcClueSource.getfTablename()+ where+" and f_jcrw='常规监测' and f_nxftb='下发';;";
        List<Map<String, Object>> dataList = jdbcTemplate.queryForList(sql);
        return dataList;
    }

    @Override
    public void addClueSplitProgramme(JcClueSplitProgramme jcClueSplitProgramme) {
        List<JcClueSplitProgramme> jcClueSplitProgrammeList = jcClueSplitProgrammeDao.selectBySourceIdAndProgrammeName(jcClueSplitProgramme.getSourceId(),jcClueSplitProgramme.getProgrammeName());
            if(jcClueSplitProgrammeList.size() > 0){
                throw new GwValidateException("分屏方案名称已存在，请检查参数");
            }
        //保存方案
        jcClueSplitProgramme.setId(UUID.randomUUID().toString());
        jcClueSplitProgramme.setCreateTime(new Timestamp(System.currentTimeMillis()));
        jcClueSplitProgrammeDao.gwAccessSelective(jcClueSplitProgramme);

        if(jcClueSplitProgramme.getJcClueSplitMaps().size() > 0){
            int i = 0;
            for(JcClueSplitMap jcClueSplitMap:jcClueSplitProgramme.getJcClueSplitMaps()){
                i++;
                jcClueSplitMap.setId(UUID.randomUUID().toString());
                jcClueSplitMap.setProgrammeId(jcClueSplitProgramme.getId());
                jcClueSplitMap.setOrderValue(i);
                //保存窗口
                jcClueSplitMapDao.gwAccessSelective(jcClueSplitMap);
                if(jcClueSplitMap.getJcClueSplitMapLayers().size() > 0){
                     for(JcClueSplitMapLayer jcClueSplitMapLayer:jcClueSplitMap.getJcClueSplitMapLayers()){
                         jcClueSplitMapLayer.setId(UUID.randomUUID().toString());
                         jcClueSplitMapLayer.setMapId(jcClueSplitMap.getId());
                         jcClueSplitMapLayerDao.gwAccessSelective(jcClueSplitMapLayer);
                     }
                }
            }
        }
    }

    @Override
    public void updateClueSplitProgramme(JcClueSplitProgramme jcClueSplitProgramme) {
        JcClueSplitProgramme jcClueSplitProgramme1 = jcClueSplitProgrammeDao.gwSearchByPK(jcClueSplitProgramme.getId());
        if(jcClueSplitProgramme1 == null ){
            throw new GwValidateException("线索分屏方案不存在，请检查参数");
        }
        if(!jcClueSplitProgramme1.getProgrammeName().equals(jcClueSplitProgramme.getProgrammeName())){
            List<JcClueSplitProgramme> jcClueSplitProgrammeList = jcClueSplitProgrammeDao.selectBySourceIdAndProgrammeName(jcClueSplitProgramme.getSourceId(),jcClueSplitProgramme.getProgrammeName());
            if(jcClueSplitProgrammeList.size() > 0){
                throw new GwValidateException("分屏方案名称已存在，请检查参数");
            }
            jcClueSplitProgramme1.setProgrammeName(jcClueSplitProgramme.getProgrammeName());
        }
        jcClueSplitProgramme1.setFilter(jcClueSplitProgramme.getFilter());
        jcClueSplitProgramme1.setMapNum(jcClueSplitProgramme.getMapNum());
        jcClueSplitProgramme1.setProgrammeDesc(jcClueSplitProgramme.getProgrammeDesc());
        jcClueSplitProgramme1.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        //保存方案
        jcClueSplitProgrammeDao.gwUpdateByPKSelective(jcClueSplitProgramme);

        //先删除原有窗口和窗口服务数据
        List<JcClueSplitMap> jcClueSplitMaps = jcClueSplitMapDao.selectByProgrammeId(jcClueSplitProgramme.getId());
        for(JcClueSplitMap jcClueSplitMap : jcClueSplitMaps){
            //删除窗口的地图服务数据
            jcClueSplitMapLayerDao.delByMapId(jcClueSplitMap.getId());
        }
        //删除方案对应的窗口数据
        jcClueSplitMapDao.delByProgrammeId(jcClueSplitProgramme.getId());
        //再保存方案对应窗口
        if(jcClueSplitProgramme.getJcClueSplitMaps().size() > 0){
            int i = 0;
            for(JcClueSplitMap jcClueSplitMap:jcClueSplitProgramme.getJcClueSplitMaps()){
                i++;
                jcClueSplitMap.setId(UUID.randomUUID().toString());
                jcClueSplitMap.setProgrammeId(jcClueSplitProgramme.getId());
                jcClueSplitMap.setOrderValue(i);
                //保存窗口
                jcClueSplitMapDao.gwAccessSelective(jcClueSplitMap);
                if(jcClueSplitMap.getJcClueSplitMapLayers().size() > 0){
                     for(JcClueSplitMapLayer jcClueSplitMapLayer:jcClueSplitMap.getJcClueSplitMapLayers()){
                         jcClueSplitMapLayer.setId(UUID.randomUUID().toString());
                         jcClueSplitMapLayer.setMapId(jcClueSplitMap.getId());
                         //保存窗口对应服务数据
                         jcClueSplitMapLayerDao.gwAccessSelective(jcClueSplitMapLayer);
                     }
                }
            }
        }
    }

    @Override
    public void delClueSplitProgramme(String programmeId) {
        JcClueSplitProgramme jcClueSplitProgramme = jcClueSplitProgrammeDao.gwSearchByPK(programmeId);
        if(jcClueSplitProgramme == null){
            throw new GwValidateException("分屏方案不存在，请检查参数");
        }
        List<JcClueSplitMap> jcClueSplitMaps = jcClueSplitMapDao.selectByProgrammeId(programmeId);
        for(JcClueSplitMap jcClueSplitMap : jcClueSplitMaps){
            //删除窗口的地图服务数据
            jcClueSplitMapLayerDao.delByMapId(jcClueSplitMap.getId());
        }
        //删除方案对应的窗口数据
        jcClueSplitMapDao.delByProgrammeId(programmeId);
        //删除方案
        jcClueSplitProgrammeDao.gwDeleteByPK(programmeId);
    }

    @Override
    public List<JcClueSplitProgramme> findClueSplitProgrammes(String sourceId, String programmeName) {
        List<JcClueSplitProgramme> jcClueSplitProgrammes = jcClueSplitProgrammeDao.selectBySourceIdAndLikeProgrammeName(sourceId, programmeName);
         for(JcClueSplitProgramme jcClueSplitProgramme : jcClueSplitProgrammes){
             //获取窗口数据
             List<JcClueSplitMap> jcClueSplitMaps = jcClueSplitMapDao.selectByProgrammeId(jcClueSplitProgramme.getId());
             jcClueSplitProgramme.setJcClueSplitMaps(jcClueSplitMaps);
             for(JcClueSplitMap jcClueSplitMap : jcClueSplitMaps){
                 //获取窗口对应的地图服务数据
                 List<JcClueSplitMapLayer> jcClueSplitMapLayers = jcClueSplitMapLayerDao.selectByMapId(jcClueSplitMap.getId());
                 jcClueSplitMap.setJcClueSplitMapLayers(jcClueSplitMapLayers);
             }
         }
        return jcClueSplitProgrammes;
    }

    @Override
    public List<JcClueSplitProgramme> findClueSplitProgrammeByClueId(String sourceId, String clueId) {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索类型不存在");
        }
        List<JcClueSplitProgramme> resultList= new ArrayList<>();
        List<JcClueSplitProgramme> jcClueSplitProgrammes = findClueSplitProgrammes(sourceId,null);
            for(JcClueSplitProgramme jcClueSplitProgramme : jcClueSplitProgrammes){
                if(StringUtils.isNotBlank(jcClueSplitProgramme.getFilter())){
                    String filter = jcClueSplitProgramme.getFilter();
                    String sql = " select count(1) from "+jcClueSource.getfTablename()+ " where "+filter+ " and f_id = '"+clueId+"';";
                    try{
                        Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
                        if(count > 0 ){
                            resultList.add(jcClueSplitProgramme);
                        }
                    }catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
        return resultList;
    }

    @Override
    public List<JcClueSplitProgramme> findClueSplitProgrammeByTbId(String taskId,String tbId) {
        String tableName = tskTaskBizService.getTableNameByBizId(taskId);
        if(StringUtils.isBlank(tableName)){
            throw new RuntimeException("任务图班表不存在");
        }
        List<JcClueSplitProgramme> resultList= new ArrayList<>();
        List<JcClueSplitProgramme> jcClueSplitProgrammes = findClueSplitProgrammes(taskId,null);
            for(JcClueSplitProgramme jcClueSplitProgramme : jcClueSplitProgrammes){
                if(StringUtils.isNotBlank(jcClueSplitProgramme.getFilter())){
                    String filter = jcClueSplitProgramme.getFilter();
                    String sql = " select count(1) from "+tableName+ " where "+filter+ " and f_id = '"+tbId+"';";
                    try{
                        Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
                        if(count > 0 ){
                            resultList.add(jcClueSplitProgramme);
                        }
                    }catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
        return resultList;
    }

    @Override
    public JcClueSplitProgramme findClueSplitProgrammeDetails(String programmeId) {
        JcClueSplitProgramme jcClueSplitProgramme = jcClueSplitProgrammeDao.gwSearchByPK(programmeId);
        if(jcClueSplitProgramme == null){
            throw new GwValidateException("分屏方案不存在，请检查参数");
        }
        //获取窗口数据
        List<JcClueSplitMap> jcClueSplitMaps = jcClueSplitMapDao.selectByProgrammeId(jcClueSplitProgramme.getId());
        jcClueSplitProgramme.setJcClueSplitMaps(jcClueSplitMaps);
        for(JcClueSplitMap jcClueSplitMap : jcClueSplitMaps){
            //获取窗口对应的地图服务数据
            List<JcClueSplitMapLayer> jcClueSplitMapLayers = jcClueSplitMapLayerDao.selectByMapId(jcClueSplitMap.getId());
            jcClueSplitMap.setJcClueSplitMapLayers(jcClueSplitMapLayers);
        }
        return jcClueSplitProgramme;
    }


    /**
     * 图斑监测类型分析情况
     * @param wb
     * @param maps
     */
    private void tbjxlxfxSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFRow row;
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
        cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
        cellStyle.setBorderTop(BorderStyle.THIN);//上边框
        cellStyle.setBorderRight(BorderStyle.THIN);//右边框
        // 添加数据
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); j++) {
                row = workSheet.createRow(j + 3);
                Cell cell0 = row.createCell(0);
                    cell0 .setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                    cell0.setCellStyle(cellStyle);
                Cell cell1 = row.createCell(1);
                    cell1.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString()  : null);
                    cell1.setCellStyle(cellStyle);
                Cell cell2 = row.createCell(2);
                    cell2.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString()  : null);
                    cell2.setCellStyle(cellStyle);
                Cell cell3 = row.createCell(3);
                    cell3.setCellValue(maps.get(j).get("jgzwCount") != null ? maps.get(j).get("jgzwCount").toString()  : null);
                    cell3.setCellStyle(cellStyle);
                Cell cell4 = row.createCell(4);
                    cell4.setCellValue(maps.get(j).get("jgzwArea") != null ? maps.get(j).get("jgzwArea").toString()  : null);
                    cell4.setCellStyle(cellStyle);
                Cell cell5 =  row.createCell(5);
                    cell5.setCellValue(maps.get(j).get("tdtCount") != null ? maps.get(j).get("tdtCount").toString()  : null);
                    cell5.setCellStyle(cellStyle);
                Cell cell6 = row.createCell(6);
                    cell6.setCellValue(maps.get(j).get("tdtArea") != null ? maps.get(j).get("tdtArea").toString()  : null);
                    cell6.setCellStyle(cellStyle);
                Cell cell7 = row.createCell(7);
                    cell7.setCellValue(maps.get(j).get("xzdwCount") != null ? maps.get(j).get("xzdwCount").toString()  : null);
                    cell7.setCellStyle(cellStyle);
                Cell cell8 = row.createCell(8);
                    cell8.setCellValue(maps.get(j).get("xzdwArea") != null ? maps.get(j).get("xzdwArea").toString()  : null);
                    cell8.setCellStyle(cellStyle);
                Cell cell9 =  row.createCell(9);
                    cell9.setCellValue(maps.get(j).get("yldCount") != null ? maps.get(j).get("yldCount") .toString()  : null);
                    cell9.setCellStyle(cellStyle);
                Cell cell10 = row.createCell(10);
                    cell10.setCellValue(maps.get(j).get("yldArea") != null ? maps.get(j).get("yldArea").toString()  : null);
                    cell10.setCellStyle(cellStyle);
                Cell cell11 =  row.createCell(11);
                    cell11.setCellValue(maps.get(j).get("ktCount") != null ? maps.get(j).get("ktCount").toString()  : null);
                    cell11.setCellStyle(cellStyle);
                Cell cell12 = row.createCell(12);
                    cell12.setCellValue(maps.get(j).get("ktArea") != null ? maps.get(j).get("ktArea").toString()  : null);
                    cell12.setCellStyle(cellStyle);
                Cell cell13 = row.createCell(13);
                    cell13.setCellValue(maps.get(j).get("jzccCount") != null ? maps.get(j).get("jzccCount").toString()  : null);
                    cell13.setCellStyle(cellStyle);
                Cell cell14 = row.createCell(14);
                    cell14.setCellValue(maps.get(j).get("jzccArea") != null ? maps.get(j).get("jzccArea").toString()  : null);
                    cell14.setCellStyle(cellStyle);
                Cell cell15 = row.createCell(15);
                    cell15.setCellValue(maps.get(j).get("xzgdCount") != null ? maps.get(j).get("xzgdCount").toString()  : null);
                    cell15.setCellStyle(cellStyle);
                Cell cell116 = row.createCell(16);
                    cell116.setCellValue(maps.get(j).get("xzgdArea") != null ? maps.get(j).get("xzgdArea").toString()  : null);
                    cell116.setCellStyle(cellStyle);
            }

        }
    }

    /**
     * 耕地外图斑叠加分析情况表
     * @param wb
     * @param maps
     */
    private void gdwtbdjfxSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFRow row;
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
        cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
        cellStyle.setBorderTop(BorderStyle.THIN);//上边框
        cellStyle.setBorderRight(BorderStyle.THIN);//右边框
        // 添加数据
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); j++) {
                row = workSheet.createRow(j + 5);
                Cell cell0 = row.createCell(0);
                    cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                    cell0.setCellStyle(cellStyle);
                Cell cell1 = row.createCell(1);
                    cell1.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString()  : null);
                    cell1.setCellStyle(cellStyle);
                Cell cell2 = row.createCell(2);
                    cell2.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString()  : null);
                    cell2.setCellStyle(cellStyle);
                Cell cell3 = row.createCell(3);
                    cell3.setCellValue(maps.get(j).get("ysxlCount") != null ? maps.get(j).get("ysxlCount").toString()  : null);
                    cell3.setCellStyle(cellStyle);
                Cell cell4 = row.createCell(4);
                    cell4.setCellValue(maps.get(j).get("ysxlArea") != null ? maps.get(j).get("ysxlArea").toString()  : null);
                    cell4.setCellStyle(cellStyle);
                Cell cell5 = row.createCell(5);
                    cell5.setCellValue(maps.get(j).get("ynrbgjzwCount") != null ? maps.get(j).get("ynrbgjzwCount").toString()  : null);
                    cell5.setCellStyle(cellStyle);
                Cell cell6 = row.createCell(6);
                    cell6.setCellValue(maps.get(j).get("ynrbgjzwArea") != null ? maps.get(j).get("ynrbgjzwArea").toString()  : null);
                    cell6.setCellStyle(cellStyle);
                Cell cell7 = row.createCell(7);
                    cell7.setCellValue(maps.get(j).get("nrwpzfCount") != null ? maps.get(j).get("nrwpzfCount").toString()  : null);
                    cell7.setCellStyle(cellStyle);
                Cell cell8 = row.createCell(8);
                    cell8.setCellValue(maps.get(j).get("nrwpzfArea") != null ? maps.get(j).get("nrwpzfArea").toString()  : null);
                    cell8.setCellStyle(cellStyle);
                Cell cell9 = row.createCell(9);
                    cell9.setCellValue(maps.get(j).get("xzdwCount") != null ? maps.get(j).get("xzdwCount") .toString()  : null);
                    cell9.setCellStyle(cellStyle);
                Cell cell10 = row.createCell(10);
                    cell10.setCellValue(maps.get(j).get("xzdwArea") != null ? maps.get(j).get("xzdwArea").toString()  : null);
                    cell10.setCellStyle(cellStyle);
                Cell cell11 = row.createCell(11);
                    cell11.setCellValue(maps.get(j).get("jzccCount") != null ? maps.get(j).get("jzccCount").toString()  : null);
                    cell11.setCellStyle(cellStyle);
                Cell cell12 = row.createCell(12);
                    cell12.setCellValue(maps.get(j).get("jzccArea") != null ? maps.get(j).get("jzccArea").toString()  : null);
                    cell12.setCellStyle(cellStyle);
                Cell cell13 = row.createCell(13);
                    cell13.setCellValue(maps.get(j).get("mjbzCount") != null ? maps.get(j).get("mjbzCount").toString()  : null);
                    cell13.setCellStyle(cellStyle);
                Cell cell14 = row.createCell(14);
                    cell14.setCellValue(maps.get(j).get("mjbzArea") != null ? maps.get(j).get("mjbzArea").toString()  : null);
                    cell14.setCellStyle(cellStyle);
            }

        }
    }

    /**
     *各区县拟下发图斑明细表
     * @param wb
     * @param maps
     */
    private void xftbmxSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFRow row;
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框
        // 添加数据
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); j++) {
                row = workSheet.createRow(j + 4);
                Cell cell0 = row.createCell(0);
                    cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                    cell0.setCellStyle(cellStyle);
                Cell cell1 = row.createCell(1);
                    cell1.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString()  : null);
                    cell1.setCellStyle(cellStyle);
                Cell cell2 = row.createCell(2);
                    cell2.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString()  : null);
                    cell2.setCellStyle(cellStyle);
                Cell cell3 =  row.createCell(3);
                     cell3.setCellValue("");
                     cell3.setCellStyle(cellStyle);
                Cell cell4 =row.createCell(4);
                    cell4.setCellValue("");
                    cell4.setCellStyle(cellStyle);
                Cell cell5 =row.createCell(5);
                    cell5.setCellValue(maps.get(j).get("totalCount") != null ? maps.get(j).get("totalCount").toString()  : null);
                    cell5.setCellStyle(cellStyle);
                Cell cell6 = row.createCell(6);
                     cell6.setCellValue(maps.get(j).get("totalArea") != null ? maps.get(j).get("totalArea").toString()  :null);
                     cell6.setCellStyle(cellStyle);
            }

        }
    }

    /**
     * 综合监测监管线索分布情况
     * @param wb
     * @param maps
     */
    private void zhjcjgxsbSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFRow row;
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框
        // 添加数据
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); j++) {
                row = workSheet.createRow(j + 3);
                Cell cell = row.createCell(0);
                    cell.setCellValue(j+1);
                    cell.setCellStyle(cellStyle);
                Cell cell0 = row.createCell(1);
                    cell0.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                    cell0.setCellStyle(cellStyle);
                Cell cell1 = row.createCell(2);
                    cell1.setCellValue(maps.get(j).get("小计") != null ? maps.get(j).get("小计").toString()  : null);
                    cell1.setCellStyle(cellStyle);
                Cell cell2 = row.createCell(3);
                    cell2.setCellValue(maps.get(j).get("国家线索") != null ? maps.get(j).get("国家线索").toString()  : null);
                    cell2.setCellStyle(cellStyle);
                Cell cell3 =  row.createCell(4);
                    cell3.setCellValue(maps.get(j).get("市级线索") != null ? maps.get(j).get("市级线索").toString()  : null);
                     cell3.setCellStyle(cellStyle);
                Cell cell4 =row.createCell(5);
                    cell4.setCellValue(maps.get(j).get("区县线索") != null ? maps.get(j).get("区县线索").toString()  : null);
                    cell4.setCellStyle(cellStyle);
                Cell cell5 =row.createCell(6);
                    cell5.setCellValue(maps.get(j).get("综合监测") != null ? maps.get(j).get("综合监测").toString()  : null);
                    cell5.setCellStyle(cellStyle);
                Cell cell6 = row.createCell(7);
                     cell6.setCellValue(Integer.valueOf(maps.get(j).get("小计").toString()) - Integer.valueOf(maps.get(j).get("综合监测").toString()));
                     cell6.setCellStyle(cellStyle);
                Cell cell7 = row.createCell(8);
                double dividend = Double.valueOf(maps.get(j).get("综合监测").toString());;
                double divisor = Double.valueOf(maps.get(j).get("小计").toString());
                double result = dividend / divisor;
                DecimalFormat decimalFormat = new DecimalFormat("0.00%");
                cell7.setCellValue(divisor >0 ?decimalFormat.format(result):"0.00%");
                cell7.setCellStyle(cellStyle);
            }

        }
    }

    /**
     * 审核分配清单
     * @param wb
     * @param maps
     */
    private void shfpqdSheet(XSSFWorkbook wb, List<Map<String, Object>> maps) {
        XSSFSheet workSheet = wb.getSheetAt(0);
        XSSFRow row;
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框
        // 添加数据
        if (maps.size() > 0) {
            for (int j = 0; j < maps.size(); j++) {
                row = workSheet.createRow(j + 1);
                Cell cell = row.createCell(0);
                    cell.setCellValue(j+1);
                    cell.setCellStyle(cellStyle);
                Cell cell0 = row.createCell(1);
                    cell0.setCellValue(maps.get(j).get("f_id") != null ? maps.get(j).get("f_id").toString() : null);
                    cell0.setCellStyle(cellStyle);
                Cell cell1 = row.createCell(2);
                    cell1.setCellValue(maps.get(j).get("f_xzqmc") != null ? maps.get(j).get("f_xzqmc").toString() : null);
                    cell1.setCellStyle(cellStyle);
                Cell cell2 = row.createCell(3);
                    cell2.setCellValue(maps.get(j).get("f_tbbh") != null ? maps.get(j).get("f_tbbh").toString()  : null);
                    cell2.setCellStyle(cellStyle);
                Cell cell3 = row.createCell(4);
                    cell3.setCellValue("");
                    cell3.setCellStyle(cellStyle);
            }

        }
    }


}
