package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.dto.*;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.JaxbXmlUtil;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.PinYinUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskImportTaskDataService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.*;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.CuleGroupDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.JcClueImportTaskRelDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.*;
import com.geoway.landteam.patrolclue.model.until.ThirdInterfaceUtil;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.annotation.Resource;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * @author cuiwenjing
 * @date 2021/12/6 21:10
 */
@Service
public class MJcClueSourceImpl implements MJcClueSourceService {

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    JcClueSourceMapper jcClueSourceMapper;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    JcClueFieldsMapper jcClueFieldsMapper;
    @Autowired
    JcClueGroupMapper jcClueGroupMapper;
    @Autowired
    JcClueImportTaskRelMapper jcClueImportTaskRelMapper;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    JcClueImportRelMapper jcClueImportRelMapper;
    @Autowired
    JcClueImportTaskRelFieldsMapper jcClueImportTaskRelFieldsMapper;
    @Autowired
    JcClueTemplateMapper jcClueTemplateMapper;

    @Autowired
    DataBizMapper dataBizMapper;
    @Resource
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    RegionService regionService;

    @Autowired
    JcClueFieldsService jcClueFieldsService;

    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;

    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    MTaskImportTaskDataService taskImportTaskDataService;

    @Value("${intelligent.analysis.url:}")
    protected String analysisUrl;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    AppMediaService appMediaService;

    @Override
    public List<JcClueSource> getClueList(Integer state, String sourceName,String appsId) {
        return jcClueSourceMapper.getAllList(state, sourceName, appsId);
    }

    @Override
    public JcClueSource findOne(String id) {
        return jcClueSourceMapper.selectByPrimaryKey(id);
    }
    @Override
    public JcClueSource findByName(String name) {
        return jcClueSourceMapper.findByName(name);
    }

    @Override
    public JcClueSource findByNameAndAppsId(String name,String appsId) {
        return jcClueSourceMapper.findByNameAndAppsId(name,appsId);
    }

    @Override
    public JcClueSource findByRemark(String remark) {
        return jcClueSourceMapper.findByRemark(remark);
    }

    @Override
    public  List<JcClueSource> findByNameAndSourceId(String sourceId,String name) {
        return jcClueSourceMapper.findByNameAndSourceId(sourceId,name);
    }

    @Override
    public JcClueSource createClueSource(Long userId, String sourceName, String sourceDesc,String parentId,Integer
            fLevel,String isNeedTemple,String importtype,String importfiletype,String showtype,String  templeId,
                                         String appsId,Integer clueClass) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); //设置格式
        JcClueSource bean = new JcClueSource();
        String id = UUID.randomUUID().toString();
           bean.setfName(sourceName);
           bean.setfUserid(BigDecimal.valueOf(userId));
           bean.setfId(id);
           bean.setfCreatetime(format.format(new Date()));
           bean.setfState(isNeedTemple.equals("1")?0:1);
           bean.setfIsneedtemple(isNeedTemple);
           bean.setfParentid(StringUtils.isNotBlank(parentId) ? parentId : "-1");
           bean.setfLevel(fLevel);
           bean.setfRemark(sourceDesc);
           bean.setfShowtype(StringUtils.isNotBlank(showtype)?Short.parseShort(showtype):null);
           bean.setfTempleid(templeId);
           bean.setfImporttype(importtype);
           bean.setfImportfiletype(importfiletype);
           bean.setfAppsId(appsId);
           bean.setfClueclass(clueClass);
          jcClueSourceMapper.insertSelective(bean);
        //添加默认字段
           //defaultField( bean);
        //保存模板对应字段
        if(StringUtils.isNotBlank(templeId)){
            jcClueFieldsMapper.insertFieldByTemple(id,templeId);
        }
       /* if(isNeedTemple.equals("0")){
            syncClueInfo(bean,userId,"groupNode","insert");
        }*/
        return bean;
    }

    @Override
    public void  clueSourceRecordMove(String  clueId,String  orderVal,String  orderType,String appsId){
        //orderType 1 上移 2 下移 3 置顶
        if ("1".equals(orderType)) {
            List<JcClueSource> preRecord = jcClueSourceMapper.findPreRecord(Integer.parseInt(orderVal),appsId);
            jcClueSourceMapper.updateMaxOrderVal(preRecord.get(0).getfId(), preRecord.get(1).getfOrder());
            jcClueSourceMapper.updateMaxOrderVal(preRecord.get(1).getfId(), preRecord.get(0).getfOrder());
        } else if ("2".equals(orderType)) {
            List<JcClueSource> nextRecord = jcClueSourceMapper.findNextRecord(Integer.parseInt(orderVal),appsId);
            jcClueSourceMapper.updateMaxOrderVal(nextRecord.get(0).getfId(), nextRecord.get(1).getfOrder());
            jcClueSourceMapper.updateMaxOrderVal(nextRecord.get(1).getfId(), nextRecord.get(0).getfOrder());
        } else if ("3".equals(orderType)) {
            int maxOrderVal = jcClueSourceMapper.findMaxOrderVal();
            //将区间数据进行减1
            jcClueSourceMapper.updateOrderVal(maxOrderVal, Integer.parseInt(orderVal));
            //将当前记录更新为最大排序号
            jcClueSourceMapper.updateMaxOrderVal(clueId, maxOrderVal);
        }
    }


    @Override
    public JcClueSource addClueResouceGroup(JcClueSource bean) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); //设置格式
            bean.setfLevel(bean.getfLevel()+1);
            bean.setfId(UUID.randomUUID().toString());
            bean.setfCreatetime(format.format(new Date()));
            bean.setfState(1);
          jcClueSourceMapper.insertSelective(bean);
        //线索信息同步给智能分析
        syncClueInfo(bean,bean.getfUserid().longValue(),"groupNode","insert");
        return bean;
    }

    @Override
    public JcClueSource updatNameById(JcClueSource bean,String templeId) {
          if(StringUtils.isNotBlank(templeId) && !bean.getfTempleid().equals(templeId)){
              //保存模板对应字段
              jcClueFieldsMapper.deleteByTableId(bean.getfId());
              jcClueFieldsMapper.insertFieldByTemple(bean.getfId(),templeId);
              //删除group配置
              jcClueGroupMapper.deleteBytableId(bean.getfId(),"web");
          }
        bean.setfTempleid(templeId);
        jcClueSourceMapper.updateByPrimaryKeySelective(bean);
        return bean;
    }

    @Override
    public int deleteByPrimaryKey(String id) {
        JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(id);
        if(jcClueSource.getfTablename() != null){
            syncClueInfo(id,"delete");
        }
        int result =   jcClueSourceMapper.deleteByPrimaryKey(id);
        return  result;
    }


    /**
     * 删除线索同步线索信息给智能分析
     */
    public void syncClueInfo(String sourceId,String type){
        //改为定时任务处理
        JSONObject params = new JSONObject();
        params.put("sourceId", sourceId);
        params.put("type", type);
        TaskRecord record = new TaskRecord();
        record.setId( UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_SYNC);
        record.setBizId(sourceId);
        record.setRead(0);
        record.setStarttime(new Date());
        record.setState(1);
        taskRecordService.save(record);
    }

    @Override
    public List<JcClueSource>  getClueAllGroup(Integer state, String sourceName,String appsId){
        List<JcClueSource> allList = jcClueSourceMapper.getAllList(state, sourceName, appsId);
        for(JcClueSource jcClueSource : allList){
            List<JcClueSource> tbtskTaskClasses = jcClueSourceMapper.queryByParentId(jcClueSource.getfId(),null);
            tbtskTaskClasses.forEach(this::completeChildren);
            jcClueSource.setChildren(tbtskTaskClasses);
        }
        return allList;
    }

    /**
     * 查询线索来源分组
     * @param sourceId
     * @return
     */
    @Override
    public JcClueSource clueTrees(String sourceId) {
        JcClueSource bean =  jcClueSourceMapper.selectByPrimaryKey(sourceId);
        List<JcClueSource> tbtskTaskClasses = jcClueSourceMapper.queryByParentId(sourceId,null);
        tbtskTaskClasses.forEach(this::completeChildren);
         bean.setChildren(tbtskTaskClasses);
        return bean;
    }

    @Override
    public List<JcClueSource> getCuleBysourceids(List<String> sourceIdList) {
        return jcClueSourceMapper.getCuleBysourceids(sourceIdList);
    }


    /**
     * 递归查询分组
     * @param jcClueSource
     */
    private void completeChildren(JcClueSource jcClueSource) {
        List<JcClueSource> jcClueSources = jcClueSourceMapper.queryByParentId(jcClueSource.getfId(),null);
        if(jcClueSources == null) return;
        jcClueSources.forEach(this::completeChildren);
        if(jcClueSources.size() > 0){
            jcClueSource.setChildren(jcClueSources);
        }else{
            jcClueSource.setChildren(null);
        }
    }

    private void completeClueChildren(JcClueSource jcClueSource,List<String> tableNames) {
        List<JcClueSource> jcClueSources = jcClueSourceMapper.queryByParentId(jcClueSource.getfId(),null);
       /* jcClueSources.forEach(this::completeClueChildren(jcClueSource,tableNames));*/
        if(jcClueSources != null && jcClueSources.size() > 0){
            for(JcClueSource bean : jcClueSources){
                if(StringUtils.isNotBlank(bean.getfTablename())){
                    tableNames.add(bean.getfTablename());
                }
                completeClueChildren(bean,tableNames);
            }
        }
    }

    @Override
    public JcClueSource rootJcClueSource(String sourceId) {
        JcClueSource bean =  jcClueSourceMapper.selectByPrimaryKey(sourceId);
        if(!"-1".equals(bean.getfParentid())){
            JcClueSource  jcClueSource = recursive(bean);
            return jcClueSource;
        }
        return bean;
    }

    private JcClueSource recursive(JcClueSource jcClueSource) {
        JcClueSource bean =  jcClueSourceMapper.selectByPrimaryKey(jcClueSource.getfParentid());
        if(!"-1".equals(bean.getfParentid())){
            JcClueSource  clueSource = recursive(bean);
            return clueSource;
        }
        return bean;
    }

    @Override
    public JcClueSource finishCuleSource(JcClueSource jcClueSource, Long userId) {
        if(jcClueSource.getfTablename() == null ){
            String sourceName = PinYinUtil.getFirstSpell(jcClueSource.getfName());
            String tableName = generateTableName(sourceName);
            if(StringUtils.isNotBlank(jcClueSource.getfAppsId())){
                String sql = " select f_schema from bus_apps_schema where f_apps_id = '"+jcClueSource.getfAppsId()+"'";
                String txtStr = jdbcTemplate.queryForObject(sql, String.class);
                tableName = txtStr+"."+tableName;
            }
            jcClueSource.setfTablename(tableName);
            //更新字段表对应表名称
            jcClueFieldsService.updateTableNameBytableId(tableName,jcClueSource.getfId());
            //添加默认字段
            //defaultField( jcClueSource);
            //创建结构表
            createTable(jcClueSource);
            //更新线索数据
            jcClueSource.setfState(1);
            jcClueSourceMapper.updateByPrimaryKey(jcClueSource);
            //添加默认导入关系数据
            defaultClueImportRel(jcClueSource.getfId());
            //添加默认线索列表显示字段
           // defaultClueGroup(jcClueSource.getfId(),tableName);
            //线索信息同步给智能分析
            syncClueInfo(jcClueSource,userId,"rootNode","insert");
        }else{
            //添加默认导入关系数据
            defaultClueImportRel(jcClueSource.getfId());
        }
        return jcClueSource;
    }

    /**
     * 同步线索信息给智能分析
     * @param jcClueSource
     * @param userId
     */
    public void syncClueInfo(JcClueSource jcClueSource, Long userId,String source,String type){
          //改为定时任务处理
        JSONObject params = new JSONObject();
        params.put("sourceId", jcClueSource.getfId());
        params.put("userId", userId);
        params.put("type", type);
        params.put("source", source);
        TaskRecord record = new TaskRecord();
        record.setId( UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_SYNC);
        record.setBizId(jcClueSource.getfId());
        record.setRead(0);
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        record.setTaskName(jcClueSource.getfName());
        taskRecordService.save(record);
    }



    @Override
    public JSONArray getClueStatistical(String appsId) {
        JSONArray jsonArray = new JSONArray();
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
          for(JcClueSource jcClueSource : list){
              JSONObject jsonObject = new JSONObject();
                  jsonObject.put("sourceName",jcClueSource.getfName());
                  jsonObject.put("sourceId",jcClueSource.getfId());
                  jsonObject.put("untreatedNum",0);
                  jsonObject.put("handleNum",0);
                  jsonObject.put("totalNum",0);
                  // 获取所有分组线索
                  List<String> tableNames = new ArrayList<>();
                  if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                      tableNames.add(jcClueSource.getfTablename());
                  }
                  completeClueChildren(jcClueSource,tableNames);
                   if(tableNames.size() > 0){
                       for(String s: tableNames){
                           String sql = "select f_status,count(1) from "+s+" group by f_status";
                           List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                           for(Map<String, Object> map :maps){
                               //status 0 未处理  1 已处理
                               if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                                   jsonObject.put("untreatedNum",jsonObject.getInteger("untreatedNum")+Integer.valueOf(map.get("count").toString()));
                               }else{
                                   jsonObject.put("handleNum",jsonObject.getInteger("handleNum")+Integer.valueOf(map.get("count").toString()));
                               }
                           }
                       }
                   }

                  /*if(jcClueSource.getfTablename() != null){
                      String sql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" group by f_status";
                      List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                      for(Map<String, Object> map :maps){
                          //status 0 未处理  1 已处理
                          if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                              jsonObject.put("untreatedNum",Integer.valueOf(map.get("count").toString()));
                          }else{
                              jsonObject.put("handleNum",Integer.valueOf(map.get("count").toString()));
                          }
                      }
                  }*/
              jsonObject.put("totalNum",Integer.valueOf(jsonObject.get("handleNum").toString()) + Integer.valueOf(jsonObject.get("untreatedNum").toString()));
              jsonArray.add(jsonObject);
          }
      return jsonArray;
    }

    @Override
    public JSONArray getClueStatisticalByDate(String appsId,String startTime,String endTime) {
        JSONArray jsonArray = new JSONArray();
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
          for(JcClueSource jcClueSource : list){
              JSONObject jsonObject = new JSONObject();
                  jsonObject.put("sourceName",jcClueSource.getfName());
                  jsonObject.put("sourceId",jcClueSource.getfId());
                  jsonObject.put("totalNum",0);
                  jsonObject.put("totalArea",0);
                  // 获取所有分组线索
                  List<String> tableNames = new ArrayList<>();
                  if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                      tableNames.add(jcClueSource.getfTablename());
                  }
                  completeClueChildren(jcClueSource,tableNames);
                  DecimalFormat decimalFormat = new DecimalFormat("0.00");
                   if(tableNames.size() > 0){
                       for(String s: tableNames){
                           //String sql = "select f_status,count(1) from "+s+" group by f_status";
                           String sql = "select count(1) ,sum(f_area)  from "+s;
                           if(StringUtils.isNotBlank(startTime)){
                               sql += " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";
                           }
                           List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                           for(Map<String, Object> map :maps){
                               if(map.get("count") != null && map.get("sum") != null && StringUtils.isNotBlank(map.get("sum").toString())){
                                   jsonObject.put("totalNum",jsonObject.getInteger("totalNum")+Integer.valueOf(map.get("count").toString()));
                                   BigDecimal bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                                   bd = bd.setScale(2, RoundingMode.HALF_UP);
                                   jsonObject.put("totalArea",jsonObject.getDoubleValue("totalArea")+bd.doubleValue());
                               }
                           }
                       }
                   }
              jsonArray.add(jsonObject);
          }
      return jsonArray;
    }

    @Override
    public JSONArray getClueStatisticalByClassAndDate(String appsId,String startTime,String endTime) {
        JSONArray jsonArray = new JSONArray();
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceName","国家线索");
            jsonObject.put("totalNum",0);
            jsonObject.put("totalArea",0);
            jsonArray.add(jsonObject);
        JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("sourceName","市级线索");
            jsonObject1.put("totalNum",0);
            jsonObject1.put("totalArea",0);
            jsonArray.add(jsonObject1);
        JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put("sourceName","区县线索");
            jsonObject2.put("totalNum",0);
            jsonObject2.put("totalArea",0);
            jsonArray.add(jsonObject2);
        JSONObject jsonObject3 = new JSONObject();
            jsonObject3.put("sourceName","综合监测");
            jsonObject3.put("totalNum",0);
            jsonObject3.put("totalArea",0);
            jsonArray.add(jsonObject3);
          for(JcClueSource jcClueSource : list){
                  // 获取所有分组线索
                  List<String> tableNames = new ArrayList<>();
                  if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                      tableNames.add(jcClueSource.getfTablename());
                  }
                  completeClueChildren(jcClueSource,tableNames);
                  DecimalFormat decimalFormat = new DecimalFormat("0.00");
                   if(tableNames.size() > 0){
                       for(String s: tableNames){
                           //String sql = "select f_status,count(1) from "+s+" group by f_status";
                           String sql = "select count(1) ,sum(f_area)  from "+s;
                           if(StringUtils.isNotBlank(startTime)){
                               sql += " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";
                           }
                           List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                           for(Map<String, Object> map :maps){
                               if(map.get("count") != null && map.get("sum") != null && StringUtils.isNotBlank(map.get("sum").toString())){
                                   if(jcClueSource.getfClueclass() == 1){ //国家线索
                                       jsonObject.put("totalNum",jsonObject.getInteger("totalNum")+Integer.valueOf(map.get("count").toString()));
                                       BigDecimal bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                                       bd = bd.setScale(2, RoundingMode.HALF_UP);
                                       jsonObject.put("totalArea",jsonObject.getDoubleValue("totalArea")+bd.doubleValue());
                                   }else if(jcClueSource.getfClueclass() == 3){ //市级线索
                                       jsonObject1.put("totalNum",jsonObject1.getInteger("totalNum")+Integer.valueOf(map.get("count").toString()));
                                       BigDecimal bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                                       bd = bd.setScale(2, RoundingMode.HALF_UP);
                                       jsonObject1.put("totalArea",jsonObject1.getDoubleValue("totalArea")+bd.doubleValue());
                                   }else if(jcClueSource.getfClueclass() == 4){ //区县级线索
                                       jsonObject2.put("totalNum",jsonObject2.getInteger("totalNum")+Integer.valueOf(map.get("count").toString()));
                                       BigDecimal bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                                       bd = bd.setScale(2, RoundingMode.HALF_UP);
                                       jsonObject2.put("totalArea",jsonObject2.getDoubleValue("totalArea")+bd.doubleValue());
                                   }else{
                                       if(jcClueSource.getfName().contains("综合监测")){
                                           jsonObject3.put("totalNum",jsonObject3.getInteger("totalNum")+Integer.valueOf(map.get("count").toString()));
                                           BigDecimal bd = new BigDecimal(Double.valueOf(map.get("sum").toString()));
                                           bd = bd.setScale(2, RoundingMode.HALF_UP);
                                           jsonObject3.put("totalArea",jsonObject3.getDoubleValue("totalArea")+bd.doubleValue());
                                       }
                                   }
                               }
                           }
                       }
                   }
          }
      return jsonArray;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getClueStatisticalXzqByDate(String appsId,String startTime,String endTime) {
        List<Map<String, Object>> resultMap = new ArrayList<>();
        List<Map<String, Object>> resultMap1 = new ArrayList<>();
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
          for(JcClueSource jcClueSource : list){
                  // 获取所有分组线索
                  List<String> tableNames = new ArrayList<>();
                  if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                      tableNames.add(jcClueSource.getfTablename());
                  }
                  completeClueChildren(jcClueSource,tableNames);
                   if(tableNames.size() > 0){
                       for(String s: tableNames){
                         String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                         String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+s+"  ";
                           if(StringUtils.isNotBlank(startTime)){
                               Bsql += " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";
                           }
                           String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                           List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                           if(jcClueSource.getfClueclass() == 1 || jcClueSource.getfClueclass() == 3 || jcClueSource.getfClueclass() == 4){
                               resultMap.addAll(maps);
                           }else{
                               if(jcClueSource.getfName().contains("综合监测")){
                                   resultMap1.addAll(maps);
                               }
                           }
                       }
                   }
          }
        //原始线索数据倒叙
        List<Map<String, Object>>  mapList = removeRepeatMapByKey(resultMap,"f_xzqdm");
        List<Map<String, Object>> ysxslist = mapList.stream().sorted((e1, e2) -> {
            // 降序
            return -Double.compare(Double.parseDouble(e1.get("count").toString()), Double.parseDouble(e2.get("count").toString()));
        }).collect(Collectors.toList());
        //综合监测线索数据倒叙
        List<Map<String, Object>>  mapList1 = removeRepeatMapByKey(resultMap1,"f_xzqdm");
        List<Map<String, Object>> zhjgxslist = new ArrayList<>();
        for(Map<String, Object> map : ysxslist){
            for(Map<String, Object> map1 : mapList1){
               if(map.get("f_xzqdm").toString().equals(map1.get("f_xzqdm").toString())){
                   zhjgxslist.add(map1);
                   break;
               }
            }
        }
       /* List<Map<String, Object>> zhjgxslist = mapList1.stream().sorted((e1, e2) -> {
            // 降序
            return -Double.compare(Double.parseDouble(e1.get("count").toString()), Double.parseDouble(e2.get("count").toString()));
        }).collect(Collectors.toList());*/
        Map<String, List<Map<String, Object>>> dataMap =  new HashMap<>();
        dataMap.put("原始线索",ysxslist);
        dataMap.put("综合监测线索",zhjgxslist);
      return dataMap;
    }


    @Override
    public  List<Map<String, Object>> getClueDistStatisticalByDate(String appsId,String startTime,String endTime) {
        List<Map<String, Object>> resultMap = new ArrayList<>();

        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        int i = 1;
          for(JcClueSource jcClueSource : list){
              List<Map<String, Object>> resultMap1 = new ArrayList<>();
                  // 获取所有分组线索
                  List<String> tableNames = new ArrayList<>();
                  if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                      tableNames.add(jcClueSource.getfTablename());
                  }
                  completeClueChildren(jcClueSource,tableNames);
                   if(tableNames.size() > 0){
                       for(String s: tableNames){
                         String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                         String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+s+"  ";
                         String timeSql = " ";
                           if(StringUtils.isNotBlank(startTime)){
                              /* Bsql += " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";*/
                               timeSql = " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";;
                           }
                           String sql = Asql+Bsql+timeSql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm) " +
                                   " union all\n" +
                                   "select '500000' as f_xzqdm,'重庆市' as f_xzqmc,count(1) as count from "+ s +timeSql;
                           List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                           resultMap1.addAll(maps);
                       }
                   }
              List<Map<String, Object>>  mapList = removeRepeatMapByKey(resultMap1,"f_xzqdm");
               for(Map map :mapList){
                   if(jcClueSource.getfName().contains("综合监测")){
                       map.put("综合监测",map.get("count"));
                       map.put("小计",0);
                  } else if(jcClueSource.getfName().contains("常规监测")){
                       map.put("小计",map.get("count"));
                       map.put("常规监测",map.get("count"));
                   }else if(jcClueSource.getfName().contains("卫片执法")){
                       map.put("小计",map.get("count"));
                       map.put("卫片执法",map.get("count"));
                   }  else{
                       map.put("小计",map.get("count"));
                       map.put("其他线索",map.get("count"));
                   }
                  if(i > 1){
                      for(Map map1 : resultMap){
                          if(map.get("f_xzqdm").toString().contains(map1.get("f_xzqdm").toString())){
                             /* if(!jcClueSource.getfName().contains("综合监测")){
                                  map1.put(jcClueSource.getfName(),map.get("count"));
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                              }else{
                                  map1.put("综合监测",map.get("count"));
                              }*/
                              if(jcClueSource.getfName().contains("综合监测")){
                                  if(map1.containsKey("综合监测")){
                                      map1.put("综合监测",Integer.valueOf(map1.get("综合监测").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("综合监测",map.get("count"));
                                  }
                              } else if(jcClueSource.getfName().contains("常规监测")){
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                                  if(map1.containsKey("常规监测")){
                                      map1.put("常规监测",Integer.valueOf(map1.get("常规监测").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("常规监测",map.get("count"));
                                  }
                              }else if(jcClueSource.getfName().contains("卫片执法")){
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                                  if(map1.containsKey("卫片执法")){
                                      map1.put("卫片执法",Integer.valueOf(map1.get("卫片执法").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("卫片执法",map.get("count"));
                                  }
                              }  else{
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                                  if(map1.containsKey("其他线索")){
                                      map1.put("其他线索",Integer.valueOf(map1.get("其他线索").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("其他线索",map.get("count"));
                                  }
                              }
                          }
                      }
                  }else{
                      resultMap.add(map);
                  }
               }
              i++;
          }
          //增加减少下发线索和下发线索减少率
         for(Map m : resultMap){
             double dividend = Double.valueOf(m.getOrDefault("综合监测","0").toString());;
             double divisor = Double.valueOf(m.get("小计").toString());
             double result = dividend / divisor;
             DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            m.put("减少下发线索",Integer.valueOf(m.get("小计").toString()) - Integer.valueOf(m.getOrDefault("综合监测","0").toString()));
            m.put("下发线索减少率",divisor >0 ?decimalFormat.format(result):"0.00%");
         }
        List<Map<String, Object>> list1 = resultMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("小计"), (Integer) e2.get("小计"));
        }).collect(Collectors.toList());
      return list1;
    }

    @Override
    public  List<Map<String, Object>> getClueDistStatisticalByClassAndDate(String appsId,String startTime,String endTime) {
        List<Map<String, Object>> resultMap = new ArrayList<>();

        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        int i = 1;
          for(JcClueSource jcClueSource : list){
              List<Map<String, Object>> resultMap1 = new ArrayList<>();
                  // 获取所有分组线索
                  List<String> tableNames = new ArrayList<>();
                  if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                      tableNames.add(jcClueSource.getfTablename());
                  }
                  completeClueChildren(jcClueSource,tableNames);
                   if(tableNames.size() > 0){
                       for(String s: tableNames){
                         String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                         String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+s+"  ";
                         String timeSql = " ";
                           if(StringUtils.isNotBlank(startTime)){
                              /* Bsql += " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";*/
                               timeSql = " where f_createtime between '"+ converTime(startTime) +"' and '" + converTime(endTime)+"'";;
                           }
                           String sql = Asql+Bsql+timeSql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm) " +
                                   " union all\n" +
                                   "select '500000' as f_xzqdm,'重庆市' as f_xzqmc,count(1) as count from "+ s +timeSql;
                           List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                           resultMap1.addAll(maps);
                       }
                   }
              List<Map<String, Object>>  mapList = removeRepeatMapByKey(resultMap1,"f_xzqdm");
               for(Map map :mapList){
                   map.put("区县线索",0);
                   map.put("国家线索",0);
                   map.put("市级线索",0);
                   map.put("小计",0);
                   if(jcClueSource.getfClueclass() == 1 ){
                       map.put("小计",map.get("count"));
                       map.put("国家线索",map.get("count"));
                   }else if(jcClueSource.getfClueclass() == 3){
                       map.put("小计",map.get("count"));
                       map.put("市级线索",map.get("count"));
                   }else if(jcClueSource.getfClueclass() == 4){
                       map.put("小计",map.get("count"));
                       map.put("区县线索",map.get("count"));
                   }else{
                       if(jcClueSource.getfName().contains("综合监测")){
                           map.put("综合监测",map.get("count"));
                           map.put("小计",0);
                       }
                   }
                  if(i > 1){
                      for(Map map1 : resultMap){
                          if(map.get("f_xzqdm").toString().contains(map1.get("f_xzqdm").toString())){
                              if(jcClueSource.getfClueclass() == 1 ){
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                                  if(map1.containsKey("国家线索")){
                                      map1.put("国家线索",Integer.valueOf(map1.get("国家线索").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("国家线索",map.get("count"));
                                  }
                              }else if(jcClueSource.getfClueclass() == 3){
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                                  if(map1.containsKey("市级线索")){
                                      map1.put("市级线索",Integer.valueOf(map1.get("市级线索").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("市级线索",map.get("count"));
                                  }
                              }else if(jcClueSource.getfClueclass() == 4){
                                  map1.put("小计",Integer.valueOf(map1.get("小计").toString())+Integer.valueOf(map.get("小计").toString()));
                                  if(map1.containsKey("区县线索")){
                                      map1.put("区县线索",Integer.valueOf(map1.get("区县线索").toString()) + Integer.valueOf(map.get("count").toString()));
                                  }else{
                                      map1.put("区县线索",map.get("count"));
                                  }
                              }else{
                                  if(jcClueSource.getfName().contains("综合监测")){
                                      if(map1.containsKey("综合监测")){
                                          map1.put("综合监测",Integer.valueOf(map1.get("综合监测").toString()) + Integer.valueOf(map.get("count").toString()));
                                      }else{
                                          map1.put("综合监测",map.get("count"));
                                      }
                                  }
                              }
                          }
                      }
                  }else{
                      resultMap.add(map);
                  }
               }
              i++;
          }
          //增加减少下发线索和下发线索减少率
         for(Map m : resultMap){
             double dividend = Double.valueOf(m.getOrDefault("综合监测","0").toString());;
             double divisor = Double.valueOf(m.get("小计").toString());
             double result = dividend / divisor;
             DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            m.put("减少下发线索",Integer.valueOf(m.get("小计").toString()) - Integer.valueOf(m.getOrDefault("综合监测","0").toString()));
            m.put("下发线索减少率",divisor >0 ?decimalFormat.format(result):"0.00%");
         }
        List<Map<String, Object>> list1 = resultMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("小计"), (Integer) e2.get("小计"));
        }).collect(Collectors.toList());
      return list1;
    }

    /**
     * List<Map<String, Object>>  key相同累加数量
     * @author  guang
     * @param list
     * @param mapKey
     * @return
     */
    public static List<Map<String, Object>> removeRepeatMapByKey(List<Map<String, Object>>list, String mapKey) {
        //把list中的数据转换成msp,去掉同一id值多余数据，保留查找到第一个id值对应的数据
        List<Map<String, Object>> listMap = new ArrayList<>();
        Map<String, Map> msp = new HashMap<>();
        for (int i = list.size() - 1; i >= 0; i--) {
            Map map = list.get(i);
            String id = (String) map.get(mapKey);
            map.remove(mapKey);
            //记录存在
            if(msp.containsKey(id)){
                //当前存放的数据     记录存在的数量+当前需要存放的数量
                map.put("count", Long.parseLong(msp.get(id).get("count").toString())+Long.parseLong(map.get("count").toString()));
            }
            //map 同一个key赋值会替换
            msp.put(id, map);
        }
        //把msp再转换成list,就会得到根据某一字段去掉重复的数据的List<Map>
        Set<String> mspKey = msp.keySet();
        for (String key : mspKey) {
            Map newMap = msp.get(key);
            newMap.put(mapKey, key);
            listMap.add(newMap);
        }
        return listMap;
    }


    @Override
    public JSONArray getAllClueStatistical(String appsId) {
        JSONArray jsonArray = new JSONArray();
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);

             //获取全部数据
            JSONObject allObject = new JSONObject();
                Integer alllHandleNum = 0;
                Integer allUntreatedNum = 0;
            //获取今年数据
            JSONObject yearObject = new JSONObject();
                Integer yearHandleNum = 0;
                Integer yearUntreatedNum = 0;
            //获取当季数据
            JSONObject seasonObject = new JSONObject();
                Integer seasonHandleNum = 0;
                Integer seasonUntreatedNum = 0;
            //获取本月数据
            JSONObject monthObject = new JSONObject();
            Integer monthHandleNum = 0;
            Integer monthUntreatedNum = 0;

            Calendar cal = Calendar.getInstance();
            for(JcClueSource jcClueSource : list){
                if(jcClueSource.getfTablename() != null){
                    //获取全部
                    String sql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" group by f_status";
                    List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                    for(Map<String, Object> map :maps){
                        //status 0 未处理  1 已处理
                        if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                            allUntreatedNum += Integer.valueOf(map.get("count").toString());
                        }else{
                            alllHandleNum += Integer.valueOf(map.get("count").toString());
                        }
                    }
                    //获取今年
                    int year = cal.get(Calendar.YEAR);
                    String start = year +"-01-01 00:00:00";
                    String end = year +"-12-31 23:59:59";
                    String yearsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                            "between '"+ converTime(start) +"' and '" + converTime(end) +"' group by f_status";
                    List<Map<String, Object>> map1s = jdbcTemplate.queryForList(yearsql);
                    for(Map<String, Object> map1 :map1s){
                        //status 0 未处理  1 已处理
                        if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                            yearUntreatedNum += Integer.valueOf(map1.get("count").toString());
                        }else{
                            yearHandleNum += Integer.valueOf(map1.get("count").toString());
                        }
                    }
                    //获取本季度
                    String seasonStart = getCurrentQuarterStartTime();
                    String  seasonEnd = getCurrentQuarterEndTime();
                    String seasonsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                            "between '"+ converTime(seasonStart) +"' and '" + converTime(seasonEnd) +"' group by f_status";
                    List<Map<String, Object>> map3s = jdbcTemplate.queryForList(seasonsql);
                    for(Map<String, Object> map3 :map3s){
                        //status 0 未处理  1 已处理
                        if(map3.get("f_status") != null && map3.get("f_status").toString().equals("0")){
                            seasonUntreatedNum += Integer.valueOf(map3.get("count").toString());
                        }else{
                            seasonHandleNum += Integer.valueOf(map3.get("count").toString());
                        }
                    }
                    //获取本月
                    String monthStart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
                    String  monthEnd = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
                    String monthsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                            "between '"+ converTime(monthStart) +"' and '" + converTime(monthEnd) +"' group by f_status";
                    List<Map<String, Object>> map2s = jdbcTemplate.queryForList(monthsql);
                    for(Map<String, Object> map2 :map2s){
                        //status 0 未处理  1 已处理
                        if(map2.get("f_status") != null && map2.get("f_status").toString().equals("0")){
                            monthUntreatedNum += Integer.valueOf(map2.get("count").toString());
                        }else{
                            monthHandleNum += Integer.valueOf(map2.get("count").toString());
                        }
                    }
                }
            }
               //汇总数据
                allObject.put("alllHandleNum",alllHandleNum);
                allObject.put("allUntreatedNum",allUntreatedNum);
                allObject.put("allTotalNum",alllHandleNum + allUntreatedNum);
                allObject.put("name","总计");
               //年数据
                yearObject.put("yearHandleNum",yearHandleNum);
                yearObject.put("yearUntreatedNum",yearUntreatedNum);
                yearObject.put("yearTotalNum",yearUntreatedNum + yearHandleNum);
                  yearObject.put("name","本年度");
               //季数据
                seasonObject.put("seasonHandleNum",seasonHandleNum);
                seasonObject.put("seasonUntreatedNum",seasonUntreatedNum);
                seasonObject.put("seasonTotalNum",seasonHandleNum + seasonUntreatedNum);
               seasonObject.put("name","本季度");
               //月数据
                monthObject.put("monthHandleNum",monthHandleNum);
                monthObject.put("monthUntreatedNum",monthUntreatedNum);
                monthObject.put("monthTotalNum",monthUntreatedNum + monthHandleNum);
                 monthObject.put("name","本月份");
           jsonArray.add(allObject);
           jsonArray.add(yearObject);
           jsonArray.add(seasonObject);
           jsonArray.add(monthObject);

      return jsonArray;
    }

    /**
     * 线索库  获取月度数据
     * @return
     */
    public JSONObject getClueStatisticalByMonth(String appsId){
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        //获取全部数据
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for(JcClueSource jcClueSource : list){
           /* if(jcClueSource.getfTablename() != null) {
                //获取本月
                String monthStart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
                String  monthEnd = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
                String monthsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                        "between '"+ converTime(monthStart) +"' and '" + converTime(monthEnd) +"' group by f_status";
                List<Map<String, Object>> map2s = jdbcTemplate.queryForList(monthsql);
                for(Map<String, Object> map1 :map2s){
                    //status 0 未处理  1 已处理
                    if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                        untreatedNum += Integer.valueOf(map1.get("count").toString());
                    }else{
                        handleNum += Integer.valueOf(map1.get("count").toString());
                    }
                }
            }*/
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource,tableNames);
            if(tableNames.size() > 0){
                for(String s: tableNames){
                    //获取本月
                    String monthStart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
                    String  monthEnd = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
                    String monthsql = "select f_status,count(1) from "+s+" where f_createtime " +
                            "between '"+ converTime(monthStart) +"' and '" + converTime(monthEnd) +"' group by f_status";
                    List<Map<String, Object>> map2s = jdbcTemplate.queryForList(monthsql);
                    for(Map<String, Object> map1 :map2s){
                        //status 0 未处理  1 已处理
                        if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                            untreatedNum += Integer.valueOf(map1.get("count").toString());
                        }else{
                            handleNum += Integer.valueOf(map1.get("count").toString());
                        }
                    }
                }
            }

        }
        //汇总数据
        object.put("handleNum",handleNum);
        object.put("untreatedNum",untreatedNum);
        object.put("totalNum",handleNum + untreatedNum);
        object.put("name","总计");
        return object;
    }
    /**
     * 线索库  获取季度数据
     * @return
     */
    public JSONObject getClueStatisticalBySeason(String appsId){
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        //获取全部数据
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        for(JcClueSource jcClueSource : list){
            /*if(jcClueSource.getfTablename() != null) {
                //获取本季度
                String seasonStart = getCurrentQuarterStartTime();
                String  seasonEnd = getCurrentQuarterEndTime();
                String seasonsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                        "between '"+ converTime(seasonStart) +"' and '" + converTime(seasonEnd) +"' group by f_status";
                List<Map<String, Object>> map1s = jdbcTemplate.queryForList(seasonsql);
                for(Map<String, Object> map1 :map1s){
                    //status 0 未处理  1 已处理
                    if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                        untreatedNum += Integer.valueOf(map1.get("count").toString());
                    }else{
                        handleNum += Integer.valueOf(map1.get("count").toString());
                    }
                }
            }*/
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource,tableNames);
            if(tableNames.size() > 0){
                for(String s: tableNames){
                    //获取本季度
                    String seasonStart = getCurrentQuarterStartTime();
                    String  seasonEnd = getCurrentQuarterEndTime();
                    String seasonsql = "select f_status,count(1) from "+s+" where f_createtime " +
                            "between '"+ converTime(seasonStart) +"' and '" + converTime(seasonEnd) +"' group by f_status";
                    List<Map<String, Object>> map1s = jdbcTemplate.queryForList(seasonsql);
                    for(Map<String, Object> map1 :map1s){
                        //status 0 未处理  1 已处理
                        if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                            untreatedNum += Integer.valueOf(map1.get("count").toString());
                        }else{
                            handleNum += Integer.valueOf(map1.get("count").toString());
                        }
                    }
                }
            }
        }
        //汇总数据
        object.put("handleNum",handleNum);
        object.put("untreatedNum",untreatedNum);
        object.put("totalNum",handleNum + untreatedNum);
        object.put("name","总计");
        return object;
    }
    /**
     * 线索库  获取年数据
     * @return
     */
    public JSONObject getClueStatisticalByYear(String appsId){
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        //获取全部数据
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for(JcClueSource jcClueSource : list){
            /*if(jcClueSource.getfTablename() != null) {
                //获取今年
                int year = cal.get(Calendar.YEAR);
                String start = year +"-01-01 00:00:00";
                String end = year +"-12-31 23:59:59";
                String yearsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                        "between '"+ converTime(start) +"' and '" + converTime(end) +"' group by f_status";
                List<Map<String, Object>> map1s = jdbcTemplate.queryForList(yearsql);
                for(Map<String, Object> map1 :map1s){
                    //status 0 未处理  1 已处理
                    if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                        untreatedNum += Integer.valueOf(map1.get("count").toString());
                    }else{
                        handleNum += Integer.valueOf(map1.get("count").toString());
                    }
                }
            }*/
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource,tableNames);
            if(tableNames.size() > 0){
                for(String s: tableNames){
                    //获取今年
                    int year = cal.get(Calendar.YEAR);
                    String start = year +"-01-01 00:00:00";
                    String end = year +"-12-31 23:59:59";
                    String yearsql = "select f_status,count(1) from "+s+" where f_createtime " +
                            "between '"+ converTime(start) +"' and '" + converTime(end) +"' group by f_status";
                    List<Map<String, Object>> map1s = jdbcTemplate.queryForList(yearsql);
                    for(Map<String, Object> map1 :map1s){
                        //status 0 未处理  1 已处理
                        if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                            untreatedNum += Integer.valueOf(map1.get("count").toString());
                        }else{
                            handleNum += Integer.valueOf(map1.get("count").toString());
                        }
                    }
                }
            }


        }
        //汇总数据
        object.put("handleNum",handleNum);
        object.put("untreatedNum",untreatedNum);
        object.put("totalNum",handleNum + untreatedNum);
        object.put("name","总计");
        return object;
    }

    /**
     * 线索库  获取全部数据
     * @return
     */
    public JSONObject getClueStatisticalByAll(String appsId){
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        //获取全部数据
        JSONObject allObject = new JSONObject();
        Integer alllHandleNum = 0;
        Integer allUntreatedNum = 0;
        for(JcClueSource jcClueSource : list){

            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource,tableNames);
            if(tableNames.size() > 0){
                for(String s: tableNames){
                    String sql = "select f_status,count(1) from "+s+" group by f_status";
                    List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                    for(Map<String, Object> map :maps){
                        //status 0 未处理  1 已处理
                        if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                            allUntreatedNum += Integer.valueOf(map.get("count").toString());
                        } else {
                            alllHandleNum += Integer.valueOf(map.get("count").toString());
                        }
                    }
                }
            }


            /*   if(jcClueSource.getfTablename() != null) {
             //获取全部
                String sql = "select f_status,count(1) from " + jcClueSource.getfTablename() + " group by f_status";
                List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                for (Map<String, Object> map : maps) {
                    //status 0 未处理  1 已处理
                    if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                        allUntreatedNum += Integer.valueOf(map.get("count").toString());
                    } else {
                        alllHandleNum += Integer.valueOf(map.get("count").toString());
                    }
                }
            }*/
        }
        //汇总数据
        allObject.put("handleNum",alllHandleNum);
        allObject.put("untreatedNum",allUntreatedNum);
        allObject.put("totalNum",alllHandleNum + allUntreatedNum);
        allObject.put("name","总计");
        return allObject;
    }




    @Override
    public  Map<String, Object> getClueStatisticalByXzqdm(String  xzqdm,String appsId) {
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        Map<String, Object> resultMap = new HashMap<>();
            for(JcClueSource jcClueSource : list) {
                if(jcClueSource.getfTablename() != null){
                    //获取全部
                    String sql = "select substring(f_xzqdm,0,5) xzqdm,count(1) count from " + jcClueSource.getfTablename() + " where f_xzqdm" +
                            " like '" + xzqdm.replace("00", "") + "%' group  by  substring(f_xzqdm,0,5) order by count desc";
                    List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                    for (Map<String, Object> map : maps) {
                        String xzqdmsys = map.get("xzqdm").toString().length()< 6 ?map.get("xzqdm").toString()+"00" : map.get("xzqdm").toString();
                        if(StringUtils.isBlank(xzqdmsys) || xzqdmsys.length()>12){
                            continue;
                        }
                        if(resultMap.containsKey(xzqdmsys)){
                            JSONObject object = (JSONObject) resultMap.get(xzqdmsys);
                            object.put("count",Integer.valueOf(object.get("count").toString()) + Integer.valueOf(map.get("count").toString()));
                        }else{
                            JSONObject newObject = new JSONObject();
                            newObject.put("xzqdm",xzqdmsys);
                            newObject.put("count",Integer.valueOf(map.get("count").toString()));
                            newObject.put("xzqmc",regionService.getName(xzqdmsys));
                            resultMap.put(xzqdmsys,newObject);
                        }
                    }
                }

            }
      return resultMap;
    }

    /**
     * 将线索索接导入到任务中
     * @param bean
     * @throws Exception
     */
    @Override
    public void importCuleTaskData(TaskRecord bean) throws Exception {
        if(StringUtils.isNoneEmpty(bean.getParam())) {
            JSONObject jsonObject = JSONObject.parseObject(bean.getParam());
            JSONArray jsonArray = JSONObject.parseArray(jsonObject.getString("importRel"));
            String sourceId = jsonObject.getString("sourceId");
            String recordId = jsonObject.getString("recordId");
            String taskId = jsonObject.getString("taskId");
            String userId = jsonObject.getString("userId");

            JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
            if (jcClueSource == null) {
                throw new RuntimeException("线索表不存在");
            }
            TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
            TbtskObjectinfo tableByTableId = tskTaskBizService.getTableByTableId(tskTaskBiz.getTableId());
            if (StringUtils.isBlank(tableByTableId.getfTablename())) {
                throw new RuntimeException("任务表不存在");
            }
            String tableNameByBizId = tableByTableId.getfTablename();
            List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            //处理新增的市、县、镇、村
            List<String> fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());

            String tablename = jcClueSource.getfTablename();
            String where = "";
            String where1 = "";
            String where2 = "";
            List<String>w = new ArrayList<>();
            List<String>w1 = new ArrayList<>();
            List<String>w2 = new ArrayList<>();
            if (StringUtils.isNotBlank(sourceId)) {
                w.add("r1.f_sourceid='" + sourceId + "'");
                w1.add("f_sourceid='" + sourceId + "'");
                w2.add("f_sourceid='" + sourceId + "'");
            }

            if (StringUtils.isNotBlank(recordId)) {
                w.add("r1.f_importid = '" + recordId + "'");
                w1.add("f_import_recordid = '" + recordId + "'");
                w2.add("f_importid='" + recordId + "'");


            }
            if (StringUtils.isNotBlank(taskId)) {
                w.add("r1.f_taskid = '" + taskId + "' ");
                w2.add("f_taskid='" + taskId + "'");
            }
            // 只增加没有的数据
            w.add("not exists(select null from " + tableNameByBizId + " tb where tb.f_id = r1.f_tbid and r1.f_type='1')");
            //只变更已有的数据
            w1.add("f_id in (select r1.f_clueid from jc_clue_task_rel r1," + tablename + " r2 where " +
                    "r1.f_clueid =r2.f_id and r1.f_type='1')");
            where = StringUtils.join(w," and ");
            where1 = StringUtils.join(w1," and ");
            where2 = StringUtils.join(w2," and ");
            List<String> fieldOriList = new ArrayList<>();
            List<String> fieldTarList = new ArrayList<>();

            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject object = jsonArray.getJSONObject(i);
                String oriField = object.getString("oriField");
                String tarField = object.getString("tarField");
                fieldOriList.add(oriField);
                fieldTarList.add(tarField);
            }
            fieldTarList.add("f_id");
            fieldTarList.add("f_shape");
            fieldTarList.add("f_status");
            fieldTarList.add("f_lon");
            fieldTarList.add("f_lat");
            fieldTarList.add("f_xzqdmsys");
            fieldTarList.add("f_xzqmc1");
            fieldTarList.add("f_createtime");
            fieldTarList.add("f_userid");
            if (fields.contains("f_xzqdmcity")) {
                fieldTarList.add("f_xzqdmcity");
                fieldTarList.add("f_xzqdmcounty");
                fieldTarList.add("f_xzqdmtown");
                fieldTarList.add("f_xzqdm");
                fieldTarList.add("f_xzqmc");
                fieldTarList.add("f_tbmj");
            }

            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into  " + tableNameByBizId + "(" + StringUtils.join(fieldTarList, ",") + ")");
            stringBuffer.append(" select ");
            if (!fieldOriList.isEmpty()) {
                for (String s : fieldOriList) {
                    stringBuffer.append(" r2." + s + ",");
                }
            }
            stringBuffer.append("r1.f_tbid");
            stringBuffer.append(",r2.f_shape");
            stringBuffer.append(",1");
            stringBuffer.append(",st_x(st_centroid(r2.f_shape))");
            stringBuffer.append(",st_y(st_centroid(r2.f_shape))");
            stringBuffer.append(",r2.f_xzqdmvillage");
            stringBuffer.append(",r2.f_xzqmc");
            stringBuffer.append("," + System.currentTimeMillis() + "");
            stringBuffer.append("," + userId + "");
            if (fields.contains("f_xzqdmcity")) {
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,5)||'00'");
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,7)");
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,10)");
                stringBuffer.append(",substring(r2.f_xzqdmvillage,0,7)");
                stringBuffer.append(",r2.f_xzqmc");
                stringBuffer.append(",r2.f_area");
            }
            stringBuffer.append(" from jc_clue_task_rel r1, " + tablename + " r2  where r2.f_id = r1.f_clueid and " + where);
            dataBizMapper.excuteSql(stringBuffer.toString());
            //将变更字段shape的srid的值
            /* String shapesql = "select UpdateGeometrySRID('"+tableNameByBizId+"', 'f_shape', 4490)";*/
            if (tableNameByBizId.contains(".")) {
                String[] split = tableNameByBizId.split("\\.");
                jdbcTemplate.execute("select UpdateGeometrySRID('','" + split[0] + "','" + split[1] + "', 'f_shape', 4490)");
            } else {
                jdbcTemplate.execute("select UpdateGeometrySRID('" + tableNameByBizId + "', 'f_shape', 4490)");
            }
            List<String> tbids = new ArrayList<>();
            Map<String,String>mapIDS = new HashMap<>();
            String sql = String.format("select f_tbid,f_clueid from jc_clue_task_rel where f_clueid in (select f_clueid from %s where %s)", jcClueSource.getfTablename(), where2);
            List<Map<String, Object>> mapTbids = jdbcTemplate.queryForList(sql);
            for (Map map : mapTbids) {
                String tbid = map.get("f_tbid").toString();
                String clueId = map.get("f_clueid").toString();
                mapIDS.put(clueId,tbid);
                tbids.add(tbid);
            }
            List<String>clues = mapIDS.keySet().stream().collect(Collectors.toList());
            List<AppMedia>medias =  appMediaService.queryByGalleryids(clues);
            if(medias!=null&&!medias.isEmpty()) {
                List<AppMedia> mediaInsert = new ArrayList<>();
                for(AppMedia media:medias)
                {
                    AppMedia insert = new AppMedia();
                    BeanUtil.copyProperties(media,insert);
                    insert.setId(UUID.randomUUID().toString());
                    insert.setGalleryid(mapIDS.get(media.getGalleryid()));
                    mediaInsert.add(insert);

                }
                appMediaService.save(mediaInsert);
            }

            /*  jdbcTemplate.execute(shapesql);*/
            //更新线索批量状态 将数据变更为已处理
            sql = " update " + tablename + "  set  f_status = 1 ,f_stage = '2',f_state =\n" +
                    "CASE\n" +
                    " WHEN  f_state = 1 THEN 1" +
                    " WHEN  f_state = 2 THEN 3" +
                    " WHEN  f_state = 3 THEN 3" +
                    "else  1 end " +
                    "where " + where1;
            dataBizMapper.excuteSql(sql);
            if (tskTaskBiz.getMode() != null && tskTaskBiz.getMode().equals(2)) {
                if (tbids.size() > 0) {
                    JSONObject additionJson = new JSONObject();
                    additionJson.put("count", tbids.size());
                    additionJson.put("addOrUpdate", "ADD");
                    additionJson.put("taskMode", tskTaskBiz.getMode());
                    additionJson.put("curMode", "receive");

                    String tempId = UUID.randomUUID().toString();
                    TaskDataDbParameter parameter = new TaskDataDbParameter();
                    parameter.setRecordId(tempId);
                    parameter.setTaskId(tskTaskBiz.getId());
                    parameter.setGroups(new JSONArray());
                    parameter.setOrgs(new JSONArray());
                    parameter.setAddition(additionJson);
                    parameter.setDate(String.valueOf(System.currentTimeMillis()));
                    //parameter.setIds(add);
                    parameter.setMode(tskTaskBiz.getMode().toString());

                    List<TaskRecordTemp> tempList = new ArrayList<>();
                    for (int i = 0; i < tbids.size(); i++) {
                        TaskRecordTemp temp = new TaskRecordTemp();
                        temp.setId(UUID.randomUUID().toString());
                        temp.setRecordid(tempId);
                        temp.setDataid(tbids.get(i));
                        tempList.add(temp);
                    }

                    taskRecordService.saveTaskRecordTemp(tempList);

                    TaskRecord record2 = new TaskRecord();
                    record2.setId(tempId);
                    record2.setParam(JSONObject.toJSONString(parameter));
                    record2.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                    record2.setStarttime(new Date());
                    record2.setState(1);
                    record2.setUserid(Long.parseLong(userId));
                    taskRecordService.save(record2);
                }
            }

        }else{
            throw new RuntimeException("参数为空");
        }

    }

    @Override
    public void syncCuleInfo(TaskRecord bean) throws Exception {
        if(StringUtils.isNoneEmpty(bean.getParam())){
            JSONObject jsonObject = JSONObject.parseObject(bean.getParam());
            String sourceId = jsonObject.getString("sourceId");
           /* String userId = jsonObject.getString("userId");*/
            String type = jsonObject.getString("type");
            JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
            if(!type.equals("delete") && jcClueSource == null ){
                throw new RuntimeException("线索表不存在");
            }
            JSONObject param = new JSONObject();
            JSONObject resultObject = new JSONObject();
            String accessUrl = "";
            switch (type){
                case "insert":  //新增数据来源或者分组
                    JSONObject layer = new JSONObject();
                    layer.put("rid",jcClueSource.getfId());
                    layer.put("type",0);
                    layer.put("layername",jcClueSource.getfName());
                    layer.put("pid",jcClueSource.getfParentid());
                    layer.put("tablename",jcClueSource.getfTablename());
                    layer.put("orderindex",jcClueSource.getfOrder());
                    layer.put("state",jcClueSource.getfState());
                    param.put("layer",layer);
                    String source = jsonObject.getString("source");
                    if(source.equals("rootNode")){
                        param.put("fields",converFields(jcClueSource,null));
                    }
                    accessUrl = analysisUrl+"/api/layer/addLayerAndFields";
                    resultObject = ThirdInterfaceUtil.getThirdTaskDataDetails(param, accessUrl);
                    break;
                case "update":  //新增或修改字段
                    String fieldId = jsonObject.getString("fieldId");
                    param.put("fields",converFields(jcClueSource,fieldId));
                    accessUrl = analysisUrl+"/api/layer/addFields";
                    resultObject = ThirdInterfaceUtil.getThirdTaskDataDetails(param, accessUrl);
                    break;
                case "delete":  //线索或者分组删除
                    param.put("rid",sourceId);
                    param.put("type",0);
                    accessUrl = analysisUrl+"/api/layer/deleteLayer";
                    resultObject = ThirdInterfaceUtil.getThirdTaskDataDetails(param, accessUrl);
                    break;
                default:
                    throw new GwValidateException("类型type不能为空");
            }
            bean.setState(3);
            bean.setData(accessUrl);
            bean.setResult(JSONObject.toJSONString(resultObject,SerializerFeature.WriteMapNullValue));
            bean.setRemark(JSONObject.toJSONString(param,SerializerFeature.WriteMapNullValue));
            bean.setEndtime(new Date());
            taskRecordService.save(bean);
        }else{
            throw new GwValidateException("参数为空");
        }
    }

    /**
     * 处理字段信息
     * @param jcClueSource
     * @param fieldId
     * @return
     */
    public JSONArray converFields(JcClueSource jcClueSource,String fieldId){
        List<JcClueFields> fields = new ArrayList<>();
        if(fieldId == null ){
            String rootSourceId = jcClueSource.getfId();
           /* if(!jcClueSource.getfParentid().equals("-1")){
                JcClueSource  bean = rootJcClueSource(rootSourceId);
                rootSourceId = bean.getfId();
            }*/
            fields = jcClueFieldsService.findByTableId(rootSourceId);
        }else{
            fields.add(jcClueFieldsService.selectByPrimaryKey(fieldId));
        }
        JSONArray jsonArray = new JSONArray();
        for(JcClueFields field : fields){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("resultshow",0);
            jsonObject.put("code",field.getfFieldname());
            jsonObject.put("orderindex",field.getfOrder());
            jsonObject.put("conditionshow",0);
            jsonObject.put("tableshow",0);
            Integer  fieldtype = Integer.valueOf(field.getfFieldtype());
                if(fieldtype == 1){
                    fieldtype = 4;
                    if(StringUtils.isNotBlank(field.getfCodetableid())){
                        fieldtype = 1;
                    }
                }else if(fieldtype == 1){
                    fieldtype = 3;
                    if(StringUtils.isNotBlank(field.getfCodetableid())){
                        fieldtype = 1;
                    }
                }else if(fieldtype == 3 || fieldtype == 7){
                    fieldtype = 2;
                }else if(fieldtype == 4 || fieldtype == 5){
                    fieldtype = 5;
                }else{
                    fieldtype = 4;
                }
            jsonObject.put("fieldtype",fieldtype);
            jsonObject.put("enumkey",field.getfCodetableid());
            jsonObject.put("unit",field.getUnit());
            jsonObject.put("layerid",jcClueSource.getfId());
            jsonObject.put("name",field.getfAlias());
            jsonObject.put("id",field.getfId());
            jsonObject.put("oid",field.getfId());
            jsonObject.put("webconfig",0);
            Integer  basetype = null;
            if("f_id".equals(field.getfFieldname())){
                basetype = 0;
            }else  if("f_xzqmc".equals(field.getfFieldname())){
                basetype = 2;
            }else  if("f_xzqdm".equals(field.getfFieldname())){
                basetype = 1;
            }else  if("f_area".equals(field.getfFieldname())){
                basetype = 3;
            }else  if("f_shape".equals(field.getfFieldname())){
                basetype = 4;
            }
            jsonObject.put("basetype",basetype);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }




    /**
     *   添加默认导入关系数据
     * @param sourceId
     */
    @Override
    public void defaultClueImportRel(String sourceId) {
        List<JcClueFields> fields =
                jcClueFieldsService.findByTableId(sourceId).stream()
                        .filter(r -> r.getfFieldInnerOuterSys() == 1)
                        .collect(Collectors.toList());
        //删除关系映射
        jcClueImportRelMapper.deleteBySourceId(sourceId);
        for (JcClueFields field : fields) {
            JcClueImportRel bean = new JcClueImportRel();
            bean.setfId(UUID.randomUUID().toString());
            bean.setfFieldname(field.getfFieldname());
            bean.setfFieldnameImport(field.getfFieldname());
            bean.setfSourceid(sourceId);
            bean.setfRemark("默认");
            jcClueImportRelMapper.insertSelective(bean);
        }
    }

    @Override
    public String exportClueDefine(Long userId, String sourceId) throws JAXBException {
        TaskDefineDTO taskDefineDTO = new TaskDefineDTO();
        List<TaskMetaDTO> taskMetaDTOList = new ArrayList<>();
        List<TaskCategoryDTO> taskCategoryDTOList= new ArrayList<>();

        TaskCategoryDTO categoryDTO = new TaskCategoryDTO();
            categoryDTO.setId("1");
            categoryDTO.setPid("1");
            categoryDTO.setName("线索配置");
        taskCategoryDTOList.add(categoryDTO);
        List<JcClueSource> clueList = new ArrayList<>();
        if (sourceId != null) {
            //单个线索导出任务配置
            JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
            clueList.add(jcClueSource);
        }
        for (JcClueSource clue : clueList) {
            TaskMetaDTO metaDTO = new TaskMetaDTO();
            metaDTO.setId(clue.getfId());
            metaDTO.setName(clue.getfName());
            metaDTO.setGranularity(1);
            metaDTO.setCategoryId("0000");

            List<TaskFieldMappingDTO> fieldMappingDTOList = new ArrayList<>();
            List<JcClueFields> fields = jcClueFieldsService.findByTableId(sourceId);
            for (JcClueFields field : fields) {
                if (field.getfFieldInnerOuterSys().intValue() == FieldGroupTypeConstant.INNER_FIELD
                        || field.getfFieldInnerOuterSys().intValue() == 3
                        || field.getfFieldInnerOuterSys().intValue() == 5) {
                   /* if (field.getfFieldname().equals("f_xzqmc")) {
                        continue;
                    }*/
                    TaskFieldMappingDTO fieldMappingDTO = new TaskFieldMappingDTO();
                    TaskFieldDefineDTO fieldDefineDTO = new TaskFieldDefineDTO();
                    fieldDefineDTO.setId(field.getfId());
                    fieldDefineDTO.setAlias(field.getfAlias());
                    fieldDefineDTO.setName(field.getfFieldname());
                    if (StringUtils.isNumeric(field.getfFieldtype())) {
                        // 翻译字段类型
                        fieldDefineDTO.setType(TskTaskBizDBUtil.getDBType(field.getfFieldtype()));
                    } else {
                        fieldDefineDTO.setType(field.getfFieldtype());
                    }

                    if (field.getfLength() != null) {
                        fieldDefineDTO.setLength(field.getfLength().toString());
                    } else {
                        fieldDefineDTO.setLength("-1");
                    }

                    if (field.getfPrecision() != null) {
                        fieldDefineDTO.setAccuracy(field.getfPrecision().toString());
                    } else {
                        fieldDefineDTO.setAccuracy("0");
                    }

                    if (field.getfNullable() == 0) {
                        fieldDefineDTO.setIsRequired("true");
                    } else {
                        fieldDefineDTO.setIsRequired("false");
                    }

                    fieldDefineDTO.setIsBase("true");
                    fieldDefineDTO.setIsOutwork("false");
                    if (field.getfUnique() != null) {
                        if (field.getfUnique() == 0) {
                            fieldDefineDTO.setUnique("false");
                        } else {
                            fieldDefineDTO.setUnique("true");
                        }
                    }

                    fieldMappingDTO.setFieldDefineDTO(fieldDefineDTO);
                    fieldMappingDTOList.add(fieldMappingDTO);
                }
            }
            metaDTO.setFieldMappingDTOList(fieldMappingDTOList);
            taskMetaDTOList.add(metaDTO);
        }

        taskDefineDTO.setTaskMetaDTOList(taskMetaDTOList);
        taskDefineDTO.setCategoryDTOList(taskCategoryDTOList);
        return JaxbXmlUtil.convertToXML(taskDefineDTO, "gb2312");
    }

    @Override
    public  List<TaskRecord> importClueData(HttpServletRequest request, String sourceId, Long userId, String batchId, String batchName, String batchDesc,String updateType) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        if (jcClueSource.getfState() < 1 || StringUtils.isBlank(jcClueSource.getfTablename()) ) {
            throw new RuntimeException("线索创建未完成，不能加载数据");
        }
        List<TaskRecord> taskRecords = new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            String id = UUID.randomUUID().toString();
            while (iter.hasNext()) {
                MultipartFile shapeFile = multiRequest.getFile(iter.next());
                if (shapeFile != null) {

                    File zipFile = null;
                    File dir = new File(uploadDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    zipFile = File.createTempFile("tmp", ".gty", dir);
                    FileUtils.copyInputStreamToFile(shapeFile.getInputStream(), zipFile);
                    String zipName = zipFile.getAbsolutePath();
                    String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
                    Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");
                    //将参数存放到定时任务列表中
                        checkData(unzipFileDir, ".shp");//检测数据是否存在
                    String fileName = UUID.randomUUID().toString()+".gty";
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String dateString = sdf.format(new Date());
                    String obsFilePath = "importClueData/" + dateString + "/" + fileName;
                    String resultUrl = defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);

                    taskImportTaskDataService.createImportLog(jcClueSource, tbtskDataLog, userId);

                    JSONObject params = new JSONObject();
                    params.put("unzipFileDir", resultUrl);
                    params.put("userId", userId);
                    params.put("sourceId", sourceId);
                    params.put("updateType", StringUtils.isBlank(updateType)?"0":updateType);
                    params.put("batchId", StringUtils.isNotBlank(batchId)?batchId:StringUtils.isNotBlank(batchName)?id:"");
                    params.put("tbtskDataLogId", tbtskDataLog.getId());
                    TaskRecord record = new TaskRecord();
                    record.setId(UUID.randomUUID().toString());
                    record.setParam(JSONObject.toJSONString(params));
                    record.setTasktype(JobConstants.JOB_TYPE_CULE_IMPORT);
                    record.setData(sourceId);
                    record.setStarttime(new Date());
                    record.setState(1);
                    record.setUserid(userId);
                    taskRecordService.save(record);
                    taskRecords.add(record);

                }
            }
            if(StringUtils.isNotBlank(batchName)){
                // 插入批次
                JcClueImportRecord bean = new JcClueImportRecord();
                bean.setfId(id);
                bean.setfCreatetime(new Date());
                bean.setfName(batchName);
                bean.setfRemark(batchDesc);
                bean.setfSourceid(jcClueSource.getfId());
                bean.setfCount(0);
                bean.setfJcmj(new BigDecimal(0));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                bean.setfJcsj( df.format(new Date()));
                jcClueImportRecordService.insert(bean);
            }
        }
        return taskRecords;
    }

    @Override
    public  List<TaskRecord> importBatchClueData(HttpServletRequest request, String sourceId, Long userId, String batchId, String batchName, String batchDesc,String updateType) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
        if (jcClueSource.getfState() < 1 || StringUtils.isBlank(jcClueSource.getfTablename()) ) {
            throw new RuntimeException("线索创建未完成，不能加载数据");
        }
        List<TaskRecord> taskRecords = new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            List<MultipartFile> files = multiRequest.getFiles("file");
            String time = System.currentTimeMillis() + "";
            String targetZipDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey()) + File.separator + time;
            for (MultipartFile file : files) {
                File dir = new File(targetZipDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File zipFile = new File(dir + File.separator + file.getOriginalFilename());
                FileUtils.copyInputStreamToFile(file.getInputStream(), zipFile);
            }
            String targetZipFile = Zip4jUtils.zip(targetZipDir, "gtdcy2019");
            String id = UUID.randomUUID().toString();
            asynImportBatchDataClue(targetZipFile, jcClueSource, id, batchId,  batchName,  userId, updateType);
            if(StringUtils.isNotBlank(batchName)){
                // 插入批次
                JcClueImportRecord bean = new JcClueImportRecord();
                bean.setfId(id);
                bean.setfCreatetime(new Date());
                bean.setfName(batchName);
                bean.setfRemark(batchDesc);
                bean.setfSourceid(jcClueSource.getfId());
                bean.setfCount(0);
                bean.setfJcmj(new BigDecimal(0));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                bean.setfJcsj( df.format(new Date()));
                jcClueImportRecordService.insert(bean);
            }
        }


        return taskRecords;
    }


    private void asynImportBatchDataClue(String zipFile, JcClueSource jcClueSource, String id, String batchId, String batchName, Long userId, String updateType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        String dateString = sdf.format(new Date());
        String obsFileName = zipFile.substring(zipFile.lastIndexOf(File.separator) + 1);
        String obsFilePath = "importTaskData/" + dateString + "/" + obsFileName;
        String resultUrl = defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);

        taskImportTaskDataService.createImportLog(jcClueSource, tbtskDataLog, userId);
        JSONObject params = new JSONObject();
        params.put("unzipFileDir", resultUrl);
        params.put("userId", userId);
        params.put("sourceId", jcClueSource.getfId());
        params.put("updateType", StringUtils.isBlank(updateType)?"0":updateType);
        params.put("batchId", StringUtils.isNotBlank(batchId)?batchId:StringUtils.isNotBlank(batchName)?id:"");
        params.put("batch", true);
        params.put("tbtskDataLogId", tbtskDataLog.getId());
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_CULE_IMPORT);
        record.setData(jcClueSource.getfId());
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);

    }



    private DataDownloadRecord buildDataDownloadRecordForGeometryDownload(String sourceId,String recordId, String tbIds, long userId, DownloadTypeEnum downloadTypeEnum, Integer downloadType) {

        if (StringUtils.isBlank(sourceId) || StringUtils.isBlank(recordId) || userId < -1) {
            return null;
        }
        DataDownloadRecord dataDownloadRecord = dataDownloadRecordService.buildDataDownloadRecordBaseInfo2(recordId, tbIds, userId,downloadTypeEnum);

        JcClueSource jcClueSource = this.jcClueSourceMapper.selectByPrimaryKey(sourceId);
        if(jcClueSource == null){
            throw new GwValidateException("线索表不存在");
        }
        int count = 0;
        String whereClause = "";
        String tableName = "";
        if (StringUtils.isNotBlank(tbIds)) {
            whereClause += " d.f_id in ( '" + tbIds.replace(",", "','") + "' ) ";
        }
        tableName = jcClueSource.getfTablename() + " d ";

        count = dataBizService.getCount(tableName, whereClause);

        dataDownloadRecord.setTbCount(count);
        JcClueImportRecord jcClueImportRecord = jcClueImportRecordService.selectByPrimaryKey(recordId);
        dataDownloadRecord.setName(jcClueImportRecord.getfName());

        return dataDownloadRecord;

    }

    @Override
    public DataDownloadRecord downloadGeometry(String sourceId, String recordId, String tbIds, Long userId, String geoType,Boolean isBatch, DownloadTypeEnum downloadTypeEnum, Integer downloadType) {
        GutilAssert.state(StringUtils.isNotBlank(sourceId), "sourceId can not be null or empty.");
        GutilAssert.state(userId > -1L, "userId can not be negative number.");
        GutilAssert.state(StringUtils.isNotBlank(geoType), "geoType can not be null or empty.");
        DataDownloadRecord record = this.buildDataDownloadRecordForGeometryDownload(sourceId,recordId, tbIds, userId, downloadTypeEnum,downloadType);
        // 保存到数据库中
        record = this.dataDownloadRecordService.save(record);
        record.setBatchOpr(isBatch);
        if (this.redisTemplate.hasKey(record.getId())) {
            this.redisTemplate.delete(record.getId());
        }

        this.redisTemplate.opsForValue().set(record.getId(), JSONObject.parseObject(JSONObject.toJSONString(record)).toString(), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(recordId) ? recordId : "");
        attachParameter.setTbIds( StringUtils.isNotBlank(record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setOrgIdOrGroupId("");
        attachParameter.setUserId(userId);
        attachParameter.setBizType("dailytask");
        attachParameter.setRecordId(com.geoway.landteam.landcloud.common.util.base.StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        attachParameter.setDownloadType(downloadType);
        attachParameter.setType(downloadTypeEnum.getCode());
        attachParameter.setDataType(StringUtils.isNoneBlank(geoType) ? geoType : "");
        String parameterString = JSONObject.toJSONString(attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public void checkData(String unzipFileDir, String fileEnd) throws Exception {
        File file = null;
        file = new File(unzipFileDir);
        File[] content = file.listFiles();
        File file1 = null;
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(fileEnd)) {
                file1 = content[j];
                break;
            }
        }
        if (file1 == null) {
            if (".db".equals(fileEnd)) {
                throw new RuntimeException("数据加载失败：缺少影像截图数据");
            } else {
                throw new RuntimeException("数据加载失败：缺少图形数据");
            }
        }
    }

    /**
     * 保存group配置
     * @param culeGroupDto
     * @param userId
     */
    public void saveFieldGroup(CuleGroupDto culeGroupDto, Long userId) throws Exception {
        JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(culeGroupDto.getSourceId());
        if(jcClueSource == null){
            throw new RuntimeException("线索不存在，请检查参数");
        }
      /*  jcClueSource.setfTempleid(culeGroupDto.getTempleId());
        jcClueSource.setfShowtype(Short.valueOf(culeGroupDto.getShowtype()));
        jcClueSource.setfImporttype(culeGroupDto.getImporttype());
        jcClueSource.setfImportfiletype(culeGroupDto.getImportfiletype());
        //保存和更新配置
        jcClueSourceMapper.updateByPrimaryKeySelective(jcClueSource);
        //保存模板对应字段
        jcClueFieldsMapper.deleteByTableId(culeGroupDto.getSourceId());
        jcClueFieldsMapper.insertFieldByTemple(culeGroupDto.getSourceId(),jcClueSource.getfTempleid());*/
        //删除group配置
        jcClueGroupMapper.deleteBytableId(culeGroupDto.getSourceId(),"web");
        List<String> fieldInList = culeGroupDto.getFieldInList().stream() .distinct().collect(Collectors.toList());
        //添加列表中显示字段的配置
        if (fieldInList.size() > 0)
            IntStream.range(0, fieldInList.size()).forEach(i -> {
                JcClueFields field =  jcClueFieldsService.selectByPrimaryKey(fieldInList.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("100");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(i);
                jcClueGroupMapper.insertSelective(jcClueGroup);
            });
        List<String> fieldInFilter = culeGroupDto.getFieldInFilter().stream() .distinct().collect(Collectors.toList());;
        //添加高级过滤
        if (fieldInFilter.size() > 0)
            IntStream.range(0, fieldInFilter.size()).forEach(i -> {
                JcClueFields field =  jcClueFieldsService.selectByPrimaryKey(fieldInFilter.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("101");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(i);
                jcClueGroupMapper.insertSelective(jcClueGroup);
            });
        // 添加搜索中配置的字段
        List<String> fieldInSearch = culeGroupDto.getFieldInSearch().stream() .distinct().collect(Collectors.toList());;
        if (fieldInSearch.size() > 0)
            IntStream.range(0, fieldInSearch.size()).forEach(i -> {
                JcClueFields field =  jcClueFieldsService.selectByPrimaryKey(fieldInSearch.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("102");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(i);
                jcClueGroupMapper.insertSelective(jcClueGroup);
            });
        //详情主显字段
        List<String> fieldInDetailMain = culeGroupDto.getFieldInDetailMain().stream() .distinct().collect(Collectors.toList());;
        if (fieldInDetailMain.size() > 0)
            IntStream.range(0, fieldInDetailMain.size()).forEach(i -> {
                JcClueFields field =  jcClueFieldsService.selectByPrimaryKey(fieldInDetailMain.get(i));
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfGroupcode("103");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(i);
                jcClueGroupMapper.insertSelective(jcClueGroup);
            });
        //详情展示配置
        for(int j = 0; j < culeGroupDto.getFieldGroup().size(); ++j) {
            Object object = culeGroupDto.getFieldGroup().get(j);
            FieldGroup group = JSONObject.toJavaObject(JSONObject.parseObject(JSONObject.toJSONString(object)), FieldGroup.class);
            List<FieldDisPlay> fields = group.getFields();

            for(int i = 0; i < fields.size(); ++i) {
                FieldDisPlay fieldDisPlay = (FieldDisPlay)fields.get(i);
                JcClueFields field = jcClueFieldsMapper.selectByPrimaryKey(fieldDisPlay.getFieldId());
                JcClueGroup jcClueGroup = new JcClueGroup();
                jcClueGroup.setfId(UUID.randomUUID().toString());
                jcClueGroup.setfSyscode("web");
                jcClueGroup.setfTablename(culeGroupDto.getSourceId());
                jcClueGroup.setfFieldname(field.getfFieldname());
                jcClueGroup.setfFieldid(field.getfId());
                jcClueGroup.setfAlias(field.getfAlias());
                jcClueGroup.setfFieldorder(i);
                jcClueGroup.setfGrouporder(j);
                jcClueGroup.setfGroupcode("202");
                jcClueGroup.setfSubgroupname(group.getTitle());
                jcClueGroup.setfControltype(fieldDisPlay.getDisplayType());
                jcClueGroup.setfTip(fieldDisPlay.getTips());
                jcClueGroup.setfCode(fieldDisPlay.getEditAble());
                jcClueGroup.setfNotNull(fieldDisPlay.getNotNull());
                jcClueGroup.setfConnection(fieldDisPlay.getConnection());
                jcClueGroup.setfVisible(fieldDisPlay.getVisible());
                jcClueGroup.setfItemGroupName(fieldDisPlay.getItemGroupName());
                jcClueGroup.setfRegexp(fieldDisPlay.getRuleReg());
                String regEx = "/[#\\\\$%\\\\^&\\\\*【】@!！￥?|‘；：”“\\'<>+=:]+/g";
                if ( (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2")) && (field.getfCodetableid() == null || field.getfCodetableid().equals(""))) {
                    jcClueGroup.setfRegexp(regEx);
                }
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    jcClueGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                    jcClueGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
                jcClueGroupMapper.insertSelective(jcClueGroup);
            }
        }

    }

    @Override
    public void  saveClueKeyLimitData(Long userId,String sourceId,String keyLimitData,String areaRepeatMinValue, String areaRepeatPrecent)  throws Exception{
        JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
        if(jcClueSource == null){
            throw new RuntimeException("线索不存在，请检查参数");
        }
        JSONArray keyData = JSON.parseArray(keyLimitData);
        if (keyData.isEmpty()) {
            throw new RuntimeException("字段数据为空，请检查参数");
        }

        List<JcClueFields> fields = jcClueFieldsMapper.findByTableId(sourceId);
        // have:true,check:false,only:true
        Map<String, JSONObject> keyMap = new HashMap<>();
        for (int i = 0; i < keyData.size(); i++) {
            JSONObject jsonObject = keyData.getJSONObject(i);
            String fieldId = jsonObject.getString("id");
            keyMap.put(fieldId, jsonObject);
        }
        for (JcClueFields field : fields) {
            String fid = field.getfId();
            if (keyMap.containsKey(fid)) {
                JSONObject data = keyMap.get(fid);

                Boolean have = data.getBoolean("have");
                Boolean check = data.getBoolean("check");
                Boolean only = data.getBoolean("only");
                field.setfNullable(check ? 0 : 1);
                field.setfUnique(only ? 1 : 0);
                field.setfIsMust(have ? 1 : 0);
                jcClueFieldsMapper.updateByPrimaryKeySelective(field);
            }
        }
        //生成线索表
       finishCuleSource( jcClueSource, userId);
    }


    @Override
    public void createClueMapperScheme(Long userId, JcClueImportTaskRelDto jcClueImportTaskRelDto) throws Exception {
        if(jcClueImportTaskRelDto.getfType()!=null && jcClueImportTaskRelDto.getfType().equals("1")){
         Integer count =  jcClueImportTaskRelMapper.selectCheckName(jcClueImportTaskRelDto.getfSourceid(),jcClueImportTaskRelDto .getfTaskid(),jcClueImportTaskRelDto.getfName());
         if(count > 0){
             throw new RuntimeException("映射方案名称已存在，请检查数据");
         }
        }
        //新增前先删除原有映射数据
        if(jcClueImportTaskRelDto.getfType()!=null && jcClueImportTaskRelDto.getfType().equals("2")){
            List<JcClueImportTaskRel> list = jcClueImportTaskRelMapper.findTaskMapperSchemes(jcClueImportTaskRelDto .getfTaskid(),"2");
           for(JcClueImportTaskRel bean : list){
               jcClueImportTaskRelMapper.gwDeleteByPK(bean.getfId());
               jcClueImportTaskRelFieldsMapper.deleteByRelId(bean.getfId());
           }
        }
        String id = UUID.randomUUID().toString();
        JcClueImportTaskRel jcClueImportTaskRel = new JcClueImportTaskRel();
           BeanUtil.copyProperties(jcClueImportTaskRelDto,jcClueImportTaskRel,false);
        jcClueImportTaskRel.setfId(id);
        jcClueImportTaskRel.setfCreatetime(new Date());
        jcClueImportTaskRel.setfUserid(userId);
        jcClueImportTaskRel.setfType(jcClueImportTaskRelDto.getfType()==null?"1":"2");
        jcClueImportTaskRelMapper.insertSelective(jcClueImportTaskRel);
        //插入关联的字段数据
        if(jcClueImportTaskRelDto.getFields() != null){
            List<JcClueImportTaskRelFields> fieldsList = jcClueImportTaskRelDto.getFields().toJavaList(JcClueImportTaskRelFields .class);
           for(JcClueImportTaskRelFields bean : fieldsList){
               bean.setfId(UUID.randomUUID().toString());
               bean.setfRelid(id);
               jcClueImportTaskRelFieldsMapper.insertSelective(bean);
           }
        }
    }

    @Override
    public List<JcClueImportTaskRel> findClueMapperSchemes(Long userId, String sourceId, String taskId,String type) {
        if(StringUtils.isBlank(taskId) || "null".equals(taskId)){
            return jcClueImportTaskRelMapper.findClueMapperSchemesByClue( sourceId,type);
        }else{
            return jcClueImportTaskRelMapper.findClueMapperSchemes( sourceId,  taskId,type);
        }

    }

    @Override
    public List<JcClueImportTaskRel> findTaskMapperSchemes(Long userId, String taskId,String type) {
        List<JcClueImportTaskRel> rels = jcClueImportTaskRelMapper.findTaskMapperSchemes( taskId,type);
         for(JcClueImportTaskRel rel : rels){
             rel.setTaskRelFields(jcClueImportTaskRelFieldsMapper.selectByRelId(rel.getfId()));
         }
        return rels;
    }

    @Override
    public List<JcClueImportTaskRelFields> findClueImportTaskRelFields(Long userId, String relId) {
        return jcClueImportTaskRelFieldsMapper.selectByRelId(relId);
    }

    @Override
    public List<JcClueSource> getClueList(Long userId,String appsId) {
        List<JcClueSource> list = jcClueSourceMapper.queryByParentId("-1",appsId);
        if(!list.isEmpty()){
            for(JcClueSource bean : list){
                bean.setChildren(getChildren(bean.getfId()));
                if(StringUtils.isNotBlank(bean.getfTempleid())){
                    JcClueTemplate jcClueTemplate = jcClueTemplateMapper.gwSearchByPK(bean.getfTempleid());
                    bean.setTempleName(jcClueTemplate!=null?jcClueTemplate.getfName():null);
                }
            }
        }
        return list;
    }


    @Override
    public List<JcClueSource> getClueListByTempleId(String templeId) {
        List<JcClueSource> list = jcClueSourceMapper.getClueListByTempleId(templeId);
        return list;
    }

    @Transactional
    @Override
    public Boolean makeViewRelClueAndTask(String sourceId, String recordId, String taskId, Long userId) {
        // 拷贝jc_clue_source表
        JcClueSource jcClueSource = jcClueSourceMapper.selectByPrimaryKey(sourceId);
        if(jcClueSource == null){
            return false;
        }

        // 创建视图
        String viewsqlTemplate = "";
        SysConfig clueViewConfig = sysConfigService.findOne("clueViewSqlTemplate");
        if(clueViewConfig!=null){
            viewsqlTemplate = clueViewConfig.getValue();
        }

        // 修改表为名视图名称
        String viewName = "business_apps_cgjc.v_jc_clue_cgjcxs_"+UUID.randomUUID().toString().replace("-","");
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableByTableId = tskTaskBizService.getTableByTableId(tskTaskBiz.getTableId());

        JcClueSource jcClueSourceNew = new JcClueSource();
        BeanUtil.copyProperties(jcClueSource,jcClueSourceNew,false);
        jcClueSourceNew.setfId(UUID.randomUUID().toString());
        jcClueSourceNew.setfTablename(viewName);
        jcClueSourceNew.setfName("伪线索_"+tskTaskBiz.getName());
        jcClueSourceNew.setfState(3);
        jcClueSourceNew.setfRemark("");
        jcClueSourceMapper.insertSelective(jcClueSourceNew);

        // 拷贝jc_clue_fields表
        List<JcClueFields> jcClueFieldsListNew = new ArrayList<>();
        List<JcClueFields> byTableId = jcClueFieldsService.findByTableId(sourceId);
        for (JcClueFields jcClueFields : byTableId) {
            JcClueFields jcClueFieldsNew = new JcClueFields();
            BeanUtil.copyProperties(jcClueFields,jcClueFieldsNew,false);
            jcClueFieldsNew.setfId(UUID.randomUUID().toString());
            jcClueFieldsNew.setfTableid(jcClueSourceNew.getfId());
            jcClueFieldsListNew.add(jcClueFieldsNew);

            // 没有批量方法，临时用单条插入
            jcClueFieldsService.insert(jcClueFieldsNew);
        }

        // 拷贝jc_clue_group表
        List<JcClueGroup> detailGroup = jcClueGroupMapper.clueGroupByTableId("",sourceId, "");
        for (JcClueGroup jcClueGroup : detailGroup) {
            JcClueGroup jcClueGroupNew = new JcClueGroup();
            BeanUtil.copyProperties(jcClueGroup,jcClueGroupNew,false);
            jcClueGroupNew.setfId(UUID.randomUUID().toString());
            Optional<JcClueFields> op = jcClueFieldsListNew.stream().filter(r -> r.getfFieldname().equals(jcClueGroupNew.getfFieldname())).findFirst();
            if(!op.isPresent()){
                continue;
            }
            jcClueGroupNew.setfFieldid(op.get().getfId());
            // 没有批量方法，临时用单条插入
            jcClueGroupMapper.insertSelective(jcClueGroupNew);
        }

        // 修改record中的关联表为伪线索的id
        JcClueImportRecord jcClueImportRecord = jcClueImportRecordService.selectByPrimaryKey(recordId);
        jcClueImportRecord.setfJcqy(jcClueSourceNew.getfId());
        jcClueImportRecordService.updateByPrimaryKeySelective(jcClueImportRecord);

//        viewsqlTemplate = "CREATE VIEW \"business_apps_cgjc\".\"{viewName}\" AS SELECT {taskname}.f_id,\n" +
//                "    '{recordid}'::text AS f_import_recordid,\n" +
//                "    {taskname}.f_status,\n" +
//                "    NULL::integer AS f_state,\n" +
//                "    NULL::integer AS f_analysis,\n" +
//                "    NULL::character varying AS f_stage,\n" +
//                "    {taskname}.f_shape,\n" +
//                "    NULL::text AS f_createtime,\n" +
//                "    {taskname}.f_userid,\n" +
//                "    NULL::character varying AS f_sourceid,\n" +
//                "    NULL::character varying AS f_sjpc,\n" +
//                "    {taskname}.f_xzqmc,\n" +
//                "    {taskname}.f_xzqdm,\n" +
//                "    NULL::character varying AS f_location,\n" +
//                "    {taskname}.f_tbmj AS f_area,\n" +
//                "    {taskname}.f_xzqdmcity,\n" +
//                "    {taskname}.f_xzqdmcounty,\n" +
//                "    {taskname}.f_xzqdmtown,\n" +
//                "    {taskname}.f_xzqdmsys AS f_xzqdmvillage,\n" +
//                "    {taskname}.f_zrbhdzym AS f_zrbhdmj,\n" +
//                "    {taskname}.f_zrbhdmc,\n" +
//                "    {taskname}.f_yjjbntzy AS f_yjjbntmj,\n" +
//                "    {taskname}.f_xzmc AS f_xzjd,\n" +
//                "    {taskname}.f_tbbh,\n" +
//                "    {taskname}.f_sthxzymj AS f_stbhhxmj,\n" +
//                "    {taskname}.f_pwfgmj AS f_sxfgmj,\n" +
//                "    {taskname}.f_pwfgbl AS f_sxfgbl,\n" +
//                "    {taskname}.f_gdzymj AS f_bgdcgdmj,\n" +
//                "    {taskname}.f_cjdcq AS f_cjdcdy,\n" +
//                "    {taskname}.f_zrbhdhxz AS f_zrbhdhxq,\n" +
//                "    {taskname}.f_tbmj_n1 AS f_tbmj,\n" +
//                "    {taskname}.f_tbmc,\n" +
//                "    {taskname}.f_xzqmc_n2 AS f_xzqmc_n1,\n" +
//                "    {taskname}.f_hsxyxtz AS f_jclx,\n" +
//                "    {taskname}.f_xzqdm_n5,\n" +
//                "    NULL::numeric AS f_ckbl,\n" +
//                "    NULL::numeric AS f_ckmj,\n" +
//                "    NULL::numeric AS f_czkfbjmj,\n" +
//                "    NULL::numeric AS f_dlkd,\n" +
//                "    NULL::numeric AS f_dllc,\n" +
//                "    NULL::numeric AS f_gbzntmj,\n" +
//                "    NULL::numeric AS f_gdbl,\n" +
//                "    NULL::numeric AS f_gdmj,\n" +
//                "    NULL::numeric AS f_ghxkbl,\n" +
//                "    NULL::numeric AS f_ghxkmj,\n" +
//                "    NULL::character varying AS f_jcgl,\n" +
//                "    NULL::numeric AS f_kcsxzgmj,\n" +
//                "    NULL::numeric AS f_kfzlmj,\n" +
//                "    NULL::numeric AS f_lsydbl,\n" +
//                "    NULL::numeric AS f_lsydmj,\n" +
//                "    NULL::numeric AS f_qqdjbl,\n" +
//                "    NULL::numeric AS f_qqdjmj,\n" +
//                "    NULL::character varying AS f_qy,\n" +
//                "    NULL::character varying AS f_rwfp,\n" +
//                "    NULL::numeric AS f_ssnydbl,\n" +
//                "    NULL::numeric AS f_ssnydmj,\n" +
//                "    NULL::numeric AS f_wpzfbl,\n" +
//                "    NULL::numeric AS f_wpzfmj,\n" +
//                "    NULL::numeric AS f_xbkxcmj,\n" +
//                "    NULL::character varying AS f_zdbgdl,\n" +
//                "    NULL::numeric AS f_zdbgdlbl,\n" +
//                "    NULL::numeric AS f_zzbl,\n" +
//                "    NULL::numeric AS f_zzmj,\n" +
//                "    NULL::character varying AS f_fnflhwt,\n" +
//                "    NULL::character varying AS f_jswt,\n" +
//                "    NULL::numeric AS f_tghlbl,\n" +
//                "    NULL::numeric AS f_tghlmj,\n" +
//                "    NULL::numeric AS f_zdgcxmbl,\n" +
//                "    {taskname}.f_zglx AS f_gdzylx,\n" +
//                "    {taskname}.f_yjdl,\n" +
//                "    {taskname}.f_ejdl,\n" +
//                "    {taskname}.f_xmmc AS f_zdgcxmmc,\n" +
//                "    {taskname}.f_sjyjydlx AS f_sjyjdl,\n" +
//                "    {taskname}.f_sjejydlx AS f_sjejdl,\n" +
//                "    {taskname}.f_sjcpjbsx AS f_sjcpysx,\n" +
//                "    {taskname}.f_sfysx,\n" +
//                "    {taskname}.f_sfwtdt,\n" +
//                "    {taskname}.f_sfgyyq,\n" +
//                "    {taskname}.f_pwh,\n" +
//                "    {taskname}.f_jclx AS f_jcrw,\n" +
//                "    {taskname}.f_gyyqmc,\n" +
//                "    {taskname}.f_wysdqk,\n" +
//                "    {taskname}.f_wydcjz AS f_bz,\n" +
//                "    {taskname}.f_tjejl,\n" +
//                "    {taskname}.f_zdgcxm,\n" +
//                "    {taskname}.f_ydsxlx,\n" +
//                "    {taskname}.f_sxmc,\n" +
//                "    {taskname}.f_sfwyjz,\n" +
//                "    {taskname}.f_sfgbyyyd,\n" +
//                "    {taskname}.f_rdwgdlc,\n" +
//                "    {taskname}.f_jbsxdmj,\n" +
//                "    NULL::character varying AS f_cbsx,\n" +
//                "    NULL::character varying AS f_cbsxyy,\n" +
//                "    NULL::numeric AS f_gyyqbl,\n" +
//                "    NULL::numeric AS f_gyyqmj,\n" +
//                "    NULL::character varying AS f_nxftb,\n" +
//                "    NULL::character varying AS f_nyyp,\n" +
//                "    NULL::character varying AS f_sfsjzdxm,\n" +
//                "    NULL::character varying AS f_tz,\n" +
//                "    NULL::numeric AS f_zdgcxmmj,\n" +
//                "    NULL::text AS f_tdqlr,\n" +
//                "    NULL::text AS f_qsdwmc,\n" +
//                "    NULL::text AS f_lxdh,\n" +
//                "    NULL::text AS f_bzy,\n" +
//                "    NULL::text AS f_bzw,\n" +
//                "    NULL::text AS f_bzl,\n" +
//                "    NULL::text AS f_bze,\n" +
//                "    NULL::text AS f_bz4,\n" +
//                "    NULL::text AS f_bz3,\n" +
//                "    NULL::text AS f_splitedid,\n" +
//                "    NULL::text AS f_mergeid,\n" +
//                "    NULL::text AS f_issplitted,\n" +
//                "    NULL::text AS f_bzsy,\n" +
//                "    NULL::text AS f_bzse,\n" +
//                "    NULL::text AS f_bzq,\n" +
//                "    NULL::text AS f_bzj,\n" +
//                "    NULL::text AS f_tbzk,\n" +
//                "    NULL::text AS f_sszt,\n" +
//                "    NULL::text AS f_spxx,\n" +
//                "    NULL::text AS f_qsx,\n" +
//                "    NULL::text AS f_hsx,\n" +
//                "    NULL::text AS f_bzs,\n" +
//                "    NULL::text AS f_bzs_n2,\n" +
//                "    NULL::text AS f_mj,\n" +
//                "    NULL::text AS f_zlwz,\n" +
//                "    NULL::text AS f_zz_n2,\n" +
//                "    NULL::text AS f_bzb\n" +
//                "   FROM {taskname}\n" +
//                "UNION ALL\n" +
//                " SELECT jc_clue_cgjccjstsl_20230808143136487.f_id,\n" +
//                "    '{recordid}'::text AS f_import_recordid,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_status,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_state,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_analysis,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_stage,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_shape,\n" +
//                "    NULL::text AS f_createtime,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_userid,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sourceid,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sjpc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqmc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqdm,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_location,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_area,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqdmcity,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqdmcounty,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqdmtown,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqdmvillage,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zrbhdmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zrbhdmc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_yjjbntmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzjd,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tbbh,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_stbhhxmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sxfgmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sxfgbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_bgdcgdmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_cjdcdy,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zrbhdhxq,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tbmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tbbh AS f_tbmc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqmc_n1,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_jclx,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xzqdm_n5,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ckbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ckmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_czkfbjmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_dlkd,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_dllc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gbzntmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gdbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gdmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ghxkbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ghxkmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_jcgl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_kcsxzgmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_kfzlmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_lsydbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_lsydmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_qqdjbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_qqdjmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_qy,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_rwfp,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ssnydbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ssnydmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_wpzfbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_wpzfmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_xbkxcmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zdbgdl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zdbgdlbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zzbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zzmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_fnflhwt,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_jswt,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tghlbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tghlmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zdgcxmbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gdzylx,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_yjdl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_ejdl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zdgcxmmc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sjyjdl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sjejdl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sjcpysx,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sfysx,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sfwtdt,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sfgyyq,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_pwh,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_jcrw,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gyyqmc,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_wysdqk,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_bz,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tjejl,\n" +
//                "    NULL::character varying AS f_zdgcxm,\n" +
//                "    NULL::character varying AS f_ydsxlx,\n" +
//                "    NULL::character varying AS f_sxmc,\n" +
//                "    NULL::character varying AS f_sfwyjz,\n" +
//                "    NULL::character varying AS f_sfgbyyyd,\n" +
//                "    NULL::character varying AS f_rdwgdlc,\n" +
//                "    NULL::numeric AS f_jbsxdmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_cbsx,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_cbsxyy,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gyyqbl,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_gyyqmj,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_nxftb,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_nyyp,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_sfsjzdxm,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_tz,\n" +
//                "    jc_clue_cgjccjstsl_20230808143136487.f_zdgcxmmj,\n" +
//                "    NULL::text AS f_tdqlr,\n" +
//                "    NULL::text AS f_qsdwmc,\n" +
//                "    NULL::text AS f_lxdh,\n" +
//                "    NULL::text AS f_bzy,\n" +
//                "    NULL::text AS f_bzw,\n" +
//                "    NULL::text AS f_bzl,\n" +
//                "    NULL::text AS f_bze,\n" +
//                "    NULL::text AS f_bz4,\n" +
//                "    NULL::text AS f_bz3,\n" +
//                "    NULL::text AS f_splitedid,\n" +
//                "    NULL::text AS f_mergeid,\n" +
//                "    NULL::text AS f_issplitted,\n" +
//                "    NULL::text AS f_bzsy,\n" +
//                "    NULL::text AS f_bzse,\n" +
//                "    NULL::text AS f_bzq,\n" +
//                "    NULL::text AS f_bzj,\n" +
//                "    NULL::text AS f_tbzk,\n" +
//                "    NULL::text AS f_sszt,\n" +
//                "    NULL::text AS f_spxx,\n" +
//                "    NULL::text AS f_qsx,\n" +
//                "    NULL::text AS f_hsx,\n" +
//                "    NULL::text AS f_bzs,\n" +
//                "    NULL::text AS f_bzs_n2,\n" +
//                "    NULL::text AS f_mj,\n" +
//                "    NULL::text AS f_zlwz,\n" +
//                "    NULL::text AS f_zz_n2,\n" +
//                "    NULL::text AS f_bzb\n" +
//                "   FROM business_apps_cgjc.jc_clue_cgjccjstsl_20230808143136487\n" +
//                "  WHERE (((jc_clue_cgjccjstsl_20230808143136487.f_sourceid)::text = 'fab498c1-a83d-4317-ae16-8818d6f7f3fe'::text) AND ((jc_clue_cgjccjstsl_20230808143136487.f_import_recordid)::text = '{recordid}'::text) AND (NOT (EXISTS ( SELECT jctr.f_id\n" +
//                "           FROM jc_clue_task_rel jctr\n" +
//                "          WHERE (((jctr.f_clueid)::text = (jc_clue_cgjccjstsl_20230808143136487.f_id)::text) AND ((jctr.f_sourceid)::text = 'fab498c1-a83d-4317-ae16-8818d6f7f3fe'::text) AND ((jctr.f_taskid)::text = 'd13b1dce-e1f9-498e-92c3-41c8bd4b7fcc'::text))))))";

        // 替换任务名

        String viewsql = viewsqlTemplate.replaceAll("\\{viewName\\}",viewName).replaceAll("\\{taskname\\}", tableByTableId!=null?tableByTableId.getfTablename():"").replaceAll("\\{recordid\\}", recordId);
        jdbcTemplate.execute(viewsql);

        return true;
    }

    private  List<JcClueSource> getChildren(String id) {
        List<JcClueSource> list = jcClueSourceMapper.queryByParentId(id,null);
        if(!list.isEmpty()){
          for(JcClueSource bean : list){
              bean.setChildren(getChildren(bean.getfId()));
              if(StringUtils.isNotBlank(bean.getfTempleid())){
                  JcClueTemplate jcClueTemplate = jcClueTemplateMapper.selectByPrimaryKey(bean.getfTempleid());
                  bean.setTempleName(jcClueTemplate!=null?jcClueTemplate.getfName():null);
              }
          }
        }
        return list;
    }


    public void defaultClueGroup(String sourceId,String tableName){
        List<JcClueFields> fields =
                jcClueFieldsService.findByTableId(sourceId).stream()
                        .filter(r -> r.getfFieldInnerOuterSys()  == 1)
                        .collect(Collectors.toList());
        //添加列表中显示字段的配置
        for(JcClueFields field : fields){
            JcClueGroup jcClueGroup = new JcClueGroup();
            jcClueGroup.setfId(UUID.randomUUID().toString());
            jcClueGroup.setfSyscode("web");
            jcClueGroup.setfGroupcode("100");
            jcClueGroup.setfTablename(sourceId);
            jcClueGroup.setfFieldname(field.getfFieldname());
            jcClueGroup.setfFieldid(field.getfId());
            jcClueGroup.setfAlias(field.getfAlias());
            if ("1".equalsIgnoreCase(field.getRuleReg())) {
                // 身份证号正则
                jcClueGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
            } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                // 手机号正则
                jcClueGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
            }
            jcClueGroupMapper.insertSelective(jcClueGroup);
        }
    }


    /**
     * 默认字段
     * @param jcClueSource
     */
    public void defaultField(JcClueSource jcClueSource){
        //添加系统字段
        //f_id
        jcClueFieldsService.saveFields(jcClueSource, "f_id", "2", "100",
                null, "true", "false", "false", "主键(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
       //f_status
        jcClueFieldsService.saveFields(jcClueSource, "f_status", "8", "10", null, "true", "false", "false", "状态(系统)",
                null,"true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        //f_registerstatus 套合状态 0 未套合 1 套合
        jcClueFieldsService.saveFields(jcClueSource, "f_registerstatus", "8", "10", null, "true", "false", "false", "套合状态(系统)",
                null,"true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        //f_mergestatus 融合状态 0 未融合 1 融合
        jcClueFieldsService.saveFields(jcClueSource, "f_mergestatus", "8", "10", null, "true", "false", "false", "融合状态(系统)",
                null,"true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        //f_state  是否有效
        jcClueFieldsService.saveFields(jcClueSource, "f_state", "8", "10", null, "true", "false", "false", "线索有效性(系统)",
                null,"true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
       //f_analysis  智能分析
        jcClueFieldsService.saveFields(jcClueSource, "f_analysis", "8", "10", null, "true", "false", "false", "智能分析状态(系统)",
                null,"true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
       //f_stage
        jcClueFieldsService.saveFields(jcClueSource, "f_stage", "2", "16", null, "true", "false", "false", "处理阶段(系统)",
                null,"true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        //f_shape
        jcClueFieldsService.saveFields(jcClueSource, "f_shape", "9", null,
                null, "true", "false", "false", "shape(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD , true);
       //f_createtime
        jcClueFieldsService.saveFields(jcClueSource, "f_createtime", "8", "20",
                null, "true", "false", "false", "创建时间(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD , true);
        //f_userid
        jcClueFieldsService.saveFields(jcClueSource, "f_userid", "2", "100",
                null, "true", "false", "false", "操作人(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD , true);
        //f_sourceid
        jcClueFieldsService.saveFields(jcClueSource, "f_sourceid", "2", "100",
                null, "true", "false", "false", "线索来源ID(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD , true);
        //f_import_recordid
        jcClueFieldsService.saveFields(jcClueSource, "f_import_recordid", "2", "100",
                null, "true", "false", "false", "批次记录id(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD , true);
        //f_sjpc
        jcClueFieldsService.saveFields(jcClueSource, "f_sjpc", "2", "100",
                null, "true", "false", "false", "批次名称(系统)", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        //f_xzqmc
        jcClueFieldsService.saveFields(jcClueSource, "f_xzqmc", "2", "100",
                null, "false", "true", "false", "行政区名称(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

         //f_xzqdm
        jcClueFieldsService.saveFields(jcClueSource, "f_xzqdm", "2", "20",
                null, "true", "true", "false", "行政区代码(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmcity", "2", "20",
                null, "true", "true", "false", "行政区代码市(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmcounty", "2", "20",
                null, "true", "true", "false", "行政区代码县(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmtown", "2", "20",
                null, "true", "true", "false", "行政区代码镇(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        jcClueFieldsService.saveFields(jcClueSource, "f_xzqdmvillage", "2", "20",
                null, "true", "true", "false", "行政区代码村(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        //f_location
        jcClueFieldsService.saveFields(jcClueSource, "f_location", "2", "200",
                null, "false", "true", "false", "坐落位置(系统)", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        //f_area
        jcClueFieldsService.saveFields(jcClueSource, "f_area", "7", "20",
                "4", "false", "true", "false", "面积(系统)", null,
                "true", "false", "false", "false",  FieldGroupTypeConstant.SYSTEM_FIELD, true);

    }



    public static String generateTableName(String sourceName) {
        StringBuffer name = new StringBuffer("jc_clue_"+sourceName);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String sxff = sdf.format(new Date());
        name.append("_").append(sxff);
        return name.toString();
    }


    /**
     * 创建表
     * @param jcClueSource
     */
    @Transactional(rollbackFor = Exception.class)
    public void createTable(JcClueSource jcClueSource) {
        GutilAssert.hasLength(jcClueSource.getfTablename(), "表不能为空");
        // 创建数据库表sql
        StringBuilder creatTableSql = new StringBuilder("CREATE TABLE ");
        List<JcClueFields> fields =  jcClueFieldsMapper.findByTableId(jcClueSource.getfId());
        // 表名称
        creatTableSql.append(jcClueSource.getfTablename()).append(" (");
        // 保存‘数据库表字段’信息
        creatTableSql.append(generateFieldSql(jcClueSource, fields));
        // 创建数据库表
        jdbcTemplate.execute(creatTableSql.toString());
        //来源的shape数据srid设置为4490
        if(jcClueSource.getfTablename().contains(".")){
            String table = jcClueSource.getfTablename();
            String[] split1 = jcClueSource.getfTablename().split("\\.");
            jdbcTemplate.execute("select UpdateGeometrySRID('','"+split1[0]+"','"+split1[1]+"', 'f_shape', 4490)");
        }else{
            jdbcTemplate.execute("select UpdateGeometrySRID('"+jcClueSource.getfTablename()+"', 'f_shape', 4490)");
        }

    }



    public static String generateFieldSql(JcClueSource jcClueSource,  List<JcClueFields> list){
        StringBuilder fieldSql = new StringBuilder();
        for (JcClueFields f : list) {
            fieldSql.append(f.getfFieldname()).append(" ");
            String fieldType = f.getfFieldtype();
            Map<String,String> FIELD_TYPE_DIC = new HashMap<>();
                FIELD_TYPE_DIC.put("1","text");
                FIELD_TYPE_DIC.put("2","varchar");
                FIELD_TYPE_DIC.put("3","decimal");
                FIELD_TYPE_DIC.put("4","timestamp");
                FIELD_TYPE_DIC.put("5", "timestamp");
                FIELD_TYPE_DIC.put("6", "varchar");
                FIELD_TYPE_DIC.put("7", "decimal");
                FIELD_TYPE_DIC.put("8","int4");
                FIELD_TYPE_DIC.put("9","geometry");
                FIELD_TYPE_DIC.put("10","text");
            String dbType = FIELD_TYPE_DIC.getOrDefault(fieldType,"varchar");

            if (f.getfLength() == null) {
                fieldSql.append(dbType);
            } else {
                if ("decimal".equals(dbType)) {
                    fieldSql.append(dbType).append("(")
                            .append(f.getfLength()).append(",")
                            .append(f.getfPrecision()).append(")");
                } else if ("varchar".equals(dbType)) {
                    fieldSql.append(dbType).append("(").append(f.getfLength()).append(")");
                } else {
                    fieldSql.append(dbType);
                }
            }
            fieldSql.append(" ");
            if ("0".equals(f.getfNullable())) {
                fieldSql.append("NOT NULL ");
            }
            fieldSql.append(",");
        }
        if(list.size() > 1){
            fieldSql.append("primary key(f_id));");
        }else{
            return fieldSql.substring(0,fieldSql.length()-1);
        }
        return fieldSql.toString();
    }


    public static String getFisrtDayOfMonth(int year,int month){
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);

        //获取某月最小天数
        int firstDay = cal.getActualMinimum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最小天数
        cal.set(Calendar.DAY_OF_MONTH, firstDay);

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);

        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }


    public static String getLastDayOfMonth(int year,int month)
    {
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);
        //获取某月最大天数
        int lastDay = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最大天数
        cal.set(Calendar.DAY_OF_MONTH, lastDay);

        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }


    /**
     * 当季开始时间
     * @return
     */
    public static String getCurrentQuarterStartTime() {
        Calendar c = Calendar . getInstance();
        int currentMonth = c. get (Calendar .MONTH) + 1;
        Date now = null;
        try {
        if (currentMonth >= 1 && currentMonth <= 3)
            c.set(Calendar.MONTH,0) ;
       else if (currentMonth >= 4 && currentMonth <= 6)
            c.set(Calendar . MONTH,3) ;
       else if ( currentMonth >= 7 && currentMonth <= 9)
            c.set(Calendar . MONTH,4);
       else if ( currentMonth >= 10 && currentMonth <= 12)
            c.set(Calendar . MONTH,9);
        } catch (Exception e) {
            e.printStackTrace() ;
        }
        //格式化日期
        c.set(Calendar.DATE,1) ;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  time = sdf.format(c.getTime())+ " 00:00:00";
        return time;
    }

    /**
     * 当季结束时间
     * @return
     */
    public static String getCurrentQuarterEndTime() {
        Calendar c = Calendar . getInstance();
        int currentMonth = c. get (Calendar .MONTH) + 1;
        Date now = null;
        try {
        if (currentMonth >= 1 && currentMonth <= 3){
            c.set(Calendar.MONTH,2) ;
            c.set(Calendar.DATE,31) ;
        } else if (currentMonth >= 4 && currentMonth <= 6){
            c.set(Calendar.MONTH,5) ;
            c.set(Calendar.DATE,31) ;
        }else if ( currentMonth >= 7 && currentMonth <= 9){
            c.set(Calendar.MONTH,8) ;
            c.set(Calendar.DATE,31) ;
        } else if ( currentMonth >= 10 && currentMonth <= 12){
            c.set(Calendar.MONTH,11) ;
            c.set(Calendar.DATE,31) ;
        }
        } catch (Exception e) {
            e.printStackTrace() ;
        }
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  time = sdf.format(c.getTime()) +"  23:59:59";
        return time;
    }

    /**
     * 将字符串转为时间戳
     * @param time
     * @return
     */
    public static Long converTime(String time ) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime()/1000;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }




}
