package com.geoway.landteam.landcloud.service.patrolclue.cluelibrary.impl;

import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueTemplateService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueFieldsMapper;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueTemplateMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueTemplate;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.gw.base.data.GwValidateException;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : tuowei
 * @date : 2022/5/9 16:27
 * @description :
 */
@Service
public class MJcClueTemplateServiceImpl implements MJcClueTemplateService {

    @Autowired
    JcClueTemplateMapper jcClueTemplateMapper;
    @Autowired
    JcClueFieldsMapper jcClueFieldsMapper;

    @Autowired
    TbtskObjectinfoRepository objectDao;

    @Autowired
    TbtskFieldsRepository fieldsDao;

    @Autowired
    MJcClueSourceService jcClueSourceService;



    @Override
    public List<JcClueTemplate> getTemplateList() {
        List<JcClueTemplate> list = jcClueTemplateMapper.getTemplateList();
        return list;
    }

    @Override
    public void saveClueTemplate(JcClueTemplate jcClueTemplate) {
        jcClueTemplateMapper.insert(jcClueTemplate);
        // 创建模板之后，
        JcClueSource jcClueSource = new JcClueSource();
        jcClueSource.setfId(jcClueTemplate.getfId());
        jcClueSourceService.defaultField(jcClueSource);
    }

    @Override
    public boolean deleteClueTemplate(String fId) throws Exception {
        List<JcClueSource> sourceList = jcClueSourceService.getClueListByTempleId(fId);
        if(!sourceList.isEmpty()){
            throw  new GwValidateException("线索模板已配置使用，无法删除！");
        }
        //先删除配置的字段
        jcClueFieldsMapper.deleteByTableId(fId);
        //删除模板数据
        int i = jcClueTemplateMapper.deleteByPrimaryKey(fId);

        return i > 0 ? true : false;
    }

    @Override
    public JcClueTemplate getClueTemplate(String fId) {
        return jcClueTemplateMapper.selectByPrimaryKey(fId);
    }

    @Override
    public boolean updateClueTemplate(JcClueTemplate jcClueTemplate) {
        int i = jcClueTemplateMapper.updateByPrimaryKeySelective(jcClueTemplate);
        return i > 0 ? true : false;
    }

    @Override
    public Pair<Integer, List<JcClueTemplate>> getTemplateList(String templateName,String templateStatus, String  appsId, int pageNum, int pageSize) {
        int start = (pageNum - 1) * pageSize;
        List<JcClueTemplate> list = jcClueTemplateMapper.searchTemplateList(templateName,templateStatus,appsId,
                start,pageSize);
        int count = jcClueTemplateMapper.searchCountTemplateList(templateName,templateStatus,appsId);
        Pair<Integer, List<JcClueTemplate>> pair = Pair.of(count, list);
        return pair;
    }


    void addDefaultFieldsToTable(TbtskObjectinfo table) {
//        TbtskObjectinfo table = (TbtskObjectinfo)this.objectDao.findOne(template.getTableId());
        this.addField(table, "f_id", "主键", "2", 100, (Integer)null, 0, 4);
        this.addField(table, "f_status", "状态", "8", (Integer)null, (Integer)null, 1, 4);
        this.addField(table, "f_ismycreate", "是否自己创建", "8", (Integer)null, (Integer)null, 1, 4);
        this.addField(table, "f_requestid", "云查询id", "2", 100, (Integer)null, 1, 4);
        this.addField(table, "f_ismy", "是否自己图斑（app端使用）", "8", (Integer)null, (Integer)null, 1, 4);
        this.addField(table, "f_xzqdmsys", "行政区代码-系统用", "2", 20, (Integer)null, 0, 4);
        this.addField(table, "f_submit_userid", "提交人员", "2", 32, (Integer)null, 1, 4);
        this.addField(table, "f_reject_count", "打回次数", "8", (Integer)null, (Integer)null, 1, 4);
        this.addField(table, "f_review_stage", "审核阶段", "8", (Integer)null, (Integer)null, 1, 4);
        this.addField(table, "f_reject_status", "打回状态", "8", (Integer)null, (Integer)null, 1, 4);
        this.addField(table, "f_shape", "shape", "9", (Integer)null, (Integer)null, 0, 5);
        this.addField(table, "f_shape1", "shape1", "9", (Integer)null, (Integer)null, 0, 5);
        this.addField(table, "f_lat", "中心点Y坐标", "3", 12, 6, 0, 5);
        this.addField(table, "f_lon", "中心点X坐标", "3", 12, 6, 0, 5);
        this.addField(table, "f_shape_b", "百度shape", "9", (Integer)null, (Integer)null, 1, 5);
        this.addField(table, "f_lat_b", "百度中心点Y坐标", "3", 12, 6, 1, 5);
        this.addField(table, "f_lon_b", "百度中心点X坐标", "3", 12, 6, 1, 5);
        this.addField(table, "f_shape_g", "谷歌shape", "9", (Integer)null, (Integer)null, 1, 5);
        this.addField(table, "f_tbmc", "图斑名称", "2", 100, (Integer)null, 1, 1);
        this.addField(table, "f_tbbh", "图斑编号", "2", 100, (Integer)null, 1, 1);
        this.addField(table, "f_xzqdm", "行政区代码", "2", 20, (Integer)null, 0, 1);
        this.addField(table, "f_tbmj", "图斑面积(亩)", "3", 12, 2, 1, 1);
        this.addField(table, "f_lat_g", "谷歌中心点Y坐标", "3", 12, 6, 1, 5);
        this.addField(table, "f_lon_g", "谷歌中心点X坐标", "3", 12, 6, 1, 5);
        this.addField(table, "f_xzqmc1", "行政区名称", "2", 100, (Integer)null, 1, 5);
        this.addField(table, "f_xzqmc", "行政区名称", "2", 100, (Integer)null, 0, 1);
        this.addField(table, "f_userid", "操作人", "2", 100, (Integer)null, 1, 5);
        this.addField(table, "f_typical", "典型问题", "2", 100, (Integer)null, 1, 5);
        this.addField(table, "f_createtime", "创建时间", "2", 100, (Integer)null, 1, 5);
        this.addField(table, "f_updatetime", "更新时间", "2", 100, (Integer)null, 1, 5);
        this.addField(table, "f_committime", "提交时间", "2", 100, (Integer)null, 1, 6);
        this.addField(table, "f_approvetime", "审核时间", "2", 100, (Integer)null, 1, 6);
        this.addField(table, "f_upload_userid", "执行人员", "2", 100, (Integer)null, 1, 6);
    }

    private void addField(TbtskObjectinfo tableInfo, String name, String alias, String fieldType, Integer length, Integer pricies, Integer nullAble, Integer code) {
        TbtskFields tbField = new TbtskFields();
        tbField.setfAlias(alias);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(fieldType);
        tbField.setfLength(length);
        tbField.setfPrecision(pricies);
        tbField.setfNullable(nullAble);
        tbField.setfFieldInnerOuterSys(1);
        tbField.setfTableid(tableInfo.getfId());
        tbField.setfTablename(tableInfo.getfTablename());
        tbField.setfFieldInnerOuterSys(code);
        this.fieldsDao.save(tbField);
    }

}
