package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.review.TbtskFlowService;
import com.geoway.landteam.customtask.servface.task.TbtskSuperUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.constants.NumberConst;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPartrolConfigService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolConfigMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserTaskMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolConfig;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlan;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolUser;
import com.github.pagehelper.util.StringUtil;
import com.google.common.base.Joiner;
import com.gw.base.Gw;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilStr;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.beans.Transient;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl
 * @date 2023/12/21 17:02
 */
@Service
public class MPartrolConfigServiceImpl implements MPartrolConfigService {

    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    TbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    TbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    PatrolConfigMapper patrolConfigMapper;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    RegionService regionService;
    @Autowired
    PatrolUserMapper patrolUserMapper;
    @Autowired
    PatrolUserTaskMapper patrolUserTaskMapper;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public PatrolConfig savePatrolInfoConfig(PatrolConfig patrolConfig) {
        //判断是否新建
        Boolean newRow = false;
        if (StringUtils.isBlank(patrolConfig.getfId())) {
            patrolConfig.setfId(UUID.randomUUID().toString());
            patrolConfig.setfState(0);
            patrolConfigMapper.gwAccessSelective(patrolConfig);
            newRow = true;
        } else {
            PatrolConfig patrolConfig1 = patrolConfigMapper.gwSearchByPK(patrolConfig.getfId());
            if(patrolConfig1.getfState() > 0){
                String tableName = tskTaskBizService.getTableNameByBizId(patrolConfig1.getfTaskId());
                if (GutilStr.isNotBlank(tableName)) {
                    boolean existTableName = dataBizService.isExistTableName(tableName);
                    // 表已经创建并且修改模板
                    if (existTableName && dataBizService.getCount(tableName, " 1=1 ") > 0 ) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许修改任务配置");
                    }
                }
            }
            patrolConfigMapper.gwUpdateByPKSelective(patrolConfig);
        }
        //创建对应调查任务
        TskTaskBiz tskTaskBiz = new TskTaskBiz();
        if(newRow){
            tskTaskBiz.setType("2");
            tskTaskBiz.setFinish(0);
            tskTaskBiz.setCreateTime(new Date());
            tskTaskBiz.setIsPublic(0);
            tskTaskBiz.setTotal(0);
            tskTaskBiz.setAssignCount(0);
            tskTaskBiz.setStatus("1");
            tskTaskBiz.setScope("智能管理");
        }else{
            tskTaskBiz = tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        }
        tskTaskBiz.setSource(patrolConfig.getfName());
        tskTaskBiz.setName(patrolConfig.getfName());
        tskTaskBiz.setDesc(patrolConfig.getfName());
        tskTaskBiz.setUserId(patrolConfig.getfUserId().toString());
        tskTaskBiz.setIsApprove(patrolConfig.getfIsApprove());
        tskTaskBiz.setGranularity(3);//下发到县
        tskTaskBiz.setMode(1);//下发模式
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        tskTaskBiz.setVersion(defaultVersion != null ? defaultVersion.getVersion() : "2018");
        tskTaskBiz.setClassId(Long.parseLong(patrolConfig.getfPatrolBusiness()));

        //任务详情
        if(tskTaskBiz.getTableId() != null){
            TbtskObjectinfo one = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
            one.setfSpatialtype(patrolConfig.getfSpatialtype());
            one.setfIsspatial(1);
            tbtskObjectinfoRepository.save(one);
        }else{
            TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
            tbtskObjectinfo.setfTablealias(tskTaskBiz.getName());
            tbtskObjectinfo.setfIsspatial(1);
            tbtskObjectinfo.setfSpatialtype(patrolConfig.getfSpatialtype());
            tbtskObjectinfo.setfState("1");
            tbtskObjectinfo.setfVersion("1");
            tbtskObjectinfo.setfTableversion(0);
            tbtskObjectinfoRepository.save(tbtskObjectinfo);
            tskTaskBiz.setTableId(tbtskObjectinfo.getfId());
        }
        tskTaskBiz = tskTaskBizService.save(tskTaskBiz, patrolConfig.getfRegionCode(), 2);
        // 新创建
        if (newRow) {
            patrolConfig.setfTaskId(tskTaskBiz.getId());
            // 任务授权给创建者
            saveManager(patrolConfig.getfUserId(),patrolConfig.getfTaskId());
            patrolConfigMapper.gwUpdateByPK(patrolConfig);
        }
        return patrolConfig;
    }

    @Override
    public void updatePatrolState(Integer state,String patrolId, String taskId) {
        PatrolConfig patrolConfig = null;
        if(StringUtils.isNotBlank(patrolId)){
             patrolConfig = patrolConfigMapper.selectByPrimaryKey(patrolId);
        }else if(StringUtils.isNotBlank(taskId)){
            patrolConfig = patrolConfigMapper.findPartolConfigByTaskId(patrolId);
        }
        if(patrolConfig != null){
            if(patrolConfig.getfState() == 0){
                throw new GwValidateException("巡查任务还没有配置完成，不能变更状态！");
            }else if(patrolConfig.getfState() > 0 && state == 4){
                String tableName = tskTaskBizService.getTableNameByBizId(patrolConfig.getfTaskId());
                if (GutilStr.isNotBlank(tableName)) {
                    boolean existTableName = dataBizService.isExistTableName(tableName);
                    // 表已经创建并且修改模板
                    if (existTableName && dataBizService.getCount(tableName, " 1=1 ") > 0 ) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许删除巡查业务");
                    }
                }
            }
        }
        patrolConfigMapper.updatePatrolState(state,patrolId,taskId);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void delPatrolCofig(String classId) {
        PatrolConfig patrolConfig = patrolConfigMapper.findPartolConfigByClassId(classId);
        if(patrolConfig != null){
           if(patrolConfig.getfState() > 0 ){
                String tableName = tskTaskBizService.getTableNameByBizId(patrolConfig.getfTaskId());
                if (GutilStr.isNotBlank(tableName)) {
                    boolean existTableName = dataBizService.isExistTableName(tableName);
                    // 表已经创建并且修改模板
                    if (existTableName && dataBizService.getCount(tableName, " 1=1 ") > 0 ) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许删除巡查业务");
                    }
                }
               //删除业务大类
               tbtskTaskClassRepository.deleteById(Long.parseLong(classId));
               //删除巡查数据
               patrolConfigMapper.deleteByPrimaryKey(patrolConfig.getfId());
               //删除对应调查任务
               if(StringUtils.isNotBlank(patrolConfig.getfTaskId())){
                   tskTaskBizService.delByTaskId(patrolConfig.getfTaskId());
               }
               patrolUserMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(),null);
               patrolUserTaskMapper.deleteByPatrolId(patrolConfig.getfId());
            }else{
               //删除业务大类
               tbtskTaskClassRepository.deleteById(Long.parseLong(classId));
               //删除巡查数据
               patrolConfigMapper.deleteByPrimaryKey(patrolConfig.getfId());
               //删除对应调查任务
               if(StringUtils.isNotBlank(patrolConfig.getfTaskId())){
                   tskTaskBizService.delByTaskId(patrolConfig.getfTaskId());
               }
               patrolUserMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(),null);
               patrolUserTaskMapper.deleteByPatrolId(patrolConfig.getfId());
           }
        }else{
            tbtskTaskClassRepository.deleteById(Long.parseLong(classId));
        }

    }

    @Override
    public Map<String, Object> findPartolConfigList(String className, Integer state, int page, int rows) {
        Map<String, Object> result = new HashMap<>();
        int start = (page - 1) * rows;
        List<PatrolConfig> list = patrolConfigMapper.findPartolConfigList(state,className,start, rows);
        int count =  patrolConfigMapper.findPartolConfigListCount(state,className);
        if (!list.isEmpty()) {
            for (PatrolConfig patrolConfig : list) {
                if(StringUtils.isNotBlank(patrolConfig.getfRegionCode())){
                    patrolConfig.setRegionName(regionService.getName(patrolConfig.getfRegionCode()));
                }
                if (patrolConfig.getClassImgurl() != null && !patrolConfig.getClassImgurl().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", patrolConfig.getClassImgurl(), null);
                    patrolConfig.setClassImgurl(url);
                }
                if (patrolConfig.getClassAppicon() != null && !patrolConfig.getClassAppicon().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", patrolConfig.getClassAppicon(), null);
                    patrolConfig.setClassAppicon(url);
                }
                if(StringUtils.isNotBlank(patrolConfig.getfPatrolBusiness())){
                    List<TskTaskBiz> tskTaskBizs  =   tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(patrolConfig.getfPatrolBusiness()));
                    if(!tskTaskBizs.isEmpty()){
                        bizSetParamByClass(tskTaskBizs, null, null);
                        patrolConfig.setTaskBizs(tskTaskBizs.get(0));
                    }
                }
            }
        }
        result.put("data", list);
        result.put("totalCount", count);
        return result;
    }

    @Override
    public void bizSetParamByClass(List<TskTaskBiz> bizs, String userRegion, Long userId) {
        for (TskTaskBiz biz : bizs) {
            // 任务区域
            List<BizArea> tskTaskBizArea = tskTaskBizService.getTskTaskBizAreaByBizId(biz.getId());
            if (!tskTaskBizArea.isEmpty()) {
                List<String> collect = tskTaskBizArea.stream().map(a -> a.getArea()).collect(Collectors.toList());
                biz.setTaskArea(com.geoway.landteam.landcloud.common.util.base.StringUtils.join(collect, ","));
            }

            if (StringUtils.isNotBlank(biz.getDataUrl())) {
                String name = biz.getDataUrl().substring(biz.getDataUrl().lastIndexOf("/") + 1);
                biz.setDataFileName(name);
                if (biz.getDataUrl() != null) {
                    biz.setDataUrl(temporarySignedUrlService.getTemporarySignedUrl("", biz.getDataUrl(), null));
                }
            }
            if (StringUtils.isNotBlank(biz.getWorkflowUrl())) {
                String name = biz.getWorkflowUrl().substring(biz.getWorkflowUrl().lastIndexOf("/") + 1);
                biz.setWorkflowFileName(name);
                if (!biz.getWorkflowUrl().contains("AccessKeyId")) {
                    biz.setWorkflowUrl(temporarySignedUrlService.getTemporarySignedUrl("", biz.getWorkflowUrl(), null));
                }
            }
            if (StringUtils.isNotBlank(biz.getUserUrl())) {
                String name = biz.getUserUrl().substring(biz.getUserUrl().lastIndexOf("/") + 1);
                biz.setUserFileName(name);
                if (!biz.getUserUrl().contains("AccessKeyId")) {
                    biz.setUserUrl(temporarySignedUrlService.getTemporarySignedUrl("", biz.getUserUrl(), null));
                }
            }
        }
    }

    //添加默认管理员
    public void saveManager(Long userId,String taskId){
        UserBiz2 ub = new UserBiz2();
        ub.setUserId(userId);
        ub.setBizId(taskId);
        ub.setRole(0);
        userBiz2Repository.save(ub);
        //任务创建者同为管理员
        UserBiz2 userBiz2 = new UserBiz2();
        userBiz2.setUserId(userId);
        userBiz2.setBizId(taskId);
        userBiz2.setRole(1);
        userBiz2Repository.save(userBiz2);
        //任务创建者同为超级审核员
        UserBiz2 userBiz3 = new UserBiz2();
        userBiz3.setUserId(userId);
        userBiz3.setBizId(taskId);
        userBiz3.setRole(5);
        userBiz2Repository.save(userBiz3);
        //查询用户政区
        List<String> regions = landUser2AreaRepository.queryAreas(userId);
        if (!regions.isEmpty()) {
            //给任务管理员设置管理区
            tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions .get(0), null);
            //给任务管理员设置超级审核区
            tbtskSuperUserAuditAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions .get(0), null);
        }
    }


}
