package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TbtskSuperUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserAuditAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPartrolConfigService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPartrolTaskService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolApproveRecordMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolConfigMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolUserTaskMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.*;
import com.geoway.landteam.patrolclue.model.until.DateUtils;
import com.gw.base.data.GwValidateException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl
 * @date 2023/12/21 17:02
 */
@Service
public class MPartrolTaskServiceImpl implements MPartrolTaskService {

    @Autowired
    TbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    TbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MPartrolConfigService mPartrolConfigService;
    @Resource
    TskRightAreaRepository rightAreaRepository;
    @Autowired
    MTbtskFieldsService fieldsService;
    @Autowired
    PatrolUserTaskMapper patrolUserTaskMapper;
    @Autowired
    PatrolApproveRecordMapper patrolApproveRecordMapper;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    PatrolConfigMapper patrolConfigMapper;
    @Autowired
    LandUser2AreaRepository userAreaDao;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    UserAreaRepository userAreaRepository;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskAuditAssignRecordRepository tbtskAuditAssignRecordRepository;

    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    RegionService regionService;
    @Autowired
    PatrolUserMapper patrolUserMapper;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Resource
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    TbsysSignRecordRepository tbsysSignRecordRepository;


    @Override
    public Map<String, Object> findPartolTaskList(String patrolId,Long userId,String  name,String  usernName, int page, int rows) {
        Map<String, Object> result = new HashMap<>();
        int start = (page - 1) * rows;
        List<PatrolUserTask> list = patrolUserTaskMapper.findListLimit(patrolId,userId,name,usernName,start, rows);
        int count =  patrolUserTaskMapper.findListLimitCount(patrolId,userId,name,usernName);
        result.put("data", list);
        result.put("totalCount", count);
        return result;
    }

    @Override
    public List<PatrolUserTask> findPartolTaskList(String patrolId, Long userId, String patrolTime) {
        List<PatrolUserTask> list = patrolUserTaskMapper.findPartolTaskList(patrolId,userId,patrolTime);
        PatrolConfig patrolConfig = patrolConfigMapper.selectByPrimaryKey(patrolId);
        String tableName = null;
        String tableNameGzqk = null;
        String tableNameWt = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); // 定义日期格式
        //查询工作情况字段
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
         for(TbtskObjectinfo tbtskObjectinfo: objectbyTaskId){
             if(StringUtils.isNotBlank(tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("工作情况")){
                 tableNameGzqk = tbtskObjectinfo.getfTablename();
             }else if(StringUtils.isNotBlank(tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("问题数据")){
                 tableNameWt = tbtskObjectinfo.getfTablename();
             }else{
                 tableName = tbtskObjectinfo.getfTablename();
             }
         }
        for (PatrolUserTask patrolUserTask : list) {
            patrolUserTask.setSignCount(tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, patrolUserTask.getfId()));
            Integer gzqkcount = dataBizService.getCount(tableNameGzqk, " f_xcrwid = '"+patrolUserTask.getfId()+"'");
            patrolUserTask.setWorkReportCount(gzqkcount);
            String sql = "select count(distinct f_dataid) from tbtsk_assign_record tar where f_status  ='1' and f_taskid  = '"+patrolConfig.getfTaskId()+"' " +
                    "and  f_assignto = '"+userId+"' and  f_createtime  <= '"+sdf.format(patrolUserTask.getfEndTime())
                    +"' and exists (select tb.f_id from "+tableName+" tb where tb.f_id = tar.f_dataid) ";
/*
            String sql = "select count(distinct f_dataid) from tbtsk_assign_record tar where f_status  ='1' and f_taskid  = '"+patrolConfig.getfTaskId()+"' " +
                    "and  f_assignto = '"+userId+"' and  f_createtime  between '"+sdf.format(patrolUserTask.getfStartTime())+"' and '"+sdf.format(patrolUserTask.getfEndTime())+"' ";
*/
            Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
            patrolUserTask.setXsCount(count);
        }
        return list;
    }

    @Override
    public Map<String, Object> findPartolGzqk(String patrolId, String xcrwId) {
        Map<String, Object> result = new HashMap<>();
        PatrolConfig patrolConfig = patrolConfigMapper.selectByPrimaryKey(patrolId);
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        //查询工作情况字段
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
           for(TbtskObjectinfo tbtskObjectinfo : objectbyTaskId){
               if(StringUtils.isNotBlank(tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("工作情况")){
                   List<TbtskFields> fieldsList = tskTaskBizService.getFieldsByTableId(tbtskObjectinfo.getfId());
                   //获取详情主显字段
                   List<TbtskGroup> detailMainGroup = tbtskGroupRepository.selectByTableIdAndGroupcode("app",tbtskObjectinfo.getfId(),"202");
                   List<String> fields = new ArrayList<>();
                   for (TbtskFields f : fieldsList) {
                       fields.add(f.getfFieldname());
                   }
                   Map currObj = dataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fields, "f_xcrwid", "'" + xcrwId + "'");
                  /* if (null == currObj) {
                       throw new RuntimeException("数据不存在");
                   }*/
                   result.put("gzqkFields", fieldsList);
                   result.put("gzqkDetailGroup", detailMainGroup);
                   result.put("gzqkInfo", currObj);
               }
           }
        return result;
    }

    @Override
    public List<TbsysSignRecord> findPartolSign(Long userId, String patrolId, String xcrwId) {
       return  tbsysSignRecordRepository.getByUserIdAndXsrwId(userId, xcrwId);
    }

    @Override
    public Map<String, Object> findPartolWtdata(String patrolId, String xcrwId,String tbId) {
        Map<String, Object> result = new HashMap<>();
        PatrolConfig patrolConfig = patrolConfigMapper.selectByPrimaryKey(patrolId);
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        //查询问题数据字段
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
        for(TbtskObjectinfo tbtskObjectinfo : objectbyTaskId){
            if(StringUtils.isNotBlank(tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("问题数据")){
                List<TbtskFields> fieldsList = tskTaskBizService.getFieldsByTableId(tbtskObjectinfo.getfId());
                //获取详情主显字段
                List<TbtskGroup> detailMainGroup = tbtskGroupRepository.selectByTableIdAndGroupcode("app",   tbtskObjectinfo.getfId(),"202");
                List<String> fields = new ArrayList<>();
                for (TbtskFields f : fieldsList) {
                    fields.add(f.getfFieldname());
                }
                String where = "f_xcrwid = " +"'"+xcrwId+"'";
                if(StringUtils.isNotBlank(tbId)){
                    where += " and f_tbid = '"+tbId+"'";
                }
                List<Map> currObj = dataBizService.queryAllData(tbtskObjectinfo.getfTablename(), fields, where);
               /* if (null == currObj) {
                    throw new RuntimeException("数据不存在");
                }*/
                result.put("wtFields", fieldsList);
                result.put("wtDetailMainGroup", detailMainGroup);
                result.put("wtInfo", currObj);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> findPartolTaskTb(Long userId, String patrolId, String xcrwId) {
        Map<String, Object> result = new HashMap<>();
        PatrolConfig patrolConfig = patrolConfigMapper.selectByPrimaryKey(patrolId);
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(patrolConfig.getfTaskId());
        TbtskObjectinfo tbtskObjectinfo =  tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        //获取对应任务
        PatrolUserTask patrolUserTask = patrolUserTaskMapper.selectByPrimaryKey(xcrwId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); // 定义日期格式
        //查询数据字段
        List<TbtskFields> fieldsList = tskTaskBizService.getFieldsByTableId(tbtskObjectinfo.getfId());
        //获取详情主显字段
        List<TbtskGroup> detailMainGroup = tbtskGroupRepository.selectByTableIdAndGroupcode("app", tbtskObjectinfo.getfId(),"100");
        List<String> fields = new ArrayList<>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        String where = " 1= 1 ";
        if(StringUtils.isNotBlank(xcrwId)){
            String sql = "select tar.f_dataid from tbtsk_assign_record tar where f_id = tar.f_dataid and tar.f_status='1' and tar.f_taskid " +
                    " = '"+patrolConfig.getfTaskId()+"' and  tar.f_assignto = '"+userId+"' and tar.f_createtime between '"+sdf.format(patrolUserTask.getfStartTime())+"' and '"+sdf.format(patrolUserTask.getfEndTime())+"' ";
            where += " and exists ("+sql+")";
        }
        List<Map> currObj = dataBizService.queryAllData(tbtskObjectinfo.getfTablename(), fields, where);
        result.put("tbFields", fieldsList);
        result.put("tbDetailMainGroup", detailMainGroup);
        result.put("tbInfo", currObj);
        return result;
    }

    @Override
    public List<PatrolUserTask> findPartolTaskListByTbid(String bizId, String tbId) {
        PatrolConfig partolConfig = patrolConfigMapper.findPartolConfigByTaskId(bizId);
        //查询下发的数据用户
        List<String>  assigntos =  tskAssignRecordRepository.findAssigntoByTaskIdAndTbId(bizId,tbId);
        List<Long> userIds = assigntos.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<PatrolUserTask> list = patrolUserTaskMapper.findPatrolUserTaskByUserIds(partolConfig.getfId(),userIds);
        return list;
    }

    @Override
    public Map<String, Object> findPatrolUserList(String taskId, String phone, String usernName,int role, int page, int rows) {
        Map<String, Object> result = new HashMap<>();
        int start = (page - 1) * rows;
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        PatrolConfig patrolConfig = patrolConfigMapper.findPartolConfigByTaskId(taskId);
        List<PatrolUser> patrolUserList = patrolUserMapper.findPatrolUserList(patrolConfig.getfId(), phone, usernName,role,start, rows);
               for(PatrolUser patrolUser : patrolUserList){
                   patrolUser.setUserRoleAreas(tskTaskBizService.getUserRoleAreas(taskId,  patrolUser.getfUserId(),3,null));
                   LandUser2Area landUser2Area = userAreaDao.queryOneByUserId(patrolUser.getfUserId());
                   patrolUser.setRegionCode(landUser2Area.getRegionCode());
                   String regionName = regionRepository.getNameByCodeAndVersion(landUser2Area.getRegionCode(),defaultVersion!=null?defaultVersion.getVersion():"2018");
                   patrolUser.setRegionName(regionName);
               }
        int count =  patrolUserMapper.findPatrolUserListCount(patrolConfig.getfId(), phone, usernName);
        result.put("data", patrolUserList);
        result.put("totalCount", count);
        return result;
    }

    @Override
    public List<PatrolUser> findPatrolUserRole(String patrolId, Long userId) {
        List<PatrolUser> patrolUsers = patrolUserMapper.findPatrolUserRoleByPatrolId(patrolId,userId);
        return patrolUsers;
    }


    @Override
    public void addPatrolRole(String taskId, Long userId, Integer role,String regions,String version) {
        PatrolConfig patrolConfig = patrolConfigMapper.findPartolConfigByTaskId(taskId);
        if(patrolConfig != null){
            List<PatrolUser> byUserIdAndRoleAndId = patrolUserMapper.findByUserIdAndRoleAndId(patrolConfig.getfId(), userId, null);
            if(byUserIdAndRoleAndId.size() <= 0 || byUserIdAndRoleAndId.get(0).getfRole() == role){
                JSONArray keyData = JSON.parseArray(patrolConfig.getfPatrolFreq());
                for (int i = 0; i < keyData.size(); i++) {
                    JSONObject jsonObject = keyData.getJSONObject(i);
                    Integer patrolRole = jsonObject.getInteger("role");
                    Integer frequency = jsonObject.getInteger("frequency");
                    if(byUserIdAndRoleAndId.size() <= 0){
                        if(role == patrolRole){
                            PatrolUser patrolUser = new PatrolUser();
                            patrolUser.setfId(UUID.randomUUID().toString());
                            patrolUser.setfUserId(userId);
                            patrolUser.setfRole(role);
                            patrolUser.setfPatrolId(patrolConfig.getfId());
                            patrolUser.setfPatrolFreq(frequency.toString());
                            patrolUserMapper.gwAccessSelective(patrolUser);

                            //给用户增加对应任务数据
                            addPatrolUserTask(patrolConfig,frequency,userId);
                        }
                    }
                }
                //相关任务配置作业员角色及作业区
                tskTaskBizService.saveUserBiz(userId, taskId, 3);
                tskTaskBizService.changeRightArea(taskId, userId.toString(), regions);
                //上级巡查员默认为下级巡查员的审核员，一级、二级默认为管理员
                //设置为管理员
                tskTaskBizService.saveUserBiz(userId, taskId, 1);
                tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions, version);
                //设置为审核员
                tskTaskBizService.saveUserBiz(userId, taskId, 2);
                tbtskUserAuditAreaService.updateByTaskIdAndUserId(taskId, userId.toString(), regions, version);
            }else{
                throw new GwValidateException("用户【"+userId+"】已配置巡查员，不能重复配置，请检查数据");
            }
        }
    }

    @Override
    public void updatePatrolRole(String id,String taskId, String regions, String version) {
        PatrolUser patrolUser = patrolUserMapper.gwSearchByPK(id);
        //相关任务配置作业员角色及作业区
        tskTaskBizService.changeRightArea(taskId,patrolUser.getfUserId().toString(), regions);
        //上级巡查员默认为下级巡查员的审核员，一级、二级默认为管理员
        //设置为管理员
        tbtskUserManageAreaService.deleteByTaskIdAndUserId(taskId,patrolUser.getfUserId().toString());
        tbtskUserManageAreaService.updateByTaskIdAndUserId(taskId, patrolUser.getfUserId().toString(), regions, version);
        //设置为审核员
        tbtskUserAuditAreaService.deleteByTaskIdAndUserId(taskId,patrolUser.getfUserId().toString());
        tbtskUserAuditAreaService.updateByTaskIdAndUserId(taskId, patrolUser.getfUserId().toString(), regions, version);
    }

    @Override
    @Transactional
    public void cancelPatrolRole(String taskId, List<Long> userIdList) {
        PatrolConfig patrolConfig = patrolConfigMapper.findPartolConfigByTaskId(taskId);
        if(patrolConfig != null){
            for(Long userId : userIdList){
                //删除这个用户巡查角色
                patrolUserMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(),userId);
                //删除这个用户巡查任务数据
                patrolUserTaskMapper.deleteByPatrolIdAndUserId(patrolConfig.getfId(),userId);
                //删除对应任务角色和区域
                //删除用户管理区及角色
                userBiz2Repository.deleteByBizIdAndUserIdAndRole(taskId, userId, 1);
                tbtskUserManageAreaService.deleteByTaskIdAndUserId(taskId,userId.toString());
                //删除用户审核区及角色
                userBiz2Repository.deleteByBizIdAndUserIdAndRole(taskId, userId, 2);
                tbtskUserAuditAreaService.deleteByTaskIdAndUserId(taskId,userId.toString());
                //删除用户作业区及角色
                userBiz2Repository.deleteByBizIdAndUserIdAndRole(taskId, userId, 3);
                rightAreaRepository.deleteByTaskIdAndUserId(taskId, userId.toString());
            }
        }
    }

    @Override
    public PatrolConfig findPartolTaskByClassId(Long classId) {
        PatrolConfig patrolConfig = null;
        TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(classId);
        List<TskTaskBiz> tskTaskBizs =  tskTaskBizService.getTskTaskBizByClassId(classId);
        if(tskTaskBizs !=null && tskTaskBizs.size() > 0){
             patrolConfig = patrolConfigMapper.findPartolConfigByTaskId(tskTaskBizs.get(0).getId());
            mPartrolConfigService.bizSetParamByClass(tskTaskBizs, null, null);
            patrolConfig.setTaskBizs(tskTaskBizs.get(0));
            patrolConfig.setClassDesc(tbtskTaskClass.getDesc());
        }
        return patrolConfig;
    }


    /**
     * 用户签到
     *
     * @param userId
     * @param lon
     * @param lat
     */
    public int userClockIn(Long userId, String lon, String lat, String patrolId,String xcrwId) throws Exception {
        int signCount = 1;
        String wkt = "POINT(" + lon + " " + lat + ")";
            Geometry geometry = WKTUtil.wktToGeom(wkt);
            String code = "";
            String codeName = "";
            RegionVillage regionVillage = regionService.queryRegionVillageByCoor(geometry);
            if (regionVillage != null) {
                code = regionVillage.getCode();
                codeName = regionVillage.getName();
            } else {
                RegionTown regionTown = regionService.queryRegionTownCotain(geometry);
                if (regionTown != null) {
                    code = regionTown.getCode();
                    codeName = regionTown.getName();
                } else {
                    RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);
                    if (region != null) {
                        code = region.getCode();
                        codeName = region.getName();
                    }
                }
            }
            TbsysSignRecord bean = new TbsysSignRecord();
            bean.setUserId(userId);
            bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bean.setRegionCode(code);
            bean.setAddr(codeName);
            bean.setLat(Double.parseDouble(lat));
            bean.setLon(Double.parseDouble(lon));
            bean.setPlanId(patrolId);
            bean.setXsrwId(xcrwId);
            tbsysSignRecordRepository.save(bean);
            signCount = tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, xcrwId);
        return signCount;
    }

    @Override
    public void submitPartolGzqk(Long userId, JSONObject param) {
        String f_patrolid = param.getString("f_patrolid");
        String f_xcrwid = param.getString("f_xcrwid");
        PatrolConfig patrolConfig = patrolConfigMapper.selectByPrimaryKey(f_patrolid);
        String tableNameGzqk = null;
       /* SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); // 定义日期格式*/
        //查询工作情况字段
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(patrolConfig.getfTaskId());
        for(TbtskObjectinfo tbtskObjectinfo: objectbyTaskId){
            if(StringUtils.isNotBlank(tbtskObjectinfo.getfRemark()) && tbtskObjectinfo.getfRemark().equals("工作情况")){
                tableNameGzqk = tbtskObjectinfo.getfTablename();
                break;
            }
        }
        String sql = "select count(1) from "+tableNameGzqk+" where  f_patrolid ='"+f_patrolid+"' and f_xcrwid ='"+f_xcrwid+"'";
        Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
        if(count > 0 ){
            throw new GwValidateException("巡查任务已有工作情况，请勿重复提交");
        }
        // 调用函数进行转换
        Map<String, Object> map = convertJsonToMap(param);
        map.put("f_id",UUID.randomUUID().toString());
        dataBizService.insertData(tableNameGzqk,map,null);
    }

    @Override
    public List<PatrolApproveRecord> findPartolApproveRecord(String taskId, String tbId, String xcrwId) {
        return patrolApproveRecordMapper.findPartolApproveRecord(taskId,tbId,xcrwId);
    }

    @Override
    public Map<String,Object> checkApprovePermission(String taskId, String tbId, String xcrwId, Long userId) {
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("hasPermission", true);
        List<TbtskAuditAssignRecord> byTaskIdAndAssigntoAndDataIdAndStatus = tbtskAuditAssignRecordRepository.findByTaskIdAndAssigntoAndDataIdAndStatus(taskId, userId.toString(), tbId, "0");
         if(byTaskIdAndAssigntoAndDataIdAndStatus.size() <= 0){
             resultMap.put("hasPermission", false);
             return resultMap;
         }
        List<PatrolApproveRecord> partolApproveRecord = patrolApproveRecordMapper.findPartolApproveRecord(taskId, tbId, xcrwId);
        if(partolApproveRecord.size() > 0){
            resultMap.put("hasPermission", false);
            return resultMap;
        }
        return resultMap;
    }

    @Override
    public PatrolApproveRecord savePatrolApproveRecord(PatrolApproveRecord patrolApproveRecord) {
        if(StringUtils.isNotBlank(patrolApproveRecord.getfId())){
            patrolApproveRecordMapper.updateByPrimaryKeySelective(patrolApproveRecord);
        }else{
            patrolApproveRecord.setfId(UUID.randomUUID().toString());
            patrolApproveRecordMapper.gwAccessSelective(patrolApproveRecord);
        }
        return patrolApproveRecord;
    }

    @Override
    public void batchApproveXcTaskData(JSONObject data, Long userId) throws Exception {
        String taskId = data.getString("taskId");
        String fOption = data.getString("fOption");
        String fStatus = data.getString("fStatus");
        String fDescription = data.getString("fDescription");
        String fRemark = data.getString("fRemark");

        TskTaskBiz tskTaskBiz = tskTaskBizService.findOne(taskId);
        if (null == tskTaskBiz) {
            throw new Exception("下发失败，业务不存在或已被删除");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoService.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo || (tbtskObjectinfo != null && StringUtils.isBlank(tbtskObjectinfo.getfTablename()))) {
            throw new Exception("下发失败，业务数据表不存在或已被删除");
        }
        //勾选分发数据
        if(data.containsKey("taskids") ){
            JSONArray tbIds = data.getJSONArray("taskids");
            for (int i = 0; i < tbIds.size(); i++) {
                JSONObject jsonObject = tbIds.getJSONObject(i);
                String tbId = jsonObject.getString("tbId");
                String xcrwId = jsonObject.getString("xcrwId");
                List<PatrolApproveRecord> partolApproveRecord = patrolApproveRecordMapper.findPartolApproveRecord(taskId, tbId, xcrwId);
                if(partolApproveRecord.size() <= 0){
                    PatrolApproveRecord patrolApproveRecord = new PatrolApproveRecord();
                    patrolApproveRecord.setfId(UUID.randomUUID().toString());
                    patrolApproveRecord.setfTaskId(taskId);
                    patrolApproveRecord.setfTbId(tbId);
                    patrolApproveRecord.setfXcrwId(xcrwId);
                    patrolApproveRecord.setfApproveUserId(userId);
                    patrolApproveRecord.setfApproveUser(userId.toString());
                    patrolApproveRecord.setfOption(Integer.valueOf(fOption));
                    patrolApproveRecord.setfStatus(Integer.valueOf(fStatus));
                    patrolApproveRecord.setfRemark(fRemark);
                    patrolApproveRecord.setfDescription(fDescription);
                    patrolApproveRecord.setfApproveTime(new Timestamp(System.currentTimeMillis()));
                    patrolApproveRecordMapper.gwAccessSelective(patrolApproveRecord);
                }
            }
        }else if(data.containsKey("taskQueryParameter")){
            //获取筛选条件
            TaskQueryParameter taskQueryParameter = JSONObject.parseObject(data.getString("taskQueryParameter"),TaskQueryParameter.class);
            taskQueryParameter.setUserId(userId);
            taskQueryParameter.setTaskId(taskId);
            Pair<String, String> queryParamPair = tskTaskBizService.parseQueryParameter(taskQueryParameter);
            String tableName = "with assign as (select f_dataid ,f_assignto from tbtsk_assign_record tar  where " +
                    "f_taskid ='"+taskId+"' group by f_dataid ,f_assignto)\n" +
                    "select\n" +
                    "\ttb.f_id as tbid,tput.f_id as xcrwid\n" +
                    "from\n" +
                    "\ttbtsk_task_znglrw_20240109160703834 tb\n" +
                    "inner join assign tar on (tar.f_dataid = tb.f_id)\n" +
                    "left join tb_patrol_user_task tput on (cast (tput.f_userid as varchar)  = tar.f_assignto)\n" +
                    "where exists (select * from tbtsk_audit_assign_record audit where audit.f_dataid = tb.f_id and audit.f_assignto='"+userId+"')\n" +
                    "and not exists (select * from tb_patrol_approve_record approve where approve.f_tbid  = tb.f_id and approve.f_xcrwid = tput.f_id)\n ";
            String where = "and " +queryParamPair.getRight();
            List<String> finalFliedNameList = new ArrayList<>();
            finalFliedNameList.add("tb.f_id as tbid");
            finalFliedNameList.add("tput.f_id as xcrwid");
            Integer count = jdbcTemplate.queryForObject(tableName+where, Integer.class);
            if (count > 0) {
                //保存数据临时数据
                    String insetSql = " INSERT INTO public.tb_patrol_approve_record (f_id, f_taskid, f_tbid, f_xcrwid, f_option, f_approve_user,      f_approve_time, f_status, f_description, f_approve_userid, f_remark) " +
                            "select uuid_generate_v4(),'"+taskId+"',aa.tbid, aa.xcrwid,'"+fOption+"','"+userId+"',now" +
                            "(),'"+fStatus+"','"+fDescription+"','"+userId+"','"+fRemark+"' from ("+tableName  +where+") as aa";
                    jdbcTemplate.execute(insetSql);
            }
        }
    }

    @Override
    public Pair<Long, List<Map>> queryXcTaskDataForList(TaskQueryParameter param) throws Exception {
        Pair<String, String> queryParamPair = tskTaskBizService.parseQueryParameter(param);
        String tableName = "with assign as (select f_dataid ,f_assignto from tbtsk_assign_record tar  where " +
                "f_taskid ='"+param.getTaskId()+"' group by f_dataid ,f_assignto)\n" +
                "select\n" +
                " AAA " +
                "from\n" +
                "\tBBB tb\n" +
                "inner join assign tar on (tar.f_dataid = tb.f_id)\n" +
                "left join tb_patrol_user_task tput on (cast (tput.f_userid as varchar)  = tar.f_assignto)\n" +
                "where exists (select * from tbtsk_audit_assign_record audit where audit.f_dataid = tb.f_id and audit.f_assignto='"+param.getUserId()+"')\n" +
                "and not exists (select * from tb_patrol_approve_record approve where approve.f_tbid  = tb.f_id and approve.f_xcrwid = tput.f_id)\n ";
        String where = " and  " +queryParamPair.getRight();
        TskTaskBiz taskBiz = tskTaskBizService.findOne(param.getTaskId());
        if (null == taskBiz) {
            throw new Exception("下发失败，业务不存在或已被删除");
        }
        TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectByTableId(taskBiz.getTableId());
        List<String> fieldNameList  = fieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode("web", tableInfo.getfId(), FieldGroupTypeConstant.WEB_LIST_DISPLAY);
        tskTaskBizService.fillRequiredFieldNames(fieldNameList,tableInfo);
        fieldNameList = fieldNameList.stream().map("tb."::concat).collect(Collectors.toList());
        fieldNameList.add("tput.f_name");
        fieldNameList.add("tput.f_starttime");
        fieldNameList.add("tput.f_endtime");
        fieldNameList.add("tput.f_state");
        fieldNameList.add("tput.f_id as f_xcrwid");
        fieldNameList.add("tput.f_userid as f_assignto");
       /* //查询下发人员
        fieldNameList.add("(select record.f_assignto  from tbtsk_assign_record record where tb.f_id = record.f_dataid and  record.f_status ='1' order by record.f_createtime desc   limit 1 )");*/
        //查询批量审核分发
       /* List<UserBiz2> byBizIdAndRole = userBiz2Repository.findByBizIdAndRole(param.getTaskId(), 5);
        if(byBizIdAndRole.size() > 0){//判断该任务是否配置超级审核员*/
            fieldNameList.add("(select record.f_assignto as f_distributionto from tbtsk_audit_assign_record record where tb.f_id = record.f_dataid limit 1 )");
       /* }*/
        Integer count = jdbcTemplate.queryForObject(tableName.replace("BBB",tableInfo.getfTablename()).replace("AAA","count(1)")+where,Integer.class);
        String order = " order by " + param.getSortParam();
        where += order;
        if(param.getPage()!=null && param.getRows()!=null) {
            where += " limit " + param.getRows() + " offset " + (param.getPage() - 1) * param.getRows();
        }
        List<Map<String, Object>> originalList = jdbcTemplate.queryForList(tableName.replace("BBB",tableInfo.getfTablename()).replace("AAA",StringUtils.join(fieldNameList.toArray (), ","))+where);
        List<Map> dataList = tskTaskBizService.updateAssignInfo(convertToListOfMaps(originalList), param.getTaskId());
        return Pair.of(Long.valueOf(count), dataList);
    }



    private static List<Map> convertToListOfMaps(List<Map<String, Object>> list) {
        List<Map> resultList = new ArrayList<>();

        for (Map<String, Object> map : list) {
            Map newMap = new HashMap();

            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();

                if (!newMap.containsKey(key)) {
                    newMap.put(key, value);
                } else {
                    throw new IllegalArgumentException("Duplicate keys are not allowed.");
                }
            }

            resultList.add(newMap);
        }

        return resultList;
    }

    //新增用户巡查任务
    public void addPatrolUserTask(PatrolConfig patrolConfig,Integer frequency,Long userId) {
        //判断计划频率
        if (patrolConfig.getfStartTime() != null && patrolConfig.getfEndTime() != null) {
            Date startDate = patrolConfig.getfStartTime();
            Date endDate = patrolConfig.getfEndTime();
            int count = 0;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            List<PatrolUserTask> patrolUserTasks = new ArrayList<>();
            String name = "第%s次巡查（" + patrolConfig.getfName() + "）";
            SimpleDateFormat sf = null;
            String tempName = "";
            Date tempStart = null;
            Date tempEnd = null;
            Date now = new Date();
            if (frequency == 1) {
                //日
                count = DateUtils.getDayCount(endDate, startDate);
            } else if (frequency == 2) {
                //周
                count = DateUtils.getWeekCount(endDate, startDate);
            } else if (frequency == 3) {
                //月
                count = DateUtils.getMonthCount(endDate, startDate);
            } else if (frequency == 4) {
                //季度
                count = DateUtils.getSeasonCount(endDate, startDate);
            }else if (frequency == 5) {
                //半年
                count = DateUtils.getHalfYearCount(endDate, startDate);
            }else if (frequency == 6) {
                //年
                count = DateUtils.getYearCount(endDate, startDate);
            }
            if (count > 366) {
                throw new RuntimeException("任务数量过多");
            }
            for (int i = 0; i < count; i++) {
                tempName = String.format(name, i + 1);
                if (frequency == 1) {
                    //日
                    sf = new SimpleDateFormat("yyyy-MM-dd");
                    tempStart = calendar.getTime();
                    tempEnd = DateUtils.getEndOfDay(calendar.getTime());
                } else if (frequency == 2) {
                    //周
                    tempStart = DateUtils.getStartOfWeek(calendar.getTime());
                    tempEnd = DateUtils.getEndOfWeek(calendar.getTime());
                    calendar.set(Calendar.WEEK_OF_YEAR, calendar.get(Calendar.WEEK_OF_YEAR) + 1);
                } else if (frequency == 3) {
                    calendar.setTime(DateUtils.getStartOfMonth(calendar.getTime()));
                    sf = new SimpleDateFormat("yyyy-MM");
                    tempStart = DateUtils.getStartOfMonth(calendar.getTime());
                    tempEnd = DateUtils.getEndOfMonth(calendar.getTime());
                }else if (frequency == 4) {
                    tempStart = DateUtils.getSeasonStartDate(calendar.getTime());
                    tempEnd = DateUtils.getSeasonEndDate(calendar.getTime());
                }else if (frequency == 5) {
                    tempStart = DateUtils.getHalfYearStartTime(calendar.getTime());
                    tempEnd = DateUtils.getHalfYearEndTime(calendar.getTime());
                } else if (frequency == 6) {
                    tempStart = DateUtils.getStartOfYear(calendar.getTime());
                    tempEnd = DateUtils.getEndOfYear(calendar.getTime());
                }
                PatrolUserTask patrolUserTask = new PatrolUserTask();
                patrolUserTask.setfCreateTime(new Timestamp(now.getTime()) );
                patrolUserTask.setfName(tempName);
                patrolUserTask.setfId(UUID.randomUUID().toString());
                patrolUserTask.setfStartTime(new Timestamp(tempStart.getTime()));
                patrolUserTask.setfEndTime(new Timestamp(tempEnd.getTime()));
                patrolUserTask.setfPatrolId(patrolConfig.getfId());
                patrolUserTask.setfUserId(userId);
                //判断任务是否已经结束
                updateState(patrolUserTask, tempStart, tempEnd, now);
                patrolUserTasks.add(patrolUserTask);
                calendar.setTime(tempEnd);
                calendar.set(Calendar.SECOND, calendar.get(Calendar.SECOND) + 1);
               /* calendar.setTime(calendar.getTime());*/
            }
            patrolUserTaskMapper.insertList(patrolUserTasks);
        }
    }

    //判断任务是否已经结束
    public boolean updateState(PatrolUserTask patrolUserTask,Date start,Date end,Date now){
        boolean result = false;
        //设置状态
        if(end.before(now)){
            if(patrolUserTask.getfState()!=null){
                result = !patrolUserTask.getfState().equals(2);
            }
            //已结束
            patrolUserTask.setfState(2);
        }else if(end.after(now) && start.before(now)){
            if(patrolUserTask.getfState()!=null){
                result = !patrolUserTask.getfState().equals(1);
            }
            //执行中
            patrolUserTask.setfState(1);
        }else if(start.after(now)){
            if(patrolUserTask.getfState()!=null){
                result = !patrolUserTask.getfState().equals(0);
            }
            //未开始
            patrolUserTask.setfState(0);
        }
        return result;
    }

    //JSONObject转Map<String, Object>
    private static Map<String, Object> convertJsonToMap(JSONObject jsonObj){
        Map<String, Object> resultMap = new HashMap<>();
        Iterator<?> keys = jsonObj.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String) keys.next();

            if (!key.equalsIgnoreCase("null")) {
                Object value;

                try {
                    value = jsonObj.get(key);
                } catch (Exception e) {
                    continue;
                }

                resultMap.put(key, value);
            }
        }

        return resultMap;
    }
}
