package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.task.TbtskUserAuditAreaService;
import com.geoway.landteam.customtask.service.task.impl.TbtskUserAuditAreaServiceImpl;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPatrolPlanService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.networkTransmission.inner.InnerProgramTransmitService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.*;
import com.geoway.landteam.patrolclue.model.patrollibrary.dto.PatrolPlanInfo;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.*;
import com.geoway.landteam.patrolclue.model.until.DateUtils;
import com.geoway.landteam.patrolclue.servface.patrollibrary.PatrolPlanAreaService;
/*import com.gw.base.data.GwValidateException;*/
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Service
public class MPatrolPlanServiceImpl implements MPatrolPlanService {
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanAreaMapper patrolPlanAreaMapper;
    @Autowired
    PatrolPlanContentMapper patrolPlanContentMapper;
    @Autowired
    PatrolProgramMapper patrolProgramMapper;
    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Autowired
    PatrolPlanScopeServiceMapper patrolPlanScopeServiceMapper;
    @Autowired
    InnerProgramTransmitService innerProgramTransmitService;

    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    PatrolPlanAreaService patrolPlanAreaService;

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    PatrolPlanScopeKeyAreaMapper patrolPlanScopeKeyAreaMapper;
    @Autowired
    PatrolPlanScopeOutServiceMapper patrolPlanScopeOutServiceMapper;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    UserBiz2Repository biz2Repository;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Resource
    TbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    private RegionService regionService;
    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(Long userId, PatrolPlanInfo patrolPlanInfo) throws Exception {
        //查询是否有同名的计划
        String name = patrolPlanInfo.getfName();
        List<PatrolPlan> list = patrolPlanMapper.selectByPlanName(name);
        if (!list.isEmpty()) {
            throw new RuntimeException("已存在同名计划，请修改");
        }
        String planId = UUID.randomUUID().toString();

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        //保存计划主体信息
        PatrolPlan patrolPlan = new PatrolPlan();
        patrolPlan.setfId(planId);
        patrolPlan.setfName(patrolPlanInfo.getfName());
        patrolPlan.setfRelprogram(patrolPlanInfo.getfRelprogram());
        patrolPlan.setfRate(patrolPlanInfo.getfRate());
        patrolPlan.setfStarttime(df.parse(patrolPlanInfo.getfStarttime()));
        patrolPlan.setfEndtime(df.parse(patrolPlanInfo.getfEndtime()));
        patrolPlan.setfRegioncode(patrolPlanInfo.getfRegioncode());
        patrolPlan.setfCreatetime(new Date());
        patrolPlan.setfPatrolbusiness(patrolPlanInfo.getfPatrolbusiness());
        //设置拟件状态
        patrolPlan.setfState(0);
        patrolPlanMapper.insert(patrolPlan);
        //保存责任区域
        List<PatrolPlanArea> patrolPlanAreas = new ArrayList<>();
        if(patrolPlanInfo.getDutyArea()!=null && !patrolPlanInfo.getDutyArea().isEmpty()){
            for (int i = 0; i < patrolPlanInfo.getDutyArea().size(); i++) {
                JSONObject object = patrolPlanInfo.getDutyArea().getJSONObject(i);
                Long uId = object.getLong("userId");
                String role = object.getString("role");
                String[] regionCodes = object.getString("regionCode").split(",");
                for (String regionCode : regionCodes) {
                    PatrolPlanArea area = new PatrolPlanArea();
                    area.setfId(UUID.randomUUID().toString());
                    area.setfArea(regionCode);
                    area.setfRole(role);
                    area.setfCreatetime(new Date());
                    area.setfUserid(uId);
                    area.setfPlanid(planId);
                    patrolPlanAreas.add(area);
                }
                //给相关的任务授权
                List<TskTaskBiz> taskBizs = tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(patrolPlanInfo.getfPatrolbusiness()));
                for(TskTaskBiz t : taskBizs){
                    List<UserBiz2> userBiz2s =  biz2Repository.findByUserIdAndBizIdAndRole(uId,t.getId(),Integer.parseInt(role));
                    if(userBiz2s.size() == 0 ){
                        UserBiz2 userBiz2 = new UserBiz2();
                        userBiz2.setId(UUID.randomUUID().toString());
                        userBiz2.setUserId(uId);
                        userBiz2.setBizId(t.getId());
                        userBiz2.setRole(Integer.parseInt(role));
                        biz2Repository.save(userBiz2);
                        //授权任务政区
                            for (String regionCode : regionCodes) {
                              if(role.equals("3")){
                                List<TskRightArea> tskRightAreas =    tskRightAreaRepository.findByTaskIdAndUserIdAndXzqdm(t.getId(),uId.toString(),regionCode);
                                if(tskRightAreas.size() == 0){
                                    TskRightArea tskRightArea = new TskRightArea();
                                    tskRightArea.setId(UUID.randomUUID().toString());
                                    tskRightArea.setTaskId(t.getId());
                                    tskRightArea.setXzqdm(regionCode);
                                    tskRightArea.setUserId(uId.toString());
                                    tskRightAreaRepository.save(tskRightArea);
                                }
                            }else if(role.equals("2")){
                                  TbtskUserAuditArea tbtskUserAuditArea = new TbtskUserAuditArea();
                                  tbtskUserAuditArea.setTaskId(t.getId());
                                  tbtskUserAuditArea.setRegionCode(regionCode);
                                  tbtskUserAuditArea.setUserId(uId.toString());
                                  tbtskUserAuditArea.setLevel(regionService.getRegionLevel(regionCode, null).shortValue());
                                  tbtskUserAuditAreaService.insertSelective(tbtskUserAuditArea);
                              }
                        }
                    }
                    //将任务配置成
                   /* t.setConfigArgs("{\"isCancelOperArea\":1  }");
                    t.setStructDbUrl(null);
                    tskTaskBizService.save(t);
                    TbtskObjectinfo tableByTableId = tskTaskBizService.getTableByTableId(t.getTableId());
                    tbtskObjectinfoRepository.updateTableVersion(tableByTableId.getfTableversion()+1,tableByTableId.getfId());*/
                }
                //给巡查人员和审核员添加对应的巡查业务
                List<TbtskUserTaskClass> tbtskUserTaskClasses = tbtskUserTaskClassRepository.queryByUserIdAndClassId(uId, Long.valueOf(patrolPlanInfo.getfPatrolbusiness()));
                if(tbtskUserTaskClasses.size() == 0){
                    TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
                    tbtskUserTaskClass.setUserId(uId);
                    tbtskUserTaskClass.setCreateDate(new Date());
                    tbtskUserTaskClass.setClassId(Long.valueOf(patrolPlanInfo.getfPatrolbusiness()));
                    //添加用户业务范围
                    tbtskUserTaskClassRepository.save(tbtskUserTaskClass);
                }
            }
            if(!patrolPlanAreas.isEmpty()){
                patrolPlanAreaMapper.insertByList(patrolPlanAreas);
            }
        }
        //保存巡查内容
        savePlanContent(patrolPlanInfo,planId,userId);
        //保存巡查计划
        JSONArray scoptArray = patrolPlanInfo.getfScope();
        List<PatrolPlanScope> scopes = new ArrayList<>();
        List<PatrolPlanScopeService> scopeServices = new ArrayList<>();
        List<PatrolPlanScopeKeyArea> scopeKeyAreas = new ArrayList<>();
        List<PatrolPlanScopeOutService> scopeOutServices = new ArrayList<>();
        completePlanScopeList(scoptArray,planId,userId,scopes,scopeServices,scopeKeyAreas,scopeOutServices);
        //保存巡查范围记录
        if(!scopes.isEmpty()){
            patrolPlanScopeMapper.insertList(scopes);
        }
        if(!scopeServices.isEmpty()){
            patrolPlanScopeServiceMapper.insertList(scopeServices);
        }
        if(!scopeKeyAreas.isEmpty()){
            patrolPlanScopeKeyAreaMapper.insertList(scopeKeyAreas);
        }
        if(!scopeOutServices.isEmpty()){
            patrolPlanScopeOutServiceMapper.insertList(scopeOutServices);
        }
        //同步巡查计划和范围
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group","patrol");
        jsonObject.put("type","insert");
        jsonObject.put("operUserId",userId);
        jsonObject.put("patrolPlan",JSONObject.parseObject(JSONObject.toJSONString(patrolPlan,SerializerFeature.WriteMapNullValue)));
        jsonObject.put("patrolPlanArea",patrolPlanAreas);
        jsonObject.put("PatrolPlanScope",scopes);
        jsonObject.put("PatrolPlanContent",patrolPlanContentMapper.getListByPlanId(patrolPlan.getfId()));
        jsonObject.put("PatrolPlanScopeService",scopeServices);
        jsonObject.put("PatrolProgram",patrolProgramMapper.gwSearchByPK(patrolPlan.getfRelprogram()));
        jsonObject.put("PatrolPlanScopeKeyArea",scopeKeyAreas);
        //异步调用
        threadPoolTaskExecutor.execute(() -> {
            try {
                innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void edit(Long userId,PatrolPlanInfo patrolPlanInfo) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

        String id = patrolPlanInfo.getfId();
        PatrolPlan patrolPlan = patrolPlanMapper.selectByPrimaryKey(id);
        if(patrolPlan.getfState().equals(1) || patrolPlan.getfState().equals(2)){
            throw new RuntimeException("已下发计划信息不可修改");
        }
        //名字不同则查询系统是否已存在要修改的计划名
        if (!patrolPlanInfo.getfName().equals(patrolPlan.getfName())) {
            List<PatrolPlan> list = patrolPlanMapper.selectByPlanName(patrolPlanInfo.getfName());
            if (!list.isEmpty()) {
                throw new RuntimeException("计划名称已存在，请修改");
            }
            patrolPlan.setfName(patrolPlanInfo.getfName());
        }
        patrolPlan.setfRelprogram(patrolPlanInfo.getfRelprogram());
        patrolPlan.setfRate(patrolPlanInfo.getfRate());
        patrolPlan.setfStarttime(df.parse(patrolPlanInfo.getfStarttime()));
        patrolPlan.setfEndtime(df.parse(patrolPlanInfo.getfEndtime()));
        patrolPlan.setfRegioncode(patrolPlanInfo.getfRegioncode());
        patrolPlanMapper.updateByPrimaryKey(patrolPlan);

        //责任区域编辑
        patrolPlanAreaService.changeUserRoleByPlanId(id,patrolPlanInfo.getDutyArea());
        //巡查范围编辑
        JSONArray scopeArray = patrolPlanInfo.getfScope();
        //todo 查询所有巡查范围
        List<String> scopeIds = patrolPlanScopeServiceMapper.findByPlanId(patrolPlan.getfId()).stream().map(r->r.getfScopeid()).collect(Collectors.toList());
        //todo 删除所有巡查范围
        if(!scopeIds.isEmpty()){
            patrolPlanScopeMapper.deleteByIds(scopeIds);
        }
        patrolPlanScopeServiceMapper.deleteByPlanId(patrolPlan.getfId());
        patrolPlanScopeKeyAreaMapper.deleteByPlanId(patrolPlan.getfId());
        patrolPlanScopeOutServiceMapper.deleteByPlanid(patrolPlan.getfId());
        //todo 新增巡查范围
        List<PatrolPlanScope> scopes = new ArrayList<>();
        List<PatrolPlanScopeService> scopeServices = new ArrayList<>();
        List<PatrolPlanScopeKeyArea> scopeKeyAreas = new ArrayList<>();
        List<PatrolPlanScopeOutService> scopeOutServices = new ArrayList<>();
        completePlanScopeList(scopeArray,patrolPlan.getfId(),userId,scopes,scopeServices,scopeKeyAreas,scopeOutServices);
        if(!scopes.isEmpty()){
            patrolPlanScopeMapper.insertList(scopes);
        }
        if(!scopeServices.isEmpty()){
            patrolPlanScopeServiceMapper.insertList(scopeServices);
        }
        if(!scopeKeyAreas.isEmpty()){
            patrolPlanScopeKeyAreaMapper.insertList(scopeKeyAreas);
        }
        if(!scopeOutServices.isEmpty()){
            patrolPlanScopeOutServiceMapper.insertList(scopeOutServices);
        }
        //巡查内容编辑
        //todo 删除巡查内容
        patrolPlanContentMapper.deleteByPlanId(patrolPlan.getfId());
        //todo 新增巡查内容
        savePlanContent(patrolPlanInfo,patrolPlanInfo.getfId(),userId);
        //同步巡查计划和范围
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group","patrol");
        jsonObject.put("type","update");
        jsonObject.put("operUserId",userId);
        jsonObject.put("patrolPlan",JSONObject.parseObject(JSONObject.toJSONString(patrolPlan,SerializerFeature.WriteMapNullValue)));
        List<PatrolPlanArea>  patrolPlanAreas = patrolPlanAreaMapper.queryByPlanId(patrolPlan.getfId());
        jsonObject.put("patrolPlanArea",patrolPlanAreas);
        jsonObject.put("PatrolProgram",patrolProgramMapper.gwSearchByPK(patrolPlan.getfRelprogram()));
        jsonObject.put("PatrolPlanContent",patrolPlanContentMapper.getListByPlanId(patrolPlan.getfId()));
        List<PatrolPlanScopeService> patrolPlanScopeServices = patrolPlanScopeServiceMapper.findByPlanId(patrolPlan.getfId());
        if(!patrolPlanScopeServices.isEmpty()){
            List<String> ids = patrolPlanScopeServices.stream().map(p -> p.getfScopeid()).collect(Collectors.toList());
            List<PatrolPlanScope> patrolPlanScopes = patrolPlanScopeMapper.selectByIds(ids);
            jsonObject.put("PatrolPlanScope",patrolPlanScopes);
            jsonObject.put("PatrolPlanScopeService",patrolPlanScopeServices);
        }
        if(!scopeKeyAreas.isEmpty()){
            jsonObject.put("PatrolPlanScopeKeyArea",scopeKeyAreas);
        }
        //异步调用
        threadPoolTaskExecutor.execute(() -> {
            try {
                innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public Map<String,Object> getList(String name, String programName,String programId, String patrolBusiness,String regionCode,int page, int rows) {
        Map map = new HashMap();
        List<PatrolPlan> list = new ArrayList<>();
        Long count = 0L;

        String sql = "SELECT A.*,\n" +
                "\tb.f_name pname,b.f_patrol_business \n" +
                "FROM\n" +
                "\ttb_patrol_plan\n" +
                "\tA LEFT JOIN tb_patrol_program b ON b.f_id = A.f_rel_program where 1=1 ";
        String countSql = "SELECT count(1)"+
                "FROM\n" +
                "\ttb_patrol_plan\n" +
                "\tA LEFT JOIN tb_patrol_program b ON b.f_id = A.f_rel_program where 1=1 ";
        if(StringUtils.isNotBlank(name)){
            sql += " and a.f_name like '%"+name+"%'";
            countSql += " and a.f_name like '%"+name+"%'";
        }
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.endsWith("00")){
                regionCode = regionCode.replace("00","");
            }
            sql += " and a.f_regioncode like '"+regionCode+"%'";
            countSql += " and a.f_regioncode like '"+regionCode+"%'";
        }
        if(StringUtils.isNotBlank(programId)){
            sql += " and a.f_rel_program = '"+programId+"'";
            countSql += " and a.f_rel_program = '"+programId+"'";
        }
        if(StringUtils.isNotBlank(programName)){
            sql += " and b.f_name like '%"+programName+"%'";
            countSql += " and b.f_name like '%"+programName+"%'";
        }
        if(StringUtils.isNotBlank(patrolBusiness)){
            sql += " and a.f_patrol_business like '%"+patrolBusiness+"%'";
            countSql += " and a.f_patrol_business like '%"+patrolBusiness+"%'";
        }
        sql += " order by a.f_createtime desc limit "+ rows+" offset "+ (page-1)*rows;
        List<Map<String, Object>> list1 = jdbcTemplate.queryForList(sql);
        list = changeMapToJavaObj(list1,"");

        count = jdbcTemplate.queryForObject(countSql,Long.class);
        map.put("list",list);
        map.put("count",count);
        return map;
    }

    @Override
    public List<PatrolPlan> findPlanList(Long userId) {
        List<PatrolPlan> list =  patrolPlanMapper.findPlanList(userId);
        if(!list.isEmpty()){
            return list.stream().filter(distinctByKey(PatrolPlan::getfId)).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public List<PatrolPlanTask> findPlanTaskList(Long userId, String planId) {
        List<PatrolPlanTask> list =  patrolPlanTaskMapper.findPlanTaskList(planId);
        if(!list.isEmpty()){
            return list.stream().filter(distinctByKey(PatrolPlanTask::getfId)).collect(Collectors.toList());
        }
        return list;
    }


    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }


    @Override
    public PatrolPlan getPatrolPlanInfo(String id) {
        PatrolPlan patrolPlan = patrolPlanMapper.selectByPrimaryKey(id);
        if(patrolPlan==null){
            throw new RuntimeException("计划id错误");
        }
        if(StringUtils.isNotBlank(patrolPlan.getfRelprogram())){
            PatrolProgram patrolProgram = patrolProgramMapper.gwSearchByPK(patrolPlan.getfRelprogram());
            if(patrolProgram!=null){
                patrolPlan.setProgramName(patrolProgram.getfName());
            }
        }
        
        return patrolPlan;
    }

    public List<PatrolPlan> changeMapToJavaObj(List<Map<String,Object>> maps,String except){
        List<PatrolPlan> list = new ArrayList<>();
        for (Map<String, Object> stringObjectMap : maps) {
            PatrolPlan patrolPlan = new PatrolPlan();
            patrolPlan.setfId(stringObjectMap.get("f_id").toString());
            patrolPlan.setfRegioncode(stringObjectMap.get("f_regioncode")!=null?stringObjectMap.get("f_regioncode").toString():null);
            patrolPlan.setfStarttime(stringObjectMap.get("f_starttime")!=null?(Date)stringObjectMap.get("f_starttime"):null);
            patrolPlan.setfEndtime(stringObjectMap.get("f_endtime")!=null? (Date)stringObjectMap.get("f_endtime"):null);
            patrolPlan.setfRate(stringObjectMap.get("f_rate")!=null?stringObjectMap.get("f_rate").toString():null);
            patrolPlan.setfRelprogram(stringObjectMap.get("f_rel_program")!=null?stringObjectMap.get("f_rel_program").toString():null);
            patrolPlan.setfName(stringObjectMap.get("f_name")!=null?stringObjectMap.get("f_name").toString():null);
            patrolPlan.setfState(stringObjectMap.get("f_state")!=null?Integer.valueOf(stringObjectMap.get("f_state").toString()):null);
            patrolPlan.setfCreatetime(stringObjectMap.get("f_createtime")!=null?(Date)stringObjectMap.get("f_createtime"):null);
            if(except != null && !except.contains("pname")) {
                patrolPlan.setProgramName(stringObjectMap.get("pname") != null ? stringObjectMap.get("pname").toString() : null);
            }
            if(stringObjectMap.containsKey("f_patrol_business")){
                if(stringObjectMap.get("f_patrol_business") != null ){
                    TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(Long.parseLong(stringObjectMap.get("f_patrol_business").toString()));
                    patrolPlan.setBusinessName(tbtskTaskClass.getName());
                }
            }
            if(StringUtils.isNotBlank(patrolPlan.getfRegioncode())){
                patrolPlan.setfRegionname(regionService.getName(patrolPlan.getfRegioncode()));
            }
            list.add(patrolPlan);
        }
        return list;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(String id) {
        //查询是否是拟件状态
        PatrolPlan patrolPlan = patrolPlanMapper.selectByPrimaryKey(id);
        if (patrolPlan == null) {
            throw new RuntimeException("未找到计划");
        }
        if (!patrolPlan.getfState().equals(0)) {
            throw new RuntimeException("非拟件状态任务不可删除");
        }
        //删除挂接的用户关系
        patrolPlanAreaMapper.deleteByPlanId(id);
        //删除挂接的计划内容
        patrolPlanContentMapper.deleteByPlanId(id);
        //删除计划自身
        patrolPlanMapper.deleteByPrimaryKey(id);
        //删除计划范围
        List<String> sourceids = patrolPlanScopeServiceMapper.findByPlanId(id).stream().map(r -> r.getfScopeid()).collect(Collectors.toList());
        if(!sourceids.isEmpty()) {
            patrolPlanScopeMapper.deleteByIds(sourceids);
        }
        patrolPlanScopeServiceMapper.deleteByPlanId(id);
        //同步巡查计划和范围
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group","patrol");
        jsonObject.put("type","delete");
        jsonObject.put("operUserId","101");
        jsonObject.put("planId",id);
        //异步调用
        threadPoolTaskExecutor.execute(() -> {
            try {
                innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void assignPlan(String id) {
        PatrolPlan patrolPlan = patrolPlanMapper.selectByPrimaryKey(id);
        if(patrolPlan==null){
            throw new RuntimeException("未找到计划");
        }
        if(patrolPlan.getfState().equals(1)){
            throw new RuntimeException("不可重复下发");
        }
        //状态改为下发
        patrolPlan.setfState(1);
        patrolPlanMapper.updateByPrimaryKey(patrolPlan);
        //todo 生成任务信息
        //判断计划频率
        if (patrolPlan.getfStarttime() != null && patrolPlan.getfEndtime() != null) {
            Date startDate = patrolPlan.getfStarttime();
            Date endDate = patrolPlan.getfEndtime();
            int count = 0;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            List<PatrolPlanTask> patrolPlanTasks = new ArrayList<>();
            String name = "第%s次巡查（"+patrolPlan.getfName()+"）";
            SimpleDateFormat sf = null;
            String tempName = "";
            Date tempStart = null;
            Date tempEnd = null;
            Date now = new Date();
            if(patrolPlan.getfRate().equals("1")){
                //日
                count = DateUtils.getDayCount(endDate,startDate);
            }else if(patrolPlan.getfRate().equals("2")){
                //周
                count = DateUtils.getWeekCount(endDate,startDate);
            }else if(patrolPlan.getfRate().equals("3")){
                //月
                count = DateUtils.getMonthCount(endDate,startDate);
            }else if(patrolPlan.getfRate().equals("4")){
                //年
                count = DateUtils.getYearCount(endDate,startDate);
            }
            if(count>366){
                throw new RuntimeException("任务数量过多");
            }
            for (int i = 0; i < count; i++) {
                tempName = String.format(name,i+1);
                if(patrolPlan.getfRate().equals("1")){
                    //日
                    sf = new SimpleDateFormat("yyyy-MM-dd");
                    tempStart = calendar.getTime();
                    tempEnd = DateUtils.getEndOfDay(calendar.getTime());
                }else if(patrolPlan.getfRate().equals("2")){
                    //周
                    tempStart = DateUtils.getStartOfWeek(calendar.getTime());
                    tempEnd = DateUtils.getEndOfWeek(calendar.getTime());
                    calendar.set(Calendar.WEEK_OF_YEAR,calendar.get(Calendar.WEEK_OF_YEAR)+1);
                }else if(patrolPlan.getfRate().equals("3")){
                    calendar.setTime(DateUtils.getStartOfMonth(calendar.getTime()));
                    sf = new SimpleDateFormat("yyyy-MM");
                    tempStart = DateUtils.getStartOfMonth(calendar.getTime());
                    tempEnd = DateUtils.getEndOfMonth(calendar.getTime());
                }else if(patrolPlan.getfRate().equals("4")){
                    tempStart = DateUtils.getStartOfYear(calendar.getTime());
                    tempEnd = DateUtils.getEndOfYear(calendar.getTime());
                }
                PatrolPlanTask patrolPlanTask = new PatrolPlanTask();
                patrolPlanTask.setfCreatetime(now);
                patrolPlanTask.setfName(tempName);
                patrolPlanTask.setfId(UUID.randomUUID().toString());
                patrolPlanTask.setfStarttime(tempStart);
                patrolPlanTask.setfEndtime(tempEnd);
                patrolPlanTask.setfPlanid(id);
                updateState(patrolPlanTask,tempStart,tempEnd,now);
                patrolPlanTasks.add(patrolPlanTask);
                calendar.setTime(tempEnd);
                calendar.set(Calendar.SECOND,calendar.get(Calendar.SECOND)+1);
                calendar.setTime(calendar.getTime());
            }
            if(!patrolPlanTasks.isEmpty()){
                patrolPlanTaskMapper.insertList(patrolPlanTasks);

                //同步巡查计划任务
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("group","patrol");
                jsonObject.put("type","insert");
                jsonObject.put("operUserId","101");
                jsonObject.put("patrolPlan",JSONObject.parseObject(JSONObject.toJSONString(patrolPlan,SerializerFeature.WriteMapNullValue)));
                jsonObject.put("patrolPlanTask",patrolPlanTasks);
                //异步调用
                threadPoolTaskExecutor.execute(() -> {
                    try {
                        innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }else{
            throw new RuntimeException("时间信息不完整");
        }
    }
    @Override
    public boolean updateState(PatrolPlanTask patrolPlanTask,Date start,Date end,Date now){
        boolean result = false;
        //设置状态
        if(end.before(now)){
            if(patrolPlanTask.getfState()!=null){
                result = !patrolPlanTask.getfState().equals(2);
            }
            //已结束
            patrolPlanTask.setfState(2);
        }else if(end.after(now) && start.before(now)){
            if(patrolPlanTask.getfState()!=null){
                result = !patrolPlanTask.getfState().equals(1);
            }
            //执行中
            patrolPlanTask.setfState(1);
        }else if(start.after(now)){
            if(patrolPlanTask.getfState()!=null){
                result = !patrolPlanTask.getfState().equals(0);
            }
            //未开始
            patrolPlanTask.setfState(0);
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void revoke(String id) {
        PatrolPlan patrolPlan = patrolPlanMapper.selectByPrimaryKey(id);
        if(patrolPlan==null){
            throw new RuntimeException("未找到计划");
        }
        if(patrolPlan.getfState().equals(0)){
            throw new RuntimeException("未下发无需撤回");
        }
        if(patrolPlan.getfState().equals(2)){
            throw new RuntimeException("已结束无法撤回");
        }
        //查看是否存在数据
        PatrolProgram patrolProgram = patrolProgramMapper.gwSearchByPK(patrolPlan.getfRelprogram());
        if(patrolProgram != null && StringUtils.isNotBlank( patrolProgram.getfPatrolBusiness())){
            List<TskTaskBiz> tskTaskBizs  =   tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(patrolProgram.getfPatrolBusiness()));
           for(TskTaskBiz bean :tskTaskBizs ){
               TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(bean.getTableId()).orElse(null);
               //查询是否有该计划的线索信息
               String sql = "select count(1) from "+tableInfo.getfTablename()+" where f_jhid = '"+id+"'";
               Long count = jdbcTemplate.queryForObject(sql, Long.class);
               if(count>0){
                   throw new RuntimeException("已有线索无法撤回");
               }
           }
        }
        //删除计划生成的表信息
        patrolPlanTaskMapper.deleteByPlanId(id);
        patrolPlan.setfState(0);
        patrolPlanMapper.updateByPrimaryKey(patrolPlan);
        //同步撤销数据
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("group","patrol");
        jsonObject.put("type","revoke");
        jsonObject.put("operUserId","101");
        jsonObject.put("patrolPlan",patrolPlan);
        //异步调用
        threadPoolTaskExecutor.execute(() -> {
            try {
                innerProgramTransmitService.syncPatrolPlanAndTask(jsonObject);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void completePlanScopeList(JSONArray scoptArray, String planId, Long userId, List<PatrolPlanScope> scopes, List<PatrolPlanScopeService> scopeServices
            , List<PatrolPlanScopeKeyArea> scopeKeyAreas, List<PatrolPlanScopeOutService> scopeOutServices) throws ParseException {
        if(scoptArray!=null && !scoptArray.isEmpty()){
            for (int i = 0; i < scoptArray.size(); i++) {
                JSONObject object = scoptArray.getJSONObject(i);
                if (object.get("fScope") != null && object.get("fDesc") != null) {
                    //创建巡查计划范围
                    PatrolPlanScope patrolPlanScope = new PatrolPlanScope();
                    String scopeId = UUID.randomUUID().toString();
                    patrolPlanScope.setfId(scopeId);
                    patrolPlanScope.setfCreatetime(new Date());
                    patrolPlanScope.setfScope(object.getString("fScope"));
                    patrolPlanScope.setfDesc(object.getString("fDesc"));
                    patrolPlanScope.setfUserid(userId);
                    scopes.add(patrolPlanScope);
                    if(object.get("fServiceIds")==null){
                        object.put("fServiceIds","");
                    }
                    String[] serviceIds = object.getString("fServiceIds").split(",");
                    for (int j = 0; j < serviceIds.length; j++) {
                        String id = serviceIds[j];
                        //创建巡查范围对应服务记录
                        PatrolPlanScopeService patrolPlanScopeService = new PatrolPlanScopeService();
                        patrolPlanScopeService.setfId(UUID.randomUUID().toString());
                        patrolPlanScopeService.setfPlanid(planId);
                        patrolPlanScopeService.setfScopeid(scopeId);
                        patrolPlanScopeService.setfUserid(userId);
                        patrolPlanScopeService.setfServiceid(id);
                        scopeServices.add(patrolPlanScopeService);
                    }
                    if (object.get("fOutService") != null) {
                        JSONArray array = object.getJSONArray("fOutService");
                        for (int j = 0; j < array.size(); j++) {
                            JSONObject object1 = array.getJSONObject(j);
                            if(object1.get("name")!=null && object1.get("url")!=null){
                                String name = object1.getString("name");
                                String url = object1.getString("url");
                                PatrolPlanScopeOutService patrolPlanScopeOutService = new PatrolPlanScopeOutService();
                                patrolPlanScopeOutService.setfId(UUID.randomUUID().toString());
                                patrolPlanScopeOutService.setfName(name);
                                patrolPlanScopeOutService.setfPlanid(planId);
                                patrolPlanScopeOutService.setfScopeid(scopeId);
                                patrolPlanScopeOutService.setfUrl(url);
                                scopeOutServices.add(patrolPlanScopeOutService);
                            }
                        }
                    }
                    if (object.get("keyArea") != null) {
                        JSONArray array = object.getJSONArray("keyArea");
                        for (int j = 0; j < array.size(); j++) {
                            JSONObject object1 = array.getJSONObject(j);
                            String wkt = object1.getString("wkt");
                            String area = object1.getString("area");
                            if (StringUtils.isNotBlank(wkt)) {
                                Geometry geometry = WKTUtil.wktToGeom(wkt);
                                List<RegionVillage> regionVillages = regionVillageRepository.queryContains1(wkt);
                                PatrolPlanScopeKeyArea patrolPlanScopeKeyArea = new PatrolPlanScopeKeyArea();
                                patrolPlanScopeKeyArea.setfArea(area);
                                patrolPlanScopeKeyArea.setfId(UUID.randomUUID().toString());
                                patrolPlanScopeKeyArea.setfScopeid(scopeId);
                                patrolPlanScopeKeyArea.setfDkbh("ZD"+String.format("%04d",j));
                                patrolPlanScopeKeyArea.setfShape(wkt);
                                patrolPlanScopeKeyArea.setfPlanid(planId);
                                if(!regionVillages.isEmpty()){
                                    patrolPlanScopeKeyArea.setfXzqdm(regionVillages.get(0).getCode());
                                    patrolPlanScopeKeyArea.setfXzqmc(regionVillages.get(0).getName());
                                }
                                scopeKeyAreas.add(patrolPlanScopeKeyArea);
                            }
                        }
                    }

                }
            }
        }
    }

    private void savePlanContent(PatrolPlanInfo patrolPlanInfo,String planId,Long userId){
        List<PatrolPlanContent> patrolPlanContents = new ArrayList<>();
        //保存巡查内容
        JSONArray contentArray = patrolPlanInfo.getfContent();
        if (contentArray!=null && !contentArray.isEmpty()) {
            for (int i = 0; i < contentArray.size(); i++) {
                JSONObject object = contentArray.getJSONObject(i);
                String content = object.getString("fContent");
                String desc = object.getString("fDesc");
                PatrolPlanContent one = new PatrolPlanContent();
                one.setfId(UUID.randomUUID().toString());
                one.setfPlanid(planId);
                one.setfCreatetime(new Date());
                one.setfDesc(desc);
                one.setfContent(content);
                one.setfUserid(userId);
                patrolPlanContents.add(one);
            }
        }
        if(!patrolPlanContents.isEmpty()){
            patrolPlanContentMapper.insertList(patrolPlanContents);
        }
    }
}
