package com.geoway.landteam.landcloud.service.patrolclue.patrollibrary.impl;

import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.servface.patrolclue.patrollibrary.MPatrolPlanTaskService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanTaskMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanTask;
/*import com.gw.base.data.GwValidateException;*/
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class MPatrolPlanTaskServiceImpl implements MPatrolPlanTaskService {
    
    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    MTskTaskBizService tskTaskBizService;

    @Override
    public List<PatrolPlanTask> queryNotEndTask() {
        return null;
    }

    @Override
    public Map<String,Object> getMyList(String classId,Long userId, int page, int rows) throws Exception {
        if(userId==null){
            throw new RuntimeException("未找到用户id");
        }
      /*  SysConfig one = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findOne(one.getValue());
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findOne(tskTaskBiz.getTableId());*/
        List<TskTaskBiz> tskTaskBizs  =   tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(classId));
        String tableName = "";
        if(!tskTaskBizs.isEmpty()){
            TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBizs.get(0).getTableId()).orElse (null);
            tableName = tableInfo.getfTablename();
        }else{
            throw new RuntimeException("任务表不存在");
        }
        Map<String,Object> result = new HashMap<>();
        String sql = "SELECT\n" +
                "\tb.f_id,\n" +
                "\tb.f_name,\n" +
                "\tA.area,\n" +
                "\tb.f_starttime,\n" +
                "\tb.f_endtime,\n" +
                "\tA.f_name planname,\n" +
                "\tb.f_state,\n" +
                "\t( SELECT COUNT ( 1 ) FROM "+tableName+" WHERE f_xsrwid = b.f_id ) \n" +
                "FROM\n" +
                "\t(\n" +
                "\tSELECT\n" +
                "\t\tb.f_name,\n" +
                "\t\tA.f_planid,\n" +
                "\tCASE\n" +
                "\t\t\t\n" +
                "\t\t\tWHEN LENGTH ( b.f_regioncode ) = 6 THEN\n" +
                "\t\t\t( SELECT f_xzqmc FROM tb_region C WHERE C.f_xzqdm = b.f_regioncode ) \n" +
                "\t\t\tWHEN LENGTH ( b.f_regioncode ) = 9 THEN\n" +
                "\t\t\t( SELECT xzqmc FROM tb_region_town C WHERE C.xzqdm = b.f_regioncode ) \n" +
                "\t\t\tWHEN LENGTH ( b.f_regioncode ) = 12 THEN\n" +
                "\t\t\t( SELECT xzqmc FROM tb_region_village C WHERE C.xzqdm = b.f_regioncode ) \n" +
                "\t\tEND AS area \n" +
                "\tFROM\n" +
                "\t\ttb_patrol_plan_area A,\n" +
                "\t\ttb_patrol_plan b \n" +
                "\tWHERE\n" +
                "\t\tA.f_userid = '"+userId+"' \n" +
                "\t\tAND A.f_planid = b.f_id \n" +
                "\tGROUP BY\n" +
                "\t\tA.f_planid,\n" +
                "\t\tb.f_name,\n" +
                "\t\tb.f_regioncode \n" +
                "\t) A,\n" +
                "\ttb_patrol_plan_task b \n" +
                "WHERE\n" +
                "\tb.f_planid = A.f_planid limit "+ rows +" offset "+ (page-1)*rows;

        String countSql = "SELECT\n" +
                "\tcount(1)\n" +
                "FROM\n" +
                "\t(\n" +
                "\tSELECT\n" +
                "\t\tb.f_name,\n" +
                "\t\tA.f_planid,\n" +
                "\tCASE\n" +
                "\t\t\t\n" +
                "\t\t\tWHEN LENGTH ( b.f_regioncode ) = 6 THEN\n" +
                "\t\t\t( SELECT f_xzqmc FROM tb_region C WHERE C.f_xzqdm = b.f_regioncode ) \n" +
                "\t\t\tWHEN LENGTH ( b.f_regioncode ) = 9 THEN\n" +
                "\t\t\t( SELECT xzqmc FROM tb_region_town C WHERE C.xzqdm = b.f_regioncode ) \n" +
                "\t\t\tWHEN LENGTH ( b.f_regioncode ) = 12 THEN\n" +
                "\t\t\t( SELECT xzqmc FROM tb_region_village C WHERE C.xzqdm = b.f_regioncode ) \n" +
                "\t\tEND AS area \n" +
                "\tFROM\n" +
                "\t\ttb_patrol_plan_area A,\n" +
                "\t\ttb_patrol_plan b \n" +
                "\tWHERE\n" +
                "\t\tA.f_userid = '"+userId+"' \n" +
                "\t\tAND A.f_planid = b.f_id \n" +
                "\tGROUP BY\n" +
                "\t\tA.f_planid,\n" +
                "\t\tb.f_name,\n" +
                "\t\tb.f_regioncode \n" +
                "\t) A,\n" +
                "\ttb_patrol_plan_task b \n" +
                "WHERE\n" +
                "\tb.f_planid = A.f_planid";
        List<Map<String, Object>> list = jdbcTemplate.queryForList(sql);
        List<PatrolPlanTask> patrolPlanTasks = new ArrayList<>();
        for (Map<String, Object> map : list) {
            PatrolPlanTask patrolPlanTask = new PatrolPlanTask();
            patrolPlanTask.setfId(map.get("f_id").toString());
            patrolPlanTask.setfName(map.get("f_name").toString());
            patrolPlanTask.setfPatrolArea(map.get("area")!=null?map.get("area").toString():null);
            patrolPlanTask.setfStarttime(map.get("f_starttime")!=null?(Date)map.get("f_starttime"):null);
            patrolPlanTask.setfEndtime(map.get("f_endtime")!=null?(Date)map.get("f_endtime"):null);
            patrolPlanTask.setfPatrolPlanName(map.get("planname")!=null?map.get("planname").toString():null);
            patrolPlanTask.setfState(map.get("f_state")!=null?Integer.valueOf(map.get("f_state").toString()):null);
            patrolPlanTask.setfPatrolClueCount(map.get("count")!=null?Long.valueOf(map.get("count").toString()):null);
            patrolPlanTasks.add(patrolPlanTask);
        }
        Long count = jdbcTemplate.queryForObject(countSql, Long.class);
        result.put("list",patrolPlanTasks);
        result.put("count",count);
        return result;
    }
}
