package com.geoway.landteam.landcloud.service.patrolclue.pub.impl;


import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueFieldsService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.geoway.landteam.patrolclue.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.patrolclue.service.pub.impl.DataDownloadFieldService;
import com.geoway.landteam.patrolclue.service.pub.impl.JcClueDownloadService;
import com.geoway.landteam.patrolclue.service.pub.impl.JcClueDownloadServiceImpl;
import com.geoway.landteam.patrolclue.service.util.UuidUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.io.File;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @Author: zkn
 * @Date: 2020/3/27 18:41
 * @Description: 日常任务下载Geometry数据服务类
 */
public abstract class MDownloadGeometryDailyClueBaseService extends JcClueDownloadService {

    private final GiLoger logger = GwLoger.getLoger(JcClueDownloadServiceImpl.class);
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    JcClueSourceService jcClueSourceService;
    @Autowired
    JcClueFieldsService jcClueFieldsService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    DataBizMapper dataBizMapper;
    private static final String TASK_CODE_DAILY_CLUE = "线索批次";
    protected String uploadDir = "d:/data/upload";
    String taskId = "";
    String taskCode = "";
    String taskName = "";
    String prjNum = "";

    List<Map> getSourceData(JcClueSource jcClueSource, List<String> queryFieldNames) {
        if (dataDownloadRecordService.checkIsUserCanceled(downloadRecord)) {
            return null;
        }
        String whereClause = "";
        String tableName = "";
        if (com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(downloadParameter.getTbIds())) {
            whereClause += "d.f_id in ( '" + downloadParameter.getTbIds().replace(",", "','") + "' )";
        }
        tableName = jcClueSource.getfTablename() + " d ";

        return this.queryAllData(tableName, queryFieldNames, whereClause);
    }

    /**
     * 根据表名称查询所有字段
     *
     * @param tableName 表名称
     * @return
     */
    public List<Map> queryAllData(String tableName, List<String> fieldNameList, String where) {
        List<Map> list = dataBizMapper.queryAllData(tableName, fieldNameList, where);
        return list;
    }
    /**
     * 初始化参数
     *
     * @param taskId
     * @param taskCode
     * @param taskName
     * @param prjNum
     */
    private void initParameter(String taskId, String taskCode, String taskName, String prjNum) {
        GutilAssert.notNull(taskId, "taskId can not be null");
        GutilAssert.notNull(taskCode, "taskCode can not be null");
        GutilAssert.notNull(taskName, "taskName can not be null");
        GutilAssert.notNull(downloadRecord, "downloadRecord can not be null");
        logger.info("日常任务下载 初始化下载参数 taskId:" + taskId + "  taskCode:" + taskCode + "   taskName:" + taskName + "   prjNmu:" + prjNum);
        logger.info("日常任务下载 初始化下载参数 downloadRecord:" + downloadRecord.toString());
        this.taskId = taskId;
        this.taskCode = taskCode;
        this.taskName = taskName;
        this.prjNum = prjNum;

        resultUrl = "";
    }


    @Override
    public void doDownloadClue() throws Exception {

        logger.info(getDescription() + " 图斑数据下载开始处理...");
        JcClueImportRecord jcClueImportRecord = null;
        JcClueSource jcClueSource = null;
        List<JcClueFields> sourceFields = null;
        // 需要导出的字段
        List<JcClueFields> exportFields = new ArrayList<>();
        List<String> queryFieldNames = new ArrayList<String>();

        try {
           boolean b = dataDownloadRecordService.checkIsUserCanceled(downloadRecord);
            if (b) {
                return;
            }
            logger.info(getDescription() + " 开始查询任务f_shape字段数据");
            jcClueImportRecord = jcClueImportRecordService.selectByPrimaryKey(downloadParameter.getTaskId());
            if (jcClueImportRecord != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(jcClueImportRecord.getfSourceid())) {
                jcClueSource = jcClueSourceService.findOne(jcClueImportRecord.getfSourceid());
            }
            if (jcClueSource != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                sourceFields = jcClueFieldsService.findByTableId(jcClueSource.getfId());
            }
            if (sourceFields != null && sourceFields.size() > 0) {
                for (JcClueFields field : sourceFields) {
                    if ("f_shape1".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_b".equalsIgnoreCase(field.getfFieldname())
                            || "f_shape_g".equalsIgnoreCase(field.getfFieldname())) {
                        continue;
                    }
                    if (field.getfFieldname().equalsIgnoreCase("f_shape")) {
                        if (isQueryGeoFields()) {
                            queryFieldNames.add("d." + field.getfFieldname());
                        }
                    } else {
                        queryFieldNames.add("d." + field.getfFieldname());
                    }
                }
                exportFields = DataDownloadFieldService.getExportFields(sourceFields);
            }
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            // 临时数据存放文件夹
            String tempFolderPath = new StringBuilder().append(uploadDir).append(File.separator).append(UuidUtil.get16UUID()).toString();
            FileUtil.creatDirectoryIfNotExist(tempFolderPath);
            String safeFileName = "";
            List<Map> sourceData = getSourceData(jcClueSource, queryFieldNames);
            if (sourceData != null) {
                if (sourceData.size() == 1) {
                    if (sourceData.get(0).get("f_tbmc") != null && com.geoway.landteam.landcloud.common.util.base.StringUtils.isNotBlank(sourceData.get(0).get("f_tbmc").toString())) {
                        safeFileName = new StringBuilder().append(jcClueImportRecord.getfName()).append("(").append(sourceData.get(0).get("f_tbmc").toString()).append(UuidUtil.get16UUID()).append("）").toString();
                    } else {
                        safeFileName = new StringBuilder().append(jcClueImportRecord.getfName()).append("(").append(UuidUtil.get16UUID()).append("）").toString();
                    }
                } else {
                    safeFileName = new StringBuilder().append(jcClueImportRecord.getfName()).append("(").append(sourceData.size()).append("个)").append(UuidUtil.get16UUID()).toString();
                }

                String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
                initParameter(jcClueImportRecord.getfId(), TASK_CODE_DAILY_CLUE, jcClueImportRecord.getfName(), "");
                downloadRecord.setName(jcClueImportRecord.getfName() + "(下载" + getDataType() + ")");
                exportAction(sourceData, tempFolderPath, exportFields);
                afterExport(tempFolderPath, safeFileName, fileNameNoSuffix);
            }
        } catch (Exception e) {
            handleException(e);
        }
    }


    List<String> getPropertyKeys(List<JcClueFields> exportFields) {
        List<String> propertyKeys = new ArrayList<>();
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (StringUtils.isNotBlank(field.getfFieldname())) {
                    propertyKeys.add(field.getfFieldname().replace("f_", "").trim());
                }
            }
        }
        return propertyKeys;
    }


    Map<String, Object> getPropertyMap(Map map, List<JcClueFields> exportFields) {
        Map<String, Object> resultMap = new HashMap<>();
        if (map == null) {
            return resultMap;
        }

        String userName = "";
        String createtime = "";
        resultMap.put("taskId", taskId);
        resultMap.put("taskCode", taskCode);
        resultMap.put("taskName", taskName);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp ts = null;
        DecimalFormat decimalFormat = new DecimalFormat("#.#######");

        String columnNmae = "";
        String tempValue = "";
        if (exportFields != null && exportFields.size() > 0) {
            for (JcClueFields field : exportFields) {
                if (StringUtils.isBlank(field.getfFieldtype())) {
                    continue;
                }
                if ("taskId".equalsIgnoreCase(field.getfFieldname())
                        || "taskCode".equalsIgnoreCase(field.getfFieldname())
                        || "taskName".equalsIgnoreCase(field.getfFieldname())
                        || "f_shape".equalsIgnoreCase(field.getfFieldname())) {
                    continue;
                }
                columnNmae = "f_" + field.getfFieldname();

                if ("f_userid".equalsIgnoreCase(columnNmae)) {
                    if (map.containsKey("f_userid") && map.get("f_userid") != null) {
                        // 将用户id转换成用户真实姓名
                        userName = userNameService.getUserRealNameByUserId(map.get("f_userid").toString());
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), userName);
                    }
                } else if ("f_createtime".equalsIgnoreCase(columnNmae)
                        || "f_committime".equalsIgnoreCase(columnNmae)) {
                    try {
                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                            ts = new Timestamp(Long.valueOf(map.get(columnNmae).toString()));
                            createtime = format.format(ts);
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), createtime);
                        }
                    } catch (Exception e) {
                        if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae).toString());
                        }
                    }
                } else if ("f_lon".equalsIgnoreCase(columnNmae)
                        || "f_lat".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), decimalFormat.format(Double.parseDouble(map.get(columnNmae).toString())));
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_sfydjzl".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "有");
                        } else if ("2".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "无");
                        } else {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_bz".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译标注
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "已登记，影像无房";
                                break;
                            case "2":
                                translatedValue = "已登记，登记附图需矢量化";
                                break;
                            case "3":
                                translatedValue = "已登记，登记附图有矢量图形";
                                break;
                            case "4":
                                translatedValue = "已登记，登记附图需矢量化，现已扩建";
                                break;
                            case "5":
                                translatedValue = "已登记，登记附图有矢量图形，现已扩建";
                                break;
                            case "6":
                                translatedValue = "已登记，登记附图需矢量化，现状无房屋";
                                break;
                            case "7":
                                translatedValue = "已登记，登记附图有矢量图形，现状无房屋";
                                break;
                            case "8":
                                translatedValue = "已登记，现状图形与登记面积一致";
                                break;
                            case "9":
                                translatedValue = "已登记，现状图形与登记面积不一致";
                                break;
                            case "10":
                                translatedValue = "未登记，现状图形";
                                break;
                            case "11":
                                translatedValue = "其他";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_tdyt".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译土地用途
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "农村宅基地";
                                break;
                            case "2":
                                translatedValue = "公共设施农用地";
                                break;
                            case "3":
                                translatedValue = "医卫慈善用地";
                                break;
                            case "4":
                                translatedValue = "科教用地";
                                break;
                            case "5":
                                translatedValue = "其他";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_qlrlx".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    // 翻译权利人类型
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        String translatedValue = "";
                        switch (tempValue) {
                            case "1":
                                translatedValue = "个人";
                                break;
                            case "2":
                                translatedValue = "单位";
                                break;
                            default:
                                translatedValue = tempValue;
                                break;
                        }
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), translatedValue);
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_ismycreate".equalsIgnoreCase(columnNmae) && map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                    try {
                        tempValue = map.get(columnNmae).toString().trim();
                        if ("1".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "是");
                        } else if ("0".equalsIgnoreCase(tempValue)) {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), "否");
                        } else {
                            resultMap.put(field.getfFieldname().replace("f_", "").trim(), tempValue);
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else if ("f_qlrqm".equalsIgnoreCase(columnNmae)
                        || "f_dcrqm".equalsIgnoreCase(columnNmae)
                        || "f_sign".equalsIgnoreCase(columnNmae)
                        || "f_requestid".equalsIgnoreCase(columnNmae)) {
                    try {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                } else {
                    if (map.containsKey(columnNmae) && map.get(columnNmae) != null) {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), map.get(columnNmae));
                    } else {
                        resultMap.put(field.getfFieldname().replace("f_", "").trim(), "");
                    }
                }
            }
        }
        return resultMap;
    }

    /**
     * 获取导出目标文件的名称
     *
     * @param sourceData
     * @param folderPath
     * @return
     */
    String getExportFileName(List<Map> sourceData, String folderPath) {
        if (sourceData == null || sourceData.size() == 0 || StringUtils.isBlank(folderPath)) {
            return "";
        }
        FileUtil.creatDirectoryIfNotExist(folderPath);

        String fileName = "";
        if (sourceData.size() == 1) {
            Map map = sourceData.get(0);
            if (map != null) {
                if (map.containsKey("f_tbmc") && map.get("f_tbmc")!=null && StringUtils.isNotBlank(map.get("f_tbmc").toString())) {
                    fileName = map.get("f_tbmc").toString();
                } else if (map.containsKey("f_tbbh") && map.get("f_tbmc")!=null && StringUtils.isNotBlank(map.get("f_tbbh").toString())) {
                    fileName = map.get("f_tbbh").toString();
                } else if (map.containsKey("f_id") && StringUtils.isNotBlank(map.get("f_id").toString())) {
                    fileName = map.get("f_id").toString();
                }
            }
        } else {
            fileName = sourceData.size() + "个";
        }

        String targetFileName = new StringBuilder()
                .append(folderPath)
                .append(File.separator)
                .append(taskName)
                .append("(")
                .append(fileName)
                .append(")")
                .append(getFileExtension())
                .toString();
        File file = new File(targetFileName);
        if (!file.exists()) {
//            try {
//                file.createNewFile();
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
        }
        return targetFileName;
    }

    @Override
    protected String getObsFolderPath() {
        return "dailyTask/download" + "/" + getDataType();
    }

    abstract void exportAction(List<Map> sourceData, String tempSavePath, List<JcClueFields> exportFields) throws Exception;

    String getName(Map map) {
        if (map == null) {
            return "";
        }
        String result = "";
        if (map.containsKey("f_tbmc") && StringUtils.isNotBlank(map.get("f_tbmc").toString())) {
            result = map.get("f_tbmc").toString();
        } else if (map.containsKey("f_tbbh") && StringUtils.isNotBlank(map.get("f_tbbh").toString())) {
            result = map.get("f_tbbh").toString();
        } else if (map.containsKey("f_id") && StringUtils.isNotBlank(map.get("f_id").toString())) {
            result = map.get("f_id").toString();
        }
        return result;
    }

    abstract boolean isQueryGeoFields();
}
