package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.SQLInjectionUtil;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.pub.entity.TbBusinessStatistics;
import com.geoway.landteam.landcloud.model.statistics.entity.TbZhddZdzbtj;
import com.geoway.landteam.landcloud.model.zhdd.dto.QuotaDataDto;
import com.geoway.landteam.landcloud.repository.pub.TbBusinessStatisticsRepository;
import com.geoway.landteam.landcloud.repository.pub.TbZhddZdzbtjRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskTaskClassService;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueSourceMapper;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.pub
 * @date 2023/7/18 9:50
 */
@Service
public class BusinessStatisticsService {

    private final GiLoger logger = GwLoger.getLoger(BusinessStatisticsService.class);

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    JcClueSourceMapper jcClueSourceMapper;
    @Autowired
    TbBusinessStatisticsRepository tbBusinessStatisticsRepository;
    @Autowired
    MTbtskTaskClassService mTbtskTaskClassService;
    @Autowired
    TbZhddZdzbtjRepository tbZhddZdzbtjRepository;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TskTaskBizService tskTaskBizService;

    /**
     * 总览地图按行政区统计73,75,76类数据
     * @return
     */
    public List<Map<String, Object>> statisticsOverviewByRegion(){
        String sql = "select f_xzqdm,f_xzqmc,f_centerx,f_centery from tb_region where f_pcode = '130000'";
        List<Map<String, Object>> listRegions = jdbcTemplate.queryForList(sql);
        Map<String,Map<String, Object>> maps = new HashMap<>();
        if(listRegions!=null&& !listRegions.isEmpty()){
            for(Map<String, Object> temp : listRegions){
                Map<String,QuotaDataDto> totalMap = new HashMap<>();
                QuotaDataDto quotaDataDto = new QuotaDataDto();
                quotaDataDto.setCode("73");
                quotaDataDto.setName("土地卫片执法");
                quotaDataDto.setCount(new BigDecimal(0));
                totalMap.put("73",quotaDataDto);
                QuotaDataDto quotaDataDto1 = new QuotaDataDto();
                quotaDataDto1.setCode("75");
                quotaDataDto1.setName("耕地占补平衡");
                quotaDataDto1.setCount(new BigDecimal(0));
                totalMap.put("75",quotaDataDto1);
                QuotaDataDto quotaDataDto2 = new QuotaDataDto();
                quotaDataDto2.setCode("76");
                quotaDataDto2.setName("农村新建住房调查");
                quotaDataDto2.setCount(new BigDecimal(0));
                totalMap.put("76",quotaDataDto2);
                temp.put("data",totalMap);
                maps.put(temp.get("f_xzqdm").toString(),temp);
            }
            String sql2 = "WITH RECURSIVE class_hierarchy AS (\n" +
                    "    SELECT c.f_id, c.f_parentid, c.f_id AS root_id\n" +
                    "    FROM tbtsk_task_class c\n" +
                    "    WHERE c.f_id IN (73,75,76) \n" +
                    "    UNION ALL\n" +
                    "    SELECT c.f_id, c.f_parentid, ch.root_id\n" +
                    "    FROM tbtsk_task_class c\n" +
                    "    INNER JOIN class_hierarchy ch ON ch.f_id = c.f_parentid\n" +
                    ")\n" +
                    "SELECT \n" +
                    "    ch.root_id AS f_id,\n" +
                    "    b.city,\n" +
                    "    tcn.f_name,\n" +
                    "    SUM(b.f_tbcount) AS total_count\n" +
                    "FROM class_hierarchy ch\n" +
                    "LEFT JOIN \n" +
                    "(select left(s.f_xzqdm,4)||'00' as city,s.f_tbcount, CAST(s.f_classid AS INTEGER) as id from tbtsk_task_statis s) b ON b.id = ch.f_id \n" +
                    "LEFT JOIN tbtsk_task_class tcn ON ch.root_id = tcn.f_id\n" +
                    "GROUP BY b.city,ch.root_id, tcn.f_name\n" +
                    "ORDER BY total_count desc";
            List<Map<String, Object>> listCount = jdbcTemplate.queryForList(sql2);
            if(listCount!=null&& !listCount.isEmpty()){
                for(Map<String, Object> temp : listCount){
                    String cityCode = String.valueOf(temp.get("city"));
                    if(maps.containsKey(cityCode)){
                        Map<String, Object> regionData = maps.get(cityCode);
                        String classId = String.valueOf(temp.get("f_id"));
                        Map<String,QuotaDataDto> data = (Map<String,QuotaDataDto>)regionData.get("data");
                         if(data.containsKey(classId)){
                             QuotaDataDto quotaDataDto =  data.get(classId);
                             BigDecimal count = (BigDecimal) temp.get("total_count");
                             quotaDataDto.setCount(count);
                         }
                    }
                }
            }
        }
        return listRegions;
    }

    /**
     * 线索库  获取当天数据
     * @return
     */
    public JSONObject getClueStatisticalByDay(String appsId){
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,appsId);
        //获取全部数据
        JSONObject object = new JSONObject();
        Integer handleNum = 0;
        Integer untreatedNum = 0;
        Calendar cal = Calendar.getInstance();
        for(JcClueSource jcClueSource : list){
            if(jcClueSource.getfTablename() != null) {
                //获取当天
                String  startOfDay = getStartOfDay(null);
                String  endOfDay = getEndOfDay(null);
                String monthsql = "select f_status,count(1) from "+jcClueSource.getfTablename()+" where f_createtime " +
                        "between '"+ converTime(startOfDay) +"' and '" + converTime(endOfDay) +"' group by f_status";
                List<Map<String, Object>> map2s = jdbcTemplate.queryForList(monthsql);
                for(Map<String, Object> map1 :map2s){
                    //status 0 未处理  1 已处理
                    if(map1.get("f_status") != null && map1.get("f_status").toString().equals("0")){
                        untreatedNum += Integer.valueOf(map1.get("count").toString());
                    }else{
                        handleNum += Integer.valueOf(map1.get("count").toString());
                    }
                }
            }
        }
        //汇总数据
        object.put("handleNum",handleNum);
        object.put("untreatedNum",untreatedNum);
        object.put("totalNum",handleNum + untreatedNum);
        object.put("name","总计");
        return object;
    }


    /**
     * 获取用户任务总量
     * @param userId
     * @param appsId
     * @return
     */
    public Map<String, Object> getTaskAllCount(Long userId,String appsId){
        Map<String, Object> resultMap = new HashMap<>();
         resultMap.put("taskAllCount",0);
        String sql= "select count(1) from tbtsk_task_class ttc inner join tbtsk_task_biz ttb on (ttc.f_id = ttb.f_classid) where \n" +
                " ttb.f_isdel is null and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW') ";
        if(StringUtils.isNotBlank(appsId)){
            sql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
        resultMap.put("taskAllCount",count);
        return resultMap;

    }

    /**
     * 获取当日图斑新增量
     * @param userId
     * @param appsId
     * @return
     */
    public Map<String, Object> getTaskCountByDay(Long userId,String appsId){
        Map<String, Object> resultMap = new HashMap<>();
        int taskTBAllCount = 0;
        int taskTBCountDay = 0;
        String sql= "select\n" +
                " ttc.f_id ,ttc.f_name ,ttb.f_id ,to2.f_tablename \n" +
                "from\n" +
                " tbtsk_task_class ttc\n" +
                "inner join tbtsk_task_biz ttb on (ttc.f_id = ttb.f_classid)\n" +
                "inner join tbtsk_objectinfo to2   on (to2.f_id = ttb.f_tableid)\n" +
                "where\n" +
                " ttb.f_isdel is null\n" +
                " and (ttc.f_appkey is not null and ttc.f_appkey != 'XCYW')";
        if(StringUtils.isNotBlank(appsId)){
            sql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(sql);
        String  startOfDay = getStartOfDay(null);
        String  endOfDay = getEndOfDay(null);
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_tablename") != null ) {
                String f_tablename = map1.get("f_tablename").toString();
                String allcount = " select count(1) from " + f_tablename;
                String daycount = "select count(1) from "+f_tablename+" where f_createtime between '"+ converTime(startOfDay) +"' and '" + converTime(endOfDay) +"'";
                taskTBAllCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                taskTBCountDay += jdbcTemplate.queryForObject(daycount, Integer.class);
              }
            }
        resultMap.put("taskTBAllCount",taskTBAllCount);
        resultMap.put("taskTBCountDay",taskTBCountDay);
        return resultMap;
    }


    /**
     * 调查任务图斑数据根据业务大类区分
     * @param userId
     * @param appsId
     * @return
     */

    public List<Map<String, Object>> getTaskTBCountByClass(Long userId,String appsId){
        List<Map<String, Object>>  resultMap = new ArrayList<>();

        String taskClassSql = "select f_id ,f_name  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if(StringUtils.isNotBlank(appsId)){
            taskClassSql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(taskClassSql);
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                Map<String, Object> map = new HashMap<>();
                String classId = map1.get("f_id").toString();
                String className = map1.get("f_name").toString();
                List<Long> classIds = new ArrayList<>();
                classIds.add(Long.valueOf(classId));
                int taskTBCount = 0;
                    map.put("classId",classId);
                    map.put("className",className);
                    map.put("taskTBCount",taskTBCount);
                mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);

                String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";
             /*   String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid ='"+classId+"'";*/

                List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
                for(Map<String, Object> map2 :taskMap){
                    if(map2.get("f_tablename") != null ) {
                        String f_tablename = map2.get("f_tablename").toString();
                        if(StringUtils.isNotBlank(f_tablename)){
                            String allcount = " select count(1) from " + f_tablename;
                            taskTBCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                        }
                    }
                }
                map.put("taskTBCount",taskTBCount);
                resultMap.add(map);
            }
        }
        List<Map<String, Object>> list = resultMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("taskTBCount"), (Integer) e2.get("taskTBCount"));
        }).collect(Collectors.toList());
        return list;

    }


    /**
     * 获取用户总量及当周用户新增量
     * @return
     */
    public Map<String, Object> getUserCountByCurrenWeek(){
        Map<String, Object> resultMap = new HashMap<>();
        int userAllCount = 0;
        int userCurrenWeekCount = 0;
        String userSql= " select count(1) from tbsys_user tu";
        Integer userCount = jdbcTemplate.queryForObject(userSql, Integer.class);
        userAllCount = userCount;
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        String sql = "select count(1) from tbsys_user tu where f_create_date  between  '"+startOfWeek+"' and '"+endOfWeek+"'";
        Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
        userCurrenWeekCount = count;
        resultMap.put("userAllCount",userAllCount);
        resultMap.put("userCurrenWeekCount",userCurrenWeekCount);
        return resultMap;
    }




    /**
     * 获取用户单位类别及本周新增量
     * @return
     */
    public List<Map<String, Object>> getUserorganizationCountByCurrenWeek(){
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        String userorganizationSql= " select f_type,count(1) from uis_organization uo , uis_userorganization uu, tbsys_user tu where uo.f_id  = uu.f_organizationid  and uu.f_userid  = tu.f_userid  group by f_type";
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(userorganizationSql);
        for(Map<String, Object> map :maps){
            map.put("userOrganizationWeekCount",0);
            if(map.get("f_type") != null ) {
                String f_type = map.get("f_type").toString();
                if(StringUtils.isNotBlank(f_type)){
                    String weekCount = " select count(1) from uis_organization uo , uis_userorganization uu, " +
                            "tbsys_user tu where uo.f_id  = uu.f_organizationid  and uu.f_userid  = tu.f_userid and " +
                            "uo.f_type='"+f_type+"' and tu.f_create_date  between  '"+startOfWeek+"' and '"+endOfWeek+"' " ;
                    Integer count = jdbcTemplate.queryForObject(weekCount, Integer.class);
                    map.put("userOrganizationWeekCount",count);
                }
            }
        }
        return maps;
    }

    /**
     * 获取业务大类用户总量及本周新增量
     * @return
     */
    public Map<String, Object> getUserTaskClass(){
        Map<String, Object> resultMap = new HashMap<>();
        String XCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where f_appkey  ='XCYW' and " +
                "f_parentid  ='-1'";
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(XCYWSql);
        resultMap.put("XCYWTaskClassmap",handlyMap(taskClassmap));

        String HCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where  f_parentid  ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        List<Map<String, Object>> taskClassmap1 = jdbcTemplate.queryForList(HCYWSql);
        resultMap.put("HCYWTaskClassmap",handlyMap(taskClassmap1));
        return resultMap;
    }


    public List<Map<String, Object>> handlyMap(List<Map<String, Object>> taskClassmap ){
        //获取全部数据
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                String classId = map1.get("f_id").toString();
                List<Long> classIds = new ArrayList<>();
                classIds.add(Long.valueOf(classId));
                mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);
                String userClassCountsql = " select count(1) from tbtsk_user_task_class tutc  where f_classid in ("+
                        GutilStr.join(classIds,",")+")";
                String currenUserClassCountsql = " select count(1) from tbtsk_user_task_class tutc  where tutc" +
                        ".f_classid in ("+ GutilStr.join(classIds,",")+") and  tutc.f_createdate  between  '"+startOfWeek+"' and '"+endOfWeek+"' " ;
                Integer userClassCount = jdbcTemplate.queryForObject(userClassCountsql, Integer.class);
                Integer weekUserClassCount = jdbcTemplate.queryForObject(currenUserClassCountsql, Integer.class);
                map1.put("userClassCount",userClassCount);
                map1.put("weekUserClassCount",weekUserClassCount);
            }
        }
        List<Map<String, Object>> list = taskClassmap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("userClassCount"), (Integer) e2.get("userClassCount"));
        }).collect(Collectors.toList());
        return list;
    }

    public List<Map<String, Object>> handlyTaskClassMap(List<Map<String, Object>> taskClassmap ){
        //按月
        Calendar cal = Calendar.getInstance();
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);

        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                String classId = map1.get("f_id").toString();
                List<Long> classIds = new ArrayList<>();
                classIds.add(Long.valueOf(classId));
                //获取业务大类下所有分组
                mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);
                //获取业务大类下所有任务数量
                String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";
                List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
                map1.put("taskCount",taskMap.size());
                //获取业务大类下本周新增任务数量
                String taskWeekSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in ("+ GutilStr.join(classIds,",")+") and ttb.f_createtime  between '"+monthstart+"' and '"+monthend+"' " ;
                List<Map<String, Object>> taskWeekMap = jdbcTemplate.queryForList(taskWeekSql);
                map1.put("taskMonthCount",taskWeekMap.size());
                int taskTBAllCount = 0;
                int taskTBMonthCount = 0;
                int taskMedTpNum = 0;
                int taskMedSpNum = 0;
                for(Map<String, Object> map2 :taskMap){
                    if(map2.get("f_tablename") != null ) {
                        String f_tablename = map2.get("f_tablename").toString();
                        String f_id = map2.get("f_id").toString();
                        //获取图斑数量及本周新增
                        if(StringUtils.isNotBlank(f_tablename)){
                            String allcount = " select count(1) from " + f_tablename;
                            String weekCount = " select count(1) from " + f_tablename +" where f_createtime  between '"+ converTime(monthstart) +"' and '" + converTime(monthend) +"'";
                            taskTBAllCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                            taskTBMonthCount += jdbcTemplate.queryForObject(weekCount, Integer.class);
                        }
                        //获取任务照片及视频数据
                        //附件数量 1 图片 2 视频
                        String medCount = " select f_type,count(1) from tb_app_media tam  where f_bizid  ='"+f_id+"' group by f_type having f_type in (1,2); ";
                        List<Map<String, Object>> medCountmap = jdbcTemplate.queryForList(medCount);
                        if(medCountmap.size() > 0 ){
                            for(Map<String, Object> medmap :medCountmap){
                                // 1 图片 2 视频
                                if(medmap.get("f_type") != null && medmap.get("f_type").toString().equals("1")){
                                    taskMedTpNum += Integer.valueOf(medmap.get("count").toString());
                                }else{
                                    taskMedSpNum += Integer.valueOf(medmap.get("count").toString());
                                }
                            }
                        }
                    }
                }
                map1.put("taskTBAllCount",taskTBAllCount);
                map1.put("taskTBWeekCount",taskTBMonthCount);
                map1.put("taskMedTpNum",taskMedTpNum);
                map1.put("taskMedSpNum",taskMedSpNum);
            }
        }
        List<Map<String, Object>> list = taskClassmap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("taskCount"), (Integer) e2.get("taskCount"));
        }).collect(Collectors.toList());
        return list;
    }

    /**
     * 获取线索数据总量及当周新增量
     * @return
     */
    public Map<String, Object> getClueCountByCurrenWeek() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer clueAllCount = 0;
        Integer clueWeekCount = 0;
        //获取全部数据
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);

        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String countsql = "select count(1) from " + s ;
                    String weekCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(startOfWeek) +"' and '" + converTime(endOfWeek) +"'";
                    Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                    Integer weekCount = jdbcTemplate.queryForObject(weekCountsql, Integer.class);
                    clueAllCount += count;
                    clueWeekCount += weekCount;
                }
            }
        }
        resultMap.put("clueAllCount",clueAllCount);
        resultMap.put("clueWeekCount",clueWeekCount);
        return resultMap;
    }

    /**
     * 获取线索数据总量及按年度、季度、月度统计
     * @return
     */
    public Map<String, Object> getClueCountByDate() {
        Map<String, Object> resultMap = new HashMap<>();
        Calendar cal = Calendar.getInstance();
        //获取全部数据
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //季度开始和结束时间
        String  quarterStartTime = getCurrentQuarterStartTime();
        String  quarterEndTime = getCurrentQuarterEndTime();
        //按月开始和结束时间
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);

        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);

        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String countsql = "select count(1) from " + s ;
                    String yearCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(yearstart) +"' and '" + converTime(yearend) +"'";
                    String quarterCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(quarterStartTime) +"' and '" + converTime(quarterEndTime) +"'";
                    String monthCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(monthstart) +"' and '" + converTime(monthend) +"'";
                    Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                    Integer yearCount = jdbcTemplate.queryForObject(yearCountsql, Integer.class);
                    Integer quarterCount = jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
                    Integer monthCount = jdbcTemplate.queryForObject(monthCountsql, Integer.class);
                    clueAllCount += count;
                    clueYearCount += yearCount;
                    clueQuarterCount += quarterCount;
                    clueMonthCount += monthCount;
                }
            }
        }
        resultMap.put("clueAllCount",clueAllCount);
        resultMap.put("clueYearCount",clueYearCount);
        resultMap.put("clueQuarterCount",clueQuarterCount);
        resultMap.put("clueMonthCount",clueMonthCount);
        return resultMap;
    }


    /**
     * 获取所有线索的面积和数量
     * @return
     */
    public Map<String, Object> getAllClueCountAndMj() {
        Map<String, Object> resultMap = new HashMap<>();
        Calendar cal = Calendar.getInstance();
        //获取全部数据
        Integer clueAllCount = 0;
        double clueAllMj = 0.0;
        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);
        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String countAndMjsql = "select count(1), sum(f_area) from " + s ;
//                    JSONObject jsonObject = jdbcTemplate.queryForObject(countAndMjsql, JSONObject.class);
                    List<Map<String, Object>> maps = jdbcTemplate.queryForList(countAndMjsql);
                    int count = 0;
                    double sum = 0.0;
                    if(maps != null && maps.size() > 0) {
                        Map<String, Object> map = maps.get(0);
                        count = map.get("count") == null ? 0 : Integer.parseInt(map.get("count").toString());
                        sum = map.get("sum") == null ? 0 : Double.parseDouble(map.get("sum").toString());
                    }
                    clueAllCount += count;
                    clueAllMj += sum;
                }
            }
        }
        resultMap.put("count",clueAllCount);
        resultMap.put("mj", new BigDecimal(clueAllMj).setScale(2, BigDecimal.ROUND_HALF_UP));
        return resultMap;
    }


    /**
     * 获取线索融合状态数据总量及按年度、季度、月度统计
     * @return
     */
    public Map<String, Object> getClueMergestatusCountByDate() {
        Map<String, Object> resultMap = new HashMap<>();
        Calendar cal = Calendar.getInstance();
        //获取全部数据
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //季度开始和结束时间
        String  quarterStartTime = getCurrentQuarterStartTime();
        String  quarterEndTime = getCurrentQuarterEndTime();
        //按月开始和结束时间
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);

        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);

        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String countsql = "select count(1) from " + s + " where f_mergestatus ='1'" ;
                    String yearCountsql = "select count(1) from "+s+" where f_mergestatus ='1' and f_createtime between '"+ converTime(yearstart) +"' and '" + converTime(yearend) +"'";
                    String quarterCountsql = "select count(1) from "+s+" where f_mergestatus ='1' and f_createtime between '"+ converTime(quarterStartTime) +"' and '" + converTime(quarterEndTime) +"'";
                    String monthCountsql = "select count(1) from "+s+" where f_mergestatus ='1' and f_createtime between '"+ converTime(monthstart) +"' and '" + converTime(monthend) +"'";
                    Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                    Integer yearCount = jdbcTemplate.queryForObject(yearCountsql, Integer.class);
                    Integer quarterCount = jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
                    Integer monthCount = jdbcTemplate.queryForObject(monthCountsql, Integer.class);
                    clueAllCount += count;
                    clueYearCount += yearCount;
                    clueQuarterCount += quarterCount;
                    clueMonthCount += monthCount;
                }
            }
        }
        resultMap.put("clueAllCount",clueAllCount);
        resultMap.put("clueYearCount",clueYearCount);
        resultMap.put("clueQuarterCount",clueQuarterCount);
        resultMap.put("clueMonthCount",clueMonthCount);
        return resultMap;
    }



    /**
     * 获取线索融合状态数据总量及按年度、季度、月度统计
     * @return
     */
    public Map<String, Object> getClueMergestatusCountAndMj() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer clueAllCount = 0;
        double clueAllMj = 0.0;
        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);
        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    try{
                        String countAndMjsql = "select count(1), sum(f_area) from " + s + " where f_mergestatus ='1'" ;
//                    JSONObject jsonObject = jdbcTemplate.queryForObject(countAndMjsql, JSONObject.class);
                        List<Map<String, Object>> maps = jdbcTemplate.queryForList(countAndMjsql);
                        int count = 0;
                        double sum = 0.0;
                        if(maps != null && maps.size() > 0) {
                            Map<String, Object> map = maps.get(0);
                            count = map.get("count") == null ? 0 : Integer.parseInt(map.get("count").toString());
                            sum = map.get("sum") == null ? 0 : Double.parseDouble(map.get("sum").toString());
                        }
                        clueAllCount += count;
                        clueAllMj += sum;
                    } catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        }
        resultMap.put("count",clueAllCount);
        resultMap.put("mj",clueAllMj);
        return resultMap;
    }



    /**
     * 推送应用线索
     * 获取推送应用线索总量及按年度、季度、月度统计
     * @return
     */
    public Map<String, Object> getTSYYClueCountByDate(String sourceId) {
        Map<String, Object> resultMap = new HashMap<>();
        Calendar cal = Calendar.getInstance();
        //获取全部数据
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //季度开始和结束时间
        String  quarterStartTime = getCurrentQuarterStartTime();
        String  quarterEndTime = getCurrentQuarterEndTime();
        //按月开始和结束时间
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);

        List<String> sourceIds = Arrays.asList(sourceId.split(","));
        List<JcClueSource> list = jcClueSourceMapper.getCuleBysourceids(sourceIds);

        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String countsql = "select count(1) from " + s ;
                    String yearCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(yearstart) +"' and '" + converTime(yearend) +"'";
                    String quarterCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(quarterStartTime) +"' and '" + converTime(quarterEndTime) +"'";
                    String monthCountsql = "select count(1) from "+s+" where f_createtime between '"+ converTime(monthstart) +"' and '" + converTime(monthend) +"'";
                    Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                    Integer yearCount = jdbcTemplate.queryForObject(yearCountsql, Integer.class);
                    Integer quarterCount = jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
                    Integer monthCount = jdbcTemplate.queryForObject(monthCountsql, Integer.class);
                    clueAllCount += count;
                    clueYearCount += yearCount;
                    clueQuarterCount += quarterCount;
                    clueMonthCount += monthCount;
                }
            }
        }
        resultMap.put("clueAllCount",clueAllCount);
        resultMap.put("clueYearCount",clueYearCount);
        resultMap.put("clueQuarterCount",clueQuarterCount);
        resultMap.put("clueMonthCount",clueMonthCount);
        return resultMap;
    }


    public Map<String, Object> getTSYYClueCountAndMj(String sourceId) {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer clueAllCount = 0;
        double clueAllMj = 0.0;
        List<String> sourceIds = Arrays.asList(sourceId.split(","));
        List<JcClueSource> list = jcClueSourceMapper.getCuleBysourceids(sourceIds);
        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    String countAndMjsql = "select count(1), sum(f_area) from " + s ;
//                    JSONObject jsonObject = jdbcTemplate.queryForObject(countAndMjsql, JSONObject.class);
                    List<Map<String, Object>> maps = jdbcTemplate.queryForList(countAndMjsql);
                    int count = 0;
                    double sum = 0.0;
                    if(maps != null && maps.size() > 0) {
                        Map<String, Object> map = maps.get(0);
                        count = map.get("count") == null ? 0 : Integer.parseInt(map.get("count").toString());
                        sum = map.get("sum") == null ? 0 : Double.parseDouble(map.get("sum").toString());
                    }
//                    int count = jsonObject.get("count") == null ? 0 : Integer.parseInt(jsonObject.get("count").toString());
//                    double sum = jsonObject.get("sum") == null ? 0 : Double.parseDouble(jsonObject.get("sum").toString());
                    clueAllCount += count;
                    clueAllMj += sum;
                }
            }
        }
        resultMap.put("count",clueAllCount);
        resultMap.put("mj",clueAllMj);
        return resultMap;
    }

    /**
     * 线索类型
     * 获取推送应用线索总量及按年度、季度、月度统计
     * @return
     */
    public Map<String, Object> getClueTypeByDate( ) {
        Map<String, Object> resultMap = new HashMap<>();
        Calendar cal = Calendar.getInstance();
        //获取全部数据
        Integer clueAllCount = 0;
        Integer clueYearCount = 0;
        Integer clueQuarterCount = 0;
        Integer clueMonthCount = 0;
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //季度开始和结束时间
        String  quarterStartTime = getCurrentQuarterStartTime();
        String  quarterEndTime = getCurrentQuarterEndTime();
        //按月开始和结束时间
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,null);
       /* String countsql = "select count(1) from  jc_clue_source where  f_level = 1 and f_state ='2'";
        String yearCountsql = "select count(1) from  jc_clue_source where  f_level = 1 and f_state ='2' and  f_createtime between '"+ yearstart +"' and '" + yearend +"'";
        String quarterCountsql = "select count(1) from  jc_clue_source where  f_level = 1 and f_state ='2' and f_createtime between '"+ quarterStartTime +"' and '" + quarterEndTime +"'";
        String monthCountsql = "select count(1) from  jc_clue_source where  f_level = 1 and f_state ='2' and f_createtime between '"+ monthstart +"' and '" + monthend +"'";
        clueAllCount = jdbcTemplate.queryForObject(countsql, Integer.class);
        clueYearCount = jdbcTemplate.queryForObject(yearCountsql, Integer.class);
        clueQuarterCount = jdbcTemplate.queryForObject(quarterCountsql, Integer.class);
        clueMonthCount = jdbcTemplate.queryForObject(monthCountsql, Integer.class);*/
        resultMap.put("clueAllCount",list.size());
        resultMap.put("clueYearCount",list.size());
        resultMap.put("clueQuarterCount",list.size());
        resultMap.put("clueMonthCount",list.size());
        return resultMap;
    }


    /**
     * 线索数据统计按照政区
     * 线索数据统计按照政区及按年度、季度、月度统计
     * @return
     */
    public  Map<String, Object> getClueXzqdmCountByDate() {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> allResultMap = new ArrayList<>();
        List<Map<String, Object>> yearResultMap = new ArrayList<>();
        List<Map<String, Object>> quarterResultMap = new ArrayList<>();
        List<Map<String, Object>> monthResultMap = new ArrayList<>();
        Calendar cal = Calendar.getInstance();
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //季度开始和结束时间
        String  quarterStartTime = getCurrentQuarterStartTime();
        String  quarterEndTime = getCurrentQuarterEndTime();
        //按月开始和结束时间
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,null);

        for(JcClueSource jcClueSource : list) {
                // 获取所有分组线索
                List<String> tableNames = new ArrayList<>();
                if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                    tableNames.add(jcClueSource.getfTablename());
                }
                completeClueChildren(jcClueSource,tableNames);
                if(tableNames.size() > 0){
                    for(String s: tableNames){
                        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_level =2)";
                        String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,4)||'00' as xzqdm,count(1) from "+s+"  ";
                        String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                        List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
                        allResultMap.addAll(Allmaps);
                        //年度
                        String yearSql = Asql+Bsql+" where f_createtime between '"+ converTime(yearstart) +"' and '"
                                + converTime(yearend)+"' group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                        List<Map<String, Object>> yearmaps = jdbcTemplate.queryForList(yearSql);
                        yearResultMap.addAll(yearmaps);
                        //季度
                        String quarterSql = Asql+Bsql+" where f_createtime between '"+ converTime(quarterStartTime) +"' and '"
                                + converTime(quarterEndTime)+"' group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                        List<Map<String, Object>> quartermaps = jdbcTemplate.queryForList(quarterSql);
                        quarterResultMap.addAll(quartermaps);
                        //月度
                        String monthSql = Asql+Bsql+" where f_createtime between '"+ converTime(monthstart) +"' and '"
                                + converTime(monthend)+"' group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                        List<Map<String, Object>> monthmaps = jdbcTemplate.queryForList(monthSql);
                        monthResultMap.addAll(monthmaps);
                    }
                }
        }
        List<Map<String, Object>>  allMap = removeRepeatMapByKey(allResultMap,"f_xzqdm");
        List<Map<String, Object>>  yearMap = removeRepeatMapByKey(yearResultMap,"f_xzqdm");
        List<Map<String, Object>>  quarterMap = removeRepeatMapByKey(quarterResultMap,"f_xzqdm");
        List<Map<String, Object>>  monthMap = removeRepeatMapByKey(monthResultMap,"f_xzqdm");
        resultMap.put("allMap",allMap);
        resultMap.put("yearMap",yearMap);
        resultMap.put("quarterMap",quarterMap);
        resultMap.put("monthMap",monthMap);
        return resultMap;
    }
    /**
     * 线索数据统计按照政区
     * 线索数据统计按照政区及按年度、季度、月度统计
     * @return
     */
    public  Map<String, Object> getClueStatusCountByDate() {
        Map<String, Object> resultMap = new HashMap<>();
        Calendar cal = Calendar.getInstance();
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //季度开始和结束时间
        String  quarterStartTime = getCurrentQuarterStartTime();
        String  quarterEndTime = getCurrentQuarterEndTime();
        //按月开始和结束时间
        String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        List<JcClueSource> list =  jcClueSourceMapper.getAllList(2,null,null);
        JSONArray allArray = new JSONArray();
        JSONArray yearArray = new JSONArray();
        JSONArray quarterArray = new JSONArray();
        JSONArray monthArray = new JSONArray();
        for(JcClueSource jcClueSource : list) {
            JSONObject allObject = new JSONObject();
                allObject.put("sourceName",jcClueSource.getfName());
                allObject.put("sourceId",jcClueSource.getfId());
                allObject.put("untreatedNum",0);
                allObject.put("handleNum",0);
                allObject.put("totalNum",0);
            JSONObject yearObject = new JSONObject();
                yearObject.put("sourceName",jcClueSource.getfName());
                yearObject.put("sourceId",jcClueSource.getfId());
                yearObject.put("untreatedNum",0);
                yearObject.put("handleNum",0);
                yearObject.put("totalNum",0);
            JSONObject quarterObject = new JSONObject();
                quarterObject.put("sourceName",jcClueSource.getfName());
                quarterObject.put("sourceId",jcClueSource.getfId());
                quarterObject.put("untreatedNum",0);
                quarterObject.put("handleNum",0);
                quarterObject.put("totalNum",0);
            JSONObject monthObject = new JSONObject();
                monthObject.put("sourceName",jcClueSource.getfName());
                monthObject.put("sourceId",jcClueSource.getfId());
                monthObject.put("untreatedNum",0);
                monthObject.put("handleNum",0);
                monthObject.put("totalNum",0);
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
                if(StringUtils.isNotBlank(jcClueSource.getfTablename())){
                    tableNames.add(jcClueSource.getfTablename());
                }
                completeClueChildren(jcClueSource,tableNames);
                if(tableNames.size() > 0){
                    for(String s: tableNames){
                        //全部数据
                        String sql = "select f_status,count(1) from "+s+" group by f_status";
                        List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
                        for(Map<String, Object> map :Allmaps){
                            //status 0 未处理  1 已处理
                            if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                                allObject.put("untreatedNum",allObject.getInteger("untreatedNum")+Integer.valueOf(map.get("count").toString()));
                            }else{
                                allObject.put("handleNum",allObject.getInteger("handleNum")+Integer.valueOf(map.get("count").toString()));
                            }
                        }
                        //年度数据
                        String yearSql ="select f_status,count(1) from "+s+" where f_createtime between '"+  converTime(yearstart) +"' and '" + converTime(yearend)+"'  group by f_status ";
                        List<Map<String, Object>> yearmaps = jdbcTemplate.queryForList(yearSql);
                        for(Map<String, Object> map :yearmaps){
                            //status 0 未处理  1 已处理
                            if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                                yearObject.put("untreatedNum",yearObject.getInteger("untreatedNum")+Integer.valueOf(map.get("count").toString()));
                            }else{
                                yearObject.put("handleNum",yearObject.getInteger("handleNum")+Integer.valueOf(map.get("count").toString()));
                            }
                        }
                        //季度
                        String quarterSql ="select f_status,count(1) from "+s+" where f_createtime between '"+  converTime(quarterStartTime) +"' and '" + converTime(quarterEndTime)+"'  group by f_status ";
                        List<Map<String, Object>> quartermaps = jdbcTemplate.queryForList(quarterSql);
                        for(Map<String, Object> map :quartermaps){
                            //status 0 未处理  1 已处理
                            if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                                quarterObject.put("untreatedNum",quarterObject.getInteger("untreatedNum")+Integer.valueOf(map.get("count").toString()));
                            }else{
                                quarterObject.put("handleNum",quarterObject.getInteger("handleNum")+Integer.valueOf(map.get("count").toString()));
                            }
                        }
                        //月度
                        String monthSql ="select f_status,count(1) from "+s+" where f_createtime between '"+  converTime(monthstart) +"' and '" + converTime(monthend)+"'  group by f_status ";
                        List<Map<String, Object>> monthmaps = jdbcTemplate.queryForList(monthSql);
                        for(Map<String, Object> map :monthmaps){
                            //status 0 未处理  1 已处理
                            if(map.get("f_status") != null && map.get("f_status").toString().equals("0")){
                                monthObject.put("untreatedNum",monthObject.getInteger("untreatedNum")+Integer.valueOf(map.get("count").toString()));
                            }else{
                                monthObject.put("handleNum",monthObject.getInteger("handleNum")+Integer.valueOf(map.get("count").toString()));
                            }
                        }
                    }
                }
            allObject.put("totalNum",Integer.valueOf(allObject.get("handleNum").toString()) + Integer.valueOf(allObject.get("untreatedNum").toString()));
            allArray.add(allObject);
            yearObject.put("totalNum",Integer.valueOf(yearObject.get("handleNum").toString()) + Integer.valueOf(yearObject.get("untreatedNum").toString()));
            yearArray.add(yearObject);
            quarterObject.put("totalNum",Integer.valueOf(quarterObject.get("handleNum").toString()) + Integer.valueOf(quarterObject.get("untreatedNum").toString()));
            quarterArray.add(quarterObject);
            monthObject.put("totalNum",Integer.valueOf(monthObject.get("handleNum").toString()) + Integer.valueOf(monthObject.get("untreatedNum").toString()));
            monthArray.add(monthObject);
        }
        resultMap.put("allMap",allArray);
        resultMap.put("yearMap",yearArray);
        resultMap.put("quarterMap",quarterArray);
        resultMap.put("monthMap",monthArray);
        return resultMap;
    }

    /**
     * 获取任务总量及当周新增量
     * @return
     */
    public Map<String, Object> getTaskCountByCurrenWeek() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer taskAllCount = 0;
        Integer taskWeekCount = 0;
        //获取全部数据
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        String taskSql = "select count(1) from tbtsk_task_biz ttb  where f_isdel  is null";
        String taskWeekSql = "select count(1) from tbtsk_task_biz ttb  where f_isdel  is null and f_createtime  between  '"+startOfWeek+"' and '"+endOfWeek+"' " ;
        taskAllCount  = jdbcTemplate.queryForObject(taskSql, Integer.class);
        taskWeekCount = jdbcTemplate.queryForObject(taskWeekSql, Integer.class);
        resultMap.put("taskAllCount",taskAllCount);
        resultMap.put("taskWeekCount",taskWeekCount);
        return resultMap;
    }

    /**
     * 获取任务图斑总量及办结数量
     * @return
     */
    public Map<String, Object> getTaskTBCountByBranch(String branch) {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer taskTBAllCount = 0;
        Integer taskTBFinishCount = 0;
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2  where ttb.f_tableid  = to2.f_id  and ttb.f_isdel  is null and to2.f_tablename is not null";
        if(StringUtils.isNotBlank(branch) && branch.equals("XCYW")){
            taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2," +
                    "tbtsk_task_class ttc  where ttb.f_tableid  = to2.f_id and ttc.f_id = ttb.f_classid  and ( ttc.f_appkey ='XCYW' ) and ttb.f_isdel  is null and to2.f_tablename is not null;";
        }else if(StringUtils.isNotBlank(branch) && branch.equals("HCYW")){
            taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2,tbtsk_task_class ttc  where ttb.f_tableid  = to2.f_id and ttc.f_id = ttb.f_classid  and ( ttc.f_appkey !='XCYW' or ttc.f_appkey is null) and ttb.f_isdel  is null and to2.f_tablename is not null";
        }
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    String allcount = " select count(1) from " + f_tablename;
                    String finishCount = " select count(1) from " + f_tablename +" where f_review_stage ='101' ";
                    taskTBAllCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                    taskTBFinishCount += jdbcTemplate.queryForObject(finishCount, Integer.class);
                }
            }
        }
        resultMap.put("taskTBAllCount",taskTBAllCount);
        resultMap.put("taskTBFinishCount",taskTBFinishCount);
        return resultMap;
    }

    /**
     * 获取图斑总量及当周新增量
     * @return
     */
    public Map<String, Object> getTaskTBCountByCurrenWeek() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer taskTBAllCount = 0;
        Integer taskTBWeekCount = 0;
        //获取全部数据
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2  where ttb.f_tableid  = to2.f_id  and ttb.f_isdel  is null and to2.f_tablename is not null";
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    String allcount = " select count(1) from " + f_tablename;
                    String weekCount = " select count(1) from " + f_tablename +" where f_createtime  between '"+ converTime(startOfWeek) +"' and '" + converTime(endOfWeek) +"'";
                    taskTBAllCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                    taskTBWeekCount += jdbcTemplate.queryForObject(weekCount, Integer.class);
                }
            }
        }
        resultMap.put("taskTBAllCount",taskTBAllCount);
        resultMap.put("taskTBWeekCount",taskTBWeekCount);
        return resultMap;
    }

    /**
     * 获取成果总量及当周新增量
     * @return
     */
    public Map<String, Object> getTaskMediaCountByCurrenWeek() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer taskMediaAllCount = 0;
        Integer taskMediaWeekCount = 0;
        //获取全部数据
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        String taskSql = "select count(1) from tb_app_media ";
        String taskWeekSql = "select count(1) from tb_app_media  where f_time  between '"+ converTime(startOfWeek) +"' and '" + converTime(endOfWeek) +"'";
        taskMediaAllCount  = jdbcTemplate.queryForObject(taskSql, Integer.class);
        taskMediaWeekCount = jdbcTemplate.queryForObject(taskWeekSql, Integer.class);
        resultMap.put("taskMediaAllCount",taskMediaAllCount);
        resultMap.put("taskMediaWeekCount",taskMediaWeekCount);
        return resultMap;
    }

    /**
     * 获取无人机总数
     * @return
     */
    public Map<String, Object> getDroneLiveCount() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取无人机数量
        Integer droneLiveCount = 0;
        //获取无人机在线数
        Integer droneDevicCount = 0;
        //获取全部数据
        String sql = "select count(1) from tb_drone_live_channel";
        droneLiveCount  = jdbcTemplate.queryForObject(sql, Integer.class);
        Date timeFilter = DateUtils.addSeconds(new Date(), -10*6*5);
        SimpleDateFormat pattern = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String droneDevicsql = "select count(distinct (f_sn)) from  tb_drone_devicetrack where f_updatetime  >='"+pattern.format(timeFilter)+"'";
        droneDevicCount  = jdbcTemplate.queryForObject(droneDevicsql, Integer.class);
        resultMap.put("droneLiveCount",droneLiveCount);
        resultMap.put("droneDevicCount",droneDevicCount);
        return resultMap;
    }

    /**
     * 获取无人机成果
     * @return
     */
    public Map<String, Object> getDroneMediaCount() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer droneMediaAllCount = 0;
        //获取全部数据
        String taskSql = "select count(1) from tb_app_media tam  where f_device_source  ='1'";
        droneMediaAllCount  = jdbcTemplate.queryForObject(taskSql, Integer.class);
        resultMap.put("droneMediaAllCount",droneMediaAllCount);
        resultMap.put("droneAllArea",10346.56);
        return resultMap;
    }

    /**
     * 获取任务相关数据统计  调查人员数量 、调查任务总数、调查图斑总量、调查成果总量
     * @return
     */
    public Map<String, Object> getTaskRelevanceDataCount() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取调查成果总量
        Integer taskMediaAllCount = 0;
        //获取调查任务总数
        Integer taskAllCount = 0;
        //获取调查图斑总量
        Integer taskTBAllCount = 0;
        //调查人员数量
        Integer taskUserCount = 0;

        //调查人员数量
        String taskUserSql = "select  count(distinct(f_userid)) from tbsys_user_biz2 ";
        taskUserCount  = jdbcTemplate.queryForObject(taskUserSql, Integer.class);
        resultMap.put("taskUserCount",taskUserCount);
        //获取调查成果总量
        String taskmedisSql = "select count(1) from tb_app_media ";
        taskMediaAllCount  = jdbcTemplate.queryForObject(taskmedisSql, Integer.class);
        resultMap.put("taskMediaAllCount",taskMediaAllCount);
        //获取调查任务总数
        String taskSql = "select count(1) from tbtsk_task_biz ttb  where f_isdel  is null";
        taskAllCount  = jdbcTemplate.queryForObject(taskSql, Integer.class);
        resultMap.put("taskAllCount",taskAllCount);
        //获取调查图斑总量
        String taskTbSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb ,tbtsk_objectinfo to2  where ttb.f_tableid  = to2.f_id  and ttb.f_isdel  is null and to2.f_tablename is not null";
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskTbSql);
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    String allcount = " select count(1) from " + f_tablename;
                    taskTBAllCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                }
            }
        }
        resultMap.put("taskTBAllCount",taskTBAllCount);
        return resultMap;
    }

    /**
     * 获取用户任务相关数据统计  调查任务、调查图斑总量、调查成果总量
     * @return
     */
    public Map<String, Object> getTaskDataCountByUser(Long userId) {
        Map<String, Object> resultMap = new HashMap<>();
        //获取用户调查成果总量
        Integer taskMediaAllCount = 0;
        //获取调查图斑总量
        Integer taskTBAllCount = 0;
        //用户调查任务数量
        Integer taskUserCount = 0;

        //用户调查任务数量
        String taskUserSql = "select count(distinct f_bizid) from tbsys_user_biz2 tub  where f_userid ='"+userId+"' ";
        taskUserCount  = jdbcTemplate.queryForObject(taskUserSql, Integer.class);
        resultMap.put("taskUserCount",taskUserCount);
        //获取用户调查成果总量
        String taskmedisSql = "select  count(1) from tb_app_media tam,tbsys_user tu  where tu.f_username  = tam.f_username and tu.f_userid ='"+userId+"' ";
        taskMediaAllCount  = jdbcTemplate.queryForObject(taskmedisSql, Integer.class);
        resultMap.put("taskMediaAllCount",taskMediaAllCount);
        //获取用户调查图斑数据 就是已下发数据
        String taskSql = "select  count(distinct f_dataid) from tbtsk_assign_record tar  where f_assignto ='"+userId+"'";
        taskTBAllCount  = jdbcTemplate.queryForObject(taskSql, Integer.class);
        resultMap.put("taskTBCount",taskTBAllCount);
        //获取调查图斑按天和月分组
        Map<String, Object> medDetailsMap = new HashMap<>();
        //按天
        String daySql = "select \n" +
                "          to_char(to_timestamp(TO_NUMBER(SUBSTR(tam.f_time, 0,11), '9999999999')),'yyyy-MM-dd') fTime,COUNT(1) from tb_app_media tam,tbsys_user tu  where tu.f_username  = tam.f_username and tu.f_userid ='"+userId+"' group by fTime  order by  fTime";
        List<Map<String, Object>> daylist = jdbcTemplate.queryForList(daySql);
        medDetailsMap.put("daylist",daylist);
        //按月
        String monthSql = "select \n" +
                "          to_char(to_timestamp(TO_NUMBER(SUBSTR(tam.f_time, 0,11), '9999999999')),'yyyy-MM') fTime,COUNT(1) from tb_app_media tam,tbsys_user tu  where tu.f_username  = tam.f_username and tu.f_userid ='"+userId+"' group by fTime  order by  fTime";

        List<Map<String, Object>> monthlist = jdbcTemplate.queryForList(monthSql);
        medDetailsMap.put("monthlist",monthlist);
        resultMap.put("medDetailsMap",medDetailsMap);
        return resultMap;
    }

    /**
     * 获取云查询总量及当周新增量
     * @return
     */
    public Map<String, Object> getCloudQueryCountByCurrenWeek() {
        Map<String, Object> resultMap = new HashMap<>();
        //获取全部数据
        Integer cloudQueryAllCount = 0;
        Integer cloudQueryWeekCount = 0;
        //获取全部数据
        String  startOfWeek = getCurrentWeekStartStartTime();
        String  endOfWeek = getCurrentWeekStartEndTime();
        String cloudQuerySql = "select count(1) from tb_cloud_query ";
        String cloudQueryWeekSql = "select count(1) from tb_cloud_query  where f_querytime  between  '"+startOfWeek+"' and '"+endOfWeek+"' " ;
        cloudQueryAllCount  = jdbcTemplate.queryForObject(cloudQuerySql, Integer.class);
        cloudQueryWeekCount = jdbcTemplate.queryForObject(cloudQueryWeekSql, Integer.class);
        resultMap.put("cloudQueryAllCount",cloudQueryAllCount);
        resultMap.put("cloudQueryWeekCount",cloudQueryWeekCount);
        return resultMap;
    }

    /**
     * 获取云查询总量及当周新增量
     * @return
     */
    public Map<String, Object> getCloudQueryCountDetails() {
        Map<String, Object> resultMap = new HashMap<>();
        //全部数据
        String allSql = " select to_char(f_querytime, 'YYYY') as time, COUNT(*) as num,sum(f_area) as mj from " +
                "tb_cloud_query group by time  order by time";
        List<Map<String, Object>> allData = jdbcTemplate.queryForList(allSql);
        resultMap.put("allData",allData);
        //按年
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";

        String yearSql = " select to_char(f_querytime, 'YYYY-MM') as time, COUNT(*) as num,sum(f_area)  as mj \n" +
                "from tb_cloud_query\n" +
                "where to_char(f_querytime, 'YYYY-MM-DD') >= '"+yearstart+"'\n" +
                "  and to_char(f_querytime, 'YYYY-MM-DD') <= '"+yearend+"'\n" +
                "group by time\n" +
                "order by time";
        List<Map<String, Object>> yearData = jdbcTemplate.queryForList(yearSql);
        resultMap.put("yearData",yearData);
        //按月
       String monthstart = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
       String monthend = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        String monthSql = " select to_char(f_querytime, 'YYYY-MM-DD') as time, COUNT(*) as num,sum(f_area)  as mj \n" +
                "from tb_cloud_query\n" +
                "where to_char(f_querytime, 'YYYY-MM-DD') >= '"+monthstart+"'\n" +
                "  and to_char(f_querytime, 'YYYY-MM-DD') <= '"+monthend+"'\n" +
                "group by time\n" +
                "order by time;";
        List<Map<String, Object>> monthData = jdbcTemplate.queryForList(monthSql);
        resultMap.put("monthData",monthData);
        return resultMap;
    }

    /**
     * 获取业务总计及本周新增量
     * @return
     */
    public Map<String, Object> getTaskClassCountDetails() {
        Map<String, Object> resultMap = new HashMap<>();
        String XCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where f_appkey  ='XCYW' and " +
                "f_parentid  ='-1'";
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(XCYWSql);
        resultMap.put("XCYWTaskClassmap",handlyTaskClassMap(taskClassmap));

        String HCYWSql = "select ttc.f_id ,ttc.f_name  from  tbtsk_task_class ttc  where  f_parentid  ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        List<Map<String, Object>> taskClassmap1 = jdbcTemplate.queryForList(HCYWSql);
        resultMap.put("HCYWTaskClassmap",handlyTaskClassMap(taskClassmap1));
        return resultMap;
    }


    /**
     * 执行定时任务数据
     * @param record
     */
    public void executeBusinessStatistics(TbBusinessStatistics record){
        //获取当前时间
        LocalDateTime now = LocalDateTime.now();
        if(record.getfNextUpdateTime() == null || datatimeToTimestamp(now) > record.getfNextUpdateTime().getTime()){
           if(StringUtils.isNotBlank(record.getfType())){
               JSONObject  resultObject = new JSONObject();
               switch (record.getfType()) {
                   case "DCZX_ZHTJ": //综合统计
                        resultObject.put("YHZL",getUserCountByCurrenWeek()); //获取用户总量及当周用户新增量
                        resultObject.put("XSZL",getClueCountByCurrenWeek()); //获取线索数据总量及当周新增量
                        resultObject.put("RWZL",getTaskCountByCurrenWeek()); //获取任务总量及当周新增量
                        resultObject.put("TBZL",getTaskTBCountByCurrenWeek()); // 获取图斑总量及当周新增量
                        resultObject.put("CGZL",getTaskMediaCountByCurrenWeek()); //获取成果总量及当周新增量
                        resultObject.put("YCXZL",getCloudQueryCountByCurrenWeek()); //获取云查询总量及当周新增量
                       break;
                   case "DCZX_YHTJ":  //用户统计
                       resultObject.put("YHLB",getUserTaskClass()); //获取业务大类用户总量及本周新增量
                       resultObject.put("DWLX",getUserorganizationCountByCurrenWeek()); //获取用户单位类别及本周新增量
                       break;
                   case "DCZX_YCXTJ": //云查询统计
                       resultObject.put("YCXTJ",getCloudQueryCountDetails()); //获取云查询总量及当周新增量
                       break;
                   case "DCZX_YWTJ": //业务统计
                       resultObject.put("YWTJ",getTaskClassCountDetails()); //获取业务总计及本周新增量
                       break;
                   case "XSGL_HJGZ": //线索管理-汇聚感知
                       resultObject.put("HJXS",getClueCountByDate()); //获取汇聚线索 线索汇总
                       resultObject.put("RHCL",getClueMergestatusCountByDate()); //获取汇聚线索 获取线索融合处理数据
                       String fSqlscript = record.getfSqlscript();
                       JSONObject jsonObject = JSONObject.parseObject(fSqlscript);
                       resultObject.put("TSYY",getTSYYClueCountByDate(jsonObject.getString("TSYY"))); //获取汇聚线索 推送应用
                       resultObject.put("XSLX",getClueTypeByDate()); //获取汇聚线索  线索类型数据
                       break;
                   case "XSGL_XZQDM": //线索管理-按照政区划分获取数据
                       resultObject.put("XZQDM",getClueXzqdmCountByDate()); //线索管理 按照政区划分获取数据
                       break;
                   case "XSGL_XSZT": //线索管理-根据线索来源按照线索状态获取数据
                       resultObject.put("XSZT",getClueStatusCountByDate()); //根据线索来源按照线索状态获取数据
                       break;
                   default:
                       break;
               }
               record.setfData(resultObject.toJSONString());
           }
            //更新下次数据统计时间
            if(record.getfTimeType() != null){
                //间隔时间类型 1 分 2 小时 3 天 4 月
                if(record.getfIntervalTime() != null){
                    if(record.getfTimeType() == 1){
                        //当前时间增加10分钟
                        LocalDateTime nextMinutes = now.plusMinutes(record.getfIntervalTime());
                        record.setfNextUpdateTime(new Timestamp(datatimeToTimestamp(nextMinutes)));
                    }else if(record.getfTimeType() == 2){
                        //当前时间增加一小时
                        LocalDateTime nextHour = now.plusHours(record.getfIntervalTime());
                        record.setfNextUpdateTime(new Timestamp(datatimeToTimestamp(nextHour)));
                    }else if(record.getfTimeType() == 3){
                        //当前时间增加1天
                        LocalDateTime nextDays = now.plusDays(record.getfIntervalTime());
                        record.setfNextUpdateTime(new Timestamp(datatimeToTimestamp(nextDays)));
                    }else if(record.getfTimeType() == 4){
                        //当前时间增加1月
                        LocalDateTime nextMonths = now.plusMonths(record.getfIntervalTime());
                        record.setfNextUpdateTime(new Timestamp(datatimeToTimestamp(nextMonths)));
                    }
                }
            }
            record.setfUpdateTime(new Timestamp(datatimeToTimestamp(now)));
        }
        record.setfStatus(1);
        tbBusinessStatisticsRepository.gwAccessSelective(record);
    }


   //将LocalDataTime转为timestamp
    public long datatimeToTimestamp(LocalDateTime ldt){
        long timestamp = ldt.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return timestamp;
    }

    //将timestamp转为LocalDateTime
    public LocalDateTime timestamToDatetime(long timestamp){
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

        private void completeClueChildren(JcClueSource jcClueSource,List<String> tableNames) {
            List<JcClueSource> jcClueSources = jcClueSourceMapper.queryByParentId(jcClueSource.getfId(),null);
            if(jcClueSources.size() > 0){
                for(JcClueSource bean : jcClueSources){
                    if(StringUtils.isNotBlank(bean.getfTablename())){
                        tableNames.add(bean.getfTablename());
                    }
                    completeClueChildren(bean,tableNames);
                }
            }
        }

    /**
     * 获得某天最大时间 2022-11-11 23:59:59
     * @param date
     * @return
     */
    public static String getEndOfDay(Date date) {

        if (date == null) date = new Date();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());;
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String EndOfDay = sdf.format(Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant()));
        return EndOfDay;
    }

    /**
     * 获得某天最小时间 2022-11-11 00:00:00
     * @param date
     * @return
     */
    public static String getStartOfDay(Date date) {

        if (date == null) date = new Date();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String StartOfDay = sdf.format(Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant()));
        return StartOfDay;
    }



    /**
     * 当月开始时间
     * @param year
     * @param month
     * @return
     */
    public static String getFisrtDayOfMonth(int year,int month){
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);

        //获取某月最小天数
        int firstDay = cal.getActualMinimum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最小天数
        cal.set(Calendar.DAY_OF_MONTH, firstDay);

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);

        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }


    /**
     * 当月结束时间
     * @param year
     * @param month
     * @return
     */
    public static String getLastDayOfMonth(int year,int month)
    {
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);
        //获取某月最大天数
        int lastDay = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最大天数
        cal.set(Calendar.DAY_OF_MONTH, lastDay);

        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }


    /**
     * 当季开始时间
     * @return
     */
    public static String getCurrentQuarterStartTime() {
        Calendar c = Calendar . getInstance();
        int currentMonth = c. get (Calendar .MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3)
                c.set(Calendar.MONTH,0) ;
            else if (currentMonth >= 4 && currentMonth <= 6)
                c.set(Calendar . MONTH,3) ;
            else if ( currentMonth >= 7 && currentMonth <= 9)
                c.set(Calendar . MONTH,4);
            else if ( currentMonth >= 10 && currentMonth <= 12)
                c.set(Calendar . MONTH,9);
        } catch (Exception e) {
            e.printStackTrace() ;
        }
        //格式化日期
        c.set(Calendar.DATE,1) ;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  time = sdf.format(c.getTime())+ " 00:00:00";
        return time;
    }

    /**
     * 当季结束时间
     * @return
     */
    public static String getCurrentQuarterEndTime() {
        Calendar c = Calendar . getInstance();
        int currentMonth = c. get (Calendar .MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3){
                c.set(Calendar.MONTH,2) ;
                c.set(Calendar.DATE,31) ;
            } else if (currentMonth >= 4 && currentMonth <= 6){
                c.set(Calendar.MONTH,5) ;
                c.set(Calendar.DATE,31) ;
            }else if ( currentMonth >= 7 && currentMonth <= 9){
                c.set(Calendar.MONTH,8) ;
                c.set(Calendar.DATE,31) ;
            } else if ( currentMonth >= 10 && currentMonth <= 12){
                c.set(Calendar.MONTH,11) ;
                c.set(Calendar.DATE,31) ;
            }
        } catch (Exception e) {
            e.printStackTrace() ;
        }
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  time = sdf.format(c.getTime()) +"  23:59:59";
        return time;
    }

    /**
     * 将字符串转为时间戳
     * @param time
     * @return
     */
    public static Long converTime(String time ) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime()/1000;
        } catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }

    /**
     * 获取当天开始时间
     * @return
     */
    public static String getCurrentDayStartTime() {
        // 获取当天日期
        LocalDate now = LocalDate.now();

        // 当天开始时间
        LocalDateTime todayStart = now.atStartOfDay();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        System.out.println("当天开始时间 = " + todayStart.format(pattern));
        return todayStart.format(pattern);
    }
    /**
     * 获取当天接收时间
     * @return
     */
    public static String getCurrentDayEndTime() {
        // 获取当天日期
        LocalDate now = LocalDate.now();

        // 当天开始时间
        LocalDateTime todayEnd = LocalDateTime.of(now, LocalTime.MAX);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        System.out.println("当天开始时间 = " + todayEnd.format(pattern));
        return todayEnd.format(pattern);
    }
    /**
     * 获取当周开始时间
     * @return
     */
    public static String getCurrentWeekStartStartTime() {
        // 获取当天日期
        LocalDate now = LocalDate.now();
        // 周一
        LocalDate monday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));

        // 本周开始时间
        LocalDateTime weekStart = monday.atStartOfDay();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return weekStart.format(pattern);
    }
    /**
     * 获取本周结束时间
     * @return
     */
    public static String getCurrentWeekStartEndTime() {
        // 获取当天日期
        LocalDate now = LocalDate.now();
        // 周日
        LocalDate sunday = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        // 本周结束时间
        LocalDateTime weekEnd = LocalDateTime.of(sunday, LocalTime.MAX);
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return weekEnd.format(pattern);
    }


    public static void main(String[] args) {
        // 获取当天日期
        LocalDate now = LocalDate.now();

        //获取当前时间
        LocalDateTime now1 = LocalDateTime.now();
        //当前时间增加50秒
        LocalDateTime nextSeconds = now1.plusSeconds(50);
        //当前时间增加10分钟
        LocalDateTime nextMinutes = now1.plusMinutes(10);
        //当前时间增加一小时
        LocalDateTime nextHour = now1.plusHours(1);
        //当前时间增加1天
        LocalDateTime nextDays = now1.plusDays(1);
        //当前时间增加1月
        LocalDateTime nextMonths = now1.plusMonths(1);

        // 当天开始时间
        LocalDateTime todayStart = now.atStartOfDay();
        // 当天结束时间
        LocalDateTime todayEnd = LocalDateTime.of(now, LocalTime.MAX);

        // 周一
        LocalDate monday = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        // 周日
        LocalDate sunday = now.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));

        // 本周开始时间
        LocalDateTime weekStart = monday.atStartOfDay();
        // 本周结束时间
        LocalDateTime weekEnd = LocalDateTime.of(sunday, LocalTime.MAX);

        // 本月1号
        LocalDate firstDayOfMonth = now.with(TemporalAdjusters.firstDayOfMonth());
        // 本月最后一天
        LocalDate lastDayOfMonth = now.with(TemporalAdjusters.lastDayOfMonth());

        // 本月1号的开始时间
        LocalDateTime firstDayOfMonthStart = firstDayOfMonth.atStartOfDay();
        // 本月最后一天的最后时间
        LocalDateTime firstDayOfMonthEnd = LocalDateTime.of(lastDayOfMonth, LocalTime.MAX);

        // 今年第一天
        LocalDate beginTime = LocalDate.now().with(TemporalAdjusters.firstDayOfYear());
        // 今年最后一天
        LocalDate endTiime = LocalDate.now().with(TemporalAdjusters.lastDayOfYear());

        //获取前一天日期
        LocalDate yesterday2 = LocalDate.now().minusDays(1);

        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        System.out.println("当前时间 = " + now1.format(pattern));
        System.out.println("当前时间增加50秒 = " + nextSeconds.format(pattern));
        System.out.println("当前时间增加10分钟 = " + nextMinutes.format(pattern));
        System.out.println("当前时间增加一小时 = " + nextHour.format(pattern));
        System.out.println("当前时间增加1天 = " + nextDays.format(pattern));
        System.out.println("当前时间增加1月 = " + nextMonths.format(pattern));

        System.out.println("当天开始时间 = " + todayStart.format(pattern));
        System.out.println("当天结束时间 = " + todayEnd.format(pattern));
        System.out.println("本周开始时间 = " + weekStart.format(pattern));
        System.out.println("本周结束时间 = " + weekEnd.format(pattern));
        System.out.println("本月开始时间 = " + firstDayOfMonthStart.format(pattern));
        System.out.println("本月结束时间 = " + firstDayOfMonthEnd.format(pattern));
    }



    /**
     * List<Map<String, Object>>  key相同累加数量
     * @author  guang
     * @param list
     * @param mapKey
     * @return
     */
    public static List<Map<String, Object>> removeRepeatMapByKey(List<Map<String, Object>>list, String mapKey) {
        //把list中的数据转换成msp,去掉同一id值多余数据，保留查找到第一个id值对应的数据
        List<Map<String, Object>> listMap = new ArrayList<>();
        Map<String, Map> msp = new HashMap<>();
        for (int i = list.size() - 1; i >= 0; i--) {
            Map map = list.get(i);
            String id = (String) map.get(mapKey);
            map.remove(mapKey);
            //记录存在
            if(msp.containsKey(id)){
                //当前存放的数据     记录存在的数量+当前需要存放的数量
                map.put("count", Double.parseDouble(msp.get(id).get("count").toString())+Double.parseDouble(map.get("count").toString()));
            }
            //map 同一个key赋值会替换
            msp.put(id, map);
        }
        //把msp再转换成list,就会得到根据某一字段去掉重复的数据的List<Map>
        Set<String> mspKey = msp.keySet();
        for (String key : mspKey) {
            Map newMap = msp.get(key);
            newMap.put(mapKey, key);
            listMap.add(newMap);
        }
        return listMap;
    }

    public void executeZhddXshjStatistics(String type) {
        List<TbBusinessStatistics> tbBusinessStatistics = tbBusinessStatisticsRepository.queryByType(type);
        if(tbBusinessStatistics == null || tbBusinessStatistics.size() == 0) {
            return;
        }
        TbBusinessStatistics record = tbBusinessStatistics.get(0);
        switch (record.getfType()) {
            case "DCZX_ZHTJ": //综合统计
//                        resultObject.put("YHZL",getUserCountByCurrenWeek()); //获取用户总量及当周用户新增量
//                        resultObject.put("XSZL",getClueCountByCurrenWeek()); //获取线索数据总量及当周新增量
//                        resultObject.put("RWZL",getTaskCountByCurrenWeek()); //获取任务总量及当周新增量
//                        resultObject.put("TBZL",getTaskTBCountByCurrenWeek()); // 获取图斑总量及当周新增量
//                        resultObject.put("CGZL",getTaskMediaCountByCurrenWeek()); //获取成果总量及当周新增量
//                        resultObject.put("YCXZL",getCloudQueryCountByCurrenWeek()); //获取云查询总量及当周新增量
                break;
            case "DCZX_YHTJ":  //用户统计
//                        resultObject.put("YHLB",getUserTaskClass()); //获取业务大类用户总量及本周新增量
//                        resultObject.put("DWLX",getUserorganizationCountByCurrenWeek()); //获取用户单位类别及本周新增量
                break;
            case "DCZX_YCXTJ": //云查询统计
//                        resultObject.put("YCXTJ",getCloudQueryCountDetails()); //获取云查询总量及当周新增量
                break;
            case "DCZX_YWTJ": //业务统计
//                        resultObject.put("YWTJ",getTaskClassCountDetails()); //获取业务总计及本周新增量
                break;
            case "XSGL_HJGZ": //线索管理-汇聚感知
                // 获取所有线索数量和面积
                Timestamp timestamp = new Timestamp(new Date().getTime());
                TbZhddZdzbtj tbZhddZdzbtj1 = new TbZhddZdzbtj();
                Map<String, Object> allClueCountAndMj = getAllClueCountAndMj();
                tbZhddZdzbtj1.setId(UUID.randomUUID().toString());
                tbZhddZdzbtj1.setModule("线索汇聚");
                tbZhddZdzbtj1.setType("线索汇聚");
                tbZhddZdzbtj1.setValue(allClueCountAndMj.get("count").toString());
                tbZhddZdzbtj1.setCalculatorvalue(allClueCountAndMj.get("mj").toString());
                tbZhddZdzbtj1.setCreatetime(timestamp);
                // 获取所有推送处置数量和面积
                String fSqlscript = record.getfSqlscript();
                JSONObject jsonObject = JSONObject.parseObject(fSqlscript);
                Map<String, Object> tsyy = getTSYYClueCountAndMj(jsonObject.getString("TSYY"));
                TbZhddZdzbtj tbZhddZdzbtj2 = new TbZhddZdzbtj();
                tbZhddZdzbtj2.setId(UUID.randomUUID().toString());
                tbZhddZdzbtj2.setModule("线索汇聚");
                tbZhddZdzbtj2.setType("推送处置");
                tbZhddZdzbtj2.setValue(tsyy.get("count").toString());
                tbZhddZdzbtj2.setCalculatorvalue(tsyy.get("mj").toString());
                tbZhddZdzbtj2.setCreatetime(timestamp);
                // 获取所有复用分析数量和面积
                Map<String, Object> clueMergestatusCountAndMj = getClueMergestatusCountAndMj();
                TbZhddZdzbtj tbZhddZdzbtj3 = new TbZhddZdzbtj();
                tbZhddZdzbtj3.setId(UUID.randomUUID().toString());
                tbZhddZdzbtj3.setModule("线索汇聚");
                tbZhddZdzbtj3.setType("复用分析");
                tbZhddZdzbtj3.setValue(clueMergestatusCountAndMj.get("count").toString());
                tbZhddZdzbtj3.setCalculatorvalue(clueMergestatusCountAndMj.get("mj").toString());
                tbZhddZdzbtj3.setCreatetime(timestamp);
                List<TbZhddZdzbtj> list = new ArrayList<>();
                list.add(tbZhddZdzbtj1);
                list.add(tbZhddZdzbtj2);
                list.add(tbZhddZdzbtj3);
                tbZhddZdzbtjRepository.saveAll(list);
                break;
            case "XSGL_XZQDM": //线索管理-按照政区划分获取数据
//                        resultObject.put("XZQDM",getClueXzqdmCountByDate()); //线索管理 按照政区划分获取数据
                break;
            case "XSGL_XSZT": //线索管理-根据线索来源按照线索状态获取数据
//                        resultObject.put("XSZT",getClueStatusCountByDate()); //根据线索来源按照线索状态获取数据
                break;
            default:
                break;
        }
    }


    /**
     * 根据大类获取调查任务信息
     * @param classId
     * @return
     */
    public List<Map<String, Object>> getTaskBaseInfoByClassId(Integer classId,String userId){
        String taskSql = "select ttb.f_id ,to2.f_tablename,ttb.f_name,ttb.f_createtime  from tbtsk_task_biz ttb  inner join " +
                " tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) " +
                " where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid ="+classId +
                " and ttb.f_id in (select b.f_bizid from tbsys_user_biz2 b where b.f_userid='"+ userId + "' and b.f_role = 1)";

        return jdbcTemplate.queryForList(taskSql);
    }

    /**
     * 调查任务图斑数据根据业务大类区分
     * @param taskName
     * @param classId
     * @return
     */
    public Map getTaskCountByClassIdAndTaskName(String taskName, Integer classId,int page,int rows){
        boolean b = SQLInjectionUtil.containsSqlInjection(taskName);
        boolean b1 = SQLInjectionUtil.containsSqlInjection(classId);
        if(b || b1){
            throw new GwValidateException("存在sql注入风险，请检查参数");
        }
        String classFilter = "";
        if(classId!=null){
            classFilter = " and ttb.f_classid = " + classId;
        }else{}
        String taskSql = "select ttb.f_id ,to2.f_tablename,ttb.f_name,ttb.f_createtime  from tbtsk_task_biz ttb  inner join " +
                "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' " + classFilter;
        String countSql = "select count(1)  from tbtsk_task_biz ttb  inner join " +
                "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' " + classFilter;
        if(StringUtils.isNotEmpty(taskName)){
            taskSql += " and ttb.f_name like '%" + taskName +"%'";
            countSql += " and ttb.f_name like '%" + taskName +"%'";
        }
        taskSql += " limit " + rows + " offset " + (page-1)*rows;
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        Integer total = jdbcTemplate.queryForObject(countSql, Integer.class);
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    String allcount = " select count(1) from " + f_tablename;
                    map2.put("taskTBCount",jdbcTemplate.queryForObject(allcount, Integer.class));
                }
            }
        }
        List<Map<String, Object>> list = taskMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("taskTBCount"), (Integer) e2.get("taskTBCount"));
        }).collect(Collectors.toList());
        Map map = new HashMap();
        map.put("list",list);
        map.put("total",total);
        return map;

    }

    /**
     * 调查任务图斑数据根据业务大类区分
     * @param userId
     * @param classId
     * @return
     */
    public List<Map<String, Object>> getTaskCountByClassId(Long userId, Integer classId){
        List<Long> classIds = new ArrayList<>();
        classIds.add(Long.valueOf(classId));
        mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);
        String taskSql = "select ttb.f_id ,to2.f_tablename,ttb.f_name,ttb.f_createtime  from tbtsk_task_biz ttb  inner join " +
                "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    String allcount = " select count(1) from " + f_tablename;
                    map2.put("taskTBCount",jdbcTemplate.queryForObject(allcount, Integer.class));
                }
            }
        }
        List<Map<String, Object>> list = taskMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("taskTBCount"), (Integer) e2.get("taskTBCount"));
        }).collect(Collectors.toList());
        return list;

    }

    /**
     * 调查任务图斑数据及任务数量根据业务大类区分
     * @param appsId
     * @return
     */
    public List<Map<String, Object>> getClassOption(String appsId){
        List<Map<String, Object>>  resultMap = new ArrayList<>();

        String taskClassSql = "select f_id ,f_name,f_imgurl  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc" +
                ".f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if(StringUtils.isNotBlank(appsId)){
            taskClassSql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(taskClassSql);
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                Map<String, Object> map = new HashMap<>();
                String classId = map1.get("f_id").toString();
                String className = map1.get("f_name").toString();
                String imgurl = map1.get("f_imgurl")!=null?map1.get("f_imgurl").toString():"";
                if(StringUtils.isNotBlank(imgurl) && !imgurl.contains("AccessKeyId")){
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", imgurl, null);
                    map.put("imgurl",url);
                }else{
                    map.put("imgurl",imgurl);
                }
                List<Long> classIds = new ArrayList<>();
                classIds.add(Long.valueOf(classId));
                int taskTBCount = 0;
                int taskCount = 0;
                map.put("classId",classId);
                map.put("className",className);
                resultMap.add(map);
            }
        }
        return resultMap;
    }


    public List<Map<String, Object>> getClassTree(String appsId){
        List<Map<String, Object>>  resultMap = new ArrayList<>();

        String taskClassSql = "select f_id ,f_name  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc" +
                ".f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if(StringUtils.isNotBlank(appsId)){
            taskClassSql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(taskClassSql);
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                Map<String, Object> map = new HashMap<>();
                String classId = map1.get("f_id").toString();
                String className = map1.get("f_name").toString();
                map.put("value",classId);
                map.put("label",className);
                String sql2 = "select f_id ,f_name  from tbtsk_task_class ttc where f_parentid='" + classId +"'";
                List<Map<String, Object>> childList = jdbcTemplate.queryForList(sql2);
                if(childList!=null&& !childList.isEmpty()){
                    List<Map<String, Object>> children = new ArrayList<>();
                    for(Map<String, Object> child : childList){
                        Map<String, Object> temp = new HashMap<>();
                        String id = child.get("f_id").toString();
                        String name = child.get("f_name").toString();
                        temp.put("value",id);
                        temp.put("label",name);
                        children.add(temp);
                    }
                    map.put("children",children);
                }
                resultMap.add(map);
            }
        }
        return resultMap;
    }

    /**
     * 调查任务图斑数据及任务数量根据业务大类区分
     * @param userId
     * @param appsId
     * @return
     */
    public List<Map<String, Object>> getClassTaskCount(Long userId,String appsId){
        List<Map<String, Object>>  resultMap = new ArrayList<>();

        String taskClassSql = "select f_id ,f_name,f_imgurl  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc" +
                ".f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if(StringUtils.isNotBlank(appsId)){
            taskClassSql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(taskClassSql);
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                Map<String, Object> map = new HashMap<>();
                String classId = map1.get("f_id").toString();
                String className = map1.get("f_name").toString();
                String imgurl = map1.get("f_imgurl")!=null?map1.get("f_imgurl").toString():"";
                if(StringUtils.isNotBlank(imgurl) && !imgurl.contains("AccessKeyId")){
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", imgurl, null);
                    map.put("imgurl",url);
                }else{
                    map.put("imgurl",imgurl);
                }
                List<Long> classIds = new ArrayList<>();
                classIds.add(Long.valueOf(classId));
                int taskTBCount = 0;
                int taskCount = 0;
                map.put("classId",classId);
                map.put("className",className);
                map.put("taskTBCount",taskTBCount);
                map.put("taskCount",taskCount);
                mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);

                String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";
             /*   String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                        "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid ='"+classId+"'";*/

                List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
                for(Map<String, Object> map2 :taskMap){
                    if(map2.get("f_tablename") != null ) {
                        String f_tablename = map2.get("f_tablename").toString();
                        if(StringUtils.isNotBlank(f_tablename)){
                            String allcount = " select count(1) from " + f_tablename;
                            taskTBCount += jdbcTemplate.queryForObject(allcount, Integer.class);
                        }
                    }
                }
                map.put("taskTBCount",taskTBCount);
                map.put("taskCount",taskMap.size());
                resultMap.add(map);
            }
        }
        List<Map<String, Object>> list = resultMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("taskTBCount"), (Integer) e2.get("taskTBCount"));
        }).collect(Collectors.toList());
        return list;
    }

    public Map<String, Object> getBusinessAndUserCount(Long userId,String appsId){
        Map<String, Object> resultMap = new HashMap<>();
        String taskClassSql = "select f_id ,f_name  from tbtsk_task_class ttc where ttc.f_parentid ='-1' and (ttc.f_appkey is  null  or ttc.f_appkey !='XCYW')";
        if(StringUtils.isNotBlank(appsId)){
            taskClassSql += " and ttc.f_appkey ='"+ appsId+"'";
        }
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(taskClassSql);
        resultMap.put("businessCount",taskClassmap.size());
        String userSql ="select count(distinct(tub.f_userid)) from tbsys_user_biz2 tub ,tbsys_user tu  where tub.f_userid = tu.f_userid";
        resultMap.put("userCount",jdbcTemplate.queryForObject(userSql, Integer.class));
        return resultMap;
    }

    public  List<Map<String, Object>> getTaskTbByRegion(Long userId,String taskId){
        TbtskObjectinfo table = tskTaskBizService.findTableByTaskId(taskId);
        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Bsql = " ,B as (select SUBSTR(f_xzqdmsys,1,6) as xzqdm,count(1) from "+table.getfTablename();
        String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
        return Allmaps;
    }

    public JSONObject zdzxCount(String name,List<Long> classIds){
        List<Long> allclassIds = new ArrayList<>();
        //耕地监测  耕地流出监测\耕地流入监测
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name",name);
        for(Long classId : classIds){
            allclassIds.add(classId);
            mTbtskTaskClassService.queryClassIdByParentId(classId,allclassIds);
        }
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        List<Map<String, Object>> gdjcAllMap = new ArrayList<>();
        Long gdjcTbCount =0L; Long gdjcMediaCount =0L;
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    //获取政区对应数据
                    String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                    String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+f_tablename+"  ";
                    String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                    List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
                    gdjcAllMap.addAll(Allmaps);
                    //获取总数
                    String totalNum = " select count(1) from "+f_tablename;
                    gdjcTbCount+=jdbcTemplate.queryForObject(totalNum, Long.class);
                    //获取附件总数
                    String mediaNum = " select count(1) from tb_app_media tam , "+f_tablename+" tb where tb.f_id = tam.f_galleryid ";
                    gdjcMediaCount+=jdbcTemplate.queryForObject(mediaNum, Long.class);
                }
            }
        }
        jsonObject.put("gdjcTbCount",gdjcTbCount);
        jsonObject.put("gdjcMediaCount",gdjcMediaCount);
        List<Map<String, Object>>  gdjcMap = removeRepeatMapByKey(gdjcAllMap,"f_xzqdm");
        jsonObject.put("gdjcAllMap",gdjcMap);
        return jsonObject;
    }

    public Map<String, Object> getOverviewZdzx(Long userId){
        Map<String, Object> resultMap = new HashMap<>();
        //耕地监测  耕地流出监测\耕地流入监测
        List<Long> gejcclassIds = new ArrayList<>();
        gejcclassIds.add(424L);
        gejcclassIds.add(398l);
        JSONObject gejcObject = zdzxCount("耕地监测",gejcclassIds);
        resultMap.put("gdjc",gejcObject);
        //综合监测  常规监测（含耕地流出）\耕地流入监测
        List<Long> zhjgclassIds = new ArrayList<>();
        zhjgclassIds.add(425L);
        zhjgclassIds.add(424L);
        JSONObject zhjgObject = zdzxCount("综合监测", zhjgclassIds);
        resultMap.put("zhjg",zhjgObject);
        //耕地监测  耕地流出监测\耕地流入监测
        List<Long> cgjcclassIds = new ArrayList<>();
        cgjcclassIds.add(425L);
        JSONObject cgjcObject = zdzxCount("常规监测", cgjcclassIds);
        resultMap.put("cgjc",cgjcObject);
        //城市监测  上半年自然资源监测
        List<Long> csjcclassIds = new ArrayList<>();
        csjcclassIds.add(34L);
        JSONObject csjcObject = zdzxCount("城市监测", csjcclassIds);
        resultMap.put("csjc",csjcObject);
        //供后监管  供后监管
        List<Long> ghjgclassIds = new ArrayList<>();
        ghjgclassIds.add(15L);
        JSONObject ghjgObject = zdzxCount("供后监管",ghjgclassIds);
        resultMap.put("ghjg",ghjgObject);

        //变更调查
        JSONObject bgdcObject = zdzxCount("变更调查",ghjgclassIds);
        bgdcObject.put("name","变更调查");
        List<Map<String, Object>> gdjcAllMap = new ArrayList<>();
        Long gdjcTbCount =0L; Long gdjcMediaCount =0L;
        //获取政区对应数据
        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1),sum(f_tbnum) from tb_business_statistics_bgdc ";
        String sql = Asql+Bsql+" group by xzqdm) select A.*,case when sum is null then 0 else sum end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
        gdjcAllMap.addAll(Allmaps);
        //获取总数
        String totalNum = " select sum(f_tbnum) from  tb_business_statistics_bgdc";
        gdjcTbCount+=jdbcTemplate.queryForObject(totalNum, Long.class);
        //获取附件总数
        String mediaNum = " select sum(f_mednum) from  tb_business_statistics_bgdc ";
        gdjcMediaCount+=jdbcTemplate.queryForObject(mediaNum, Long.class);
        bgdcObject.put("gdjcTbCount",gdjcTbCount);
        bgdcObject.put("gdjcMediaCount",gdjcMediaCount);
        List<Map<String, Object>>  gdjcMap = removeRepeatMapByKey(gdjcAllMap,"f_xzqdm");
        bgdcObject.put("gdjcAllMap",gdjcMap);
        resultMap.put("bgdc",bgdcObject);
        return resultMap;
    }


    /**
     * 获取所有线索的数量
     * @return
     */
    public JSONObject getAllClueCountByYear(String year) {
        JSONObject object = new JSONObject();
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        //获取全部数据
        List<Map<String, Object>> AllMap = new ArrayList<>();
        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);
        JSONObject object1 = new JSONObject();
        for (JcClueSource jcClueSource : list) {
            Long clueAllCount = 0L;
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String f_tablename : tableNames) {
                    String totalNum = "select count(1) from "+f_tablename+" where f_createtime between '"+ converTime(yearstart) +"' and '" + converTime(yearend) +"'";
                    clueAllCount+=jdbcTemplate.queryForObject(totalNum, Long.class);


                    String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                    String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+f_tablename+" where f_createtime between '"+ converTime(yearstart) +"' and '" + converTime(yearend) +"'";
                    String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                    List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
                    AllMap.addAll(Allmaps);
                }
            }
            object1.put(jcClueSource.getfName(),clueAllCount);
        }
        List<Map<String, Object>>  regionMap = removeRepeatMapByKey(AllMap,"f_xzqdm");
        object.put("regionMap",regionMap);
        object.put("xsMap",object1);
        return object;
    }

    public Map<String, Object> getOverviewXshj(Long userId){
        String sourceId = "be7323d1-3968-463d-8d11-1893a82fd1d4,dd487e12-8e56-41e2-87f0-30965f8d234b";
        Map<String, Object> resultMap = new HashMap<>();
        JSONObject xshjObject = new JSONObject();
        // 获取所有线索数量和面积
        Map<String, Object> allClueCountAndMj = getAllClueCountAndMj();
        xshjObject.put("xshj",allClueCountAndMj);
        // 获取所有推送处置数量和面积
        Map<String, Object> tsyy = getTSYYClueCountAndMj(sourceId);
        xshjObject.put("tsyy",tsyy);
        // 获取所有复用分析数量和面积
        Map<String, Object> rhfx = getClueMergestatusCountAndMj();
        xshjObject.put("rhfx",rhfx);
        resultMap.put("xshj",xshjObject);

        //获取各线索大类数据
        List<JcClueSource> list = jcClueSourceMapper.getAllList(2, null, null);
        List<Map<String, Object>> AllMap = new ArrayList<>();
        List<Map<String, Object>> tsczMap = new ArrayList<>();
        List<Map<String, Object>> xssjList = new ArrayList<>();
        for (JcClueSource jcClueSource : list) {
            Map<String, Object> map = new HashMap<>();
            map.put("name",jcClueSource.getfName());
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            Long xsCount = 0L;
            if (tableNames.size() > 0) {
                for (String f_tablename : tableNames) {
                    if(StringUtils.isNotBlank(f_tablename)){
                        //获取政区对应数据
                        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                        String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+f_tablename+"  ";
                        String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                        List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
                        AllMap.addAll(Allmaps);
                        //获取总数
                        String totalNum = " select count(1) from "+f_tablename;
                        xsCount+=jdbcTemplate.queryForObject(totalNum, Long.class);
                    }
                }
            }
            map.put("xsCount",xsCount);
            xssjList.add(map);
        }
        resultMap.put("xssjList",xssjList);

        List<Map<String, Object>>  xshjAllMap = removeRepeatMapByKey(AllMap,"f_xzqdm");
        resultMap.put("xshjAllMap",xshjAllMap);
        //推送处置
        List<String> sourceIds = Arrays.asList(sourceId.split(","));
        List<JcClueSource> list1 = jcClueSourceMapper.getCuleBysourceids(sourceIds);
        for (JcClueSource jcClueSource : list) {
            // 获取所有分组线索
            List<String> tableNames = new ArrayList<>();
            if (StringUtils.isNotBlank(jcClueSource.getfTablename())) {
                tableNames.add(jcClueSource.getfTablename());
            }
            completeClueChildren(jcClueSource, tableNames);
            if (tableNames.size() > 0) {
                for (String s : tableNames) {
                    if(StringUtils.isNotBlank(s)){
                        //获取政区对应数据
                        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
                        String Bsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from "+s+"  ";
                        String sql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
                        List<Map<String, Object>> Allmaps = jdbcTemplate.queryForList(sql);
                        tsczMap.addAll(Allmaps);
                    }
                }
            }
        }
        List<Map<String, Object>>  tsczAllMap = removeRepeatMapByKey(tsczMap,"f_xzqdm");
        resultMap.put("tsczAllMap",tsczAllMap);
        return resultMap;
    }


    public Map<String, Object> getOverviewXsktdwjc(Long userId){
        Map<String, Object> resultMap = new HashMap<>();
        //2020年
        JSONObject object_2020 = getAllClueCountByYear("2020");
        resultMap.put("2020",object_2020);
        //2021
        JSONObject object_2021 = getAllClueCountByYear("2021");
        resultMap.put("2021",object_2021);
        //2022
        JSONObject object_2022 = getAllClueCountByYear("2022");
        resultMap.put("2022",object_2022);
        //2023
        JSONObject object_20203 = getAllClueCountByYear("2023");
        resultMap.put("2023",object_20203);
        //2024
        JSONObject object_20204 = getAllClueCountByYear("2024");
        resultMap.put("2024",object_20204);
        return resultMap;
    }

    public Map<String, Object> getOverviewRwhz(Long userId){
        Map<String, Object> resultMap = new HashMap<>();
        //汇总数据
        JSONObject levelObkect = new JSONObject();
        levelObkect.put("cityCount",0);
        levelObkect.put("countyCount",0);
        String levelsql = " select f_unifylevel,count(1) from tbtsk_task_biz ttb where f_unifylevel in ('2','3') group by f_unifylevel;";
        List<Map<String, Object>> levelMaps = jdbcTemplate.queryForList(levelsql);
        if(levelMaps.size()>0){
            for(Map<String, Object> map:levelMaps ){
                if("2".equals(map.get("f_unifylevel").toString())){
                    levelObkect.put("cityCount",map.get("count"));
                }else if("3".equals(map.get("f_unifylevel").toString())){
                    levelObkect.put("countyCount",map.get("count"));
                }
            }
        }
        Calendar cal = Calendar.getInstance();
        //按年开始和结束时间
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        String yearCitysql = "select count(1) from tbtsk_task_biz where f_unifylevel in ('3') and f_createtime " +
                "between '"+ yearstart +"' and '" + yearend +"'";
        String yearCountsql = "select count(1) from tbtsk_task_biz where f_unifylevel in ('2') and f_createtime between '"+ yearstart +"' and '" + yearend +"'";
        Integer ingCount = jdbcTemplate.queryForObject(yearCitysql, Integer.class);
        Integer oldCount = jdbcTemplate.queryForObject(yearCountsql, Integer.class);
        levelObkect.put("ingCount",ingCount);
        //levelObkect.put("oldCount",(levelObkect.getInteger("cityCount")+levelObkect.getInteger("countyCount"))-ingCount);
        levelObkect.put("oldCount",oldCount);
        resultMap.put("levelObkect",levelObkect);
        //今年新增按照区县统计
        String Asql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Bsql = " ,B as (select SUBSTR(f_unifycode,1,6) as xzqdm,count(1) from tbtsk_task_biz where f_unifylevel in ('3')  and f_createtime between '"+ yearstart +"' and '" +yearend +"'";
        String newSql = Asql+Bsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List<Map<String, Object>> regionNewmaps = jdbcTemplate.queryForList(newSql);
        List<Map<String, Object>>  newAllMap = removeRepeatMapByKey(regionNewmaps,"f_xzqdm");

        List<Map<String, Object>> newAlllist = newAllMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Long.compare((Long) e1.get("count"), (Long) e2.get("count"));
        }).collect(Collectors.toList());
        resultMap.put("newAlllist",newAlllist);
        //按政区统计所有区县数据
        String Csql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Dsql = " ,B as (select SUBSTR(f_unifycode,1,6) as xzqdm,count(1) from tbtsk_task_biz where " +
                "f_unifylevel in ('3')  ";
        String sql = Csql+Dsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List<Map<String, Object>> regionmaps = jdbcTemplate.queryForList(sql);
        List<Map<String, Object>>  regionAllMap = removeRepeatMapByKey(regionmaps,"f_xzqdm");
        List<Map<String, Object>> regionAlllist = regionAllMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Long.compare((Long) e1.get("count"), (Long) e2.get("count"));
        }).collect(Collectors.toList());
        resultMap.put("regionAlllist",regionAlllist);
        return resultMap;
    }


    public Map<String, Object> getOverviewCghz(Long userId){
        Map<String, Object> resultMap = new HashMap<>();
        //成果汇总数据
        JSONObject allObject = new JSONObject();
        //数据资产 华为云存储量大小
        allObject.put("sjzcCount",3.56);
        //举证图斑：图斑数量
        String jztbsql = " select sum(ttb.f_total)    from tbtsk_task_biz ttb where ttb.f_isdel  is null";
        allObject.put("jztbCount",jdbcTemplate.queryForObject(jztbsql, Long.class));
        //服务支撑：云查询次数
        String fwzcsql = " select count(1) from tb_cloud_query tcq;";
        allObject.put("fwzcCount",jdbcTemplate.queryForObject(fwzcsql, Long.class));
        //举证照片：照片数量
        String jzzpsql = " select count(1) from tb_app_media tam;";
        allObject.put("jzzpCount",jdbcTemplate.queryForObject(jzzpsql, Long.class));
        resultMap.put("allObject",allObject);

        Calendar cal = Calendar.getInstance();
        //按年开始和结束时间 今年新增数据
        int year = cal.get(Calendar.YEAR);
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        JSONObject yearObject = new JSONObject();
        yearObject.put("shzcYearCount",3.56);
        //举证照片：照片数量
        String jzzpYearsql = "select count(1) from tb_app_media where f_xzqdm  is not null and f_time between '"+  converTime(yearstart) +"' and '" + converTime(yearend) +"'";
        Long jzzpYearCount = jdbcTemplate.queryForObject(jzzpYearsql, Long.class);
        yearObject.put("jzzpYearCount",jzzpYearCount);
        //举证图斑：图斑数量
        String jztbYearsql = "select sum(ttb.f_total)  from tbtsk_task_biz ttb where ttb.f_isdel  is null and ttb.f_createtime between '"+ yearstart +"' and '" + yearend +"'";
        Long jztbYearCount = jdbcTemplate.queryForObject(jztbYearsql, Long.class);
        yearObject.put("jztbYearCount",jztbYearCount);
        //服务支撑：云查询次数
        String fwzcYearsql = "select count(1) from tb_cloud_query where f_querytime between '"+yearstart +"' and '" + yearend +"'";
        Long fwzcYearCount = jdbcTemplate.queryForObject(fwzcYearsql, Long.class);
        yearObject.put("fwzcYearCount",fwzcYearCount);
        resultMap.put("yearObject",yearObject);

        //按政区统计所有区县附件数据
        JSONObject regionObject = new JSONObject();
        String Csql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Dsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from tb_app_media where f_xzqdm is not null  ";
        String sql = Csql+Dsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count from A left join B on (A.f_xzqdm = B.xzqdm)";
        List<Map<String, Object>> regionmaps = jdbcTemplate.queryForList(sql);
        List<Map<String, Object>>  regionAllMap = removeRepeatMapByKey(regionmaps,"f_xzqdm");
        List<Map<String, Object>> regionAlllist = regionAllMap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Long .compare((Long ) e1.get("count"), (Long ) e2.get("count"));
        }).collect(Collectors.toList());
        //按政区统计所有区县云查询数据
        String Esql = " with A as  (select f_xzqdm ,f_xzqmc  from tb_region tr where f_pcode in ('500200','500100'))";
        String Fsql = " ,B as (select SUBSTR(f_xzqdm,1,6) as xzqdm,count(1) from tb_cloud_query where f_xzqdm is not null  ";
        String sql1 = Esql+Fsql+" group by xzqdm) select A.*,case when count is null then 0 else count end  as count " +
                "from A left join B on (A.f_xzqdm = B.xzqdm)";
        List<Map<String, Object>> regionmaps1 = jdbcTemplate.queryForList(sql1);
        List<Map<String, Object>>  regionAllMap1 = removeRepeatMapByKey(regionmaps1,"f_xzqdm");
        List<Map<String, Object>> regionAlllist1 = regionAllMap1.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Long .compare((Long ) e1.get("count"), (Long ) e2.get("count"));
        }).collect(Collectors.toList());
        regionObject.put("jzzpRegionCount",regionAlllist);
        regionObject.put("queryRegionCount",regionAlllist1);
        resultMap.put("regionObject",regionObject);
        return resultMap;
    }

    public Map<String, Object> getOverviewXskdyy(Long userId){
        Map<String, Object> resultMap = new HashMap<>();
        //常规监测(425)、综合监测(425、424)、耕地监测(424、398)
        //耕地监测  耕地流出监测\耕地流入监测
        //2020年
        JSONObject object_2020 = handlyXskdyy("2020");
        resultMap.put("2020",object_2020);
        //2021
        JSONObject object_2021 = handlyXskdyy("2021");
        resultMap.put("2021",object_2021);
        //2022
        JSONObject object_2022 = handlyXskdyy("2022");
        resultMap.put("2022",object_2022);
        //2023
        JSONObject object_20203 = handlyXskdyy("2023");
        resultMap.put("2023",object_20203);
        //2024
        JSONObject object_20204 = handlyXskdyy("2024");
        resultMap.put("2024",object_20204);
        return resultMap;
    }

    public JSONObject  handlyXskdyy(String year){
        JSONObject object = new JSONObject();
        //耕地监测  耕地流出监测\耕地流入监测
        //2020年
        List<Long> gejcclassIds = new ArrayList<>();
        gejcclassIds.add(424L);
        gejcclassIds.add(398l);
        object.put("gdjc",xskdyyCount(gejcclassIds,year));
        //常规监测  耕地流出监测\耕地流入监测
        List<Long> cgjcclassIds = new ArrayList<>();
        cgjcclassIds.add(425L);
        object.put("cgjc",xskdyyCount(cgjcclassIds,year));
        //综合监测  耕地流出监测\耕地流入监测
        List<Long> zhjgclassIds = new ArrayList<>();
        zhjgclassIds.add(425L);
        zhjgclassIds.add(424L);
        object.put("zhjc",xskdyyCount(zhjgclassIds,year));
        //变更调查
        String bgdcNum = "select case when sum(f_tbnum) is null then 0 else sum(f_tbnum) end  as count  from tb_business_statistics_bgdc where f_year ='"+year+"'";
        object.put("bgdc",jdbcTemplate.queryForObject(bgdcNum, Long.class));
        return object;
    }

    public Long xskdyyCount(List<Long> classIds,String year){
        Long TbCount =0L;
        String yearstart = year +"-01-01 00:00:00";
        String yearend =  year +"-12-31 23:59:59";
        List<Long> allclassIds = new ArrayList<>();
        //耕地监测  耕地流出监测\耕地流入监测
        for(Long classId : classIds){
            allclassIds.add(classId);
            mTbtskTaskClassService.queryClassIdByParentId(classId,allclassIds);
        }
        String taskSql = "select ttb.f_id ,to2.f_tablename  from tbtsk_task_biz ttb  inner join " +
                "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        for(Map<String, Object> map2 :taskMap){
            if(map2.get("f_tablename") != null ) {
                String f_tablename = map2.get("f_tablename").toString();
                if(StringUtils.isNotBlank(f_tablename)){
                    //获取总数
                    String totalNum = "select count(1) from "+f_tablename+" where f_createtime between '"+ converTime(yearstart) +"' and '" + converTime(yearend) +"'";
                    TbCount+=jdbcTemplate.queryForObject(totalNum, Long.class);
                }
            }
        }
        return TbCount;
    }
}
