package com.geoway.landteam.landcloud.service.pub;

import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.enm.EnumWlyqSendStateType;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.thread.TaskSendMsgNewThread;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBiz;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.hb.sms4j.sdk.Sms4jService;
import com.geoway.landteam.hb.sms4j.sdk.Sms4jService;
import com.geoway.landteam.landcloud.core.model.base.entity.*;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.constants.PhoneMessageType;
import com.geoway.landteam.landcloud.model.pub.dto.ClueDubanDto;
import com.geoway.landteam.landcloud.model.pub.entity.TbsysConfigMessageDetail;
import com.geoway.landteam.landcloud.model.pub.entity.TbsysUserSubjectRel;
import com.geoway.landteam.landcloud.repository.pub.TbsysConfigMessageDetailRepository;
import com.geoway.landteam.landcloud.repository.pub.TbsysUserSubjectRelRepository;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskManageService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueDubanDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcCluePushRelDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueTaskRelDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.*;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueTaskRelService;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;
import com.gw.base.data.GwValidateException;
import com.gw.base.data.result.GiResult;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Service
public class CluePushService {

    GiLoger loger = GwLoger.getLoger(this.getClass());
    @Value("${clue.wlyq.id}")
    protected String clueId;

    @Value("${clue.wlyq.fjoid}")
    protected String fjOid;

    @Value("${clue.wlyq.limittime}")
    protected String limitTime;

    @Value("${clue.wlyq.tasklimittime}")
    protected String taskLimitTime;

    @Value("${class.wlyq.id}")
    protected Long classId;

    @Value("${third.url.wlyq}")
    protected String wlyqUrl;

    @Value("${third.url.hcfj}")
    protected String hcfjUrl;

    @Value("${project.downloadDir}")
    protected String downloadDir;
    @Autowired
    MJcClueFieldsService jcClueFieldsService;

    @Autowired
    DataBizService dataBizService;

    @Autowired
    MJcClueSourceService jcClueSourceService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    RegionService regionService;

    @Autowired
    AppMediaService appMediaService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    ClueService clueService;

    @Resource
    JcCluePushRelDao cluePushRelDao;

    @Resource
    JcClueDubanDao jcClueDubanDao;

    @Resource
    JcClueTaskRelDao jcClueTaskRelDao;

    @Autowired
    MTaskManageService mTaskManageService;

    @Resource
    TbsysUserSubjectRelRepository tbsysUserSubjectRelRepository;

    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    OauthUserService oauthUserService;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    Sms4jService sms4jService;
    @Autowired
    TbsysConfigMessageDetailRepository tbsysConfigMessageDetailRepository;



    public List<TskTaskBiz> getWlyqTask() {

        String sql = String.format("WITH RECURSIVE sub AS (\n" +
                "    SELECT f_id, f_parentid,f_level\n" +
                "    FROM tbtsk_task_class\n" +
                "    WHERE f_id = '%s' -- 替换为你要查询的子级ID\n" +
                "    UNION ALL\n" +
                "    SELECT n.f_id, n.f_parentid,n.f_level\n" +
                "    FROM tbtsk_task_class n\n" +
                "    INNER JOIN sub p ON n.f_id = p.f_parentid\n" +
                ")\n" +
                "SELECT f_id, f_parentid,f_level\n" +
                "FROM sub order by f_level desc", classId);
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
        List<Long> classIds = new ArrayList<>();
        for (Map map : maps) {
            classIds.add(Long.parseLong(map.get("f_id").toString()));
        }
        return tskTaskBizService.getTskTaskBizByClassIds(classIds);
    }

    @Transactional
    public void pushWlyq(JSONObject param) {

        if (param.get("midUserId") == null || StringUtils.isBlank(param.getString("midUserId"))) {
            throw new IllegalArgumentException("未设置用户id");
        }
        String midUserId = param.getString("midUserId");
        List<TbsysUserSubjectRel> subjectRels = tbsysUserSubjectRelRepository.findByMidUserId(midUserId);
        if (subjectRels == null || subjectRels.isEmpty()) {
            throw new IllegalArgumentException("当前用户不是业务系统用户");
        }
        if (param.get("taskId") == null || StringUtils.isBlank(param.getString("taskId"))) {
            throw new IllegalArgumentException("未设置违法类型");
        }
        TskTaskBiz task = tskTaskBizService.findByTaskId(param.getString("taskId"));
        if (task == null) {
            throw new IllegalArgumentException("违法类型核查任务不存在");
        }
        JSONArray jsonArray = param.getJSONArray("clues");
        if (jsonArray == null || jsonArray.isEmpty()) {
            throw new IllegalArgumentException("待推送数据为空");
        }
        List<Map<String, Object>> maps = new ArrayList<>();
        JcClueSource clueSource = jcClueSourceService.findOne(clueId);
        List<JcClueFields> allFields = jcClueFieldsService.findByTableId(clueId);
        List<JcClueFields> innerFields = allFields.stream().filter(t -> t.getfFieldInnerOuterSys() != null && (t.getfFieldInnerOuterSys() & 1) == 1).collect(Collectors.toList());
        //List<JcClueFields> btFields =  allFields.stream().filter(t->t.getfNullable()!=null&&t.getfNullable().equals(0)).collect(Collectors.toList());
        List<TbtskFields> taskFields = tskTaskBizService.getFieldsByTableId(task.getTableId());
        Map<String, String> mapFields = new HashMap<>();
        for (JcClueFields f : innerFields) {
            //通过字段别名实现线索和任务字段的映射
            TbtskFields tarField = taskFields.stream().filter(t -> t.getfAlias().equalsIgnoreCase(f.getfAlias())).findFirst().orElse(null);
            if (tarField == null) {
                throw new IllegalArgumentException("字段：" + f.getfAlias() + "[" + f.getfFieldname() + "]" + "不匹配");
            }
            mapFields.put(f.getfFieldname(), tarField.getfFieldname());


        }

        List<String> cludIds = new ArrayList<>();
        Map<String, String> mapId = new HashMap<>();
        String importId = UUID.randomUUID().toString();
        List<JcCluePushRel> pushRels = new ArrayList<>();
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject json = jsonArray.getJSONObject(i);
            if (json.get("primaryKey") == null || StringUtils.isBlank(json.getString("primaryKey"))) {
                throw new IllegalArgumentException("推送数据主键为空");
            }
            if (json.get("regionCode") == null || StringUtils.isBlank(json.getString("regionCode"))) {
                throw new IllegalArgumentException("推送数据政区信息为空");
            }
            String oid = json.containsKey(fjOid) ? json.getString(fjOid) : "";

            String pk = json.getString("primaryKey");
            JcCluePushRel seo = new JcCluePushRel();
            seo.setRelId(pk);
            List<JcCluePushRel> pushRels1 = cluePushRelDao.gwSearch(seo);
            if (pushRels1 != null && !pushRels1.isEmpty()) {
                throw new IllegalArgumentException(pk + "已存在");
            }
            String regionCode = json.getString("regionCode");
            String villageCode = null;
            String townCode = null;
            String countyCode = null;
            String cityCode = null;

            if (regionCode.length() == 6) {
                villageCode = regionCode + "000000";
                townCode = regionCode + "000";
                countyCode = regionCode;
                cityCode = regionCode.substring(0, 4) + "00";
            } else if (regionCode.length() == 9) {
                villageCode = regionCode + "000";
                townCode = regionCode;
                countyCode = regionCode.substring(0, 6);
                cityCode = regionCode.substring(0, 4) + "00";
            } else if (regionCode.length() == 12) {
                villageCode = regionCode;
                townCode = regionCode.substring(0, 9);
                countyCode = regionCode.substring(0, 6);
                cityCode = regionCode.substring(0, 4) + "00";
            }
            Map<String, Object> map = new HashMap<>();
            for (JcClueFields f : innerFields) {
                //内网
                if (f.getfNullable() != null && f.getfNullable().equals(0)) {
                    if (!json.containsKey(f.getfFieldname()) || json.get(f.getfFieldname()) == null || StringUtils.isBlank(json.getString(f.getfFieldname()))) {
                        throw new IllegalArgumentException(f.getfAlias() + "为空");
                    }

                }
                Object v = json.get(f.getfFieldname());
                if(v==null||StringUtils.isBlank(v.toString()))
                {
                    continue;
                }
                map.put(f.getfFieldname(), v);
            }
            List<String> fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());


            map.put("f_xzqdm", countyCode);
            if (StringUtils.isNotBlank(countyCode)) {
                Region region = regionService.findRegionByCode(countyCode);
                if (region != null) {
                    map.put("f_xzqmc", region.getName());
                }
            }


            map.put("f_xzqdmcity", cityCode);
            map.put("f_xzqdmcounty", countyCode);
            map.put("f_xzqdmtown", townCode);
            map.put("f_xzqdmvillage", villageCode);


            //map.put("f_location", map1.get("location"));
            //map.put("f_area", map1.get("area"));
            String id = UUID.randomUUID().toString();
            map.put("f_id", id);
            map.put("f_status", '0');
            map.put("f_state", '0');
            map.put("f_stage", '1');
            map.put("f_analysis", '0');
            if (fields.contains("f_registerstatus")) {
                map.put("f_registerstatus", '0');
                map.put("f_mergestatus", '0');
            }
            map.put("f_userid", "520031475");
            map.put("f_sourceid", clueId);
            map.put("f_import_recordid", importId);
            map.put("f_createtime", System.currentTimeMillis() / 1000);
            maps.add(map);
            cludIds.add(map.get("f_id").toString());
            mapId.put(pk, id);
            /*
            Integer sendSms = 1;
            if (json.containsKey(limitTime) && StringUtils.isNotBlank(json.getString(limitTime))) {
                sendSms = 0;
            }
            */
            JcCluePushRel pushRel = new JcCluePushRel();
            pushRel.setId(id);
            pushRel.setClueId(id);
            pushRel.setSourceId(clueId);
            pushRel.setRelId(pk);
            pushRel.setTaskId(task.getId());
            //pushRel.setSendSms(0);
            pushRels.add(pushRel);

            if (StringUtils.isNotBlank(oid)) {
                List<Map<String, Object>> tempHcfjs = jdbcTemplate.queryForList("select filepath,f_url from tb_temp_hcfj where id='" + oid + "'");
                if (tempHcfjs != null && !tempHcfjs.isEmpty()) {
                    for (Map temp : tempHcfjs) {
                        String fjurl = temp.get("f_url") != null ? temp.get("f_url").toString() : "";
                        if(StringUtils.isBlank(fjurl)) {
                            String path = temp.get("filepath") != null ? temp.get("filepath").toString() : "";
                            if (StringUtils.isNotBlank(path)) {
                                try {
                                    String url = hcfjUrl;
                                    if (path.startsWith("/")) {
                                        url += path;
                                    } else {
                                        url += "/" + path;
                                    }
                                    if (url.contains("?")) {
                                        url = StringUtils.split(url, "?")[0];
                                    }
                                    String fjName = url.substring(url.lastIndexOf("/") + 1);
                                    File fjFile = new File(downloadDir, fjName);
                                    FileUtils.copyURLToFile(new URL(url), fjFile);
                                    if (fjFile.exists()) {
                                        String ossPath = "clueProof/hcfj/" + oid + "/" + fjName;
                                        fjurl = defaultOssOperatorService.sendObject2Oss(ossPath, fjFile);

                                        try {
                                            fjFile.delete();
                                        }
                                        catch (Exception ex)
                                        {}

                                    }
                                } catch (Exception ex) {
                                    loger.error("网络舆情线索下载核查附件异常" + ExceptionUtil.getErrorString(ex));
                                }
                            }
                        }
                        if(StringUtils.isNotBlank(fjurl))
                        {
                            String fjName = fjurl.substring(fjurl.lastIndexOf("/") + 1);
                            AppMedia appMedia = new AppMedia();
                            appMedia.setServerpath(fjurl);
                            appMedia.setType(getMediaType(fjName));
                            appMedia.setId(UUID.randomUUID().toString());
                            appMedia.setGalleryid(id);
                            //1证据材料
                            appMedia.setTypetype(1);
                            appMedia.setGroupCode(1);
                            appMedia.setDeviceSource(2);
                            appMedia.setTime(String.valueOf(System.currentTimeMillis()));
                            appMediaService.saveOne(appMedia);
                        }
                    }

                }
            }
        }

        JSONArray mediaArray = param.getJSONArray("medias");
        if (mediaArray != null && !mediaArray.isEmpty()) {
            for (int i = 0; i < mediaArray.size(); i++) {
                try {
                    JSONObject obj = mediaArray.getJSONObject(i);

                    String url = obj.getString("url");
                    String id = obj.getString("primaryKey");
                    if (StringUtils.isBlank(url) || StringUtils.isBlank(id)) {
                        continue;
                    }
                    url = StringUtils.split(url, "?")[0];
                    String fjName = url.substring(url.lastIndexOf("/")+1);
                    AppMedia appMedia = new AppMedia();
                    appMedia.setServerpath(url);
                    appMedia.setType(getMediaType(fjName));
                    appMedia.setId(UUID.randomUUID().toString());
                    appMedia.setGalleryid(mapId.get(id));
                    //1证据材料
                    appMedia.setTypetype(1);
                    appMedia.setGroupCode(1);
                    appMedia.setDeviceSource(2);
                    appMedia.setTime(String.valueOf(System.currentTimeMillis()));
                    appMediaService.saveOne(appMedia);

                } catch (Exception ex) {
                    loger.error("网络舆情线索下载附件异常" + ExceptionUtil.getErrorString(ex));
                }
            }
        }

        dataBizService.insertDatasBatch(clueSource.getfTablename(), maps, null);
        cluePushRelDao.batchInsert(pushRels);
        String sourceId = clueId;
        String taskId = task.getId();
        String cluesId = StringUtils.join(cludIds, ",");
        String importRel = null;
        JSONArray jsonArrayImportRel = new JSONArray();
        for (JcClueFields f : innerFields) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("oriField", f.getfFieldname());
            jsonObject.put("tarField", mapFields.get(f.getfFieldname()));
            jsonArrayImportRel.add(jsonObject);
        }
        importRel = jsonArrayImportRel.toString();
        clueService.importClueToTaskByDatas(subjectRels.get(0).getUserId(), sourceId, importId, importRel, taskId, cluesId);
        CompletableFuture.runAsync(() -> {
            for (JcCluePushRel push : pushRels) {
                sendState(push.getRelId(), EnumWlyqSendStateType.待领取.getCode());
            }
        });
    }

    public void duban(ClueDubanDto duban) {
        if (duban == null) {
            throw new IllegalArgumentException("督办信息为空");
        }
        if (StringUtils.isBlank(duban.getPrimaryKey())) {
            throw new IllegalArgumentException("督办图斑主键为空");
        }
        if (StringUtils.isBlank(duban.getDubanType())) {
            throw new IllegalArgumentException("督办类型为空");
        }
        if (StringUtils.isBlank(duban.getDubanYj())) {
            throw new IllegalArgumentException("督办意见为空");
        }
        if (StringUtils.isBlank(duban.getCreator())) {
            throw new IllegalArgumentException("督办人员为空");
        }
        JcCluePushRel seo = new JcCluePushRel();
        seo.setRelId(duban.getPrimaryKey());
        List<JcCluePushRel> pushRels = cluePushRelDao.gwSearch(seo);
        if (pushRels == null || pushRels.isEmpty()) {
            throw new IllegalArgumentException("待督办数据不存在");
        }
        EpaUserReso midUser = oauthUserService.getMidtUser(duban.getCreatorId());
        JcCluePushRel pushRel = pushRels.get(0);
        JcClueDuban jcClueDuban = new JcClueDuban();
        jcClueDuban.setClueId(pushRel.getClueId());
        jcClueDuban.setSourceId(pushRel.getSourceId());
        jcClueDuban.setDuban(duban.getDubanType());
        jcClueDuban.setDubanYj(duban.getDubanYj());
        jcClueDuban.setCreatorId(duban.getCreator());
        jcClueDuban.setCreator(midUser != null ? midUser.getUserName() : null);
        jcClueDuban.setTime(new Date());
        jcClueDuban.setId(UUID.randomUUID().toString());
        jcClueDubanDao.gwAccess(jcClueDuban);

    }

    public void sendSms(TskTaskBiz task) throws Exception {
        List<TbtskObjectinfo>objectinfos = tskTaskBizService.getObjectbyTaskId(task.getId());
        if(objectinfos==null||objectinfos.isEmpty())
        {
            return;
        }
        TbtskObjectinfo objectinfo = objectinfos.get(0);
        String sql = String.format("select f_userid,f_regioncode as f_xzqdm from tbtsk_user_manage_area where f_taskid = '%s'",task.getId());
        List<Map<String,Object>>mapManagers = jdbcTemplate.queryForList(sql);

        sql = String.format("select f_userid,f_xzqdm from tbtsk_right_area where f_taskid = '%s'",task.getId());
        List<Map<String,Object>>mapWorkers = jdbcTemplate.queryForList(sql);

        if((mapManagers==null||mapManagers.isEmpty())||(mapWorkers==null||mapWorkers.isEmpty()))
        {
            return;
        }
        List<TbtskFields>fields = tskTaskBizService.getFieldsByTableId(task.getTableId());
        TbtskFields uniqueField = fields.stream().filter(t->t.getfUnique()!=null&&t.getfUnique().equals(1)).findFirst().orElse(null);
        if(uniqueField==null)
        {
            uniqueField = new TbtskFields();
            uniqueField.setfAlias("图斑id");
            uniqueField.setfFieldname("f_id");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        String where =  String.format("to_date(to_char(%s,'YYYY-MM-DD'),'YYYY-MM-DD') + interval '-3 day' = '%s' and f_status <=1",taskLimitTime,today);

        List<Map<String,Object>> needAssign = jdbcTemplate.queryForList("select "+uniqueField.getfFieldname()+",f_xzqdmsys from "+objectinfo.getfTablename()+" where "+where);
        if(needAssign!=null&&!needAssign.isEmpty())
        {

            Map<String,List<Map<String,Object>>>mapTbs =  needAssign.stream().collect(Collectors.groupingBy(t->t.get("f_xzqdmsys").toString()));
            if(mapManagers!=null&&!mapManagers.isEmpty())
            {
                for(Map map:mapManagers)
                {
                    String xzqdm = map.get("f_xzqdm").toString();
                    Long userId =Long.parseLong(map.get("f_userid").toString());
                    EpaUserReso userReso = oauthUserService.getMidtUser(userId);
                    if(userReso==null||StringUtils.isBlank(userReso.getPhoneNumber()))
                    {
                        continue;
                    }
                    Integer level = getXzqLevel(xzqdm);
                    String msg="";
                    List<String> bhs = new ArrayList<>();
                    if(task.getMode().equals(1)) {
                        switch (level) {
                            case 1:
                                {
                                for (Map m : needAssign) {
                                    String bh = m.get(uniqueField.getfFieldname()).toString();
                                    if (bhs.size()<1) {
                                        bhs.add(bh);
                                    } else  {
                                        bh += "......";
                                        bhs.add(bh);
                                        break;
                                    }
                                }
                                msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未下发,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 2:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,4).equals(xzqdm.substring(0,4)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未下发,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 3:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,6).equals(xzqdm.substring(0,6)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未下发,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 4:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,9).equals(xzqdm.substring(0,9)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未下发,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 5:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,12).equals(xzqdm.substring(0,12)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未下发,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                        }
                    }
                    else
                    {
                        switch (level) {
                            case 1:
                            {
                                for (Map m : needAssign) {
                                    String bh = m.get(uniqueField.getfFieldname()).toString();
                                    if (bhs.size()<1) {
                                        bhs.add(bh);
                                    } else  {
                                        bh += "......";
                                        bhs.add(bh);
                                        break;
                                    }
                                }
                                msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未被领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                            }
                            break;
                            case 2:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,4).equals(xzqdm.substring(0,4)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未被领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 3:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,6).equals(xzqdm.substring(0,6)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未被领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 4:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,9).equals(xzqdm.substring(0,9)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未被领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 5:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,12).equals(xzqdm.substring(0,12)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<1) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未被领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                        }
                    }
                    if(StringUtils.isNotBlank(msg)) {
                        try {
                            TbsysConfigMessageDetail messageDetail = tbsysConfigMessageDetailRepository.findByType(PhoneMessageType.CONTENT);
//                            sms4jService.sendMsg(msg, userReso.getPhoneNumber());
                            sms4jService.sendMsg(msg, userReso.getPhoneNumber(), messageDetail.getTemplateid());
                        } catch (Exception ex) {
                            loger.error("网络舆情任务发送核查期限通知信息异常" + ExceptionUtil.getErrorString(ex));
                        }
                    }

                }
            }
            if(mapWorkers!=null&&mapWorkers.isEmpty())
            {

                for(Map map:mapWorkers)
                {
                    String xzqdm = map.get("f_xzqdm").toString();
                    Long userId =Long.parseLong(map.get("f_userid").toString());
                    EpaUserReso userReso = oauthUserService.getMidtUser(userId);
                    if(userReso==null||StringUtils.isBlank(userReso.getPhoneNumber()))
                    {
                        continue;
                    }
                    Integer level = getXzqLevel(xzqdm);
                    String msg="";
                    List<String> bhs = new ArrayList<>();
                    if(task.getMode().equals(1)) {
                        switch (level) {
                            case 1:
                            {
                                for (Map m : needAssign) {
                                    String bh = m.get(uniqueField.getfFieldname()).toString();
                                    if (bhs.size()<2) {
                                        bhs.add(bh);
                                    } else  {
                                        bh += "......";
                                        bhs.add(bh);
                                        break;
                                    }
                                }
                                msg = "距离核查截止时间只剩3天,有" + needAssign.size() + "个图斑未下发,请联系管理员处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                            }
                            break;
                            case 2:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,4).equals(xzqdm.substring(0,4)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,有" + needAssign.size() + "个图斑未下发,请联系管理员处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 3:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,6).equals(xzqdm.substring(0,6)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,有" + needAssign.size() + "个图斑未下发,请联系管理员处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 4:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,9).equals(xzqdm.substring(0,9)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,有" + needAssign.size() + "个图斑未下发,请联系管理员处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 5:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,12).equals(xzqdm.substring(0,12)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,有" + needAssign.size() + "个图斑未下发,请联系管理员处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                        }
                    }
                    else
                    {
                        switch (level) {
                            case 1:
                            {
                                for (Map m : needAssign) {
                                    String bh = m.get(uniqueField.getfFieldname()).toString();
                                    if (bhs.size()<2) {
                                        bhs.add(bh);
                                    } else  {
                                        bh += "......";
                                        bhs.add(bh);
                                        break;
                                    }
                                }
                                msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                            }
                            break;
                            case 2:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,4).equals(xzqdm.substring(0,4)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 3:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,6).equals(xzqdm.substring(0,6)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 4:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,9).equals(xzqdm.substring(0,9)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                            case 5:
                                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                                {

                                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().substring(0,12).equals(xzqdm.substring(0,12)))
                                    {
                                        for (Map m : kv.getValue()) {

                                            String bh = m.get(uniqueField.getfFieldname()).toString();
                                            if (bhs.size()<2) {
                                                bhs.add(bh);
                                            } else  {
                                                bh += "......";
                                                bhs.add(bh);
                                                break;
                                            }

                                        }

                                    }
                                    if(bhs.size()>=2)
                                    {
                                        break;
                                    }
                                }
                                if(!bhs.isEmpty()) {
                                    msg = "距离核查截止时间只剩3天,您有" + needAssign.size() + "个图斑未领取,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                                }
                                break;
                        }
                    }
                    if(StringUtils.isNotBlank(msg)) {
                        try {
                            TbsysConfigMessageDetail messageDetail = tbsysConfigMessageDetailRepository.findByType(PhoneMessageType.CONTENT);
//                            sms4jService.sendMsg(msg, userReso.getPhoneNumber());
                            sms4jService.sendMsg(msg, userReso.getPhoneNumber(), messageDetail.getTemplateid());
                        } catch (Exception ex) {
                            loger.error("网络舆情任务发送核查期限通知信息异常" + ExceptionUtil.getErrorString(ex));
                        }
                    }
                }
            }
        }

        where =  String.format("to_date(to_char(%s,'YYYY-MM-DD'),'YYYY-MM-DD') + interval '-3 day' = '%s' and f_status >1 and f_status < 10",taskLimitTime,today);

        sql = "with t as (select "+uniqueField.getfFieldname() +",f_id as f_pk from "+objectinfo.getfTablename() +" where "+where+")\n" +
                "select t."+uniqueField.getfFieldname()+", s.f_assignto from t left join (select f_assignto,f_dataid from  tbtsk_assign_record where f_taskid ='"+task.getId()+"') s on t.f_pk = s.f_dataid";
        List<Map<String,Object>>warnTbs = jdbcTemplate.queryForList(sql);
        if(warnTbs==null||warnTbs.isEmpty())
            return;
        if(mapWorkers==null||mapWorkers.isEmpty())
        {
            if(mapManagers!=null&&!mapManagers.isEmpty())
            {
                for(Map map:mapManagers)
                {
                    Long userId =Long.parseLong(map.get("f_userid").toString());
                    EpaUserReso userReso = oauthUserService.getMidtUser(userId);
                    if(userReso==null||StringUtils.isBlank(userReso.getPhoneNumber()))
                    {
                        continue;
                    }
                    try {
                        TbsysConfigMessageDetail configMessageDetail = tbsysConfigMessageDetailRepository.findByType(PhoneMessageType.CONTENT);
                        sms4jService.sendMsg("距离核查截止时间只剩3天,请配置作业员进行作业;任务名称【"+task.getName()+"】", userReso.getPhoneNumber(), configMessageDetail.getTemplateid());
                    }
                    catch (Exception ex)
                    {
                        loger.error("网络舆情任务发送核查期限通知信息异常"+ExceptionUtil.getErrorString(ex));
                    }
                }
            }
        }
        else {
            Map<String,List<Map<String,Object>>>mapTbs =  warnTbs.stream().collect(Collectors.groupingBy(t->t.get("f_assignto").toString()));
            for(Map map:mapWorkers)
            {
                Long userId =Long.parseLong(map.get("f_userid").toString());
                EpaUserReso userReso = oauthUserService.getMidtUser(userId);
                if(userReso==null||StringUtils.isBlank(userReso.getPhoneNumber()))
                {
                    continue;
                }
                String msg="";
                List<String> bhs = new ArrayList<>();
                for(Map.Entry<String,List<Map<String,Object>>>kv:mapTbs.entrySet())
                {
                    if(StringUtils.isNotBlank(kv.getKey())&&kv.getKey().equals(userId.toString()))
                    {
                        for (Map m : kv.getValue()) {

                            String bh = m.get(uniqueField.getfFieldname()).toString();
                            if (bhs.size()<2) {
                                bhs.add(bh);
                            } else  {
                                bh += "......";
                                bhs.add(bh);
                                break;
                            }

                        }

                    }
                    if(bhs.size()>=2)
                    {
                        break;
                    }
                }
                if(!bhs.isEmpty()) {
                    msg = "距离核查截止时间只剩3天,有" + needAssign.size() + "个图斑提报,请及时处理;任务名称【" + task.getName() + "】;" + uniqueField.getfAlias() + "如下：" + StringUtils.join(bhs, "、");
                }
                if(StringUtils.isNotBlank(msg)) {
                    try {
                        TbsysConfigMessageDetail configMessageDetail = tbsysConfigMessageDetailRepository.findByType(PhoneMessageType.CONTENT);
//                        sms4jService.sendMsg(msg, userReso.getPhoneNumber());
                        sms4jService.sendMsg(msg, userReso.getPhoneNumber(), configMessageDetail.getTemplateid());
                    } catch (Exception ex) {
                        loger.error("网络舆情任务发送核查期限通知信息异常" + ExceptionUtil.getErrorString(ex));
                    }
                }
            }
        }


    }

    public Map<String,List<JcClueDuban>>getDuban(String taskId,List<String>tbids)
    {
        List<TskTaskBiz> tasks = getWlyqTask();
        if(tasks==null||tasks.isEmpty())
            return null;
        if(!tasks.stream().filter(t->t.getId().equals(taskId)).findFirst().isPresent())
        {
            return null;
        }
        String sql=String.format("with t1 as (select f_clueid,f_sourceid,f_tbid from jc_clue_task_rel where f_taskid = '%s' and f_tbid in ('%s')) select a.*,t1.f_tbid from t1 inner join jc_clue_duban a on t1.f_clueid = a.f_clue_id and t1.f_sourceid = a.f_source_id order by f_time desc",taskId,StringUtils.join(tbids,"','"));
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
            return null;
        Map<String,List<Map<String,Object>>>mapTb = maps.stream().collect(Collectors.groupingBy(t->t.get("f_tbid").toString()));
        Map<String,List<JcClueDuban>>mapDbs = new HashMap<>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        for(Map.Entry<String,List<Map<String,Object>>>kv:mapTb.entrySet())
        {
            List<JcClueDuban> dubans = new ArrayList<>();
            for(Map map:kv.getValue())
            {
                String id = map.get("f_id")!=null?map.get("f_id").toString():"";
                String clueId = map.get("f_clue_id")!=null?map.get("f_clue_id").toString():"";
                String sourceId = map.get("f_source_id")!=null?map.get("f_source_id").toString():"";
                String db = map.get("f_duban")!=null?map.get("f_duban").toString():"";
                String dbyj = map.get("f_duban_yj")!=null?map.get("f_duban_yj").toString():"";
                String creator = map.get("f_creator")!=null?map.get("f_creator").toString():"";
                String time = map.get("f_time")!=null?map.get("f_time").toString():"";
                JcClueDuban duban = new JcClueDuban();
                duban.setId(id);
                duban.setClueId(clueId);
                duban.setSourceId(sourceId);
                duban.setDubanYj(dbyj);
                duban.setDuban(db);
                duban.setCreator(creator);
                try {
                    duban.setTime(df.parse(time));
                }
                catch (Exception ex)
                {}
                dubans.add(duban);

            }
            mapDbs.put(kv.getKey(),dubans);
        }
        return mapDbs;
    }
    public void pushWlyqState(String taskId, List<String>tbids, EnumWlyqSendStateType state)
    {
        CompletableFuture.runAsync(()->{
            try {
                List<TskTaskBiz> tasks = getWlyqTask();
                if (tasks == null || tasks.isEmpty())
                    return;
                if (!tasks.stream().filter(t -> t.getId().equals(taskId)).findFirst().isPresent()) {
                    return;
                }
                String sql = String.format("select f_rel_id from jc_clue_push_rel where f_clue_id in (select f_clueid from jc_clue_task_rel where f_taskid = '%s' and f_tbid in ('%s'))", taskId, StringUtils.join(tbids, "','"));
                List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                if (maps == null || maps.isEmpty())
                    return;
                for (Map map : maps) {
                    String id = map.get("f_rel_id") != null ? map.get("f_rel_id").toString() : "";
                    sendState(id, state.getCode());
                }
            }
            catch (Exception ex)
            {
                loger.error("推送网络舆情线索状态异常\n"+ ExceptionUtil.getErrorString(ex));
            }
        });

    }
    public void cancle(String primaryKey,String midUserId) throws Exception {
        if(StringUtils.isBlank(primaryKey))
        {
            throw new IllegalArgumentException("未设置撤销数据");
        }
        if(StringUtils.isBlank(midUserId))
        {
            throw new IllegalArgumentException("未设置撤销用户");
        }
        List<TbsysUserSubjectRel> subjectRels = tbsysUserSubjectRelRepository.findByMidUserId(midUserId);
        if(subjectRels==null||subjectRels.isEmpty())
        {
            throw new IllegalArgumentException("当前用户不是业务系统用户");
        }
        JcCluePushRel seo = new JcCluePushRel();
        seo.setRelId(primaryKey);
        List<JcCluePushRel>pushRels = cluePushRelDao.gwSearch(seo);
        if(pushRels==null||pushRels.isEmpty())
        {
            throw new IllegalArgumentException("数据不存在");
        }
        JcCluePushRel pushRel = pushRels.get(0);
        JcClueTaskRel seo2 = new JcClueTaskRel();
        seo2.setfSourceid(pushRel.getSourceId());
        seo2.setfTaskid(pushRel.getTaskId());
        seo2.setfClueid(pushRel.getClueId());
        List<JcClueTaskRel>taskRels =  jcClueTaskRelDao.gwSearch(seo2);
        if(taskRels==null||taskRels.isEmpty())
        {
            throw new IllegalArgumentException("任务关联记录不存在");
        }

        JcClueTaskRel taskRel = taskRels.get(0);
        TskTaskBiz byTaskId = tskTaskBizService.findByTaskId(taskRel.getfTaskid());
        if(byTaskId==null){
            throw new GwValidateException("未找到任务");
        }
        TbtskObjectinfo objectbyID = tbtskObjectinfoService.getObjectbyID(byTaskId.getTableId());
        if(objectbyID==null){
            throw new GwValidateException("未找到任务");
        }

        Map map = dataBizService.selectFieldByID(objectbyID.getfTablename(), Arrays.asList("f_status"), "f_id", "'" + taskRel.getfTbid() + "'");
        if(map == null){
            throw new GwValidateException("未找到图斑数据");
        }
        if(map.get("f_status")!=null && Integer.valueOf(map.get("f_status").toString())>=10){
            throw new GwValidateException("已提报不能撤销");
        }
        JcClueSource clueSource = jcClueSourceService.findOne(pushRel.getSourceId());
        mTaskManageService.deleteTb(taskRel.getfTbid(),taskRel.getfTaskid(),subjectRels.get(0).getUserId());
        cluePushRelDao.gwDeleteByPK(pushRel.getId());
        dataBizService.delete(clueSource.getfTablename(),"f_id", pushRel.getClueId());
        JcClueTaskRel clueTaskRel = new JcClueTaskRel();
        clueTaskRel.setfClueid(pushRel.getClueId());
        clueTaskRel.setfSourceid(pushRel.getSourceId());
        clueTaskRel.setfTaskid(pushRel.getTaskId());
        jcClueTaskRelDao.gwDeleteBy(clueTaskRel);
    }
    public Integer getMediaType(String fileName){
        Integer result = null;
        fileName = fileName.toLowerCase();
        //1-jpg/png 2-mp4 3-mp3 4-osgb 5-pdf 6-txt 7-word 8-excel 9-ppt
        if(fileName.endsWith(".jpg") || fileName.endsWith(".png")){
            result = 1;
        }else if(fileName.endsWith(".mp4")){
            result = 2;
        }else if(fileName.endsWith(".mp3")){
            result = 3;
        }else if(fileName.endsWith(".osgb")){
            result = 4;
        }else if(fileName.endsWith(".pdf")){
            result = 5;
        }else if(fileName.endsWith(".txt")){
            result = 6;
        }else if(fileName.endsWith(".docx") || fileName.endsWith(".doc") ){
            result = 7;
        }else if(fileName.endsWith(".xls") || fileName.endsWith(".xlsx")){
            result = 8;
        }else if(fileName.endsWith(".ppt")){
            result = 9;
        }
        return result;
    }

    public void sendState(String jgno,Integer state)
    {
        String url = wlyqUrl+"/wlyq-server/pushTaskState?jgno="+jgno+"&state="+state;
        HttpResponse response= cn.hutool.http.HttpUtil.createGet(url).execute();
        if(!response.isOk())
        {
            loger.error("网络舆情线索 监管编号:"+jgno+"推送状态:"+state+"失败\n"+response.body());
        }
        else
        {
            try {
                JSONObject jsonObject = JSONObject.parseObject(response.body());
                if (!jsonObject.get("code").toString().equals("200")) {
                    loger.error("网络舆情线索 监管编号:" +jgno + "推送状态:"+state+"失败," + jsonObject.getString("msg"));
                }
                else
                {
                    loger.info("网络舆情线索 监管编号:" +jgno + "推送状态:"+state+"成功," + jsonObject.getString("msg"));
                }
            }
            catch (Exception ex)
            {
                loger.error("网络舆情线索 监管编号:"+jgno+"推送状态:"+state+"失败\n"+response.body());
            }
        }
    }

    public void batchHandleFj()
    {
        List<Map<String, Object>> tempHcfjs = jdbcTemplate.queryForList("select * from tb_temp_hcfj where f_url is null");
        if (tempHcfjs != null && !tempHcfjs.isEmpty()) {
            for (Map temp : tempHcfjs) {
                String path = temp.get("filepath") != null ? temp.get("filepath").toString() : "";
                if (StringUtils.isNotBlank(path)) {
                    try {
                        String url = hcfjUrl;
                        if (path.startsWith("/")) {
                            url += path;
                        } else {
                            url += "/" + path;
                        }
                        if (url.contains("?")) {
                            url = StringUtils.split(url, "?")[0];
                        }
                        String fjName = url.substring(url.lastIndexOf("/")+1);

                        File fjFile = new File(downloadDir, fjName);
                        FileUtils.copyURLToFile(new URL(url), fjFile);
                        if (fjFile.exists()) {
                            String id = temp.get("id").toString();
                            String pk = temp.get("pk").toString();
                            String ossPath = "clueProof/hcfj/" + id + "/" + fjName;
                            String fjurl = defaultOssOperatorService.sendObject2Oss( ossPath,fjFile);
                            jdbcTemplate.execute("update tb_temp_hcfj set f_url ='"+fjurl+"' where pk ='"+pk+"'");
                            try {
                                fjFile.delete();
                            }
                            catch (Exception ex)
                            {}
                        }
                    } catch (Exception ex) {
                        loger.error("网络舆情线索下载核查附件异常" + ExceptionUtil.getErrorString(ex));
                    }
                }

            }

        }
    }

    private Integer getXzqLevel(String xzqdm)
    {
        if(StringUtils.isBlank(xzqdm))
            return null;
        while (xzqdm.endsWith("0"))
        {
            if(xzqdm.length()==1)
            {
                return null;
            }
            xzqdm = xzqdm.substring(0,xzqdm.length()-1);
        }
        if(xzqdm.length()<=2)
        {
            return 1;
        }
        else if(xzqdm.length()<=4)
        {
            return 2;
        }
        else if(xzqdm.length()<=6)
        {
            return 3;
        }
        else if(xzqdm.length()<=9)
        {
            return 4;
        }
        return 5;
    }


}
